#!/usr/bin/perl -w
# $Id$
use strict;
use ExtUtils::MakeMaker;

my $prereq_pm = {
        'MPMinus'               => 1.13,
    };

WriteMakefile(
    'NAME'                  => 'MPM::<!-- cgi: ProjectName -->',
    'MIN_PERL_VERSION'      => 5.008001,
    'VERSION_FROM'          => CTK::catfile(qw/lib MPM <!-- cgi: ProjectName -->.pm/),
    'ABSTRACT_FROM'         => CTK::catfile(qw/lib MPM <!-- cgi: ProjectName -->.pm/),
    'PREREQ_PM'             => $prereq_pm,
    'AUTHOR'                => '<!-- cgi: Author --> <<!-- cgi: ServerAdmin -->>',
    'LICENSE'               => '<!-- cgi: License -->',
    'META_MERGE' => { "meta-spec" => { version => 2 },
        mpminus => {
            GMT             => '<!-- cgi: GMT -->',
            ProjectName	    => '<!-- cgi: ProjectName -->',
            ProjectNameL    => '<!-- cgi: ProjectNameL -->',
            ProjectVersion  => '<!-- cgi: ProjectVersion -->',
            DefaultCharset  => '<!-- cgi: DefaultCharset -->',
            ContentType     => '<!-- cgi: ContentType -->',
            Author          => '<!-- cgi: Author -->',
            License         => '<!-- cgi: License -->',
        },
    },
);

1;

package MY;
use CTK;

sub postamble {
my $section = <<'MAKE_FRAG';

MPMPROJECTNAME = <!-- cgi: ProjectName -->
MPMPROJECTNAMEL = <!-- cgi: ProjectNameL -->
PERM_DIR_X = 777

pure_all :: $(MPMPROJECTNAMEL).conf
	$(NOECHO) $(NOOP)

$(MPMPROJECTNAMEL).conf : src$(DFSEP)$(MPMPROJECTNAME).conf log$(DFSEP).exists cache$(DFSEP).exists META.yml
	$(NOECHO) $(ECHO) "Configuration..."
	$(CP) src$(DFSEP)$(MPMPROJECTNAME).conf $(MPMPROJECTNAMEL).conf
[INCLUDEBUILD]
	$(NOECHO) $(ECHO) "Done."

log$(DFSEP).exists :: Makefile.PL
	$(NOECHO) $(MKPATH) log
	$(NOECHO) $(CHMOD) $(PERM_DIR_X) log
	$(NOECHO) $(TOUCH) log$(DFSEP).exists

cache$(DFSEP).exists :: Makefile.PL
	$(NOECHO) $(MKPATH) cache
	$(NOECHO) $(CHMOD) $(PERM_DIR_X) cache
	$(NOECHO) $(TOUCH) cache$(DFSEP).exists

META.yml : MYMETA.yml
	-$(CP) MYMETA.yml META.yml

clean :: Makefile.PL
	-$(RM_F) $(MAKEFILE_OLD)

MAKE_FRAG

my $c = new CTK;
my $includebuild = '';
#if ($c->isostype('Unix')) {
#    $includebuild = "\t".'$(CP) src$(DFSEP)httpd-include-unix.conf httpd-include.conf'
#} elsif ($c->isostype('Windows')) {
#    $includebuild = "\t".'$(CP) src$(DFSEP)httpd-include-win32.conf httpd-include.conf'
#} else {
#    $includebuild = "\t".'$(NOECHO) $(ECHO) "Skipped. OS unsupported: '.$^O.'"'
#}
$includebuild = "\t".'$(NOECHO) $(ECHO) "Your OS: '.$^O.'"';

return CTK::dformat($section, {
        INCLUDEBUILD => $includebuild,
    });
}

1;

__END__
