/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.hemf.record.HemfHeader;
import org.apache.poi.hemf.record.HemfRecord;
import org.apache.poi.hemf.record.HemfRecordType;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.RecordFormatException;

@Internal
public class HemfExtractor
implements Iterable<HemfRecord> {
    private HemfHeader header;
    private final LittleEndianInputStream stream;

    public HemfExtractor(InputStream is) throws IOException {
        this.stream = new LittleEndianInputStream(is);
        this.header = new HemfHeader();
        long recordId = this.stream.readUInt();
        long recordSize = this.stream.readUInt();
        this.header = new HemfHeader();
        this.header.init(this.stream, recordId, recordSize - 8L);
    }

    @Override
    public Iterator<HemfRecord> iterator() {
        return new HemfRecordIterator();
    }

    public HemfHeader getHeader() {
        return this.header;
    }

    private class HemfRecordIterator
    implements Iterator<HemfRecord> {
        private HemfRecord currentRecord = this._next();

        HemfRecordIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentRecord != null;
        }

        @Override
        public HemfRecord next() {
            HemfRecord toReturn = this.currentRecord;
            this.currentRecord = this._next();
            return toReturn;
        }

        private HemfRecord _next() {
            if (this.currentRecord != null && this.currentRecord.getRecordType().equals((Object)HemfRecordType.eof)) {
                return null;
            }
            long recordId = HemfExtractor.this.stream.readUInt();
            long recordSize = HemfExtractor.this.stream.readUInt();
            HemfRecord record = null;
            HemfRecordType type = HemfRecordType.getById(recordId);
            if (type == null) {
                throw new RuntimeException("Undefined record of type:" + recordId);
            }
            try {
                record = type.clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            try {
                record.init(HemfExtractor.this.stream, recordId, recordSize - 8L);
            }
            catch (IOException e) {
                throw new RecordFormatException(e);
            }
            return record;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }
}

