/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureType;
import org.apache.sis.feature.Field;
import org.apache.sis.feature.FieldType;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.jdk8.UncheckedIOException;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class FeatureFormat
extends TabularFormat<Object> {
    private static final long serialVersionUID = -5792086817264884947L;
    private static final String SEPARATOR = ", ";
    private static final AtomicReference<FeatureFormat> INSTANCE = new AtomicReference();
    private final Locale displayLocale;
    private final EnumSet<Column> columns = EnumSet.allOf(Column.class);
    private static final int MAXIMAL_VALUE_LENGTH = 40;
    private transient int illegalNaN;

    public FeatureFormat() {
        super(Locale.getDefault(Locale.Category.FORMAT), TimeZone.getDefault());
        this.displayLocale = Locale.getDefault(Locale.Category.DISPLAY);
        this.columnSeparator = " \u2502 ";
    }

    public FeatureFormat(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
        this.displayLocale = locale != null ? locale : Locale.ROOT;
        this.columnSeparator = " \u2502 ";
    }

    @Override
    public final Class<Object> getValueType() {
        return Object.class;
    }

    @Override
    public Locale getLocale(Locale.Category category) {
        return category == Locale.Category.DISPLAY ? this.displayLocale : super.getLocale(category);
    }

    public Set<Column> getAllowedColumns() {
        return this.columns.clone();
    }

    public void setAllowedColumns(Set<Column> set) {
        ArgumentChecks.ensureNonNull("inclusion", set);
        this.columns.clear();
        this.columns.addAll(set);
    }

    private void nextColumn(TableAppender tableAppender) {
        tableAppender.append(this.beforeFill);
        tableAppender.nextColumn(this.fillCharacter);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void format(Object var1_1, Appendable var2_2) throws IOException {
        ArgumentChecks.ensureNonNull("object", var1_1);
        ArgumentChecks.ensureNonNull("toAppendTo", var2_2);
        if (var1_1 instanceof AbstractFeature) {
            var4_3 = (AbstractFeature)var1_1;
            var3_4 = var4_3.getType();
        } else if (var1_1 instanceof DefaultFeatureType) {
            var3_4 = (DefaultFeatureType)var1_1;
            var4_3 = null;
        } else {
            throw new IllegalArgumentException(Errors.getResources(this.displayLocale).getString((short)163, var1_1.getClass()));
        }
        var5_5 = this.columns.clone();
        var6_6 = false;
        var7_9 = false;
        var8_12 = false;
        for (AbstractIdentifiedType var10_15 : var3_4.getProperties(true)) {
            if (!var6_6) {
                v0 = var6_6 = var10_15 /* !! */ .getDesignation() != null;
            }
            if (!var7_9 && var10_15 /* !! */  instanceof DefaultAttributeType) {
                v1 = var7_9 = ((DefaultAttributeType)var10_15 /* !! */ ).characteristics().isEmpty() == false;
            }
            if (var8_12 || !(var10_15 /* !! */  instanceof Deprecable)) continue;
            var8_12 = var10_15 /* !! */ .isDeprecated();
        }
        if (!var6_6) {
            var5_5.remove((Object)Column.DESIGNATION);
        }
        if (!var7_9) {
            var5_5.remove((Object)Column.CHARACTERISTICS);
        }
        if (!var8_12) {
            var5_5.remove((Object)Column.REMARKS);
        }
        var2_2.append(this.toString(var3_4.getName()));
        if (var4_3 == null) {
            var6_7 = " \u21fe ";
            for (FeatureType var8_13 : var3_4.getSuperTypes()) {
                var2_2.append(var6_7).append(this.toString(var8_13.getName()));
                var6_7 = ", ";
            }
        }
        var2_2.append(this.getLineSeparator());
        var6_8 = Vocabulary.getResources(this.displayLocale);
        var7_11 = new TableAppender(var2_2, this.columnSeparator);
        var7_11.setMultiLinesCells(true);
        var7_11.nextLine('\u2500');
        var8_12 = true;
        var9_14 = var5_5.iterator();
        while (var9_14.hasNext()) {
            var10_15 /* !! */  = (Column)var9_14.next();
            var11_16 = var10_15 /* !! */ .resourceKey;
            if (var11_16 == 111 && var4_3 == null) {
                var11_16 = 28;
            }
            if (!var8_12) {
                this.nextColumn(var7_11);
            }
            var7_11.append(var6_8.getString(var11_16));
            var8_12 = false;
        }
        var7_11.nextLine();
        var7_11.nextLine('\u2500');
        var9_14 = new StringBuffer();
        var10_15 /* !! */  = new FieldPosition(-1);
        var11_17 = new ArrayList<String>();
        for (AbstractIdentifiedType var13_20 : var3_4.getProperties(true)) {
            var14_22 = null;
            var15_23 = -1;
            if (var4_3 != null) {
                if (!(var13_20 instanceof DefaultAttributeType) && !(var13_20 instanceof DefaultAssociationRole) && !DefaultFeatureType.isParameterlessOperation(var13_20)) continue;
                var14_22 = var4_3.getPropertyValue(var13_20.getName().toString());
                if (var14_22 == null) {
                    if (var13_20 instanceof FieldType && ((FieldType)var13_20).getMinimumOccurs() == 0) continue;
                    var15_23 = 0;
                } else {
                    var15_23 = var14_22 instanceof Collection ? ((Collection)var14_22).size() : 1;
                }
            } else if (var13_20 instanceof DefaultAttributeType) {
                var14_22 = ((DefaultAttributeType)var13_20).getDefaultValue();
            } else if (var13_20 instanceof AbstractOperation) {
                var9_14.append(" = ");
                try {
                    ((AbstractOperation)var13_20).formatResultFormula((Appendable)var9_14);
                }
                catch (IOException var16_25) {
                    throw new UncheckedIOException(var16_25);
                }
                var14_22 = CharSequences.trimWhitespaces((CharSequence)var9_14).toString();
                var9_14.setLength(0);
            }
            var20_29 = var13_20 instanceof AbstractOperation != false ? ((AbstractOperation)var13_20).getResult() : var13_20;
            if (var20_29 instanceof DefaultAttributeType) {
                var21_30 = (DefaultAttributeType)var20_29;
                var18_27 = var21_30.getMinimumOccurs();
                var19_28 = var21_30.getMaximumOccurs();
                var17_26 = var21_30.getValueClass();
                var16_24 = this.getFormat(Class.class).format(var17_26, (StringBuffer)var9_14, (FieldPosition)var10_15 /* !! */ ).toString();
                var9_14.setLength(0);
            } else if (var20_29 instanceof DefaultAssociationRole) {
                var21_30 = (DefaultAssociationRole)var20_29;
                var18_27 = var21_30.getMinimumOccurs();
                var19_28 = var21_30.getMaximumOccurs();
                var16_24 = this.toString(DefaultAssociationRole.getValueTypeName((DefaultAssociationRole)var21_30));
                var17_26 = AbstractFeature.class;
            } else {
                var16_24 = var20_29 != null ? this.toString(var20_29.getName()) : "";
                var17_26 = null;
                var18_27 = -1;
                var19_28 = -1;
            }
            var8_12 = true;
            var21_30 = var5_5.iterator();
            block17: while (var21_30.hasNext()) {
                var22_31 = (Column)var21_30.next();
                if (!var8_12) {
                    this.nextColumn(var7_11);
                }
                var8_12 = false;
                block2 : switch (1.$SwitchMap$org$apache$sis$feature$FeatureFormat$Column[var22_31.ordinal()]) {
                    case 1: {
                        var23_32 = var13_20.getDesignation();
                        if (var23_32 == null) break;
                        var7_11.append(var23_32.toString(this.displayLocale));
                        break;
                    }
                    case 2: {
                        var7_11.append(this.toString(var13_20.getName()));
                        break;
                    }
                    case 3: {
                        var7_11.append(var16_24);
                        break;
                    }
                    case 4: {
                        var7_11.setCellAlignment((byte)1);
                        if (var15_23 >= 0) {
                            var7_11.append(this.getFormat(Integer.class).format(var15_23, (StringBuffer)var9_14, (FieldPosition)var10_15 /* !! */ ));
                            var9_14.setLength(0);
                        }
                        if (var19_28 < 0) break;
                        if (var15_23 >= 0) {
                            var7_11.append(' ').append((char)(var15_23 >= var18_27 && var15_23 <= var19_28 ? 8712 : 8713)).append(' ');
                        }
                        var23_33 = this.getFormat(Integer.class);
                        var7_11.append('[').append(var23_33.format(var18_27, (StringBuffer)var9_14, (FieldPosition)var10_15 /* !! */ )).append(" \u2026 ");
                        var9_14.setLength(0);
                        if (var19_28 != 0x7FFFFFFF) {
                            var7_11.append(var23_33.format(var19_28, (StringBuffer)var9_14, (FieldPosition)var10_15 /* !! */ ));
                        } else {
                            var7_11.append('\u221e');
                        }
                        var9_14.setLength(0);
                        var7_11.append(']');
                        break;
                    }
                    case 5: {
                        var7_11.setCellAlignment((byte)-1);
                        var23_34 = this.getFormat(var17_26);
                        var24_37 = CollectionsExt.toCollection(var14_22).iterator();
                        var25_38 = "";
                        var26_39 = 0;
                        while (var24_37.hasNext()) {
                            var14_22 = var24_37.next();
                            if (var14_22 == null) continue;
                            if (!(var13_20 instanceof DefaultAssociationRole)) ** GOTO lbl171
                            var27_41 = DefaultAssociationRole.getTitleProperty((DefaultAssociationRole)var13_20);
                            if (var27_41 != null && (var14_22 = ((AbstractFeature)var14_22).getPropertyValue((String)var27_41)) == null) {
                                continue;
                            }
                            ** GOTO lbl191
lbl171:
                            // 1 sources

                            if (var23_34 == null || !var17_26.isInstance(var14_22)) ** GOTO lbl191
                            var27_41 = var23_34.format(var14_22, (StringBuffer)var9_14, (FieldPosition)var10_15 /* !! */ );
                            if (!(var14_22 instanceof Number) || !Float.isNaN(var28_42 = ((Number)var14_22).floatValue())) ** GOTO lbl190
                            if ("\ufffd".contentEquals((StringBuffer)var27_41)) {
                                var27_41.setLength(0);
                                var27_41.append("NaN");
                            }
                            try {
                                var29_44 = MathFunctions.toNanOrdinal(var28_42);
                                if (var29_44 > 0) {
                                    var27_41.append(" #").append(var29_44);
                                }
                            }
                            catch (IllegalArgumentException var29_45) {
                                var30_47 = Float.floatToRawIntBits(var28_42);
                                if (var30_47 == this.illegalNaN) ** GOTO lbl190
                                this.illegalNaN = var30_47;
                                Logging.recoverableException(Logging.getLogger("org.apache.sis.feature"), FeatureFormat.class, "format", var29_45);
                            }
lbl190:
                            // 4 sources

                            var14_22 = var27_41;
lbl191:
                            // 3 sources

                            var26_39 = this.formatValue(var14_22, var7_11.append((CharSequence)var25_38), var26_39);
                            var9_14.setLength(0);
                            if (var26_39 < 0) break block2;
                            var25_38 = ", ";
                            var26_39 += ", ".length();
                        }
                        break;
                    }
                    case 6: {
                        if (!(var13_20 instanceof DefaultAttributeType)) break;
                        var23_35 = 0;
                        var24_37 = "";
                        for (DefaultAttributeType var26_40 : ((DefaultAttributeType)var13_20).characteristics().values()) {
                            var27_41 = var26_40.getName();
                            var28_43 = this.toString((GenericName)var27_41);
                            var7_11.append((CharSequence)var24_37).append(var28_43);
                            var23_35 += var24_37.length() + var28_43.length();
                            var29_46 /* !! */  = CollectionsExt.singletonOrEmpty(var26_40.getDefaultValue());
                            if (var4_3 != null && (var30_48 = var4_3.getProperty(var13_20.getName().toString())) instanceof AbstractAttribute && (var31_50 = ((AbstractAttribute)var30_48).characteristics().get(var27_41.toString())) != null) {
                                var29_46 /* !! */  = var31_50.getValues();
                            }
                            var30_47 = var26_40.getMaximumOccurs() > 1 ? 1 : 0;
                            var31_50 = var30_47 != 0 ? " = {" : " = ";
                            for (E var33_52 : var29_46 /* !! */ ) {
                                var23_35 += var31_50.length();
                                var23_35 = this.formatValue(var33_52, var7_11.append((CharSequence)var31_50), var23_35);
                                if (var23_35 < 0) break block2;
                                var31_50 = ", ";
                            }
                            var24_37 = ", ";
                            if (var30_47 == 0 || var31_50 != ", ") continue;
                            var7_11.append('}');
                        }
                        continue block17;
                    }
                    case 7: {
                        if (!Field.isDeprecated(var13_20)) break;
                        var7_11.append(var6_8.getString((short)29));
                        var23_36 = var13_20.getRemarks();
                        if (var23_36 == null) break;
                        var11_17.add(var23_36.toString(this.displayLocale));
                        FeatureFormat.appendSuperscript(var11_17.size(), var7_11);
                    }
                }
            }
            var7_11.nextLine();
        }
        var7_11.nextLine('\u2500');
        var7_11.flush();
        var12_19 = var11_17.size();
        for (var13_21 = 0; var13_21 < var12_19; ++var13_21) {
            FeatureFormat.appendSuperscript(var13_21 + 1, var2_2);
            var2_2.append(' ').append((CharSequence)var11_17.get(var13_21)).append(this.lineSeparator);
        }
    }

    private String toString(GenericName genericName) {
        String string;
        if (genericName == null) {
            return "";
        }
        InternationalString internationalString = genericName.toInternationalString();
        if (internationalString != null && (string = internationalString.toString(this.displayLocale)) != null) {
            return string;
        }
        return genericName.toString();
    }

    private int formatValue(Object object, TableAppender tableAppender, int n) {
        String string;
        if (object instanceof InternationalString) {
            string = ((InternationalString)object).toString(this.displayLocale);
        } else if (object instanceof GenericName) {
            string = this.toString((GenericName)object);
        } else if (object instanceof AbstractIdentifiedType) {
            string = this.toString(((AbstractIdentifiedType)object).getName());
        } else if (object instanceof IdentifiedObject) {
            string = IdentifiedObjects.getIdentifierOrName((IdentifiedObject)object);
        } else {
            string = Geometries.toString(object);
            if (string == null) {
                string = object.toString();
            }
        }
        int n2 = 40 - n;
        if (n2 >= string.length()) {
            tableAppender.append(string);
            return n + string.length();
        }
        tableAppender.append(string, 0, Math.max(0, n2 - 1)).append('\u2026');
        return -1;
    }

    private static void appendSuperscript(int n, Appendable appendable) throws IOException {
        if (n >= 0 && n < 10) {
            appendable.append(Characters.toSuperScript((char)(48 + n)));
        } else {
            appendable.append('(').append(String.valueOf(n)).append(')');
        }
    }

    static String sharedFormat(Object object) {
        FeatureFormat featureFormat = INSTANCE.getAndSet(null);
        if (featureFormat == null) {
            featureFormat = new FeatureFormat();
        }
        String string = featureFormat.format(object);
        INSTANCE.set(featureFormat);
        return string;
    }

    @Override
    public Object parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        throw new ParseException(Errors.getResources(this.displayLocale).getString((short)162, "parse"), parsePosition.getIndex());
    }

    @Override
    public FeatureFormat clone() {
        return (FeatureFormat)super.clone();
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$sis$feature$FeatureFormat$Column;

        static {
            $SwitchMap$org$apache$sis$feature$FeatureFormat$Column = new int[Column.values().length];
            try {
                1.$SwitchMap$org$apache$sis$feature$FeatureFormat$Column[Column.DESIGNATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$sis$feature$FeatureFormat$Column[Column.NAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$sis$feature$FeatureFormat$Column[Column.TYPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$sis$feature$FeatureFormat$Column[Column.CARDINALITY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$sis$feature$FeatureFormat$Column[Column.VALUE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$sis$feature$FeatureFormat$Column[Column.CHARACTERISTICS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$sis$feature$FeatureFormat$Column[Column.REMARKS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static enum Column {
        DESIGNATION(142),
        NAME(72),
        TYPE(105),
        CARDINALITY(10),
        VALUE(111),
        CHARACTERISTICS(13),
        REMARKS(88);

        final short resourceKey;

        private Column(short s) {
            this.resourceKey = s;
        }
    }
}

