/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import org.apache.sis.util.LenientComparable;

public enum ComparisonMode {
    STRICT,
    BY_CONTRACT,
    IGNORE_METADATA,
    APPROXIMATIVE,
    ALLOW_VARIANT,
    DEBUG;


    public boolean isIgnoringMetadata() {
        return this.ordinal() >= IGNORE_METADATA.ordinal();
    }

    public boolean isApproximative() {
        return this.ordinal() >= APPROXIMATIVE.ordinal();
    }

    public static ComparisonMode equalityLevel(Object object, Object object2) {
        if (object == object2) {
            return STRICT;
        }
        if (object != null && object2 != null) {
            LenientComparable lenientComparable;
            if (object.equals(object2)) {
                return STRICT;
            }
            if (object instanceof LenientComparable) {
                lenientComparable = (LenientComparable)object;
            } else if (object2 instanceof LenientComparable) {
                lenientComparable = (LenientComparable)object2;
                object2 = object;
            } else {
                return null;
            }
            if (lenientComparable.equals(object2, BY_CONTRACT)) {
                return BY_CONTRACT;
            }
            if (lenientComparable.equals(object2, IGNORE_METADATA)) {
                return IGNORE_METADATA;
            }
            if (lenientComparable.equals(object2, APPROXIMATIVE)) {
                return APPROXIMATIVE;
            }
            if (lenientComparable.equals(object2, ALLOW_VARIANT)) {
                return ALLOW_VARIANT;
            }
        }
        return null;
    }
}

