package App::Manoc::Controller::Error;
#ABSTRACT: Error controller

use Moose;

our $VERSION = '2.99.3'; ##TRIAL VERSION

use namespace::autoclean;

BEGIN { extends 'Catalyst::Controller'; }


sub http_403 : Private {
    my ( $self, $c ) = @_;
    $c->stash( template => 'error_403.tt' );
    $c->response->status(403);
}


sub http_404 : Private {
    my ( $self, $c ) = @_;
    $c->stash( template => 'error_404.tt' );
    $c->response->status(404);
}

__PACKAGE__->meta->make_immutable;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Controller::Error - Error controller

=head1 VERSION

version 2.99.3

=head1 ACTIONS

=head2 http_403

Error page for HTTP 403.

=head2 http_404

Error page for HTTP 404.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
