/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class Compare
extends CollatingFunction
implements CallableExpression {
    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.MINUS_ONE, Int64Value.PLUS_ONE};
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue arg0 = (AtomicValue)this.argument[0].evaluateItem(context);
        if (arg0 == null) {
            return null;
        }
        AtomicValue arg1 = (AtomicValue)this.argument[1].evaluateItem(context);
        if (arg1 == null) {
            return null;
        }
        GenericAtomicComparer collator = this.getAtomicComparer(2, context);
        int result = collator.compareAtomicValues(arg0, arg1);
        if (result < 0) {
            return Int64Value.MINUS_ONE;
        }
        if (result > 0) {
            return Int64Value.PLUS_ONE;
        }
        return Int64Value.ZERO;
    }

    public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        AtomicValue arg0 = (AtomicValue)arguments[0].next();
        if (arg0 == null) {
            return null;
        }
        AtomicValue arg1 = (AtomicValue)arguments[1].next();
        if (arg1 == null) {
            return null;
        }
        GenericAtomicComparer collator = this.getAtomicComparer(2, context);
        int result = collator.compareAtomicValues(arg0, arg1);
        if (result < 0) {
            return SingletonIterator.makeIterator(Int64Value.MINUS_ONE);
        }
        if (result > 0) {
            return SingletonIterator.makeIterator(Int64Value.PLUS_ONE);
        }
        return SingletonIterator.makeIterator(Int64Value.ZERO);
    }
}

