/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.protocol;

import com.javonet.utils.StringEcodingMode;
import java.nio.charset.StandardCharsets;

public class TypeDecoder {
    protected static String decodeString(StringEcodingMode stringEncodingMode, byte[] bytes) {
        switch (stringEncodingMode) {
            case ASCII: {
                return new String(bytes, StandardCharsets.US_ASCII);
            }
            case UTF8: {
                return new String(bytes, StandardCharsets.UTF_8);
            }
            case UTF16: {
                return new String(bytes, StandardCharsets.UTF_16LE);
            }
            case UTF32: {
                throw new UnsupportedOperationException();
            }
        }
        throw new ArrayIndexOutOfBoundsException("");
    }

    protected static int decodeInt(byte[] bytes) {
        return bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8 | (bytes[2] & 0xFF) << 16 | (bytes[3] & 0xFF) << 24;
    }

    protected static float decodeFloat(byte[] bytes) {
        return Float.intBitsToFloat(TypeDecoder.decodeInt(bytes));
    }

    protected static char decodeChar(byte byteVal) {
        return (char)byteVal;
    }

    protected static long decodeLong(byte[] bytes) {
        return (long)bytes[0] & 0xFFL | ((long)bytes[1] & 0xFFL) << 8 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[7] & 0xFFL) << 56;
    }

    protected static double decodeDouble(byte[] bytes) {
        return Double.longBitsToDouble(TypeDecoder.decodeLong(bytes));
    }
}

