/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.handler;

import com.javonet.core.handler.AbstractHandler;
import com.javonet.core.handler.ArrayGetItemHandler;
import com.javonet.core.handler.ArrayGetRankHandler;
import com.javonet.core.handler.ArrayGetSizeHandler;
import com.javonet.core.handler.ArrayHandler;
import com.javonet.core.handler.ArraySetItemHandler;
import com.javonet.core.handler.CastHandler;
import com.javonet.core.handler.CreateInstanceHandler;
import com.javonet.core.handler.DestructReferenceHandler;
import com.javonet.core.handler.GenerateLibraryHandler;
import com.javonet.core.handler.GenericMethodHandler;
import com.javonet.core.handler.GenericStaticMethodHandler;
import com.javonet.core.handler.GetInstanceFieldHandler;
import com.javonet.core.handler.GetStaticFieldHandler;
import com.javonet.core.handler.GetTypeHandler;
import com.javonet.core.handler.InvokeInstanceMethodHandler;
import com.javonet.core.handler.InvokeStaticMethodHandler;
import com.javonet.core.handler.LoadLibraryHandler;
import com.javonet.core.handler.OptimizeHandler;
import com.javonet.core.handler.ReferencesCache;
import com.javonet.core.handler.ResolveInstanceHandler;
import com.javonet.core.handler.SetInstanceFieldHandler;
import com.javonet.core.handler.SetStaticFieldHandler;
import com.javonet.core.handler.ValueHandler;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.exceptions.ExceptionSerializer;
import java.util.HashMap;
import java.util.Map;

public class Handler {
    Map<CommandType, AbstractHandler> HANDLERS = new HashMap<CommandType, AbstractHandler>();

    public Handler() {
        this.HANDLERS.put(CommandType.VALUE, new ValueHandler());
        this.HANDLERS.put(CommandType.LOAD_LIBRARY, new LoadLibraryHandler());
        this.HANDLERS.put(CommandType.INVOKE_STATIC_METHOD, new InvokeStaticMethodHandler());
        this.HANDLERS.put(CommandType.GET_STATIC_FIELD, new GetStaticFieldHandler());
        this.HANDLERS.put(CommandType.SET_STATIC_FIELD, new SetStaticFieldHandler());
        this.HANDLERS.put(CommandType.CREATE_INSTANCE, new CreateInstanceHandler());
        this.HANDLERS.put(CommandType.GET_TYPE, new GetTypeHandler());
        this.HANDLERS.put(CommandType.REFERENCE, new ResolveInstanceHandler());
        this.HANDLERS.put(CommandType.INVOKE_INSTANCE_METHOD, new InvokeInstanceMethodHandler());
        this.HANDLERS.put(CommandType.CAST, new CastHandler());
        this.HANDLERS.put(CommandType.OPTIMIZE, new OptimizeHandler());
        this.HANDLERS.put(CommandType.GENERATE_LIB, new GenerateLibraryHandler());
        this.HANDLERS.put(CommandType.GET_INSTANCE_FIELD, new GetInstanceFieldHandler());
        this.HANDLERS.put(CommandType.SET_INSTANCE_FIELD, new SetInstanceFieldHandler());
        this.HANDLERS.put(CommandType.DESTRUCT_REFERENCE, new DestructReferenceHandler());
        this.HANDLERS.put(CommandType.ARRAY_GET_ITEM, new ArrayGetItemHandler());
        this.HANDLERS.put(CommandType.ARRAY_GET_SIZE, new ArrayGetSizeHandler());
        this.HANDLERS.put(CommandType.ARRAY_GET_RANK, new ArrayGetRankHandler());
        this.HANDLERS.put(CommandType.ARRAY_SET_ITEM, new ArraySetItemHandler());
        this.HANDLERS.put(CommandType.ARRAY, new ArrayHandler());
        this.HANDLERS.put(CommandType.INVOKE_GENERIC_STATIC_METHOD, new GenericStaticMethodHandler());
        this.HANDLERS.put(CommandType.INVOKE_GENERIC_METHOD, new GenericMethodHandler());
    }

    public Command handleCommand(Command command) {
        try {
            if (command.getCommandType() == CommandType.RETRIEVE_ARRAY) {
                Object[] responseArray = (Object[])this.HANDLERS.get((Object)CommandType.REFERENCE).handleCommand((Command)command.getPayload()[0]);
                return Command.createArrayResponse(responseArray, command.getRuntimeName());
            }
            Object response = this.HANDLERS.get((Object)command.getCommandType()).handleCommand(command);
            return Handler.ParseResponse(response, command.getRuntimeName());
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                return ExceptionSerializer.serializeException(e.getCause(), command);
            }
            return ExceptionSerializer.serializeException(e, command);
        }
    }

    private static Command ParseResponse(Object response, RuntimeName runtimeName) {
        if (Handler.isResponseSimpleType(response)) {
            return Command.createResponse(response, runtimeName);
        }
        if (Handler.isCommandGenerateLibType(response) || Handler.isCommandExceptionType(response)) {
            return (Command)response;
        }
        ReferencesCache cache = ReferencesCache.getInstance();
        String uuid = cache.cacheReference(response);
        return Command.createReference(uuid, runtimeName);
    }

    private static boolean isCommandGenerateLibType(Object result) {
        if (result.getClass() == Command.class) {
            return ((Command)result).getCommandType().equals((Object)CommandType.GENERATE_LIB);
        }
        return false;
    }

    private static boolean isCommandExceptionType(Object result) {
        if (result.getClass() == Command.class) {
            return ((Command)result).getCommandType().equals((Object)CommandType.EXCEPTION);
        }
        return false;
    }

    private static boolean isResponseSimpleType(Object result) {
        Class<?> resultClass = result.getClass();
        return resultClass.isPrimitive() || resultClass == String.class || resultClass == Long.class || resultClass == Integer.class || resultClass == Boolean.class || resultClass == Byte.class || resultClass == Float.class || resultClass == Double.class || resultClass == Short.class || resultClass == Character.class;
    }
}

