use strict;
use warnings;

use Test::More tests => 34;
use Data::Dumper;

use_ok 'Rex';
use_ok 'Rex::Commands::Iptables';

my @iptables_list_1 = (
  "# Generated by iptables-save v1.4.12 on Fri Nov 16 22:20:13 2012",
  "*nat",
  ":PREROUTING ACCEPT [831648:47063372]",
  ":INPUT ACCEPT [71162:4082850]",
  ":OUTPUT ACCEPT [159345:9708626]",
  ":POSTROUTING ACCEPT [263463:17336449]",
  "-A PREROUTING -d 1.2.3.4/32 -p tcp -m tcp --dport 25 -j DNAT --to-destination 4.3.2.1:25",
  "COMMIT",
  "*foo",
  "-A syn_flood -p tcp -m tcp --tcp-flags FIN,SYN,RST,ACK SYN -m limit --limit 25/sec --limit-burst 50 -j RETURN",
);

my $rules = Rex::Commands::Iptables::_iptables_list(@iptables_list_1);

ok( exists $rules->{nat},                    "found nat tables" );
ok( $rules->{nat}->[0]->[0] eq "A",          "first is append" );
ok( $rules->{nat}->[0]->[1] eq "PREROUTING", "append to prerouting" );
ok( $rules->{nat}->[0]->[2] eq "d",          "should be destination" );
ok( $rules->{nat}->[0]->[3] eq "1.2.3.4/32", "to destination 1.2.3.4" );
ok( $rules->{nat}->[0]->[4] eq "p",          "should be proto" );
ok( $rules->{nat}->[0]->[5] eq "tcp",        "tcp" );
ok( $rules->{nat}->[0]->[6] eq "m",          "in module" );
ok( $rules->{nat}->[0]->[7] eq "tcp",        "tcp" );
ok( $rules->{nat}->[0]->[8] eq "dport",      "should be destination port" );
ok( $rules->{nat}->[0]->[9] eq "25",         "dport 25" );
ok( $rules->{nat}->[0]->[10] eq "j",         "jump to" );
ok( $rules->{nat}->[0]->[11] eq "DNAT",      "dnating" );
ok(
  $rules->{nat}->[0]->[12] eq "to-destination",
  "should be forwarded to destination"
);
ok( $rules->{nat}->[0]->[13] eq "4.3.2.1:25", "4.3.2.1:25" );

ok( exists $rules->{foo},                   "found foo table" );
ok( $rules->{foo}->[0]->[0] eq "A",         "frist is append" );
ok( $rules->{foo}->[0]->[1] eq "syn_flood", "append to sys_flood" );
ok( $rules->{foo}->[0]->[2] eq "p",         "should use protocol" );
ok( $rules->{foo}->[0]->[3] eq "tcp",       "proto tcp" );
ok( $rules->{foo}->[0]->[4] eq "m",         "in module" );
ok( $rules->{foo}->[0]->[5] eq "tcp",       "tcp module" );
ok( $rules->{foo}->[0]->[6] eq "tcp-flags", "should match tcp flags" );
ok( $rules->{foo}->[0]->[7] eq "FIN,SYN,RST,ACK SYN", "only these flags" );
ok( $rules->{foo}->[0]->[8] eq "m",                   "should use module" );
ok( $rules->{foo}->[0]->[9] eq "limit",               "limit module" );
ok( $rules->{foo}->[0]->[10] eq "limit",              "limit the bandwidth" );
ok( $rules->{foo}->[0]->[11] eq "25/sec",             "to 25 req per second" );
ok( $rules->{foo}->[0]->[12] eq "limit-burst",        "use burst" );
ok( $rules->{foo}->[0]->[13] eq "50",                 "up to 50" );
ok( $rules->{foo}->[0]->[14] eq "j",                  "jump to" );
ok( $rules->{foo}->[0]->[15] eq "RETURN",             "RETURN" );

