=encoding utf8

=head1

Locale::CLDR::Locales::Sr - Package for language Serbian

=cut

package Locale::CLDR::Locales::Sr;
# This file auto generated from Data\common\main\sr.xml
#	on Sun  3 Feb  2:18:49 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal-masculine','spellout-cardinal-neuter','spellout-cardinal-feminine','spellout-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => HashRef,
	init_arg => undef,
	default => sub { 
		use bignum;
		return {
		'ordi' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(и),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' и =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' и =%spellout-ordinal=),
				},
			},
		},
		'ordti' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ти),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'spellout-cardinal-feminine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(једна),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(две),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четрдесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шездесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седамдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осамдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљаду[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-masculine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(један),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(три),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(четири),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(пет),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(шест),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(седам),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(осам),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(девет),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(десет),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(једанаест),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(дванаест),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(тринаест),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(четрнаест),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(петнаест),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(шеснаест),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(седамнаест),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(осамнаест),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(деветнаест),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четрдесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шездесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седамдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осамдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљаду[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-neuter' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(једно),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четрдесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шездесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седамдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осамдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљаду[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нулти),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##0.#=),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(први),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(други),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(трећи),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(четврти),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(пети),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(шести),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(седми),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(осми),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(девети),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(десети),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(једанаести),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(дванаести),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(тринаести),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(четрнаести),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(петнаести),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(шеснаести),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(седамнаести),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(осамнаести),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(деветнаести),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет→%%ordi→),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет→%%ordi→),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четрдесет→%%ordi→),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет→%%ordi→),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шездесет→%%ordi→),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седамдесет→%%ordi→),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осамдесет→%%ordi→),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет→%%ordi→),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто→%%ordti→),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста→%%ordti→),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста→%%ordti→),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто→%%ordti→),
				},
				'max' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто→%%ordti→),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'афарски',
 				'ab' => 'абхаски',
 				'ace' => 'ацешки',
 				'ach' => 'аколи',
 				'ada' => 'адангме',
 				'ady' => 'адигејски',
 				'ae' => 'авестански',
 				'af' => 'африканс',
 				'afh' => 'африхили',
 				'agq' => 'агем',
 				'ain' => 'аину',
 				'ak' => 'акански',
 				'akk' => 'акадијски',
 				'ale' => 'алеутски',
 				'alt' => 'јужноалтајски',
 				'am' => 'амхарски',
 				'an' => 'арагонски',
 				'ang' => 'староенглески',
 				'anp' => 'ангика',
 				'ar' => 'арапски',
 				'ar_001' => 'савремени стандардни арапски',
 				'arc' => 'арамејски',
 				'arn' => 'мапуче',
 				'arp' => 'арапахо',
 				'arw' => 'аравачки',
 				'as' => 'асамски',
 				'asa' => 'асу',
 				'ast' => 'астуријски',
 				'av' => 'аварски',
 				'awa' => 'авади',
 				'ay' => 'ајмара',
 				'az' => 'азербејџански',
 				'az@alt=short' => 'азерски',
 				'ba' => 'башкирски',
 				'bal' => 'белучки',
 				'ban' => 'балијски',
 				'bas' => 'баса',
 				'be' => 'белоруски',
 				'bej' => 'беџа',
 				'bem' => 'бемба',
 				'bez' => 'бена',
 				'bg' => 'бугарски',
 				'bgn' => 'западни белучки',
 				'bho' => 'боџпури',
 				'bi' => 'бислама',
 				'bik' => 'бикол',
 				'bin' => 'бини',
 				'bla' => 'сисика',
 				'bm' => 'бамбара',
 				'bn' => 'бенгалски',
 				'bo' => 'тибетански',
 				'br' => 'бретонски',
 				'bra' => 'брај',
 				'brx' => 'бодо',
 				'bs' => 'босански',
 				'bua' => 'бурјатски',
 				'bug' => 'бугијски',
 				'byn' => 'блински',
 				'ca' => 'каталонски',
 				'cad' => 'кадо',
 				'car' => 'карипски',
 				'cch' => 'атсам',
 				'ce' => 'чеченски',
 				'ceb' => 'себуански',
 				'cgg' => 'чига',
 				'ch' => 'чаморо',
 				'chb' => 'чипча',
 				'chg' => 'чагатај',
 				'chk' => 'чучки',
 				'chm' => 'мари',
 				'chn' => 'чинучки',
 				'cho' => 'чоктавски',
 				'chp' => 'чипевјански',
 				'chr' => 'чероки',
 				'chy' => 'чејенски',
 				'ckb' => 'централни курдски',
 				'co' => 'корзикански',
 				'cop' => 'коптски',
 				'cr' => 'кри',
 				'crh' => 'кримскотатарски',
 				'crs' => 'сејшелски креолски француски',
 				'cs' => 'чешки',
 				'csb' => 'кашупски',
 				'cu' => 'црквенословенски',
 				'cv' => 'чувашки',
 				'cy' => 'велшки',
 				'da' => 'дански',
 				'dak' => 'дакота',
 				'dar' => 'даргински',
 				'dav' => 'таита',
 				'de' => 'немачки',
 				'de_CH' => 'швајцарски високи немачки',
 				'del' => 'делаверски',
 				'den' => 'слејви',
 				'dgr' => 'догрипски',
 				'din' => 'динка',
 				'dje' => 'зарма',
 				'doi' => 'догри',
 				'dsb' => 'доњи лужичкосрпски',
 				'dua' => 'дуала',
 				'dum' => 'средњехоландски',
 				'dv' => 'малдивски',
 				'dyo' => 'џола фоњи',
 				'dyu' => 'ђула',
 				'dz' => 'џонга',
 				'dzg' => 'дазага',
 				'ebu' => 'ембу',
 				'ee' => 'еве',
 				'efi' => 'ефички',
 				'egy' => 'староегипатски',
 				'eka' => 'екаџук',
 				'el' => 'грчки',
 				'elx' => 'еламитски',
 				'en' => 'енглески',
 				'en_GB' => 'енглески (Велика Британија)',
 				'en_GB@alt=short' => 'енглески (УК)',
 				'en_US' => 'енглески (Сједињене Америчке Државе)',
 				'en_US@alt=short' => 'енглески (САД)',
 				'enm' => 'средњеенглески',
 				'eo' => 'есперанто',
 				'es' => 'шпански',
 				'es_ES' => 'шпански (Европа)',
 				'et' => 'естонски',
 				'eu' => 'баскијски',
 				'ewo' => 'евондо',
 				'fa' => 'персијски',
 				'fan' => 'фанг',
 				'fat' => 'фанти',
 				'ff' => 'фула',
 				'fi' => 'фински',
 				'fil' => 'филипински',
 				'fj' => 'фиџијски',
 				'fo' => 'фарски',
 				'fon' => 'фон',
 				'fr' => 'француски',
 				'frc' => 'кајунски француски',
 				'frm' => 'средњефранцуски',
 				'fro' => 'старофранцуски',
 				'frr' => 'севернофризијски',
 				'frs' => 'источнофризијски',
 				'fur' => 'фриулски',
 				'fy' => 'западни фризијски',
 				'ga' => 'ирски',
 				'gaa' => 'га',
 				'gag' => 'гагауз',
 				'gay' => 'гајо',
 				'gba' => 'гбаја',
 				'gd' => 'шкотски гелски',
 				'gez' => 'геез',
 				'gil' => 'гилбертски',
 				'gl' => 'галицијски',
 				'gmh' => 'средњи високонемачки',
 				'gn' => 'гварани',
 				'goh' => 'старонемачки',
 				'gon' => 'гонди',
 				'gor' => 'горонтало',
 				'got' => 'готски',
 				'grb' => 'гребо',
 				'grc' => 'старогрчки',
 				'gsw' => 'немачки (Швајцарска)',
 				'gu' => 'гуџарати',
 				'guz' => 'гуси',
 				'gv' => 'манкс',
 				'gwi' => 'гвичински',
 				'ha' => 'хауса',
 				'hai' => 'хаида',
 				'haw' => 'хавајски',
 				'he' => 'хебрејски',
 				'hi' => 'хинди',
 				'hil' => 'хилигајнонски',
 				'hit' => 'хетитски',
 				'hmn' => 'хмоншки',
 				'ho' => 'хири моту',
 				'hr' => 'хрватски',
 				'hsb' => 'горњи лужичкосрпски',
 				'ht' => 'хаићански',
 				'hu' => 'мађарски',
 				'hup' => 'хупа',
 				'hy' => 'јерменски',
 				'hz' => 'хереро',
 				'ia' => 'интерлингва',
 				'iba' => 'ибански',
 				'ibb' => 'ибибио',
 				'id' => 'индонежански',
 				'ie' => 'интерлингве',
 				'ig' => 'игбо',
 				'ii' => 'сечуански ји',
 				'ik' => 'инупик',
 				'ilo' => 'илоко',
 				'inh' => 'ингушки',
 				'io' => 'идо',
 				'is' => 'исландски',
 				'it' => 'италијански',
 				'iu' => 'инуктитутски',
 				'ja' => 'јапански',
 				'jbo' => 'ложбан',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачаме',
 				'jpr' => 'јудео-персијски',
 				'jrb' => 'јудео-арапски',
 				'jv' => 'јавански',
 				'ka' => 'грузијски',
 				'kaa' => 'кара-калпашки',
 				'kab' => 'кабиле',
 				'kac' => 'качински',
 				'kaj' => 'џу',
 				'kam' => 'камба',
 				'kaw' => 'кави',
 				'kbd' => 'кабардијски',
 				'kcg' => 'тјап',
 				'kde' => 'маконде',
 				'kea' => 'зеленортски',
 				'kfo' => 'коро',
 				'kg' => 'конго',
 				'kha' => 'каси',
 				'kho' => 'котанешки',
 				'khq' => 'којра чиини',
 				'ki' => 'кикују',
 				'kj' => 'квањама',
 				'kk' => 'казашки',
 				'kkj' => 'како',
 				'kl' => 'гренландски',
 				'kln' => 'каленџински',
 				'km' => 'кмерски',
 				'kmb' => 'кимбунду',
 				'kn' => 'канада',
 				'ko' => 'корејски',
 				'koi' => 'коми-пермски',
 				'kok' => 'конкани',
 				'kos' => 'косренски',
 				'kpe' => 'кпеле',
 				'kr' => 'канури',
 				'krc' => 'карачајско-балкарски',
 				'kri' => 'крио',
 				'krl' => 'карелски',
 				'kru' => 'курук',
 				'ks' => 'кашмирски',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафија',
 				'ksh' => 'келнски',
 				'ku' => 'курдски',
 				'kum' => 'кумички',
 				'kut' => 'кутенај',
 				'kv' => 'коми',
 				'kw' => 'корнволски',
 				'ky' => 'киргиски',
 				'la' => 'латински',
 				'lad' => 'ладино',
 				'lag' => 'ланги',
 				'lah' => 'ланда',
 				'lam' => 'ламба',
 				'lb' => 'луксембуршки',
 				'lez' => 'лезгински',
 				'lg' => 'ганда',
 				'li' => 'лимбуршки',
 				'lkt' => 'лакота',
 				'ln' => 'лингала',
 				'lo' => 'лаоски',
 				'lol' => 'монго',
 				'lou' => 'луизијански креолски',
 				'loz' => 'лози',
 				'lrc' => 'северни лури',
 				'lt' => 'литвански',
 				'lu' => 'луба-катанга',
 				'lua' => 'луба-лулуа',
 				'lui' => 'луисењо',
 				'lun' => 'лунда',
 				'luo' => 'луо',
 				'lus' => 'мизо',
 				'luy' => 'лујиа',
 				'lv' => 'летонски',
 				'mad' => 'мадурски',
 				'mag' => 'магахи',
 				'mai' => 'маитили',
 				'mak' => 'макасарски',
 				'man' => 'мандинго',
 				'mas' => 'масајски',
 				'mdf' => 'мокша',
 				'mdr' => 'мандар',
 				'men' => 'менде',
 				'mer' => 'меру',
 				'mfe' => 'морисјен',
 				'mg' => 'малгашки',
 				'mga' => 'средњеирски',
 				'mgh' => 'макува-мито',
 				'mgo' => 'мета',
 				'mh' => 'маршалски',
 				'mi' => 'маорски',
 				'mic' => 'микмак',
 				'min' => 'минангкабау',
 				'mk' => 'македонски',
 				'ml' => 'малајалам',
 				'mn' => 'монголски',
 				'mnc' => 'манџурски',
 				'mni' => 'манипурски',
 				'moh' => 'мохочки',
 				'mos' => 'моси',
 				'mr' => 'марати',
 				'ms' => 'малајски',
 				'mt' => 'малтешки',
 				'mua' => 'мунданг',
 				'mul' => 'Више језика',
 				'mus' => 'кришки',
 				'mwl' => 'мирандски',
 				'mwr' => 'марвари',
 				'my' => 'бурмански',
 				'myv' => 'ерзја',
 				'mzn' => 'мазандерански',
 				'na' => 'науруски',
 				'nap' => 'напуљски',
 				'naq' => 'нама',
 				'nb' => 'норвешки букмол',
 				'nd' => 'северни ндебеле',
 				'nds' => 'нисконемачки',
 				'nds_NL' => 'нискосаксонски',
 				'ne' => 'непалски',
 				'new' => 'невари',
 				'ng' => 'ндонга',
 				'nia' => 'ниас',
 				'niu' => 'ниуејски',
 				'nl' => 'холандски',
 				'nl_BE' => 'фламански',
 				'nmg' => 'квасио',
 				'nn' => 'норвешки нинорск',
 				'nnh' => 'нгиембун',
 				'no' => 'норвешки',
 				'nog' => 'ногајски',
 				'non' => 'старонордијски',
 				'nqo' => 'нко',
 				'nr' => 'јужни ндебеле',
 				'nso' => 'северни сото',
 				'nus' => 'нуер',
 				'nv' => 'навахо',
 				'nwc' => 'класични неварски',
 				'ny' => 'њанџа',
 				'nym' => 'њамвези',
 				'nyn' => 'њанколе',
 				'nyo' => 'њоро',
 				'nzi' => 'нзима',
 				'oc' => 'окситански',
 				'oj' => 'оџибве',
 				'om' => 'оромо',
 				'or' => 'одија',
 				'os' => 'осетински',
 				'osa' => 'осаге',
 				'ota' => 'османски турски',
 				'pa' => 'пенџапски',
 				'pag' => 'пангасинански',
 				'pal' => 'пахлави',
 				'pam' => 'пампанга',
 				'pap' => 'папијаменто',
 				'pau' => 'палауски',
 				'pcm' => 'нигеријски пиџин',
 				'peo' => 'староперсијски',
 				'phn' => 'феничански',
 				'pi' => 'пали',
 				'pl' => 'пољски',
 				'pon' => 'понпејски',
 				'prg' => 'пруски',
 				'pro' => 'староокситански',
 				'ps' => 'паштунски',
 				'ps@alt=variant' => 'пашто',
 				'pt' => 'португалски',
 				'pt_PT' => 'португалски (Португал)',
 				'qu' => 'кечуа',
 				'quc' => 'киче',
 				'raj' => 'раџастански',
 				'rap' => 'рапануи',
 				'rar' => 'раротонгански',
 				'rm' => 'романш',
 				'rn' => 'кирунди',
 				'ro' => 'румунски',
 				'ro_MD' => 'молдавски',
 				'rof' => 'ромбо',
 				'rom' => 'ромски',
 				'root' => 'рут',
 				'ru' => 'руски',
 				'rup' => 'цинцарски',
 				'rw' => 'кињаруанда',
 				'rwk' => 'руа',
 				'sa' => 'санскрит',
 				'sad' => 'сандаве',
 				'sah' => 'саха',
 				'sam' => 'самаријански арамејски',
 				'saq' => 'самбуру',
 				'sas' => 'сасак',
 				'sat' => 'сантали',
 				'sba' => 'нгамбај',
 				'sbp' => 'сангу',
 				'sc' => 'сардински',
 				'scn' => 'сицилијански',
 				'sco' => 'шкотски',
 				'sd' => 'синди',
 				'sdh' => 'јужнокурдски',
 				'se' => 'северни сами',
 				'seh' => 'сена',
 				'sel' => 'селкупски',
 				'ses' => 'којраборо сени',
 				'sg' => 'санго',
 				'sga' => 'староирски',
 				'sh' => 'српскохрватски',
 				'shi' => 'ташелхит',
 				'shn' => 'шански',
 				'si' => 'синхалешки',
 				'sid' => 'сидамо',
 				'sk' => 'словачки',
 				'sl' => 'словеначки',
 				'sm' => 'самоански',
 				'sma' => 'јужни сами',
 				'smj' => 'луле сами',
 				'smn' => 'инари сами',
 				'sms' => 'сколт сами',
 				'sn' => 'шона',
 				'snk' => 'сонинке',
 				'so' => 'сомалски',
 				'sog' => 'согдијски',
 				'sq' => 'албански',
 				'sr' => 'српски',
 				'srn' => 'сранан тонго',
 				'srr' => 'серерски',
 				'ss' => 'свази',
 				'ssy' => 'сахо',
 				'st' => 'сесото',
 				'su' => 'сундански',
 				'suk' => 'сукума',
 				'sus' => 'сусу',
 				'sux' => 'сумерски',
 				'sv' => 'шведски',
 				'sw' => 'свахили',
 				'sw_CD' => 'кисвахили',
 				'swb' => 'коморски',
 				'syc' => 'сиријачки',
 				'syr' => 'сиријски',
 				'ta' => 'тамилски',
 				'te' => 'телугу',
 				'tem' => 'тимне',
 				'teo' => 'тесо',
 				'ter' => 'терено',
 				'tet' => 'тетум',
 				'tg' => 'таџички',
 				'th' => 'тајски',
 				'ti' => 'тигриња',
 				'tig' => 'тигре',
 				'tiv' => 'тив',
 				'tk' => 'туркменски',
 				'tkl' => 'токелау',
 				'tl' => 'тагалог',
 				'tlh' => 'клингонски',
 				'tli' => 'тлингит',
 				'tmh' => 'тамашек',
 				'tn' => 'цвана',
 				'to' => 'тонгански',
 				'tog' => 'њаса тонга',
 				'tpi' => 'ток писин',
 				'tr' => 'турски',
 				'trv' => 'тароко',
 				'ts' => 'цонга',
 				'tsi' => 'цимшиан',
 				'tt' => 'татарски',
 				'tum' => 'тумбука',
 				'tvl' => 'тувалу',
 				'tw' => 'тви',
 				'twq' => 'тасавак',
 				'ty' => 'тахићански',
 				'tyv' => 'тувински',
 				'tzm' => 'централноатласки тамазигт',
 				'udm' => 'удмуртски',
 				'ug' => 'ујгурски',
 				'uga' => 'угаритски',
 				'uk' => 'украјински',
 				'umb' => 'умбунду',
 				'und' => 'непознат језик',
 				'ur' => 'урду',
 				'uz' => 'узбечки',
 				'vai' => 'ваи',
 				've' => 'венда',
 				'vi' => 'вијетнамски',
 				'vo' => 'волапик',
 				'vot' => 'водски',
 				'vun' => 'вунџо',
 				'wa' => 'валонски',
 				'wae' => 'валсерски',
 				'wal' => 'волајта',
 				'war' => 'варајски',
 				'was' => 'вашо',
 				'wbp' => 'варлпири',
 				'wo' => 'волоф',
 				'xal' => 'калмички',
 				'xh' => 'коса',
 				'xog' => 'сога',
 				'yao' => 'јао',
 				'yap' => 'јапски',
 				'yav' => 'јангбен',
 				'ybb' => 'јемба',
 				'yi' => 'јидиш',
 				'yo' => 'јоруба',
 				'yue' => 'кантонски',
 				'za' => 'џуаншки',
 				'zap' => 'запотечки',
 				'zbl' => 'блисимболи',
 				'zen' => 'зенага',
 				'zgh' => 'стандардни марокански тамазигт',
 				'zh' => 'кинески',
 				'zh_Hans' => 'поједностављени кинески',
 				'zh_Hant' => 'традиционални кинески',
 				'zu' => 'зулу',
 				'zun' => 'зуни',
 				'zxx' => 'без лингвистичког садржаја',
 				'zza' => 'заза',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'арапско писмо',
 			'Arab@alt=variant' => 'персијско-арапско писмо',
 			'Armi' => 'империјско арамејско писмо',
 			'Armn' => 'јерменско писмо',
 			'Avst' => 'авестанско писмо',
 			'Bali' => 'балијско писмо',
 			'Batk' => 'батак писмо',
 			'Beng' => 'бенгалско писмо',
 			'Blis' => 'блисимболично писмо',
 			'Bopo' => 'бопомофо писмо',
 			'Brah' => 'браманско писмо',
 			'Brai' => 'брајево писмо',
 			'Bugi' => 'бугинско писмо',
 			'Buhd' => 'бухидско писмо',
 			'Cakm' => 'чакманско писмо',
 			'Cans' => 'уједињени канадски абориџински силабици',
 			'Cari' => 'каријско писмо',
 			'Cham' => 'чамско писмо',
 			'Cher' => 'Чероки',
 			'Cirt' => 'цирт писмо',
 			'Copt' => 'коптичко писмо',
 			'Cprt' => 'кипарско писмо',
 			'Cyrl' => 'ћирилица',
 			'Cyrs' => 'Старословенска црквена ћирилица',
 			'Deva' => 'деванагари',
 			'Dsrt' => 'Дезерет',
 			'Egyd' => 'египатско народно писмо',
 			'Egyh' => 'египатско хијератско писмо',
 			'Egyp' => 'египатски хијероглифи',
 			'Ethi' => 'етиопско писмо',
 			'Geok' => 'грузијско кхутсури писмо',
 			'Geor' => 'грузијско писмо',
 			'Glag' => 'глагољица',
 			'Goth' => 'Готика',
 			'Grek' => 'грчко писмо',
 			'Gujr' => 'гуџаратско писмо',
 			'Guru' => 'гурмуки писмо',
 			'Hanb' => 'ханб',
 			'Hang' => 'хангул',
 			'Hani' => 'хан',
 			'Hano' => 'хануно',
 			'Hans' => 'поједностављено кинеско писмо',
 			'Hans@alt=stand-alone' => 'поједностављено хан писмо',
 			'Hant' => 'традиционално кинеско писмо',
 			'Hant@alt=stand-alone' => 'традиционално хан писмо',
 			'Hebr' => 'хебрејско писмо',
 			'Hira' => 'хирагана',
 			'Hmng' => 'пахав хмонг писмо',
 			'Hrkt' => 'јапанска слоговна писма',
 			'Hung' => 'старомађарско писмо',
 			'Inds' => 'индушко писмо',
 			'Ital' => 'стари италик',
 			'Jamo' => 'џамо',
 			'Java' => 'јаванско писмо',
 			'Jpan' => 'јапанско писмо',
 			'Kali' => 'кајах-ли писмо',
 			'Kana' => 'катакана',
 			'Khar' => 'карошти писмо',
 			'Khmr' => 'кмерско писмо',
 			'Knda' => 'канада писмо',
 			'Kore' => 'корејско писмо',
 			'Kthi' => 'каити',
 			'Lana' => 'ланна писмо',
 			'Laoo' => 'лаошко писмо',
 			'Latf' => 'латиница (фрактур варијанта)',
 			'Latg' => 'галска латиница',
 			'Latn' => 'латиница',
 			'Lepc' => 'лепча писмо',
 			'Limb' => 'лимбу писмо',
 			'Lina' => 'линеарно А писмо',
 			'Linb' => 'линеарно Б писмо',
 			'Lyci' => 'лисијско писмо',
 			'Lydi' => 'лидијско писмо',
 			'Mand' => 'мандеанско писмо',
 			'Mani' => 'манихејско писмо',
 			'Maya' => 'мајански хијероглифи',
 			'Mero' => 'мероитик писмо',
 			'Mlym' => 'малајаламско писмо',
 			'Mong' => 'монголско писмо',
 			'Moon' => 'месечево писмо',
 			'Mtei' => 'меитеи мајек писмо',
 			'Mymr' => 'мијанмарско писмо',
 			'Nkoo' => 'н’ко писмо',
 			'Ogam' => 'огамско писмо',
 			'Olck' => 'ол чики писмо',
 			'Orkh' => 'орконско писмо',
 			'Orya' => 'оријанско писмо',
 			'Osma' => 'осмањанско писмо',
 			'Perm' => 'старо пермикско писмо',
 			'Phag' => 'пагс-па писмо',
 			'Phli' => 'писани пахлави',
 			'Phlp' => 'псалтер пахлави',
 			'Phlv' => 'пахлави писмо',
 			'Phnx' => 'Феничанско писмо',
 			'Plrd' => 'поралд фонетско писмо',
 			'Prti' => 'писани партиан',
 			'Rjng' => 'рејанг писмо',
 			'Roro' => 'ронгоронго писмо',
 			'Runr' => 'рунско писмо',
 			'Samr' => 'самаританско писмо',
 			'Sara' => 'сарати писмо',
 			'Saur' => 'саураштра писмо',
 			'Sgnw' => 'знаковно писмо',
 			'Shaw' => 'шавијанско писмо',
 			'Sinh' => 'синхалско писмо',
 			'Sund' => 'сунданско писмо',
 			'Sylo' => 'силоти нагри писмо',
 			'Syrc' => 'сиријско писмо',
 			'Syre' => 'сиријско естрангело писмо',
 			'Syrj' => 'западносиријско писмо',
 			'Syrn' => 'писмо источне Сирије',
 			'Tagb' => 'тагбанва писмо',
 			'Tale' => 'таи ле писмо',
 			'Talu' => 'нови таи луе',
 			'Taml' => 'тамилско писмо',
 			'Tavt' => 'таи виет писмо',
 			'Telu' => 'телугу писмо',
 			'Teng' => 'тенгвар писмо',
 			'Tfng' => 'тифинаг писмо',
 			'Tglg' => 'Тагалог',
 			'Thaa' => 'тана писмо',
 			'Thai' => 'тајландско писмо',
 			'Tibt' => 'тибетанско писмо',
 			'Ugar' => 'угаритско писмо',
 			'Vaii' => 'ваи писмо',
 			'Visp' => 'видљиви говор',
 			'Xpeo' => 'староперсијско писмо',
 			'Xsux' => 'сумерско-акадско кунеиформ писмо',
 			'Yiii' => 'ји писмо',
 			'Zinh' => 'наследно писмо',
 			'Zmth' => 'математичка нотација',
 			'Zsye' => 'емоџи',
 			'Zsym' => 'симболи',
 			'Zxxx' => 'неписани језик',
 			'Zyyy' => 'заједничко писмо',
 			'Zzzz' => 'непознато писмо',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'свет',
 			'002' => 'Африка',
 			'003' => 'Северноамерички континент',
 			'005' => 'Јужна Америка',
 			'009' => 'Океанија',
 			'011' => 'Западна Африка',
 			'013' => 'Централна Америка',
 			'014' => 'Источна Африка',
 			'015' => 'Северна Африка',
 			'017' => 'Централна Африка',
 			'018' => 'Јужна Африка',
 			'019' => 'Северна и Јужна Америка',
 			'021' => 'Северна Америка',
 			'029' => 'Кариби',
 			'030' => 'Источна Азија',
 			'034' => 'Јужна Азија',
 			'035' => 'Југоисточна Азија',
 			'039' => 'Јужна Европа',
 			'053' => 'Аустралија и Нови Зеланд',
 			'054' => 'Меланезија',
 			'057' => 'Микронезијски регион',
 			'061' => 'Полинезија',
 			'142' => 'Азија',
 			'143' => 'Централна Азија',
 			'145' => 'Западна Азија',
 			'150' => 'Европа',
 			'151' => 'Источна Европа',
 			'154' => 'Северна Европа',
 			'155' => 'Западна Европа',
 			'202' => 'Африка јужно од Сахаре',
 			'419' => 'Латинска Америка',
 			'AC' => 'Острво Асенсион',
 			'AD' => 'Андора',
 			'AE' => 'Уједињени Арапски Емирати',
 			'AF' => 'Авганистан',
 			'AG' => 'Антигва и Барбуда',
 			'AI' => 'Ангвила',
 			'AL' => 'Албанија',
 			'AM' => 'Јерменија',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктик',
 			'AR' => 'Аргентина',
 			'AS' => 'Америчка Самоа',
 			'AT' => 'Аустрија',
 			'AU' => 'Аустралија',
 			'AW' => 'Аруба',
 			'AX' => 'Оландска Острва',
 			'AZ' => 'Азербејџан',
 			'BA' => 'Босна и Херцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Белгија',
 			'BF' => 'Буркина Фасо',
 			'BG' => 'Бугарска',
 			'BH' => 'Бахреин',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Свети Бартоломеј',
 			'BM' => 'Бермуда',
 			'BN' => 'Брунеј',
 			'BO' => 'Боливија',
 			'BQ' => 'Карипска Холандија',
 			'BR' => 'Бразил',
 			'BS' => 'Бахами',
 			'BT' => 'Бутан',
 			'BV' => 'Острво Буве',
 			'BW' => 'Боцвана',
 			'BY' => 'Белорусија',
 			'BZ' => 'Белизе',
 			'CA' => 'Канада',
 			'CC' => 'Кокосова (Килингова) Острва',
 			'CD' => 'Конго - Киншаса',
 			'CD@alt=variant' => 'Конго (ДРК)',
 			'CF' => 'Централноафричка Република',
 			'CG' => 'Конго - Бразавил',
 			'CG@alt=variant' => 'Конго (Република)',
 			'CH' => 'Швајцарска',
 			'CI' => 'Обала Слоноваче (Кот д’Ивоар)',
 			'CI@alt=variant' => 'Обала Слоноваче',
 			'CK' => 'Кукова Острва',
 			'CL' => 'Чиле',
 			'CM' => 'Камерун',
 			'CN' => 'Кина',
 			'CO' => 'Колумбија',
 			'CP' => 'Острво Клипертон',
 			'CR' => 'Костарика',
 			'CU' => 'Куба',
 			'CV' => 'Зеленортска Острва',
 			'CW' => 'Курасао',
 			'CX' => 'Божићно Острво',
 			'CY' => 'Кипар',
 			'CZ' => 'Чешка',
 			'CZ@alt=variant' => 'Чешка Република',
 			'DE' => 'Немачка',
 			'DG' => 'Дијего Гарсија',
 			'DJ' => 'Џибути',
 			'DK' => 'Данска',
 			'DM' => 'Доминика',
 			'DO' => 'Доминиканска Република',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута и Мелиља',
 			'EC' => 'Еквадор',
 			'EE' => 'Естонија',
 			'EG' => 'Египат',
 			'EH' => 'Западна Сахара',
 			'ER' => 'Еритреја',
 			'ES' => 'Шпанија',
 			'ET' => 'Етиопија',
 			'EU' => 'Европска Унија',
 			'EZ' => 'Еврозона',
 			'FI' => 'Финска',
 			'FJ' => 'Фиџи',
 			'FK' => 'Фокландска Острва',
 			'FK@alt=variant' => 'Фокландска (Малвинска) острва',
 			'FM' => 'Микронезија',
 			'FO' => 'Фарска Острва',
 			'FR' => 'Француска',
 			'GA' => 'Габон',
 			'GB' => 'Уједињено Краљевство',
 			'GB@alt=short' => 'УК',
 			'GD' => 'Гренада',
 			'GE' => 'Грузија',
 			'GF' => 'Француска Гвајана',
 			'GG' => 'Гернзи',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренланд',
 			'GM' => 'Гамбија',
 			'GN' => 'Гвинеја',
 			'GP' => 'Гваделуп',
 			'GQ' => 'Екваторијална Гвинеја',
 			'GR' => 'Грчка',
 			'GS' => 'Јужна Џорџија и Јужна Сендвичка Острва',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинеја-Бисао',
 			'GY' => 'Гвајана',
 			'HK' => 'САР Хонгконг (Кина)',
 			'HK@alt=short' => 'Хонгконг',
 			'HM' => 'Острво Херд и Мекдоналдова острва',
 			'HN' => 'Хондурас',
 			'HR' => 'Хрватска',
 			'HT' => 'Хаити',
 			'HU' => 'Мађарска',
 			'IC' => 'Канарска Острва',
 			'ID' => 'Индонезија',
 			'IE' => 'Ирска',
 			'IL' => 'Израел',
 			'IM' => 'Острво Ман',
 			'IN' => 'Индија',
 			'IO' => 'Британска територија Индијског океана',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исланд',
 			'IT' => 'Италија',
 			'JE' => 'Џерзи',
 			'JM' => 'Јамајка',
 			'JO' => 'Јордан',
 			'JP' => 'Јапан',
 			'KE' => 'Кенија',
 			'KG' => 'Киргистан',
 			'KH' => 'Камбоџа',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморска Острва',
 			'KN' => 'Сент Китс и Невис',
 			'KP' => 'Северна Кореја',
 			'KR' => 'Јужна Кореја',
 			'KW' => 'Кувајт',
 			'KY' => 'Кајманска Острва',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Либан',
 			'LC' => 'Света Луција',
 			'LI' => 'Лихтенштајн',
 			'LK' => 'Шри Ланка',
 			'LR' => 'Либерија',
 			'LS' => 'Лесото',
 			'LT' => 'Литванија',
 			'LU' => 'Луксембург',
 			'LV' => 'Летонија',
 			'LY' => 'Либија',
 			'MA' => 'Мароко',
 			'MC' => 'Монако',
 			'MD' => 'Молдавија',
 			'ME' => 'Црна Гора',
 			'MF' => 'Свети Мартин (Француска)',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалска Острва',
 			'MK' => 'Македонија',
 			'MK@alt=variant' => 'Македонија (БЈРМ)',
 			'ML' => 'Мали',
 			'MM' => 'Мијанмар (Бурма)',
 			'MN' => 'Монголија',
 			'MO' => 'САР Макао (Кина)',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Северна Маријанска Острва',
 			'MQ' => 'Мартиник',
 			'MR' => 'Мауританија',
 			'MS' => 'Монсерат',
 			'MT' => 'Малта',
 			'MU' => 'Маурицијус',
 			'MV' => 'Малдиви',
 			'MW' => 'Малави',
 			'MX' => 'Мексико',
 			'MY' => 'Малезија',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибија',
 			'NC' => 'Нова Каледонија',
 			'NE' => 'Нигер',
 			'NF' => 'Острво Норфок',
 			'NG' => 'Нигерија',
 			'NI' => 'Никарагва',
 			'NL' => 'Холандија',
 			'NO' => 'Норвешка',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуе',
 			'NZ' => 'Нови Зеланд',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Француска Полинезија',
 			'PG' => 'Папуа Нова Гвинеја',
 			'PH' => 'Филипини',
 			'PK' => 'Пакистан',
 			'PL' => 'Пољска',
 			'PM' => 'Сен Пјер и Микелон',
 			'PN' => 'Питкерн',
 			'PR' => 'Порторико',
 			'PS' => 'Палестинске територије',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалија',
 			'PW' => 'Палау',
 			'PY' => 'Парагвај',
 			'QA' => 'Катар',
 			'QO' => 'Океанија (удаљена острва)',
 			'RE' => 'Реинион',
 			'RO' => 'Румунија',
 			'RS' => 'Србија',
 			'RU' => 'Русија',
 			'RW' => 'Руанда',
 			'SA' => 'Саудијска Арабија',
 			'SB' => 'Соломонска Острва',
 			'SC' => 'Сејшели',
 			'SD' => 'Судан',
 			'SE' => 'Шведска',
 			'SG' => 'Сингапур',
 			'SH' => 'Света Јелена',
 			'SI' => 'Словенија',
 			'SJ' => 'Свалбард и Јан Мајен',
 			'SK' => 'Словачка',
 			'SL' => 'Сијера Леоне',
 			'SM' => 'Сан Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомалија',
 			'SR' => 'Суринам',
 			'SS' => 'Јужни Судан',
 			'ST' => 'Сао Томе и Принципе',
 			'SV' => 'Салвадор',
 			'SX' => 'Свети Мартин (Холандија)',
 			'SY' => 'Сирија',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан да Куња',
 			'TC' => 'Острва Туркс и Каикос',
 			'TD' => 'Чад',
 			'TF' => 'Француске Јужне Територије',
 			'TG' => 'Того',
 			'TH' => 'Тајланд',
 			'TJ' => 'Таџикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Тимор-Лесте (Источни Тимор)',
 			'TL@alt=variant' => 'Источни Тимор',
 			'TM' => 'Туркменистан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Турска',
 			'TT' => 'Тринидад и Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тајван',
 			'TZ' => 'Танзанија',
 			'UA' => 'Украјина',
 			'UG' => 'Уганда',
 			'UM' => 'Удаљена острва САД',
 			'UN' => 'Уједињене нације',
 			'UN@alt=short' => 'УН',
 			'US' => 'Сједињене Државе',
 			'US@alt=short' => 'САД',
 			'UY' => 'Уругвај',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент Винсент и Гренадини',
 			'VE' => 'Венецуела',
 			'VG' => 'Британска Девичанска Острва',
 			'VI' => 'Америчка Девичанска Острва',
 			'VN' => 'Вијетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Валис и Футуна',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Јемен',
 			'YT' => 'Мајот',
 			'ZA' => 'Јужноафричка Република',
 			'ZM' => 'Замбија',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Непознат регион',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'Традиционална немачка ортографија',
 			'1994' => 'Стандарднизована ресијанска ортографија',
 			'1996' => 'Немачка ортографија из 1996',
 			'1606NICT' => 'Француски из касног средњег века до 1606.',
 			'1694ACAD' => 'Рани модерни француски',
 			'1959ACAD' => 'Академски',
 			'AREVELA' => 'Источни арменијски',
 			'AREVMDA' => 'Западно јерменска',
 			'BAKU1926' => 'Уједињен турски латинични алфабет',
 			'BISKE' => 'Сан Ђорђио/Била дијалект',
 			'BOONT' => 'Бунтлинг',
 			'FONIPA' => 'ИПА фонетика',
 			'FONUPA' => 'УПА фонетика',
 			'KKCOR' => 'Уобичајена ортографија',
 			'LIPAW' => 'Липовички дијалект ресијански',
 			'MONOTON' => 'Монотоник',
 			'NEDIS' => 'Натисоне дијалект',
 			'NJIVA' => 'Гњива/Њива дијалкект',
 			'OSOJS' => 'Осеако/Осојане дијалект',
 			'POLYTON' => 'Политоник',
 			'POSIX' => 'Компјутер',
 			'REVISED' => 'Ревидирана ортографија',
 			'ROZAJ' => 'Ресијан',
 			'SAAHO' => 'Сахо',
 			'SCOTLAND' => 'Шкотски стандардни Енглески',
 			'SCOUSE' => 'Скауз',
 			'SOLBA' => 'Столвица/Солбица дијалект',
 			'TARASK' => 'Тараскијевичка ортографија',
 			'UCCOR' => 'Уједињена ортографија',
 			'UCRCOR' => 'Уједињена ревидирана ортографија',
 			'VALENCIA' => 'Валенцијска',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'календар',
 			'cf' => 'формат валуте',
 			'colalternate' => 'Сортирање уз игнорисање симбола',
 			'colbackwards' => 'Сортирање према обрнутим акцентима',
 			'colcasefirst' => 'Ређање према малом/великом слову',
 			'colcaselevel' => 'Сортирање према малом/великом слову',
 			'collation' => 'редослед сортирања',
 			'colnormalization' => 'Нормализовано сортирање',
 			'colnumeric' => 'Нумеричко сортирање',
 			'colstrength' => 'Сортирање према јачини',
 			'currency' => 'валута',
 			'hc' => 'приказивање времена (12- или 24-часовно)',
 			'lb' => 'стил прелома реда',
 			'ms' => 'систем мерних јединица',
 			'numbers' => 'бројеви',
 			'timezone' => 'Временска зона',
 			'va' => 'Варијанта локалитета',
 			'x' => 'Приватна употреба',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{будистички календар},
 				'chinese' => q{кинески календар},
 				'coptic' => q{коптски календар},
 				'dangi' => q{данги календар},
 				'ethiopic' => q{етиопски календар},
 				'ethiopic-amete-alem' => q{етиопски амет алем календар},
 				'gregorian' => q{грегоријански календар},
 				'hebrew' => q{хебрејски календар},
 				'indian' => q{Индијски национални календар},
 				'islamic' => q{исламски календар},
 				'islamic-civil' => q{Исламски цивилни календар},
 				'islamic-umalqura' => q{исламски календар (Umm al-Qura)},
 				'iso8601' => q{ISO-8601 календар},
 				'japanese' => q{јапански календар},
 				'persian' => q{персијски календар},
 				'roc' => q{календар Републике Кине},
 			},
 			'cf' => {
 				'account' => q{рачуноводствени формат валуте},
 				'standard' => q{стандардни формат валуте},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{Сортирај симболе},
 				'shifted' => q{Сортирање уз игнорисање симбола},
 			},
 			'colbackwards' => {
 				'no' => q{Сортирај акценте нормално},
 				'yes' => q{Сортирај акценте обрнуто},
 			},
 			'colcasefirst' => {
 				'lower' => q{Сортирај прво мала слова},
 				'no' => q{Сортирај нормалан редослед великих и малих слова},
 				'upper' => q{Сортирај прво велика слова},
 			},
 			'colcaselevel' => {
 				'no' => q{Сортирај без обзира на велика и мала слова},
 				'yes' => q{Сортирај мала и велика слова},
 			},
 			'collation' => {
 				'big5han' => q{Традиционално кинеско сортирање},
 				'compat' => q{претходни редослед сортирања, због компатибилности},
 				'dictionary' => q{Редослед сортирања у речнику},
 				'ducet' => q{подразумевани Unicode редослед сортирања},
 				'eor' => q{европска правила редоследа},
 				'gb2312han' => q{Поједностављено кинеско сортирање},
 				'phonebook' => q{Сортирање као телефонски именик},
 				'phonetic' => q{Фонетски редослед сортирања},
 				'pinyin' => q{Пињин сортирање},
 				'reformed' => q{Реформисани редослед сортирања},
 				'search' => q{претрага опште намене},
 				'searchjl' => q{Претрага према хангул почетном сугласнику},
 				'standard' => q{стандардни редослед сортирања},
 				'stroke' => q{Сортирање по броју црта},
 				'traditional' => q{Традиционално сортирање},
 				'unihan' => q{Редослед сортирања радикалним цртицама},
 			},
 			'colnormalization' => {
 				'no' => q{Сортирај без нормализације},
 				'yes' => q{Сортирај Unicode нормализовано},
 			},
 			'colnumeric' => {
 				'no' => q{Сортирај цифре појединачно},
 				'yes' => q{Сортирај цифре нумерички},
 			},
 			'colstrength' => {
 				'identical' => q{Сортирај све},
 				'primary' => q{Сортирај само основна слова},
 				'quaternary' => q{Сортирај акценте/мала и велика слова/ширину/кана симболе},
 				'secondary' => q{Сортирај акценте},
 				'tertiary' => q{Сортирај акценте/мала и велика слова/ширину},
 			},
 			'd0' => {
 				'fwidth' => q{пуна ширина},
 				'hwidth' => q{пола ширине},
 				'npinyin' => q{Нумеричка},
 			},
 			'hc' => {
 				'h11' => q{12-часовни систем (0-11)},
 				'h12' => q{12-часовни систем (1-12)},
 				'h23' => q{24-часовни систем (0-23)},
 				'h24' => q{24-часовни систем (1-24)},
 			},
 			'lb' => {
 				'loose' => q{размакнути стил прелома реда},
 				'normal' => q{нормални стил прелома реда},
 				'strict' => q{строги стил прелома реда},
 			},
 			'm0' => {
 				'bgn' => q{БГН (BGN)},
 				'ungegn' => q{УНГЕГН (BGN)},
 			},
 			'ms' => {
 				'metric' => q{метрички},
 				'uksystem' => q{империјални},
 				'ussystem' => q{амерички},
 			},
 			'numbers' => {
 				'arab' => q{арапско-индијске цифре},
 				'arabext' => q{продужене арапско-индијске цифре},
 				'armn' => q{јерменски бројеви},
 				'armnlow' => q{мали јерменски бројеви},
 				'beng' => q{бенгалске цифре},
 				'deva' => q{девангари цифре},
 				'ethi' => q{етиопски бројеви},
 				'finance' => q{Финансијски бројеви},
 				'fullwide' => q{цифре пуне ширине},
 				'geor' => q{грузијски бројеви},
 				'grek' => q{грчки бројеви},
 				'greklow' => q{мали грчки бројеви},
 				'gujr' => q{гуџаратске цифре},
 				'guru' => q{гурмуки цифре},
 				'hanidec' => q{кинески децимални бројеви},
 				'hans' => q{поједностављени кинески бројеви},
 				'hansfin' => q{поједностављени кинески финансијски бројеви},
 				'hant' => q{традиционални кинески бројеви},
 				'hantfin' => q{традиционални кинески финансијски бројеви},
 				'hebr' => q{хебрејски бројеви},
 				'jpan' => q{јапански бројеви},
 				'jpanfin' => q{јапански финансијски бројеви},
 				'khmr' => q{кмерске цифре},
 				'knda' => q{канада цифре},
 				'laoo' => q{лаошке цифре},
 				'latn' => q{западне цифре},
 				'mlym' => q{малајалам цифре},
 				'mong' => q{монголске цифре},
 				'mymr' => q{мијанмарске цифре},
 				'native' => q{Локалне цифре},
 				'orya' => q{орија цифре},
 				'roman' => q{римски бројеви},
 				'romanlow' => q{мали римски бројеви},
 				'taml' => q{тамилски бројеви},
 				'tamldec' => q{тамилске цифре},
 				'telu' => q{телугу цифре},
 				'thai' => q{тајске цифре},
 				'tibt' => q{тибетанске цифре},
 				'traditional' => q{Традиционални бројеви},
 				'vaii' => q{Ваи цифре},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{Метрички},
 			'UK' => q{УК},
 			'US' => q{САД},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'Језик: {0}',
 			'script' => 'Писмо: {0}',
 			'region' => 'Регион: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[ё й щ ъ ы ь э ю я]},
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Ђ', 'Е', 'Ж', 'З', 'И', 'Ј', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'Ћ', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш'],
			main => qr{[а б в г д ђ е ж з и ј к л љ м н њ о п р с т ћ у ф х ц ч џ ш]},
			numbers => qr{[\- , . % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[\- ‐ – , ; \: ! ? . … ‘ ‚ “ „ ( ) \[ \] \{ \} * #]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Д', 'Ђ', 'Е', 'Ж', 'З', 'И', 'Ј', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'Ћ', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{„},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'' => {
						'name' => q(главни правац),
					},
					'acre' => {
						'few' => q({0} акера),
						'name' => q(акери),
						'one' => q({0} акер),
						'other' => q({0} акера),
					},
					'acre-foot' => {
						'few' => q({0} акер стопе),
						'name' => q(акер стопе),
						'one' => q({0} акер стопа),
						'other' => q({0} акер стопа),
					},
					'ampere' => {
						'few' => q({0} ампера),
						'name' => q(ампери),
						'one' => q({0} ампер),
						'other' => q({0} ампера),
					},
					'arc-minute' => {
						'few' => q({0} лучна минута),
						'name' => q(лучни минути),
						'one' => q({0} лучни минут),
						'other' => q({0} лучних минута),
					},
					'arc-second' => {
						'few' => q({0} лучне секунде),
						'name' => q(лучне секунде),
						'one' => q({0} лучна секунда),
						'other' => q({0} лучних секунди),
					},
					'astronomical-unit' => {
						'few' => q({0} астрономске јединице),
						'name' => q(астрономске јединице),
						'one' => q({0} астрономска јединица),
						'other' => q({0} астрономских јединица),
					},
					'atmosphere' => {
						'few' => q({0} атмосфере),
						'name' => q(атмосфере),
						'one' => q({0} атмосфера),
						'other' => q({0} атмосфера),
					},
					'bit' => {
						'few' => q({0} бита),
						'name' => q(битови),
						'one' => q({0} бит),
						'other' => q({0} битова),
					},
					'byte' => {
						'few' => q({0} бајта),
						'name' => q(бајтови),
						'one' => q({0} бајт),
						'other' => q({0} бајтова),
					},
					'calorie' => {
						'few' => q({0} калорије),
						'name' => q(калорије),
						'one' => q({0} калорија),
						'other' => q({0} калорија),
					},
					'carat' => {
						'few' => q({0} карата),
						'name' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					'celsius' => {
						'few' => q({0} степена Целзијуса),
						'name' => q(степени Целзијуса),
						'one' => q({0} степен Целзијуса),
						'other' => q({0} степени Целзијуса),
					},
					'centiliter' => {
						'few' => q({0} центилитра),
						'name' => q(центилитри),
						'one' => q({0} центилитар),
						'other' => q({0} центилитара),
					},
					'centimeter' => {
						'few' => q({0} центиментра),
						'name' => q(центиметри),
						'one' => q({0} центиметар),
						'other' => q({0} центиметара),
						'per' => q({0}/cm),
					},
					'century' => {
						'few' => q({0} века),
						'name' => q(векови),
						'one' => q({0} век),
						'other' => q({0} векова),
					},
					'coordinate' => {
						'east' => q({0}И),
						'north' => q({0}С),
						'south' => q({0}Ј),
						'west' => q({0}З),
					},
					'cubic-centimeter' => {
						'few' => q({0} кубна центиметра),
						'name' => q(кубни центиметри),
						'one' => q({0} кубни центиметар),
						'other' => q({0} кубних центиметара),
						'per' => q({0}/cm³),
					},
					'cubic-foot' => {
						'few' => q({0} кубне стопе),
						'name' => q(кубне стопе),
						'one' => q({0} кубна стопа),
						'other' => q({0} кубних стопа),
					},
					'cubic-inch' => {
						'few' => q({0} кубна инча),
						'name' => q(кубни инчи),
						'one' => q({0} кубни инч),
						'other' => q({0} кубних инча),
					},
					'cubic-kilometer' => {
						'few' => q({0} кубна километра),
						'name' => q(кубни километри),
						'one' => q({0} кубни километар),
						'other' => q({0} кубних километара),
					},
					'cubic-meter' => {
						'few' => q({0} кубна метра),
						'name' => q(кубни метри),
						'one' => q({0} кубни метар),
						'other' => q({0} кубних метара),
						'per' => q({0}/m³),
					},
					'cubic-mile' => {
						'few' => q({0} кубне миље),
						'name' => q(кубне миље),
						'one' => q({0} кубна миља),
						'other' => q({0} кубних миља),
					},
					'cubic-yard' => {
						'few' => q({0} кубна јарда),
						'name' => q(кубни јарди),
						'one' => q({0} кубни јард),
						'other' => q({0} кубних јарди),
					},
					'cup' => {
						'few' => q({0} шоље),
						'name' => q(шоље),
						'one' => q({0} шоља),
						'other' => q({0} шоља),
					},
					'cup-metric' => {
						'few' => q({0} метричке шоље),
						'name' => q(метричка шоља),
						'one' => q({0} метричка шоља),
						'other' => q({0} метричких шоља),
					},
					'day' => {
						'few' => q({0} дана),
						'name' => q(дани),
						'one' => q({0} дан),
						'other' => q({0} дана),
						'per' => q({0}/дневно),
					},
					'deciliter' => {
						'few' => q({0} децилитра),
						'name' => q(децилитри),
						'one' => q({0} децилитар),
						'other' => q({0} децилитара),
					},
					'decimeter' => {
						'few' => q({0} дециметра),
						'name' => q(дециметри),
						'one' => q({0} дециметар),
						'other' => q({0} дециметара),
					},
					'degree' => {
						'few' => q({0} степена),
						'name' => q(степени),
						'one' => q({0} степен),
						'other' => q({0} степени),
					},
					'fahrenheit' => {
						'few' => q({0} степена Фаренхајта),
						'name' => q(степени Фаренхајта),
						'one' => q({0} степен Фаренхајта),
						'other' => q({0} степени Фаренхајта),
					},
					'fluid-ounce' => {
						'few' => q({0} унце течности),
						'name' => q(унце течности),
						'one' => q({0} унца течности),
						'other' => q({0} унци течности),
					},
					'foodcalorie' => {
						'few' => q({0} калорије),
						'name' => q(Калорије),
						'one' => q({0} калорија),
						'other' => q({0} калорија),
					},
					'foot' => {
						'few' => q({0} стопе),
						'name' => q(стопе),
						'one' => q({0} стопа),
						'other' => q({0} стопа),
						'per' => q({0}/ft),
					},
					'g-force' => {
						'few' => q({0} ге сила),
						'name' => q(ге сила),
						'one' => q({0} ге сила),
						'other' => q({0} ге сила),
					},
					'gallon' => {
						'few' => q({0} галона),
						'name' => q(галони),
						'one' => q({0} галон),
						'other' => q({0} галона),
						'per' => q({0} по галону),
					},
					'gallon-imperial' => {
						'few' => q({0} имп. галона),
						'name' => q(империјални галон),
						'one' => q({0} имп. галон),
						'other' => q({0} имп. галона),
						'per' => q({0} по имп. галону),
					},
					'generic' => {
						'few' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'few' => q({0} гигабита),
						'name' => q(гигабитови),
						'one' => q({0} гигабит),
						'other' => q({0} гигабита),
					},
					'gigabyte' => {
						'few' => q({0} гигабајта),
						'name' => q(гигабајти),
						'one' => q({0} гигабајт),
						'other' => q({0} гигабајта),
					},
					'gigahertz' => {
						'few' => q({0} гигахерца),
						'name' => q(гигахерци),
						'one' => q({0} гигахерц),
						'other' => q({0} гигахерца),
					},
					'gigawatt' => {
						'few' => q({0} гигавата),
						'name' => q(гигавати),
						'one' => q({0} гигават),
						'other' => q({0} гигавати),
					},
					'gram' => {
						'few' => q({0} грама),
						'name' => q(грами),
						'one' => q({0} грам),
						'other' => q({0} грама),
						'per' => q({0} по граму),
					},
					'hectare' => {
						'few' => q({0} хектара),
						'name' => q(хектари),
						'one' => q({0} хектар),
						'other' => q({0} хектара),
					},
					'hectoliter' => {
						'few' => q({0} хектолитра),
						'name' => q(хектолитри),
						'one' => q({0} хектолитар),
						'other' => q({0} хектолитара),
					},
					'hectopascal' => {
						'few' => q({0} хектопаскала),
						'name' => q(хектопаскали),
						'one' => q({0} хектопаскал),
						'other' => q({0} хектопаскала),
					},
					'hertz' => {
						'few' => q({0} херца),
						'name' => q(херци),
						'one' => q({0} херц),
						'other' => q({0} херца),
					},
					'horsepower' => {
						'few' => q({0} коњске снаге),
						'name' => q(коњске снаге),
						'one' => q({0} коњска снага),
						'other' => q({0} коњских снага),
					},
					'hour' => {
						'few' => q({0} сата),
						'name' => q(сати),
						'one' => q({0} сат),
						'other' => q({0} сати),
						'per' => q({0}/сат),
					},
					'inch' => {
						'few' => q({0} инча),
						'name' => q(инчи),
						'one' => q({0} инч),
						'other' => q({0} инча),
						'per' => q({0}/in),
					},
					'inch-hg' => {
						'few' => q({0} инча живиног стуба),
						'name' => q(инчи живиног стуба),
						'one' => q({0} инч живиног стуба),
						'other' => q({0} инча живиног стуба),
					},
					'joule' => {
						'few' => q({0} џула),
						'name' => q(џули),
						'one' => q({0} џул),
						'other' => q({0} џула),
					},
					'karat' => {
						'few' => q({0} карата),
						'name' => q(карати),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					'kelvin' => {
						'few' => q({0} келвина),
						'name' => q(келвин),
						'one' => q({0} келвин),
						'other' => q({0} келвина),
					},
					'kilobit' => {
						'few' => q({0} килобита),
						'name' => q(килобитови),
						'one' => q({0} килобит),
						'other' => q({0} килобита),
					},
					'kilobyte' => {
						'few' => q({0} килобајта),
						'name' => q(килобајти),
						'one' => q({0} килобајт),
						'other' => q({0} килобајта),
					},
					'kilocalorie' => {
						'few' => q({0} килокалорије),
						'name' => q(килокалорије),
						'one' => q({0} килокалорија),
						'other' => q({0} килокалорија),
					},
					'kilogram' => {
						'few' => q({0} килограма),
						'name' => q(килограми),
						'one' => q({0} килограм),
						'other' => q({0} килограма),
						'per' => q({0} по килограму),
					},
					'kilohertz' => {
						'few' => q({0} килохерца),
						'name' => q(килохерци),
						'one' => q({0} килохерц),
						'other' => q({0} килохерца),
					},
					'kilojoule' => {
						'few' => q({0} килоџула),
						'name' => q(килоџули),
						'one' => q({0} килоџул),
						'other' => q({0} килоџула),
					},
					'kilometer' => {
						'few' => q({0} километра),
						'name' => q(километри),
						'one' => q({0} километар),
						'other' => q({0} километара),
						'per' => q({0}/km),
					},
					'kilometer-per-hour' => {
						'few' => q({0} километра на сат),
						'name' => q(километри на сат),
						'one' => q({0} километар на сат),
						'other' => q({0} километара на сат),
					},
					'kilowatt' => {
						'few' => q({0} киловата),
						'name' => q(киловати),
						'one' => q({0} киловат),
						'other' => q({0} киловати),
					},
					'kilowatt-hour' => {
						'few' => q({0} киловат-сата),
						'name' => q(киловат-сати),
						'one' => q({0} киловат-сат),
						'other' => q({0} киловат-сати),
					},
					'knot' => {
						'few' => q({0} чвора),
						'name' => q(чвор),
						'one' => q({0} чвор),
						'other' => q({0} чворова),
					},
					'light-year' => {
						'few' => q({0} светлосне године),
						'name' => q(светлосне године),
						'one' => q({0} светлосна година),
						'other' => q({0} светлосних година),
					},
					'liter' => {
						'few' => q({0} литра),
						'name' => q(литри),
						'one' => q({0} литар),
						'other' => q({0} литара),
						'per' => q({0} по литри),
					},
					'liter-per-100kilometers' => {
						'few' => q({0} литра на 100 километара),
						'name' => q(L/100km),
						'one' => q({0} литар на 100 километара),
						'other' => q({0} литара на 100 километара),
					},
					'liter-per-kilometer' => {
						'few' => q({0} литра по километру),
						'name' => q(литри по километру),
						'one' => q({0} литар по километру),
						'other' => q({0} литара по километру),
					},
					'lux' => {
						'few' => q({0} лукса),
						'name' => q(лукс),
						'one' => q({0} лукс),
						'other' => q({0} лукса),
					},
					'megabit' => {
						'few' => q({0} мегабита),
						'name' => q(мегабитови),
						'one' => q({0} мегабит),
						'other' => q({0} мегабита),
					},
					'megabyte' => {
						'few' => q({0} мегабајта),
						'name' => q(мегабајти),
						'one' => q({0} мегабајт),
						'other' => q({0} мегабајта),
					},
					'megahertz' => {
						'few' => q({0} мегахерца),
						'name' => q(мегахерци),
						'one' => q({0} мегахерц),
						'other' => q({0} мегахерца),
					},
					'megaliter' => {
						'few' => q({0} мегалитра),
						'name' => q(мегалитри),
						'one' => q({0} мегалитар),
						'other' => q({0} мегалитара),
					},
					'megawatt' => {
						'few' => q({0} мегавата),
						'name' => q(мегавати),
						'one' => q({0} мегават),
						'other' => q({0} мегавати),
					},
					'meter' => {
						'few' => q({0} метра),
						'name' => q(метри),
						'one' => q({0} метар),
						'other' => q({0} метара),
						'per' => q({0}/m),
					},
					'meter-per-second' => {
						'few' => q({0} метра у секунди),
						'name' => q(метри у секунди),
						'one' => q({0} метар у секунди),
						'other' => q({0} метара у секунди),
					},
					'meter-per-second-squared' => {
						'few' => q({0} метра у секунди на квадрат),
						'name' => q(метри у секунди на квадрат),
						'one' => q({0} метар у секунди на квадрат),
						'other' => q({0} метара у секунди на квадрат),
					},
					'metric-ton' => {
						'few' => q({0} метричке тоне),
						'name' => q(метричке тоне),
						'one' => q({0} метричка тона),
						'other' => q({0} метричких тона),
					},
					'microgram' => {
						'few' => q({0} микрограма),
						'name' => q(микрограми),
						'one' => q({0} микрограм),
						'other' => q({0} микрограма),
					},
					'micrometer' => {
						'few' => q({0} микрометра),
						'name' => q(микрометри),
						'one' => q({0} микрометар),
						'other' => q({0} микрометара),
					},
					'microsecond' => {
						'few' => q({0} микросекунде),
						'name' => q(микросекунде),
						'one' => q({0} микросекунда),
						'other' => q({0} микросекунди),
					},
					'mile' => {
						'few' => q({0} миље),
						'name' => q(миље),
						'one' => q({0} миља),
						'other' => q({0} миља),
					},
					'mile-per-gallon' => {
						'few' => q({0} миље по галону),
						'name' => q(миља по галону),
						'one' => q({0} миља по галону),
						'other' => q({0} миља по галону),
					},
					'mile-per-gallon-imperial' => {
						'few' => q({0} миље по империјалном галону),
						'name' => q(миља по империјалном галону),
						'one' => q({0} миља по империјалном галону),
						'other' => q({0} миља по империјалном галону),
					},
					'mile-per-hour' => {
						'few' => q({0} миље на сат),
						'name' => q(миље на сат),
						'one' => q({0} миља на сат),
						'other' => q({0} миља на сат),
					},
					'mile-scandinavian' => {
						'few' => q({0} скандинавске миље),
						'name' => q(скандинавска миља),
						'one' => q({0} скандинавска миља),
						'other' => q({0} скандинавских миља),
					},
					'milliampere' => {
						'few' => q({0} милиампера),
						'name' => q(милиампери),
						'one' => q({0} милиампер),
						'other' => q({0} милиампера),
					},
					'millibar' => {
						'few' => q({0} милибара),
						'name' => q(милибари),
						'one' => q({0} милибар),
						'other' => q({0} милибара),
					},
					'milligram' => {
						'few' => q({0} милиграма),
						'name' => q(милиграми),
						'one' => q({0} милиграм),
						'other' => q({0} милиграма),
					},
					'milligram-per-deciliter' => {
						'few' => q({0} милиграма по децилитру),
						'name' => q(милиграми по децилитру),
						'one' => q({0} милиграм по децилитру),
						'other' => q({0} милиграма по децилитру),
					},
					'milliliter' => {
						'few' => q({0} милилитра),
						'name' => q(милилитри),
						'one' => q({0} милилитар),
						'other' => q({0} милилитара),
					},
					'millimeter' => {
						'few' => q({0} милиметра),
						'name' => q(милиметри),
						'one' => q({0} милиметар),
						'other' => q({0} милиметара),
					},
					'millimeter-of-mercury' => {
						'few' => q({0} милиметра живиног стуба),
						'name' => q(милиметри живиног стуба),
						'one' => q({0} милиметар живиног стуба),
						'other' => q({0} милиметара живиног стуба),
					},
					'millimole-per-liter' => {
						'few' => q({0} милимола по литри),
						'name' => q(милимол по литри),
						'one' => q({0} милимол по литри),
						'other' => q({0} милимола по литри),
					},
					'millisecond' => {
						'few' => q({0} милисекунде),
						'name' => q(милисекунде),
						'one' => q({0} милисекунда),
						'other' => q({0} милисекунди),
					},
					'milliwatt' => {
						'few' => q({0} миливата),
						'name' => q(миливати),
						'one' => q({0} миливат),
						'other' => q({0} миливати),
					},
					'minute' => {
						'few' => q({0} минута),
						'name' => q(минути),
						'one' => q({0} минут),
						'other' => q({0} минута),
						'per' => q({0} у минуту),
					},
					'month' => {
						'few' => q({0} месеца),
						'name' => q(месеци),
						'one' => q({0} месец),
						'other' => q({0} месеци),
						'per' => q({0} месечно),
					},
					'nanometer' => {
						'few' => q({0} нанометра),
						'name' => q(нанометри),
						'one' => q({0} нанометар),
						'other' => q({0} нанометара),
					},
					'nanosecond' => {
						'few' => q({0} наносекунде),
						'name' => q(наносекунде),
						'one' => q({0} наносекунда),
						'other' => q({0} наносекунди),
					},
					'nautical-mile' => {
						'few' => q({0} наутичке миље),
						'name' => q(наутичке миље),
						'one' => q({0} наутичка миља),
						'other' => q({0} наутичких миља),
					},
					'ohm' => {
						'few' => q({0} ома),
						'name' => q(оми),
						'one' => q({0} ом),
						'other' => q({0} ома),
					},
					'ounce' => {
						'few' => q({0} унце),
						'name' => q(унце),
						'one' => q({0} унца),
						'other' => q({0} унци),
						'per' => q({0} по унци),
					},
					'ounce-troy' => {
						'few' => q({0} фине унце),
						'name' => q(фине унце),
						'one' => q({0} фина унца),
						'other' => q({0} финих унци),
					},
					'parsec' => {
						'few' => q({0} парсека),
						'name' => q(парсеци),
						'one' => q({0} парсек),
						'other' => q({0} парсека),
					},
					'part-per-million' => {
						'few' => q({0} честице на милион),
						'name' => q(честица на милион),
						'one' => q({0} честица на милион),
						'other' => q({0} честица на милион),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'few' => q({0} процената),
						'name' => q(проценат),
						'one' => q({0} проценат),
						'other' => q({0} процената),
					},
					'permille' => {
						'few' => q({0} промила),
						'name' => q(промил),
						'one' => q({0} промил),
						'other' => q({0} промила),
					},
					'petabyte' => {
						'few' => q({0} петабајта),
						'name' => q(петабајти),
						'one' => q({0} петабајт),
						'other' => q({0} петабајта),
					},
					'picometer' => {
						'few' => q({0} пикометра),
						'name' => q(пикометри),
						'one' => q({0} пикометар),
						'other' => q({0} пикометара),
					},
					'pint' => {
						'few' => q({0} пинте),
						'name' => q(пинте),
						'one' => q({0} пинта),
						'other' => q({0} пинти),
					},
					'pint-metric' => {
						'few' => q({0} метричке пинте),
						'name' => q(метричке пинте),
						'one' => q({0} метричка пинта),
						'other' => q({0} метричких пинти),
					},
					'point' => {
						'few' => q({0} pt),
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pound' => {
						'few' => q({0} фунте),
						'name' => q(фунте),
						'one' => q({0} фунта),
						'other' => q({0} фунти),
						'per' => q({0} по фунти),
					},
					'pound-per-square-inch' => {
						'few' => q({0} фунте по квадратном инчу),
						'name' => q(фунте по квадратном инчу),
						'one' => q({0} фунта по квадратном инчу),
						'other' => q({0} фунти по квадратном инчу),
					},
					'quart' => {
						'few' => q({0} кварта),
						'name' => q(кварти),
						'one' => q({0} кварат),
						'other' => q({0} кварата),
					},
					'radian' => {
						'few' => q({0} радијана),
						'name' => q(радијани),
						'one' => q({0} радијан),
						'other' => q({0} радијана),
					},
					'revolution' => {
						'few' => q({0} обртаја),
						'name' => q(обртај),
						'one' => q({0} обртај),
						'other' => q({0} обртаја),
					},
					'second' => {
						'few' => q({0} секунде),
						'name' => q(секунде),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
						'per' => q({0}/у секунди),
					},
					'square-centimeter' => {
						'few' => q({0} квадратна центиметра),
						'name' => q(квадратни центиметри),
						'one' => q({0} квадратни центиметар),
						'other' => q({0} квадратних центиметара),
						'per' => q({0}/cm²),
					},
					'square-foot' => {
						'few' => q({0} квадратне стопе),
						'name' => q(квадратне стопе),
						'one' => q({0} квадратна стопа),
						'other' => q({0} квадратних стопа),
					},
					'square-inch' => {
						'few' => q({0} квадратна инча),
						'name' => q(квадратни инчи),
						'one' => q({0} квадратни инч),
						'other' => q({0} квадратних инча),
						'per' => q({0}/in²),
					},
					'square-kilometer' => {
						'few' => q({0} квадратна километра),
						'name' => q(квадратни километри),
						'one' => q({0} квадратни километар),
						'other' => q({0} квадратних километара),
						'per' => q({0} по квадратном километру),
					},
					'square-meter' => {
						'few' => q({0} квадратна метра),
						'name' => q(квадратни метри),
						'one' => q({0} квадратни метар),
						'other' => q({0} квадратних метара),
						'per' => q({0}/m²),
					},
					'square-mile' => {
						'few' => q({0} квадратне миље),
						'name' => q(квадратне миље),
						'one' => q({0} квадратна миља),
						'other' => q({0} квадратних миља),
						'per' => q({0} по квадратној миљи),
					},
					'square-yard' => {
						'few' => q({0} квадратна јарда),
						'name' => q(квадратни јарди),
						'one' => q({0} квадратни јард),
						'other' => q({0} квадратних јарди),
					},
					'tablespoon' => {
						'few' => q({0} кашике),
						'name' => q(кашике),
						'one' => q({0} кашика),
						'other' => q({0} кашика),
					},
					'teaspoon' => {
						'few' => q({0} кашичице),
						'name' => q(кашичице),
						'one' => q({0} кашичица),
						'other' => q({0} кашичица),
					},
					'terabit' => {
						'few' => q({0} терабита),
						'name' => q(терабитови),
						'one' => q({0} терабит),
						'other' => q({0} терабита),
					},
					'terabyte' => {
						'few' => q({0} терабајта),
						'name' => q(терабајти),
						'one' => q({0} терабајт),
						'other' => q({0} терабајта),
					},
					'ton' => {
						'few' => q({0} тоне),
						'name' => q(тоне),
						'one' => q({0} тона),
						'other' => q({0} тона),
					},
					'volt' => {
						'few' => q({0} волта),
						'name' => q(волти),
						'one' => q({0} волт),
						'other' => q({0} волти),
					},
					'watt' => {
						'few' => q({0} вата),
						'name' => q(вати),
						'one' => q({0} ват),
						'other' => q({0} вати),
					},
					'week' => {
						'few' => q({0} недеље),
						'name' => q(недеље),
						'one' => q({0} недеља),
						'other' => q({0} недеља),
						'per' => q({0} недељно),
					},
					'yard' => {
						'few' => q({0} јарда),
						'name' => q(јарди),
						'one' => q({0} јард),
						'other' => q({0} јарди),
					},
					'year' => {
						'few' => q({0} године),
						'name' => q(године),
						'one' => q({0} година),
						'other' => q({0} година),
						'per' => q({0} годишње),
					},
				},
				'narrow' => {
					'' => {
						'name' => q(правац),
					},
					'acre' => {
						'few' => q({0} ac),
						'one' => q({0} ac),
						'other' => q({0} ac),
					},
					'arc-minute' => {
						'few' => q({0}′),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'few' => q({0}″),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'few' => q({0}°C),
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'few' => q({0} cm),
						'name' => q(cm),
						'one' => q({0} cm),
						'other' => q({0} cm),
					},
					'coordinate' => {
						'east' => q({0}И),
						'north' => q({0}С),
						'south' => q({0}Ј),
						'west' => q({0}З),
					},
					'cubic-kilometer' => {
						'few' => q({0} km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'few' => q({0} mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					'day' => {
						'few' => q({0} д),
						'name' => q(д),
						'one' => q({0} д),
						'other' => q({0} д),
					},
					'degree' => {
						'few' => q({0}°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'few' => q({0}°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'few' => q({0} ft),
						'name' => q(ft),
						'one' => q({0} ft),
						'other' => q({0} ft),
					},
					'g-force' => {
						'few' => q({0} G),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'few' => q({0} g),
						'name' => q(g),
						'one' => q({0} g),
						'other' => q({0} g),
					},
					'hectare' => {
						'few' => q({0} ha),
						'one' => q({0} ha),
						'other' => q({0} ha),
					},
					'hectopascal' => {
						'few' => q({0} hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'few' => q({0} кс),
						'one' => q({0} кс),
						'other' => q({0} кс),
					},
					'hour' => {
						'few' => q({0} ч),
						'name' => q(ч),
						'one' => q({0} ч),
						'other' => q({0} ч),
					},
					'inch' => {
						'few' => q({0} инча),
						'one' => q({0} инч),
						'other' => q({0} инча),
					},
					'inch-hg' => {
						'few' => q({0} inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'few' => q({0} kg),
						'name' => q(kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
					},
					'kilometer' => {
						'few' => q({0} km),
						'name' => q(km),
						'one' => q({0} km),
						'other' => q({0} km),
					},
					'kilometer-per-hour' => {
						'few' => q({0} km/h),
						'name' => q(km/h),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'few' => q({0} kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'light-year' => {
						'few' => q({0} сг),
						'one' => q({0} сг),
						'other' => q({0} сг),
					},
					'liter' => {
						'few' => q({0} l),
						'name' => q(l),
						'one' => q({0} l),
						'other' => q({0} l),
					},
					'liter-per-100kilometers' => {
						'few' => q({0} L/100km),
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					'meter' => {
						'few' => q({0} m),
						'name' => q(m),
						'one' => q({0} m),
						'other' => q({0} m),
					},
					'meter-per-second' => {
						'few' => q({0} m/s),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'mile' => {
						'few' => q({0} миље),
						'one' => q({0} миља),
						'other' => q({0} миља),
					},
					'mile-per-hour' => {
						'few' => q({0} mi/h),
						'one' => q({0} mi/h),
						'other' => q({0} mi/h),
					},
					'millibar' => {
						'few' => q({0} mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'millimeter' => {
						'few' => q({0} mm),
						'name' => q(mm),
						'one' => q({0} mm),
						'other' => q({0} mm),
					},
					'millisecond' => {
						'few' => q({0} ms),
						'name' => q(ms),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'few' => q({0} м),
						'name' => q(мин),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'month' => {
						'few' => q({0} м),
						'name' => q(м.),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'ounce' => {
						'few' => q({0} унце),
						'one' => q({0} унца),
						'other' => q({0} унци),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'few' => q({0}%),
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'picometer' => {
						'few' => q({0} pm),
						'one' => q({0} pm),
						'other' => q({0} pm),
					},
					'pound' => {
						'few' => q({0} lb),
						'one' => q({0} lb),
						'other' => q({0} lb),
					},
					'second' => {
						'few' => q({0} с),
						'name' => q(с),
						'one' => q({0} с),
						'other' => q({0} с),
					},
					'square-foot' => {
						'few' => q({0} ft²),
						'one' => q({0} ft²),
						'other' => q({0} ft²),
					},
					'square-kilometer' => {
						'few' => q({0} km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'few' => q({0} m²),
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'few' => q({0} mi²),
						'one' => q({0} mi²),
						'other' => q({0} mi²),
					},
					'watt' => {
						'few' => q({0} W),
						'one' => q({0} W),
						'other' => q({0} W),
					},
					'week' => {
						'few' => q({0} н),
						'name' => q(н.),
						'one' => q({0} н),
						'other' => q({0} н),
					},
					'yard' => {
						'few' => q({0} јрд),
						'one' => q({0} јрд),
						'other' => q({0} јрд),
					},
					'year' => {
						'few' => q({0} г),
						'name' => q(г.),
						'one' => q({0} г),
						'other' => q({0} г),
					},
				},
				'short' => {
					'' => {
						'name' => q(правац),
					},
					'acre' => {
						'few' => q({0} ac),
						'name' => q(акери),
						'one' => q({0} ac),
						'other' => q({0} ac),
					},
					'acre-foot' => {
						'few' => q({0} ac ft),
						'name' => q(ac ft),
						'one' => q({0} ac ft),
						'other' => q({0} ac ft),
					},
					'ampere' => {
						'few' => q({0} A),
						'name' => q(A),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'few' => q({0}′),
						'name' => q(лучни мин),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'few' => q({0}″),
						'name' => q(лучне сек),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'astronomical-unit' => {
						'few' => q({0} ај),
						'name' => q(ај),
						'one' => q({0} ај),
						'other' => q({0} ај),
					},
					'atmosphere' => {
						'few' => q({0} atm),
						'name' => q(atm),
						'one' => q({0} atm),
						'other' => q({0} atm),
					},
					'bit' => {
						'few' => q({0} b),
						'name' => q(бит),
						'one' => q({0} b),
						'other' => q({0} b),
					},
					'byte' => {
						'few' => q({0} B),
						'name' => q(бајт),
						'one' => q({0} B),
						'other' => q({0} B),
					},
					'calorie' => {
						'few' => q({0} cal),
						'name' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
					},
					'carat' => {
						'few' => q({0} CD),
						'name' => q(карати),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					'celsius' => {
						'few' => q({0}°C),
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'few' => q({0} cL),
						'name' => q(cL),
						'one' => q({0} cL),
						'other' => q({0} cL),
					},
					'centimeter' => {
						'few' => q({0} cm),
						'name' => q(cm),
						'one' => q({0} cm),
						'other' => q({0} cm),
						'per' => q({0}/cm),
					},
					'century' => {
						'few' => q({0} в),
						'name' => q(в.),
						'one' => q({0} в),
						'other' => q({0} в),
					},
					'coordinate' => {
						'east' => q({0}И),
						'north' => q({0}С),
						'south' => q({0}Ј),
						'west' => q({0}З),
					},
					'cubic-centimeter' => {
						'few' => q({0} cm³),
						'name' => q(cm³),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					'cubic-foot' => {
						'few' => q({0} ft³),
						'name' => q(ft³),
						'one' => q({0} ft³),
						'other' => q({0} ft³),
					},
					'cubic-inch' => {
						'few' => q({0} in³),
						'name' => q(in³),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					'cubic-kilometer' => {
						'few' => q({0} km³),
						'name' => q(km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-meter' => {
						'few' => q({0} m³),
						'name' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					'cubic-mile' => {
						'few' => q({0} mi³),
						'name' => q(mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					'cubic-yard' => {
						'few' => q({0} yd³),
						'name' => q(yd³),
						'one' => q({0} yd³),
						'other' => q({0} yd³),
					},
					'cup' => {
						'few' => q({0} ш.),
						'name' => q(шоље),
						'one' => q({0} ш.),
						'other' => q({0} ш.),
					},
					'cup-metric' => {
						'few' => q({0} mc),
						'name' => q(mcup),
						'one' => q({0} mc),
						'other' => q({0} mc),
					},
					'day' => {
						'few' => q({0} дана),
						'name' => q(д.),
						'one' => q({0} дан),
						'other' => q({0} дана),
						'per' => q({0}/д),
					},
					'deciliter' => {
						'few' => q({0} dL),
						'name' => q(dL),
						'one' => q({0} dL),
						'other' => q({0} dL),
					},
					'decimeter' => {
						'few' => q({0} dm),
						'name' => q(dm),
						'one' => q({0} dm),
						'other' => q({0} dm),
					},
					'degree' => {
						'few' => q({0}°),
						'name' => q(степени),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'few' => q({0}°F),
						'name' => q(степени Фаренхајта),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fluid-ounce' => {
						'few' => q({0} fl oz),
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					'foodcalorie' => {
						'few' => q({0} Cal),
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					'foot' => {
						'few' => q({0} ft),
						'name' => q(ft),
						'one' => q({0} ft),
						'other' => q({0} ft),
						'per' => q({0}/ft),
					},
					'g-force' => {
						'few' => q({0} G),
						'name' => q(ге сила),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'few' => q({0} gal),
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					'gallon-imperial' => {
						'few' => q({0} gal Imp.),
						'name' => q(Imp. gal),
						'one' => q({0} gal Imp.),
						'other' => q({0} gal Imp.),
						'per' => q({0}/gal Imp.),
					},
					'generic' => {
						'few' => q({0}°),
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'few' => q({0} Gb),
						'name' => q(Gb),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'few' => q({0} GB),
						'name' => q(GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'few' => q({0} GHz),
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					'gigawatt' => {
						'few' => q({0} GW),
						'name' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
					},
					'gram' => {
						'few' => q({0} g),
						'name' => q(грами),
						'one' => q({0} g),
						'other' => q({0} g),
						'per' => q({0}/g),
					},
					'hectare' => {
						'few' => q({0} ha),
						'name' => q(хектари),
						'one' => q({0} ha),
						'other' => q({0} ha),
					},
					'hectoliter' => {
						'few' => q({0} hL),
						'name' => q(hL),
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					'hectopascal' => {
						'few' => q({0} hPa),
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'hertz' => {
						'few' => q({0} Hz),
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					'horsepower' => {
						'few' => q({0} hp),
						'name' => q(hp),
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'few' => q({0} сата),
						'name' => q(сати),
						'one' => q({0} сат),
						'other' => q({0} сати),
						'per' => q({0}/ч),
					},
					'inch' => {
						'few' => q({0} инча),
						'name' => q(инчи),
						'one' => q({0} инч),
						'other' => q({0} инча),
						'per' => q({0}/in),
					},
					'inch-hg' => {
						'few' => q({0} inHg),
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'few' => q({0} J),
						'name' => q(J),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					'karat' => {
						'few' => q({0} kt),
						'name' => q(kt),
						'one' => q({0} kt),
						'other' => q({0} kt),
					},
					'kelvin' => {
						'few' => q({0} K),
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'few' => q({0} kb),
						'name' => q(kb),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'few' => q({0} kB),
						'name' => q(kB),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'few' => q({0} kcal),
						'name' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
					},
					'kilogram' => {
						'few' => q({0} kg),
						'name' => q(kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
						'per' => q({0}/kg),
					},
					'kilohertz' => {
						'few' => q({0} kHz),
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					'kilojoule' => {
						'few' => q({0} kJ),
						'name' => q(kJ),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
					},
					'kilometer' => {
						'few' => q({0} km),
						'name' => q(km),
						'one' => q({0} km),
						'other' => q({0} km),
						'per' => q({0}/km),
					},
					'kilometer-per-hour' => {
						'few' => q({0} km/h),
						'name' => q(km/h),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'few' => q({0} kW),
						'name' => q(kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'kilowatt-hour' => {
						'few' => q({0} kWh),
						'name' => q(kWh),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
					},
					'knot' => {
						'few' => q({0} kn),
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					'light-year' => {
						'few' => q({0} сг),
						'name' => q(светлосне год.),
						'one' => q({0} сг),
						'other' => q({0} сг),
					},
					'liter' => {
						'few' => q({0} l),
						'name' => q(литри),
						'one' => q({0} l),
						'other' => q({0} l),
						'per' => q({0}/l),
					},
					'liter-per-100kilometers' => {
						'few' => q({0} L/100 km),
						'name' => q(L/100 km),
						'one' => q({0} L/100 km),
						'other' => q({0} L/100 km),
					},
					'liter-per-kilometer' => {
						'few' => q({0} L/km),
						'name' => q(L/km),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
					},
					'lux' => {
						'few' => q({0} lx),
						'name' => q(lx),
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					'megabit' => {
						'few' => q({0} Mb),
						'name' => q(Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'few' => q({0} MB),
						'name' => q(MB),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'few' => q({0} MHz),
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					'megaliter' => {
						'few' => q({0} ML),
						'name' => q(ML),
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					'megawatt' => {
						'few' => q({0} MW),
						'name' => q(MW),
						'one' => q({0} MW),
						'other' => q({0} MW),
					},
					'meter' => {
						'few' => q({0} m),
						'name' => q(m),
						'one' => q({0} m),
						'other' => q({0} m),
						'per' => q({0}/m),
					},
					'meter-per-second' => {
						'few' => q({0} m/s),
						'name' => q(метри у секунди),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'meter-per-second-squared' => {
						'few' => q({0} m/s²),
						'name' => q(m/s²),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					'metric-ton' => {
						'few' => q({0} t),
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
					},
					'microgram' => {
						'few' => q({0} µg),
						'name' => q(µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'few' => q({0} µm),
						'name' => q(µm),
						'one' => q({0} µm),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'few' => q({0} μs),
						'name' => q(μs),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'few' => q({0} mi),
						'name' => q(миље),
						'one' => q({0} mi),
						'other' => q({0} mi),
					},
					'mile-per-gallon' => {
						'few' => q({0} mpg),
						'name' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					'mile-per-gallon-imperial' => {
						'few' => q({0} mpg Imp.),
						'name' => q(mpg Imp.),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					'mile-per-hour' => {
						'few' => q({0} mi/h),
						'name' => q(миље на сат),
						'one' => q({0} mi/h),
						'other' => q({0} mi/h),
					},
					'mile-scandinavian' => {
						'few' => q({0} smi),
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					'milliampere' => {
						'few' => q({0} mA),
						'name' => q(mA),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					'millibar' => {
						'few' => q({0} mbar),
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'milligram' => {
						'few' => q({0} mg),
						'name' => q(mg),
						'one' => q({0} mg),
						'other' => q({0} mg),
					},
					'milligram-per-deciliter' => {
						'few' => q({0} mg/dL),
						'name' => q(mg/dL),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					'milliliter' => {
						'few' => q({0} mL),
						'name' => q(mL),
						'one' => q({0} mL),
						'other' => q({0} mL),
					},
					'millimeter' => {
						'few' => q({0} mm),
						'name' => q(mm),
						'one' => q({0} mm),
						'other' => q({0} mm),
					},
					'millimeter-of-mercury' => {
						'few' => q({0} mm Hg),
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					'millimole-per-liter' => {
						'few' => q({0} mmol/L),
						'name' => q(mmol/L),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					'millisecond' => {
						'few' => q({0} ms),
						'name' => q(ms),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'milliwatt' => {
						'few' => q({0} mW),
						'name' => q(mW),
						'one' => q({0} mW),
						'other' => q({0} mW),
					},
					'minute' => {
						'few' => q({0} мин),
						'name' => q(мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
						'per' => q({0}/мин),
					},
					'month' => {
						'few' => q({0} мес.),
						'name' => q(месеци),
						'one' => q({0} мес.),
						'other' => q({0} мес.),
						'per' => q({0}/м),
					},
					'nanometer' => {
						'few' => q({0} nm),
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
					},
					'nanosecond' => {
						'few' => q({0} ns),
						'name' => q(ns),
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					'nautical-mile' => {
						'few' => q({0} nmi),
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					'ohm' => {
						'few' => q({0} Ω),
						'name' => q(Ω),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'few' => q({0} oz),
						'name' => q(oz),
						'one' => q({0} oz),
						'other' => q({0} oz),
						'per' => q({0}/oz),
					},
					'ounce-troy' => {
						'few' => q({0} oz t),
						'name' => q(oz t),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					'parsec' => {
						'few' => q({0} pc),
						'name' => q(парсеци),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					'part-per-million' => {
						'few' => q({0} ppm),
						'name' => q(ppm),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'few' => q({0}%),
						'name' => q(проценат),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'permille' => {
						'few' => q({0}‰),
						'name' => q(промил),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					'petabyte' => {
						'few' => q({0} PB),
						'name' => q(PB),
						'one' => q({0} PB),
						'other' => q({0} PB),
					},
					'picometer' => {
						'few' => q({0} pm),
						'name' => q(пикометри),
						'one' => q({0} pm),
						'other' => q({0} pm),
					},
					'pint' => {
						'few' => q({0} pt),
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pint-metric' => {
						'few' => q({0} mpt),
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					'point' => {
						'few' => q({0} pt),
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pound' => {
						'few' => q({0} lb),
						'name' => q(lb),
						'one' => q({0} lb),
						'other' => q({0} lb),
						'per' => q({0}/lb),
					},
					'pound-per-square-inch' => {
						'few' => q({0} psi),
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					'quart' => {
						'few' => q({0} qt),
						'name' => q(qt),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					'radian' => {
						'few' => q({0} rad),
						'name' => q(rad),
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					'revolution' => {
						'few' => q({0} rev),
						'name' => q(rev),
						'one' => q({0} rev),
						'other' => q({0} rev),
					},
					'second' => {
						'few' => q({0} сек),
						'name' => q(сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
						'per' => q({0}/с),
					},
					'square-centimeter' => {
						'few' => q({0} cm²),
						'name' => q(cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
					},
					'square-foot' => {
						'few' => q({0} ft²),
						'name' => q(квадратне стопе),
						'one' => q({0} ft²),
						'other' => q({0} ft²),
					},
					'square-inch' => {
						'few' => q({0} in²),
						'name' => q(in²),
						'one' => q({0} in²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					'square-kilometer' => {
						'few' => q({0} km²),
						'name' => q(квадратни километри),
						'one' => q({0} km²),
						'other' => q({0} km²),
						'per' => q({0}/km²),
					},
					'square-meter' => {
						'few' => q({0} m²),
						'name' => q(квадратни метри),
						'one' => q({0} m²),
						'other' => q({0} m²),
						'per' => q({0}/m²),
					},
					'square-mile' => {
						'few' => q({0} mi²),
						'name' => q(mi²),
						'one' => q({0} mi²),
						'other' => q({0} mi²),
						'per' => q({0}/mi²),
					},
					'square-yard' => {
						'few' => q({0} yd²),
						'name' => q(yd²),
						'one' => q({0} yd²),
						'other' => q({0} yd²),
					},
					'tablespoon' => {
						'few' => q({0} каш.),
						'name' => q(каш.),
						'one' => q({0} каш.),
						'other' => q({0} каш.),
					},
					'teaspoon' => {
						'few' => q({0} кашич.),
						'name' => q(кашич.),
						'one' => q({0} кашич.),
						'other' => q({0} кашич.),
					},
					'terabit' => {
						'few' => q({0} Tb),
						'name' => q(Tb),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'few' => q({0} TB),
						'name' => q(TB),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'few' => q({0} tn),
						'name' => q(tn),
						'one' => q({0} tn),
						'other' => q({0} tn),
					},
					'volt' => {
						'few' => q({0} V),
						'name' => q(V),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					'watt' => {
						'few' => q({0} W),
						'name' => q(W),
						'one' => q({0} W),
						'other' => q({0} W),
					},
					'week' => {
						'few' => q({0} нед.),
						'name' => q(нед.),
						'one' => q({0} нед.),
						'other' => q({0} нед.),
						'per' => q({0}/н),
					},
					'yard' => {
						'few' => q({0} јрд),
						'name' => q(јарди),
						'one' => q({0} јрд),
						'other' => q({0} јрд),
					},
					'year' => {
						'few' => q({0} год.),
						'name' => q(год.),
						'one' => q({0} год),
						'other' => q({0} год.),
						'per' => q({0}/год),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:да|д|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:не|н|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0} и {1}),
				2 => q({0} и {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q(.),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'few' => '0 хиљ'.'',
					'one' => '0 хиљ'.'',
					'other' => '0 хиљ'.'',
				},
				'10000' => {
					'few' => '00 хиљ'.'',
					'one' => '00 хиљ'.'',
					'other' => '00 хиљ'.'',
				},
				'100000' => {
					'few' => '000 хиљ'.'',
					'one' => '000 хиљ'.'',
					'other' => '000 хиљ'.'',
				},
				'1000000' => {
					'few' => '0 мил'.'',
					'one' => '0 мил'.'',
					'other' => '0 мил'.'',
				},
				'10000000' => {
					'few' => '00 мил'.'',
					'one' => '00 мил'.'',
					'other' => '00 мил'.'',
				},
				'100000000' => {
					'few' => '000 мил'.'',
					'one' => '000 мил'.'',
					'other' => '000 мил'.'',
				},
				'1000000000' => {
					'few' => '0 млрд'.'',
					'one' => '0 млрд'.'',
					'other' => '0 млрд'.'',
				},
				'10000000000' => {
					'few' => '00 млрд'.'',
					'one' => '00 млрд'.'',
					'other' => '00 млрд'.'',
				},
				'100000000000' => {
					'few' => '000 млрд'.'',
					'one' => '000 млрд'.'',
					'other' => '000 млрд'.'',
				},
				'1000000000000' => {
					'few' => '0 бил'.'',
					'one' => '0 бил'.'',
					'other' => '0 бил'.'',
				},
				'10000000000000' => {
					'few' => '00 бил'.'',
					'one' => '00 бил'.'',
					'other' => '00 бил'.'',
				},
				'100000000000000' => {
					'few' => '000 бил'.'',
					'one' => '000 бил'.'',
					'other' => '000 бил'.'',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'few' => '0 хиљаде',
					'one' => '0 хиљада',
					'other' => '0 хиљада',
				},
				'10000' => {
					'few' => '00 хиљаде',
					'one' => '00 хиљада',
					'other' => '00 хиљада',
				},
				'100000' => {
					'few' => '000 хиљаде',
					'one' => '000 хиљада',
					'other' => '000 хиљада',
				},
				'1000000' => {
					'few' => '0 милиона',
					'one' => '0 милион',
					'other' => '0 милиона',
				},
				'10000000' => {
					'few' => '00 милиона',
					'one' => '00 милион',
					'other' => '00 милиона',
				},
				'100000000' => {
					'few' => '000 милиона',
					'one' => '000 милион',
					'other' => '000 милиона',
				},
				'1000000000' => {
					'few' => '0 милијарде',
					'one' => '0 милијарда',
					'other' => '0 милијарди',
				},
				'10000000000' => {
					'few' => '00 милијарде',
					'one' => '00 милијарда',
					'other' => '00 милијарди',
				},
				'100000000000' => {
					'few' => '000 милијарде',
					'one' => '000 милијарда',
					'other' => '000 милијарди',
				},
				'1000000000000' => {
					'few' => '0 билиона',
					'one' => '0 билион',
					'other' => '0 билиона',
				},
				'10000000000000' => {
					'few' => '00 билиона',
					'one' => '00 билион',
					'other' => '00 билиона',
				},
				'100000000000000' => {
					'few' => '000 билиона',
					'one' => '000 билион',
					'other' => '000 билиона',
				},
			},
			'short' => {
				'1000' => {
					'few' => '0 хиљ'.'',
					'one' => '0 хиљ'.'',
					'other' => '0 хиљ'.'',
				},
				'10000' => {
					'few' => '00 хиљ'.'',
					'one' => '00 хиљ'.'',
					'other' => '00 хиљ'.'',
				},
				'100000' => {
					'few' => '000 хиљ'.'',
					'one' => '000 хиљ'.'',
					'other' => '000 хиљ'.'',
				},
				'1000000' => {
					'few' => '0 мил'.'',
					'one' => '0 мил'.'',
					'other' => '0 мил'.'',
				},
				'10000000' => {
					'few' => '00 мил'.'',
					'one' => '00 мил'.'',
					'other' => '00 мил'.'',
				},
				'100000000' => {
					'few' => '000 мил'.'',
					'one' => '000 мил'.'',
					'other' => '000 мил'.'',
				},
				'1000000000' => {
					'few' => '0 млрд'.'',
					'one' => '0 млрд'.'',
					'other' => '0 млрд'.'',
				},
				'10000000000' => {
					'few' => '00 млрд'.'',
					'one' => '00 млрд'.'',
					'other' => '00 млрд'.'',
				},
				'100000000000' => {
					'few' => '000 млрд'.'',
					'one' => '000 млрд'.'',
					'other' => '000 млрд'.'',
				},
				'1000000000000' => {
					'few' => '0 бил'.'',
					'one' => '0 бил'.'',
					'other' => '0 бил'.'',
				},
				'10000000000000' => {
					'few' => '00 бил'.'',
					'one' => '00 бил'.'',
					'other' => '00 бил'.'',
				},
				'100000000000000' => {
					'few' => '000 бил'.'',
					'one' => '000 бил'.'',
					'other' => '000 бил'.'',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(#,##0.00 ¤)',
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(Андорска пезета),
				'few' => q(андорске пезете),
				'one' => q(андорска пезета),
				'other' => q(андорске пезете),
			},
		},
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(УАЕ дирхам),
				'few' => q(УАЕ дирхама),
				'one' => q(УАЕ дирхам),
				'other' => q(УАЕ дирхама),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(Авганистански авгани \(1927–2002\)),
				'few' => q(авганистанска авгана \(1927–2002\)),
				'one' => q(aвганистански авгани \(1927–2002\)),
				'other' => q(авганистанских авгана \(1927–2002\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(Авганистански авгани),
				'few' => q(авганистанска авгана),
				'one' => q(aвганистански авгани),
				'other' => q(авганистанских авгана),
			},
		},
		'ALK' => {
			display_name => {
				'few' => q(стара албанска лека),
				'one' => q(стари албански лек),
				'other' => q(старих албанских лека),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(Албански лек),
				'few' => q(албанска лека),
				'one' => q(албански лек),
				'other' => q(албанских лека),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(Јерменски драм),
				'few' => q(јерменска драма),
				'one' => q(јерменски драм),
				'other' => q(јерменска драма),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(Холандскоантилски гулден),
				'few' => q(холандскоантилска гулдена),
				'one' => q(холандскоантилски гулден),
				'other' => q(холандскоантилских гулдена),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(Анголска кванза),
				'few' => q(анголске кванзе),
				'one' => q(анголска кванза),
				'other' => q(анголских кванзи),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(Анголијска кванза \(1977–1990\)),
				'few' => q(анголијске кванзе \(1977–1990\)),
				'one' => q(анголијска кванза \(1977–1990\)),
				'other' => q(анголијских кванзи \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(Анголијска нова кванза \(1990–2000\)),
				'few' => q(анголијске нове кванзе),
				'one' => q(анголијска нова кванза),
				'other' => q(анголијских нових кванзи),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(Анголијска кванза реађустадо \(1995–1999\)),
				'few' => q(анголијске кванзе реађустадо \(1995–1999\)),
				'one' => q(анголијска кванза реађустадо \(1995–1999\)),
				'other' => q(анголијских кванзи реађустадо \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(Аргентински аустрал),
				'few' => q(аргентинска аустрала),
				'one' => q(аргентински аустрал),
				'other' => q(аргентинских аустрала),
			},
		},
		'ARL' => {
			display_name => {
				'currency' => q(Аргентински пезос леј),
				'few' => q(аргентинска пезос леја),
				'one' => q(аргентински пезос леј),
				'other' => q(аргентинских пезос леја),
			},
		},
		'ARM' => {
			display_name => {
				'currency' => q(Аргентински пезос монедо национал),
				'few' => q(аргентинска пезос монеда национал),
				'one' => q(аргентински пезос монедо национал),
				'other' => q(аргентинских пезос монеда национала),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(Аргентински пезо \(1983–1985\)),
				'few' => q(аргентинска пезоса \(1983–1985\)),
				'one' => q(аргентински пезо \(1983–1985\)),
				'other' => q(аргентинских пезоса \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(Аргентински пезос),
				'few' => q(аргентинска пезоса),
				'one' => q(аргентински пезос),
				'other' => q(аргентинских пезоса),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(Аустријски шилинг),
				'few' => q(аустријска шилинга),
				'one' => q(аустријски шилинг),
				'other' => q(аустријских шилинга),
			},
		},
		'AUD' => {
			symbol => 'AUD',
			display_name => {
				'currency' => q(Аустралијски долар),
				'few' => q(аустралијска долара),
				'one' => q(аустралијски долар),
				'other' => q(аустралијских долара),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(Арубански флорин),
				'few' => q(арубанска флорина),
				'one' => q(арубански флорин),
				'other' => q(арубанских флорина),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(Азербејџански манат \(1993–2006\)),
				'few' => q(азербејџанска маната \(1993–2006\)),
				'one' => q(азербејџански манат \(1993–2006\)),
				'other' => q(азербејџанских маната \(1993–2006\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(Азербејџански манат),
				'few' => q(азербејџанска маната),
				'one' => q(азербејџански манат),
				'other' => q(азербејџанских маната),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(Босанско-Херцеговачки динар),
				'few' => q(босанско-херцеговачка динара),
				'one' => q(босанско-херцеговачки динар),
				'other' => q(босанско-херцеговачких динара),
			},
		},
		'BAM' => {
			symbol => 'КМ',
			display_name => {
				'currency' => q(Босанско-херцеговачка конвертибилна марка),
				'few' => q(босанско-херцеговачке конвертибилне маркe),
				'one' => q(босанско-херцеговачка конвертибилна марка),
				'other' => q(босанско-херцеговачких конвертибилних марака),
			},
		},
		'BAN' => {
			display_name => {
				'currency' => q(Босанско-херцеговачки нови динар),
				'few' => q(босанско-херцеговачка нова динара),
				'one' => q(босанско-херцеговачки нови динар),
				'other' => q(босанско-херцеговачких нових динара),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(Барбадошки долар),
				'few' => q(барбадошка долара),
				'one' => q(барбадошки долар),
				'other' => q(барбадошких долара),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(Бангладешка така),
				'few' => q(бангладешке таке),
				'one' => q(бангладешка така),
				'other' => q(бангладешких така),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(Белгијски франак \(конвертибилни\)),
				'few' => q(белгијска франка \(конвертибилна\)),
				'one' => q(белгијски франак \(конвертибилни\)),
				'other' => q(белгијских франака \(конвертибилних\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(Белгијски франак),
				'few' => q(белгијска франка),
				'one' => q(белгијски франак),
				'other' => q(белгијских франака),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(Белгијски франак \(финансијски\)),
				'few' => q(белгијска франка \(финансијска\)),
				'one' => q(белгијски франак \(финансијски\)),
				'other' => q(белгијских франака \(финансијских\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(Бугарски тврди лев),
				'few' => q(бугарска тврда лева),
				'one' => q(бугарски тврди лев),
				'other' => q(бугарских тврдих лева),
			},
		},
		'BGM' => {
			display_name => {
				'currency' => q(Бугарски социјалистички лев),
				'few' => q(бугарска социјалистичка лева),
				'one' => q(бугарски социјалистички лев),
				'other' => q(бугарских социјалистичких лева),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(Бугарски лев),
				'few' => q(бугарска лева),
				'one' => q(бугарски лев),
				'other' => q(бугарских лева),
			},
		},
		'BGO' => {
			display_name => {
				'currency' => q(Стари бугарски лев),
				'few' => q(стара бугарска лева),
				'one' => q(стари бугарски лев),
				'other' => q(старих бугарских лева),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(Бахреински динар),
				'few' => q(бахреинскa динара),
				'one' => q(бахреински динар),
				'other' => q(бахреинских динара),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(Бурундски франак),
				'few' => q(бурундска франка),
				'one' => q(бурундски франак),
				'other' => q(бурундских франакa),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(Бермудски долар),
				'few' => q(бермудска долара),
				'one' => q(бермудски долар),
				'other' => q(бермудских долара),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(Брунејски долар),
				'few' => q(брунејска долара),
				'one' => q(брунејски долар),
				'other' => q(брунејских долара),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(Боливијски боливијано),
				'few' => q(боливијска боливијана),
				'one' => q(боливијски боливијано),
				'other' => q(боливијских боливијана),
			},
		},
		'BOL' => {
			display_name => {
				'currency' => q(Стари боливијски боливијано),
				'few' => q(стара боливијска боливијана),
				'one' => q(стари боливијски боливијано),
				'other' => q(старих боливијских боливијана),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(Боливијски пезо),
				'few' => q(боливијска пезоса),
				'one' => q(боливијски пезо),
				'other' => q(боливијских пезоса),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(Боливијски мвдол),
				'few' => q(боливијска мвдола),
				'one' => q(боливијски мвдол),
				'other' => q(боливијских мвдола),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(Бразилски нови крузеиро \(1967–1986\)),
				'few' => q(бразилска нова крузеира \(1967–1986\)),
				'one' => q(бразилски нови крузеиро \(1967–1986\)),
				'other' => q(бразилских нових крузеира \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(Бразилијски крузадо),
				'few' => q(бразилска крузадоса),
				'one' => q(бразилски крузадос),
				'other' => q(бразилских крузадоса),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(Бразилски крузеиро \(1990–1993\)),
				'few' => q(бразилска крузеира \(1990–1993\)),
				'one' => q(бразилски крузеиро \(1990–1993\)),
				'other' => q(бразилских крузеира \(1990–1993\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(Бразилски реал),
				'few' => q(бразилска реала),
				'one' => q(бразилски реал),
				'other' => q(бразилских реала),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(Бразилијски нови крузадо),
				'few' => q(бразилска нова крузада),
				'one' => q(бразилски нови крузадо),
				'other' => q(бразилских нових крузада),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(Бразилски крузеиро),
				'few' => q(бразилска крузеира),
				'one' => q(бразилски крузеиро),
				'other' => q(бразилских крузеира),
			},
		},
		'BRZ' => {
			display_name => {
				'currency' => q(Стари бразилски крузеиро),
				'few' => q(стара бразилска крузеира),
				'one' => q(стари бразилски крузеиро),
				'other' => q(старих бразилских крузеира),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(Бахамски долар),
				'few' => q(бахамска долара),
				'one' => q(бахамски долар),
				'other' => q(бахамских долара),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(Бутански нгултрум),
				'few' => q(бутанска нгултрума),
				'one' => q(бутански нгултрум),
				'other' => q(бутанских нгултрума),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(Бурмански кјат),
				'few' => q(бурманска кјата),
				'one' => q(бурмански кјат),
				'other' => q(бурманских кјата),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(Боцванска пула),
				'few' => q(боцванске пуле),
				'one' => q(боцванска пула),
				'other' => q(боцванских пула),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(Белоруска нова рубља \(1994–1999\)),
				'few' => q(белоруске нове рубља \(1994–1999\)),
				'one' => q(белоруска нова рубља \(1994–1999\)),
				'other' => q(белоруских нових рубљи \(1994–1999\)),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(Белоруска рубља),
				'few' => q(белоруске рубље),
				'one' => q(белоруска рубља),
				'other' => q(белоруских рубљи),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(Белоруска рубља \(2000–2016\)),
				'few' => q(белоруске рубље \(2000–2016\)),
				'one' => q(белоруска рубља \(2000–2016\)),
				'other' => q(белоруских рубљи \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(Белиски долар),
				'few' => q(белиска долара),
				'one' => q(белиски долар),
				'other' => q(белиских долара),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(Канадски долар),
				'few' => q(канадска долара),
				'one' => q(канадски долар),
				'other' => q(канадских долара),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(Конгоански франак),
				'few' => q(конгоанска франка),
				'one' => q(конгоански франак),
				'other' => q(конгоанских франака),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(WIR евро),
				'few' => q(WIR евра),
				'one' => q(WIR евро),
				'other' => q(WIR евра),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(Швајцарски франак),
				'few' => q(швајцарска франка),
				'one' => q(швајцарски франак),
				'other' => q(швајцарских франака),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(WIR франак),
				'few' => q(WIR франка),
				'one' => q(WIR франак),
				'other' => q(WIR франака),
			},
		},
		'CLE' => {
			display_name => {
				'currency' => q(Чилеански ескудо),
				'few' => q(чилеанска ескуда),
				'one' => q(чилеански ескудо),
				'other' => q(чилеанских ескуда),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(Чилеовски унидадес се фоменто),
				'few' => q(чилеанска унидадес де фомента),
				'one' => q(чилеански унидадес де фоменто),
				'other' => q(чилеански унидадеси де фоменто),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(Чилеански пезос),
				'few' => q(чилеанска пезоса),
				'one' => q(чилеански пезос),
				'other' => q(чилеанских пезоса),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(Кинески јуан \(острвски\)),
				'few' => q(кинеска јуана \(острвска\)),
				'one' => q(кинески јуан \(острвски\)),
				'other' => q(кинеских јуана \(острвских\)),
			},
		},
		'CNX' => {
			display_name => {
				'currency' => q(Долар кинеске народне банке),
				'few' => q(долара кинеске народне банке),
				'one' => q(долар кинеске народне банке),
				'other' => q(долара кинеске народне банке),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(Кинески јуан),
				'few' => q(кинеска јуана),
				'one' => q(кинески јуан),
				'other' => q(кинеских јуана),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(Колумбијски пезос),
				'few' => q(колумбијска пезоса),
				'one' => q(колумбијски пезос),
				'other' => q(колумбијских пезоса),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(Унидад де валоршки реал),
				'few' => q(нидад де валор реала),
				'one' => q(унидад де валоршки реал),
				'other' => q(унидад де валоршких реала),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(Костарикански колон),
				'few' => q(костариканска колона),
				'one' => q(костарикански колон),
				'other' => q(костарикански колони),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(Стари српски динар),
				'few' => q(стара српска динара),
				'one' => q(стари српски динар),
				'other' => q(старих српских динара),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(Чехословачка тврда круна),
				'few' => q(чехословачке тврде круне),
				'one' => q(чехословачка тврда круна),
				'other' => q(чехословачких тврдих круна),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(Кубански конвертибилни пезос),
				'few' => q(кубанска конвертибилна пезоса),
				'one' => q(кубански конвертибилни пезос),
				'other' => q(кубанских конвертибилних пезоса),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(Кубански пезос),
				'few' => q(кубанска пезоса),
				'one' => q(кубански пезос),
				'other' => q(кубанских пезоса),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(Зеленортски ескудо),
				'few' => q(зеленортска ескуда),
				'one' => q(зеленортски ескудо),
				'other' => q(зеленортских ескуда),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(Кипарска фунта),
				'few' => q(кипарске фунте),
				'one' => q(кипарска фунта),
				'other' => q(кипарских фунти),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(Чешка круна),
				'few' => q(чешке круне),
				'one' => q(чешка круна),
				'other' => q(чешких крунa),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(Источно-немачка марка),
				'few' => q(источно-немачке марке),
				'one' => q(источно-немачка марка),
				'other' => q(источно-немачких марака),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(Немачка марка),
				'few' => q(немачке марке),
				'one' => q(немачка марка),
				'other' => q(немачких марака),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(Џибутански франак),
				'few' => q(џибутанскa франкa),
				'one' => q(џибутански франак),
				'other' => q(џибутанских франакa),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(Данска круна),
				'few' => q(данске круне),
				'one' => q(данска круна),
				'other' => q(данских круна),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(Доминикански пезос),
				'few' => q(доминиканска пезоса),
				'one' => q(доминикански пезос),
				'other' => q(доминиканских пезоса),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(Алжирски динар),
				'few' => q(алжирска динара),
				'one' => q(алжирски динар),
				'other' => q(алжирских динара),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(Еквадорски сакр),
				'few' => q(еквадорска сакра),
				'one' => q(еквадорски сакр),
				'other' => q(еквадорских сакра),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(Еквадорски унидад де валор константе),
				'few' => q(еквадорска унидад де валор константа),
				'one' => q(еквадорски унидад де валор константе),
				'other' => q(еквадорских унидад де валор константа),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(Естонска кроон),
				'few' => q(естонске круне),
				'one' => q(естонска круна),
				'other' => q(естонских круна),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(Египатска фунта),
				'few' => q(египатске фунте),
				'one' => q(египатска фунта),
				'other' => q(египатских фунти),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(Eритрејска накфa),
				'few' => q(еритрејске накфе),
				'one' => q(еритрејска накфа),
				'other' => q(еритрејских накфи),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(Шпанска пезета \(рачун\)),
				'few' => q(шпанске пезете \(А рачун\)),
				'one' => q(шпанска пезета \(А рачун\)),
				'other' => q(шпанских пезета \(А рачун\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(Шпанска пезета \(конвертибилнирачун\)),
				'few' => q(шпанске пезете \(конвертибилан рачун\)),
				'one' => q(шпанска пезета \(конвертибилан рачун\)),
				'other' => q(шпанских пезета \(конвертибилан рачун\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(Шпанска пезета),
				'few' => q(шпанска пезета),
				'one' => q(шпанска пезета),
				'other' => q(шпанске пезете),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(Етиопски бир),
				'few' => q(етиопска бира),
				'one' => q(етиопски бир),
				'other' => q(етиопских бира),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(Евро),
				'few' => q(евра),
				'one' => q(евро),
				'other' => q(евра),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(Финска марка),
				'few' => q(финске марке),
				'one' => q(финска марка),
				'other' => q(финских марака),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(Фиџијски долар),
				'few' => q(фиџијска долара),
				'one' => q(фиџијски долар),
				'other' => q(фиџијских долара),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(Фокландска фунта),
				'few' => q(фокландске фунте),
				'one' => q(фокландска фунта),
				'other' => q(фокландских фунти),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(Француски франак),
				'few' => q(француска франка),
				'one' => q(француски франак),
				'other' => q(француских франака),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(Британска фунта),
				'few' => q(британске фунте),
				'one' => q(британска фунта),
				'other' => q(британских фунти),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(Грузијски купон ларит),
				'few' => q(грузијска купон ларита),
				'one' => q(грузијски купон ларит),
				'other' => q(грузијских купон ларита),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(Грузијски лари),
				'few' => q(грузијска ларија),
				'one' => q(грузијски лари),
				'other' => q(грузијских ларија),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(Гански цеди \(1979–2007\)),
				'few' => q(ганска цеда \(1979–2007\)),
				'one' => q(гански цед \(1979–2007\)),
				'other' => q(ганских цеда \(1979–2007\)),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(Гански седи),
				'few' => q(ганска седија),
				'one' => q(гански седи),
				'other' => q(ганских седија),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(Гибралтарска фунта),
				'few' => q(гибралтарске фунте),
				'one' => q(гибралтарска фунта),
				'other' => q(гибралтарских фунти),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(Гамбијски даласи),
				'few' => q(гамбијских даласија),
				'one' => q(гамбијски даласи),
				'other' => q(гамбијских даласија),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(Гвинејски франак),
				'few' => q(гвинејска франка),
				'one' => q(гвинејски франак),
				'other' => q(гвинејских франака),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(Гвинејски сили),
				'few' => q(гвинејска сила),
				'one' => q(гвинејски сили),
				'other' => q(гвинејских сила),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(Екваторијално-гвинејски еквеле),
				'few' => q(екваторијално-гвинејска еквела),
				'one' => q(екваторијално-гвинејски еквеле),
				'other' => q(екваторијално-гвинејских еквела),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(Грчка драхма),
				'few' => q(грчке драхме),
				'one' => q(грчка драхма),
				'other' => q(грчких драхми),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(Гватемалски кецал),
				'few' => q(гватемалска кецала),
				'one' => q(гватемалски кецал),
				'other' => q(гватемалских кецала),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(Португалска гвинеја ескудо),
				'few' => q(португалско-гвинејска ескуда),
				'one' => q(португалско-гвинејски ескудо),
				'other' => q(португалско-гвинејских ескуда),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(Гвинеја Бисао Пезо),
				'few' => q(гвинеја-бисаошка пезоса),
				'one' => q(гвинеја-бисаошки пезо),
				'other' => q(гвинеја-бисаошких пезоса),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(Гвајански долар),
				'few' => q(гвајанска долара),
				'one' => q(гвајански долар),
				'other' => q(гвајанских долара),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(Хонгконшки долар),
				'few' => q(хонгконшка долара),
				'one' => q(хонгконшки долар),
				'other' => q(хонгконшких долара),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(Хондурашка лемпира),
				'few' => q(хондурашке лемпире),
				'one' => q(хондурашка лемпира),
				'other' => q(хондурашких лемпира),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(Хрватски динар),
				'few' => q(хрватска динара),
				'one' => q(хрватски динар),
				'other' => q(хрватских динара),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(Хрватска куна),
				'few' => q(хрватске куне),
				'one' => q(хрватска куна),
				'other' => q(хрватских куна),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(Хаићански гурд),
				'few' => q(хаићанска гурда),
				'one' => q(хаићански гурд),
				'other' => q(хаићанских гурда),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(Мађарска форинта),
				'few' => q(мађарске форинте),
				'one' => q(мађарска форинта),
				'other' => q(мађарских форинти),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(Индонежанска рупија),
				'few' => q(индонежанске рупије),
				'one' => q(индонежанска рупија),
				'other' => q(индонежанских рупијa),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(Ирска фунта),
				'few' => q(ирске фунте),
				'one' => q(ирска фунта),
				'other' => q(ирских фунти),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(Израелска фунта),
				'few' => q(израелске фунте),
				'one' => q(израелска фунта),
				'other' => q(израелских фунти),
			},
		},
		'ILR' => {
			display_name => {
				'currency' => q(Стари израелски шекели),
				'few' => q(стари израелски шекели),
				'one' => q(стари израелски шекели),
				'other' => q(стари израелски шекели),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(Израелски нови шекел),
				'few' => q(израелска нова шекела),
				'one' => q(израелски нови шекел),
				'other' => q(израелских нових шекела),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(Индијска рупија),
				'few' => q(индијске рупије),
				'one' => q(индијска рупија),
				'other' => q(индијских рупија),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(Ирачки динар),
				'few' => q(ирачка динара),
				'one' => q(ирачки динар),
				'other' => q(ирачких динара),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(Ирански риjал),
				'few' => q(иранска ријала),
				'one' => q(ирански ријал),
				'other' => q(иранских ријала),
			},
		},
		'ISJ' => {
			display_name => {
				'currency' => q(Стара исландска круна),
				'few' => q(стара исландска круна),
				'one' => q(стара исландска круна),
				'other' => q(стара исландска круна),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(Исландска круна),
				'few' => q(исландске круне),
				'one' => q(исландска круна),
				'other' => q(исландских круна),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(Италијанска лира),
				'few' => q(италијанске лире),
				'one' => q(италијанска лира),
				'other' => q(италијанске лире),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(Јамајчански долар),
				'few' => q(jамајчанска долара),
				'one' => q(jамајчански долар),
				'other' => q(jамајчанскиx долара),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(Јордански динар),
				'few' => q(јорданскa динара),
				'one' => q(јордански динар),
				'other' => q(јорданских динара),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(Јапански јен),
				'few' => q(јапанска јена),
				'one' => q(јапански јен),
				'other' => q(јапанских јена),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(Кенијски шилинг),
				'few' => q(кенијска шилинга),
				'one' => q(кенијски шилинг),
				'other' => q(кенијских шилинга),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(Киргистански сом),
				'few' => q(киргистанска сома),
				'one' => q(киргистански сом),
				'other' => q(киргистанских сома),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(Kамбоџански ријел),
				'few' => q(камбоџанска ријела),
				'one' => q(камбоџански ријел),
				'other' => q(камбоџанских ријела),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(Коморски франак),
				'few' => q(коморскa франкa),
				'one' => q(коморски франак),
				'other' => q(коморских франакa),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(Севернокорејски вон),
				'few' => q(севернокорејска вона),
				'one' => q(севернокорејски вон),
				'other' => q(севернокорејских вона),
			},
		},
		'KRH' => {
			display_name => {
				'currency' => q(Јужнокорејски хван),
				'few' => q(јужнокорејска хвана),
				'one' => q(јужнокорејски хван),
				'other' => q(јужнокорејских хвана),
			},
		},
		'KRO' => {
			display_name => {
				'currency' => q(Стари јужнокорејски вон),
				'few' => q(стара јужнокорејска вона),
				'one' => q(стари јужнокорејски вон),
				'other' => q(старих јужнокорејских вона),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(Јужнокорејски вон),
				'few' => q(јужнокорејска вона),
				'one' => q(јужнокорејски вон),
				'other' => q(јужнокорејских вона),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(Кувајтски динар),
				'few' => q(кувајтскa динара),
				'one' => q(кувајтски динар),
				'other' => q(кувајтских динара),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(Кајмански долар),
				'few' => q(кајманска долара),
				'one' => q(кајмански долар),
				'other' => q(кајманских долара),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(Казахстански тенге),
				'few' => q(казахстанска тенгеа),
				'one' => q(казахстански тенге),
				'other' => q(казахстанских тенгеа),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(Лаошки кип),
				'few' => q(лаошка кипа),
				'one' => q(лаошки кип),
				'other' => q(лаошких кипи),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(Либанска фунта),
				'few' => q(либанскe фунтe),
				'one' => q(либанскa фунтa),
				'other' => q(либанских фунти),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(Шриланканскa рупиja),
				'few' => q(шриланканскe рупијe),
				'one' => q(шриланканска рупија),
				'other' => q(шриланканских рупија),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(Либеријски долар),
				'few' => q(либеријска долара),
				'one' => q(либеријски долар),
				'other' => q(либеријских долара),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(Лесото лоти),
				'few' => q(лесотска лотиса),
				'one' => q(лесотски лотис),
				'other' => q(лесотских лотиса),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(Литвански литас),
				'few' => q(литванска литаса),
				'one' => q(литвански литас),
				'other' => q(литванских литаса),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(Литвански талонас),
				'few' => q(литванска талонаса),
				'one' => q(литвански талонас),
				'other' => q(литванских талонаса),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(Луксембуршки конвертибилни франак),
				'few' => q(луксембуршка конвертибилна франка),
				'one' => q(луксембуршки конвертибилни франак),
				'other' => q(луксембуршких конвертибилних франака),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(Луксембуршки франак),
				'few' => q(луксембуршка франка),
				'one' => q(луксембуршки франак),
				'other' => q(луксембуршки франци),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(Луксембуршки финансијски франак),
				'few' => q(луксембуршка финансијска франка),
				'one' => q(луксембуршки финансијски франак),
				'other' => q(луксембуршких финансијских франака),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(Латвијски лати),
				'few' => q(латвијска лата),
				'one' => q(латвијски лат),
				'other' => q(латвијских лата),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(Латвијска рубља),
				'few' => q(латвијске рубље),
				'one' => q(латвијска рубља),
				'other' => q(латвијских рубљи),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(Либијски динар),
				'few' => q(либијскa динарa),
				'one' => q(либијски динар),
				'other' => q(либијских динарa),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(Марокански дирхам),
				'few' => q(мароканска дирхама),
				'one' => q(марокански дирхам),
				'other' => q(мароканских дирхама),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(Марокански франак),
				'few' => q(мароканска франка),
				'one' => q(марокански франак),
				'other' => q(мароканских франака),
			},
		},
		'MCF' => {
			display_name => {
				'currency' => q(Монегаскански франак),
				'few' => q(монегасканска франка),
				'one' => q(монегаскански франак),
				'other' => q(монегасканских франака),
			},
		},
		'MDC' => {
			display_name => {
				'currency' => q(Молдовански купон),
				'few' => q(молдованска купона),
				'one' => q(молдовански купон),
				'other' => q(молдованских купона),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(Молдавски леј),
				'few' => q(молдaвскa леја),
				'one' => q(молдaвски леј),
				'other' => q(молдaвских леја),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(Мадагаскарски ариари),
				'few' => q(мадагаскарска ариарија),
				'one' => q(мадагаскарски ариари),
				'other' => q(мадагаскарских ариарија),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(Малагасијски франак),
				'few' => q(малагашајска франка),
				'one' => q(малагашајски франак),
				'other' => q(малагашајски франци),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(Македонски денар),
				'few' => q(македонска денара),
				'one' => q(македонски денар),
				'other' => q(македонских динара),
			},
		},
		'MKN' => {
			display_name => {
				'currency' => q(Стари македонски денар),
				'few' => q(стара македонска денара),
				'one' => q(стари македонски денар),
				'other' => q(старих македонских денара),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(Малијански франак),
				'few' => q(малијска франка),
				'one' => q(малијски франак),
				'other' => q(малијских франака),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(Мјанмарски кјат),
				'few' => q(мјанмарскa кјатa),
				'one' => q(мјанмарски кјат),
				'other' => q(мјанмарских кјатa),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(Монголски тугрик),
				'few' => q(монголскa тугрика),
				'one' => q(монголски тугрик),
				'other' => q(монголских тугрика),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(Макаоска патака),
				'few' => q(макаоске патаке),
				'one' => q(макаоска патака),
				'other' => q(макаоских патака),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(Мауританијска oгија \(1973–2017\)),
				'few' => q(мауританијскe oгијe \(1973–2017\)),
				'one' => q(мауританијска oгија \(1973–2017\)),
				'other' => q(мауританијских oгијa \(1973–2017\)),
			},
		},
		'MRU' => {
			symbol => 'MRU',
			display_name => {
				'currency' => q(Мауританијска oгија),
				'few' => q(мауританијскe oгијe),
				'one' => q(мауританијска oгија),
				'other' => q(мауританијских oгијa),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(Малтешка лира),
				'few' => q(малтешке лире),
				'one' => q(малтешка лира),
				'other' => q(малтешких лира),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(Малтешка фунта),
				'few' => q(малтешке фунте),
				'one' => q(малтешка фунта),
				'other' => q(малтешких фунти),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(Маурицијска рупија),
				'few' => q(маурицијскe рупијe),
				'one' => q(маурицијска рупија),
				'other' => q(маурицијских рупија),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(Малдивска руфија),
				'few' => q(малдивскe руфијe),
				'one' => q(малдивскa руфија),
				'other' => q(малдивских руфија),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(Малавијска квача),
				'few' => q(малавијске кваче),
				'one' => q(малавијска квача),
				'other' => q(малавијских квача),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(Мексички пезос),
				'few' => q(мексичка пезоса),
				'one' => q(мексички пезос),
				'other' => q(мексичких пезоса),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(Мексички сребрни пезо \(1861–1992\)),
				'few' => q(мексичка сребрна пезоса),
				'one' => q(мексички сребрни пезо),
				'other' => q(мексичких сребрних пезоса),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(Мексички унидад де инверсион \(UDI\)),
				'few' => q(мексичка унидадс де инверзиона),
				'one' => q(мексички унидадс де инверзион),
				'other' => q(мексичких унидадс де инверзиона),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(Малезијски рингит),
				'few' => q(малезијска рингита),
				'one' => q(малезијски рингит),
				'other' => q(малезијских рингита),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(Мозамбијски ескудо),
				'few' => q(мозамбијска ескуда),
				'one' => q(мозамбијски ескудо),
				'other' => q(мозамбијских ескуда),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(Стари мозамбијски метикал),
				'few' => q(стара мозамбијска метикала),
				'one' => q(стари мозамбијски метикал),
				'other' => q(старих мозамбијских метикала),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(Мозамбички метикал),
				'few' => q(мозамбичка метикала),
				'one' => q(мозамбички метикал),
				'other' => q(мозамбичких метикала),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(Намибијски долар),
				'few' => q(намибијска долара),
				'one' => q(намибијски долар),
				'other' => q(намибијских долара),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(Нигеријска наира),
				'few' => q(нигеријске наире),
				'one' => q(нигеријска наира),
				'other' => q(нигеријских наира),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(Никарагванска кордоба),
				'few' => q(никарагванске кордобе),
				'one' => q(никарагванска кордоба),
				'other' => q(никарагванских кордоба),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(Никарагванска златна кордоба),
				'few' => q(никарагванске златне кордобе),
				'one' => q(никарагванска златна кордоба),
				'other' => q(никарагванских златних кордоба),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(Холандски гулден),
				'few' => q(холандска гулдена),
				'one' => q(холандски гулден),
				'other' => q(холандских гулдена),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(Норвешка круна),
				'few' => q(норвешке круне),
				'one' => q(норвешка круна),
				'other' => q(норвешких круна),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(Непалскa рупиja),
				'few' => q(непалске рупије),
				'one' => q(непалска рупија),
				'other' => q(непалских рупија),
			},
		},
		'NZD' => {
			symbol => 'NZD',
			display_name => {
				'currency' => q(Новозеландски долар),
				'few' => q(новозеландска долара),
				'one' => q(новозеландски долар),
				'other' => q(новозеландских долара),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(Омански ријал),
				'few' => q(оманскa ријала),
				'one' => q(омански ријал),
				'other' => q(оманских ријала),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(Панамска балбоа),
				'few' => q(панамске балбое),
				'one' => q(панамска балбоа),
				'other' => q(панамских балбоа),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(Перуански инти),
				'few' => q(перувијска интија),
				'one' => q(перувијски инти),
				'other' => q(перувијских интија),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(Перуански сол),
				'few' => q(перуанска сола),
				'one' => q(перуански сол),
				'other' => q(перуанских сола),
			},
		},
		'PES' => {
			symbol => 'PES',
			display_name => {
				'currency' => q(Перуански сол \(1863–1965\)),
				'few' => q(перуанска сола \(1863–1965\)),
				'one' => q(перуански сол \(1863–1965\)),
				'other' => q(перуанских сола \(1863–1965\)),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(Папуанска кина),
				'few' => q(папуанскe кинe),
				'one' => q(папуанска кина),
				'other' => q(папуанских кинa),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(Филипински пезос),
				'few' => q(филипинска пезоса),
				'one' => q(филипински пезос),
				'other' => q(филипинских пезоса),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(Пакистанскa рупиja),
				'few' => q(пакистанске рупије),
				'one' => q(пакистанска рупија),
				'other' => q(пакистанских рупија),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(Пољски злот),
				'few' => q(пољска злота),
				'one' => q(пољски злот),
				'other' => q(пољских злота),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(Пољски злоти \(1950–1995\)),
				'few' => q(пољска злота \(1950–1995\)),
				'one' => q(пољски злот \(1950–1995\)),
				'other' => q(пољских злота \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(Португалски ескудо),
				'few' => q(португалска ескуда),
				'one' => q(португалски ескудо),
				'other' => q(португалских ескуда),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(Парагвајски гварани),
				'few' => q(парагвајска гваранија),
				'one' => q(парагвајски гварани),
				'other' => q(парагвајских гваранија),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(Катарски ријал),
				'few' => q(катарска ријала),
				'one' => q(катарски ријал),
				'other' => q(катарских ријала),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(Родејскидолар),
				'few' => q(родежанска долара),
				'one' => q(родежански долар),
				'other' => q(родежанских долара),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(Румунски леј \(1952–2006\)),
				'few' => q(румунскa леја \(1952–2006\)),
				'one' => q(румунски леј \(1952–2006\)),
				'other' => q(румунских леја \(1952–2006\)),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(Румунски леј),
				'few' => q(румунскa леја),
				'one' => q(румунски леј),
				'other' => q(румунских леја),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(Српски динар),
				'few' => q(српска динара),
				'one' => q(српски динар),
				'other' => q(српских динара),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(Руска рубља),
				'few' => q(руске рубље),
				'one' => q(руска рубља),
				'other' => q(руских рубљи),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(Руска рубља \(1991–1998\)),
				'few' => q(руске рубље \(1991–1998\)),
				'one' => q(руска рубља \(1991–1998\)),
				'other' => q(руских рубљи \(1991–1998\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(Руандски франак),
				'few' => q(руандскa франка),
				'one' => q(руандски франак),
				'other' => q(руандских франака),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(Саудијски ријал),
				'few' => q(саудијска ријала),
				'one' => q(саудијски ријал),
				'other' => q(саудијских ријала),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(Соломонски долар),
				'few' => q(соломонска долара),
				'one' => q(соломонски долар),
				'other' => q(соломонских долара),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(Сејшелска рупија),
				'few' => q(сејшелске рупије),
				'one' => q(сејшелска рупија),
				'other' => q(сејшелских рупија),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(Стари судански динар),
				'few' => q(стара суданска динара),
				'one' => q(стари судански динар),
				'other' => q(старих суданских динара),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(Суданска фунта),
				'few' => q(суданске фунте),
				'one' => q(суданска фунта),
				'other' => q(суданских фунти),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(Стара суданска фунта),
				'few' => q(старе суданске фунте),
				'one' => q(стара суданска фунта),
				'other' => q(старих суданских фунти),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(Шведска круна),
				'few' => q(шведске круне),
				'one' => q(шведска круна),
				'other' => q(шведских круна),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(Сингапурски долар),
				'few' => q(сингапурска долара),
				'one' => q(сингапурски долар),
				'other' => q(сингапурских долара),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(Св. јеленска фунта),
				'few' => q(св. јеленске фунте),
				'one' => q(св. јеленска фунта),
				'other' => q(св. јеленских фунти),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(Словеначки толар),
				'few' => q(словеначка толара),
				'one' => q(словеначки толар),
				'other' => q(словеначких толара),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(Словачка круна),
				'few' => q(словачке круне),
				'one' => q(словачка круна),
				'other' => q(словачких круна),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(Сијералеонски леоне),
				'few' => q(сијералеонска леона),
				'one' => q(сијералеонски леоне),
				'other' => q(сијералеонских леона),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(Сомалијски шилинг),
				'few' => q(сомалијска шилинга),
				'one' => q(сомалијски шилинг),
				'other' => q(сомалијских шилинга),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(Суринамски долар),
				'few' => q(суринамска долара),
				'one' => q(суринамски долар),
				'other' => q(суринамских долара),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(Суринамски гилдер),
				'few' => q(суринамска гилдера),
				'one' => q(суринамски гилдер),
				'other' => q(суринамских гилдера),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(Јужносуданска фунта),
				'few' => q(јужносуданскe фунтe),
				'one' => q(јужносуданска фунта),
				'other' => q(јужносуданских фунти),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(Саотомска добра \(1977–2017\)),
				'few' => q(саотомске добре \(1977–2017\)),
				'one' => q(саотомска добра \(1977–2017\)),
				'other' => q(саотомских добри \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(Саотомска добра),
				'few' => q(саотомске добре),
				'one' => q(саотомска добра),
				'other' => q(саотомских добри),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(Совјетска рубља),
				'few' => q(совјетске рубље),
				'one' => q(совјетска рубља),
				'other' => q(совјетских рубљи),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(Салвадорски колон),
				'few' => q(салвадорска колона),
				'one' => q(салвадорски колон),
				'other' => q(салвадорских колона),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(Сиријска фунта),
				'few' => q(сиријске фунте),
				'one' => q(сиријска фунта),
				'other' => q(сиријских фунти),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(Свазилендски лилангени),
				'few' => q(свазилендска лилангенија),
				'one' => q(свазилендски лилангени),
				'other' => q(свазилендских лилангенија),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(Тајландски бат),
				'few' => q(тајландска бата),
				'one' => q(тајландски бат),
				'other' => q(тајландских бата),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(Таџихистанска рубља),
				'few' => q(таџихистанске рубље),
				'one' => q(таџихистанска рубља),
				'other' => q(таџихистанских рубљи),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(Таџикистански сомон),
				'few' => q(таџикистанска сомона),
				'one' => q(таџикистански сомон),
				'other' => q(таџикистанских сомона),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(Туркменистански манат \(1993–2009\)),
				'few' => q(туркменистанска маната \(1993–2009\)),
				'one' => q(туркменистански манат \(1993–2009\)),
				'other' => q(туркменистански манат \(1993–2009\)),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(Туркменистански манат),
				'few' => q(туркменистанскa манатa),
				'one' => q(туркменистански манат),
				'other' => q(туркменистанских маната),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(Туниски динар),
				'few' => q(туниска динара),
				'one' => q(туниски динар),
				'other' => q(туниских динара),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(Тонганска панга),
				'few' => q(тонганске панге),
				'one' => q(тонганска панга),
				'other' => q(тонганских панги),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(Тиморшки ескудо),
				'few' => q(тиморшка ескуда),
				'one' => q(тиморшки ескудо),
				'other' => q(тиморшких ескуда),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(Турска лира \(1922–2005\)),
				'few' => q(турске лире \(1922–2005\)),
				'one' => q(турска лира \(1922–2005\)),
				'other' => q(турских лира \(1922–2005\)),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(Турска лира),
				'few' => q(турске лире),
				'one' => q(турска лира),
				'other' => q(турских лира),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(Тринидад-тобагошки долар),
				'few' => q(тринидад-тобагошка долара),
				'one' => q(тринидад-тобагошки долар),
				'other' => q(тринидад-тобагошких долара),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(Нови тајвански долар),
				'few' => q(нова тајванска долара),
				'one' => q(нови тајвански долар),
				'other' => q(нових тајванских долара),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(Танзанијски шилинг),
				'few' => q(танзанијска шилинга),
				'one' => q(танзанијски шилинг),
				'other' => q(танзанијских шилинга),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(Украјинска хривња),
				'few' => q(украјинскe гривнe),
				'one' => q(украјинскa хривњa),
				'other' => q(украјинских хривњи),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(Украјински карбованети),
				'few' => q(украјинска карбованцива),
				'one' => q(украјински карбованец),
				'other' => q(украјинских карбованцива),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(Угандски шилинг \(1966–1987\)),
				'few' => q(угандијска шилинга \(1966–1987\)),
				'one' => q(угандијски шилинг \(1966–1987\)),
				'other' => q(угандијских шилинга \(1966–1987\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(Угандски шилинг),
				'few' => q(угандскa шилинга),
				'one' => q(угандски шилинг),
				'other' => q(угандских шилинга),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(Амерички долар),
				'few' => q(америчка долара),
				'one' => q(амерички долар),
				'other' => q(америчких долара),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(САД долар \(следећи дан\)),
				'few' => q(САД долара \(следећи дан\)),
				'one' => q(САД долар \(следећи дан\)),
				'other' => q(САД долара \(следећи дан\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(САД долар \(исти дан\)),
				'few' => q(САД долара \(исти дан\)),
				'one' => q(САД долар \(исти дан\)),
				'other' => q(САД долара \(исти дан\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(Уругвајски пезо ен унидадес индексадас),
				'few' => q(уругвајска пезоса ен унидадес индексадеса),
				'one' => q(уругвајски пезо ен унидадес индексадес),
				'other' => q(угвајских пезоса ен унидадес индексадеса),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(Уругвајски пезо \(1975–1993\)),
				'few' => q(уругвајска пезоса \(1975–1993\)),
				'one' => q(уругвајски пезо \(1975–1993\)),
				'other' => q(уругвајских пезоса \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(Уругвајски пезос),
				'few' => q(уругвајска пезоса),
				'one' => q(уругвајски пезос),
				'other' => q(уругвајских пезоса),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(Узбекистански сом),
				'few' => q(узбекистанска сома),
				'one' => q(узбекистански сом),
				'other' => q(узбекистанских сома),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(Венецуелански боливар \(1871–2008\)),
				'few' => q(венецуеланска боливара \(1871–2008\)),
				'one' => q(венецуелански боливар \(1871–2008\)),
				'other' => q(венецуеланских боливара \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(Венецуелански боливар \(2008–2018\)),
				'few' => q(венецуеланска боливара \(2008–2018\)),
				'one' => q(венецуелански боливар \(2008–2018\)),
				'other' => q(венецуеланских боливара \(2008–2018\)),
			},
		},
		'VES' => {
			symbol => 'VES',
			display_name => {
				'currency' => q(Венецуелански боливар),
				'few' => q(венецуеланска боливара),
				'one' => q(венецуелански боливар),
				'other' => q(венецуеланских боливара),
			},
		},
		'VND' => {
			symbol => 'VND',
			display_name => {
				'currency' => q(Вијетнамски донг),
				'few' => q(вијетнамска донга),
				'one' => q(вијетнамски донг),
				'other' => q(вијетнамских донга),
			},
		},
		'VNN' => {
			display_name => {
				'currency' => q(Вијетнамски донг \(1978–1985\)),
				'few' => q(вијетнамска донга \(1978–1985\)),
				'one' => q(вијетнамски донг \(1978–1985\)),
				'other' => q(вијетнамских донга \(1978–1985\)),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(Вануатски вату),
				'few' => q(вануатскa ватуa),
				'one' => q(вануатски вату),
				'other' => q(вануатских ватуa),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(Самоанска тала),
				'few' => q(самоанске тале),
				'one' => q(самоанска тала),
				'other' => q(самоанских тала),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(CFA франак BEAC),
				'few' => q(CFA франка BEAC),
				'one' => q(CFA франак BEAC),
				'other' => q(CFA франака BEAC),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(Сребро),
				'few' => q(сребра),
				'one' => q(сребро),
				'other' => q(сребра),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(Злато),
				'few' => q(злата),
				'one' => q(злато),
				'other' => q(злата),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(Европска композитна јединица),
				'few' => q(европске композитне јединице),
				'one' => q(европска композитна јединица),
				'other' => q(европских композитних јединица),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(Европска новчана јединица),
				'few' => q(европске новчане јединице \(XBB\)),
				'one' => q(европска новчана јединица \(XBB\)),
				'other' => q(европске новчане јединице \(XBB\)),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(Европска јединица рачуна \(XBC\)),
				'few' => q(европске јединице рачуна \(XBC\)),
				'one' => q(европска јединица рачуна \(XBC\)),
				'other' => q(европских јединица рачуна \(XBC\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(Европска јединица рачуна \(XBD\)),
				'few' => q(европске јединице рачуна \(XBD\)),
				'one' => q(европска јединица рачуна \(XBD\)),
				'other' => q(европских јединица рачуна \(XBD\)),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(Источнокарипски долар),
				'few' => q(источнокарипскa доларa),
				'one' => q(источнокарипски долар),
				'other' => q(источнокарипскиx доларa),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(Посебна цртаћа права),
				'few' => q(посебна цртаћа права),
				'one' => q(посебно цртаће право),
				'other' => q(посебних цртаћих права),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(Европска валутна јединица),
				'few' => q(европске новчане јединице \(XEU\)),
				'one' => q(европска новчана јединица \(XEU\)),
				'other' => q(европских новчаних јединица),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(Француски златни франак),
				'few' => q(француска златна франка),
				'one' => q(француски златни франак),
				'other' => q(француских златних франака),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(Француски UIC-франак),
				'few' => q(француска UIC-франка),
				'one' => q(француски UIC-франак),
				'other' => q(француских UIC-франака),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(ЦФА франак БЦЕАО),
				'few' => q(ЦФА франка БЦЕАО),
				'one' => q(ЦФА франак БЦЕАО),
				'other' => q(ЦФА франака БЦЕАО),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(Паладијум),
				'few' => q(паладијума),
				'one' => q(паладијум),
				'other' => q(паладијума),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP франак),
				'few' => q(CFP франка),
				'one' => q(CFP франак),
				'other' => q(CFP франака),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(Платина),
				'few' => q(платине),
				'one' => q(платина),
				'other' => q(платина),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(RINET фонд),
				'few' => q(RINET фонда),
				'one' => q(RINET фонд),
				'other' => q(RINET фондова),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(Код тестиране валуте),
				'few' => q(кода тестиране валуте),
				'one' => q(код тестиране валуте),
				'other' => q(кодова тестиране валуте),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Непозната валута),
				'few' => q(непознате валуте),
				'one' => q(непозната јединица валуте),
				'other' => q(непознатих валута),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(Јеменски динар),
				'few' => q(јеменска долара),
				'one' => q(јеменски долар),
				'other' => q(јеменских долара),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(Јеменски риjал),
				'few' => q(јеменска ријала),
				'one' => q(јеменски ријал),
				'other' => q(jеменских ријала),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(Југословенски тврди динар),
				'few' => q(југословенска тврда динара),
				'one' => q(југословенски тврди динар),
				'other' => q(југословенских тврдих динара),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(Југословенски нови динар),
				'few' => q(југословенска нова динара),
				'one' => q(југословенски нови динар),
				'other' => q(југословенских нових динара),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(Југословенски конвертибилни динар),
				'few' => q(југословенска конвертибилна динара),
				'one' => q(југословенски конвертибилни динар),
				'other' => q(југословенских конвертибилних динара),
			},
		},
		'YUR' => {
			display_name => {
				'currency' => q(Југословенски реформирани динар),
				'few' => q(југословенска реформирана динара),
				'one' => q(југословенски реформирани динар),
				'other' => q(југословенских реформираних динара),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(Јужно-афрички ранд \(финансијски\)),
				'few' => q(јужноафричка ранда \(финансијска\)),
				'one' => q(јужноафрички ранд \(финансијски\)),
				'other' => q(јужноафричких ранда \(финансијских\)),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(Јужноафрички ранд),
				'few' => q(јужноафричка ранда),
				'one' => q(јужноафрички ранд),
				'other' => q(јужноафричких ранда),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Замбијска квача \(1968–2012\)),
				'few' => q(замбијске кваче \(1968–2012\)),
				'one' => q(замбијска квача \(1968–2012\)),
				'other' => q(замбијских квача \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(Замбијска квача),
				'few' => q(замбијске кваче),
				'one' => q(замбијска квача),
				'other' => q(замбијских квача),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(Заирски нови заир),
				'few' => q(заирска нова заира),
				'one' => q(заирски нови заир),
				'other' => q(заирских нових заира),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(Заирски заир),
				'few' => q(заирска заира),
				'one' => q(заирски заир),
				'other' => q(заирских заира),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(1980–2008\)),
				'few' => q(зимбабвејска долара \(1980–2008\)),
				'one' => q(зимбабвејски долар \(1980–2008\)),
				'other' => q(зимбабвејских долара \(1980–2008\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(2009\)),
				'few' => q(зимбабвејска долара \(2009\)),
				'one' => q(зимбабвејски долар \(2009\)),
				'other' => q(зимбабвејских долара \(2009\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(2008\)),
				'few' => q(зимбабвејска долара \(2008\)),
				'one' => q(зимбабвејски долар \(2008\)),
				'other' => q(зимбабвејских долара \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					wide => {
						nonleap => [
							'Таут',
							'Баба',
							'Хатор',
							'Киахк',
							'Тоба',
							'Амшир',
							'Барамхат',
							'Барамуда',
							'Башанс',
							'Паона',
							'Епеп',
							'Месра',
							'Наси'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					wide => {
						nonleap => [
							'Мескерем',
							'Текемт',
							'Хедар',
							'Тахсас',
							'Тер',
							'Јекатит',
							'Мегабит',
							'Миазиа',
							'Генбот',
							'Сене',
							'Хамле',
							'Нехасе',
							'Пагумен'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'јан',
							'феб',
							'мар',
							'апр',
							'мај',
							'јун',
							'јул',
							'авг',
							'сеп',
							'окт',
							'нов',
							'дец'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ј',
							'ф',
							'м',
							'а',
							'м',
							'ј',
							'ј',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'јануар',
							'фебруар',
							'март',
							'април',
							'мај',
							'јун',
							'јул',
							'август',
							'септембар',
							'октобар',
							'новембар',
							'децембар'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'јан',
							'феб',
							'мар',
							'апр',
							'мај',
							'јун',
							'јул',
							'авг',
							'сеп',
							'окт',
							'нов',
							'дец'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ј',
							'ф',
							'м',
							'а',
							'м',
							'ј',
							'ј',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'јануар',
							'фебруар',
							'март',
							'април',
							'мај',
							'јун',
							'јул',
							'август',
							'септембар',
							'октобар',
							'новембар',
							'децембар'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					wide => {
						nonleap => [
							'Тишри',
							'Хешван',
							'Кислев',
							'Тевет',
							'Шеват',
							'Адар I',
							'Адар',
							'Нисан',
							'Ијар',
							'Сиван',
							'Тамуз',
							'Ав',
							'Елул'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'Адар II'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'Чаитра',
							'Ваисака',
							'Јиаиста',
							'Асада',
							'Сравана',
							'Бадра',
							'Асвина',
							'Картика',
							'Аргајана',
							'Пауза',
							'Мага',
							'Фалгуна'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'Мух.',
							'Саф.',
							'Реб. 1',
							'Реб. 2',
							'Џум. 1',
							'Џум. 2',
							'Реџ.',
							'Ша.',
							'Рам.',
							'Ше.',
							'Зул-к.',
							'Зул-х.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Мурахам',
							'Сафар',
							'Рабиʻ I',
							'Рабиʻ II',
							'Јумада I',
							'Јумада II',
							'Рађаб',
							'Шаʻбан',
							'Рамадан',
							'Шавал',
							'Дуʻл-Киʻда',
							'Дуʻл-хиђа'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					wide => {
						nonleap => [
							'Мухарем',
							'Сафер',
							'Реби 1',
							'Реби 2',
							'Џумаде 1',
							'Џумаде 2',
							'Реџеб',
							'Шаʻбан',
							'Рамазан',
							'Шевал',
							'Зул-каде',
							'Зул-хиџе'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					wide => {
						nonleap => [
							'Фаравадин',
							'Ордибехешт',
							'Кордад',
							'Тир',
							'Мордад',
							'Шахривар',
							'Мехр',
							'Абан',
							'Азар',
							'Деј',
							'Бахман',
							'Есфанд'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'пон',
						tue => 'уто',
						wed => 'сре',
						thu => 'чет',
						fri => 'пет',
						sat => 'суб',
						sun => 'нед'
					},
					narrow => {
						mon => 'п',
						tue => 'у',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
					short => {
						mon => 'по',
						tue => 'ут',
						wed => 'ср',
						thu => 'че',
						fri => 'пе',
						sat => 'су',
						sun => 'не'
					},
					wide => {
						mon => 'понедељак',
						tue => 'уторак',
						wed => 'среда',
						thu => 'четвртак',
						fri => 'петак',
						sat => 'субота',
						sun => 'недеља'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'пон',
						tue => 'уто',
						wed => 'сре',
						thu => 'чет',
						fri => 'пет',
						sat => 'суб',
						sun => 'нед'
					},
					narrow => {
						mon => 'п',
						tue => 'у',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
					short => {
						mon => 'по',
						tue => 'ут',
						wed => 'ср',
						thu => 'че',
						fri => 'пе',
						sat => 'су',
						sun => 'не'
					},
					wide => {
						mon => 'понедељак',
						tue => 'уторак',
						wed => 'среда',
						thu => 'четвртак',
						fri => 'петак',
						sat => 'субота',
						sun => 'недеља'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'К1',
						1 => 'К2',
						2 => 'К3',
						3 => 'К4'
					},
					narrow => {0 => '1.',
						1 => '2.',
						2 => '3.',
						3 => '4.'
					},
					wide => {0 => 'први квартал',
						1 => 'други квартал',
						2 => 'трећи квартал',
						3 => 'четврти квартал'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'К1',
						1 => 'К2',
						2 => 'К3',
						3 => 'К4'
					},
					narrow => {0 => '1.',
						1 => '2.',
						2 => '3.',
						3 => '4.'
					},
					wide => {0 => 'први квартал',
						1 => 'други квартал',
						2 => 'трећи квартал',
						3 => 'четврти квартал'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
			if ($_ eq 'japanese') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'midnight' => q{поноћ},
					'pm' => q{по подне},
					'am' => q{пре подне},
					'night1' => q{ноћу},
					'evening1' => q{увече},
					'morning1' => q{ујутро},
					'afternoon1' => q{по подне},
					'noon' => q{подне},
				},
				'narrow' => {
					'evening1' => q{увече},
					'morning1' => q{ујутру},
					'noon' => q{подне},
					'afternoon1' => q{по подне},
					'midnight' => q{поноћ},
					'pm' => q{p},
					'am' => q{a},
					'night1' => q{ноћу},
				},
				'wide' => {
					'midnight' => q{поноћ},
					'pm' => q{по подне},
					'am' => q{пре подне},
					'night1' => q{ноћу},
					'evening1' => q{увече},
					'morning1' => q{ујутро},
					'afternoon1' => q{по подне},
					'noon' => q{подне},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'am' => q{пре подне},
					'midnight' => q{поноћ},
					'pm' => q{по подне},
					'night1' => q{ноћ},
					'morning1' => q{јутро},
					'evening1' => q{вече},
					'noon' => q{подне},
					'afternoon1' => q{поподне},
				},
				'wide' => {
					'afternoon1' => q{поподне},
					'noon' => q{подне},
					'morning1' => q{јутро},
					'evening1' => q{вече},
					'night1' => q{ноћ},
					'am' => q{пре подне},
					'pm' => q{по подне},
					'midnight' => q{поноћ},
				},
				'narrow' => {
					'afternoon1' => q{поподне},
					'noon' => q{подне},
					'evening1' => q{вече},
					'morning1' => q{јутро},
					'night1' => q{ноћ},
					'pm' => q{по подне},
					'midnight' => q{поноћ},
					'am' => q{пре подне},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'БЕ'
			},
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'п. н. е.',
				'1' => 'н. е.'
			},
			narrow => {
				'0' => 'п.н.е.',
				'1' => 'н.е.'
			},
			wide => {
				'0' => 'пре нове ере',
				'1' => 'нове ере'
			},
		},
		'hebrew' => {
		},
		'indian' => {
			abbreviated => {
				'0' => 'САКА'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'АХ'
			},
		},
		'japanese' => {
			abbreviated => {
				'0' => 'Таика (645–650)',
				'1' => 'Хакучи (650–671)',
				'2' => 'Хакухо (672–686)',
				'3' => 'Шучо (686–701)',
				'4' => 'Таихо (701–704)',
				'5' => 'Кеиун (704–708)',
				'6' => 'Вадо (708–715)',
				'7' => 'Реики (715–717)',
				'8' => 'Јоро (717–724)',
				'9' => 'Јинки (724–729)',
				'10' => 'Темпио (729–749)',
				'11' => 'Темпио-кампо (749-749)',
				'12' => 'Темпио-шохо (749-757)',
				'13' => 'Темпио-хођи (757-765)',
				'14' => 'Темпо-ђинго (765-767)',
				'15' => 'Ђинго-кеиун (767-770)',
				'16' => 'Хоки (770–780)',
				'17' => 'Тен-о (781-782)',
				'18' => 'Енрјаку (782–806)',
				'19' => 'Даидо (806–810)',
				'20' => 'Конин (810–824)',
				'21' => 'Тенчо (824–834)',
				'22' => 'Шова (834–848)',
				'23' => 'Кајо (848–851)',
				'24' => 'Нињу (851–854)',
				'25' => 'Саико (854–857)',
				'26' => 'Тенан (857–859)',
				'27' => 'Јоган (859–877)',
				'28' => 'Генкеи (877–885)',
				'29' => 'Ниња (885–889)',
				'30' => 'Кампјо (889–898)',
				'31' => 'Шотаи (898–901)',
				'32' => 'Енђи (901–923)',
				'33' => 'Енчо (923–931)',
				'34' => 'Шохеи (931–938)',
				'35' => 'Тенгјо (938–947)',
				'36' => 'Тенриаку (947–957)',
				'37' => 'Тентоку (957–961)',
				'38' => 'Ова (961–964)',
				'39' => 'Кохо (964–968)',
				'40' => 'Ана (968–970)',
				'41' => 'Тенроку (970–973)',
				'42' => 'Тен-ен (973-976)',
				'43' => 'Јоген (976–978)',
				'44' => 'Тенген (978–983)',
				'45' => 'Еикан (983–985)',
				'46' => 'Кана (985–987)',
				'47' => 'Еи-ен (987-989)',
				'48' => 'Еисо (989–990)',
				'49' => 'Шорјаку (990–995)',
				'50' => 'Чотоку (995–999)',
				'51' => 'Чохо (999–1004)',
				'52' => 'Канко (1004–1012)',
				'53' => 'Чова (1012–1017)',
				'54' => 'Канин (1017–1021)',
				'55' => 'Ђиан (1021–1024)',
				'56' => 'Мању (1024–1028)',
				'57' => 'Чоген (1028–1037)',
				'58' => 'Чорјаку (1037–1040)',
				'59' => 'Чокју (1040–1044)',
				'60' => 'Кантоку (1044–1046)',
				'61' => 'Еишо (1046–1053)',
				'62' => 'Тенђи (1053–1058)',
				'63' => 'Кохеи (1058–1065)',
				'64' => 'Ђирјаку (1065–1069)',
				'65' => 'Енкју (1069–1074)',
				'66' => 'Шохо (1074–1077)',
				'67' => 'Шорјаку (1077–1081)',
				'68' => 'Еишо (1081–1084)',
				'69' => 'Отоку (1084–1087)',
				'70' => 'Канђи (1087–1094)',
				'71' => 'Кахо (1094–1096)',
				'72' => 'Еичо (1096–1097)',
				'73' => 'Шотоку (1097–1099)',
				'74' => 'Кова (1099–1104)',
				'75' => 'Чођи (1104–1106)',
				'76' => 'Кашо (1106–1108)',
				'77' => 'Тенин (1108–1110)',
				'78' => 'Тен-еи (1110-1113)',
				'79' => 'Еикју (1113–1118)',
				'80' => 'Ђен-еи (1118-1120)',
				'81' => 'Хоан (1120–1124)',
				'82' => 'Тенђи (1124–1126)',
				'83' => 'Даиђи (1126–1131)',
				'84' => 'Теншо (1131–1132)',
				'85' => 'Чошао (1132–1135)',
				'86' => 'Хоен (1135–1141)',
				'87' => 'Еиђи (1141–1142)',
				'88' => 'Кођи (1142–1144)',
				'89' => 'Тењо (1144–1145)',
				'90' => 'Кјуан (1145–1151)',
				'91' => 'Нинпеи (1151–1154)',
				'92' => 'Кјују (1154–1156)',
				'93' => 'Хоген (1156–1159)',
				'94' => 'Хеиђи (1159–1160)',
				'95' => 'Еирјаку (1160–1161)',
				'96' => 'Охо (1161–1163)',
				'97' => 'Чокан (1163–1165)',
				'98' => 'Еиман (1165–1166)',
				'99' => 'Нин-ан (1166-1169)',
				'100' => 'Као (1169–1171)',
				'101' => 'Шоан (1171–1175)',
				'102' => 'Анген (1175–1177)',
				'103' => 'Ђишо (1177–1181)',
				'104' => 'Јова (1181–1182)',
				'105' => 'Ђуеи (1182–1184)',
				'106' => 'Генрјуку (1184–1185)',
				'107' => 'Бунђи (1185–1190)',
				'108' => 'Кенкју (1190–1199)',
				'109' => 'Шођи (1199–1201)',
				'110' => 'Кенин (1201–1204)',
				'111' => 'Генкју (1204–1206)',
				'112' => 'Кен-еи (1206-1207)',
				'113' => 'Шоген (1207–1211)',
				'114' => 'Кенрјаку (1211–1213)',
				'115' => 'Кенпо (1213–1219)',
				'116' => 'Шокју (1219–1222)',
				'117' => 'Ђу (1222–1224)',
				'118' => 'Ђенин (1224–1225)',
				'119' => 'Кароку (1225–1227)',
				'120' => 'Антеи (1227–1229)',
				'121' => 'Канки (1229–1232)',
				'122' => 'Ђоеи (1232–1233)',
				'123' => 'Темпуку (1233–1234)',
				'124' => 'Бунрјаку (1234–1235)',
				'125' => 'Катеи (1235–1238)',
				'126' => 'Рјакунин (1238–1239)',
				'127' => 'Ен-о (1239-1240)',
				'128' => 'Нињи (1240–1243)',
				'129' => 'Канген (1243–1247)',
				'130' => 'Хођи (1247–1249)',
				'131' => 'Кенчо (1249–1256)',
				'132' => 'Коген (1256–1257)',
				'133' => 'Шока (1257–1259)',
				'134' => 'Шоген (1259–1260)',
				'135' => 'Бун-о (1260-1261)',
				'136' => 'Кочо (1261–1264)',
				'137' => 'Бун-еи (1264-1275)',
				'138' => 'Кенђи (1275–1278)',
				'139' => 'Коан (1278–1288)',
				'140' => 'Шу (1288–1293)',
				'141' => 'Еинин (1293–1299)',
				'142' => 'Шоан (1299–1302)',
				'143' => 'Кенген (1302–1303)',
				'144' => 'Каген (1303–1306)',
				'145' => 'Токуђи (1306–1308)',
				'146' => 'Енкеи (1308–1311)',
				'147' => 'Очо (1311–1312)',
				'148' => 'Шова (1312–1317)',
				'149' => 'Бунпо (1317–1319)',
				'150' => 'Ђено (1319–1321)',
				'151' => 'Ђенкјо (1321–1324)',
				'152' => 'Шочу (1324–1326)',
				'153' => 'Кареки (1326–1329)',
				'154' => 'Гентоку (1329–1331)',
				'155' => 'Генко (1331–1334)',
				'156' => 'Кему (1334–1336)',
				'157' => 'Енген (1336–1340)',
				'158' => 'Кококу (1340–1346)',
				'159' => 'Шохеи (1346–1370)',
				'160' => 'Кентоку (1370–1372)',
				'161' => 'Бучу (1372–1375)',
				'162' => 'Тењу (1375–1379)',
				'163' => 'Корјаку (1379–1381)',
				'164' => 'Кова (1381–1384)',
				'165' => 'Генчу (1384–1392)',
				'166' => 'Меитоку (1384–1387)',
				'167' => 'Какеи (1387–1389)',
				'168' => 'Ку (1389–1390)',
				'169' => 'Меитоку (1390–1394)',
				'170' => 'Оеи (1394–1428)',
				'171' => 'Шочо (1428–1429)',
				'172' => 'Еикјо (1429–1441)',
				'173' => 'Какитсу (1441–1444)',
				'174' => 'Бун-ан (1444-1449)',
				'175' => 'Хотоку (1449–1452)',
				'176' => 'Кјотоку (1452–1455)',
				'177' => 'Кошо (1455–1457)',
				'178' => 'Чороку (1457–1460)',
				'179' => 'Каншо (1460–1466)',
				'180' => 'Буншо (1466–1467)',
				'181' => 'Онин (1467–1469)',
				'182' => 'Бунмеи (1469–1487)',
				'183' => 'Чокјо (1487–1489)',
				'184' => 'Ентоку (1489–1492)',
				'185' => 'Меио (1492–1501)',
				'186' => 'Бунки (1501–1504)',
				'187' => 'Еишо (1504–1521)',
				'188' => 'Таиеи (1521–1528)',
				'189' => 'Кјороку (1528–1532)',
				'190' => 'Тенмон (1532–1555)',
				'191' => 'Кођи (1555–1558)',
				'192' => 'Еироку (1558–1570)',
				'193' => 'Генки (1570–1573)',
				'194' => 'Теншо (1573–1592)',
				'195' => 'Бунроку (1592–1596)',
				'196' => 'Кеичо (1596–1615)',
				'197' => 'Генва (1615–1624)',
				'198' => 'Кан-еи (1624-1644)',
				'199' => 'Шохо (1644–1648)',
				'200' => 'Кеиан (1648–1652)',
				'201' => 'Шу (1652–1655)',
				'202' => 'Меирјаку (1655–1658)',
				'203' => 'Мањи (1658–1661)',
				'204' => 'Канбун (1661–1673)',
				'205' => 'Енпо (1673–1681)',
				'206' => 'Тенва (1681–1684)',
				'207' => 'Јокјо (1684–1688)',
				'208' => 'Генроку (1688–1704)',
				'209' => 'Хоеи (1704–1711)',
				'210' => 'Шотоку (1711–1716)',
				'211' => 'Кјохо (1716–1736)',
				'212' => 'Генбун (1736–1741)',
				'213' => 'Канпо (1741–1744)',
				'214' => 'Енкјо (1744–1748)',
				'215' => 'Кан-ен (1748-1751)',
				'216' => 'Хорјаку (1751–1764)',
				'217' => 'Меива (1764–1772)',
				'218' => 'Ан-еи (1772-1781)',
				'219' => 'Тенмеи (1781–1789)',
				'220' => 'Кансеи (1789–1801)',
				'221' => 'Кјова (1801–1804)',
				'222' => 'Бунка (1804–1818)',
				'223' => 'Бунсеи (1818–1830)',
				'224' => 'Тенпо (1830–1844)',
				'225' => 'Кока (1844–1848)',
				'226' => 'Каеи (1848–1854)',
				'227' => 'Ансеи (1854–1860)',
				'228' => 'Ман-ен (1860-1861)',
				'229' => 'Бункју (1861–1864)',
				'230' => 'Генђи (1864–1865)',
				'231' => 'Кеико (1865–1868)',
				'232' => 'Меиђи',
				'233' => 'Таишо',
				'234' => 'Шова',
				'235' => 'Хаисеи'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'АП'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'Пре РК',
				'1' => 'РК'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE, d. MMMM y. G},
			'long' => q{d. MMMM y. G},
			'medium' => q{d.MM.y. G},
			'short' => q{d.M.y. GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, dd. MMMM y.},
			'long' => q{dd. MMMM y.},
			'medium' => q{dd.MM.y.},
			'short' => q{d.M.yy.},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
			'full' => q{EEEE, MMMM d, y G},
			'long' => q{MMMM d, y G},
			'medium' => q{MMM d, y G},
			'short' => q{M/d/yy G},
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{h B},
			Bhm => q{hh:mm B},
			Bhms => q{hh:mm:ss B},
			E => q{ccc},
			EBhm => q{E hh:mm B},
			EBhms => q{E hh:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E d.},
			Ehm => q{E hh:mm a},
			Ehms => q{E hh:mm:ss a},
			Gy => q{y. G},
			GyMMM => q{MMM y. G},
			GyMMMEd => q{E, d. MMM y. G},
			GyMMMd => q{d. MMM y. G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d.M.},
			MMM => q{LLL},
			MMMEd => q{E, d. MMM},
			MMMMEd => q{E, d. MMMM},
			MMMMd => q{d. MMMM},
			MMMd => q{d. MMM},
			MMMdd => q{dd.MMM},
			MMdd => q{MM-dd},
			Md => q{d.M.},
			d => q{d},
			h => q{h a},
			hm => q{hh:mm a},
			hms => q{hh:mm:ss a},
			ms => q{mm:ss},
			y => q{y. G},
			yyyy => q{y. G},
			yyyyM => q{M.y. GGGGG},
			yyyyMEd => q{E, d.M.y. GGGGG},
			yyyyMM => q{MM.y. G},
			yyyyMMM => q{MMM y. G},
			yyyyMMMEd => q{E, d. MMM y. G},
			yyyyMMMM => q{MMMM y. G},
			yyyyMMMd => q{d. MMM y. G},
			yyyyMMdd => q{dd.MM.y. G},
			yyyyMd => q{d.M.y. GGGGG},
			yyyyQQQ => q{QQQ, y. G},
			yyyyQQQQ => q{QQQQ y. G},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{hh:mm B},
			Bhms => q{hh:mm:ss B},
			E => q{E},
			EBhm => q{E hh:mm B},
			EBhms => q{E hh:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E d.},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y. G},
			GyMMM => q{MMM y. G},
			GyMMMEd => q{E, d. MMM y. G},
			GyMMMd => q{d. MMM y. G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E, d.M.},
			MMM => q{LLL},
			MMMEd => q{E d. MMM},
			MMMMEd => q{E, d. MMMM},
			MMMMW => q{W. 'седмица' 'у' MMM.},
			MMMMd => q{d. MMMM},
			MMMd => q{d. MMM},
			MMMdd => q{dd.MMM},
			MMdd => q{dd.MM.},
			Md => q{d.M.},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y.},
			yM => q{M.y.},
			yMEd => q{E, d.M.y.},
			yMM => q{MM.y.},
			yMMM => q{MMM y.},
			yMMMEd => q{E, d. MMM y.},
			yMMMM => q{MMMM y.},
			yMMMd => q{d. MMM y.},
			yMMdd => q{dd.MM.y.},
			yMd => q{d.M.y.},
			yQQQ => q{QQQ y.},
			yQQQQ => q{QQQQ y.},
			yw => q{w. 'седмица' 'у' Y.},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d.M – E, d.M},
				d => q{E, d.M – E, d.M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, dd. MMM – E, dd. MMM},
				d => q{E, dd. – E, dd. MMM},
			},
			MMMd => {
				M => q{d. MMM – d. MMM},
				d => q{d – d. MMM},
			},
			Md => {
				M => q{d.M – d.M},
				d => q{d.M – d.M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y – y. G},
			},
			yM => {
				M => q{M.y – M.y. GGGGG},
				y => q{M.y – M.y. GGGGG},
			},
			yMEd => {
				M => q{E, d.M.y – E, d.M.y. GGGGG},
				d => q{E, d.M.y – E, d.M.y. GGGGG},
				y => q{E, d.M.y – E, d.M.y. GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y. G},
				y => q{MMM y – MMM y. G},
			},
			yMMMEd => {
				M => q{E, d. MMM – E, d. MMM y. G},
				d => q{E, d. MMM – E, d. MMM y. G},
				y => q{E, d. MMM y – E, d. MMM y. G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y. G},
				y => q{MMMM y. – MMMM y. G},
			},
			yMMMd => {
				M => q{d. MMM – d. MMM y. G},
				d => q{d–d. MMM y. G},
				y => q{d. MMM y. – d. MMM y. G},
			},
			yMd => {
				M => q{d.M.y. – d.M.y.},
				d => q{d.M.y – d.M.y. GGGGG},
				y => q{d.M.y – d.M.y. GGGGG},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d.M – E, d.M},
				d => q{E, d.M – E, d.M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, dd. MMM – E, dd. MMM},
				d => q{E, dd. – E, dd. MMM},
			},
			MMMd => {
				M => q{dd. MMM – dd. MMM},
				d => q{dd.–dd. MMM},
			},
			Md => {
				M => q{d.M – d.M},
				d => q{d.M – d.M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M – M, y},
				y => q{M.y. – M.y.},
			},
			yMEd => {
				M => q{E, d.M.y. – E, d.M.y.},
				d => q{E, d.M.y. – E, d.M.y.},
				y => q{E, d.M.y. – E, d.M.y.},
			},
			yMMM => {
				M => q{MMM–MMM y.},
				y => q{MMM y. – MMM y.},
			},
			yMMMEd => {
				M => q{E, dd. MMM – E, dd. MMM y.},
				d => q{E, dd. – E, dd. MMM y.},
				y => q{E, dd. MMM y. – E, dd. MMM y.},
			},
			yMMMM => {
				M => q{MMMM – MMMM y.},
				y => q{MMMM y. – MMMM y.},
			},
			yMMMd => {
				M => q{dd. MMM – dd. MMM y.},
				d => q{dd.–dd. MMM y.},
				y => q{dd. MMM y. – dd. MMM y.},
			},
			yMd => {
				M => q{d.M.y. – d.M.y.},
				d => q{d.M.y. – d.M.y.},
				y => q{d.M.y. – d.M.y.},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0}),
		regionFormat => q({0}, летње време),
		regionFormat => q({0}, стандардно време),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q#Акре летње рачунање времена#,
				'generic' => q#Акре време#,
				'standard' => q#Акре стандардно време#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#Авганистан време#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиџан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Акра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Адис Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмера#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Бангуи#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисао#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантир#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Бразавил#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Буџумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каиро#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Казабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-ес-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Џибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Ел Ајун#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габорон#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Јоханесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Џуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Картум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревил#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадиш#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровија#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Најроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нџамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Нијамеј#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сао Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#Централно-афричко време#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#Источно-афричко време#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#Јужно-афричко време#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Западно-афричко летње време#,
				'generic' => q#Западно-афричко време#,
				'standard' => q#Западно-афричко стандардно време#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Аљаска, летње време#,
				'generic' => q#Аљаска#,
				'standard' => q#Аљаска, стандардно време#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#Алмати летње рачунање времена#,
				'generic' => q#Алмати време#,
				'standard' => q#Алмати стандардно време#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Амазон, летње време#,
				'generic' => q#Амазон време#,
				'standard' => q#Амазон, стандардно време#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Енкориџ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангвила#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигва#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагвајана#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио Гаљегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луи#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуаија#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсион#,
		},
		'America/Bahia' => {
			exemplarCity => q#Баија#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баија Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белизе#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Сејблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бојзи#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буенос Ајрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кембриџ Беј#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кајен#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кајманска Острва#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чихуахуа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал Харбур#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордоба#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Костарика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куиаба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кирасо#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмарксхаген#,
		},
		'America/Dawson' => {
			exemplarCity => q#Досон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Досон Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детроит#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Едмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Еирунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Салвадор#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Форт Нелсон#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глејс Беј#,
		},
		'America/Godthab' => {
			exemplarCity => q#Готхаб#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус Беј#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Турк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гвадалупе#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гвајакил#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гвајана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Халифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Хавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Хермосиљо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индијана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индијана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсбург, Индијана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Тел Сити, Индијана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вевај, Индијана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винценес, Индијана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак, Индијана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Иквалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Јамајка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуи#,
		},
		'America/Juneau' => {
			exemplarCity => q#Жуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичело, Кентаки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендајк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Паз#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос Анђелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луивиле#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуер Принсиз Квортер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масејо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагва#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиник#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоса#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мексико Сити#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтереј#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсерат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Насау#,
		},
		'America/New_York' => {
			exemplarCity => q#Њујорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Нороња#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бијула, Северна Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Центар, Северна Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нови Салем, Северна Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртунг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Финикс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт о Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт оф Спејн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто Вељо#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Порто Рико#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#Пунта Аренас#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рејни Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ранкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифе#,
		},
		'America/Regina' => {
			exemplarCity => q#Регина#,
		},
		'America/Resolute' => {
			exemplarCity => q#Ресолут#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта Изабел#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантјаго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сао Паоло#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Скорезбисунд#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Св. Бартоломeј#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Св. Џон#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Св. Луција#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Св. Тома#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт Курент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигалпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Тул#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тандер Беј#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Вајтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Винипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Јакутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Јелоунајф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Северноамеричко централно летње време#,
				'generic' => q#Северноамеричко централно време#,
				'standard' => q#Северноамеричко централно стандардно време#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Северноамеричко источно летње време#,
				'generic' => q#Северноамеричко источно време#,
				'standard' => q#Северноамеричко источно стандардно време#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Северноамеричко планинско летње време#,
				'generic' => q#Северноамеричко планинско време#,
				'standard' => q#Северноамеричко планинско стандардно време#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Северноамеричко пацифичко летње време#,
				'generic' => q#Северноамеричко пацифичко време#,
				'standard' => q#Северноамеричко пацифичко стандардно време#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#Анадир летње рачунање времена#,
				'generic' => q#Анадир време#,
				'standard' => q#Анадир стандардно време#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кејси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дејвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Димон д’Урвил#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Меквори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Мосон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Макмурдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Шова#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Трол#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q#Апија, летње време#,
				'generic' => q#Апија време#,
				'standard' => q#Апија, стандардно време#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#Акватау летње рачунање времена#,
				'generic' => q#Акватау време#,
				'standard' => q#Акватау стандардно време#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#Акутобе летње рачунање времена#,
				'generic' => q#Акутобе време#,
				'standard' => q#Акутобе стандардно време#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#Арабијско летње време#,
				'generic' => q#Арабијско време#,
				'standard' => q#Арабијско стандардно време#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгјербјен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#Аргентина, летње време#,
				'generic' => q#Аргентина време#,
				'standard' => q#Аргентина, стандардно време#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Западна Аргентина, летње време#,
				'generic' => q#Западна Аргентина време#,
				'standard' => q#Западна Аргентина, стандардно време#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Јерменија, летње време#,
				'generic' => q#Јерменија време#,
				'standard' => q#Јерменија, стандардно време#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алмати#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Аман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадир#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Акутобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Атирау#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахреин#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Барнаул#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бејрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Брунеј#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калкута#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чојбалсан#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дака#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубаи#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#Фамагуста#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Хонгконг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркуцк#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Џакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Џајапура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Јерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандига#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Краснојарск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувајт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никозија#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузњецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пном Пен#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтијанак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пјонгјанг#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кизилорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Ријад#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шангај#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Средњеколимск#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тајпеј#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Техеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тимпу#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Томск#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумћи#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Уст-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вијентијан#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Јакутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Јекатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Јереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Атлантско летње време#,
				'generic' => q#Атлантско време#,
				'standard' => q#Атлантско стандардно време#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азори#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуда#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канарска острва#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Зеленортска Острва#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарска Острва#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадеира#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рејкјавик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Јужна Џорџија#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Света Јелена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стенли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделејд#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Бризбејн#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен Хил#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Кари#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Иукла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мелбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сиднеј#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Аустралијско централно летње време#,
				'generic' => q#Аустралијско централно време#,
				'standard' => q#Аустралијско централно стандардно време#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Аустралијско централно западно летње време#,
				'generic' => q#Аустралијско централно западно време#,
				'standard' => q#Аустралијско централно западно стандардно време#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Аустралијско источно летње време#,
				'generic' => q#Аустралијско источно време#,
				'standard' => q#Аустралијско источно стандардно време#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Аустралијско западно летње време#,
				'generic' => q#Аустралијско западно време#,
				'standard' => q#Аустралијско западно стандардно време#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Азербејџан, летње време#,
				'generic' => q#Азербејџан време#,
				'standard' => q#Азербејџан, стандардно време#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Азори, летње време#,
				'generic' => q#Азори време#,
				'standard' => q#Азори, стандардно време#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Бангладеш, летње време#,
				'generic' => q#Бангладеш време#,
				'standard' => q#Бангладеш, стандардно време#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Бутан време#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#Боливија време#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Бразилија, летње време#,
				'generic' => q#Бразилија време#,
				'standard' => q#Бразилија, стандардно време#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Брунеј Дарусалум време#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Зеленортска Острва, летње време#,
				'generic' => q#Зеленортска Острва време#,
				'standard' => q#Зеленортска Острва, стандардно време#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#Чаморо време#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Чатам, летње време#,
				'generic' => q#Чатам време#,
				'standard' => q#Чатам, стандардно време#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Чиле, летње време#,
				'generic' => q#Чиле време#,
				'standard' => q#Чиле, стандардно време#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Кина, летње време#,
				'generic' => q#Кина време#,
				'standard' => q#Кинеско стандардно време#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#Чојбалсан, летње време#,
				'generic' => q#Чојбалсан време#,
				'standard' => q#Чојбалсан, стандардно време#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#Божићно острво време#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#Кокос (Келинг) Острва време#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Колумбија, летње време#,
				'generic' => q#Колумбија време#,
				'standard' => q#Колумбија, стандардно време#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Кукова острва, полу-летње време#,
				'generic' => q#Кукова острва време#,
				'standard' => q#Кукова острва, стандардно време#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Куба, летње време#,
				'generic' => q#Куба#,
				'standard' => q#Куба, стандардно време#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#Дејвис време#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#Димон д’Урвил време#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Источни тимор време#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#Ускршња острва, летње време#,
				'generic' => q#Ускршња острва време#,
				'standard' => q#Ускршња острва, стандардно време#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#Еквадор време#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#Координисано универзално време#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Непознат град#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андора#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Астракан#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Атина#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Београд#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брисел#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Букурешт#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будимпешта#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бисинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишињев#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенхаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Даблин#,
			long => {
				'daylight' => q#Ирска, стандардно време#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернзи#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хелсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Острво Ман#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Истанбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Џерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калињинград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Кијев#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Киров#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лисабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Љубљана#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q#Британија, летње време#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Луксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Малта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Марихамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париз#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Праг#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сарајево#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Саратов#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферопољ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопље#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Софија#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокхолм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Талин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Уљановск#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуз#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Беч#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вилњус#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожје#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цирих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Средњеевропско летње време#,
				'generic' => q#Средњеевропско време#,
				'standard' => q#Средњеевропско стандардно време#,
			},
			short => {
				'daylight' => q#CEST#,
				'generic' => q#CET#,
				'standard' => q#CET#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Источноевропско летње време#,
				'generic' => q#Источноевропско време#,
				'standard' => q#Источноевропско стандардно време#,
			},
			short => {
				'daylight' => q#EEST#,
				'generic' => q#EET#,
				'standard' => q#EET#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#Даљи исток Европе#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Западноевропско летње време#,
				'generic' => q#Западноевропско време#,
				'standard' => q#Западноевропско стандардно време#,
			},
			short => {
				'daylight' => q#WEST#,
				'generic' => q#WET#,
				'standard' => q#WET#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Фолкландска Острва, летње време#,
				'generic' => q#Фолкландска Острва време#,
				'standard' => q#Фолкландска Острва, стандардно време#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Фиџи, летње време#,
				'generic' => q#Фиџи време#,
				'standard' => q#Фиџи, стандардно време#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Француска Гвајана време#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Француско јужно и антарктичко време#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#Средње време по Гриничу#,
			},
			short => {
				'standard' => q#GMT#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Галапагос време#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#Гамбије време#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Грузија, летње време#,
				'generic' => q#Грузија време#,
				'standard' => q#Грузија, стандардно време#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#Гилберт острва време#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Источни Гренланд, летње време#,
				'generic' => q#Источни Гренланд#,
				'standard' => q#Источни Гренланд, стандардно време#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Западни Гренланд, летње време#,
				'generic' => q#Западни Гренланд#,
				'standard' => q#Западни Гренланд, стандардно време#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#Гуам стандардно време#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#Заливско време#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#Гвајана време#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Хавајско-алеутско летње време#,
				'generic' => q#Хавајско-алеутско време#,
				'standard' => q#Хавајско-алеутско стандардно време#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Хонг Конг, летње време#,
				'generic' => q#Хонг Конг време#,
				'standard' => q#Хонг Конг, стандардно време#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Ховд, летње време#,
				'generic' => q#Ховд време#,
				'standard' => q#Ховд, стандардно време#,
			},
		},
		'India' => {
			long => {
				'standard' => q#Индијско стандардно време#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Божић#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморо#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Малдиви#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маурицијус#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Мајот#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реунион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Индијско океанско време#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#Индокина време#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Централно-индонезијско време#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Источно-индонезијско време#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Западно-индонезијско време#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#Иран, летње време#,
				'generic' => q#Иран време#,
				'standard' => q#Иран, стандардно време#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Иркуцк, летње време#,
				'generic' => q#Иркуцк време#,
				'standard' => q#Иркуцк, стандардно време#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Израелско летње време#,
				'generic' => q#Израелско време#,
				'standard' => q#Израелско стандардно време#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Јапанско летње време#,
				'generic' => q#Јапанско време#,
				'standard' => q#Јапанско стандардно време#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#Петропавловско-камчатско летње рачунање времена#,
				'generic' => q#Петропавловско-камчатско време#,
				'standard' => q#Петропавловско-камчатско стандардно време#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#Источно-казахстанско време#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#Западно-казахстанско време#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Корејско летње време#,
				'generic' => q#Корејско време#,
				'standard' => q#Корејско стандардно време#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Кошре време#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Краснојарск, летње време#,
				'generic' => q#Краснојарск време#,
				'standard' => q#Краснојарск, стандардно време#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Киргистан време#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#Шри Ланка време#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#Острва Лајн време#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Лорд Хов, летње време#,
				'generic' => q#Лорд Хов време#,
				'standard' => q#Лорд Хов, стандардно време#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#Макао летње рачунање времена#,
				'generic' => q#Макао време#,
				'standard' => q#Макао стандардно време#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#Острво Маквери време#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Магадан, летње време#,
				'generic' => q#Магадан време#,
				'standard' => q#Магадан, стандардно време#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#Малезија време#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#Малдиви време#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Маркиз време#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#Маршалска Острва време#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Маурицијус, летње време#,
				'generic' => q#Маурицијус време#,
				'standard' => q#Маурицијус, стандардно време#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Мосон време#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#Северозападни Мексико, летње време#,
				'generic' => q#Северозападни Мексико#,
				'standard' => q#Северозападни Мексико, стандардно време#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#Мексички Пацифик, летње време#,
				'generic' => q#Мексички Пацифик#,
				'standard' => q#Мексички Пацифик, стандардно време#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Улан Батор, летње време#,
				'generic' => q#Улан Батор време#,
				'standard' => q#Улан Батор, стандардно време#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Москва, летње време#,
				'generic' => q#Москва време#,
				'standard' => q#Москва, стандардно време#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#Мијанмар време#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Науру време#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Непал време#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Нова Каледонија, летње време#,
				'generic' => q#Нова Каледонија време#,
				'standard' => q#Нова Каледонија, стандардно време#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Нови Зеланд, летње време#,
				'generic' => q#Нови Зеланд време#,
				'standard' => q#Нови Зеланд, стандардно време#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Њуфаундленд, летње време#,
				'generic' => q#Њуфаундленд#,
				'standard' => q#Њуфаундленд, стандардно време#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#Ниуе време#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#Норфолк Острво време#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Фернандо де Нороња, летње време#,
				'generic' => q#Фернандо де Нороња време#,
				'standard' => q#Фернандо де Нороња, стандардно време#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#Северна Маријанска Острва време#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Новосибирск, летње време#,
				'generic' => q#Новосибирск време#,
				'standard' => q#Новосибирск, стандардно време#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Омск, летње време#,
				'generic' => q#Омск време#,
				'standard' => q#Омск, стандардно време#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апија#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окланд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Буганвил#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатам#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Ускршње острво#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Ефат#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Ендербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиџи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбије#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гвадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Хонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Џонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Кошре#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваџалејин#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Мајуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркиз#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидвеј#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуе#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкерн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понапе#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт Морзби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сајпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Тахити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Трук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Вејк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Валис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Пакистан, летње време#,
				'generic' => q#Пакистан време#,
				'standard' => q#Пакистан, стандардно време#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Палау време#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Папуа Нова Гвинеја време#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Парагвај, летње време#,
				'generic' => q#Парагвај време#,
				'standard' => q#Парагвај, стандардно време#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Перу, летње време#,
				'generic' => q#Перу време#,
				'standard' => q#Перу, стандардно време#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Филипини, летње време#,
				'generic' => q#Филипини време#,
				'standard' => q#Филипини, стандардно време#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#Феникс острва време#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Сен Пјер и Микелон, летње време#,
				'generic' => q#Сен Пјер и Микелон#,
				'standard' => q#Сен Пјер и Микелон, стандардно време#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#Питкерн време#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Понпеј време#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#Пјонгјаншко време#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#Кизилорда летње рачунање времена#,
				'generic' => q#Кизилорда време#,
				'standard' => q#Кизилорда стандардно време#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#Реинион време#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#Ротера време#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Сахалин, летње време#,
				'generic' => q#Сахалин време#,
				'standard' => q#Сахалин, стандардно време#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#Самара летње рачунање времена#,
				'generic' => q#Самара време#,
				'standard' => q#Самара стандардно време#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Самоа, летње време#,
				'generic' => q#Самоа време#,
				'standard' => q#Самоа, стандардно време#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Сејшели време#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Сингапур, стандардно време#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#Соломонска Острва време#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#Јужна Џорџија време#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Суринам време#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#Шова време#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#Тахити време#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Тајпеј, летње време#,
				'generic' => q#Тајпеј време#,
				'standard' => q#Тајпеј, стандардно време#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Таџикистан време#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Токелау време#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Тонга, летње време#,
				'generic' => q#Тонга време#,
				'standard' => q#Тонга, стандардно време#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#Чуук време#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Туркменистан, летње време#,
				'generic' => q#Туркменистан време#,
				'standard' => q#Туркменистан, стандардно време#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#Тувалу време#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Уругвај, летње време#,
				'generic' => q#Уругвај време#,
				'standard' => q#Уругвај, стандардно време#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Узбекистан, летње време#,
				'generic' => q#Узбекистан време#,
				'standard' => q#Узбекистан, стандардно време#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Вануату, летње време#,
				'generic' => q#Вануату време#,
				'standard' => q#Вануату, стандардно време#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Венецуела време#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Владивосток, летње време#,
				'generic' => q#Владивосток време#,
				'standard' => q#Владивосток, стандардно време#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Волгоград, летње време#,
				'generic' => q#Волгоград време#,
				'standard' => q#Волгоград, стандардно време#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Восток време#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Вејк острво време#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Валис и Футуна Острва време#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Јакутск, летње време#,
				'generic' => q#Јакутск време#,
				'standard' => q#Јакутск, стандардно време#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Јекатеринбург, летње време#,
				'generic' => q#Јекатеринбург време#,
				'standard' => q#Јекатеринбург, стандардно време#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
