# NEVER EDIT this file.  It was generated and will be overwritten without
# notice upon regeneration of this application.  You have been warned.
package JobAd::GEN::Job;

use strict;
use warnings;

use base 'JobAd';
use JSON;
use Gantry::Utils::TablePerms;

use JobAd::Model::job qw(
    $JOB
);

#-----------------------------------------------------------------
# $self->do_main(  )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = @_;

    $self->stash->view->template( 'results.tt' );
    $self->stash->view->title( 'Job' );

    my $real_location = $self->location() || '';
    if ( $real_location ) {
        $real_location =~ s{/+$}{};
        $real_location .= '/';
    }

    my @header_options = (
        {
            text => 'Add',
            link => $real_location . "add",
            type => 'create',
        },
    );

    my $retval = {
        headings       => [
            'Title',
            'Description',
        ],
    };

    my $params = $self->params;

    my $search = {};
    if ( $params->{ search } ) {
        my $form = $self->form();

        my @searches;
        foreach my $field ( @{ $form->{ fields } } ) {
            if ( $field->{ searchable } ) {
                push( @searches,
                    ( $field->{ name } => { 'like', "%$params->{ search }%"  } )
                );
            }
        }

        $search = {
            -or => \@searches
        } if scalar( @searches ) > 0;
    }

    my @row_options = (
        {
            text => 'Edit',
            type => 'update',
        },
        {
            text => 'Delete',
            type => 'delete',
        },
    );

    my $perm_obj = Gantry::Utils::TablePerms->new(
        {
            site           => $self,
            real_location  => $real_location,
            header_options => \@header_options,
            row_options    => \@row_options,
        }
    );

    $retval->{ header_options } = $perm_obj->real_header_options;

    my $limit_to_user_id = $perm_obj->limit_to_user_id;
    $search->{ user_id } = $limit_to_user_id if ( $limit_to_user_id );

    my $schema = $self->get_schema();
    my @rows   = $JOB->get_listing(
        {
            schema   => $schema,
            where    => $search,
        }
    );

    ROW:
    foreach my $row ( @rows ) {
        last ROW if $perm_obj->hide_all_data;

        my $id = $row->id;

        push(
            @{ $retval->{rows} }, {
                orm_row => $row,
                data => [
                    $row->title,
                    $row->description,
                ],
                options => $perm_obj->real_row_options( $row ),
            }
        );
    }

    if ( $params->{ json } ) {
        $self->template_disable( 1 );

        my $obj = {
            headings        => $retval->{ headings },
            header_options  => $retval->{ header_options },
            rows            => $retval->{ rows },
        };

        my $json = objToJson( $obj, { skipinvalid => 1 } );
        return( $json );
    }

    $self->stash->view->data( $retval );
} # END do_main

#-----------------------------------------------------------------
# $self->job_form( $data )
#-----------------------------------------------------------------
sub job_form {
    my ( $self, $data ) = @_;

    my $selections = $JOB->get_form_selections(
            { schema => $self->get_schema() }
    );

    return {
        row        => $data->{row},
        legend => $self->path_info =~ /edit/i ? 'Edit' : 'Add',
        fields     => [
            {
                name => 'title',
                label => 'Title',
                type => 'text',
                is => 'varchar',
            },
            {
                name => 'description',
                label => 'Description',
                type => 'textarea',
                is => 'varchar',
                rows => 6,
                cols => 55,
            },
            {
                name => 'travel_percent',
                label => 'Travel Percent',
                type => 'text',
                is => 'varchar',
            },
            {
                options => [
                    { label => 'On-Site', value => 'onsite' },
                    { label => 'Partial Telecommute', value => 'parttele' },
                    { label => 'Telecommute', value => 'tele' },
                ],
                name => 'on_site',
                label => 'On Site',
                type => 'select',
                is => 'varchar',
            },
            {
                options => [
                    { label => 'Full Time', value => 'full' },
                    { label => 'Part Time', value => 'part' },
                    { label => 'Contract', value => 'con' },
                ],
                name => 'time_percent',
                label => 'Time Percent',
                type => 'select',
                is => 'varchar',
            },
        ],
    };
} # END job_form

1;

=head1 NAME

JobAd::GEN::Job - generated support module for JobAd::Job

=head1 SYNOPSIS

In JobAd::Job:

    use base 'JobAd::GEN::Job';

=head1 DESCRIPTION

This module was generated by bigtop and IS subject to regeneration.
Use it in JobAd::Job to provide the methods below.
Feel free to override them.

=head1 METHODS

=over 4

=item do_main

=item job_form


=back

=head1 AUTHOR

Generated by bigtop and subject to regeneration.

=cut

