/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

public class NormalizeResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private ExecRow normalizedRow;
    private int numCols;
    private int startCol;
    private ResultDescription resultDescription;
    private GeneratedMethod closeCleanup;
    private DataTypeDescriptor[] desiredTypes;

    public NormalizeResultSet(NoPutResultSet noPutResultSet, Activation activation, int n, int n2, double d, double d2, boolean bl, GeneratedMethod generatedMethod) throws StandardException {
        super(activation, n, d, d2);
        this.source = noPutResultSet;
        this.resultDescription = (ResultDescription)activation.getPreparedStatement().getSavedObject(n2);
        this.numCols = this.resultDescription.getColumnCount();
        this.startCol = bl ? (this.numCols - 1) / 2 + 1 : 1;
        this.normalizedRow = activation.getExecutionFactory().getValueRow(this.numCols);
        this.closeCleanup = generatedMethod;
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        execRow = this.source.getNextRowCore();
        if (execRow != null) {
            execRow2 = this.normalizeRow(execRow);
            ++this.rowsSeen;
        }
        this.currentRow = execRow2;
        this.setCurrentRow(execRow2);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow2;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            if (this.closeCleanup != null) {
                this.closeCleanup.invoke(this.activation);
            }
            this.currentRow = null;
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source.getTimeSpent(1);
        }
        return l;
    }

    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    private ExecRow normalizeRow(ExecRow execRow) throws StandardException {
        Formatable formatable;
        int n;
        if (this.desiredTypes == null) {
            this.desiredTypes = new DataTypeDescriptor[this.numCols];
            for (n = 1; n <= this.numCols; ++n) {
                formatable = this.resultDescription.getColumnDescriptor(n).getType();
                this.desiredTypes[n - 1] = formatable;
            }
        }
        for (n = 1; n <= this.numCols; ++n) {
            Formatable formatable2;
            formatable = execRow.getColumn(n);
            if (formatable == null) continue;
            if (n < this.startCol) {
                formatable2 = formatable;
            } else {
                try {
                    formatable2 = this.desiredTypes[n - 1].normalize((DataValueDescriptor)formatable, this.normalizedRow.getColumn(n));
                }
                catch (StandardException standardException) {
                    if (standardException.getMessageId().startsWith("23502")) {
                        ResultColumnDescriptor resultColumnDescriptor = this.resultDescription.getColumnDescriptor(n);
                        throw StandardException.newException("23502", resultColumnDescriptor.getName());
                    }
                    throw standardException;
                }
            }
            this.normalizedRow.setColumn(n, (DataValueDescriptor)formatable2);
        }
        return this.normalizedRow;
    }
}

