package
    Pinto::Remote::SelfContained::Action::Add; # hide from PAUSE
# ABSTRACT: add a distribution to a the repository

use v5.10;
use Moo;

use Carp qw(croak);
use Pinto::Remote::SelfContained::Types qw(SingleBodyPart);

use namespace::clean;

our $VERSION = '1.999'; # TRIAL VERSION

extends qw(Pinto::Remote::SelfContained::Action);

has archives => (is => 'ro', isa => SingleBodyPart, required => 1);

around BUILDARGS => sub {
    my ($orig, $class, @rest) = @_;

    my $args = $class->$orig(@rest);

    $args->{args}{author} //= $ENV{PINTO_AUTHOR_ID}
        if defined $ENV{PINTO_AUTHOR_ID};

    $args->{archives} //= delete $args->{args}{archives};

    return $args;
};

around _make_body_parts => sub {
    my ($orig, $self) = @_;

    my $body = $self->$orig;
    my $archives = $self->archives;
    push @$body, @$archives;

    return $body;
};

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Pinto::Remote::SelfContained::Action::Add - add a distribution to a the repository

=head1 VERSION

version 1.999

=head1 AUTHOR

Brad Lhotsky <brad@divisionbyzero.net>

=head1 CONTRIBUTOR

=for stopwords Aaron Crane

Aaron Crane <arc@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by Aaron Crane.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
