## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::json_or_str;

our $DATE = '2022-11-15'; # DATE
our $VERSION = '0.007'; # VERSION

our $rschema = do{my$var={base=>"any",clsets_after_base=>[{description=>"\nYou can use this schema if you want to accept any data (a data structure or\nsimple scalar), and if user supplies a defined string e.g. in a command-line\nscript as command-line argument or option, it will be tried to be JSON-decoded\nfirst. If the string does not contain valid JSON, it will be left as-is as\nstring.\n\nThis schema is convenient on the command-line where you want to accept data\nstructure via command-line argument or option. But you have to be careful when\nyou want to pass a string like `null`, `true`, `false`; you have to quote it to\n`\"null\"`, `\"true\"`, `\"false\"` to prevent it being decoded into undef or\nboolean values.\n\nSee also related schema: `json_str`, `str::encoded_json`, `str::escaped_json`.\n\n",examples=>[{summary=>"Empty string, left as-is as string",valid=>1,value=>""},{valid=>1,value=>1},{summary=>"JSON-decoded and becomes undef",valid=>1,validated_value=>undef,value=>"null"},{summary=>"JSON-decoded into string",valid=>1,validated_value=>"null",value=>"\"null\""},{summary=>"JSON-decoded into array",valid=>1,validated_value=>[1,2,3,{}],value=>"[1,2,3,{}]"},{summary=>"Left as-is as string since it is invalid JSON (missing closing square bracket)",valid=>1,value=>"[1,2"},{summary=>"Left as-is as string since it is invalid JSON (dangling comma)",valid=>1,value=>"[1,2,]"},{summary=>"Not coerced, already an array",valid=>1,value=>[1,2]},{summary=>"Not coerced, already a hash",valid=>1,value=>{}},{summary=>"Not coerced, already an undef",valid=>1,value=>undef}],prefilters=>["Str::try_decode_json"],summary=>"A JSON-encoded data or string"}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["any"],type=>"any",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: A JSON-encoded data or string

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::json_or_str - A JSON-encoded data or string

=head1 VERSION

This document describes version 0.007 of Sah::SchemaR::json_or_str (from Perl distribution Sah-Schemas-JSON), released on 2022-11-15.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-JSON>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-JSON>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022, 2021 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-JSON>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
