# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240308154347;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{de} = {"434876", "Kals\ am\ Großglockner",
"435449", "Fließ",
"432242", "Sankt\ Andrä\-Wördern",
"435557", "Sankt\ Gallenkirch",
"435352", "Sankt\ Johann\ in\ Tirol",
"434264", "Klein\ Sankt\ Paul",
"432719", "Droß",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"432642", "Aspangberg\-Sankt\ Peter",
"437565", "Sankt\ Pankraz",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"437667", "Sankt\ Georgen\ im\ Attergau",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"434877", "Prägraten\ am\ Großvenediger",
"434825", "Großkirchheim",
"432812", "Groß\ Gerungs",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"434843", "Außervillgraten",
"433464", "Groß\ Sankt\ Florian",
"4313", "Wien",
"432955", "Großweikersdorf",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"437477", "Sankt\ Peter\ in\ der\ Au",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"432647", "Krumbach\,\ Niederösterreich",
"433469", "Sankt\ Oswald\ im\ Freiland",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"4315", "Wien",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"432629", "Warth\,\ Niederösterreich",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"434286", "Weißbriach",
"436412", "Sankt\ Johann\ im\ Pongau",
"433868", "Tragöß",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"436227", "Sankt\ Gilgen",
"432756", "Sankt\ Leonhard\ am\ Forst",
"434358", "Sankt\ Andrä",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"437219", "Vorderweißenbach",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"433684", "Sankt\ Martin\ am\ Grimming",
"433386", "Großsteinbach",
"436215", "Straßwalchen",
"433632", "Sankt\ Gallen",
"432847", "Groß\-Siegharts",
"433158", "Sankt\ Anna\ am\ Aigen",
"433119", "Sankt\ Marein\ bei\ Graz",
"432617", "Draßmarkt",
"437435", "Sankt\ Valentin",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"435678", "Weißenbach\ am\ Lech",
"437956", "Unterweißenbach",
"4317", "Wien",
"432686", "Draßburg",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"432618", "Markt\ Sankt\ Martin",
"436477", "Sankt\ Michael\ im\ Lungau",
"434785", "Außerfragant",
"432556", "Großkrut",
"4314", "Wien",
"437717", "Sankt\ Aegidi",
"436565", "Neukirchen\ am\ Großvenediger",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"4316", "Wien",
"437751", "Sankt\ Martin\ im\ Innkreis",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"432815", "Großschönau",
"433834", "Wald\ am\ Schoberpaß",
"436276", "Nußdorf\ am\ Haunsberg",
"432249", "Groß\-Enzersdorf",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"436414", "Großarl",
"433864", "Sankt\ Marein\ im\ Mürztal",
"4312", "Wien",
"436247", "Großgmain",
"434266", "Straßburg",
"437254", "Großraming",
"433575", "Sankt\ Johann\ am\ Tauern",
"434253", "Sankt\ Jakob\ im\ Rosental",
"436277", "Sankt\ Pantaleon",
"433327", "Sankt\ Michael\ im\ Burgenland",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"432674", "Weißenbach\ an\ der\ Triesting",
"435446", "Sankt\ Anton\ am\ Arlberg",
"437218", "Großtraberg",
"434879", "Sankt\ Veit\ in\ Defereggen",
"437566", "Rosenau\ am\ Hengstpaß",
"432857", "Bad\ Großpertholz",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"434226", "Sankt\ Margareten\ im\ Rosental",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"433362", "Großpetersdorf",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"433585", "Sankt\ Lambrecht",
"432822", "Zwettl\-Niederösterreich",
"432263", "Großrußbach",
"432233", "Preßbaum",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"437224", "Sankt\ Florian",
"433537", "Sankt\ Georgen\ ob\ Murau",
"434783", "Reißeck",
"435279", "Sankt\ Jodok\ am\ Brenner",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"432268", "Großmugl",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"437954", "Sankt\ Georgen\ am\ Walde",
"436241", "Sankt\ Koloman",
"4318", "Wien",
"4319", "Wien",
"432823", "Großglobnitz",
"435245", "Hinterriß",
"432742", "Sankt\ Pölten",};
$areanames{en} = {"434769", "Möllbrücke",
"432773", "Eichgraben",
"433618", "Hohentauern",
"437281", "Aigen\ im\ Mühlkreis",
"432214", "Kopfstetten",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"437415", "Altenmarkt\,\ Yspertal",
"432689", "Hornstein",
"432555", "Herrnbaumgarten",
"437272", "Eferding",
"432633", "Markt\ Piesting",
"437432", "Strengberg",
"433362", "Grosspetersdorf",
"433358", "Litzelsdorf",
"432256", "Leobersdorf",
"432637", "Grünbach\ am\ Schneeberg",
"436135", "Bad\ Goisern",
"436566", "Bramberg\ am\ Wildkogel",
"434226", "St\.\ Margareten\ im\ Rosental",
"437260", "Waldhausen",
"435376", "Thiersee",
"435674", "Bichlbach",
"432166", "Parndorf",
"432535", "Hohenau\ an\ der\ March",
"437719", "Taufkirchen\ an\ der\ Pram",
"437484", "Göstling\ an\ der\ Ybbs",
"435417", "Roppen",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"433338", "Lafnitz",
"432236", "Mödling",
"433159", "Bad\ Gleichenberg",
"432285", "Marchegg",
"432267", "Sierndorf",
"433687", "Schladming",
"433118", "Sinabelkirchen",
"434279", "Sirnitz",
"433848", "Eisenerz",
"436589", "Unken",
"433683", "Donnersbach",
"432822", "Zwettl\,\ Lower\ Austria",
"433514", "Seckau",
"432263", "Grossrussbach",
"435550", "Thüringen",
"437762", "Raab",
"437758", "Obernberg\ am\ Inn",
"436479", "Muhr",
"433475", "Hürth",
"435578", "Höchst",
"432666", "Reichenau",
"435280", "Hochfügen",
"435524", "Satteins",
"434735", "Kremsbrücke",
"437242", "Wels",
"434852", "Lienz",
"432725", "Frankenfels",
"432747", "Ober\-Grafendorf",
"433536", "St\.\ Peter\ am\ Kammersberg",
"433585", "St\.\ Lambrecht",
"434712", "Greifenburg",
"432743", "Böheimkirchen",
"432233", "Pressbaum",
"437672", "Vöcklabruck",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"437248", "Grieskirchen",
"437955", "Königswiesen",
"432237", "Gaaden",
"435572", "Dornbirn",
"432163", "Petronell\-Carnuntum",
"434227", "Ferlach",
"434245", "Feistritz\ an\ der\ Drau",
"435373", "Ebbs",
"437732", "Haag\ am\ Hausruck",
"432614", "Kleinwarasdorf",
"434718", "Dellach",
"432289", "Matzen",
"433155", "Fehring",
"434858", "Nikolsdorf",
"434223", "Maria\ Saal",
"432167", "Neusiedl\ am\ See",
"436563", "Uttendorf",
"432253", "Oberwaltersdorf",
"432828", "Rappottenstein",
"433112", "Gleisdorf",
"432874", "Martinsberg",
"433842", "Leoben",
"432257", "Klausen\-Leopoldsdorf",
"432636", "Puchberg\ am\ Schneeberg",
"432685", "Rust",
"432711", "Dürnstein",
"437752", "Ried\ im\ Innkreis",
"433135", "Kalsdorf\ bei\ Graz",
"435274", "Gries\ am\ Brenner",
"432951", "Guntersdorf",
"433537", "St\.\ Georgen\ ob\ Murau",
"435244", "Jenbach",
"432746", "Wilhelmsburg",
"437250", "Maria\ Neustift",
"433533", "Turrach",
"433332", "Hartberg",
"432944", "Haugsdorf",
"432667", "Schwarzau\ im\ Gebirge",
"434783", "Reisseck",
"432844", "Karlstein\ an\ der\ Thaya",
"432663", "Schottwien",
"436212", "Seekirchen\ am\ Wallersee",
"433612", "Liezen",
"437230", "Altenberg\ bei\ Linz",
"434275", "Ebene\ Reichenau",
"435441", "See",
"433352", "Oberwart",
"432266", "Stockerau",
"433635", "Radmer",
"433686", "Haus",
"436475", "Ramingstein",
"437224", "St\.\ Florian",
"436235", "Thalgau",
"437278", "Neukirchen\ am\ Walde",
"437276", "Peuerbach",
"437485", "Gaming",
"433117", "Eggersdorf\ bei\ Graz",
"432619", "Lackendorf",
"433847", "Trofaiach",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"437211", "Reichenau\ im\ Mühlkreis",
"433688", "Tauplitz",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"432284", "Oberweiden",
"433366", "Kohfidisch",
"432268", "Grossmugl",
"432252", "Baden",
"437757", "Gurten",
"436134", "Hallstatt",
"432534", "Niedersulz",
"437753", "Eberschwang",
"435675", "Tannheim",
"435573", "Hörbranz",
"435279", "St\.\ Jodok\ am\ Brenner",
"437673", "Schwanenstadt",
"432232", "Fischamend",
"435577", "Lustenau",
"436562", "Mittersill",
"436461", "Dienten\ am\ Hochkönig",
"432215", "Probstdorf",
"432748", "Kilb",
"432554", "Stützenhofen",
"437733", "Neumarkt\ im\ Hausruckkreis",
"435372", "Kufstein",
"437414", "Weins\-Isperdorf",
"432162", "Bruck\ an\ der\ Leitha",
"433584", "Neumarkt\ in\ Steiermark",
"436217", "Mattsee",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"432949", "Niederfladnitz",
"435226", "Neustift\ im\ Stubaital",
"433613", "Admont",
"437766", "Andorf",
"433617", "Gaishorn\ am\ See",
"432849", "Schwarzenau",
"436213", "Oberhofen\ am\ Irrsee",
"433357", "Pinkafeld",
"435525", "Nenzing",
"432638", "Winzendorf\-Muthmannsdorf",
"433474", "Deutsch\ Goritz",
"434734", "Rennweg",
"432826", "Rastenfeld",
"433353", "Oberschützen",
"434716", "Lesachtal",
"433532", "Murau",
"432621", "Sieggraben",
"437229", "Traun",
"433337", "Vorau",
"432662", "Gloggnitz",
"434782", "Obervellach",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"435418", "Schönwies",
"437246", "Gunskirchen",
"433333", "Sebersdorf",
"437736", "Pram",
"436241", "St\.\ Koloman",
"433134", "Heiligenkreuz\ am\ Waasen",
"435275", "Trins",
"437676", "Ottnang\ am\ Hausruck",
"432875", "Grafenschlag",
"4319", "Vienna",
"435412", "Imst",
"432684", "Schützen\ am\ Gebirge",
"4318", "Vienna",
"435576", "Hohenems",
"437489", "Purgstall\ an\ der\ Erlauf",
"432615", "Lutzmannsburg",
"434244", "Bad\ Bleiberg",
"43316", "Graz",
"433182", "Wildon",
"433461", "Trahütten",
"432772", "Neulengbach",
"437277", "Waizenkirchen",
"433363", "Rechnitz",
"437954", "St\.\ Georgen\ am\ Walde",
"433116", "Kirchbach\ in\ Steiermark",
"433846", "Kalwang",
"437433", "Wallsee",
"433171", "Gasen",
"437714", "Esternberg",
"432632", "Pernitz",
"437273", "Aschach\ an\ der\ Donau",
"433634", "Hieflau",
"437243", "Marchtrenk",
"433336", "Waldbach",
"433385", "Ilz",
"432238", "Kaltenleutgeben",
"433141", "Hirschegg",
"436234", "Zell\ am\ Moos",
"436474", "Tamsweg",
"437225", "Hargelsberg",
"437247", "Kematen\ am\ Innbach",
"432168", "Mannersdorf\ am\ Leithagebirge",
"432742", "St\.\ Pölten",
"434717", "Steinfeld",
"434274", "Velden\ am\ Wörther\ See",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"434713", "Techendorf",
"437941", "Neumarkt\ im\ Mühlkreis",
"434853", "Ainet",
"434228", "Feistritz\ im\ Rosental",
"433356", "Markt\ Allhau",
"432262", "Korneuburg",
"432258", "Alland",
"432823", "Grossglobnitz",
"433682", "Stainach",
"432945", "Zellerndorf",
"434231", "Mittertrixen",
"432827", "Schönbach",
"432845", "Weikertschlag\ an\ der\ Thaya",
"436216", "Neumarkt\ am\ Wallersee",
"435245", "Hinterriss",
"437763", "Kopfing\ im\ Innkreis",
"433616", "Selzthal",
"437767", "Eggerding",
"435223", "Hall\ in\ Tirol",
"432145", "Prellenkirchen",
"437616", "Grünau\ im\ Almtal",
"434263", "Hüttenberg",
"432577", "Asparn\ an\ der\ Zaya",
"432815", "Grossschönau",
"435232", "Kematen\ in\ Tirol",
"434822", "Winklern",
"432279", "Kirchberg\ am\ Wagram",
"435472", "Prutz",
"432755", "Mank",
"432915", "Drosendorf\-Zissersdorf",
"436229", "Hof\ bei\ Salzburg",
"434267", "Metnitz",
"432573", "Wilfersdorf",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"435516", "Doren",
"435339", "Wildschönau",
"435582", "Klösterle",
"436463", "Annaberg\-Lungötz",
"435554", "Sonntag",
"436467", "Mühlbach\ am\ Hochkönig",
"437682", "Vöcklamarkt",
"436246", "Grödig",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"435252", "Oetz",
"433176", "Stubenberg",
"432786", "Oberwölbling",
"432735", "Hadersdorf\ am\ Kamp",
"435284", "Gerlos",
"437728", "Schwand\ im\ Innkreis",
"437213", "Bad\ Leonfelden",
"432984", "Eggenburg",
"433466", "Eibiswald",
"435359", "Hochfilzen",
"432952", "Hollabrunn",
"432712", "Aggsbach",
"4316", "Vienna",
"437751", "St\.\ Martin\ im\ Innkreis",
"432852", "Gmünd",
"433854", "Langenwang",
"432623", "Pottendorf",
"433882", "Mariazell",
"436456", "Obertauern",
"437946", "Gutau",
"434214", "Brückl",
"432769", "Türnitz",
"432627", "Pitten",
"432645", "Wiesmath",
"433579", "Pöls",
"437562", "Windischgarsten",
"434256", "Nötsch\ im\ Gailtal",
"437744", "Munderfing",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"433146", "Modriach",
"436414", "Grossarl",
"433834", "Wald\ am\ Schoberpass",
"433611", "Johnsbach",
"437288", "Ulrichsberg",
"436276", "Nussdorf\ am\ Haunsberg",
"433453", "Ehrenhausen",
"437264", "Windhaag\ bei\ Perg",
"433457", "Gleinstätten",
"433328", "Kukmirn",
"434285", "Tröpolach",
"434236", "Eberndorf",
"437480", "Langau\,\ Gaming",
"435442", "Landeck",
"432249", "Gross\-Enzersdorf",
"432525", "Gnadendorf",
"432175", "Apetlon",
"433467", "Schwanberg",
"432739", "Tiefenfucha",
"433322", "Güssing",
"437254", "Grossraming",
"437282", "Neufelden",
"433463", "Stainz",
"437216", "Helfenberg",
"435632", "Stanzach",
"435448", "Pettneu\ am\ Arlberg",
"433177", "Puch\ bei\ Weiz",
"435355", "Jochberg",
"432783", "Traismauer",
"433173", "Ratten",
"436243", "Abtenau",
"432275", "Atzenbrugg",
"437353", "Gaflenz",
"436549", "Piesendorf",
"437234", "Ottensheim",
"436466", "Werfenweng",
"437357", "Kleinreifling",
"437474", "Euratsfeld",
"4312", "Vienna",
"433864", "St\.\ Marein\ im\ Mürztal",
"436225", "Eugendorf",
"436247", "Grossgmain",
"437617", "Traunkirchen",
"435513", "Hittisau",
"432576", "Ernstbrunn",
"435335", "Hopfgarten\ im\ Brixental",
"437584", "Molln",
"434266", "Strassburg",
"435517", "Riezlern",
"437613", "Laakirchen",
"434237", "Miklauzhof",
"434354", "Preitenegg",
"437722", "Braunau\ am\ Inn",
"435262", "Telfs",
"434233", "Griffen",
"436277", "St\.\ Pantaleon",
"432858", "Moorbad\ Harbach",
"437444", "Opponitz",
"432862", "Heidenreichstein",
"432610", "Horitschon",
"432718", "Lichtenau\ im\ Waldviertel",
"432958", "Maissau",
"436433", "Dorfgastein",
"433456", "Fresing",
"432245", "Wolkersdorf\ im\ Weinviertel",
"434257", "Fürnitz",
"433143", "Krottendorf",
"437241", "Steinerkirchen\ an\ der\ Traun",
"434874", "Virgen",
"433575", "St\.\ Johann\ am\ Tauern",
"432649", "Mönichkirchen",
"433125", "Übelbach",
"433147", "Salla",
"432765", "Kaumberg",
"435238", "Zirl",
"434253", "St\.\ Jakob\ im\ Rosental",
"437947", "Kefermarkt",
"437664", "Weyregg\ am\ Attersee",
"436457", "Flachau",
"436453", "Filzmoos",
"437943", "Windhaag\ bei\ Freistadt",
"432626", "Mattersburg",
"432628", "Felixdorf",
"432985", "Gars\ am\ Kamp",
"432674", "Weissenbach\ an\ der\ Triesting",
"436242", "Russbach\ am\ Pass\ Gschütt",
"437612", "Gmunden",
"434826", "Mörtschach",
"435236", "Gries\ im\ Sellrain",
"432734", "Langenlois",
"435285", "Mayrhofen",
"435476", "Serfaus",
"437259", "Sierning",
"435512", "Egg",
"433462", "Deutschlandsberg",
"433327", "St\.\ Michael\ im\ Burgenland",
"437283", "Sarleinsbach",
"432956", "Ziersdorf",
"432716", "Gföhl",
"435214", "Leutasch",
"437287", "Peilstein\ im\ Mühlviertel",
"433323", "Eberau",
"432856", "Weitra",
"435256", "Untergurgl",
"432754", "Loosdorf",
"433172", "Weiz",
"432144", "Deutsch\ Jahrndorf",
"432631", "Pöttsching",
"432782", "Herzogenburg",
"432814", "Langschlag",
"437239", "Lichtenberg",
"436544", "Rauris",
"435633", "Hägerau",
"432914", "Japons",
"437479", "Ardagger",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"434268", "Friesach",
"434252", "Wernberg",
"437566", "Rosenau\ am\ Hengstpass",
"434284", "Kirchbach",
"432524", "Kautendorf",
"432174", "Wallern\ im\ Burgenland",
"433142", "Voitsberg",
"436484", "Lessach",
"437265", "Pabneukirchen",
"434359", "Reichenfels",
"437942", "Freistadt",
"436468", "Werfen",
"436452", "Radstadt",
"433886", "Weichselboden",
"432741", "Flinsbach",
"435263", "Silz",
"434232", "Völkermarkt",
"437727", "Ach",
"437745", "Lochen",
"436415", "Schwarzach\ im\ Pongau",
"435446", "St\.\ Anton\ am\ Arlberg",
"437723", "Altheim",
"437218", "Grosstraberg",
"436272", "Oberndorf\ bei\ Salzburg",
"436432", "Bad\ Hofgastein",
"433855", "Krieglach",
"432644", "Grimmenstein",
"434879", "St\.\ Veit\ in\ Defereggen",
"434215", "Liebenfels",
"432863", "Eggern",
"437212", "Zwettl\ an\ der\ Rodl",
"435334", "Westendorf",
"435559", "Brand",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"435253", "Längenfeld",
"434238", "Eisenkappel\-Vellach",
"436470", "Atzmannsdorf",
"432853", "Schrems",
"433624", "Pichl\-Kainisch",
"433326", "Stegersbach",
"432957", "Hohenwarth",
"432713", "Spitz",
"432274", "Sieghartskirchen",
"433865", "Kindberg",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"436224", "Hintersee",
"432717", "Unter\-Meisling",
"432953", "Nappersdorf",
"437286", "Lembach\ im\ Mühlkreis",
"436278", "Ostermiething",
"437235", "Gallneukirchen",
"432857", "Bad\ Grosspertholz",
"432989", "Brunn\ an\ der\ Wild",
"432572", "Mistelbach",
"435354", "Fieberbrunn",
"435477", "Tösens",
"432231", "Purkersdorf",
"433148", "Kainach\ bei\ Voitsberg",
"435473", "Nauders",
"434823", "Tresdorf\,\ Rangersdorf",
"434262", "Treibach",
"434258", "Gummern",
"437683", "Frankenburg\ am\ Hausruck",
"435289", "Häusling",
"437948", "Hirschbach\ im\ Mühlkreis",
"436462", "Bischofshofen",
"436458", "Hüttau",
"434221", "Gallizien",
"435583", "Lech",
"437255", "Losenstein",
"437665", "Unterach\ am\ Attersee",
"433452", "Leibnitz",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"433859", "Mürzsteg",
"435443", "Galtür",
"435447", "Flirsch",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"434875", "Matrei\ in\ Osttirol",
"433574", "Pusterwald",
"433124", "Gratkorn",
"435266", "Ötztal\-Bahnhof",
"432764", "Hainfeld",
"43662", "Salzburg",
"434240", "Bad\ Kleinkirchheim",
"437445", "Hollenstein\ an\ der\ Ybbs",
"432244", "Langenzersdorf",
"433883", "Terz",
"432622", "Wiener\ Neustadt",
"433150", "Paldau",
"435518", "Mellau",
"434355", "Gemmersdorf",
"437269", "Baumgartenberg",
"437618", "Neukirchen\,\ Altmünster",
"437563", "Spital\ am\ Pyhrn",
"432829", "Schweiggers",
"433615", "Trieben",
"434272", "Pörtschach\ am\ Wörther\ See",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"432744", "Kasten\ bei\ Böheimkirchen",
"436215", "Strasswalchen",
"435246", "Achenkirch",
"436472", "Mauterndorf",
"435523", "Götzis",
"436232", "Mondsee",
"432846", "Raabs\ an\ der\ Thaya",
"433355", "Stadtschlaining",
"432946", "Pulkau",
"433632", "St\.\ Gallen",
"437249", "Bad\ Schallerbach",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"432538", "Velm\-Götzendorf",
"432641", "Kirchberg\ am\ Wechsel",
"437226", "Wilhering",
"432288", "Auersthal",
"433684", "St\.\ Martin\ am\ Grimming",
"433386", "Grosssteinbach",
"433335", "Pöllau",
"433513", "Bischoffeld",
"432264", "Rückersdorf\,\ Harmannsdorf",
"437483", "Oberndorf\ an\ der\ Melk",
"432682", "Eisenstadt",
"432731", "Idolsberg",
"435414", "Wenns",
"43732", "Linz",
"433845", "Mautern\ in\ Steiermark",
"433115", "Studenzen",
"437487", "Gresten",
"434762", "Spittal\ an\ der\ Drau",
"433132", "Kumberg",
"435677", "Vils",
"432616", "Lockenhaus",
"435673", "Ehrwald",
"437279", "Haibach\ ob\ der\ Donau",
"437755", "Mettmach",
"432634", "Gutenstein",
"437712", "Schärding",
"435575", "Langen\ bei\ Bregenz",
"432876", "Els",
"437675", "Ampflwang\ im\ Hausruckwald",
"437952", "Weitersfelden",
"436541", "Saalbach",
"432620", "Willendorf",
"432728", "Wienerbruck",
"433152", "Feldbach",
"433588", "Katsch\ an\ der\ Mur",
"435276", "Gschnitz",
"432774", "Innermanzing",
"433184", "Wolfsberg\ im\ Schwarzautal",
"432213", "Lassee",
"434242", "Villach",
"437735", "Gaspoltshofen",
"434732", "Gmünd\ in\ Kärnten",
"433516", "Kleinlobming",
"435510", "Damüls",
"437227", "Neuhofen\ an\ der\ Krems",
"437245", "Lambach",
"433383", "Burgau",
"433387", "Söchau",
"433571", "Möderbrugg",
"437223", "Enns",
"433472", "Mureck",
"437718", "Waldkirchen\ am\ Wesen",
"436240", "Krispl",
"434248", "Treffen",
"434855", "Assling",
"433339", "Friedberg",
"434715", "Kötschach\-Mauthen",
"433582", "Scheifling",
"432722", "Kirchberg\ an\ der\ Pielach",
"433158", "St\.\ Anna\ am\ Aigen",
"434768", "Kleblach\-Lind",
"432943", "Obritz",
"433619", "Oppenberg",
"434784", "Mallnitz",
"432847", "Gross\-Siegharts",
"432825", "Göpfritz\ an\ der\ Wild",
"432843", "Dobersberg",
"432688", "Steinbrunn",
"433170", "Fischbach",
"435526", "Laterns",
"436219", "Obertrum\ am\ See",
"432664", "Semmering",
"432947", "Theras",
"437765", "Lambrechten",
"435243", "Maurach",
"433534", "Stadl\ an\ der\ Mur",
"435225", "Fulpmes",
"433359", "Loipersdorf\-Kitzladen",
"433460", "Soboth",
"432271", "Ried\ am\ Riederberg",
"435579", "Alberschwende",
"432532", "Zistersdorf",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"436132", "Bad\ Ischl",
"435273", "Matrei\ am\ Brenner",
"436221", "Koppl",
"432254", "Ebreichsdorf",
"435331", "Brandenberg",
"432282", "Gänserndorf",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"432873", "Kottes",
"432877", "Grainbrunn",
"432164", "Rohrau",
"437412", "Ybbs\ an\ der\ Donau",
"432552", "Poysdorf",
"435676", "Jungholz",
"435374", "Walchsee",
"432613", "Deutschkreutz",
"432617", "Drassmarkt",
"433119", "St\.\ Marein\ bei\ Graz",
"436588", "Lofer",
"434278", "Gnesau",
"433849", "Vordernberg",
"434224", "Pischeldorf",
"436564", "Krimml",
"432234", "Gramatneusiedl",
"433638", "Palfau",
"433365", "Deutsch\ Schützen\-Eisenberg",
"437759", "Antiesenhofen",
"434230", "Globasnitz",
"437486", "Lunz\ am\ See",
"437435", "St\.\ Valentin",
"436478", "Zederhaus",
"436476", "St\.\ Margarethen\ im\ Lungau",
"437488", "Steinakirchen\ am\ Forst",
"432842", "Waidhofen\ an\ der\ Thaya",
"432265", "Hausleiten",
"432942", "Retz",
"433334", "Kaindorf",
"433685", "Gröbming",
"433636", "Wildalpen",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"434276", "Feldkirchen\ in\ Kärnten",
"435678", "Weissenbach\ am\ Lech",
"435242", "Schwaz",
"433473", "Straden",
"433382", "Fürstenfeld",
"433477", "St\.\ Peter\ am\ Ottersbach",
"434733", "Malta",
"433354", "Bernstein",
"432723", "Rabenstein\ an\ der\ Pielach",
"433583", "Unzmarkt",
"437261", "Schönau\ im\ Mühlkreis",
"433614", "Rottenmann",
"433587", "Schönberg\-Lachtal",
"436214", "Henndorf\ am\ Wallersee",
"432745", "Pyhra",
"433136", "Dobl",
"433185", "Preding",
"432259", "Münchendorf",
"432557", "Bernhardsthal",
"432612", "Oberpullendorf",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"437413", "Marbach\ an\ der\ Donau",
"4317", "Vienna",
"435574", "Bregenz",
"432686", "Drassburg",
"432635", "Neunkirchen",
"434766", "Millstatt",
"437674", "Attnang\-Puchheim",
"432239", "Breitenfurt\ bei\ Wien",
"436133", "Ebensee",
"435272", "Steinach\ am\ Brenner",
"434246", "Radenthein",
"437754", "Waldzell",
"436137", "Strobl",
"432533", "Neusiedl\ an\ der\ Zaya",
"437716", "Münzkirchen",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"432287", "Strasshof\ an\ der\ Nordbahn",
"432872", "Ottenschlag",
"433844", "Kammern\ im\ Liesingtal",
"432283", "Angern\ an\ der\ March",
"433114", "Markt\ Hartmannsdorf",
"437956", "Unterweissenbach",
"434229", "Krumpendorf\ am\ Wörther\ See",
"437764", "Riedau",
"435278", "Navis",
"432726", "Puchenstuben",
"435224", "Wattens",
"433535", "Krakaudorf",
"433586", "Mühlen",
"432824", "Allentsteig",
"434785", "Ausserfragant",
"433512", "Knittelfeld",
"434736", "Innerkrems",
"432878", "Traunstein",
"432665", "Prein\ an\ der\ Rax",
"432749", "Prinzersdorf",
"433476", "Bad\ Radkersburg",
"435230", "Sellrain",
"432618", "Markt\ St\.\ Martin",
"434277", "Glanegg",
"436583", "Leogang",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"434273", "Reifnitz",
"434714", "Dellach\ im\ Drautal",
"432269", "Niederfellabrunn",
"433633", "Landl",
"437244", "Sattledt",
"436477", "St\.\ Michael\ im\ Lungau",
"436233", "Oberwang",
"43512", "Innsbruck",
"435522", "Feldkirch",
"436473", "Mariapfarr",
"433637", "Gams\ bei\ Hieflau",
"437953", "Liebenau",
"437717", "St\.\ Aegidi",
"433364", "Hannersdorf",
"432286", "Obersiebenbrunn",
"432235", "Maria\-Lanzendorf",
"437228", "Kematen\ an\ der\ Krems",
"437434", "Haag",
"437713", "Schardenberg",
"437274", "Alkoven",
"4314", "Vienna",
"435375", "Kössen",
"433157", "Kapfenstein",
"432165", "Hainburg\ a\.d\.\ Donau",
"432536", "Drösing",
"434243", "Bodensdorf",
"4346", "Klagenfurt",
"432212", "Orth\ an\ der\ Donau",
"434225", "Grafenstein",
"434247", "Afritz",
"436136", "Gosau",
"436565", "Neukirchen\ am\ Grossvenediger",
"433153", "Riegersburg",
"437251", "Schiedlberg",
"432948", "Weitersfeld",
"432687", "Siegendorf",
"432255", "Deutsch\ Brodersdorf",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"432683", "Purbach\ am\ Neusiedler\ See",
"437482", "Scheibbs",
"434767", "Rothenthurn",
"437416", "Wieselburg",
"432639", "Bad\ Fischau",
"433137", "Söding",
"435672", "Reutte",
"432556", "Grosskrut",
"435248", "Steinberg\ am\ Rofan",
"433861", "Aflenz",
"437471", "Neustadtl\ an\ der\ Donau",
"433133", "Nestelbach",
"437231", "Herzogsdorf",
"432762", "Lilienfeld",
"432758", "Pöggstall",
"433572", "Judenburg",
"436548", "Niedernsill",
"434356", "Lavamünd",
"433833", "Traboch",
"433454", "Leutschach",
"437263", "Bad\ Zell",
"433581", "Oberwölz",
"437267", "Mönchdorf",
"432738", "Fels\ am\ Wagram",
"437743", "Maria\ Schmolln",
"432630", "Ternitz",
"436417", "Hüttschlag",
"435265", "Nassereith",
"434876", "Kals\ am\ Grossglockner",
"436413", "Wagrain",
"437747", "Kirchberg\ bei\ Mattighofen",
"433853", "Spital\ am\ Semmering",
"432624", "Ebenfurth",
"435449", "Fliess",
"432242", "St\.\ Andrä\-Wördern",
"434213", "Launsdorf",
"432865", "Litschau",
"437666", "Attersee",
"433857", "Neuberg\ an\ der\ Mürz",
"432983", "Sigmundsherberg",
"436131", "Obertraun",
"437256", "Ternberg",
"432272", "Tulln\ an\ der\ Donau",
"432648", "Hochneukirchen",
"433622", "Bad\ Aussee",
"435239", "Kühtai",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"435283", "Kaltenbach",
"435287", "Tux",
"434846", "Abfaltersbach",
"435332", "Wörgl",
"437214", "Reichenthal",
"433866", "Breitenau\ am\ Hochlantsch",
"437476", "Aschbach\-Markt",
"435553", "Raggal",
"437285", "Hofkirchen\ im\ Mühlkreis",
"437236", "Pregarten",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"435557", "St\.\ Gallenkirch",
"432859", "Brand\-Nagelberg",
"434264", "Klein\ St\.\ Paul",
"432719", "Dross",
"437586", "Pettenbach",
"435635", "Elmen",
"432959", "Sitzendorf\ an\ der\ Schmida",
"433680", "Donnersbachwald",
"432574", "Gaweinstal",
"435352", "St\.\ Johann\ in\ Tirol",
"437663", "Steinbach\ am\ Attersee",
"437667", "St\.\ Georgen\ im\ Attergau",
"437944", "Sandl",
"437729", "Neukirchen\ an\ der\ Enknach",
"436454", "Mandling",
"434271", "Steuerberg",
"433856", "Veitsch",
"435358", "Ellmau",
"435445", "Kappl",
"436416", "Lend",
"432172", "Frauenkirchen",
"433144", "Köflach",
"432522", "Laa\ an\ der\ Thaya",
"433631", "Unterlaussa",
"434877", "Prägraten\ am\ Grossvenediger",
"434873", "St\.\ Jakob\ in\ Defereggen",
"434282", "Hermagor",
"436471", "Tweng",
"437746", "Friedburg",
"434254", "Faak\ am\ See",
"437443", "Ybbsitz",
"432160", "Jois",
"432278", "Absdorf",
"432642", "Aspangberg\-St\.\ Peter",
"436228", "Faistenau",
"436434", "Bad\ Gastein",
"437266", "Bad\ Kreuzen",
"436274", "Lamprechtshausen",
"434220", "Köttmannsdorf",
"433885", "Greith",
"435338", "Kundl",
"434353", "Prebl",
"432230", "Schwadorf",
"437565", "St\.\ Pankraz",
"434234", "Ruden",
"434357", "St\.\ Paul\ im\ Lavanttal",
"437289", "Rohrbach\ in\ Oberösterreich",
"435514", "Bezau",
"434761", "Stockenboi",
"437587", "Wartberg\ an\ der\ Krems",
"437583", "Kremsmünster",
"435255", "Umhausen",
"432732", "Krems\ an\ der\ Donau",
"437614", "Vorchdorf",
"433329", "Jennersdorf",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"436244", "Golling\ an\ der\ Salzach",
"437477", "St\.\ Peter\ in\ der\ Au",
"433867", "Pernegg\ an\ der\ Mur",
"432855", "Waldenstein",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"432672", "Berndorf",
"435556", "Schruns",
"437233", "Feldkirchen\ an\ der\ Donau",
"432248", "Markgrafneusiedl",
"433863", "Turnau",
"437473", "Blindenmarkt",
"432955", "Grossweikersdorf",
"432912", "Geras",
"436542", "Zell\ am\ See",
"434843", "Ausservillgraten",
"434825", "Grosskirchheim",
"434847", "Obertilliach",
"435286", "Ginzling",
"432812", "Gross\ Gerungs",
"432784", "Perschling",
"433174", "Birkfeld",
"437711", "Suben",
"432142", "Gattendorf",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"435475", "Feichten",
"432752", "Melk",
"433578", "Obdach",
"4313", "Vienna",
"435212", "Seefeld\ in\ Tirol",
"437257", "Grünburg",
"435585", "Dalaas",
"437253", "Wolfern",
"433151", "Gnas",
"433464", "Gross\ St\.\ Florian",
"432986", "Irnfritz",
"432988", "Neupölla",
"433149", "Geistthal",
"432625", "Bad\ Sauerbrunn",
"432647", "Krumbach\,\ Lower\ Austria",
"432643", "Lichtenegg",
"437442", "Waidhofen\ an\ der\ Ybbs",
"432864", "Kautzen",
"435264", "Mieming",
"433126", "Frohnleiten",
"432766", "Kleinzell",
"433576", "Bretstein",
"435288", "Fügen",
"437949", "Rainbach\ im\ Mühlkreis",
"437724", "Mauerkirchen",
"434352", "Wolfsberg",
"436483", "Göriach",
"435558", "Gaschurn",
"433455", "Arnfels",
"432246", "Gerasdorf\ bei\ Wien",
"437750", "Andrichsfurt",
"437662", "Seewalchen\ am\ Attersee",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"432177", "Podersdorf\ am\ See",
"434283", "St\.\ Stefan\ im\ Gailtal",
"432527", "Wulzeshofen",
"434872", "Huben",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"432173", "Gols",
"432753", "Gansbach",
"436547", "Kaprun",
"432143", "Kittsee",
"434265", "Weitensfeld\ im\ Gurktal",
"4315", "Vienna",
"432813", "Arbesbach",
"434842", "Sillian",
"432575", "Ladendorf",
"436543", "Taxenbach",
"432147", "Zurndorf",
"432913", "Hötzelsdorf",
"435336", "Alpbach",
"432757", "Pöchlarn",
"435634", "Elbigenalp",
"435519", "Schröcken",
"437284", "Oberkappel",
"436226", "Fuschl\ am\ See",
"437252", "Steyr",
"437268", "Grein",
"432276", "Reidling",
"435213", "Scharnitz",
"437619", "Kirchham",
"433324", "Strem",
"437748", "Eggelsberg",
"432733", "Schönberg\ am\ Kamp",
"437582", "Kirchdorf\ an\ der\ Krems",
"437215", "Hellmonsödt",
"435356", "Kitzbühel",
"433469", "St\.\ Oswald\ im\ Freiland",
"436418", "Kleinarl",
"437472", "Amstetten",
"433858", "Mitterdorf\ im\ Mürztal",
"433862", "Bruck\ an\ der\ Mur",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"432673", "Altenmarkt\ an\ der\ Triesting",
"433179", "Passail",
"436412", "St\.\ Johann\ im\ Pongau",
"432176", "Tadten",
"432526", "Stronsdorf",
"437588", "Ried\ im\ Traunkreis",
"434286", "Weissbriach",
"434235", "Bleiburg",
"437742", "Mattighofen",
"432841", "Vitis",
"437564", "Hinterstoder",
"432247", "Deutsch\-Wagram",
"434212", "St\.\ Veit\ an\ der\ Glan",
"432243", "Klosterneuburg",
"433884", "Wegscheid",
"437238", "Mauthausen",
"433852", "Mürzzuschlag",
"433868", "Tragöss",
"437478", "Oed\-Oehling",
"432629", "Warth\,\ Lower\ Austria",
"433145", "Edelschrott",
"433127", "Peggau",
"432767", "Hohenberg",
"433577", "Zeltweg",
"434848", "Kartitsch",
"435444", "Ischgl",
"434255", "Arnoldstein",
"437221", "Hörsching",
"433573", "Fohnsdorf",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"437258", "Bad\ Hall",
"437262", "Perg",
"433832", "Kraubath\ an\ der\ Mur",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"436455", "Untertauern",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"437684", "Frankenmarkt",
"435552", "Bludenz",
"433465", "Pölfing\-Brunn",
"437219", "Vorderweissenbach",
"435353", "Waidring",
"435474", "Pfunds",
"435234", "Axams",
"432736", "Paudorf",
"434824", "Heiligenblut",
"435357", "Kirchberg\ in\ Tirol",
"433175", "Anger",
"432854", "Kirchberg\ am\ Walde",
"437448", "Kematen\ an\ der\ Ybbs",
"434269", "Flattnitz",
"437355", "Weyer",
"433623", "Bad\ Mitterndorf",
"436245", "Hallein",
"432714", "Rossatz",
"436227", "St\.\ Gilgen",
"432273", "Tulbing",
"434710", "Oberdrauburg",
"432277", "Zwentendorf",
"432954", "Göllersdorf",
"436223", "Anthering",
"432982", "Horn",
"435333", "Söll",
"437240", "Sipbachzell",
"432916", "Riegersburg\,\ Hardegg",
"434358", "St\.\ Andrä",
"435515", "Au",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"435282", "Zell\ am\ Ziller",
"432816", "Karlstift",
"432146", "Nickelsdorf",
"437615", "Scharnstein",
"435254", "Sölden",
"432756", "St\.\ Leonhard\ am\ Forst",
"435337", "Brixlegg",};
my $timezones = {
               '' => [
                       'Europe/Vienna'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;