# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::NZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240308154352;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8[1-79]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            50(?:
              [0367]|
              88
            )|
            8|
            90
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2,3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            24|
            [346]|
            7[2-57-9]|
            9[2-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              10|
              74
            )|
            [589]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1|
            2[028]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            2(?:
              [169]|
              7[0-35-9]
            )|
            7
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'geographic' => '
          24099\\d{3}|
          (?:
            3[2-79]|
            [49][2-9]|
            6[235-9]|
            7[2-57-9]
          )\\d{6}
        ',
                'mobile' => '
          2(?:
            [0-27-9]\\d|
            6
          )\\d{6,7}|
          2(?:
            1\\d|
            75
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '70\\d{7}',
                'specialrate' => '(
          (?:
            1[13-57-9]\\d{5}|
            50(?:
              0[08]|
              30|
              66|
              77|
              88
            )
          )\\d{3}|
          90\\d{6,8}
        )|(
          8(?:
            1[16-9]|
            22|
            3\\d|
            4[045]|
            5[459]|
            6[235-9]|
            7[0-3579]|
            90
          )\\d{2,7}
        )',
                'toll_free' => '
          508\\d{6,7}|
          80\\d{6,8}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"6433947", "Darfield",
"6496012", "Kawakawa",
"649958", "Helensville",
"6469289", "Taihape",
"6439735", "Lumsden",
"643435", "Oamaru\/Mount\ Cook\/Twizel\/Kurow",
"6469284", "Stratford",
"6439084", "Amberley",
"6499475", "Hibiscus\ Coast",
"6435663", "Twizel",
"6439043", "Ashburton",
"6469243", "New\ Plymouth",
"6492833", "Warkworth",
"6477889", "Whakatane",
"6477884", "Tauranga",
"643412", "Balclutha",
"6439752", "Cheviot",
"6432715", "Culverden",
"6432653", "Wanaka",
"6439521", "Dunedin",
"6468243", "Napier",
"6499452", "Warkworth",
"6472826", "Matamata",
"6472128", "Waihi",
"6495533", "Whangarei",
"646832", "Napier\/Wairoa",
"6435997", "Amberley",
"6434285", "Cheviot",
"64330", "Ashburton\/Akaroa\/Chatham\ Islands",
"64632", "Palmerston\ North",
"647903", "Hamilton",
"6466992", "Hawera",
"6437774", "Queenstown",
"643940", "Christchurch",
"6499062", "Hibiscus\ Coast",
"6499878", "Warkworth",
"6432720", "Nelson",
"6462167", "Mokau",
"644589", "Wellington",
"6437779", "Invercargill",
"6474446", "Otorohanga",
"6434242", "Darfield",
"6472191", "Whakatane",
"647460", "Rotorua",
"6469295", "Wanganui",
"6432728", "Haast",
"6433953", "Geraldine",
"644904", "Paraparaumu",
"6479842", "Matamata",
"6492428", "Hibiscus\ Coast",
"6439095", "Ashburton",
"6435", "South\ Island",
"643206", "Edendale",
"6435882", "Dunedin",
"6469716", "Opunake",
"6468257", "Taihape",
"6475604", "Hamilton",
"6432647", "Fairlie",
"643938", "South\ Island",
"6439057", "Waimate",
"6475609", "Paeroa",
"649348", "Auckland",
"6472120", "Putaruru\/Tokoroa",
"6432622", "Balclutha",
"6439297", "Takaka",
"6499423", "Great\ Barrier\ Island",
"6439272", "Timaru",
"6478135", "Te\ Kuiti",
"6494315", "Warkworth",
"6434299", "Haast",
"6439723", "Blenheim",
"6434294", "Franz\ Josef",
"6475613", "Te\ Awamutu",
"647879", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"6472115", "Taumarunui",
"6463993", "Pahiatua",
"6434227", "Riverton",
"6439006", "Nelson",
"6469029", "Opunake",
"6432634", "Invercargill",
"6496508", "Hibiscus\ Coast",
"6439011", "Queenstown",
"643529", "Nelson",
"6432639", "Edendale",
"6442198", "Paraparaumu",
"643245", "Tokanui\/Lumsden\/Te\ Anau",
"6432608", "Dunedin",
"643459", "Dunedin\/Queenstown",
"6479040", "Otorohanga",
"6466522", "Palmerston\ North",
"6462137", "Palmerston\ North",
"6436653", "Edendale",
"6435527", "Alexandra",
"6435687", "Lumsden",
"6434351", "Mt\ Cook",
"6474649", "Matamata",
"6466579", "Featherston",
"6472603", "Hamilton",
"644212", "Wellington",
"6466508", "Napier\/Wairoa",
"6495563", "Whangarei",
"6498690", "Kawakawa",
"6478071", "Otorohanga",
"6473946", "Taupo",
"6468886", "Wanganui",
"6462144", "Ruatoria",
"643279", "South\ Island",
"6499558", "Great\ Barrier\ Island",
"643755", "Hokitika",
"6439314", "Winton",
"6462149", "Ruatoria",
"6472614", "Otorohanga",
"6439319", "Otautau",
"6499295", "Kaikohe",
"6466005", "Mokau",
"6499716", "Helensville",
"6434400", "Alexandra",
"6435542", "Riverton",
"6439765", "Milton",
"6437482", "Lumsden",
"6462810", "Gisborne",
"6434990", "Queenstown",
"6435673", "Lawrence",
"6499465", "Dargaville",
"6474637", "Opotiki",
"6472224", "Taupo",
"6479296", "Tauranga",
"6462818", "New\ Plymouth",
"6432669", "Rangiora",
"6434998", "Dunedin",
"6436647", "Te\ Anau",
"6436593", "Nelson",
"6432664", "Christchurch",
"6434408", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"643465", "Palmerston",
"6496992", "Kawakawa",
"64932", "Auckland\/Waiheke\ Island",
"6462420", "Palmerston\ North",
"6437445", "Fox\ Glacier",
"646765", "Stratford",
"6479007", "Whakatane",
"6468809", "Masterton",
"6479715", "Paeroa",
"6468804", "Napier",
"649439", "Dargaville",
"646958", "Palmerston\ North\/New\ Plymouth",
"646962", "Wanganui\/New\ Plymouth",
"6468813", "Taihape",
"6449030", "Paraparaumu",
"6436634", "Mt\ Cook",
"6436639", "Oamaru",
"6475821", "Hamilton",
"6436622", "Cheviot",
"6436582", "Riverton",
"6462101", "Levin",
"6439346", "Christchurch",
"6466553", "New\ Plymouth",
"6465627", "Levin",
"6435544", "Winton",
"6437484", "Riverton",
"6439888", "Christchurch\/Blenheim\/Nelson",
"6468820", "Palmerston\ North",
"6493943", "Helensville",
"6432426", "Blenheim",
"6472222", "Hamilton",
"6436595", "Mt\ Cook",
"6479021", "Te\ Awamutu",
"643416", "Balclutha\/Milton",
"6435549", "Hokitika",
"6437489", "South\ Island",
"6472612", "Te\ Awamutu",
"6475958", "Taupo",
"643454", "Dunedin",
"6499047", "Pukekohe",
"6479713", "Morrinsville",
"6478090", "Thames",
"644891", "Wellington",
"6439312", "Riverton",
"6437443", "Nelson",
"6435537", "Winton",
"6479709", "Matamata",
"647880", "Matamata",
"643420", "Christchurch",
"6465601", "Palmerston\ North",
"6499631", "Pukekohe",
"6473338", "Rotorua",
"647980", "Hamilton",
"6465616", "Hawera",
"6462127", "Dannevirke",
"6439851", "Culverden",
"6468815", "Pahiatua",
"6436506", "Darfield",
"64364", "South\ Island",
"6466529", "Pahiatua",
"6473996", "Otorohanga",
"6462413", "Gisborne",
"643957", "Timaru",
"6466555", "Hawera",
"644213", "Wellington",
"6466524", "Ohakune",
"6449740", "Paraparaumu",
"6499008", "Pukekohe",
"64735", "Rotorua",
"646376", "Pahiatua",
"646967", "New\ Plymouth",
"6436655", "Westport",
"6436629", "Christchurch",
"6436589", "Otautau",
"64627", "Hawera",
"6436584", "Winton",
"6436624", "Darfield",
"646963", "Wanganui\/New\ Plymouth",
"6435501", "Christchurch",
"6479246", "Thames",
"6437457", "Darfield",
"6495565", "Dargaville",
"6466019", "Napier",
"64423", "Wellington",
"6466014", "Napier",
"6472605", "Thames",
"6436632", "Murchison",
"6435516", "Balclutha",
"6439269", "Dunedin",
"6466003", "Ruatoria",
"6432801", "Lumsden",
"6468802", "New\ Plymouth",
"6499727", "Whangarei",
"6434267", "Ranfurly",
"64784", "Hamilton",
"6475950", "Hamilton",
"6432816", "Waimate",
"644570", "Wellington",
"6432662", "Christchurch",
"6468307", "Napier\/Wairoa",
"6435675", "Twizel",
"6499463", "Whangarei",
"6439763", "Palmerston",
"6496994", "Dargaville",
"643680", "Fairlie",
"6469307", "Stratford",
"6439880", "Greymouth",
"6439876", "Roxburgh",
"6439093", "Ashburton",
"6463906", "Napier",
"6433955", "Mt\ Cook",
"643956", "Timaru",
"6439710", "Timaru",
"6469293", "New\ Plymouth",
"646837", "Wairoa",
"6499069", "Pukekohe",
"6437772", "Timaru",
"6499064", "Helensville",
"6463911", "New\ Plymouth",
"6475620", "Tauranga",
"6433997", "Gore",
"6466994", "Ohakune",
"6432730", "Blenheim",
"6466999", "New\ Plymouth",
"6469000", "New\ Plymouth",
"6477882", "Hamilton",
"6475615", "Waihi",
"6439754", "Darfield",
"6472427", "Rotorua",
"644595", "Wellington",
"6499454", "Whangarei",
"6439725", "Christchurch",
"6499459", "Maungaturoto",
"6478133", "Putaruru\/Tokoroa",
"6494313", "Warkworth",
"6439759", "Cromwell",
"6469282", "Mokau",
"6439531", "Timaru",
"6439082", "Culverden",
"643413", "Balclutha",
"643651", "Nelson",
"6496014", "Dargaville",
"643417", "Milton",
"6463995", "Marton",
"6432741", "Milton",
"6469022", "Hawera",
"6499473", "Helensville",
"6435665", "Waimate",
"649400", "Kaikohe",
"6439733", "Te\ Anau",
"6439866", "Christchurch\/Blenheim\/Nelson",
"6498815", "Helensville",
"6462221", "Gisborne",
"6472817", "Taupo",
"6432632", "Lumsden",
"6439279", "Christchurch",
"6468245", "Wairoa",
"6434292", "Hokitika",
"6432655", "Nelson",
"6434277", "Ranfurly",
"6432629", "Roxburgh",
"6432713", "Ashburton",
"6462606", "Waiouru",
"6472141", "Te\ Kuiti",
"6432624", "Milton",
"64343", "Oamaru",
"6446509", "Paraparaumu",
"6492835", "Kaikohe",
"6462611", "Napier",
"6434237", "Culverden",
"6439274", "Queenstown",
"6469008", "Palmerston\ North",
"6439045", "Twizel",
"6498820", "Whangarei",
"6435889", "Timaru",
"6432738", "Oamaru",
"6463943", "Masterton",
"6434283", "Cromwell",
"649391", "Auckland",
"6435884", "Dunedin",
"643524", "Takaka",
"6442429", "Paraparaumu",
"6475602", "Hamilton",
"6472130", "Tauranga",
"6475628", "Tauranga",
"646966", "Wanganui\/New\ Plymouth",
"6479844", "Otorohanga",
"647928", "Tauranga",
"647974", "Hamilton",
"647334", "Rotorua",
"6434249", "Kaikoura",
"647828", "Huntly",
"6434244", "Amberley",
"646866", "Gisborne\/Ruatoria",
"6439718", "Mt\ Cook",
"643741", "Christchurch",
"6479849", "Thames",
"647874", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"649902", "Warkworth",
"6442129", "Paraparaumu",
"6439529", "Palmerston",
"64694", "Masterton\/Levin",
"643396", "South\ Island",
"647464", "Hamilton",
"646657", "Masterton",
"646653", "Wanganui",
"6477881", "Hamilton",
"6439298", "Motueka",
"6465950", "Palmerston\ North",
"6439524", "Oamaru",
"6442197", "Paraparaumu",
"6496507", "Helensville",
"6432607", "Dunedin",
"6433940", "Westport",
"6432742", "Twizel",
"649409", "Kaitaia",
"6439532", "Timaru",
"6469281", "Wairoa",
"6434228", "Tokanui",
"643233", "Riverton\/Winton",
"6437771", "Blenheim",
"6432727", "Fox\ Glacier",
"6498816", "Great\ Barrier\ Island",
"6439865", "Murchison",
"647863", "Waihi",
"6463912", "New\ Plymouth",
"6492427", "Warkworth",
"647867", "Thames",
"64336", "South\ Island",
"6435666", "Oamaru",
"6462160", "Masterton",
"649425", "Warkworth",
"643237", "Riverton\/Winton",
"6469246", "Palmerston\ North",
"6435990", "Hokitika",
"6492836", "Kaitaia",
"6439046", "Kurow",
"6468246", "Hawera",
"6472823", "Whakatane",
"6432656", "Nelson",
"6432648", "Geraldine",
"6462605", "Marton",
"6468258", "Waiouru",
"646214", "Gisborne",
"6468250", "Stratford",
"6439726", "Timaru",
"6432640", "Hokitika",
"6475601", "Hamilton",
"644205", "Wellington",
"6475616", "Whangamata",
"6472127", "Paeroa",
"6435998", "Rangiora",
"6439050", "Geraldine",
"6462168", "Featherston",
"6443709", "Paraparaumu",
"6463996", "Palmerston\ North",
"6439003", "Ashburton",
"643447", "Alexandra",
"6472194", "Whakatane",
"6469203", "New\ Plymouth",
"643443", "Wanaka",
"6472199", "Opotiki",
"64635", "Palmerston\ North",
"6499877", "Maungaturoto",
"6434220", "Invercargill",
"6432631", "Gore",
"647391", "Hamilton",
"6439019", "Roxburgh",
"6498883", "Whangarei",
"6474443", "Matamata",
"6462222", "Ohakune",
"6439014", "Ashburton",
"6433948", "Kaikoura",
"6463905", "Napier",
"6433956", "Dunedin",
"6495588", "Hibiscus\ Coast",
"643944", "Christchurch",
"643667", "Christchurch",
"6439290", "Christchurch",
"6469713", "Stratford",
"6434291", "Westport",
"64329", "South\ Island",
"6472142", "Te\ Awamutu",
"646951", "Palmerston\ North",
"6468883", "Palmerston\ North",
"6432815", "Fairlie",
"6439852", "Cheviot",
"644834", "Paraparaumu",
"6465602", "Palmerston\ North",
"647325", "Opotiki",
"6434359", "Twizel",
"6439875", "Ranfurly",
"643908", "Ashburton",
"6435676", "Kurow",
"6435680", "Dunedin",
"647866", "Thames",
"643236", "Winton",
"6479022", "Morrinsville",
"6434407", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"643689", "Waimate",
"6436656", "Hokitika",
"6472221", "Tauranga",
"6436648", "Lumsden",
"6462817", "Napier",
"6434997", "Lawrence",
"6478074", "Taumarunui",
"646382", "Taihape",
"64789", "Taumarunui",
"6439311", "Invercargill",
"643397", "South\ Island",
"6472606", "Huntly",
"6435515", "Oamaru",
"646656", "Levin",
"6479245", "Matamata",
"6472611", "Matamata",
"643393", "Christchurch",
"6495566", "Kaikohe",
"64935", "Auckland",
"6479008", "Rotorua",
"6478079", "Hamilton",
"6479000", "Hamilton",
"6465615", "Wanganui",
"643666", "Christchurch",
"6468816", "Hawera",
"6468801", "Wanganui",
"6432802", "Gore",
"6499557", "Warkworth",
"6436640", "Palmerston",
"6474638", "Opotiki",
"6436505", "Culverden",
"6466548", "Ruatoria",
"6473995", "Putaruru\/Tokoroa",
"6432661", "Christchurch",
"64361", "Timaru",
"6439343", "Waimate",
"6466556", "Stratford",
"6436596", "Queenstown",
"643267", "South\ Island",
"6435688", "Queenstown",
"6435528", "Ranfurly",
"643446", "Roxburgh",
"6479293", "Hamilton",
"643922", "Nelson",
"6462104", "Marton",
"6462109", "Waiouru",
"6432425", "Invercargill",
"64369", "Geraldine",
"6465620", "New\ Plymouth",
"6462138", "Palmerston\ North",
"6475829", "Hamilton",
"647889", "Morrinsville",
"6436631", "Motueka",
"647989", "Taupo",
"6435502", "Christchurch",
"6475824", "Hamilton",
"6499040", "Helensville",
"6499728", "Dargaville",
"64372", "South\ Island",
"644887", "Wellington",
"6478072", "Paeroa",
"6465613", "Wairoa",
"6478097", "Whakatane",
"6434268", "Roxburgh",
"6437481", "Invercargill",
"6469308", "Opunake",
"6439345", "Christchurch",
"646387", "Waiouru",
"6435541", "Te\ Anau",
"6462115", "Wairoa",
"644281", "Wellington",
"6473993", "Te\ Awamutu",
"643392", "South\ Island",
"64340", "South\ Island",
"6479029", "Waihi",
"6462416", "Waipukurau",
"6436503", "Ashburton",
"6468827", "New\ Plymouth",
"647210", "Hamilton",
"6436519", "Takaka",
"644551", "Paraparaumu",
"6432423", "Dunedin",
"6479295", "Whakatane",
"6466521", "Palmerston\ North",
"6479716", "Waihi",
"6492229", "Hibiscus\ Coast",
"6439859", "Christchurch\/Blenheim\/Nelson",
"6435530", "Nelson",
"6492006", "Helensville",
"6465604", "Ohakune",
"6437446", "Franz\ Josef",
"6465609", "Pahiatua",
"643335", "Christchurch",
"6439854", "Waitangi\ \(Chatham\ Is\.\)",
"6437458", "Kaikoura",
"6462120", "Palmerston\ North",
"6462128", "Ohakune",
"6437450", "Westport",
"6435504", "Christchurch",
"6499296", "Kaitaia",
"649652", "Warkworth",
"6466006", "Opunake",
"6473945", "Tauranga",
"646750", "Mokau",
"643923", "Nelson",
"6466011", "Marton",
"6432813", "Geraldine",
"6468885", "New\ Plymouth",
"644818", "Wellington",
"6435538", "Lumsden",
"64732", "Whakatane",
"644650", "Wellington",
"646903", "Palmerston\ North",
"6473337", "Rotorua",
"6435509", "Culverden",
"643450", "Queenstown",
"6439766", "Balclutha",
"643221", "Invercargill",
"6499466", "Kaikohe",
"6499007", "Kaikohe",
"6436581", "Invercargill",
"6436621", "Culverden",
"6439873", "Wanaka",
"6462102", "Levin",
"647884", "Morrinsville",
"6496991", "Kaikohe",
"6439887", "Christchurch\/Blenheim\/Nelson",
"6469300", "Gisborne",
"6434260", "Oamaru",
"6436546", "Fairlie",
"6432804", "Riverton",
"643270", "Christchurch",
"6479243", "Rotorua\/Whakatane\/Tauranga",
"6435513", "Waitangi\ \(Chatham\ Is\.\)",
"6432809", "Hokitika",
"6499048", "Pukekohe",
"649398", "Auckland\/Waiheke\ Island",
"6466991", "Wanganui",
"6433990", "South\ Island",
"649404", "Kawakawa",
"647862", "Paeroa",
"6435560", "Mt\ Cook",
"643571", "Nelson",
"6478136", "Te\ Awamutu",
"6432737", "Palmerston",
"643232", "Riverton\/Winton",
"6439717", "Fairlie",
"643215", "Invercargill",
"647921", "Rotorua",
"6499061", "Hibiscus\ Coast",
"6472116", "Thames",
"6475627", "Taupo",
"6439005", "Invercargill",
"647821", "Hamilton\/Huntly",
"6463914", "Stratford",
"6469296", "Levin",
"649907", "Warkworth",
"6439534", "Mt\ Cook",
"6432749", "Wanaka",
"6472818", "Rotorua",
"6463903", "Ruatoria",
"6439096", "Ashburton",
"6474445", "Hamilton",
"643520", "Blenheim",
"6432744", "Ranfurly",
"6439539", "Dunedin\/Timaru",
"6434238", "Waitangi\ \(Chatham\ Is\.\)",
"6439751", "Culverden",
"6472420", "Hamilton",
"6499451", "Warkworth",
"6469007", "Masterton",
"6439522", "Dunedin",
"647970", "Hamilton",
"6469715", "Mokau",
"644886", "Wellington",
"647870", "Te\ Awamutu",
"6434278", "Roxburgh",
"6434286", "Christchurch",
"6434270", "Oamaru",
"6472144", "Matamata",
"6462619", "Featherston",
"6472149", "Whangamata",
"6462614", "Wairoa",
"6432621", "Oamaru",
"6434230", "Christchurch",
"6472428", "Taupo",
"6439271", "Westport",
"6439012", "Queenstown",
"646845", "Napier\/Hastings",
"6472810", "Tauranga",
"644250", "Wellington",
"6462224", "Masterton",
"6479841", "Huntly",
"643949", "Dunedin",
"6469040", "Wairoa",
"6434241", "Rangiora",
"6439863", "Motueka",
"6439736", "Riverton",
"6472192", "Whakatane",
"6462603", "Palmerston\ North",
"6432716", "Darfield",
"643442", "Queenstown",
"643926", "Christchurch",
"6433998", "Lumsden",
"6435881", "Dunedin",
"643438", "Kurow",
"6439025", "Otautau",
"6468254", "Ohakune",
"6475607", "Morrinsville",
"6432644", "Westport",
"6472121", "Te\ Kuiti",
"6468259", "Levin",
"6432649", "Waimate",
"6433916", "Hokitika",
"6469615", "Masterton",
"643230", "Invercargill",
"6472190", "Whakatane",
"647860", "Paeroa\/Waihi\/Thames\/Whangamata",
"6437465", "Waimate",
"64348", "Dunedin",
"647872", "Te\ Awamutu",
"6436993", "Kaikoura",
"6434224", "Te\ Anau",
"6432637", "Winton",
"6479855", "Taupo",
"6472812", "Tauranga",
"647332", "Rotorua",
"6434229", "Winton",
"647589", "Hamilton",
"6439010", "Queenstown",
"6439294", "Dunedin",
"6434232", "Ashburton",
"647533", "Tauranga",
"6439528", "Lawrence",
"647315", "Opotiki",
"64357", "Blenheim",
"643522", "Nelson",
"6442128", "Paraparaumu",
"6463923", "Ohakune",
"6434297", "Westport",
"646650", "Napier",
"6439299", "Murchison",
"6434272", "Alexandra",
"6469576", "Dannevirke",
"6495589", "Pukekohe",
"6498856", "Maungaturoto",
"6477887", "Te\ Awamutu",
"6467775", "Palmerston\ North",
"644619", "Wellington",
"6439520", "Dunedin",
"649421", "Hibiscus\ Coast",
"6433983", "Ranfurly",
"643660", "Christchurch",
"6432226", "Timaru",
"6433944", "Ashburton",
"6439018", "Ranfurly",
"6436565", "Twizel",
"643419", "Balclutha",
"6432616", "Ashburton",
"6469287", "Ohakune",
"649458", "Dargaville",
"6433949", "Rangiora",
"6496516", "Kaikohe",
"643935", "South\ Island",
"6437777", "Christchurch",
"6432721", "Motueka",
"6443708", "Paraparaumu",
"6462169", "Featherston",
"6472805", "Morrinsville",
"6469273", "New\ Plymouth",
"6462164", "New\ Plymouth",
"649470", "Whangarei",
"6472198", "Opotiki",
"6462623", "Stratford",
"6439073", "Motueka",
"6439285", "Invercargill",
"6435562", "Invercargill",
"6439745", "Greymouth",
"6435994", "Ashburton",
"6433992", "Riverton",
"6478993", "Waihi",
"6435999", "Christchurch",
"643248", "Lumsden",
"64362", "South\ Island",
"644906", "Paraparaumu",
"6479004", "Te\ Awamutu",
"6462421", "New\ Plymouth",
"6474653", "Putaruru\/Tokoroa",
"6479009", "Hamilton",
"6439336", "Cromwell",
"6478078", "Whangamata",
"643390", "Christchurch",
"6468807", "Gisborne",
"6436683", "Rangiora",
"6436523", "Hokitika",
"6499551", "Whangarei",
"6434262", "Alexandra",
"6469302", "Napier",
"6436644", "Alexandra",
"6432667", "South\ Island",
"6436649", "Gore",
"6435695", "Fox\ Glacier",
"643758", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6462100", "Levin",
"646869", "Gisborne\/Ruatoria",
"6497775", "Helensville",
"6465624", "Featherston",
"646969", "New\ Plymouth",
"6437475", "Palmerston",
"6432993", "Balclutha",
"6449031", "Paraparaumu",
"6436637", "Twizel",
"6475820", "Hamilton",
"6493935", "Kawakawa",
"6437452", "Akaroa",
"6499747", "Dargaville",
"6462153", "New\ Plymouth",
"6477776", "Whangamata",
"6462122", "Palmerston\ North",
"6475828", "Hamilton",
"6435532", "Motueka",
"6436616", "Geraldine",
"6498691", "Maungaturoto",
"643452", "Wanaka",
"643468", "Dunedin",
"6496100", "Pukekohe",
"6468263", "Napier",
"6435689", "Otautau",
"6435529", "Roxburgh",
"6435555", "Timaru",
"646768", "New\ Plymouth",
"643959", "Dunedin\/Timaru",
"6462139", "Palmerston\ North",
"6434350", "Twizel",
"644219", "Wellington",
"6432446", "Blenheim",
"6462108", "Ohakune",
"6439063", "Westport",
"6435684", "Winton",
"6469315", "Taihape",
"643260", "Christchurch",
"6474639", "Opotiki",
"6434401", "Cromwell",
"6462806", "Napier\/Hastings",
"644240", "Wellington",
"646955", "Palmerston\ North\/New\ Plymouth",
"6434991", "Cromwell",
"6462811", "New\ Plymouth",
"6466549", "Ruatoria",
"6439453", "Te\ Anau",
"6439317", "Gore",
"6478086", "Hamilton",
"6478070", "Morrinsville",
"6499042", "Hibiscus\ Coast",
"6437454", "Ashburton",
"6439858", "Kaikoura",
"6492228", "Warkworth",
"6435500", "Christchurch",
"6437459", "Rangiora",
"6466017", "Napier",
"6465608", "Dannevirke",
"6473331", "Rotorua",
"6439065", "Ashburton",
"6498016", "Hibiscus\ Coast",
"6469313", "Marton",
"6465622", "Stratford",
"6436518", "Murchison",
"6436627", "Waitangi\ \(Chatham\ Is\.\)",
"6436587", "Gore",
"6435553", "Wanaka",
"6499016", "Kaikohe",
"647217", "Taupo",
"6468304", "Napier\/Wairoa",
"6469309", "Mokau",
"6496997", "Hibiscus\ Coast",
"6439326", "Rangiora",
"643526", "Motueka",
"6472626", "Rotorua",
"6439881", "Greymouth",
"6469304", "Wairoa",
"647213", "Hamilton",
"6436642", "Milton",
"64685", "Waipukurau",
"647876", "Te\ Kuiti",
"646864", "Ruatoria",
"6434264", "Kurow",
"643225", "Otautau",
"6432800", "Te\ Anau",
"6434269", "Twizel",
"6479002", "Matamata",
"6439267", "Dunedin",
"6468996", "Napier",
"6439455", "Otautau",
"643590", "Christchurch",
"646964", "Wanganui",
"644555", "Wellington",
"6436525", "Franz\ Josef",
"6499044", "Hibiscus\ Coast",
"6436685", "Nelson",
"6432808", "Westport",
"6499049", "Great\ Barrier\ Island",
"6474655", "Te\ Kuiti",
"643277", "South\ Island",
"643954", "Dunedin\/Timaru",
"6478091", "Matamata",
"6496", "Auckland",
"64396", "Christchurch",
"6435693", "Nelson",
"6435547", "Blenheim",
"6437487", "Winton",
"6468821", "Featherston",
"6479748", "Taumarunui",
"64941", "Auckland",
"643331", "Christchurch",
"6479020", "Te\ Awamutu",
"644586", "Wellington",
"6437473", "Milton",
"643453", "Dunedin",
"6497773", "Dargaville",
"6435682", "Riverton",
"64634", "Wanganui",
"6449741", "Paraparaumu",
"6466527", "Taihape",
"643457", "Dunedin",
"6435534", "Takaka",
"6462155", "Hawera",
"6499630", "Pukekohe",
"6465600", "Palmerston\ North",
"6493933", "Kaikohe",
"6462129", "Waiouru",
"6435508", "Cheviot",
"6462124", "Marton",
"6439850", "Ashburton",
"643920", "Rangiora",
"6432995", "Winton",
"6435539", "Otautau",
"6473926", "Taumarunui",
"647877", "Te\ Kuiti",
"64337", "Christchurch",
"6472140", "Putaruru\/Tokoroa",
"6433985", "Alexandra",
"64934", "Auckland\/Waiheke\ Island",
"6434274", "Kurow",
"6434239", "Christchurch",
"6467773", "Wanganui",
"6439292", "Timaru",
"6434279", "Twizel",
"6432627", "Alexandra",
"6434234", "Darfield",
"6462610", "Napier",
"6439277", "Invercargill",
"647873", "Otorohanga",
"647216", "Rotorua",
"6432756", "Gore",
"6472819", "Rotorua",
"644902", "Paraparaumu",
"643527", "Motueka",
"6432748", "Cromwell",
"643523", "Murchison",
"6436563", "Lawrence",
"6462220", "New\ Plymouth",
"6439538", "Dunedin\/Timaru",
"6434222", "Gore",
"6472814", "Putaruru\/Tokoroa",
"64379", "South\ Island",
"6462625", "Hawera",
"6439075", "Takaka",
"6479847", "Te\ Awamutu",
"6472803", "Waihi",
"6463918", "Wanganui",
"6469275", "Wanganui",
"6472131", "Rotorua",
"6434247", "Kaikoura",
"6467556", "New\ Plymouth\/Mokau",
"64371", "South\ Island",
"6439052", "Mt\ Cook",
"6478995", "Matamata",
"646841", "Napier\ City",
"6498821", "Dargaville",
"6435887", "Invercargill",
"647220", "Tauranga",
"6439743", "Christchurch",
"6468252", "Dannevirke",
"6432642", "Fox\ Glacier",
"6439283", "Rangiora",
"6433994", "Winton",
"643414", "Balclutha\/Milton",
"6466997", "New\ Plymouth",
"6435992", "Fox\ Glacier",
"6433999", "Otautau",
"6432731", "Timaru",
"6439023", "Te\ Anau",
"6437463", "Mt\ Cook",
"644587", "Wellington",
"6439711", "Geraldine",
"6462162", "Masterton",
"6475621", "Tauranga",
"6499067", "Pukekohe",
"6478143", "Opotiki",
"6469613", "Levin",
"6492", "Auckland",
"6439706", "Nelson",
"643456", "Dunedin",
"6462228", "Wanganui",
"6439530", "Timaru",
"6433942", "Akaroa",
"6496017", "Great\ Barrier\ Island",
"64731", "Whakatane\/Opotiki",
"6479853", "Putaruru",
"6432740", "Lawrence",
"6436995", "Westport",
"646374", "Dannevirke",
"643211", "Invercargill",
"6462618", "Masterton",
"6439757", "Waitangi\ \(Chatham\ Is\.\)",
"6472424", "Tauranga",
"647925", "Tauranga",
"6463925", "Waiouru",
"6469001", "New\ Plymouth",
"6499457", "Kaitaia",
"643276", "South\ Island",
"6472429", "Whakatane",
"6469016", "Ohakune",
"643485", "Lawrence",
"647825", "Hamilton",
"6472148", "Waihi",
"6499879", "Warkworth",
"643943", "Christchurch",
"6436996", "Takaka",
"6472197", "Tauranga",
"64734", "Rotorua",
"6437778", "Greymouth",
"6472132", "Taupo",
"643947", "Invercargill",
"6499874", "Kawakawa",
"6475600", "Hamilton",
"6432641", "Franz\ Josef",
"6472129", "Whangamata",
"6468251", "Wanganui",
"6469573", "Palmerston\ North",
"6472124", "Matamata",
"6498822", "Kaikohe",
"6463926", "Taihape",
"643241", "Tokanui\/Lumsden\/Te\ Anau",
"6477888", "Taupo",
"6439291", "Dunedin",
"649428", "Hibiscus\ Coast",
"6433913", "Murchison",
"643444", "Ranfurly",
"6434290", "Greymouth",
"6469288", "Waiouru",
"6432630", "Christchurch",
"6439705", "Motueka",
"6434221", "Invercargill",
"6439017", "Cromwell",
"6469020", "Stratford",
"649451", "Auckland",
"6467529", "Mokau",
"6433941", "Blenheim",
"643552", "Dunedin",
"6462626", "Mokau",
"6432609", "Mt\ Cook",
"6439076", "Ashburton",
"6469280", "Waipukurau",
"6469276", "Wanganui",
"6432638", "Tokanui",
"6442199", "Paraparaumu",
"646213", "Wanganui",
"6496509", "Pukekohe",
"6469869", "Ruatoria",
"64785", "Hamilton",
"643234", "Riverton",
"6434298", "Hokitika",
"647864", "Thames",
"649402", "Kawakawa",
"64795", "Hamilton",
"6469002", "Hawera",
"6478996", "Huntly",
"6442127", "Paraparaumu",
"6477880", "Hamilton",
"6439527", "Kurow",
"6498853", "Whangarei",
"6432732", "Fairlie",
"6435991", "Franz\ Josef",
"6432223", "Akaroa",
"64931", "Auckland\/Waiheke\ Island",
"6433986", "Queenstown",
"6475608", "Otorohanga",
"6475622", "Tauranga",
"6432724", "Greymouth",
"6437770", "Nelson",
"647463", "Whakatane",
"6496513", "Whangarei",
"6462161", "Masterton",
"646654", "Gisborne",
"6439712", "Fairlie",
"6432755", "Edendale",
"6492429", "Pukekohe",
"6432613", "Waitangi\ \(Chatham\ Is\.\)",
"6432729", "Westport",
"6439882", "Westport",
"6436641", "Lawrence",
"643538", "Nelson",
"6469853", "Waiouru",
"6432660", "Christchurch",
"643905", "Ashburton",
"6499559", "Whangarei",
"6432996", "Riverton",
"6462424", "Wanganui",
"6473925", "Putaruru\/Tokoroa",
"6479001", "Hamilton",
"64325", "South\ Island",
"6462156", "Hawera",
"6435650", "Greymouth",
"6439318", "Lumsden",
"6499554", "Kaitaia",
"6468800", "Napier\/Hastings",
"6474656", "Te\ Awamutu",
"6436630", "Takaka",
"6473332", "Rotorua",
"6474648", "Huntly",
"6449008", "Paraparaumu",
"643461", "Dunedin\/Palmerston",
"6466509", "Napier\/Waipukurau",
"6475827", "Hamilton",
"6436686", "Invercargill",
"6436526", "Fox\ Glacier",
"6439333", "Franz\ Josef",
"646761", "Opunake",
"647982", "Hamilton",
"6462107", "Dannevirke",
"6465621", "New\ Plymouth",
"64944", "Auckland",
"643946", "Invercargill",
"64347", "Dunedin",
"647882", "Putaruru\/Tokoroa",
"6472625", "Opotiki",
"64923", "Pukekohe",
"643751", "Fox\ Glacier",
"6462803", "Palmerston\ North",
"647466", "Tauranga",
"6479049", "Te\ Kuiti",
"6435681", "Invercargill",
"6439325", "Kaikoura",
"6478083", "Hamilton",
"6468995", "Napier",
"6439456", "Riverton",
"6499748", "Whangarei",
"6436638", "Kurow",
"6468808", "Palmerston\ North",
"6478077", "Waihi",
"6439310", "Invercargill",
"643682", "Timaru\/Waimate\/Fairlie",
"644889", "Wellington",
"6478092", "Huntly",
"6477773", "Taupo",
"6472610", "Morrinsville",
"644572", "Wellington",
"64452", "Wellington",
"6436613", "Wanaka",
"6499015", "Dargaville",
"6434404", "Alexandra",
"6432668", "Blenheim",
"6462819", "Levin",
"6434999", "Dunedin",
"6473933", "Rotorua",
"6439066", "Hokitika",
"6472220", "Tauranga",
"6432443", "Christchurch",
"6434994", "Palmerston",
"6462814", "Hawera",
"6434409", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6468822", "Masterton",
"6439323", "Cheviot",
"6499004", "Hibiscus\ Coast",
"6466528", "Dannevirke",
"643950", "Dunedin",
"6462805", "Napier\/Hastings",
"644210", "Wellington",
"6436580", "Invercargill",
"6436576", "Cromwell",
"6436620", "Kaikoura",
"6472623", "Tauranga",
"643269", "South\ Island",
"6473339", "Taupo",
"647883", "Putaruru\/Tokoroa",
"6435507", "Ashburton",
"6437451", "Blenheim",
"6479708", "Thames",
"647987", "Tauranga",
"647983", "Hamilton",
"6468993", "Taihape",
"64338", "Christchurch",
"647887", "Morrinsville",
"6466010", "Taihape",
"6478085", "Tauranga",
"6436615", "Ashburton",
"6432807", "Tokanui",
"6434261", "Balclutha",
"6499552", "Dargaville",
"6477775", "Huntly",
"6462422", "Napier\/Hastings",
"6496990", "Kaitaia",
"6432445", "Greymouth",
"647551", "Tauranga",
"6439889", "Christchurch\/Blenheim\/Nelson",
"6469316", "Dannevirke",
"6439884", "Franz\ Josef",
"643924", "Christchurch",
"6473935", "Rotorua",
"6469301", "Ruatoria",
"6437488", "South\ Island",
"6435548", "Westport",
"6499013", "Kawakawa",
"6435556", "Fairlie",
"643338", "Christchurch",
"6479747", "Te\ Kuiti",
"643978", "Christchurch",
"6497776", "Hibiscus\ Coast",
"6435540", "Edendale",
"6468824", "Wanganui",
"6437480", "Gore",
"6462812", "Napier\/Hastings",
"6437476", "Ranfurly",
"6434992", "Ranfurly",
"6479027", "Paeroa",
"649406", "Kaitaia",
"6434402", "Alexandra",
"6496998", "Helensville",
"644577", "Wellington",
"644815", "Wellington",
"6493936", "Maungaturoto",
"6499041", "Helensville",
"6439268", "Dunedin",
"6473923", "Otorohanga",
"6478094", "Tauranga",
"6466018", "Napier",
"6439335", "Haast",
"6435531", "Nelson",
"6465607", "Taihape",
"6462121", "Palmerston\ North",
"6492227", "Whangarei",
"6439857", "Akaroa",
"6436588", "Lumsden",
"6436628", "Ashburton",
"6479753", "Taupo",
"6435696", "Haast",
"646860", "Gisborne\/Ruatoria",
"6466520", "Palmerston\ North",
"6436517", "Motueka",
"646960", "Wanganui\/New\ Plymouth",
"644895", "Paraparaumu",
"6472806", "Matamata",
"649395", "Auckland\/Waiheke\ Island",
"643410", "Balclutha\/Milton",
"6472811", "Tauranga",
"6462227", "Napier",
"646321", "Marton",
"6472147", "Paeroa",
"643218", "Invercargill",
"6434271", "Balclutha",
"6439270", "Greymouth",
"6439286", "Cromwell",
"6439758", "Ashburton",
"6462617", "Masterton",
"6434231", "Christchurch",
"6499458", "Kawakawa",
"6432620", "Palmerston",
"643669", "Christchurch",
"6439746", "Dunedin",
"6467776", "Levin",
"6472122", "Te\ Awamutu",
"6498824", "Kawakawa",
"6432225", "Greymouth",
"647986", "Hamilton",
"6442420", "Wellington",
"647886", "Putaruru\/Tokoroa",
"643942", "Christchurch",
"6435880", "Dunedin",
"6498855", "Kawakawa",
"6466998", "New\ Plymouth",
"6432615", "Amberley",
"6499068", "Pukekohe",
"64754", "Tauranga",
"6496515", "Dargaville",
"6432753", "Winton",
"643449", "Alexandra",
"646830", "Napier",
"6436566", "Kurow",
"6434240", "Ashburton",
"6439714", "Waimate",
"6434248", "Cheviot",
"643239", "Invercargill",
"647869", "Thames",
"643981", "Christchurch",
"6479848", "Te\ Kuiti",
"6475624", "Rotorua",
"6432722", "Murchison",
"6439719", "Waimate",
"6499060", "Warkworth",
"6479856", "Tauranga",
"6463917", "Wanganui",
"6432739", "Balclutha",
"6433991", "Invercargill",
"6466990", "Mokau",
"646848", "Napier\ City",
"6435888", "Timaru",
"643655", "Dunedin",
"6469575", "Waiouru",
"647462", "Taupo",
"6435561", "Dunedin",
"6432734", "Waimate",
"6499450", "Warkworth",
"6432628", "Ranfurly",
"6469004", "Napier\/Hastings",
"6433915", "Greymouth",
"6439278", "Invercargill",
"6439750", "Kaikoura",
"6469009", "Palmerston\ North",
"6439026", "Riverton",
"6439537", "Dunedin\/Timaru",
"6437466", "Cromwell",
"649403", "Kawakawa",
"6493206", "Pukekohe",
"649407", "Kaikohe",
"6439703", "Takaka",
"6469616", "Featherston",
"644576", "Wellington",
"6432747", "Queenstown",
"6496010", "Kaitaia",
"6499011", "Kaitaia",
"6473998", "Taumarunui",
"643759", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"64998", "Whangarei",
"6436508", "Rangiora",
"647826", "Huntly",
"6469303", "Waipukurau",
"6439767", "Alexandra",
"6436579", "Wanaka",
"6499467", "Kaitaia",
"646968", "New\ Plymouth\ W100",
"646952", "Palmerston\ North\ W100",
"647926", "Tauranga",
"6499006", "Whangarei",
"6474652", "Paeroa",
"6435510", "Darfield",
"643576", "Nelson",
"647949", "Hamilton",
"6465618", "Masterton",
"6499297", "Hibiscus\ Coast",
"6434263", "Lawrence",
"6436522", "Greymouth",
"6436682", "Dunedin",
"6479240", "Taupo",
"6466007", "Stratford",
"6432810", "Franz\ Josef",
"6432992", "Gore",
"6468991", "Gisborne",
"643455", "Dunedin",
"6462152", "New\ Plymouth",
"6437453", "Amberley",
"6436547", "Geraldine",
"6479500", "Whakatane",
"6439870", "Queenstown",
"6439886", "Christchurch\/Blenheim\/Nelson",
"6472621", "Tauranga",
"6469319", "Masterton",
"6435554", "Cromwell",
"6432428", "Queenstown",
"6495", "Auckland",
"6435559", "Haast",
"6439321", "Amberley",
"6435685", "Tokanui",
"6469314", "Waiouru",
"6437479", "Edendale",
"6468262", "Napier",
"643690", "Waimate",
"6497779", "Great\ Barrier\ Island",
"6432420", "Christchurch",
"6479751", "Tauranga",
"6439062", "Ashburton",
"6497774", "Warkworth",
"6465625", "Gisborne",
"6462417", "Wanganui",
"6468826", "Levin",
"6439878", "Christchurch\/Blenheim\/Nelson",
"6437474", "Oamaru",
"64930", "Auckland",
"6432887", "Nelson",
"6462123", "Palmerston\ North",
"6493939", "Auckland",
"6493934", "Kaitaia",
"6432818", "Christchurch",
"6435533", "Murchison",
"6479248", "Rotorua\/Whakatane\/Tauranga",
"6437447", "Greymouth",
"6473921", "Matamata",
"6439452", "Gore",
"6479005", "Tauranga",
"6465610", "Napier",
"6479717", "Otorohanga",
"647215", "Rotorua",
"6499043", "Hibiscus\ Coast",
"643469", "Dunedin",
"6492007", "Warkworth",
"6435518", "Milton",
"643921", "Blenheim",
"6435699", "Amberley",
"646769", "New\ Plymouth",
"6436645", "Ranfurly",
"643958", "Dunedin\/Timaru",
"6436500", "Christchurch",
"6435694", "Franz\ Josef",
"6473990", "Te\ Awamutu",
"6439860", "Nelson",
"6472809", "Otorohanga",
"6479420", "Tauranga",
"6472804", "Whangamata",
"6462165", "Stratford",
"6432751", "Riverton",
"6439284", "Blenheim",
"643984", "Blenheim",
"6439744", "Queenstown",
"6435995", "Darfield",
"6462600", "Palmerston\ North",
"6434287", "Queenstown",
"6439749", "Christchurch",
"6439289", "Akaroa",
"646840", "Napier\ City",
"6467779", "Masterton",
"6434233", "Rangiora",
"64480", "Wellington",
"6467774", "Dannevirke",
"6434273", "Lawrence",
"6432717", "Kaikoura",
"6498826", "Warkworth",
"6479101", "Rotorua",
"6463922", "Palmerston\ North",
"64630", "Featherston",
"647923", "Whakatane",
"6472813", "Waihi",
"6463908", "Wairoa",
"6433945", "Cheviot",
"6436992", "Greymouth",
"6436564", "Milton",
"647827", "Hamilton",
"64332", "Christchurch",
"6439737", "Tokanui",
"643483", "Dunedin\/Lawrence\/Mosgiel",
"6436569", "Alexandra",
"647823", "Hamilton",
"6499477", "Pukekohe",
"647927", "Tauranga",
"6475626", "Taupo",
"6434225", "Edendale",
"6439701", "Nelson",
"6479854", "Rotorua",
"6439716", "Geraldine",
"646838", "Wairoa",
"6479859", "Tauranga",
"647875", "Te\ Awamutu\/Otorohanga\/Te\ Kuiti",
"643226", "Otautau",
"6463900", "Gisborne",
"6439295", "Nelson",
"6478137", "Thames",
"6432736", "Dunedin",
"643249", "Te\ Anau",
"6433982", "Kurow",
"643525", "Takaka",
"6444887", "Paraparaumu",
"647312", "Whakatane",
"64698", "Gisborne",
"6435563", "Queenstown",
"6439024", "Lumsden",
"6468255", "Pahiatua",
"6462608", "Dannevirke",
"6432645", "Greymouth",
"6439055", "Fairlie",
"6439029", "Tokanui",
"6478992", "Paeroa",
"6433993", "Te\ Anau",
"6469006", "Gisborne",
"6469614", "Levin",
"6493209", "Great\ Barrier\ Island",
"6437469", "Alexandra",
"6478144", "Tauranga",
"643418", "Balclutha",
"6469297", "Masterton",
"6439072", "Ashburton",
"649459", "Whangarei",
"6496007", "Helensville",
"6469272", "Featherston",
"6439097", "Darfield",
"6437464", "Timaru",
"6469619", "Wanganui\/New\ Plymouth",
"6439868", "Blenheim",
"6436999", "Nelson",
"643989", "Nelson",
"647861", "Paeroa\/Waihi\/Thames\/Whangamata",
"643231", "Invercargill",
"6499876", "Kaikohe",
"6434223", "Otautau",
"6463997", "Palmerston\ North",
"6498880", "Helensville",
"6436994", "Murchison",
"6474440", "Paeroa",
"6436562", "Balclutha",
"6467772", "Hawera",
"6472459", "Rotorua",
"6475617", "Whakatane",
"6472126", "Otorohanga",
"649347", "Auckland",
"6442821", "Wellington",
"6433911", "Nelson",
"643937", "South\ Island",
"647822", "Hamilton\/Huntly",
"6463924", "Marton",
"6439727", "Dunedin",
"6469710", "New\ Plymouth",
"646956", "Palmerston\ North\/New\ Plymouth",
"64733", "Rotorua\/Taupo",
"647922", "Whakatane",
"6439293", "Blenheim",
"6433995", "Tokanui",
"6469571", "Palmerston\ North",
"6432643", "Haast",
"6439282", "Christchurch",
"6468253", "Marton",
"6472828", "Tauranga",
"6439742", "Christchurch",
"646651", "Napier",
"6472802", "Paeroa",
"6433957", "Palmerston",
"6439000", "Christchurch",
"6469200", "Gisborne",
"6462624", "Opunake",
"6439074", "Ashburton",
"6432611", "Kaikoura",
"6469274", "New\ Plymouth",
"6496511", "Whangarei",
"6462163", "New\ Plymouth",
"6469045", "Waipukurau",
"6437462", "Geraldine",
"64399", "South\ Island",
"6439008", "Timaru",
"6469279", "Levin",
"6469612", "Wanganui\/New\ Plymouth",
"6478142", "Whakatane",
"6432606", "Dunedin",
"6439079", "Murchison",
"6462629", "Levin",
"649957", "Pukekohe",
"64367", "South\ Island",
"6472820", "Hamilton",
"6432221", "Nelson",
"6478994", "Tauranga",
"6439022", "Ashburton",
"649420", "Helensville",
"6435993", "Mt\ Cook",
"6478999", "Hamilton",
"64373", "Greymouth",
"6498851", "Pukekohe",
"6468247", "Mokau",
"6432657", "Motueka",
"6433984", "Roxburgh",
"6434275", "Milton",
"6469247", "Wanganui",
"6434235", "Akaroa",
"6492837", "Hibiscus\ Coast",
"6433989", "Waimate",
"6439047", "Alexandra",
"6449", "Wellington",
"6435667", "Waitangi\ \(Chatham\ Is\.\)",
"6474448", "Taumarunui",
"64391", "South\ Island",
"6432726", "Franz\ Josef",
"6498817", "Hibiscus\ Coast",
"643441", "Queenstown",
"6479852", "Whangamata",
"644905", "Paraparaumu",
"6472815", "Whakatane",
"6433943", "Amberley",
"6492426", "Whangarei",
"6499718", "Whangarei",
"6465623", "Opunake",
"6469312", "Ohakune",
"6466557", "Stratford",
"6479290", "Hamilton",
"6435552", "Queenstown",
"6435535", "Invercargill",
"6468888", "Masterton",
"6479014", "Matamata",
"6462154", "New\ Plymouth",
"6432999", "Invercargill",
"6439331", "Greymouth",
"643754", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6473948", "Opotiki",
"6499556", "Maungaturoto",
"64376", "Greymouth",
"6447770", "Paraparaumu",
"6462125", "Taihape",
"6462426", "Levin",
"6479019", "Whangamata",
"6462159", "Mokau",
"6432994", "Otautau",
"6468817", "Stratford",
"64943", "Whangarei",
"646953", "Palmerston\ North\ W100",
"6474659", "Whangamata",
"6436684", "Dunedin",
"6499045", "Hibiscus\ Coast",
"6436524", "Hokitika",
"643936", "South\ Island",
"6442609", "Paraparaumu",
"6436529", "Westport",
"6436689", "Christchurch",
"6474654", "Taumarunui",
"6479003", "Thames",
"6499733", "Warkworth",
"6439340", "Mt\ Cook",
"6469851", "Napier",
"6436643", "Balclutha",
"6436597", "Cromwell",
"6468305", "Napier\/Wairoa",
"6432441", "Christchurch",
"6435677", "Ranfurly",
"6435692", "Takaka",
"6462118", "Waipukurau",
"6439348", "South\ Island",
"6469305", "New\ Plymouth",
"6473931", "Whangamata",
"6439459", "Tokanui",
"64736", "Rotorua",
"6499725", "Hibiscus\ Coast",
"6436611", "Rangiora",
"6434265", "Milton",
"6477771", "Whakatane",
"6439454", "Lumsden",
"6493932", "Dargaville",
"64675", "New\ Plymouth",
"6495567", "Kaitaia",
"6437455", "Cheviot",
"646764", "Stratford",
"6472607", "Paeroa",
"6478081", "Rotorua",
"6468880", "Napier\/Hastings",
"6439064", "Ashburton",
"6435683", "Te\ Anau",
"6468269", "New\ Plymouth",
"6497772", "Kaitaia",
"6479298", "Taupo",
"6436657", "Franz\ Josef",
"6437472", "Lawrence",
"6462816", "Gisborne",
"6434996", "Roxburgh",
"6462801", "Palmerston\ North",
"6434406", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6439069", "Haast",
"643464", "Dunedin",
"6468264", "Palmerston\ North",
"6479718", "Taumarunui",
"6492008", "Hibiscus\ Coast",
"6435517", "Lawrence",
"644817", "Wellington",
"6437448", "Haast",
"6479247", "Hamilton",
"6466000", "Napier",
"6437456", "Culverden",
"643334", "Christchurch",
"643685", "Fairlie",
"6434405", "Alexandra",
"6499014", "Dargaville",
"6498019", "Pukekohe",
"6439883", "Hokitika",
"6499460", "Whangarei",
"643951", "Dunedin",
"6439760", "Twizel",
"6469852", "Napier",
"6462815", "Wairoa",
"644211", "Wellington",
"6434995", "Te\ Anau",
"6499019", "Maungaturoto",
"6472624", "Whakatane",
"6439329", "South\ Island",
"6469306", "Hawera",
"6439877", "Christchurch\/Blenheim\/Nelson",
"6435551", "Franz\ Josef",
"6479045", "Taumarunui",
"6462418", "Palmerston\ North",
"643539", "Nelson",
"6499003", "Warkworth",
"6468306", "Napier\/Wairoa",
"6469311", "Palmerston\ North",
"6472629", "Taupo",
"6439324", "Darfield",
"6468994", "Waipukurau",
"644897", "Wellington",
"6432817", "Christchurch",
"6432888", "Nelson",
"6439332", "Hokitika",
"6468999", "Napier",
"644893", "Wellington",
"6499726", "Kawakawa",
"6434266", "Palmerston",
"6436548", "Waimate",
"644888", "Wellington",
"6478082", "Tauranga",
"6493931", "Whangarei",
"6499046", "Pukekohe",
"64936", "Auckland",
"6462802", "Palmerston\ North",
"643425", "Dunedin",
"647885", "Putaruru\/Tokoroa",
"6462410", "New\ Plymouth",
"6497771", "Kaikohe",
"6479754", "Tauranga",
"6437471", "Kurow",
"6432427", "Greymouth",
"646388", "Taihape",
"6473932", "Rotorua",
"6439768", "Ranfurly",
"649320", "Auckland",
"64483", "Wellington",
"6499468", "Kawakawa",
"6436507", "Kaikoura",
"6468823", "Napier\/Hastings",
"6473997", "Te\ Kuiti",
"6432442", "Christchurch",
"6435691", "Murchison",
"643409", "Queenstown",
"6477772", "Rotorua",
"6499298", "Pukekohe",
"6478093", "Rotorua",
"6465617", "Mokau",
"6462126", "Pahiatua",
"6462425", "Masterton",
"6466008", "Ohakune",
"6437440", "Nelson",
"6473924", "Paeroa",
"64687", "Napier\/Hastings",
"6436612", "Akaroa",
"6435536", "Invercargill",
"6473929", "Thames",
"6479710", "Putaruru\/Tokoroa",
"64697", "Napier",
"6499555", "Kawakawa",
"649396", "Auckland\/Waiheke\ Island",
"6439281", "Christchurch",
"6434236", "Amberley",
"644896", "Wellington",
"6469468", "Featherston",
"6439741", "Christchurch",
"646320", "Palmerston\ North\/Marton",
"649429", "Great\ Barrier\ Island",
"6498823", "Kaitaia",
"6434276", "Palmerston",
"6434280", "Queenstown",
"6462607", "Taihape",
"6463940", "Levin",
"6469572", "Palmerston\ North",
"643653", "Blenheim",
"6432725", "Hokitika",
"6469298", "Masterton",
"643411", "Balclutha\/Milton",
"6432759", "South\ Island",
"6439867", "Christchurch\/Blenheim\/Nelson",
"6439098", "Akaroa",
"6472816", "Morrinsville",
"6496008", "Hibiscus\ Coast",
"6472801", "Huntly",
"6432754", "Tokanui",
"6472133", "Taupo",
"64933", "Auckland",
"643657", "Queenstown",
"6439730", "Invercargill",
"643214", "Invercargill",
"646371", "Masterton\/Dannevirke\/Pahiatua",
"6436561", "Oamaru",
"6472118", "Taumarunui",
"6499470", "Hibiscus\ Coast",
"6467525", "Mokau",
"6479109", "Opotiki",
"649405", "Kaikohe",
"64636", "Levin",
"6444888", "Paraparaumu",
"644816", "Wellington",
"6467771", "New\ Plymouth",
"6432710", "Christchurch",
"6478138", "Waihi",
"6433912", "Motueka",
"6432718", "Rangiora",
"6478130", "Morrinsville",
"64335", "Christchurch",
"6469003", "Napier\/Hastings",
"6433996", "Edendale",
"649397", "Auckland\/Waiheke\ Island",
"644590", "Wellington",
"643980", "Christchurch",
"6439704", "Murchison",
"6479851", "Waihi",
"6499478", "Pukekohe",
"6439709", "Motueka",
"6463907", "Waipukurau",
"643743", "Christchurch",
"6439738", "Winton",
"646844", "Napier\/Hastings",
"6469611", "Wanganui",
"644209", "Wellington",
"6475623", "Tauranga",
"6478141", "Taupo",
"6439090", "Rangiora",
"6432612", "Rangiora",
"6437461", "Fairlie",
"6469290", "Napier\/Hastings",
"6439713", "Mt\ Cook",
"6499875", "Dargaville",
"6496512", "Whangarei",
"6469014", "Dannevirke",
"6434288", "Cromwell",
"6439021", "Ashburton",
"6432733", "Geraldine",
"6498852", "Warkworth",
"6472125", "Huntly",
"6469019", "Pahiatua",
"6432222", "Christchurch",
"6492838", "Pukekohe",
"6492809", "Maungaturoto",
"6463921", "Palmerston\ North",
"6439048", "Lawrence",
"6469005", "Wanganui",
"6479102", "Rotorua",
"6433914", "Takaka",
"6475610", "Putaruru\/Tokoroa",
"6432658", "Murchison",
"6499420", "Pukekohe",
"6433919", "Haast",
"6468248", "New\ Plymouth",
"643240", "Tokanui\/Lumsden\/Te\ Anau",
"6439720", "Blenheim",
"6468256", "Palmerston\ North",
"6432646", "Timaru",
"6478128", "Huntly",
"6498901", "Pukekohe",
"6474447", "Te\ Kuiti",
"6435668", "Kurow",
"643448", "Alexandra",
"649424", "Hibiscus\ Coast",
"6499818", "Great\ Barrier\ Island",
"6436991", "Culverden",
"6463990", "Featherston",
"6439715", "Timaru",
"6432752", "Te\ Anau",
"6433950", "Waitangi\ \(Chatham\ Is\.\)",
"6499873", "Kaitaia",
"6475625", "Rotorua",
"6434226", "Lumsden",
"6439007", "Dunedin",
"6499101", "Pukekohe",
"644260", "Wellington",
"643219", "Invercargill",
"6472123", "Morrinsville",
"6469574", "Taihape",
"6439296", "Invercargill",
"6469579", "Pahiatua",
"6432735", "Mt\ Cook",
"64328", "South\ Island",
"6498859", "Kaitaia",
"6498825", "Maungaturoto",
"6478991", "Whangamata",
"6432224", "Invercargill",
"6472827", "Tauranga",
"6469012", "Waiouru",
"6432229", "Dunedin",
"6498854", "Hibiscus\ Coast",
"6495530", "Great\ Barrier\ Island",
"6432614", "South\ Island",
"6462621", "New\ Plymouth",
"6439071", "Motueka",
"6496514", "Whangarei",
"6469271", "Pahiatua",
"6433946", "Culverden",
"6496519", "Maungaturoto",
"6432723", "Takaka",
"6432619", "Christchurch",
"6433958", "Oamaru",
"6463998", "Palmerston\ North",
"643238", "Riverton\/Winton",
"6499810", "Hibiscus\ Coast",
"6462166", "Opunake",
"6435660", "Haast",
"647868", "Thames",
"6439702", "Nelson",
"649392", "Auckland",
"646365", "Palmerston\ North",
"644204", "Wellington",
"6433981", "Twizel",
"643430", "Mt\ Cook",
"646849", "Napier\ City",
"6439728", "Franz\ Josef",
"643742", "Dunedin",
"6432650", "Christchurch",
"6499428", "Warkworth",
"646949", "Levin\ W100",
"6475618", "Opotiki",
"6439040", "Balclutha",
"6435996", "Akaroa",
"6469240", "Gisborne",
"6439334", "Fox\ Glacier",
"6462151", "New\ Plymouth",
"647245", "Hamilton",
"6472608", "Waihi",
"6479229", "Opotiki",
"6468810", "Ohakune",
"6439339", "South\ Island",
"6468992", "Wairoa",
"6432991", "Milton",
"6495568", "Kawakawa",
"6466550", "New\ Plymouth",
"64370", "South\ Island",
"644892", "Paraparaumu",
"6439322", "Culverden",
"6479297", "Tauranga",
"6436658", "Fox\ Glacier",
"6472622", "Tauranga",
"643339", "Christchurch",
"643979", "Christchurch",
"6436646", "Roxburgh",
"6439347", "Christchurch",
"6465626", "Ruatoria",
"646760", "New\ Plymouth\/Opunake\/Stratford",
"6468825", "Gisborne",
"6469854", "Waipukurau",
"6435678", "Roxburgh",
"6499012", "Kawakawa",
"6436590", "Nelson",
"643268", "South\ Island",
"6499553", "Kaikohe",
"6436681", "Dunedin",
"6436521", "Greymouth",
"6462423", "Gisborne",
"6474651", "Otorohanga",
"643460", "Dunedin\/Palmerston",
"6478095", "Taupo",
"6436614", "Timaru",
"6477779", "Putaruru\/Tokoroa",
"6477774", "Thames",
"6436619", "Cheviot",
"6439451", "Invercargill",
"6473922", "Morrinsville",
"643750", "Haast",
"64730", "Whakatane",
"6462813", "Wanganui",
"6434993", "Alexandra",
"6436598", "Wanaka",
"6432444", "Nelson",
"64368", "Timaru",
"643903", "Christchurch",
"6435686", "Gore",
"6435526", "Kurow",
"6435670", "Palmerston",
"6439885", "Fox\ Glacier",
"6473934", "Rotorua",
"6434403", "Queenstown\/Cromwell\/Alexandra\/Wanaka\/Ranfurly\/Roxburgh",
"6432449", "Queenstown",
"649554", "Hibiscus\ Coast",
"6479752", "Rotorua",
"6439061", "Greymouth",
"6436650", "Otautau",
"6462809", "Napier\/Hastings",
"6499717", "Whangarei",
"6462804", "Palmerston\ North",
"6466558", "Opunake",
"6468261", "Masterton",
"6495560", "Whangarei",
"6468818", "Opunake",
"6473947", "Whakatane",
"6472600", "Hamilton",
"6468887", "Gisborne",
"6493990", "Great\ Barrier\ Island",
"6478084", "Hamilton",
"643224", "Invercargill",
"643278", "South\ Island",
"6472602", "Hamilton",
"6436635", "Fairlie",
"644890", "Wellington",
"6493937", "Warkworth",
"646965", "Wanganui\ W100",
"6495562", "Whangarei",
"6432889", "Blenheim",
"6468998", "Napier",
"6479026", "Paeroa",
"6462419", "Masterton",
"6466523", "Palmerston\ North",
"6439328", "South\ Island",
"6436652", "Winton",
"6497777", "Auckland",
"6472628", "Taupo",
"6462414", "Napier",
"647557", "Tauranga",
"6479750", "Tauranga",
"6432421", "Tokanui\/Lumsden\/Te\ Anau",
"6437477", "Roxburgh",
"643462", "Dunedin\/Palmerston",
"643458", "Dunedin\/Queenstown",
"6498018", "Whangarei",
"6473991", "Whakatane",
"6432665", "South\ Island",
"6499018", "Maungaturoto",
"6436501", "Akaroa",
"6493944", "Hibiscus\ Coast",
"6435672", "Balclutha",
"6437483", "Otautau",
"6435697", "Westport",
"6435543", "Tokanui",
"6492009", "Pukekohe",
"6465611", "Napier",
"6437444", "Takaka",
"643250", "Christchurch",
"6473920", "Huntly",
"6492226", "Helensville",
"6479719", "Te\ Kuiti",
"647881", "Matamata",
"6439856", "Darfield",
"643421", "Christchurch",
"646762", "Stratford",
"6479714", "Huntly",
"6468805", "Wanganui",
"644810", "Wellington",
"6437449", "Hokitika",
"647981", "Hamilton",
"6465606", "Waiouru",
"646959", "Palmerston\ North\/New\ Plymouth",
"6466009", "Waiouru",
"6435511", "Kaikoura",
"6439315", "Tokanui",
"6499299", "Whangarei",
"6479241", "Whakatane",
"6472615", "Te\ Kuiti",
"6435506", "Amberley",
"64354", "Nelson",
"643752", "Franz\ Josef",
"6473928", "Te\ Awamutu",
"6466004", "Waipukurau",
"6436592", "Nelson",
"6499469", "Maungaturoto",
"6439769", "Roxburgh",
"6436577", "Cromwell",
"6499010", "Kaitaia",
"6439764", "Lawrence",
"6496993", "Whangarei",
"64948", "Auckland",
"6499464", "Whangarei",
"6472225", "Rotorua",
"6435557", "Geraldine",
"644571", "Wellington",
"6472620", "Tauranga",
"6479746", "Opotiki",
"6436623", "Amberley",
"6436583", "Te\ Anau",
"6439871", "Queenstown",
"6443990", "Paraparaumu",
"6439320", "Akaroa",
"647218", "Tauranga",
"6479230", "Opotiki",
"6466552", "New\ Plymouth",
"6469317", "Pahiatua",
"6468990", "Ruatoria",
"64456", "Wellington",
"6466013", "Featherston",
"6432811", "Fox\ Glacier",
"6468812", "Waiouru",
"6436549", "Mt\ Cook",
"64320", "Gore",
"6479501", "Opotiki",
"6432806", "Edendale",
"643955", "Dunedin",
"6492832", "Dargaville",
"6444889", "Paraparaumu",
"6469242", "Levin",
"6478134", "Taumarunui",
"6494314", "Warkworth",
"6439042", "Oamaru",
"6479108", "Whakatane",
"6434295", "Fox\ Glacier",
"6468242", "Ruatoria",
"6499453", "Warkworth",
"6478139", "Whangamata",
"6432652", "Cromwell",
"6439753", "Amberley",
"6439700", "Nelson",
"6432635", "Riverton",
"6496013", "Whangarei",
"6479857", "Opotiki",
"6463916", "Mokau",
"6469025", "Mokau",
"6463901", "Gisborne",
"6435662", "Geraldine",
"6472119", "Thames",
"6439099", "Kaikoura",
"64378", "Westport",
"6496009", "Pukekohe",
"649959", "Hibiscus\ Coast",
"6432758", "Otautau",
"6469617", "Wanganui\/New\ Plymouth",
"6432746", "Alexandra",
"6499063", "Hibiscus\ Coast",
"6469299", "Napier\/Hastings",
"6469294", "Palmerston\ North",
"6439536", "Waimate",
"6439094", "Ashburton",
"6437467", "Queenstown",
"6493207", "Hibiscus\ Coast",
"6439027", "Winton",
"6495532", "Warkworth",
"64790", "Taupo",
"6469010", "Taihape",
"6475605", "Huntly",
"649452", "Auckland",
"6466993", "Waiouru",
"646327", "Marton",
"6439287", "Oamaru",
"6462616", "Ruatoria",
"6434289", "Wanaka",
"646375", "Pahiatua",
"6435883", "Dunedin",
"6439747", "Wanaka",
"6463944", "Featherston",
"6434284", "Wanaka",
"647824", "Hamilton",
"6472146", "Otorohanga",
"647878", "Te\ Kuiti",
"6462601", "Palmerston\ North",
"6437775", "Wanaka",
"649401", "Kaikohe",
"6434243", "Akaroa",
"6439861", "Nelson",
"644975", "Paraparaumu",
"6462226", "Napier",
"6472807", "Te\ Awamutu",
"643528", "Motueka",
"6479843", "Morrinsville",
"6432750", "Invercargill",
"6479421", "Tauranga",
"6433952", "Fairlie",
"643983", "Christchurch",
"6499479", "Pukekohe",
"6463992", "Levin",
"64738", "Taupo",
"6436567", "Ranfurly",
"6439734", "Edendale",
"64360", "South\ Island",
"6469285", "Hawera",
"643740", "Christchurch",
"6439739", "Invercargill",
"6439085", "Waitangi\ \(Chatham\ Is\.\)",
"6499474", "Helensville",
"6439708", "Murchison",
"6439722", "Blenheim",
"643415", "Balclutha",
"649390", "Auckland",
"6439273", "Blenheim",
"6499422", "Helensville",
"6432719", "Waitangi\ \(Chatham\ Is\.\)",
"6432623", "Lawrence",
"643939", "South\ Island",
"6477885", "Tauranga",
"6479100", "Rotorua",
"6467777", "Napier",
"6475612", "Te\ Kuiti",
"6432714", "Cheviot",
"649349", "Auckland",
"6432220", "Dunedin",
"6478997", "Morrinsville",
"6472821", "Hamilton",
"6439526", "Twizel",
"6435885", "Invercargill",
"6498850", "Great\ Barrier\ Island",
"6469578", "Marton",
"64683", "Napier\/Hastings",
"6462627", "Wanganui",
"6439077", "Ashburton",
"6469292", "Ruatoria",
"6479845", "Paeroa",
"6496510", "Whangarei",
"6469277", "Gisborne",
"6439092", "Rangiora",
"6432610", "Darfield",
"64637", "Masterton",
"6434245", "Culverden",
"646322", "Marton",
"6437773", "Dunedin",
"64349", "South\ Island",
"6439083", "Cheviot",
"6435664", "Timaru",
"643941", "Christchurch",
"6478129", "Matamata",
"6469283", "Opunake",
"646766", "New\ Plymouth",
"6444", "Wellington",
"6499819", "Helensville",
"6498814", "Pukekohe",
"644666", "Wellington",
"6435669", "Wanaka",
"6468244", "Waipukurau",
"643466", "Dunedin",
"6432654", "Blenheim",
"6492808", "Great\ Barrier\ Island",
"6439049", "Palmerston",
"6433987", "Cromwell",
"6492839", "Whangarei",
"643247", "Tokanui\/Lumsden\/Te\ Anau",
"6477883", "Hamilton",
"6469249", "Masterton",
"6432625", "Twizel",
"643243", "Tokanui\/Lumsden\/Te\ Anau",
"6492834", "Kawakawa",
"6494312", "Warkworth",
"6468249", "Opunake",
"6478132", "Paeroa",
"6433918", "Fox\ Glacier",
"6439275", "Nelson",
"6432659", "Takaka",
"6439044", "Milton",
"6475614", "Thames",
"6432712", "Amberley",
"6439755", "Rangiora",
"6433910", "Nelson",
"6442820", "Wellington",
"6439729", "Fox\ Glacier",
"644777", "Wellington",
"6434293", "Haast",
"6463927", "Dannevirke",
"6499455", "Dargaville",
"6439724", "Blenheim",
"6469711", "New\ Plymouth",
"643982", "Christchurch",
"6475619", "Hamilton",
"6472457", "Rotorua",
"644393", "Paraparaumu",
"6499472", "Great\ Barrier\ Island",
"6463999", "Palmerston\ North",
"6496015", "Maungaturoto",
"6432633", "Otautau",
"647829", "Hamilton",
"6474441", "Waihi",
"6498881", "Hibiscus\ Coast",
"6463994", "Dannevirke",
"643756", "Hokitika",
"6436997", "Motueka",
"6472196", "Taupo",
"6439732", "Otautau",
"6439016", "Alexandra",
"6433954", "Lawrence",
"646211", "Napier",
"6433959", "Balclutha",
"6499065", "Helensville",
"6469201", "Ruatoria",
"6432618", "Culverden",
"6496518", "Kawakawa",
"6439001", "Christchurch",
"6434282", "Queenstown",
"6463942", "Masterton",
"6469570", "Palmerston\ North",
"6466995", "Opunake",
"6498858", "Kaikohe",
"6475603", "Hamilton",
"644908", "Paraparaumu",
"6432228", "Wanaka",
"643467", "Dunedin",
"6479712", "Te\ Awamutu",
"6436610", "Kaikoura",
"643246", "Tokanui",
"6472613", "Putaruru\/Tokoroa",
"6439313", "Te\ Anau",
"6437442", "Murchison",
"6477770", "Tauranga",
"6439457", "Winton",
"643463", "Palmerston",
"6472223", "Hamilton",
"6435674", "Milton",
"6493942", "Great\ Barrier\ Island",
"64429", "Paraparaumu",
"6432440", "Christchurch",
"646763", "Opunake",
"6496995", "Maungaturoto",
"646767", "New\ Plymouth\/Opunake\/Stratford",
"6473930", "Waihi",
"6435679", "Alexandra",
"6439067", "Franz\ Josef",
"6436654", "Tokanui",
"646590", "Palmerston\ North",
"6462412", "Gisborne",
"6436585", "Tokanui",
"6436625", "Rangiora",
"6436659", "Haast",
"6462800", "Palmerston\ North",
"6472609", "Whangamata",
"6495564", "Whangarei",
"6495569", "Maungaturoto",
"6468881", "Napier\/Hastings",
"6478076", "Te\ Awamutu",
"6478080", "Hamilton",
"6439338", "Queenstown",
"6466015", "Napier",
"647552", "Tauranga",
"6472604", "Hamilton",
"6462157", "Stratford",
"6468819", "Mokau",
"6439330", "Westport",
"6436633", "Geraldine",
"6432997", "Edendale",
"6447771", "Paraparaumu",
"6468814", "Dannevirke",
"6462808", "Napier\/Hastings",
"646954", "Palmerston\ North\ W100",
"6466554", "Hawera",
"6479291", "Hamilton",
"6466559", "Mokau",
"6466525", "Marton",
"64686", "Gisborne",
"6435545", "Gore",
"6439762", "Oamaru",
"6437485", "Te\ Anau",
"6469850", "Napier",
"643753", "Hokitika",
"6439341", "Fairlie",
"6436599", "Blenheim",
"6499462", "Whangarei",
"6432663", "Christchurch",
"6432448", "Dunedin",
"6436594", "Waimate",
"643757", "Hokitika\/Franz\ Josef\ Glacier\/Fox\ Glacier\/Haast",
"6462106", "Pahiatua",
"6477778", "Te\ Awamutu",
"6475826", "Hamilton",
"6436527", "Haast",
"6468803", "Gisborne",
"6436687", "Nelson",
"6466002", "Napier",
"6474657", "Thames",
"6436618", "Blenheim",
"64937", "Auckland",
"643436", "Kurow",
"64334", "Christchurch",
"6432429", "Timaru",
"6469318", "Levin",
"644280", "Wellington",
"6462105", "Taihape",
"647211", "Hamilton",
"6435546", "Greymouth",
"6437470", "Balclutha",
"6437486", "Tokanui",
"643925", "Christchurch",
"6432424", "Nelson",
"6497770", "Whangarei",
"6435558", "Waimate",
"6462411", "New\ Plymouth",
"64331", "Rangiora\/Amberley\/Culverden\/Darfield\/Cheviot\/Kaikoura",
"6439853", "Amberley",
"6468882", "Napier\/Hastings",
"6443", "Wellington",
"6465603", "Palmerston\ North",
"6475825", "Hamilton",
"649431", "Maungaturoto",
"6493930", "Whangarei",
"6465614", "Wanganui",
"6437441", "Motueka",
"646946", "Masterton",
"6443333", "Paraparaumu",
"6473927", "Te\ Kuiti",
"64363", "South\ Island",
"6479711", "Whangamata",
"6469893", "Ruatoria",
"6465619", "Masterton",
"646846", "Napier\ City",
"6466526", "Waiouru",
"6436509", "Waitangi\ \(Chatham\ Is\.\)",
"644550", "Wellington",
"6473999", "Taupo",
"6436504", "Cheviot",
"6473994", "Rotorua",
"6435690", "Motueka",
"64377", "South\ Island",
"649552", "Pukekohe",
"6436578", "Wanaka",
"6436586", "Edendale",
"6436626", "Akaroa",
"6499017", "Kaikohe",
"643451", "Queenstown",
"6435698", "Hokitika",
"6439342", "Geraldine",
"6498017", "Hibiscus\ Coast",
"6439761", "Kurow",
"644894", "Wellington",
"643595", "Christchurch",
"6499461", "Whangarei",
"647888", "Matamata",
"6478075", "Te\ Kuiti",
"6466016", "Napier",
"6435514", "Palmerston",
"6479249", "Huntly",
"646385", "Ohakune",
"647988", "Rotorua",
"6479244", "Tauranga",
"6435519", "Twizel",
"6432803", "Otautau",
"6466001", "Napier",
"6493938", "Auckland",
"6468997", "Napier",
"6439266", "Dunedin",
"6432814", "Mt\ Cook",
"643216", "Invercargill",
"6432819", "Christchurch",
"6435503", "Christchurch",
"643337", "Christchurch",
"64783", "Hamilton",
"6472627", "Rotorua",
"6497778", "Pukekohe",
"6479292", "Hamilton",
"6435550", "Fox\ Glacier",
"643977", "Christchurch",
"6437478", "Twizel",
"6439874", "Cromwell",
"6439879", "Christchurch\/Blenheim\/Nelson",
"64737", "Taupo",
"64793", "Tauranga",
"6469310", "Wanganui",
"6439327", "Ashburton",
"6496996", "Warkworth",
"6499066", "Helensville",
"647920", "Rotorua",
"6479850", "Tokoroa",
"6432743", "Kurow",
"6439707", "Takaka",
"647820", "Hamilton\/Huntly",
"6439015", "Wanaka",
"643480", "Dunedin\/Lawrence\/Mosgiel",
"6463904", "Napier",
"6439533", "Geraldine",
"6436568", "Roxburgh",
"646843", "Napier\/Hastings",
"6467778", "Wairoa",
"6478131", "Otorohanga",
"6448880", "Paraparaumu",
"643288", "Christchurch",
"6466996", "Stratford",
"646847", "Napier\/Hastings",
"6469017", "Marton",
"6439020", "Gore",
"647871", "Te\ Awamutu",
"6439756", "Akaroa",
"6439288", "Ashburton",
"6439748", "Dunedin",
"6472822", "Rotorua",
"644202", "Wellington",
"6499456", "Kaikohe",
"6478140", "Rotorua",
"6496016", "Warkworth",
"649394", "Auckland",
"6463913", "Hawera",
"6472808", "Putaruru\/Tokoroa",
"649408", "Kaitaia",
"6472195", "Rotorua",
"64796", "Hamilton",
"6469610", "Wanganui",
"6469291", "Gisborne",
"6437460", "Waitangi\ \(Chatham\ Is\.\)",
"6439091", "Rangiora",
"643521", "Nelson",
"6469202", "Levin",
"643336", "Christchurch",
"647590", "Hamilton",
"6439864", "Takaka",
"649422", "Warkworth",
"6493208", "Helensville",
"6439002", "Rangiora",
"6437468", "Wanaka",
"64947", "Auckland",
"6469618", "Wanganui\/New\ Plymouth",
"6439869", "Blenheim",
"6432757", "Lumsden",
"6472800", "Thames",
"6462609", "Pahiatua",
"6432626", "Kurow",
"6439740", "Christchurch",
"6439280", "Nelson",
"6439276", "Nelson",
"643213", "Invercargill",
"643217", "Invercargill",
"6439028", "Edendale",
"6463941", "Masterton",
"6434281", "Queenstown",
"6462604", "Ohakune",
"643654", "Timaru",
"6469712", "New\ Plymouth",
"6435886", "Invercargill",
"6499", "Auckland",
"6462613", "Waipukurau",
"6432711", "Akaroa",
"6472143", "Morrinsville",
"6479107", "Whakatane",
"6442125", "Paraparaumu",
"6467770", "Gisborne",
"6498", "Auckland",
"6439525", "Milton",
"6498882", "Whangarei",
"6436560", "Palmerston",
"6474442", "Morrinsville",
"6462223", "Palmerston\ North",
"6434246", "Waitangi\ \(Chatham\ Is\.\)",
"6439731", "Gore",
"6479846", "Taumarunui",
"6479858", "Whakatane",
"6499471", "Hibiscus\ Coast",
"6432617", "Cheviot",
"644203", "Wellington",
"6469286", "Dannevirke",
"6469270", "Marton",
"6439070", "Motueka",
"6462620", "New\ Plymouth",
"6496517", "Kaitaia",
"6477886", "Rotorua",
"6478990", "Thames",
"6432227", "Queenstown",
"6495531", "Helensville",
"6472829", "Tauranga",
"6498857", "Dargaville",
"643445", "Cromwell",
"6432651", "Queenstown",
"6439523", "Balclutha",
"649399", "Auckland",
"6468241", "Gisborne",
"6472458", "Rotorua",
"6472145", "Huntly",
"6433980", "Milton",
"6469241", "Napier",
"6462615", "Gisborne",
"6492831", "Maungaturoto",
"643930", "Christchurch",
"6439041", "Ashburton",
"6463928", "Pahiatua",
"6435661", "Fairlie",
"6463902", "Gisborne",
"6499811", "Hibiscus\ Coast",
"6436998", "Blenheim",
"6437776", "Cromwell",
"643749", "Christchurch",
"646842", "Napier\/Hastings",
"6462225", "Levin",
"643948", "Invercargill",
"6439535", "Fairlie",
"6498900", "Pukekohe",
"6474449", "Opotiki",
"6439013", "Ashburton",
"6463991", "Masterton",
"6474444", "Hamilton",
"6436990", "Cheviot",
"6432745", "Roxburgh",
"6475611", "Taumarunui",
"6463920", "Palmerston\ North",
"6433917", "Franz\ Josef",
"6492807", "Helensville",
"6469714", "Hawera",
"6433988", "Wanaka",
"6439721", "Blenheim",
"6475606", "Matamata",
"6499421", "Hibiscus\ Coast",
"6434296", "Greymouth",
"647865", "Whangamata",
"6424", "Scott\ Base",
"6462602", "Palmerston\ North",
"643235", "Invercargill",
"649427", "Hibiscus\ Coast",
"6469577", "Ohakune",
"64938", "Auckland\/Waiheke\ Island",
"649423", "Warkworth",
"6478998", "Hamilton",
"647390", "Hamilton",
"6439009", "Greymouth",
"6433951", "Timaru",
"6479422", "Tauranga",
"6472193", "Whakatane",
"643212", "Invercargill",
"6499100", "Pukekohe",
"6439078", "Ashburton",
"6462628", "Wanganui",
"6439004", "Gore",
"6439862", "Nelson",
"6432636", "Te\ Anau",
"6469278", "Gisborne",
"6463915", "Opunake",
"6435671", "Oamaru",
"6436502", "Amberley",
"6432447", "Timaru",
"6473992", "Opotiki",
"64638", "Taihape\/Ohakune\/Waiouru",
"646950", "Palmerston\ North\/New\ Plymouth",
"6442608", "Paraparaumu",
"6436617", "Cromwell",
"644245", "Wellington",
"6474658", "Waihi",
"6432805", "Winton",
"6439450", "Invercargill",
"6477777", "Hamilton",
"6465612", "Waipukurau",
"6478073", "Putaruru\/Tokoroa",
"6436688", "Waitangi\ \(Chatham\ Is\.\)",
"6436528", "Westport",
"6472616", "Taumarunui",
"6445", "Wellington\/Hutt\ Valley",
"6435505", "Akaroa",
"6473949", "Taupo",
"6468889", "Levin",
"6495561", "Whangarei",
"6432998", "Tokanui",
"6473944", "Tauranga",
"6479018", "Putaruru\/Tokoroa",
"6462158", "Opunake",
"6493991", "Pukekohe",
"6468884", "Palmerston\ North",
"6439316", "Edendale",
"6472601", "Hamilton",
"647812", "Hamilton",
"6436651", "Riverton",
"6434353", "Twizel",
"6432422", "Tokanui\/Lumsden\/Te\ Anau",
"6439060", "Greymouth",
"6472226", "Te\ Kuiti",
"6499719", "Whangarei",
"6468260", "Featherston",
"6462807", "Napier\/Hastings",
"6432666", "South\ Island",
"6468268", "New\ Plymouth",
"6466551", "New\ Plymouth",
"6479299", "Rotorua",
"6479294", "Hamilton",
"6462103", "Levin",
"6439068", "Fox\ Glacier",
"64757", "Tauranga",
"6439872", "Alexandra",
"643332", "Christchurch",
"6439337", "Wanaka",
"6475823", "Hamilton",
"6468806", "New\ Plymouth",
"6462150", "New\ Plymouth",
"649426", "Hibiscus\ Coast",
"6479010", "Thames",
"6465605", "Marton",
"6432990", "Lumsden",
"6492225", "Pukekohe",
"6468811", "Marton",
"6432812", "Haast",
"6439855", "Rangiora",
"6436680", "Akaroa",
"6436520", "Greymouth",
"6479242", "Rotorua",
"6499746", "Kawakawa",
"6439458", "Edendale",
"644819", "Wellington",
"6474650", "Morrinsville",
"6436636", "Waimate",
"6435512", "Rangiora",
"6439344", "Timaru",
"6462114", "Waipukurau",
"6479025", "Huntly",
"6436591", "Nelson",
"6439349", "South\ Island",
"6462119", "Wairoa",};
my $timezones = {
               '' => [
                       'Pacific/Auckland',
                       'Pacific/Chatham'
                     ],
               '1' => [
                        'Pacific/Auckland'
                      ],
               '2' => [
                        'Pacific/Auckland'
                      ],
               '3' => [
                        'Pacific/Auckland'
                      ],
               '330' => [
                          'Pacific/Chatham'
                        ],
               '4' => [
                        'Pacific/Auckland'
                      ],
               '5' => [
                        'Pacific/Auckland'
                      ],
               '6' => [
                        'Pacific/Auckland'
                      ],
               '7' => [
                        'Pacific/Auckland'
                      ],
               '8' => [
                        'Pacific/Auckland'
                      ],
               '9' => [
                        'Pacific/Auckland'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+64|\D)//g;
      my $self = bless({ country_code => '64', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '64', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;