# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::BR;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230903131444;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              1[25-8]|
              2[357-9]|
              3[02-68]|
              4[12568]|
              5|
              6[0-8]|
              8[015]|
              9[0-47-9]
            )|
            321|
            610
          ',
                  'pattern' => '(\\d{3,6})'
                },
                {
                  'format' => '$1-$2',
                  'leading_digits' => '
            4(?:
              02|
              37
            )0|
            [34]00
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            [2357]|
            4(?:
              [0-24-9]|
              3(?:
                [0-689]|
                7[1-9]
              )
            )
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              [358]|
              90
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2,3})(\\d{4})'
                },
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '9',
                  'pattern' => '(\\d{5})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3',
                  'leading_digits' => '
            (?:
              [14689][1-9]|
              2[12478]|
              3[1-578]|
              5[13-5]|
              7[13-579]
            )[2-57]
          ',
                  'national_rule' => '($1)',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3',
                  'leading_digits' => '
            [16][1-9]|
            [2-57-9]
          ',
                  'national_rule' => '($1)',
                  'pattern' => '(\\d{2})(\\d{5})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )[2-5]\\d{7}
        ',
                'geographic' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )[2-5]\\d{7}
        ',
                'mobile' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )(?:
            7|
            9\\d
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          (?:
            30[03]\\d{3}|
            4(?:
              0(?:
                0\\d|
                20
              )|
              370
            )
          )\\d{4}|
          300\\d{5}
        )|(
          300\\d{6}|
          [59]00\\d{6,7}
        )',
                'toll_free' => '800\\d{6,7}',
                'voip' => ''
              };
my %areanames = ();
$areanames{pt} = {"5561", "Distrito\ Federal",};
$areanames{en} = {"5568", "Acre",
"55333238", "São\ Geraldo\ da\ Piedade\ \-\ MG",
"55112350", "Poá\ \-\ SP",
"55143296", "Arealva\ \-\ SP",
"55323745", "Caiana\ \-\ MG",
"55354102", "Pouso\ Alegre\ \-\ MG",
"55813683", "Maraial\ \-\ PE",
"55473364", "Dona\ Emma\ \-\ SC",
"55383747", "Paredão\ de\ Minas\ \-\ MG",
"55163041", "Sertãozinho\ \-\ SP",
"55322102", "Juiz\ de\ Fora\ \-\ MG",
"55933527", "Santarém\ \-\ PA",
"55614001", "Brasília\ \-\ DF",
"55433618", "Ibaiti\ \-\ PR",
"55672108", "Dourados\ \-\ MS",
"55713379", "Lauro\ de\ Freitas\ \-\ BA",
"55813741", "Toritama\ \-\ PE",
"55383253", "Engenheiro\ Navarro\ \-\ MG",
"55753286", "Coronel\ João\ Sá\ \-\ BA",
"55443535", "Jesuítas\ \-\ PR",
"55624103", "Aparecida\ de\ Goiânia\ \-\ GO",
"55613108", "Brasília\ \-\ DF",
"55613632", "Formosa\ \-\ GO",
"55413677", "Campo\ Magro\ \-\ PR",
"55113435", "Guarulhos\ \-\ SP",
"55843381", "Alexandria\ \-\ RN",
"55883686", "Catunda\ \-\ CE",
"55513515", "Porto\ Alegre\ \-\ RS",
"55515", "Rio\ Grande\ do\ Sul",
"55133828", "Registro\ \-\ SP",
"55193893", "Pedreira\ \-\ SP",
"55474062", "Joinville\ \-\ SC",
"55644141", "Itumbiara\ \-\ GO",
"55943324", "Marabá\ \-\ PA",
"55893495", "Queimada\ Nova\ \-\ PI",
"55993317", "Timon\ \-\ MA",
"55873787", "Paranatama\ \-\ PE",
"55313956", "Contagem\ \-\ MG",
"55823420", "Palmeira\ dos\ Índios\ \-\ AL",
"55683262", "Vila\ do\ V\ \-\ AC",
"55312591", "Betim\ \-\ MG",
"55793277", "Carmópolis\ \-\ SE",
"55733296", "Medeiros\ Neto\ \-\ BA",
"55832106", "João\ Pessoa\ \-\ PB",
"55973451", "Boca\ do\ Acre\ \-\ AM",
"55883561", "Icó\ \-\ CE",
"55143731", "Avaré\ \-\ SP",
"55893454", "Fronteiras\ \-\ PI",
"55183708", "Primeira\ Aliança\ \-\ SP",
"55623325", "Rubiataba\ \-\ GO",
"55133491", "Praia\ Grande\ \-\ SP",
"55183274", "Teçaindá\ \-\ SP",
"55333755", "Águas\ Vermelhas\ \-\ MG",
"55623534", "Goiânia\ \-\ GO",
"55313889", "Belo\ Horizonte\ \-\ MG",
"55823298", "Porto\ de\ Pedras\ \-\ AL",
"55683327", "Assis\ Brasil\ \(Vila\)\ \-\ AC",
"55433527", "Jacarezinho\ \-\ PR",
"55433437", "Novo\ Itacolomi\ \-\ PR",
"55753248", "Coração\ de\ Maria\ \-\ BA",
"55115641", "São\ Paulo\ \-\ SP",
"55353741", "Botelhos\ \-\ MG",
"55823266", "Satuba\ \-\ AL",
"55213434", "Rio\ de\ Janeiro\ \-\ RJ",
"55493253", "São\ Cristovão\ do\ Sul\ \-\ SC",
"55114032", "Bragança\ Paulista\ \-\ SP",
"55843613", "Natal\ \-\ RN",
"55312564", "Contagem\ \-\ MG",
"55633472", "Araguacema\ \-\ TO",
"55513440", "Rio\ Grande\ do\ Sul",
"55823557", "Piaçabuçu\ \-\ AL",
"55114573", "Cotia\ \-\ SP",
"55143303", "Marília\ \-\ SP",
"5533", "Minas\ Gerais",
"55353833", "Candeias\ \-\ MG",
"55643901", "Itumbiara\ \-\ GO",
"55883555", "Jardim\ \-\ CE",
"55733268", "Porto\ Seguro\ \-\ BA",
"55823530", "Arapiraca\ \-\ AL",
"55113601", "Osasco\ \-\ SP",
"55433066", "Londrina\ \-\ PR",
"55814102", "Recife\ \-\ PE",
"55853403", "Fortaleza\ \-\ CE",
"55413721", "Paranaguá\ \-\ PR",
"55114096", "São\ Paulo\ \-\ SP",
"5581322", "Recife\ \-\ PE",
"55973391", "Tapauá\ \-\ AM",
"55813311", "Ipojuca\ \-\ PE",
"55313026", "Sete\ Lagoas\ \-\ MG",
"55643086", "Itumbiara\ \-\ GO",
"55473674", "São\ Miguel\ da\ Serra\ \-\ SC",
"55333262", "Goiabeira\ \-\ MG",
"55773682", "Iuiú\ \-\ BA",
"55112228", "Santo\ André\ \-\ SP",
"55543478", "Vista\ Alegre\ do\ Prata\ \-\ RS",
"55923877", "Manaus\ \-\ AM",
"55743675", "São\ José\ do\ Jacuípe\ \-\ BA",
"55443425", "Loanda\ \-\ PR",
"55913721", "Castanhal\ \-\ PA",
"55173579", "Botelho\ \-\ SP",
"55333327", "Ipaba\ \-\ MG",
"55653321", "Cuiabá\ \-\ MT",
"55353242", "Turvolândia\ \-\ MG",
"55833547", "Vieirópolis\ \-\ PB",
"55883648", "Uruoca\ \-\ CE",
"55713669", "Palmares\ \-\ BA",
"55112490", "Bragança\ Paulista\ \-\ SP",
"55473465", "Joinville\ \-\ SC",
"55343819", "Monte\ Carmelo\ \-\ MG",
"55143268", "Macatuba\ \-\ SP",
"55623593", "Goiânia\ \-\ GO",
"55353536", "Itaú\ de\ Minas\ \-\ MG",
"55863282", "Água\ Branca\ \-\ PI",
"55663581", "Castanheira\ \-\ MT",
"55883423", "Limoeiro\ do\ Norte\ \-\ CE",
"55193684", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55333733", "Itinga\ \-\ MG",
"55183368", "Lutécia\ \-\ SP",
"55513617", "Rio\ Grande\ do\ Sul",
"55273382", "Vitória\ \-\ ES",
"55353861", "Nepomuceno\ \-\ MG",
"55193834", "Indaiatuba\ \-\ SP",
"55433625", "Cafeara\ \-\ PR",
"5585345", "Fortaleza\ \-\ CE",
"55443123", "Maringá\ \-\ PR",
"55753644", "Queimadas\ \-\ BA",
"55383758", "Augusto\ de\ Lima\ \-\ MG",
"55833297", "Mataraca\ \-\ PB",
"55313665", "Pedro\ Leopoldo\ \-\ MG",
"55513462", "Canoas\ \-\ RS",
"55683301", "Rio\ Branco\ \-\ AC",
"55613264", "Brasília\ \-\ DF",
"55143664", "Itapuí\ \-\ SP",
"55623010", "Senador\ Canedo\ \-\ GO",
"55333582", "São\ José\ do\ Divino\ \-\ MG",
"55423617", "Santa\ Maria\ do\ Oeste\ \-\ PR",
"55443553", "Janiópolis\ \-\ PR",
"55853375", "Pindoretama\ \-\ CE",
"55923528", "Silves\ \-\ AM",
"55443569", "Juranda\ \-\ PR",
"55383235", "Capitão\ Enéas\ \-\ MG",
"55114911", "São\ Paulo\ \-\ SP",
"55513097", "Novo\ Hamburgo\ \-\ RS",
"55173482", "Auriflama\ \-\ SP",
"55323250", "Juiz\ de\ Fora\ \-\ MG",
"55413575", "Curitiba\ \-\ PR",
"55163604", "Ribeirão\ Preto\ \-\ SP",
"55283522", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55142107", "Bauru\ \-\ SP",
"55173624", "Jales\ \-\ SP",
"55443637", "Cianorte\ \-\ PR",
"55513279", "Rio\ Grande\ do\ Sul",
"55143475", "Ocauçu\ \-\ SP",
"55374101", "Itaúna\ \-\ MG",
"55212186", "Nilópolis\ \-\ RJ",
"55643672", "Mineiros\ \-\ GO",
"55613964", "Brasília\ \-\ DF",
"55453273", "Toledo\ \-\ PR",
"55483443", "Criciúma\ \-\ SC",
"55543251", "Cambará\ do\ Sul\ \-\ RS",
"55813861", "Petrolina\ \-\ PE",
"55513438", "Cachoeirinha\ \-\ RS",
"55663544", "Sorriso\ \-\ MT",
"55143104", "Bauru\ \-\ SP",
"55733011", "Teixeira\ de\ Freitas\ \-\ BA",
"55143374", "Caporanga\ \-\ SP",
"5531345", "Belo\ Horizonte\ \-\ MG",
"55753230", "Antônio\ Cardoso\ \-\ BA",
"55733546", "Nova\ Itarana\ \-\ BA",
"55213917", "Maricá\ \-\ RJ",
"55663302", "Rondonópolis\ \-\ MT",
"55373241", "Itaúna\ \-\ MG",
"55193641", "Vargem\ Grande\ do\ Sul\ \-\ SP",
"55713635", "Mata\ de\ São\ João\ \-\ BA",
"55453336", "Luz\ Marina\ \-\ PR",
"55843034", "Natal\ \-\ RN",
"55913446", "São\ Miguel\ do\ Guamá\ \-\ PA",
"55753257", "Bessa\ \-\ BA",
"55913817", "Nova\ Esperança\ do\ Piriá\ \-\ PA",
"55983224", "São\ José\ de\ Ribamar\ \-\ MA",
"55113393", "São\ Paulo\ \-\ SP",
"55115111", "São\ Paulo\ \-\ SP",
"55813536", "Pombos\ \-\ PE",
"55753681", "Cabaceiras\ do\ Paraguaçu\ \-\ BA",
"55883657", "Quiterianópolis\ \-\ CE",
"55833558", "Cachoeira\ dos\ Índios\ \-\ PB",
"5575348", "Feira\ de\ Santana\ \-\ BA",
"55343353", "Conquista\ \-\ MG",
"55423438", "Guamiranga\ \-\ PR",
"55113133", "São\ Paulo\ \-\ SP",
"55143546", "Sabino\ \-\ SP",
"55463520", "Francisco\ Beltrão\ \-\ PR",
"5519344", "Limeira\ \-\ SP",
"55883533", "Campos\ Sales\ \-\ CE",
"55373329", "Formiga\ \-\ MG",
"55883630", "Miraíma\ \-\ CE",
"55433878", "Londrina\ \-\ PR",
"55353855", "Coqueiral\ \-\ MG",
"55493235", "Painel\ \-\ SC",
"55313375", "Belo\ Horizonte\ \-\ MG",
"55313651", "Caeté\ \-\ MG",
"55113518", "São\ Paulo\ \-\ SP",
"55353426", "Senador\ José\ Bento\ \-\ MG",
"55643612", "Rio\ Verde\ \-\ GO",
"55312102", "Belo\ Horizonte\ \-\ MG",
"55493551", "Joaçaba\ \-\ SC",
"55833473", "Desterro\ \-\ PB",
"55663559", "Novo\ Horizonte\ do\ Norte\ \-\ MT",
"55143415", "Marília\ \-\ SP",
"55663563", "Paranaíta\ \-\ MT",
"55483464", "Lauro\ Muller\ \-\ SC",
"55333246", "Mendes\ Pimentel\ \-\ MG",
"55813734", "Vertentes\ \-\ PE",
"55614103", "Brasília\ \-\ DF",
"55853315", "São\ Gonçalo\ do\ Amarante\ \-\ CE",
"55163143", "Restinga\ \-\ SP",
"55423677", "Pinhão\ \-\ PR",
"55623378", "Itauçu\ \-\ GO",
"55193938", "Indaiatuba\ \-\ SP",
"55213484", "Rio\ de\ Janeiro\ \-\ RJ",
"55353266", "Três\ Pontas\ \-\ MG",
"55114706", "Barueri\ \-\ SP",
"55833252", "João\ Pessoa\ \-\ PB",
"55114082", "São\ Paulo\ \-\ SP",
"55423219", "Ponta\ Grossa\ \-\ PR",
"55443656", "Alto\ Piquiri\ \-\ PR",
"55353409", "Lavras\ \-\ MG",
"55623541", "Goiânia\ \-\ GO",
"55623016", "Aparecida\ de\ Goiânia\ \-\ GO",
"55983351", "Viana\ \-\ MA",
"55513052", "Canoas\ \-\ RS",
"55153521", "Itapeva\ \-\ SP",
"55513677", "Dom\ Feliciano\ \-\ RS",
"55983464", "Miranda\ do\ Norte\ \-\ MA",
"55993551", "São\ João\ dos\ Patos\ \-\ MA",
"55193794", "Campinas\ \-\ SP",
"55313414", "Minas\ Gerais",
"55114816", "Jundiaí\ \-\ SP",
"55113384", "São\ Paulo\ \-\ SP",
"55543535", "Caxias\ do\ Sul\ \-\ RS",
"55114772", "Jandira\ \-\ SP",
"55663407", "Barra\ do\ Garças\ \-\ MT",
"55323256", "Aracitaba\ \-\ MG",
"55543324", "Ibirubá\ \-\ RS",
"55143282", "Duartina\ \-\ SP",
"55643629", "Montividiu\ \-\ GO",
"55113578", "São\ Paulo\ \-\ SP",
"5543302", "Londrina\ \-\ PR",
"55843331", "Açu\ \-\ RN",
"55923367", "Iranduba\ \-\ AM",
"55733540", "Presidente\ Tancredo\ Neves\ \-\ BA",
"55483049", "São\ José\ \-\ SC",
"55753236", "Santa\ Bárbara\ \-\ BA",
"55173275", "Monte\ Aprazível\ \-\ SP",
"55743628", "Piritiba\ \-\ BA",
"55453038", "Cascavel\ \-\ PR",
"55873852", "Betânia\ \-\ PE",
"55993565", "Formosa\ da\ Serra\ Negra\ \-\ MA",
"55464054", "Francisco\ Beltrão\ \-\ PR",
"55673669", "Paranaíba\ \-\ MS",
"55153431", "Itararé\ \-\ SP",
"55323026", "Juiz\ de\ Fora\ \-\ MG",
"55823311", "Maceió\ \-\ AL",
"55753659", "Salinas\ da\ Margarida\ \-\ BA",
"55773668", "Sebastião\ Laranjeiras\ \-\ BA",
"55123601", "Taubaté\ \-\ SP",
"55193761", "Campinas\ \-\ SP",
"55115634", "São\ Paulo\ \-\ SP",
"55824102", "Centro\ \-\ AL",
"55353734", "Santa\ Rita\ de\ Caldas\ \-\ MG",
"55813633", "Nazaré\ da\ Mata\ \-\ PE",
"55463526", "Itapejara\ D\'Oeste\ \-\ PR",
"55242102", "Volta\ Redonda\ \-\ RJ",
"55313839", "Itabira\ \-\ MG",
"55353298", "Machado\ \-\ MG",
"55883692", "Crateús\ \-\ CE",
"55433274", "Arapongas\ \-\ PR",
"55483491", "Orleans\ \-\ SC",
"55733282", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55553511", "Santa\ Rosa\ \-\ RS",
"55623584", "Aparecida\ de\ Goiânia\ \-\ GO",
"55862107", "Teresina\ \-\ PI",
"55512131", "Porto\ Alegre\ \-\ RS",
"55513721", "Triunfo\ \-\ RS",
"55213977", "Rio\ de\ Janeiro\ \-\ RJ",
"55843604", "Parnamirim\ \-\ RN",
"55883636", "Amontada\ \-\ CE",
"55213099", "Teresópolis\ \-\ RJ",
"55813127", "Recife\ \-\ PE",
"55714117", "Simões\ Filho\ \-\ BA",
"5583333", "Campina\ Grande\ \-\ PB",
"55114162", "Barueri\ \-\ SP",
"55463905", "Francisco\ Beltrão\ \-\ PR",
"55753631", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55813661", "Palmares\ \-\ PE",
"55843084", "Natal\ \-\ RN",
"55373543", "Quartel\ Geral\ \-\ MG",
"55193841", "Mogi\-Guaçu\ \-\ SP",
"55153459", "Iperó\ \-\ SP",
"55382104", "Montes\ Claros\ \-\ MG",
"55863303", "Teresina\ \-\ PI",
"55653254", "Indiavaí\ \-\ MT",
"55413462", "Morretes\ \-\ PR",
"55853328", "Mulungu\ \-\ CE",
"55923575", "Itapiranga\ \-\ AM",
"55173522", "Catanduva\ \-\ SP",
"55913617", "Cotijuba\ \-\ PA",
"55793217", "Aracaju\ \-\ SE",
"55843359", "Água\ Nova\ \-\ RN",
"55513488", "Gravataí\ \-\ RS",
"55843363", "Rafael\ Godeiro\ \-\ RN",
"55163344", "Ribeirão\ Bonito\ \-\ SP",
"55513575", "São\ Leopoldo\ \-\ RS",
"55913528", "Novo\ Progresso\ \-\ PA",
"55413158", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55663421", "Rondonópolis\ \-\ MT",
"55733290", "Ibirapuã\ \-\ BA",
"55823426", "Estrela\ de\ Alagoas\ \-\ AL",
"55112152", "Jundiaí\ \-\ SP",
"55883583", "Mombaça\ \-\ CE",
"55123972", "Santa\ Branca\ \-\ SP",
"55613010", "Brasília\ \-\ DF",
"55313237", "Belo\ Horizonte\ \-\ MG",
"55193582", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55633377", "Aliança\ do\ Tocantins\ \-\ TO",
"55353655", "Sapucaí\-Mirim\ \-\ MG",
"55113183", "Itatiba\ \-\ SP",
"55353371", "Passa\ Quatro\ \-\ MG",
"55633429", "Muricilândia\ \-\ TO",
"55913462", "Capanema\ \-\ PA",
"55353694", "Lavras\ \-\ MG",
"5581346", "Recife\ \-\ PE",
"55313851", "João\ Monlevade\ \-\ MG",
"55243328", "Barra\ Mansa\ \-\ RJ",
"55133224", "Santos\ \-\ SP",
"55473343", "Ilhota\ \-\ SC",
"55633539", "Lizarda\ \-\ TO",
"55273332", "Vitória\ \-\ ES",
"55513446", "Viamão\ \-\ RS",
"55183625", "Araçatuba\ \-\ SP",
"55873945", "Serra\ Talhada\ \-\ PE",
"55493667", "São\ Miguel\ da\ Boa\ Vista\ \-\ SC",
"55823260", "Marechal\ Deodoro\ \-\ AL",
"55193884", "Paulínia\ \-\ SP",
"55733538", "Itiruçu\ \-\ BA",
"55373234", "São\ Gonçalo\ do\ Pará\ \-\ MG",
"55313865", "Coronel\ Fabriciano\ \-\ MG",
"55433456", "Apucarana\ \-\ PR",
"55493539", "Iomerê\ \-\ SC",
"55663531", "Sinop\ \-\ MT",
"55823536", "Traipu\ \-\ AL",
"55313328", "Minas\ Gerais",
"55813548", "Itapissuma\ \-\ PE",
"55123133", "Guaratinguetá\ \-\ SP",
"55213726", "Teresópolis\ \-\ RJ",
"55193301", "Piracicaba\ \-\ SP",
"55443687", "Maripá\ \-\ PR",
"55114602", "Salto\ \-\ SP",
"55813655", "São\ Vicente\ Ferrer\ \-\ PE",
"55114138", "Taboão\ da\ Serra\ \-\ SP",
"55553336", "Catuípe\ \-\ RS",
"55212136", "Rio\ de\ Janeiro\ \-\ RJ",
"55813101", "Caruaru\ \-\ PE",
"55993539", "Vila\ Nova\ dos\ Martírios\ \-\ MA",
"55115693", "São\ Paulo\ \-\ SP",
"55273136", "Cariacica\ \-\ ES",
"55872101", "Petrolina\ \-\ PE",
"55513707", "Lajeado\ \-\ RS",
"55443251", "Sabáudia\ \-\ PR",
"55423446", "Prudentópolis\ \-\ PR",
"55893449", "Santo\ Antônio\ de\ Lisboa\ \-\ PI",
"55823003", "Maceió\ \-\ AL",
"55323375", "Conceição\ da\ Barra\ de\ Minas\ \-\ MG",
"55793045", "Aracaju\ \-\ SE",
"55973343", "Tefé\ \-\ AM",
"55473055", "Jaraguá\ do\ Sul\ \-\ SC",
"55114513", "Mauá\ \-\ SP",
"55843673", "Natal\ \-\ RN",
"55333532", "Itaipé\ \-\ MG",
"55713267", "Salvador\ \-\ BA",
"55483199", "Tubarão\ \-\ SC",
"55993667", "Governador\ Archer\ \-\ MA",
"55323287", "Senador\ Cortes\ \-\ MG",
"55373353", "Iguatama\ \-\ MG",
"55222009", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55513783", "Esteio\ \-\ RS",
"55423532", "São\ Mateus\ do\ Sul\ \-\ PR",
"55313878", "Contagem\ \-\ MG",
"55353466", "Munhoz\ \-\ MG",
"55543343", "Sananduva\ \-\ RS",
"55173546", "Itajobi\ \-\ SP",
"55833452", "Piancó\ \-\ PB",
"55173011", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55113412", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55543614", "Rio\ dos\ Índios\ \-\ RS",
"55313382", "Minas\ Gerais",
"55833273", "Alagoa\ Grande\ \-\ PB",
"55212665", "Queimados\ \-\ RJ",
"55883085", "Juazeiro\ do\ Norte\ \-\ CE",
"55473418", "Joinville\ \-\ SC",
"55213116", "Rio\ de\ Janeiro\ \-\ RJ",
"55483264", "Canelinha\ \-\ SC",
"55693651", "Costa\ Marques\ \-\ RO",
"55463560", "Pinhal\ de\ São\ Bento\ \-\ PR",
"55183851", "Tupi\ Paulista\ \-\ SP",
"55983264", "São\ Luís\ \-\ MA",
"5511467", "Ferraz\ de\ Vasconcelos\ \-\ SP",
"55753526", "Maragogipe\ \-\ BA",
"55413634", "São\ José\ dos\ Pinhais\ \-\ PR",
"55283538", "Atilio\ Vivacqua\ \-\ ES",
"55114247", "Barueri\ \-\ SP",
"55673227", "Anhanduí\ \-\ MS",
"55343241", "Araguari\ \-\ MG",
"55613389", "Planaltina\ \-\ DF",
"55173691", "Três\ Fronteiras\ \-\ SP",
"55813821", "Recife\ \-\ PE",
"55513596", "Novo\ Hamburgo\ \-\ RS",
"55543055", "Bento\ Gonçalves\ \-\ RS",
"55643556", "Paraúna\ \-\ GO",
"55613054", "Brasília\ \-\ DF",
"55733215", "Itabuna\ \-\ BA",
"55853382", "Maracanaú\ \-\ CE",
"55323332", "Barbacena\ \-\ MG",
"55173664", "Aspásia\ \-\ SP",
"55913733", "Murucupi\ \-\ PA",
"5511436", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55283562", "Bom\ Jesus\ do\ Norte\ \-\ ES",
"55793543", "Indiaroba\ \-\ SE",
"55112664", "Barueri\ \-\ SP",
"55114015", "Tuiuti\ \-\ SP",
"55513568", "São\ Leopoldo\ \-\ RS",
"55113429", "São\ Paulo\ \-\ SP",
"55513684", "Tramandaí\ \-\ RS",
"55513422", "Barro\ Vermelho\ \-\ RS",
"55193617", "Rio\ Claro\ \-\ SP",
"55643685", "Ivolândia\ \-\ GO",
"55443278", "Ourizona\ \-\ PR",
"55113377", "São\ Paulo\ \-\ SP",
"55443529", "Campo\ Mourão\ \-\ PR",
"55753436", "Olindina\ \-\ BA",
"55413582", "Curitiba\ \-\ PR",
"55223234", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55173475", "Meridiano\ \-\ SP",
"55733047", "Jequié\ \-\ BA",
"55873873", "Araripina\ \-\ PE",
"55673672", "Rio\ Brilhante\ \-\ MS",
"55612030", "Brasília\ \-\ DF",
"55114654", "Arujá\ \-\ SP",
"55353821", "Lavras\ \-\ MG",
"55794003", "Aracaju\ \-\ SE",
"55693474", "Castanheiras\ \-\ RO",
"5512390", "São\ José\ dos\ Campos\ \-\ SP",
"55343284", "Araporã\ \-\ MG",
"55114695", "Guararema\ \-\ SP",
"55313625", "Ribeirão\ das\ Neves\ \-\ MG",
"55553305", "Ijuí\ \-\ RS",
"55212651", "São\ João\ de\ Meriti\ \-\ RJ",
"55553739", "Taquaruçu\ do\ Sul\ \-\ RS",
"55423422", "Irati\ \-\ PR",
"55123867", "Maresias\ \-\ SP",
"5512320", "São\ José\ dos\ Campos\ \-\ SP",
"55163852", "Sales\ Oliveira\ \-\ SP",
"55273287", "Fundão\ \-\ ES",
"55823621", "Santana\ do\ Ipanema\ \-\ AL",
"55433474", "Grandes\ Rios\ \-\ PR",
"55833392", "Queimadas\ \-\ PB",
"55193979", "Monte\ Mor\ \-\ SP",
"55533237", "Povo\ Novo\ \-\ RS",
"55733624", "Jussari\ \-\ BA",
"55213742", "Nova\ Iguaçu\ \-\ RJ",
"55443674", "Indianópolis\ \-\ PR",
"55993578", "São\ Domingos\ do\ Maranhão\ \-\ MA",
"5591", "Pará",
"55513111", "Cachoeirinha\ \-\ RS",
"55653361", "Barra\ do\ Bugres\ \-\ MT",
"55543033", "Nova\ Petrópolis\ \-\ RS",
"55493341", "Jupiá\ \-\ SC",
"55513288", "Rio\ Grande\ do\ Sul",
"55613628", "Novo\ Gama\ \-\ GO",
"55114735", "Mogi\ das\ Cruzes\ \-\ SP",
"55773464", "Mortugaba\ \-\ BA",
"55113565", "São\ Caetano\ do\ Sul\ \-\ SP",
"55413590", "Piraquara\ \-\ PR",
"55443465", "Cruzeiro\ do\ Sul\ \-\ PR",
"55213760", "Nilópolis\ \-\ RJ",
"55153259", "Tatuí\ \-\ SP",
"55173268", "Onda\ Verde\ \-\ SP",
"55323274", "Rio\ Novo\ \-\ MG",
"55153263", "Boituva\ \-\ SP",
"55553252", "São\ Francisco\ de\ Assis\ \-\ RS",
"55983378", "Pedro\ do\ Rosário\ \-\ MA",
"55182102", "Araçatuba\ \-\ SP",
"55112303", "Guarulhos\ \-\ SP",
"55623351", "Campos\ Verdes\ \-\ GO",
"55652137", "Várzea\ Grande\ \-\ MT",
"55883431", "Itapiúna\ \-\ CE",
"55333721", "Almenara\ \-\ MG",
"55483378", "Santa\ Tereza\ \-\ SC",
"55183745", "Itapura\ \-\ SP",
"55193877", "Artur\ Nogueira\ \-\ SP",
"55163323", "Ribeirão\ Preto\ \-\ SP",
"55673901", "Campo\ Grande\ \-\ MS",
"55483632", "Tubarão\ \-\ SC",
"55553751", "Dois\ Irmãos\ das\ MissõEs\ \-\ RS",
"55312524", "Contagem\ \-\ MG",
"5541", "Paraná",
"55273256", "Aracruz\ \-\ ES",
"55833380", "Puxinanã\ \-\ PB",
"55373524", "Martinho\ Campos\ \-\ MG",
"55484001", "Florianópolis\ \-\ SC",
"55623464", "Água\ Fria\ de\ Goiás\ \-\ GO",
"55973425", "Jutaí\ \-\ AM",
"55613517", "Brasília\ \-\ DF",
"55833088", "Campina\ Grande\ \-\ PB",
"55373335", "Passa\ Tempo\ \-\ MG",
"55693026", "Porto\ Velho\ \-\ RO",
"55313437", "Minas\ Gerais",
"55183839", "Jamaica\ \-\ SP",
"55993212", "Timon\ \-\ MA",
"55713612", "Salvador\ \-\ BA",
"55173843", "Ouroeste\ \-\ SP",
"55373434", "Medeiros\ \-\ MG",
"55313527", "Minas\ Gerais",
"55623365", "Crixás\ \-\ GO",
"55114597", "Nazaré\ Paulista\ \-\ SP",
"55112843", "São\ Paulo\ \-\ SP",
"55162101", "Ribeirão\ Preto\ \-\ SP",
"55433256", "Rolândia\ \-\ PR",
"55433567", "Sengés\ \-\ PR",
"55483668", "Pinheiral\ \-\ SC",
"55114028", "Salto\ \-\ SP",
"55943364", "Vila\ Mandii\ \-\ PA",
"55213688", "Rio\ de\ Janeiro\ \-\ RJ",
"55633384", "Araguaçu\ \-\ TO",
"55123023", "Jacareí\ \-\ SP",
"55313390", "Minas\ Gerais",
"55883521", "Crato\ \-\ CE",
"55313130", "Matozinhos\ \-\ MG",
"55833511", "Patos\ \-\ PB",
"55163945", "Sertãozinho\ \-\ SP",
"55454007", "Cascavel\ \-\ PR",
"55473535", "Atalanta\ \-\ SC",
"55115097", "São\ Paulo\ \-\ SP",
"55463542", "Santa\ Izabel\ do\ Oeste\ \-\ PR",
"55843299", "Coronel\ Ezequiel\ \-\ RN",
"55913755", "Igarapé\-Miri\ \-\ PA",
"55773491", "São\ Félix\ do\ Coribe\ \-\ BA",
"55423246", "Caetano\ Mendes\ \-\ PR",
"55743534", "Pilão\ Arcado\ \-\ BA",
"55153533", "Bom\ Sucesso\ de\ Itararé\ \-\ SP",
"55613577", "Brasília\ \-\ DF",
"55653383", "Sapezal\ \-\ MT",
"55513634", "Bom\ Princípio\ \-\ RS",
"55143432", "Marília\ \-\ SP",
"55993627", "Bacabal\ \-\ MA",
"55213543", "Rio\ de\ Janeiro\ \-\ RJ",
"55473251", "Brusque\ \-\ SC",
"55383081", "Montes\ Claros\ \-\ MG",
"55413073", "Belo\ Horizonte\ \-\ MG",
"55543439", "Faria\ Lemos\ \-\ RS",
"55112864", "São\ Paulo\ \-\ SP",
"55643635", "Santa\ Rita\ do\ Araguaia\ \-\ GO",
"55193817", "Amparo\ \-\ SP",
"55143496", "Tupã\ \-\ SP",
"55213766", "Nova\ Iguaçu\ \-\ RJ",
"55443055", "Umuarama\ \-\ PR",
"55913783", "Breves\ \-\ PA",
"55853332", "Redenção\ \-\ CE",
"5535342", "Pouso\ Alegre\ \-\ MG",
"55423301", "Ponta\ Grossa\ \-\ PR",
"55222665", "Araruama\ \-\ RJ",
"55153281", "Araçoiaba\ da\ Serra\ \-\ SP",
"55443343", "Maringá\ \-\ PR",
"55353621", "Itajubá\ \-\ MG",
"55115721", "Mauá\ \-\ SP",
"55133291", "Santos\ \-\ SP",
"55313456", "Minas\ Gerais",
"55623389", "Goianésia\ \-\ GO",
"55243332", "Rio\ Claro\ \-\ RJ",
"55923301", "Manaus\ \-\ AM",
"55114895", "Nazaré\ Paulista\ \-\ SP",
"55283546", "Venda\ Nova\ do\ Imigrante\ \-\ ES",
"55433020", "Rolândia\ \-\ PR",
"55423634", "Campina\ do\ Simão\ \-\ PR",
"55273237", "Vitória\ \-\ ES",
"55514112", "Novo\ Hamburgo\ \-\ RS",
"55843245", "Vila\ Flor\ \-\ RN",
"55663455", "Santa\ Elvira\ \-\ MT",
"55193707", "Campinas\ \-\ SP",
"55683462", "Tarauacá\ \-\ AC",
"55833386", "Gurjão\ \-\ PB",
"55273250", "Coqueiral\ \-\ ES",
"55663494", "São\ José\ do\ Povo\ \-\ MT",
"55553413", "Uruguaiana\ \-\ RS",
"55493627", "Paraíso\ \-\ SC",
"55623095", "Goiânia\ \-\ GO",
"55633393", "Chapada\ da\ Natividade\ \-\ TO",
"55193488", "Mombuca\ \-\ SP",
"55193575", "Itirapina\ \-\ SP",
"55713198", "Salvador\ \-\ BA",
"55313332", "Minas\ Gerais",
"55633453", "Wanderlândia\ \-\ TO",
"55633469", "Goiatins\ \-\ TO",
"55693237", "Porto\ Velho\ \-\ RO",
"55922123", "Manaus\ \-\ AM",
"5581342", "Recife\ \-\ PE",
"55753448", "Itamira\ \-\ BA",
"55313396", "Minas\ Gerais",
"55663461", "Jaciara\ \-\ MT",
"55123107", "Areias\ \-\ SP",
"55493453", "Peritiba\ \-\ SC",
"55773443", "Caraíbas\ \-\ BA",
"55183287", "Campinal\ \-\ SP",
"55183651", "Avanhandava\ \-\ SP",
"55513733", "Encruzilhada\ do\ Sul\ \-\ RS",
"55153244", "Piedade\ \-\ SP",
"55183375", "Pedrinhas\ Paulista\ \-\ SP",
"55453305", "Cascavel\ \-\ PR",
"55653611", "Cuiabá\ \-\ MT",
"55112891", "Suzano\ \-\ SP",
"55353442", "Bueno\ Brandão\ \-\ MG",
"55923582", "Manaus\ \-\ AM",
"55173562", "Tabapuã\ \-\ SP",
"55473021", "Balneário\ Camboriú\ \-\ SC",
"55143356", "Manduri\ \-\ SP",
"55843323", "Mossoró\ \-\ RN",
"55333528", "Teófilo\ Otoni\ \-\ MG",
"55833348", "Alcantil\ \-\ PB",
"55143522", "Lins\ \-\ SP",
"55813621", "Carpina\ \-\ PE",
"55843697", "Parazinho\ \-\ RN",
"55543278", "Canela\ \-\ RS",
"55513582", "Novo\ Hamburgo\ \-\ RS",
"55613339", "Brasília\ \-\ DF",
"55673574", "Inocência\ \-\ MS",
"55222651", "Saquarema\ \-\ RJ",
"55222105", "Macaé\ \-\ RJ",
"55272102", "Colatina\ \-\ ES",
"55513761", "Paverama\ \-\ RS",
"55173643", "Santa\ Rita\ D\'Oeste\ \-\ SP",
"55623628", "Novo\ Gama\ \-\ GO",
"55183639", "Santo\ Antônio\ do\ Aracanguá\ \-\ SP",
"55483534", "Santa\ Rosa\ do\ Sul\ \-\ SC",
"55273745", "Águia\ Branca\ \-\ ES",
"5592", "Amazonas",
"55343662", "Araxá\ \-\ MG",
"55663433", "Primavera\ do\ Leste\ \-\ MT",
"55533026", "Pelotas\ \-\ RS",
"55112643", "São\ Paulo\ \-\ SP",
"55843737", "Parnamirim\ \-\ RN",
"55493525", "Catanduvas\ \-\ SC",
"55993601", "Feira\ Nova\ do\ Maranhão\ \-\ MA",
"55493334", "Saudades\ \-\ SC",
"55112781", "São\ Paulo\ \-\ SP",
"5511461", "Cotia\ \-\ SP",
"55115817", "São\ Paulo\ \-\ SP",
"55173282", "Icém\ \-\ SP",
"55114649", "Itaquaquecetuba\ \-\ SP",
"55472111", "Blumenau\ \-\ SC",
"55343846", "Douradoquara\ \-\ MG",
"55543391", "Gaurama\ \-\ RS",
"55443572", "Piquirivaí\ \-\ PR",
"55143387", "Sarutaiá\ \-\ SP",
"55223862", "Portela\ \-\ RJ",
"55613351", "Taguatinga\ \-\ DF",
"55513479", "Nova\ Santa\ Rita\ \-\ RS",
"55753623", "Feira\ de\ Santana\ \-\ BA",
"55143275", "Paulistânia\ \-\ SP",
"55773628", "Luis\ Eduardo\ Magalhães\ \-\ BA",
"55833213", "João\ Pessoa\ \-\ PB",
"55413111", "Curitiba\ \-\ PR",
"55623517", "Goiânia\ \-\ GO",
"55453252", "Toledo\ \-\ PR",
"55643653", "Gouvelândia\ \-\ GO",
"55743668", "João\ Dourado\ \-\ BA",
"55433315", "Londrina\ \-\ PR",
"55513590", "São\ Leopoldo\ \-\ RS",
"55983325", "Maranhãozinho\ \-\ MA",
"55883444", "Quixeramobim\ \-\ CE",
"55982109", "São\ Luís\ \-\ MA",
"55513693", "Rio\ Grande\ do\ Sul",
"5542", "Paraná",
"55153555", "Ribeira\ \-\ SP",
"55463313", "Pato\ Branco\ \-\ PR",
"55213846", "Duque\ de\ Caxias\ \-\ RJ",
"55273315", "Vitória\ \-\ ES",
"55383525", "Senador\ Modestino\ Gonçalves\ \-\ MG",
"55543364", "Ronda\ Alta\ \-\ RS",
"55613365", "Brasília\ \-\ DF",
"55673467", "Fátima\ do\ Sul\ \-\ MS",
"55483243", "Biguaçu\ \-\ SC",
"55543451", "Bento\ Gonçalves\ \-\ RS",
"55513238", "Rio\ Grande\ do\ Sul",
"55114785", "Embu\ das\ Artes\ \-\ SP",
"5531325", "Minas\ Gerais",
"55753430", "Itapicuru\ \-\ BA",
"55743632", "Mairi\ \-\ BA",
"55613491", "Brasília\ \-\ DF",
"55554007", "Santa\ Maria\ \-\ RS",
"55743541", "Senhor\ do\ Bonfim\ \-\ BA",
"55513755", "Muçum\ \-\ RS",
"55443218", "Maringá\ \-\ PR",
"55533256", "Bojuru\ \-\ RS",
"55493435", "Ponte\ Serrada\ \-\ SC",
"55373277", "Leandro\ Ferreira\ \-\ MG",
"55813607", "Orobó\ \-\ PE",
"55544062", "Caxias\ do\ Sul\ \-\ RS",
"55353226", "Luminárias\ \-\ MG",
"55663523", "Nova\ Santa\ Helena\ \-\ MT",
"55242484", "Miguel\ Pereira\ \-\ RJ",
"55333515", "Água\ Boa\ \-\ MG",
"55212689", "Porto\ Belo\ \-\ RJ",
"55673503", "Paranaíba\ \-\ MS",
"55133378", "Cubatão\ \-\ SP",
"55633435", "Arapoema\ \-\ TO",
"55423238", "Ponta\ Grossa\ \-\ PR",
"55833357", "São\ Domingos\ do\ Cariri\ \-\ PB",
"55432102", "Apucarana\ \-\ PR",
"55553615", "Santa\ Margarida\ do\ Sul\ \-\ RS",
"55133392", "Guarujá\ \-\ SP",
"55893462", "Oeiras\ \-\ PI",
"55513902", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55353539", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55473156", "Braço\ do\ Baú\ \-\ SC",
"5533327", "Governador\ Valadares\ \-\ MG",
"55983182", "São\ Luís\ \-\ MA",
"55773413", "Cascavel\ \-\ BA",
"55513210", "Rio\ Grande\ do\ Sul",
"55163975", "Ribeirão\ Preto\ \-\ SP",
"55753418", "Alagoinhas\ \-\ BA",
"55163275", "Taiaçu\ \-\ SP",
"55383014", "Montes\ Claros\ \-\ MG",
"55223211", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55973352", "Anori\ \-\ AM",
"55663537", "Nova\ Maringá\ \-\ MT",
"55463572", "Cruzeiro\ do\ Iguaçu\ \-\ PR",
"55623997", "Goiânia\ \-\ GO",
"55163387", "Nova\ Europa\ \-\ SP",
"55643609", "Itumbiara\ \-\ GO",
"55423276", "Reserva\ \-\ PR",
"55423902", "Guarapuava\ \-\ PR",
"55213162", "Nilópolis\ \-\ RJ",
"55323533", "Colônia\ Padre\ Damião\ \-\ MG",
"55813377", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55193307", "Campinas\ \-\ SP",
"55443257", "Flórida\ \-\ PR",
"55513701", "Rio\ Grande\ do\ Sul",
"55473352", "Presidente\ Getúlio\ \-\ SC",
"55983386", "Guimarães\ \-\ MA",
"55793342", "Muribeca\ \-\ SE",
"55443566", "Juranda\ \-\ PR",
"55643433", "Itumbiara\ \-\ GO",
"55314113", "Sete\ Lagoas\ \-\ MG",
"55993586", "Ribamar\ Fiquene\ \-\ MA",
"55713025", "Salvador\ \-\ BA",
"55343513", "Araguari\ \-\ MG",
"55993661", "Codó\ \-\ MA",
"55323281", "Lima\ Duarte\ \-\ MG",
"55313768", "Contagem\ \-\ MG",
"55713261", "Salvador\ \-\ BA",
"55413383", "São\ José\ dos\ Pinhais\ \-\ PR",
"55213138", "Rio\ de\ Janeiro\ \-\ RJ",
"55213602", "Niterói\ \-\ RJ",
"55144009", "Bauru\ \-\ SP",
"55623645", "Goiânia\ \-\ GO",
"55553224", "Silveira\ Martins\ \-\ RS",
"55333295", "Virgolândia\ \-\ MG",
"55733549", "Manoel\ Vitorino\ \-\ BA",
"55212728", "São\ Gonçalo\ \-\ RJ",
"55543280", "Pedras\ Brancas\ \-\ RS",
"55333254", "Perpétuo\ Socorro\ \-\ MG",
"55193847", "Jaguariúna\ \-\ SP",
"55273728", "Vila\ Valério\ \-\ ES",
"55643620", "Rio\ Verde\ \-\ GO",
"55913449", "São\ João\ de\ Pirabas\ \-\ PA",
"55793211", "Aracaju\ \-\ SE",
"55213610", "Niterói\ \-\ RJ",
"55213513", "Rio\ de\ Janeiro\ \-\ RJ",
"55753650", "Nordestina\ \-\ BA",
"55493548", "Vargem\ Bonita\ \-\ SC",
"55473492", "Santa\ Cruz\ \-\ SC",
"55313732", "Congonhas\ \-\ MG",
"55673559", "Paranaíba\ \-\ MS",
"55633014", "Palmas\ \-\ TO",
"55312122", "Belo\ Horizonte\ \-\ MG",
"55323423", "Cataguases\ \-\ MG",
"55443644", "São\ Manoel\ do\ Paraná\ \-\ PR",
"55663427", "Rondonópolis\ \-\ MT",
"55793712", "Aracaju\ \-\ SE",
"55893438", "São\ Julião\ \-\ PI",
"55773645", "Boquira\ \-\ BA",
"55313231", "Minas\ Gerais",
"55493655", "Campo\ Erê\ \-\ SC",
"55873763", "Garanhuns\ \-\ PE",
"55433035", "Cambé\ \-\ PR",
"55133273", "Santos\ \-\ SP",
"55813412", "Recife\ \-\ PE",
"55313830", "Minas\ Gerais",
"551122", "São\ Paulo\ \-\ SP",
"551129", "São\ Paulo\ \-\ SP",
"55993014", "Imperatriz\ \-\ MA",
"55633371", "Paranã\ \-\ TO",
"55313857", "Dom\ Silvério\ \-\ MG",
"55823235", "Maceió\ \-\ AL",
"55623558", "Goiânia\ \-\ GO",
"55443313", "Santa\ Inês\ \-\ PR",
"55513495", "Sertão\ Santana\ \-\ RS",
"55923361", "Manacapuru\ \-\ AM",
"55913184", "Belém\ \-\ PA",
"55843337", "Caraúbas\ \-\ RN",
"55383633", "Ubaí\ \-\ MG",
"55543292", "Flores\ da\ Cunha\ \-\ RS",
"55893515", "Floriano\ \-\ PI",
"55143652", "Dois\ Córregos\ \-\ SP",
"55163519", "Ribeirão\ Preto\ \-\ SP",
"55513454", "Esteio\ \-\ RS",
"55813551", "Ipojuca\ \-\ PE",
"55643455", "Caldas\ Novas\ \-\ GO",
"55863245", "Nossa\ Senhora\ dos\ Remédios\ \-\ PI",
"55753289", "Pedro\ Alexandre\ \-\ BA",
"55753425", "Cachoeira\ \-\ BA",
"55183605", "Santópolis\ do\ Aguapeí\ \-\ SP",
"55273345", "Vitória\ \-\ ES",
"55433444", "Arapuã\ \-\ PR",
"55323555", "Coimbra\ \-\ MG",
"55213816", "Rio\ de\ Janeiro\ \-\ RJ",
"55123607", "Tremembé\ \-\ SP",
"55183521", "Adamantina\ \-\ SP",
"55483062", "Florianópolis\ \-\ SC",
"55833534", "Uiraúna\ \-\ PB",
"55733299", "Lajedão\ \-\ BA",
"55463055", "Francisco\ Beltrão\ \-\ PR",
"55163432", "Franca\ \-\ SP",
"55313263", "Belo\ Horizonte\ \-\ MG",
"55513727", "Rio\ Grande\ do\ Sul",
"55443248", "Iguaraçu\ \-\ PR",
"55983213", "São\ Luís\ \-\ MA",
"55714111", "Camaçari\ \-\ BA",
"55313886", "Diogo\ de\ Vasconcelos\ \-\ MG",
"55433223", "Cambé\ \-\ PR",
"55114484", "Mairiporã\ \-\ SP",
"55173445", "Américo\ de\ Campos\ \-\ SP",
"55873843", "Tacaratu\ \-\ PE",
"55114622", "Santana\ de\ Parnaíba\ \-\ SP",
"55193321", "Araras\ \-\ SP",
"55823269", "Pólo\ Cloroquímico\ de\ Alagoas\ \-\ AL",
"55143408", "Marília\ \-\ SP",
"55513043", "Gravataí\ \-\ RS",
"55693481", "Espigão\ do\ Oeste\ \-\ RO",
"55473205", "Joinville\ \-\ SC",
"55513134", "São\ Leopoldo\ \-\ RS",
"55493557", "Zortéa\ \-\ SC",
"55173344", "Bebedouro\ \-\ SP",
"55273223", "Vitória\ \-\ ES",
"55823253", "Novo\ Lino\ \-\ AL",
"55463225", "Pato\ Branco\ \-\ PR",
"55343271", "Ituiutaba\ \-\ MG",
"55853012", "Caucaia\ \-\ CE",
"55483330", "Florianópolis\ \-\ SC",
"55633530", "Rio\ dos\ Bois\ \-\ TO",
"55833424", "Salgadinho\ \-\ PB",
"55863323", "Parnaíba\ \-\ PI",
"55833682", "São\ José\ dos\ Ramos\ \-\ PB",
"55644052", "Itumbiara\ \-\ GO",
"55493633", "Santa\ Helena\ \-\ SC",
"55353551", "Guaxupé\ \-\ MG",
"55483357", "São\ José\ \-\ SC",
"55192103", "Campinas\ \-\ SP",
"55313029", "Belo\ Horizonte\ \-\ MG",
"55114099", "Diadema\ \-\ SP",
"55193858", "Engenheiro\ Coelho\ \-\ SP",
"55993633", "Lagoa\ Grande\ do\ Maranhão\ \-\ MA",
"55643089", "Itumbiara\ \-\ GO",
"55893440", "Ipiranga\ do\ Piauí\ \-\ PI",
"55883414", "Quixadá\ \-\ CE",
"55433345", "Londrina\ \-\ PR",
"55923671", "Manaus\ \-\ AM",
"55153527", "Itapetininga\ \-\ SP",
"55643461", "Pires\ do\ Rio\ \-\ GO",
"55242411", "Barra\ do\ Piraí\ \-\ RJ",
"55313848", "Minas\ Gerais",
"55543373", "São\ Valentim\ \-\ RS",
"55173576", "Ariranha\ \-\ SP",
"55983357", "Matinha\ \-\ MA",
"55843228", "Ceará\-Mirim\ \-\ RN",
"55993557", "Nova\ Iorque\ \-\ MA",
"55513671", "Camaquã\ \-\ RS",
"55663401", "Barra\ do\ Garças\ \-\ MT",
"55693345", "Cabixi\ \-\ RO",
"55343816", "Lagoa\ Grande\ \-\ MG",
"55114619", "Jandira\ \-\ SP",
"55513394", "Rio\ Grande\ do\ Sul",
"55114441", "Caieiras\ \-\ SP",
"55733017", "Ilhéus\ \-\ BA",
"55173359", "Colômbia\ \-\ SP",
"55513064", "Sapiranga\ \-\ RS",
"55983273", "São\ Luís\ \-\ MA",
"55453054", "Toledo\ \-\ PR",
"55613297", "Brasília\ \-\ DF",
"55373247", "Igaratinga\ \-\ MG",
"55193647", "Itobi\ \-\ SP",
"55843522", "Pendências\ \-\ RN",
"55623404", "Assunção\ de\ Goiás\ \-\ GO",
"55753251", "Itaberaba\ \-\ BA",
"55913811", "Ipixuna\ do\ Pará\ \-\ PA",
"55873891", "Moreilândia\ \-\ PE",
"55133348", "Guarujá\ \-\ SP",
"55673025", "Campo\ Grande\ \-\ MS",
"55673261", "Bandeirantes\ \-\ MS",
"55843356", "Doutor\ Severiano\ \-\ RN",
"55733697", "Travessão\ \-\ BA",
"55823285", "São\ José\ da\ Laje\ \-\ AL",
"55413902", "Paranaguá\ \-\ PR",
"55194126", "Itapira\ \-\ SP",
"55193024", "Rio\ Claro\ \-\ SP",
"55433399", "Tamarana\ \-\ PR",
"55653301", "Chapada\ dos\ Guimarães\ \-\ MT",
"55313533", "Ibirité\ \-\ MG",
"55483273", "Major\ Gercino\ \-\ SC",
"55313880", "Minas\ Gerais",
"55313118", "Belo\ Horizonte\ \-\ MG",
"55633426", "São\ Sebastião\ do\ Tocantins\ \-\ TO",
"55113505", "São\ Paulo\ \-\ SP",
"55893575", "Avelino\ Lopes\ \-\ PI",
"55893488", "Jacobina\ do\ Piauí\ \-\ PI",
"55693463", "Mirante\ da\ Serra\ \-\ RO",
"55533035", "Rio\ Grande\ \-\ RS",
"55883665", "Morrinhos\ \-\ CE",
"55813758", "Barra\ de\ Guabiraba\ \-\ PE",
"55863299", "Hugo\ Napoleão\ \-\ PI",
"55333416", "Virginópolis\ \-\ MG",
"55443542", "Campina\ da\ Lagoa\ \-\ PR",
"55133386", "Guarujá\ \-\ SP",
"55693459", "Ji\-Paraná\ \-\ RO",
"55793366", "Brejo\ Grande\ \-\ SE",
"55493592", "Tangará\ \-\ SC",
"55652123", "Cuiabá\ \-\ MT",
"55513611", "Chuvisca\ \-\ RS",
"55473448", "Balneário\ Barra\ do\ Sul\ \-\ SC",
"55214133", "Magé\ \-\ RJ",
"55513449", "Rio\ Grande\ do\ Sul",
"5511353", "São\ Paulo\ \-\ SP",
"55443304", "Maringá\ \-\ PR",
"55113442", "São\ Paulo\ \-\ SP",
"55353867", "Ribeirão\ Vermelho\ \-\ MG",
"55114493", "Várzea\ Paulista\ \-\ SP",
"55242471", "Vassouras\ \-\ RJ",
"55112516", "São\ Paulo\ \-\ SP",
"55732101", "Ilhéus\ \-\ BA",
"55833291", "Rio\ Tinto\ \-\ PB",
"55953224", "Boa\ Vista\ \-\ RR",
"55493536", "Salto\ Veloso\ \-\ SC",
"55433463", "Godoy\ Moreira\ \-\ PR",
"55823539", "Arapiraca\ \-\ AL",
"55733245", "Ubatã\ \-\ BA",
"55643051", "Rio\ Verde\ \-\ GO",
"55213504", "Rio\ de\ Janeiro\ \-\ RJ",
"55993536", "Governador\ Edison\ Lobão\ \-\ MA",
"55373015", "Divinópolis\ \-\ MG",
"55893446", "Itainópolis\ \-\ PI",
"55623305", "São\ Francisco\ de\ Goiás\ \-\ GO",
"55273139", "Vila\ Velha\ \-\ ES",
"55983392", "Bacuri\ \-\ MA",
"55753265", "Santaluz\ \-\ BA",
"55993592", "Açailândia\ \-\ MA",
"55843432", "Campo\ Redondo\ \-\ RN",
"5551341", "Rio\ Grande\ do\ Sul",
"55313244", "Minas\ Gerais",
"55114217", "Atibaia\ \-\ SP",
"55673255", "Bonito\ \-\ MS",
"55963083", "Macapá\ \-\ AP",
"55753021", "Feira\ de\ Santana\ \-\ BA",
"55443631", "Cianorte\ \-\ PR",
"55663556", "Juara\ \-\ MT",
"55823551", "Penedo\ \-\ AL",
"55383311", "Paracatu\ \-\ MG",
"55353472", "Cachoeira\ de\ Minas\ \-\ MG",
"55733554", "Aurelino\ Leal\ \-\ BA",
"55864009", "Teresina\ \-\ PI",
"55923184", "Manaus\ \-\ AM",
"55833378", "Campo\ de\ Santana\ \-\ PB",
"5565", "Mato\ Grosso",
"55423270", "Guaragi\ \-\ PR",
"55313555", "Minas\ Gerais",
"5511597", "São\ Paulo\ \-\ SP",
"55113607", "Osasco\ \-\ SP",
"55112813", "São\ Paulo\ \-\ SP",
"55373258", "Pitangui\ \-\ MG",
"55114524", "Itatiba\ \-\ SP",
"55713642", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55173813", "Jaci\ \-\ SP",
"55623952", "Aparecida\ de\ Goiânia\ \-\ GO",
"55623473", "Iaciara\ \-\ GO",
"55443659", "Altônia\ \-\ PR",
"55193545", "Santa\ Gertrudes\ \-\ SP",
"55443663", "Douradina\ \-\ PR",
"55913727", "Tomé\-Açu\ \-\ PA",
"55493242", "São\ José\ do\ Cerrito\ \-\ SC",
"55143554", "Cafelândia\ \-\ SP",
"55473397", "Gaspar\ \-\ SC",
"55273151", "Linhares\ \-\ ES",
"55443236", "Floresta\ \-\ PR",
"55112703", "São\ Paulo\ \-\ SP",
"55473623", "Três\ Barras\ \-\ SC",
"55653327", "Progresso\ \-\ MT",
"55473520", "Rio\ do\ Sul\ \-\ SC",
"55333321", "Caratinga\ \-\ MG",
"55674004", "Campo\ Grande\ \-\ MS",
"55773473", "Macaúbas\ \-\ BA",
"55513270", "Rio\ Grande\ do\ Sul",
"55713283", "Salvador\ \-\ BA",
"55153274", "Alambari\ \-\ SP",
"55114819", "Franco\ da\ Rocha\ \-\ SP",
"55162133", "Ribeirão\ Preto\ \-\ SP",
"55183345", "Presidente\ Prudente\ \-\ SP",
"55323263", "Maripá\ de\ Minas\ \-\ MG",
"55423916", "Tibagi\ \-\ PR",
"55163723", "Franca\ \-\ SP",
"55553351", "Pirapó\ \-\ RS",
"55643626", "Santo\ Antônio\ da\ Barra\ \-\ GO",
"55383833", "Jaíba\ \-\ MG",
"55543286", "Gramado\ \-\ RS",
"5563322", "Palmas\ \-\ TO",
"55753239", "Anguera\ \-\ BA",
"55813269", "Recife\ \-\ PE",
"55933521", "Vila\ Residencial\ Belo\ Monte\ \-\ PA",
"55614007", "Brasília\ \-\ DF",
"55383741", "Pirapora\ \-\ MG",
"55813253", "Recife\ \-\ PE",
"55433151", "Sabáudia\ \-\ PR",
"55193402", "Piracicaba\ \-\ SP",
"55813472", "Recife\ \-\ PE",
"55112331", "São\ Paulo\ \-\ SP",
"55133213", "Santos\ \-\ SP",
"55843275", "Vera\ Cruz\ \-\ RN",
"55493311", "Chapecó\ \-\ SC",
"55864020", "Teresina\ \-\ PI",
"5549322", "Lages\ \-\ SC",
"55673666", "Chapadão\ do\ Sul\ \-\ MS",
"55813747", "Brejo\ da\ Madre\ de\ Deus\ \-\ PE",
"55843387", "Riacho\ de\ Santana\ \-\ RN",
"55793447", "Frei\ Paulo\ \-\ SE",
"55553365", "Roque\ Gonzales\ \-\ RS",
"55413671", "Quatro\ Barras\ \-\ PR",
"55753656", "Glória\ \-\ BA",
"55173331", "Guaíra\ \-\ SP",
"55473457", "Barra\ Velha\ \-\ SC",
"55313836", "Itambé\ do\ Mato\ Dentro\ \-\ MG",
"55993311", "Açailândia\ \-\ MA",
"55693521", "Jaru\ \-\ RO",
"55213032", "Rio\ de\ Janeiro\ \-\ RJ",
"55183223", "Presidente\ Prudente\ \-\ SP",
"55994102", "Imperatriz\ \-\ MA",
"55192114", "Limeira\ \-\ SP",
"55163482", "Cravinhos\ \-\ SP",
"55883567", "Ipaumirim\ \-\ CE",
"55143737", "Garça\ \-\ SP",
"55413134", "São\ José\ dos\ Pinhais\ \-\ PR",
"55873781", "Canhotinho\ \-\ PE",
"55793271", "Divina\ Pastora\ \-\ SE",
"55193476", "Nova\ Odessa\ \-\ SP",
"55242258", "Bemposta\ \-\ RJ",
"55313561", "Itabirito\ \-\ MG",
"55883639", "Varjota\ \-\ CE",
"55313892", "Viçosa\ \-\ MG",
"55433521", "Londrina\ \-\ PR",
"55313686", "Confins\ \-\ MG",
"55713626", "Camaçari\ \-\ BA",
"55843268", "Caiçara\ do\ Rio\ do\ Vento\ \-\ RN",
"55753451", "Araças\ \-\ BA",
"55673461", "Naviraí\ \-\ MS",
"55114176", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55853923", "Fortaleza\ \-\ CE",
"55823341", "Maceió\ \-\ AL",
"55183648", "Juritis\ \-\ SP",
"55733613", "Itabuna\ \-\ BA",
"55222555", "Cantagalo\ \-\ RJ",
"55983473", "Coelho\ Neto\ \-\ MA",
"55543457", "Monte\ Belo\ do\ Sul\ \-\ RS",
"55153256", "Campina\ do\ Monte\ Alegre\ \-\ SP",
"55813525", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55554001", "Santa\ Maria\ \-\ RS",
"55753364", "Iraquara\ \-\ BA",
"55683216", "Rio\ Branco\ \-\ AC",
"55483952", "Florianópolis\ \-\ SC",
"55123966", "São\ José\ dos\ Campos\ \-\ SP",
"55663574", "Nova\ Guarita\ \-\ MT",
"55813194", "Recife\ \-\ PE",
"55143344", "Ipaussu\ \-\ SP",
"55833464", "Junco\ do\ Seridó\ \-\ PB",
"55193394", "Indaiatuba\ \-\ SP",
"55743547", "Antônio\ Gonçalves\ \-\ BA",
"55623088", "Goiânia\ \-\ GO",
"55863363", "Buriti\ dos\ Lopes\ \-\ PI",
"55813155", "Gravatá\ \-\ PE",
"55114638", "Poá\ \-\ SP",
"55623380", "Araguapaz\ \-\ GO",
"55123633", "Taubaté\ \-\ SP",
"55373271", "Pitangui\ \-\ MG",
"55193671", "Casa\ Branca\ \-\ SP",
"55514109", "Gravataí\ \-\ RS",
"55474108", "Balneário\ Camboriú\ \-\ SC",
"55212886", "Nova\ Iguaçu\ \-\ RJ",
"55273263", "Santa\ Maria\ de\ Jetibá\ \-\ ES",
"55353435", "Extrema\ \-\ MG",
"55212692", "Nilópolis\ \-\ RJ",
"55114888", "Joanópolis\ \-\ SP",
"55553541", "Santo\ Cristo\ \-\ RS",
"55333508", "Governador\ Valadares\ \-\ MG",
"55273259", "Santa\ Teresa\ \-\ ES",
"55473001", "Joinville\ \-\ SC",
"55613213", "Brasília\ \-\ DF",
"55483252", "São\ Bonifácio\ \-\ SC",
"55833351", "Monteiro\ \-\ PB",
"55613190", "Brasília\ \-\ DF",
"55513767", "Tunas\ \-\ RS",
"55242271", "Sapucaia\ \-\ RJ",
"55433259", "Jataizinho\ \-\ PR",
"55353525", "Delfinópolis\ \-\ MG",
"55114662", "Embu\-Guaçu\ \-\ SP",
"55923249", "Manaus\ \-\ AM",
"55853345", "Pacatuba\ \-\ CE",
"55193361", "Mogi\-Guaçu\ \-\ SP",
"55914005", "Belém\ \-\ PA",
"55353334", "Carmo\ de\ Minas\ \-\ MG",
"55193454", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55313715", "Cordisburgo\ \-\ MG",
"55913658", "Santa\ Cruz\ do\ Arari\ \-\ PA",
"55193495", "Limeira\ \-\ SP",
"55833365", "Alagoa\ Nova\ \-\ PB",
"55112787", "São\ Paulo\ \-\ SP",
"55643642", "Turvelândia\ \-\ GO",
"55453243", "Nova\ Aurora\ \-\ PR",
"5561210", "Brasília\ \-\ DF",
"55813435", "Paulista\ \-\ PE",
"55383226", "Coração\ de\ Jesus\ \-\ MG",
"55963251", "Macapá\ \-\ AP",
"55343411", "Iturama\ \-\ MG",
"55543397", "Maximiliano\ de\ Almeida\ \-\ RS",
"55112652", "São\ Paulo\ \-\ SP",
"55843232", "Natal\ \-\ RN",
"55643983", "Itumbiara\ \-\ GO",
"55313444", "Belo\ Horizonte\ \-\ MG",
"55643531", "Itumbiara\ \-\ GO",
"55143714", "Cerqueira\ César\ \-\ SP",
"55283554", "Muqui\ \-\ ES",
"55673455", "Rio\ Brilhante\ \-\ MS",
"55613357", "Samambaia\ Sul\ \-\ DF",
"55192137", "Campinas\ \-\ SP",
"55413658", "Bocaiúva\ do\ Sul\ \-\ PR",
"55242447", "Barra\ do\ Piraí\ \-\ RJ",
"55153026", "Sorocaba\ \-\ SP",
"55623511", "Inhumas\ \-\ GO",
"55222561", "Santa\ Maria\ Madalena\ \-\ RJ",
"55753674", "Cruz\ das\ Almas\ \-\ BA",
"55543520", "Erechim\ \-\ RS",
"55122124", "Lorena\ \-\ SP",
"55813518", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55473644", "Rio\ Negrinho\ \-\ SC",
"55112549", "São\ Paulo\ \-\ SP",
"55953593", "Amajari\ \-\ RR",
"55743645", "Campo\ Formoso\ \-\ BA",
"55693231", "Itapuã\ do\ Oeste\ \-\ RO",
"55893532", "Pajeú\ do\ Piauí\ \-\ PI",
"55213895", "Rio\ de\ Janeiro\ \-\ RJ",
"55183981", "Mirante\ do\ Paranapanema\ \-\ SP",
"55353453", "São\ Sebastião\ da\ Bela\ Vista\ \-\ MG",
"55843011", "Natal\ \-\ RN",
"55183281", "Presidente\ Epitácio\ \-\ SP",
"55123101", "Cachoeira\ Paulista\ \-\ SP",
"55663467", "Nova\ Nazaré\ \-\ MT",
"55693583", "Quinto\ Bec\ \-\ RO",
"55213119", "São\ Gonçalo\ \-\ RJ",
"55513416", "Capão\ da\ Canoa\ \-\ RS",
"55123655", "Caçapava\ \-\ SP",
"55383505", "Unaí\ \-\ MG",
"55653617", "Cuiabá\ \-\ MT",
"55333611", "Águas\ Formosas\ \-\ MG",
"55183657", "Alto\ Alegre\ \-\ SP",
"55174009", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55753278", "Cícero\ Dantas\ \-\ BA",
"55443436", "Itaúna\ do\ Sul\ \-\ PR",
"55184104", "Birigui\ \-\ SP",
"55713051", "Lauro\ de\ Freitas\ \-\ BA",
"55633442", "Ananás\ \-\ TO",
"55112897", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55513470", "Rio\ Grande\ do\ Sul",
"55222630", "Cabo\ Frio\ \-\ RJ",
"55323463", "Volta\ Grande\ \-\ MG",
"55613386", "Núcleo\ Bandeirante\ \-\ DF",
"55663503", "Brianorte\ \-\ MT",
"55383621", "Januária\ \-\ MG",
"55222533", "Nova\ Friburgo\ \-\ RJ",
"55282101", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55843691", "Lajes\ Pintadas\ \-\ RN",
"55212768", "Nova\ Iguaçu\ \-\ RJ",
"55613718", "Formosa\ \-\ GO",
"55513599", "Sapiranga\ \-\ RS",
"55273768", "Boa\ Esperança\ \-\ ES",
"55493442", "Concórdia\ \-\ SC",
"55643559", "Itumbiara\ \-\ GO",
"55773452", "Guanambi\ \-\ BA",
"55843374", "Riacho\ da\ Cruz\ \-\ RN",
"55123014", "Jacareí\ \-\ SP",
"55643563", "Jandaia\ \-\ GO",
"55163415", "São\ Carlos\ \-\ SP",
"55813272", "Recife\ \-\ PE",
"55843475", "Equador\ \-\ RN",
"5521387", "Rio\ de\ Janeiro\ \-\ RJ",
"55212796", "Mesquita\ \-\ RJ",
"55312138", "Belo\ Horizonte\ \-\ MG",
"55443352", "Santo\ Inácio\ \-\ PR",
"55993621", "Bacabal\ \-\ MA",
"55313728", "Buarque\ de\ Macedo\ \-\ MG",
"55713221", "Salvador\ \-\ BA",
"55673433", "Ponta\ Porã\ \-\ MS",
"55683611", "Manoel\ Urbano\ \-\ AC",
"55113426", "Diadema\ \-\ SP",
"55373513", "Pompéu\ \-\ MG",
"55193811", "Mogi\-Guaçu\ \-\ SP",
"55273732", "Baixo\ Guandu\ \-\ ES",
"55153287", "Laranjal\ Paulista\ \-\ SP",
"55623608", "Goiânia\ \-\ GO",
"55443526", "Formosa\ do\ Oeste\ \-\ PR",
"55753439", "Ribeira\ do\ Amparo\ \-\ BA",
"55813469", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55193902", "Holambra\ \-\ SP",
"55813972", "Recife\ \-\ PE",
"55843664", "Natal\ \-\ RN",
"55813453", "Recife\ \-\ PE",
"55533281", "Pelotas\ \-\ RS",
"55242458", "Rio\ das\ Flores\ \-\ RJ",
"551155", "São\ Paulo\ \-\ SP",
"55163982", "Serra\ Azul\ \-\ SP",
"55213552", "Duque\ de\ Caxias\ \-\ RJ",
"55553792", "Pinheirinho\ do\ Vale\ \-\ RS",
"55893568", "Palmeira\ do\ Piauí\ \-\ PI",
"55114234", "São\ Caetano\ do\ Sul\ \-\ SP",
"55893422", "Picos\ \-\ PI",
"55813771", "Bom\ Conselho\ \-\ PE",
"55193701", "Limeira\ \-\ SP",
"55753603", "Feira\ de\ Santana\ \-\ BA",
"55212680", "Mangaratiba\ \-\ RJ",
"55943352", "Parauapebas\ \-\ PA",
"55493621", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55623336", "Alexânia\ \-\ GO",
"55163475", "Sertãozinho\ \-\ SP",
"55813341", "Recife\ \-\ PE",
"55114591", "Itupeva\ \-\ SP",
"55313521", "Ibirité\ \-\ MG",
"55183636", "Araçatuba\ \-\ SP",
"5511257", "São\ Paulo\ \-\ SP",
"55433561", "Conselheiro\ Mairinck\ \-\ PR",
"55143604", "Barra\ Bonita\ \-\ SP",
"55482106", "Florianópolis\ \-\ SC",
"55513402", "Guaíba\ \-\ RS",
"55533029", "Pelotas\ \-\ RS",
"55113409", "Suzano\ \-\ SP",
"55162107", "São\ Carlos\ \-\ SP",
"55463553", "Espigão\ Alto\ do\ Iguaçu\ \-\ PR",
"55543905", "Gramado\ \-\ RS",
"55183263", "Santo\ Anastácio\ \-\ SP",
"55273555", "Mimoso\ do\ Sul\ \-\ ES",
"55323345", "Alto\ Rio\ Doce\ \-\ MG",
"55823334", "Maceió\ \-\ AL",
"55973373", "Humaitá\ \-\ AM",
"55753181", "Alagoinhas\ \-\ BA",
"55453541", "Santa\ Terezinha\ de\ Itaipu\ \-\ PR",
"55163664", "Brodowski\ \-\ SP",
"55883527", "Pereiro\ \-\ CE",
"55843643", "Parnamirim\ \-\ RN",
"55115611", "São\ Paulo\ \-\ SP",
"55183692", "Braúna\ \-\ SP",
"55753218", "Salgadália\ \-\ BA",
"55473373", "Guaramirim\ \-\ SC",
"55613380", "Núcleo\ Bandeirante\ \-\ DF",
"55114646", "Itaquaquecetuba\ \-\ SP",
"55113633", "São\ Paulo\ \-\ SP",
"55273125", "Guarapari\ \-\ ES",
"55733604", "Batinga\ \-\ BA",
"55212648", "Maricá\ \-\ RJ",
"55453378", "Toledo\ \-\ PR",
"55333355", "Iapu\ \-\ MG",
"55343849", "Monte\ Carmelo\ \-\ MG",
"55513476", "Canoas\ \-\ RS",
"55713461", "Salvador\ \-\ BA",
"55553534", "Doutor\ Maurício\ Cardoso\ \-\ RS",
"55123311", "Aparecida\ \-\ SP",
"55152102", "Sorocaba\ \-\ SP",
"55353212", "Varginha\ \-\ MG",
"55412103", "Curitiba\ \-\ PR",
"55313151", "Sete\ Lagoas\ \-\ MG",
"55124110", "Pindamonhangaba\ \-\ SP",
"55454001", "Cascavel\ \-\ PR",
"55643666", "Portelândia\ \-\ GO",
"5512392", "São\ José\ dos\ Campos\ \-\ SP",
"55653052", "Cuiabá\ \-\ MT",
"55643933", "Itumbiara\ \-\ GO",
"5589", "Piauí",
"55643581", "Itumbiara\ \-\ GO",
"55193508", "Araras\ \-\ SP",
"55843282", "Santo\ Antônio\ \-\ RN",
"55982106", "São\ Luís\ \-\ MA",
"55793411", "Nossa\ Senhora\ da\ Glória\ \-\ SE",
"55743699", "Lapão\ \-\ BA",
"55513658", "Charqueadas\ \-\ RS",
"55213849", "Rio\ de\ Janeiro\ \-\ RJ",
"55163763", "Jardinópolis\ \-\ SP",
"55493347", "Coronel\ Freitas\ \-\ SC",
"55643698", "Nova\ Aurora\ \-\ GO",
"55163759", "Franca\ \-\ SP",
"55813711", "Caruaru\ \-\ PE",
"55473236", "Blumenau\ \-\ SC",
"55353341", "Caxambu\ \-\ MG",
"55653222", "Cáceres\ \-\ MT",
"55443623", "Umuarama\ \-\ PR",
"55313165", "Santa\ Luzia\ \-\ MG",
"55913767", "São\ Caetano\ de\ Odivelas\ \-\ PA",
"55333727", "Santa\ Maria\ do\ Salto\ \-\ MG",
"55533263", "Santa\ Vitória\ do\ Palmar\ \-\ RS",
"55883437", "Tauá\ \-\ CE",
"55623357", "Uruaçu\ \-\ GO",
"55673907", "Corumbá\ \-\ MS",
"55553757", "Novo\ Barreiro\ \-\ RS",
"55193871", "Valinhos\ \-\ SP",
"55323444", "Recreio\ \-\ MG",
"55123833", "Ubatuba\ \-\ SP",
"55433555", "Japira\ \-\ PR",
"55353229", "Varginha\ \-\ MG",
"55643018", "Itumbiara\ \-\ GO",
"55923545", "Boa\ Vista\ do\ Ramos\ \-\ AM",
"55553243", "Santana\ do\ Livramento\ \-\ RS",
"55114688", "Barueri\ \-\ SP",
"55313431", "Belo\ Horizonte\ \-\ MG",
"55553730", "Vista\ Alegre\ \-\ RS",
"55143813", "Botucatu\ \-\ SP",
"55813212", "Recife\ \-\ PE",
"55484007", "Florianópolis\ \-\ SC",
"55513545", "Igrejinha\ \-\ RS",
"551124", "Guarulhos\ \-\ SP",
"55883501", "Juazeiro\ do\ Norte\ \-\ CE",
"55274104", "Cariacica\ \-\ ES",
"55613273", "Brasília\ \-\ DF",
"55433244", "Prado\ Ferreira\ \-\ PR",
"55813031", "Recife\ \-\ PE",
"55673483", "Coronel\ Sapucaia\ \-\ MS",
"55223854", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55123003", "São\ José\ dos\ Campos\ \-\ SP",
"55133305", "Guarujá\ \-\ SP",
"55114312", "Mogi\ das\ Cruzes\ \-\ SP",
"55453264", "Medianeira\ \-\ PR",
"55733041", "Itabuna\ \-\ BA",
"55333333", "Realeza\ \-\ MG",
"55313507", "Belo\ Horizonte\ \-\ MG",
"55843538", "Fernando\ Pedroza\ \-\ RN",
"55483413", "Criciúma\ \-\ SC",
"55113371", "São\ Paulo\ \-\ SP",
"55473631", "São\ Bento\ do\ Sul\ \-\ SC",
"55963324", "Itaubal\ \-\ AP",
"55664141", "Rondonópolis\ \-\ MT",
"55112245", "Guarulhos\ \-\ SP",
"5511472", "Mogi\ das\ Cruzes\ \-\ SP",
"55343654", "Santa\ Rosa\ da\ Serra\ \-\ MG",
"5531379", "Minas\ Gerais",
"5547343", "Joinville\ \-\ SC",
"55212630", "Magé\ \-\ RJ",
"55273072", "Vila\ Velha\ \-\ ES",
"55623386", "Faina\ \-\ GO",
"55163996", "Ribeirão\ Preto\ \-\ SP",
"55473542", "Agronômica\ \-\ SC",
"55533931", "Rio\ Grande\ \-\ RS",
"55313459", "Minas\ Gerais",
"55443448", "Marilena\ \-\ PR",
"55114284", "Mogi\ das\ Cruzes\ \-\ SP",
"55173245", "José\ Bonifácio\ \-\ SP",
"55463535", "Verê\ \-\ PR",
"55273533", "Vila\ Velha\ \-\ ES",
"55733673", "Arataca\ \-\ BA",
"5519341", "Piracicaba\ \-\ SP",
"55553318", "Jóia\ \-\ RS",
"55123861", "São\ Sebastião\ \-\ SP",
"55693423", "Ji\-Paraná\ \-\ RO",
"55883625", "Chaval\ \-\ CE",
"55222768", "Quissamã\ \-\ RJ",
"55833389", "Olivedos\ \-\ PB",
"55423254", "Colônia\ Witmarsum\ \-\ PR",
"55222796", "Macaé\ \-\ RJ",
"55312146", "Sete\ Lagoas\ \-\ MG",
"55633358", "Dueré\ \-\ TO",
"5511346", "São\ Paulo\ \-\ SP",
"55753614", "Feira\ de\ Santana\ \-\ BA",
"55323728", "Muriaé\ \-\ MG",
"55333202", "Governador\ Valadares\ \-\ MG",
"55823272", "Barra\ de\ São\ Miguel\ \-\ AL",
"55633466", "Pedro\ Afonso\ \-\ TO",
"55693533", "Porto\ Velho\ \-\ RO",
"55613608", "Novo\ Gama\ \-\ GO",
"55513647", "Vendinha\ \-\ RS",
"55893582", "São\ Raimundo\ Nonato\ \-\ PI",
"55433533", "Panema\ \-\ PR",
"55473405", "Itajaí\ \-\ SC",
"55313399", "Minas\ Gerais",
"55183583", "Rinópolis\ \-\ SP",
"55183857", "São\ João\ do\ Pau\ D\'Alho\ \-\ SP",
"55753343", "Bonito\ \-\ BA",
"55114477", "Santo\ André\ \-\ SP",
"55222732", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55123426", "Taubaté\ \-\ SP",
"55123894", "Ilhabela\ \-\ SP",
"55493358", "Cordilheira\ Alta\ \-\ SC",
"55733084", "Ilhéus\ \-\ BA",
"55843428", "São\ Fernando\ \-\ RN",
"55543352", "São\ José\ do\ Ouro\ \-\ RS",
"55833443", "Brejo\ do\ Cruz\ \-\ PB",
"55933533", "Monte\ Alegre\ \-\ PA",
"55383821", "Janaúba\ \-\ MG",
"55313775", "Sete\ Lagoas\ \-\ MG",
"55673221", "Três\ Lagoas\ \-\ MS",
"55613392", "Santa\ Maria\ \-\ DF",
"55114241", "Embu\ das\ Artes\ \-\ SP",
"55713433", "Salvador\ \-\ BA",
"55853463", "Fortaleza\ \-\ CE",
"55163303", "Araraquara\ \-\ SP",
"55613336", "Taguatinga\ \-\ DF",
"55163173", "Igarapava\ \-\ SP",
"55543526", "Três\ Arroios\ \-\ RS",
"55623348", "Mozarlândia\ \-\ GO",
"55553748", "Erval\ Seco\ \-\ RS",
"55733208", "Nova\ Viçosa\ \-\ BA",
"55434104", "Apucarana\ \-\ PR",
"55483645", "Armazém\ \-\ SC",
"55973482", "Ipixuna\ \-\ AM",
"55193589", "Porto\ Ferreira\ \-\ SP",
"55123979", "Monteiro\ Lobato\ \-\ SP",
"55413906", "Curitiba\ \-\ PR",
"55813647", "Buenos\ Aires\ \-\ PE",
"55193867", "Jaguariúna\ \-\ SP",
"55714101", "Salvador\ \-\ BA",
"55213716", "São\ Gonçalo\ \-\ RJ",
"55473047", "Balneário\ Camboriú\ \-\ SC",
"55633422", "Bernardo\ Sayão\ \-\ TO",
"55353295", "Machado\ \-\ MG",
"55112814", "Itaquaquecetuba\ \-\ SP",
"55533224", "Morro\ Redondo\ \-\ RS",
"55913469", "Nova\ Timboteua\ \-\ PA",
"55433339", "Londrina\ \-\ PR",
"55114620", "Osasco\ \-\ SP",
"55173814", "Adolfo\ \-\ SP",
"55653548", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55843526", "Porto\ do\ Mangue\ \-\ RN",
"55483903", "Araranguá\ \-\ SC",
"55653371", "Nova\ Mutum\ \-\ MT",
"55333377", "São\ João\ do\ Manhuaçu\ \-\ MG",
"55873831", "Serra\ Talhada\ \-\ PE",
"55543290", "Caxias\ do\ Sul\ \-\ RS",
"55383532", "Diamantina\ \-\ MG",
"55823177", "Maceió\ \-\ AL",
"55443664", "Alto\ Paraíso\ \-\ PR",
"55413972", "Pontal\ do\ Paraná\ \-\ PR",
"55413453", "Matinhos\ \-\ PR",
"55653694", "Várzea\ Grande\ \-\ MT",
"55213806", "Rio\ de\ Janeiro\ \-\ RJ",
"55413081", "São\ José\ dos\ Pinhais\ \-\ PR",
"55143553", "Guaimbê\ \-\ SP",
"55114169", "Carapicuíba\ \-\ SP",
"55313318", "Belo\ Horizonte\ \-\ MG",
"55112704", "São\ Paulo\ \-\ SP",
"55473624", "Canoinhas\ \-\ SC",
"55793198", "Aracaju\ \-\ SE",
"55773474", "Feira\ da\ Mata\ \-\ BA",
"55674003", "Campo\ Grande\ \-\ MS",
"55163509", "São\ Carlos\ \-\ SP",
"55983368", "Primeira\ Cruz\ \-\ MA",
"55153273", "Itapetininga\ \-\ SP",
"55443588", "Vidigal\ \-\ PR",
"55453035", "Cascavel\ \-\ PR",
"55323264", "Guarará\ \-\ MG",
"55173278", "União\ Paulista\ \-\ SP",
"55913771", "Mosqueiro\ \-\ PA",
"55993422", "Caxias\ \-\ MA",
"55173529", "Elisiário\ \-\ SP",
"55754009", "Feira\ de\ Santana\ \-\ BA",
"55483203", "Florianópolis\ \-\ SC",
"55163724", "Franca\ \-\ SP",
"55673234", "Corumbá\ \-\ MS",
"55983396", "Cândido\ Mendes\ \-\ MA",
"55893442", "Alagoinha\ do\ Piauí\ \-\ PI",
"55383834", "Nova\ Porteirinha\ \-\ MG",
"55493641", "Princesa\ \-\ SC",
"55993073", "Imperatriz\ \-\ MA",
"55153336", "Sorocaba\ \-\ SP",
"55114609", "Francisco\ Morato\ \-\ SP",
"55413627", "Fazenda\ Rio\ Grande\ \-\ PR",
"55153392", "Itapetininga\ \-\ SP",
"55413393", "Campo\ Largo\ \-\ PR",
"55323291", "Santa\ Rita\ de\ Jacutinga\ \-\ MG",
"55883404", "Russas\ \-\ CE",
"55843436", "São\ Vicente\ \-\ RN",
"55242401", "Barra\ do\ Piraí\ \-\ RJ",
"55513031", "Canoas\ \-\ RS",
"55983678", "Pindare\ Mirim\ \-\ MA",
"55193935", "Indaiatuba\ \-\ SP",
"55623375", "Itaberaí\ \-\ GO",
"55213142", "Itaboraí\ \-\ RJ",
"55192113", "Limeira\ \-\ SP",
"55133382", "Guarujá\ \-\ SP",
"55443546", "Quarto\ Centenário\ \-\ PR",
"55793362", "Cumbe\ \-\ SE",
"55443011", "Maringá\ \-\ PR",
"55333412", "São\ João\ Evangelista\ \-\ MG",
"55243076", "Volta\ Redonda\ \-\ RJ",
"55483332", "Florianópolis\ \-\ SC",
"55212705", "Niterói\ \-\ RJ",
"55493532", "Tangará\ \-\ SC",
"55163397", "Araraquara\ \-\ SP",
"55624017", "Aparecida\ de\ Goiânia\ \-\ GO",
"55863239", "Santo\ Antônio\ dos\ Milagres\ \-\ PI",
"55793227", "Aracaju\ \-\ SE",
"55173512", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55993641", "Coroatá\ \-\ MA",
"55513059", "Canoas\ \-\ RS",
"55493246", "Fraiburgo\ \-\ SC",
"55983274", "Paço\ do\ Lumiar\ \-\ MA",
"55833308", "Santo\ André\ \-\ PB",
"55653266", "Pontes\ e\ Lacerda\ \-\ MT",
"55473350", "Brusque\ \-\ SC",
"55114779", "Itapecerica\ da\ Serra\ \-\ SP",
"55423912", "São\ Mateus\ do\ Sul\ \-\ PR",
"55143535", "Pompéia\ \-\ SP",
"55343612", "Araxá\ \-\ MG",
"55813658", "Glória\ do\ Goitá\ \-\ PE",
"55114135", "Taboão\ da\ Serra\ \-\ SP",
"55773639", "Luis\ Eduardo\ Magalhães\ \-\ BA",
"55743527", "Casa\ Nova\ \-\ BA",
"55143324", "Ourinhos\ \-\ SP",
"55513711", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55473337", "Blumenau\ \-\ SC",
"55323696", "Muriaé\ \-\ MG",
"55443232", "Marialva\ \-\ PR",
"55833636", "Frei\ Martinho\ \-\ PB",
"55623567", "Goiânia\ \-\ GO",
"55813545", "Igarassu\ \-\ PE",
"55313325", "Minas\ Gerais",
"55223201", "Araruama\ \-\ RJ",
"55193023", "Rio\ Claro\ \-\ SP",
"55863251", "São\ João\ da\ Serra\ \-\ PI",
"55312109", "Ipatinga\ \-\ MG",
"55313868", "Conceição\ do\ Mato\ Dentro\ \-\ MG",
"55663552", "Guarantã\ do\ Norte\ \-\ MT",
"55313534", "Igarapé\ \-\ MG",
"55643441", "Catalão\ \-\ GO",
"55483274", "Angelina\ \-\ SC",
"55623956", "Goiânia\ \-\ GO",
"55453345", "Portão\ Ocoi\ \-\ PR",
"55212675", "Duque\ de\ Caxias\ \-\ RJ",
"55213629", "Niterói\ \-\ RJ",
"55713646", "Lauro\ de\ Freitas\ \-\ BA",
"55833259", "Pitimbu\ \-\ PB",
"55833263", "Lagoa\ de\ Dentro\ \-\ PB",
"55114461", "Santo\ André\ \-\ SP",
"55733535", "Jitaúna\ \-\ BA",
"55123147", "Queluz\ \-\ SP",
"55323541", "Ubá\ \-\ MG",
"55623639", "Goiânia\ \-\ GO",
"55873948", "Bom\ Nome\ \-\ PE",
"55112773", "São\ Paulo\ \-\ SP",
"55693464", "Vale\ do\ Paraíso\ \-\ RO",
"55153511", "Itapetininga\ \-\ SP",
"55433351", "Londrina\ \-\ PR",
"5598325", "São\ Luís\ \-\ MA",
"55433675", "Centenário\ do\ Sul\ \-\ PR",
"55733289", "Itagimirim\ \-\ BA",
"55863265", "União\ \-\ PI",
"55243325", "Barra\ Mansa\ \-\ RJ",
"55242109", "Resende\ \-\ RJ",
"55313832", "Santa\ Bárbara\ \-\ MG",
"55114826", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55313424", "Belo\ Horizonte\ \-\ MG",
"55114494", "Atibaia\ \-\ SP",
"55313896", "Pedra\ do\ Anta\ \-\ MG",
"55413601", "Pinhais\ \-\ PR",
"55224141", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55183875", "Santa\ Mercedes\ \-\ SP",
"553131", "Minas\ Gerais",
"55433464", "Mauá\ da\ Serra\ \-\ PR",
"55543282", "Canela\ \-\ RS",
"55143425", "Marília\ \-\ SP",
"55513229", "Rio\ Grande\ do\ Sul",
"55473228", "Balneário\ Camboriú\ \-\ SC",
"55513485", "Viamão\ \-\ RS",
"55613689", "Formosa\ \-\ GO",
"55643622", "Rio\ Verde\ \-\ GO",
"55313757", "Itaverava\ \-\ MG",
"55273049", "Colatina\ \-\ ES",
"55753652", "Cairu\ \-\ BA",
"55983487", "Paulino\ Neves\ \-\ MA",
"55313243", "Minas\ Gerais",
"55313730", "Minas\ Gerais",
"55853325", "Pacoti\ \-\ CE",
"55533517", "Pelotas\ \-\ RS",
"55353545", "Ibiraci\ \-\ MG",
"55173465", "Fernandópolis\ \-\ SP",
"55553431", "São\ Borja\ \-\ RS",
"55873859", "Santa\ Terezinha\ \-\ PE",
"55963084", "Macapá\ \-\ AP",
"55223829", "Laje\ do\ Muriaé\ \-\ RJ",
"55193406", "Americana\ \-\ SP",
"55113367", "São\ Paulo\ \-\ SP",
"55813476", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55793346", "Canindé\ de\ São\ Francisco\ \-\ SE",
"55443562", "Araruna\ \-\ PR",
"55983382", "Santa\ Helena\ \-\ MA",
"55383634", "Chapada\ Gaúcha\ \-\ MG",
"55473356", "Vidal\ Ramos\ \-\ SC",
"55883645", "Coreaú\ \-\ CE",
"55693443", "Cacoal\ \-\ RO",
"55513453", "Rio\ Grande\ do\ Sul",
"55143265", "Piratininga\ \-\ SP",
"55823647", "Pariconha\ \-\ AL",
"55513469", "Cachoeirinha\ \-\ RS",
"55752101", "Feira\ de\ Santana\ \-\ BA",
"55483214", "São\ José\ \-\ SC",
"55423906", "Castro\ \-\ PR",
"5511474", "Suzano\ \-\ SP",
"55643679", "Sanclerlândia\ \-\ GO",
"55473522", "Rio\ do\ Sul\ \-\ SC",
"55714003", "Salvador\ \-\ BA",
"55983878", "São\ Luís\ \-\ MA",
"55443428", "Graciosa\ \-\ PR",
"55993582", "Imperatriz\ \-\ MA",
"55542107", "Erechim\ \-\ RS",
"55173489", "Brasitânia\ \-\ SP",
"55283529", "Itapemirim\ \-\ ES",
"55113158", "São\ Paulo\ \-\ SP",
"55112803", "Carapicuíba\ \-\ SP",
"55513771", "Rio\ Grande\ do\ Sul",
"55733265", "Itororó\ \-\ BA",
"55473152", "Gaspar\ Alto\ \-\ SC",
"55863289", "São\ Gonçalo\ do\ Piauí\ \-\ PI",
"55733021", "Prado\ \-\ BA",
"55833533", "João\ Pessoa\ \-\ PB",
"55623937", "Anápolis\ \-\ GO",
"55193377", "Piracicaba\ \-\ SP",
"55343338", "Uberaba\ \-\ MG",
"55412152", "Paranaguá\ \-\ PR",
"55943428", "Rio\ Maria\ \-\ PA",
"55663597", "Nova\ Monte\ Verde\ \-\ MT",
"55483878", "Florianópolis\ \-\ SC",
"55423272", "Telêmaco\ Borba\ \-\ PR",
"55313264", "Minas\ Gerais",
"55973356", "Anamã\ \-\ AM",
"55753245", "Santo\ Estêvão\ \-\ BA",
"55833281", "Itabaiana\ \-\ PB",
"55653003", "Cuiabá\ \-\ MT",
"55983214", "São\ Luís\ \-\ MA",
"55883558", "Abaiara\ \-\ CE",
"55213227", "Rio\ de\ Janeiro\ \-\ RJ",
"55114483", "Mairiporã\ \-\ SP",
"55433224", "Santo\ Antônio\ do\ Paraíso\ \-\ PR",
"55873844", "São\ José\ do\ Egito\ \-\ PE",
"55683235", "Acrelândia\ \-\ AC",
"55513044", "Alvorada\ \-\ RS",
"55513133", "Novo\ Hamburgo\ \-\ RS",
"55733251", "Itacaré\ \-\ BA",
"55173343", "Bebedouro\ \-\ SP",
"55273224", "Vitória\ \-\ ES",
"55543546", "Faxinalzinho\ \-\ RS",
"55543011", "Farroupilha\ \-\ RS",
"55183705", "Guaraçaí\ \-\ SP",
"55823254", "São\ Luís\ do\ Quitunde\ \-\ AL",
"55213030", "Rio\ de\ Janeiro\ \-\ RJ",
"55913031", "Ananindeua\ \-\ PA",
"55483625", "Treze\ de\ Maio\ \-\ SC",
"55193667", "Mococa\ \-\ SP",
"55823295", "São\ Miguel\ dos\ Milagres\ \-\ AL",
"55733687", "Caravelas\ \-\ BA",
"55519", "Rio\ Grande\ do\ Sul",
"55613799", "Brasília\ \-\ DF",
"55833423", "Patos\ \-\ PB",
"55893498", "Lagoa\ do\ Barro\ do\ Piauí\ \-\ PI",
"55923133", "Manaus\ \-\ AM",
"55383733", "Francisco\ Dumont\ \-\ MG",
"55493634", "Iporã\ do\ Oeste\ \-\ SC",
"55193539", "Ajapi\ \-\ SP",
"55313890", "Minas\ Gerais",
"55114820", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55383841", "Salinas\ \-\ MG",
"55192104", "Campinas\ \-\ SP",
"55373322", "Formiga\ \-\ MG",
"55673241", "Aquidauana\ \-\ MS",
"55313291", "Belo\ Horizonte\ \-\ MG",
"55133203", "Santos\ \-\ SP",
"55443538", "Engenheiro\ Beltrão\ \-\ PR",
"55993634", "Lago\ do\ Junco\ \-\ MA",
"55114349", "São\ Paulo\ \-\ SP",
"55513627", "Imbé\ \-\ RS",
"55493301", "Concórdia\ \-\ SC",
"55883413", "Fortim\ \-\ CE",
"55672105", "Três\ Lagoas\ \-\ MS",
"55113438", "Santo\ André\ \-\ SP",
"55543374", "Ibiaçá\ \-\ RS",
"55413031", "Araucária\ \-\ PR",
"55323748", "Pedra\ Dourada\ \-\ MG",
"55333235", "Tumiritinga\ \-\ MG",
"55213198", "Rio\ de\ Janeiro\ \-\ RJ",
"55753697", "Serra\ Preta\ \-\ BA",
"55313736", "Desterro\ de\ Entre\ Rios\ \-\ MG",
"55873881", "Ipubi\ \-\ PE",
"55633301", "Gurupi\ \-\ TO",
"55153571", "Riversul\ \-\ SP",
"55353858", "Santana\ da\ Vargem\ \-\ MG",
"55913711", "Castanhal\ \-\ PA",
"55873791", "Palmeirina\ \-\ PE",
"5512394", "São\ José\ dos\ Campos\ \-\ SP",
"55352103", "Pouso\ Alegre\ \-\ MG",
"55193551", "Araras\ \-\ SP",
"55113515", "São\ Paulo\ \-\ SP",
"55474053", "Blumenau\ \-\ SC",
"55773414", "Jussiape\ \-\ BA",
"55733656", "Ilhéus\ \-\ BA",
"55313378", "Belo\ Horizonte\ \-\ MG",
"55493238", "Palmeira\ \-\ SC",
"55423435", "Pinho\ de\ Baixo\ \-\ PR",
"55883115", "Juazeiro\ do\ Norte\ \-\ CE",
"55273145", "Vitória\ \-\ ES",
"55123677", "Natividade\ da\ Serra\ \-\ SP",
"5538", "Minas\ Gerais",
"55313882", "Minas\ Gerais",
"55713176", "Salvador\ \-\ BA",
"55183351", "Palmital\ \-\ SP",
"55483437", "Criciúma\ \-\ SC",
"55733239", "Uruçuca\ \-\ BA",
"55333317", "Conceição\ de\ Ipanema\ \-\ MG",
"55653311", "Tangará\ da\ Serra\ \-\ MT",
"55663015", "Sinop\ \-\ MT",
"55213201", "Rio\ de\ Janeiro\ \-\ RJ",
"55613567", "Guará\ \-\ DF",
"55173874", "Macaubal\ \-\ SP",
"55323534", "Brás\ Pires\ \-\ MG",
"55143656", "Torrinha\ \-\ SP",
"55413063", "Curitiba\ \-\ PR",
"55883547", "Caririaçu\ \-\ CE",
"55543296", "Nova\ Pádua\ \-\ RS",
"55413059", "Pinhais\ \-\ PR",
"55643434", "Cachoeira\ Dourada\ \-\ GO",
"55673591", "Santa\ Rita\ do\ Pardo\ \-\ MS",
"55313541", "Nova\ Lima\ \-\ MG",
"55772102", "Vitória\ da\ Conquista\ \-\ BA",
"55543232", "Vacaria\ \-\ RS",
"55314114", "Conselheiro\ Lafaiete\ \-\ MG",
"55843397", "Umarizal\ \-\ RN",
"55343514", "Cachoeira\ Dourada\ \-\ MG",
"55513435", "Rio\ Grande\ do\ Sul",
"55613639", "Planaltina\ \-\ GO",
"55413384", "São\ José\ dos\ Pinhais\ \-\ PR",
"55343201", "Araxá\ \-\ MG",
"55173572", "Pindorama\ \-\ SP",
"55473387", "Pomerode\ \-\ SC",
"55153330", "Sorocaba\ \-\ SP",
"5549", "Santa\ Catarina",
"55333253", "Belo\ Oriente\ \-\ MG",
"55943314", "Serra\ Pelada\ \-\ PA",
"55143585", "Pirajuí\ \-\ SP",
"55613026", "Brasília\ \-\ DF",
"55143478", "Bastos\ \-\ SP",
"55773689", "Rosário\ \-\ BA",
"55473275", "Jaraguá\ do\ Sul\ \-\ SC",
"55122131", "Guaratinguetá\ \-\ SP",
"55333747", "Santo\ Antônio\ do\ Jacinto\ \-\ MG",
"55543268", "Farroupilha\ \-\ RS",
"55343812", "Lagamar\ \-\ MG",
"5563", "Tocantins",
"55383238", "Grão\ Mogol\ \-\ MG",
"55323424", "Laranjal\ \-\ MG",
"55443643", "Francisco\ Alves\ \-\ PR",
"55933517", "Creporizão\ \-\ PA",
"55483527", "Araranguá\ \-\ SC",
"55193565", "Pirassununga\ \-\ SP",
"55923194", "Manaus\ \-\ AM",
"55443540", "Bragantina\ \-\ PR",
"5511285", "São\ Paulo\ \-\ SP",
"55114039", "Campo\ Limpo\ Paulista\ \-\ SP",
"55633479", "Piraquê\ \-\ TO",
"55112506", "São\ Paulo\ \-\ SP",
"55873764", "Garanhuns\ \-\ PE",
"55433145", "Bandeirantes\ \-\ PR",
"55383755", "Morada\ Nova\ de\ Minas\ \-\ MG",
"55423334", "Maceió\ \-\ AL",
"5599", "Maranhão",
"55163352", "Ibitinga\ \-\ SP",
"55833561", "Bernardino\ Batista\ \-\ PB",
"55663471", "Alto\ Garças\ \-\ MT",
"55713417", "Salvador\ \-\ BA",
"55913485", "Tracuateua\ \-\ PA",
"55814109", "Paulista\ \-\ PE",
"55513601", "Osório\ \-\ RS",
"55493327", "Nova\ Itaberaba\ \-\ SC",
"55513747", "Arroio\ do\ Tigre\ \-\ RS",
"55543275", "Nova\ Araçá\ \-\ RS",
"55963697", "Chaves\ \-\ PA",
"55613274", "Brasília\ \-\ DF",
"55513472", "Canoas\ \-\ RS",
"55633440", "Fortaleza\ do\ Tabocão\ \-\ TO",
"55115031", "São\ Paulo\ \-\ SP",
"55673484", "Caarapó\ \-\ MS",
"55223853", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55193341", "Campinas\ \-\ SP",
"55163405", "Franca\ \-\ SP",
"55123004", "São\ José\ dos\ Campos\ \-\ SP",
"55853365", "Canindé\ \-\ CE",
"55773437", "Belo\ Campo\ \-\ BA",
"55543387", "Selbach\ \-\ RS",
"55843286", "Passagem\ \-\ RN",
"55643662", "Palestina\ de\ Goiás\ \-\ GO",
"55333334", "Manhuaçu\ \-\ MG",
"55513253", "Rio\ Grande\ do\ Sul",
"55773450", "Barra\ da\ Estiva\ \-\ BA",
"55753381", "Varzedo\ \-\ BA",
"55663513", "Sorriso\ \-\ MT",
"55833345", "Caturité\ \-\ PB",
"55333525", "Poté\ \-\ MG",
"55453259", "São\ José\ das\ Palmeiras\ \-\ PR",
"55963323", "Macapá\ \-\ AP",
"55123111", "Cunha\ \-\ SP",
"55313464", "Belo\ Horizonte\ \-\ MG",
"55513406", "Rio\ Grande\ do\ Sul",
"55212868", "Rio\ de\ Janeiro\ \-\ RJ",
"55753445", "Jandaíra\ \-\ BA",
"55482102", "Criciúma\ \-\ SC",
"55343669", "Araxá\ \-\ MG",
"55833481", "Água\ Branca\ \-\ PB",
"55273325", "Vitória\ \-\ ES",
"55733674", "Barra\ de\ Caravelas\ \-\ BA",
"55193929", "Valinhos\ \-\ SP",
"55953263", "Alto\ Alegre\ \-\ RR",
"55222541", "Nova\ Friburgo\ \-\ RJ",
"55193578", "Campinas\ \-\ SP",
"55183696", "Turiúba\ \-\ SP",
"55693424", "Ji\-Paraná\ \-\ RO",
"55114531", "Jundiaí\ \-\ SP",
"55643417", "Morrinhos\ \-\ GO",
"55313351", "Contagem\ \-\ MG",
"55893557", "Nazaré\ do\ Piauí\ \-\ PI",
"55773618", "Cristópolis\ \-\ BA",
"55843248", "Senador\ Georgino\ Avelino\ \-\ RN",
"5561325", "Brasília\ \-\ DF",
"55193384", "Campinas\ \-\ SP",
"55343427", "Planura\ \-\ MG",
"55623098", "Anápolis\ \-\ GO",
"55114421", "Santo\ André\ \-\ SP",
"55534001", "Pelotas\ \-\ RS",
"55462101", "Pato\ Branco\ \-\ PR",
"55943337", "Brejo\ Grande\ do\ Araguaia\ \-\ PA",
"55673441", "Nova\ Andradina\ \-\ MS",
"55313491", "Minas\ Gerais",
"55693534", "Alto\ Paraíso\ \-\ RO",
"55433534", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55753344", "Palmeiras\ \-\ BA",
"55212682", "Seropédica\ \-\ RJ",
"55313828", "Minas\ Gerais",
"55123893", "São\ Sebastião\ \-\ SP",
"55243351", "Itatiaia\ \-\ RJ",
"55153547", "Guapiara\ \-\ SP",
"55623527", "Araçu\ \-\ GO",
"55923317", "Autazes\ \-\ AM",
"55153115", "Boituva\ \-\ SP",
"55863343", "Piracuruca\ \-\ PI",
"55833444", "São\ Bento\ \-\ PB",
"55333435", "Coluna\ \-\ MG",
"55612099", "Brasília\ \-\ DF",
"55193801", "Indaiatuba\ \-\ SP",
"55933534", "Prainha\ \-\ PA",
"55222668", "Silva\ Jardim\ \-\ RJ",
"55853351", "Trairi\ \-\ CE",
"55273757", "Ponto\ Belo\ \-\ ES",
"55313049", "Contagem\ \-\ MG",
"55983689", "Zé\ Doca\ \-\ MA",
"55853464", "Fortaleza\ \-\ CE",
"55163304", "Araraquara\ \-\ SP",
"55212730", "Rio\ de\ Janeiro\ \-\ RJ",
"55743639", "Várzea\ do\ Poço\ \-\ BA",
"55453029", "Foz\ do\ Iguaçu\ \-\ PR",
"55463245", "Honório\ Serpa\ \-\ PR",
"55613487", "Sobradinho\ \-\ DF",
"55112535", "São\ Paulo\ \-\ SP",
"55143451", "Marília\ \-\ SP",
"55962101", "Macapá\ \-\ AP",
"55423235", "Ponta\ Grossa\ \-\ PR",
"55633438", "Recursolândia\ \-\ TO",
"55353064", "Poços\ de\ Caldas\ \-\ MG",
"55133375", "Cubatão\ \-\ SP",
"55193031", "Campinas\ \-\ SP",
"55473546", "Laurentino\ \-\ SC",
"55623382", "Fazenda\ Nova\ \-\ GO",
"55883571", "Juazeiro\ do\ Norte\ \-\ CE",
"55273076", "Cariacica\ \-\ ES",
"55163236", "Ribeirão\ Preto\ \-\ SP",
"55623878", "Goiânia\ \-\ GO",
"55513758", "Capitão\ \-\ RS",
"55183264", "Iepê\ \-\ SP",
"55113301", "São\ Paulo\ \-\ SP",
"55113171", "São\ Paulo\ \-\ SP",
"55833035", "João\ Pessoa\ \-\ PB",
"55313577", "Minas\ Gerais",
"55543519", "Erechim\ \-\ RS",
"55163663", "Jardinópolis\ \-\ SP",
"55843644", "Parnamirim\ \-\ RN",
"55793322", "Propriá\ \-\ SE",
"55493438", "Ipumirim\ \-\ SC",
"55163659", "Brodowski\ \-\ SP",
"55473374", "Schroeder\ \-\ SC",
"55532126", "Rio\ Grande\ \-\ RS",
"55913412", "Castanhal\ \-\ PA",
"55743651", "Capim\ Grosso\ \-\ BA",
"55553533", "São\ Martinho\ \-\ RS",
"55413539", "Campo\ Largo\ \-\ PR",
"55333627", "Machacalis\ \-\ MG",
"55223835", "Carabuçu\ \-\ RJ",
"55153297", "Araçoiaba\ da\ Serra\ \-\ SP",
"55613456", "Taguatinga\ \-\ DF",
"55733512", "Eunápolis\ \-\ BA",
"55713369", "Lauro\ de\ Freitas\ \-\ BA",
"55853339", "Palmácia\ \-\ CE",
"55553281", "Caçapava\ do\ Sul\ \-\ RS",
"55613368", "Brasília\ \-\ DF",
"55413667", "Pinhais\ \-\ PR",
"5513345", "Peruíbe\ \-\ SP",
"55453231", "Santa\ Tereza\ do\ Oeste\ \-\ PR",
"55543468", "Pinto\ Bandeira\ \-\ RS",
"55713493", "Camaçari\ \-\ BA",
"55843230", "Nísia\ Floresta\ \-\ RN",
"55823202", "Maceió\ \-\ AL",
"55153558", "Apiaí\ \-\ SP",
"55112887", "Itaquaquecetuba\ \-\ SP",
"55173553", "São\ João\ de\ Itaguaçu\ \-\ SP",
"55353449", "Pouso\ Alegre\ \-\ MG",
"55543356", "Barracão\ \-\ RS",
"55323224", "Juiz\ de\ Fora\ \-\ MG",
"55743665", "Jacobina\ \-\ BA",
"55843257", "Lagoa\ Salgada\ \-\ RN",
"55115063", "São\ Paulo\ \-\ SP",
"55933593", "Altamira\ \-\ PA",
"55472107", "Jaraguá\ do\ Sul\ \-\ SC",
"55553423", "Quaraí\ \-\ RS",
"55443624", "Umuarama\ \-\ PR",
"55443482", "Paranavaí\ \-\ PR",
"5551320", "Rio\ Grande\ do\ Sul",
"55513589", "São\ Leopoldo\ \-\ RS",
"55543522", "Erechim\ \-\ RS",
"55773625", "Santa\ Rita\ de\ Cássia\ \-\ BA",
"55613332", "Recanto\ das\ Emas\ \-\ DF",
"55143529", "Lins\ \-\ SP",
"55143278", "Lençóis\ Paulista\ \-\ SP",
"55173637", "Guzolândia\ \-\ SP",
"55793319", "Gracho\ Cardoso\ \-\ SE",
"55183991", "Mirante\ do\ Paranapanema\ \-\ SP",
"55533264", "Praia\ do\ Hermenegildo\ \-\ RS",
"55913429", "Viseu\ \-\ PA",
"55493279", "Rio\ Rufino\ \-\ SC",
"55823276", "Jequiá\ da\ Praia\ \-\ AL",
"55313339", "Belo\ Horizonte\ \-\ MG",
"55123834", "Ubatuba\ \-\ SP",
"55553244", "Santana\ do\ Livramento\ \-\ RS",
"55623625", "Aparecida\ de\ Goiânia\ \-\ GO",
"55733278", "Wenceslau\ Guimarães\ \-\ BA",
"55643543", "Cezarina\ \-\ GO",
"55143814", "Botucatu\ \-\ SP",
"55115212", "São\ Paulo\ \-\ SP",
"55643640", "Lagoa\ Santa\ \-\ GO",
"55193827", "Artur\ Nogueira\ \-\ SP",
"55113240", "Salvador\ \-\ BA",
"55473643", "Mafra\ \-\ SC",
"55212108", "Rio\ de\ Janeiro\ \-\ RJ",
"55212632", "Guapimirim\ \-\ RJ",
"55333341", "Manhumirim\ \-\ MG",
"55163831", "Guará\ \-\ SP",
"55833521", "Sousa\ \-\ PB",
"55553308", "Ijuí\ \-\ RS",
"55653347", "Assari\ \-\ MT",
"55183325", "Assis\ \-\ SP",
"55493367", "Sul\ Brasil\ \-\ SC",
"55163957", "Ibitiúva\ \-\ SP",
"55123962", "Jacareí\ \-\ SP",
"55353454", "Espírito\ Santo\ do\ Dourado\ \-\ MG",
"55483256", "Anitápolis\ \-\ SC",
"55353361", "Itanhandu\ \-\ MG",
"55163257", "Cândido\ Rodrigues\ \-\ SP",
"55115044", "São\ Paulo\ \-\ SP",
"55633367", "Tocantínia\ \-\ TO",
"55313628", "Ribeirão\ das\ Neves\ \-\ MG",
"55212882", "Nova\ Iguaçu\ \-\ RJ",
"55813671", "Ribeirão\ \-\ PE",
"55373201", "Itaúna\ \-\ MG",
"55193601", "Americana\ \-\ SP",
"55643688", "Jaupaci\ \-\ GO",
"55143572", "Pirajuí\ \-\ SP",
"55114302", "São\ Paulo\ \-\ SP",
"55533243", "Dom\ Pedrito\ \-\ RS",
"55773274", "Macarani\ \-\ BA",
"55212780", "Mangaratiba\ \-\ RJ",
"55413472", "Guaratuba\ \-\ PR",
"55673524", "Três\ Lagoas\ \-\ MS",
"55323464", "Estrela\ Dalva\ \-\ MG",
"55663504", "União\ do\ Norte\ \(Antiga\ Lenislândia\)\ \-\ MT",
"55443275", "Barbosa\ Ferraz\ \-\ PR",
"55222534", "Duas\ Barras\ \-\ RJ",
"55713622", "Camaçari\ \-\ BA",
"55683212", "Rio\ Branco\ \-\ AC",
"55323351", "Barroso\ \-\ MG",
"55883511", "Juazeiro\ do\ Norte\ \-\ CE",
"55553259", "Mata\ \-\ RS",
"55553263", "Faxinal\ do\ Soturno\ \-\ RS",
"55153252", "Torre\ de\ Pedra\ \-\ SP",
"5511482", "Ribeirão\ Pires\ \-\ SP",
"55513565", "Nova\ Hartz\ \-\ RS",
"55212016", "Rio\ de\ Janeiro\ \-\ RJ",
"55383677", "Unaí\ \-\ MG",
"55843373", "Rodolfo\ Fernandes\ \-\ RN",
"55114018", "Pinhalzinho\ \-\ SP",
"55123013", "Guaratinguetá\ \-\ SP",
"55643564", "Anicuns\ \-\ GO",
"55113988", "Guarulhos\ \-\ SP",
"55753331", "Seabra\ \-\ BA",
"55813361", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55964009", "Macapá\ \-\ AP",
"55843236", "Natal\ \-\ RN",
"55433016", "Rolândia\ \-\ PR",
"55214117", "Nova\ Iguaçu\ \-\ RJ",
"55383222", "Montes\ Claros\ \-\ MG",
"55433541", "Uraí\ \-\ PR",
"55673434", "Sanga\ Puitã\ \-\ MS",
"55693541", "Guajará\-Mirim\ \-\ RO",
"55283535", "Presidente\ Kennedy\ \-\ ES",
"55742102", "Juazeiro\ \-\ BA",
"55643591", "Itumbiara\ \-\ GO",
"55463549", "Realeza\ \-\ PR",
"55843292", "Tangará\ \-\ RN",
"55323365", "Santa\ Bárbara\ do\ Tugúrio\ \-\ MG",
"55373514", "Abaeté\ \-\ MG",
"55543337", "Estação\ \-\ RS",
"55374141", "Divinópolis\ \-\ MG",
"55813495", "Olinda\ \-\ PE",
"55973415", "Benjamin\ Constant\ \-\ AM",
"55823216", "Maceió\ \-\ AL",
"55663211", "Sinop\ \-\ MT",
"55843663", "Natal\ \-\ RN",
"55813454", "Recife\ \-\ PE",
"55513551", "Estância\ Velha\ \-\ RS",
"55153022", "Tatuí\ \-\ SP",
"55434001", "Londrina\ \-\ PR",
"55212668", "Nova\ Iguaçu\ \-\ RJ",
"55143218", "Bauru\ \-\ SP",
"55342108", "Araguari\ \-\ MG",
"55613618", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55343853", "Tiros\ \-\ MG",
"55114666", "Itapecerica\ da\ Serra\ \-\ SP",
"55823270", "Maribondo\ \-\ AL",
"55222757", "Macaé\ \-\ RJ",
"55493677", "Itapiranga\ \-\ SC",
"55893580", "Dom\ Inocêncio\ \-\ PI",
"55114233", "São\ Caetano\ do\ Sul\ \-\ SP",
"55753604", "Feira\ de\ Santana\ \-\ BA",
"55533325", "Pelotas\ \-\ RS",
"55423551", "Santana\ \-\ PR",
"55333212", "Governador\ Valadares\ \-\ MG",
"55833431", "Pombal\ \-\ PB",
"55115906", "São\ Paulo\ \-\ SP",
"55313875", "Santa\ Margarida\ \-\ MG",
"55694001", "Porto\ Velho\ \-\ RO",
"55383721", "Curvelo\ \-\ MG",
"55613382", "Guará\ \-\ DF",
"55512104", "Porto\ Alegre\ \-\ RS",
"55513539", "Novo\ Hamburgo\ \-\ RS",
"55843631", "Macaíba\ \-\ RN",
"55923667", "Manaus\ \-\ AM",
"55313615", "Belo\ Horizonte\ \-\ MG",
"55633446", "Sítio\ Novo\ do\ Tocantins\ \-\ TO",
"55913758", "Cachoeira\ do\ Arari\ \-\ PA",
"55173251", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55853924", "Fortaleza\ \-\ CE",
"55112687", "São\ Paulo\ \-\ SP",
"55443432", "Nova\ Londrina\ \-\ PR",
"55183786", "Sud\ Mennucci\ \-\ SP",
"55112837", "São\ Paulo\ \-\ SP",
"55773456", "Urandi\ \-\ BA",
"55983474", "Duque\ Bacelar\ \-\ MA",
"55493446", "Lindóia\ do\ Sul\ \-\ SC",
"55513667", "Três\ Cachoeiras\ \-\ RS",
"55114762", "Mogi\ das\ Cruzes\ \-\ SP",
"55123301", "Lorena\ \-\ SP",
"55613878", "Brasília\ \-\ DF",
"55442031", "Umuarama\ \-\ PR",
"55173837", "Sebastianópolis\ do\ Sul\ \-\ SP",
"55453281", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55323577", "Rodeiro\ \-\ MG",
"55113596", "São\ Paulo\ \-\ SP",
"55423412", "Mato\ Branco\ de\ Baixo\ \-\ PR",
"55712203", "Salvador\ \-\ BA",
"55663573", "Paranatinga\ \-\ MT",
"55643941", "Itumbiara\ \-\ GO",
"55833459", "Nova\ Olinda\ \-\ PB",
"55143343", "Canitar\ \-\ SP",
"55833463", "Taperoá\ \-\ PB",
"55893536", "Flores\ do\ Piauí\ \-\ PI",
"55114025", "Itu\ \-\ SP",
"55513400", "Rio\ Grande\ do\ Sul",
"55123634", "Taubaté\ \-\ SP",
"55753208", "Campinhos\ \-\ BA",
"55343267", "Centralina\ \-\ MG",
"55353701", "Alfenas\ \-\ MG",
"55273264", "Linhares\ \-\ ES",
"55423667", "Inácio\ Martins\ \-\ PR",
"55112752", "São\ Paulo\ \-\ SP",
"55114961", "Itupeva\ \-\ SP",
"55943432", "Floresta\ do\ Araguaia\ \-\ PA",
"55373227", "Nova\ Serrana\ \-\ MG",
"55213835", "Rio\ de\ Janeiro\ \-\ RJ",
"55613214", "Brasília\ \-\ DF",
"55623456", "Divinópolis\ de\ Goiás\ \-\ GO",
"55933736", "Munguba\ \-\ PA",
"55343322", "Uberaba\ \-\ MG",
"55793635", "Lagarto\ \-\ SE",
"55313389", "Belo\ Horizonte\ \-\ MG",
"55553796", "Alpestre\ \-\ RS",
"55133851", "Cananéia\ \-\ SP",
"55623396", "Itaguari\ \-\ GO",
"55843405", "Currais\ Novos\ \-\ RN",
"55163986", "Luís\ Antônio\ \-\ SP",
"55163114", "Araraquara\ \-\ SP",
"55213267", "Rio\ de\ Janeiro\ \-\ RJ",
"55973428", "Maraã\ \-\ AM",
"55353333", "Soledade\ de\ Minas\ \-\ MG",
"55114255", "Mogi\ das\ Cruzes\ \-\ SP",
"5531378", "Minas\ Gerais",
"55613501", "Planaltina\ \-\ DF",
"55193453", "Limeira\ \-\ SP",
"55623332", "Silvânia\ \-\ GO",
"55733225", "Igrapiúna\ \-\ BA",
"55483287", "Florianópolis\ \-\ SC",
"55163286", "Ribeirão\ Preto\ \-\ SP",
"55943356", "Parauapebas\ \-\ PA",
"55712136", "Salvador\ \-\ BA",
"55833399", "Massaranduba\ \-\ PB",
"55153305", "Tatuí\ \-\ SP",
"55163859", "Orlândia\ \-\ SP",
"55343835", "Cruzeiro\ da\ Fortaleza\ \-\ MG",
"55633488", "Praia\ Norte\ \-\ TO",
"55183748", "Ilha\ Solteira\ \-\ SP",
"55453244", "Missal\ \-\ PR",
"55893426", "Geminiano\ \-\ PI",
"55243389", "Barra\ Mansa\ \-\ RJ",
"55473562", "Taió\ \-\ SC",
"55212792", "Nilópolis\ \-\ RJ",
"55313443", "Minas\ Gerais",
"55283569", "Ibitirama\ \-\ ES",
"55143713", "Paranapanema\ \-\ SP",
"55983651", "Araguanã\ \-\ MA",
"55283553", "Guaçuí\ \-\ ES",
"55173265", "José\ Bonifácio\ \-\ SP",
"55553231", "Rosário\ do\ Sul\ \-\ RS",
"55323339", "Barbacena\ \-\ MG",
"55553931", "Santo\ Ângelo\ \-\ RS",
"55414122", "Curitiba",
"55413589", "Piraquara\ \-\ PR",
"55863131", "Teresina\ \-\ PI",
"55443522", "Goioerê\ \-\ PR",
"55993575", "Graça\ Aranha\ \-\ MA",
"55273736", "Laranja\ da\ Terra\ \-\ ES",
"55114738", "Mogi\ das\ Cruzes\ \-\ SP",
"55613625", "Cidade\ Ocidental\ \-\ GO",
"55513429", "Canoas\ \-\ RS",
"55473428", "Dona\ Francisca\ SC\ 301\ \-\ SC",
"55513285", "Rio\ Grande\ do\ Sul",
"55113422", "São\ Caetano\ do\ Sul\ \-\ SP",
"55122123", "Taubaté\ \-\ SP",
"55143489", "Iacri\ \-\ SP",
"55773678", "Botuporã\ \-\ BA",
"55222748", "Travessão\ \-\ RJ",
"55513460", "Esteio\ \-\ RS",
"55513056", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55114201", "Barueri\ \-\ SP",
"55493249", "Campo\ Belo\ do\ Sul\ \-\ SC",
"55943787", "Tucuruí\ \-\ PA",
"55753268", "Teofilândia\ \-\ BA",
"55673258", "Taunay\ \-\ MS",
"55382103", "Montes\ Claros\ \-\ MG",
"55373544", "Cedro\ do\ Abaeté\ \-\ MG",
"55854007", "Maracanaú\ \-\ CE",
"55443652", "Iporã\ \-\ PR",
"55863304", "Teresina\ \-\ PI",
"55993321", "Imperatriz\ \-\ MA",
"55323252", "Santos\ Dumont\ \-\ MG",
"55433511", "Jacarezinho\ \-\ PR",
"5568322", "Rio\ Branco\ \-\ AC",
"55683311", "Cruzeiro\ do\ Sul\ \-\ AC",
"55983521", "Caxias\ \-\ MA",
"55433046", "Arapongas\ \-\ PR",
"55283520", "Piúma\ \-\ ES",
"55333741", "Jequitinhonha\ \-\ MG",
"55733248", "Itapé\ \-\ BA",
"55183913", "Montalvão\ \-\ SP",
"55114812", "Campo\ Limpo\ Paulista\ \-\ SP",
"55353013", "Lavras\ \-\ MG",
"55643573", "Itumbiara\ \-\ GO",
"55843364", "Olho\-D\'Água\ do\ Borges\ \-\ RN",
"5535", "Minas\ Gerais",
"55163343", "Ibaté\ \-\ SP",
"55833639", "Riachão\ \-\ PB",
"55323751", "Tombos\ \-\ MG",
"55483521", "Araranguá\ \-\ SC",
"55333242", "São\ João\ do\ Manteninha\ \-\ MG",
"55863280", "São\ Pedro\ do\ Piauí\ \-\ PI",
"5563321", "Palmas\ \-\ TO",
"55633321", "Araguaína\ \-\ TO",
"55423460", "Teixeira\ Soares\ \-\ PR",
"55353327", "Carrancas\ \-\ MG",
"55883584", "Orós\ \-\ CE",
"55312106", "Sete\ Lagoas\ \-\ MG",
"55113184", "Osasco\ \-\ SP",
"55213626", "Rio\ de\ Janeiro\ \-\ RJ",
"55713649", "Camaçari\ \-\ BA",
"55833256", "Alhandra\ \-\ PB",
"55623959", "Niquelândia\ \-\ GO",
"55114702", "Cotia\ \-\ SP",
"55813755", "Tacaimbó\ \-\ PE",
"55883668", "Senador\ Sá\ \-\ CE",
"55212088", "São\ Gonçalo\ \-\ RJ",
"55833567", "Cabedelo\ \-\ PB",
"5517323", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55212380", "Rio\ de\ Janeiro\ \-\ RJ",
"55353693", "Pouso\ Alegre\ \-\ MG",
"55493321", "Chapecó\ \-\ SC",
"55513607", "Rio\ Grande\ do\ Sul",
"55793455", "São\ Domingos\ \-\ SE",
"55623636", "Goiânia\ \-\ GO",
"55473445", "Garuva\ \-\ SC",
"55473344", "Itajaí\ \-\ SC",
"55193557", "Rio\ Claro\ \-\ SP",
"55793354", "Gararu\ \-\ SE",
"55733286", "Itapebi\ \-\ BA",
"55163489", "Serrana\ \-\ SP",
"55893485", "Isaías\ Coelho\ \-\ PI",
"55213039", "Nilópolis\ \-\ RJ",
"55893578", "Gilbués\ \-\ PI",
"55883696", "Monsenhor\ Tabosa\ \-\ CE",
"55193883", "Sumaré\ \-\ SP",
"5581", "Pernambuco",
"55242106", "Barra\ Mansa\ \-\ RJ",
"55373233", "Pará\ de\ Minas\ \-\ MG",
"55313899", "Viçosa\ \-\ MG",
"55123671", "São\ Luís\ do\ Paraitinga\ \-\ SP",
"55883632", "Viçosa\ do\ Ceará\ \-\ CE",
"55813761", "Garanhuns\ \-\ PE",
"55823288", "Quebrangulo\ \-\ AL",
"55793461", "Pinhão\ \-\ SE",
"55314007", "Belo\ Horizonte\ \-\ MG",
"55133481", "Praia\ Grande\ \-\ SP",
"55193966", "Conchal\ \-\ SP",
"55483431", "Quarta\ Linha\ \-\ SC",
"55673028", "Campo\ Grande\ \-\ MS",
"5521386", "Rio\ de\ Janeiro\ \-\ RJ",
"55114048", "Diadema\ \-\ SP",
"55153491", "Salto\ de\ Pirapora\ \-\ SP",
"55613561", "Taguatinga\ \-\ DF",
"55653023", "Cuiabá\ \-\ MT",
"55213207", "Rio\ de\ Janeiro\ \-\ RJ",
"55813693", "Xexéu\ \-\ PE",
"55883541", "Várzea\ Alegre\ \-\ CE",
"55683242", "Rio\ Branco\ \-\ AC",
"55143286", "Lucianópolis\ \-\ SP",
"55383321", "Montes\ Claros\ \-\ MG",
"55843391", "Martins\ \-\ RN",
"55313547", "Minas\ Gerais",
"55433904", "Cornélio\ Procópio\ \-\ PR",
"55843674", "Natal\ \-\ RN",
"5515301", "Sorocaba\ \-\ SP",
"55753296", "Sítio\ do\ Quinto\ \-\ BA",
"55873856", "Tupanatinga\ \-\ PE",
"55543017", "Veranópolis\ \-\ RS",
"55193586", "Itirapina\ \-\ SP",
"55833474", "Maturéia\ \-\ PB",
"55733257", "Nilo\ Peçanha\ \-\ BA",
"55242255", "Três\ Rios\ \-\ RJ",
"55663564", "Confresa\ \-\ MT",
"55483463", "Forquilhinha\ \-\ SC",
"55823422", "Cacimbinhas\ \-\ AL",
"55373261", "Lagoa\ da\ Prata\ \-\ MG",
"55193661", "Espírito\ Santo\ do\ Pinhal\ \-\ SP",
"55813733", "Taquaritinga\ do\ Norte\ \-\ PE",
"55733230", "Ubaitaba\ \-\ BA",
"55753011", "Feira\ de\ Santana\ \-\ BA",
"55913466", "Marudá\ \-\ PA",
"55643504", "Americano\ do\ Brasil\ \-\ GO",
"55273273", "Sooretama\ \-\ ES",
"55433336", "Londrina\ \-\ PR",
"55213483", "Rio\ de\ Janeiro\ \-\ RJ",
"55343820", "Patos\ de\ Minas\ \-\ MG",
"55673247", "Costa\ Rica\ \-\ MS",
"55343221", "Uberlândia\ \-\ MG",
"55112352", "São\ Paulo\ \-\ SP",
"55843278", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55513621", "Capão\ Novo\ \-\ RS",
"55333426", "Dores\ de\ Guanhães\ \-\ MG",
"55213809", "Rio\ de\ Janeiro\ \-\ RJ",
"55114166", "Barueri\ \-\ SP",
"55413358", "São\ José\ dos\ Pinhais\ \-\ PR",
"55673471", "Iguatemi\ \-\ MS",
"55132138", "Santos\ \-\ SP",
"55653235", "Figueirópolis\ D\'Oeste\ \-\ MT",
"55983463", "Itapecuru\ Mirim\ \-\ MA",
"5519346", "Americana\ \-\ SP",
"55163506", "Matão\ \-\ SP",
"55153577", "Barra\ do\ Turvo\ \-\ SP",
"55113383", "São\ Paulo\ \-\ SP",
"55613981", "Formosa\ \-\ GO",
"55433132", "Cornélio\ Procópio\ \-\ PR",
"55613533", "Brasília\ \-\ DF",
"55543323", "Nova\ Alvorada\ \-\ RS",
"55873887", "Orocó\ \-\ PE",
"55353301", "Poços\ de\ Caldas\ \-\ MG",
"55273132", "Vitória\ \-\ ES",
"55983399", "Mirinzal\ \-\ MA",
"55444009", "Maringá\ \-\ PR",
"55753475", "Porto\ de\ Sauipe\ \-\ BA",
"55212608", "Niterói\ \-\ RJ",
"55212132", "Rio\ de\ Janeiro\ \-\ RJ",
"55153339", "Sorocaba\ \-\ SP",
"55823641", "Delmiro\ Gouveia\ \-\ AL",
"55114606", "Várzea\ Paulista\ \-\ SP",
"55553332", "Ijuí\ \-\ RS",
"55733313", "Ipiaú\ \-\ BA",
"55333536", "Teófilo\ Otoni\ \-\ MG",
"55353841", "Bom\ Sucesso\ \-\ MG",
"55313128", "Jaboticatubas\ \-\ MG",
"55843439", "Bodó\ \-\ RN",
"55313645", "Vespasiano\ \-\ MG",
"55542101", "Caxias\ do\ Sul\ \-\ RS",
"55353733", "Ibitiúra\ de\ Minas\ \-\ MG",
"55753664", "Taperoá\ \-\ BA",
"55813634", "Surubim\ \-\ PE",
"55513777", "Putinga\ \-\ RS",
"55113449", "Osasco\ \-\ SP",
"5551353", "Rio\ Grande\ do\ Sul",
"55814112", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55313558", "Mariana\ \-\ MG",
"55143644", "Igaraçu\ do\ Tietê\ \-\ SP",
"55513442", "Alvorada\ \-\ RS",
"55633470", "Santa\ Fé\ do\ Araguaia\ \-\ TO",
"55433273", "Miraselva\ \-\ PR",
"55863292", "Amarante\ \-\ PI",
"55623931", "Goiânia\ \-\ GO",
"55193371", "Piracicaba\ \-\ SP",
"55623583", "Goiânia\ \-\ GO",
"55483085", "Florianópolis\ \-\ SC",
"55833287", "Mari\ \-\ PB",
"55183571", "Flórida\ Paulista\ \-\ SP",
"55953625", "Boa\ Vista\ \-\ RR",
"55433452", "Borrazópolis\ \-\ PR",
"55913821", "Peixe\-Boi\ \-\ PA",
"55213820", "Rio\ de\ Janeiro\ \-\ RJ",
"55143313", "Bauru\ \-\ SP",
"55833375", "Pedra\ Lavrada\ \-\ PB",
"55213221", "Rio\ de\ Janeiro\ \-\ RJ",
"55623594", "Aparecida\ de\ Goiânia\ \-\ GO",
"55633658", "Aurora\ do\ Tocantins\ \-\ TO",
"55733292", "Teixeira\ de\ Freitas\ \-\ BA",
"55883424", "Tabuleiro\ do\ Norte\ \-\ CE",
"55983345", "Rosário\ \-\ MA",
"55483053", "Tubarão\ \-\ SC",
"55193683", "Santa\ Cruz\ das\ Palmeiras\ \-\ SP",
"55333734", "Itaobim\ \-\ MG",
"55613012", "Brasília\ \-\ DF",
"55613308", "Planaltina\ \-\ DF",
"55213089", "Rio\ de\ Janeiro\ \-\ RJ",
"55413607", "Araucária\ \-\ PR",
"55673411", "Dourados\ \-\ MS",
"55893435", "Francisco\ Macedo\ \-\ PI",
"55193833", "Paulínia\ \-\ SP",
"55993545", "São\ Domingos\ do\ Azeitão\ \-\ MA",
"55343826", "Patos\ de\ Minas\ \-\ MG",
"55753643", "Valença\ \-\ BA",
"55493658", "Tigrinhos\ \-\ SC",
"55343455", "Carneirinho\ \-\ MG",
"55773648", "Novo\ Horizonte\ \-\ BA",
"55733236", "Una\ \-\ BA",
"55222778", "Casimiro\ de\ Abreu\ \-\ RJ",
"55493545", "Abdon\ Batista\ \-\ SC",
"55613263", "Brasília\ \-\ DF",
"55853022", "Fortaleza\ \-\ CE",
"55163512", "Ribeirão\ Preto\ \-\ SP",
"55115855", "São\ Paulo\ \-\ SP",
"55273213", "Cariacica\ \-\ ES",
"55443554", "Assis\ Chateaubriand\ \-\ PR",
"55313751", "Entre\ Rios\ de\ Minas\ \-\ MG",
"55143292", "Pederneiras\ \-\ SP",
"55413056", "Pinhais\ \-\ PR",
"55993117", "Timon\ \-\ MA",
"55213779", "Nova\ Iguaçu\ \-\ RJ",
"55163603", "Ribeirão\ Preto\ \-\ SP",
"55983481", "Anapurus\ \-\ MA",
"55333298", "Açucena\ \-\ MG",
"55873939", "Flores\ \-\ PE",
"55613636", "Cabeceiras\ \-\ GO",
"55113361", "São\ Paulo\ \-\ SP",
"55273725", "Itaguaçu\ \-\ ES",
"55123184", "Cruzeiro\ \-\ SP",
"55112623", "São\ Paulo\ \-\ SP",
"55753282", "Paulo\ Afonso\ \-\ BA",
"55453274", "Toledo\ \-\ PR",
"55613963", "Brasília\ \-\ DF",
"55483345", "Tijucas\ \-\ SC",
"55823013", "Maceió\ \-\ AL",
"55143103", "Bauru\ \-\ SP",
"55833315", "Campina\ Grande\ \-\ PB",
"55143373", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"5582", "Alagoas",
"5521310", "Rio\ de\ Janeiro\ \-\ RJ",
"55533204", "Rio\ Grande\ \-\ RS",
"55633402", "Araguaína\ \-\ TO",
"55333266", "Quatituba\ \-\ MG",
"55773686", "Serra\ Dourada\ \-\ BA",
"55933062", "Santarém\ \-\ PA",
"55313765", "Minas\ Gerais",
"55193311", "Jaguariúna\ \-\ SP",
"55693913", "Guajará\-Mirim\ \-\ RO",
"55513717", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55343354", "Santa\ Juliana\ \-\ MG",
"55163704", "Franca\ \-\ SP",
"5511347", "São\ Paulo\ \-\ SP",
"55633476", "Colinas\ do\ Tocantins\ \-\ TO",
"55973331", "Lábrea\ \-\ AM",
"55643447", "Corumbaíba\ \-\ GO",
"55114036", "Piracaia\ \-\ SP",
"55823262", "Messias\ \-\ AL",
"55373421", "Luz\ \-\ MG",
"55623561", "Caldazinha\ \-\ GO",
"55114092", "Diadema\ \-\ SP",
"55143764", "Iaras\ \-\ SP",
"55383545", "Presidente\ Kubitschek\ \-\ MG",
"55213826", "Rio\ de\ Janeiro\ \-\ RJ",
"55433062", "Cambé\ \-\ PR",
"55273357", "Vitória\ \-\ ES",
"55123141", "Cruzeiro\ \-\ SP",
"55473359", "Botuverá\ \-\ SC",
"55822123", "Maceió\ \-\ AL",
"55793349", "Porto\ da\ Folha\ \-\ SE",
"55813684", "São\ Benedito\ do\ Sul\ \-\ PE",
"55473363", "Balneário\ Camboriú\ \-\ SC",
"55843225", "Genipabu\ \-\ RN",
"55843061", "Mossoró\ \-\ RN",
"55413621", "Colombo\ \-\ PR",
"55114806", "Jundiaí\ \-\ SP",
"55773657", "Tabocas\ do\ Brejo\ Velho\ \-\ BA",
"55423909", "Palmeira\ \-\ PR",
"55493647", "Palmitos\ \-\ SC",
"55513466", "Canoas\ \-\ RS",
"55683548", "Assis\ Brasil\ \-\ AC",
"55473084", "Jaraguá\ do\ Sul\ \-\ SC",
"55383254", "Itacambira\ \-\ MG",
"55643676", "Cachoeira\ de\ Goiás\ \-\ GO",
"55353641", "Brasópolis\ \-\ MG",
"55443323", "Colorado\ \-\ PR",
"55624104", "Goiânia\ \-\ GO",
"55273182", "Vitória\ \-\ ES",
"55115833", "São\ Paulo\ \-\ SP",
"55513037", "São\ Leopoldo\ \-\ RS",
"55283526", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55313845", "Jaguaraçu\ \-\ MG",
"55223051", "Macaé\ \-\ RJ",
"55173486", "Álvares\ Florence\ \-\ SP",
"55643610", "Mineiros\ \-\ GO",
"5511256", "São\ Paulo\ \-\ SP",
"55193894", "Indaiatuba\ \-\ SP",
"55143844", "Pratânia\ \-\ SP",
"55943323", "Marabá\ \-\ PA",
"55643513", "Caldas\ Novas\ \-\ GO",
"55853305", "Fortaleza\ \-\ CE",
"55193855", "Socorro\ \-\ SP",
"55473908", "Itajaí\ \-\ SC",
"55353532", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55443017", "Campo\ Mourão\ \-\ PR",
"55893453", "Pio\ Ix\ \-\ PI",
"55433571", "Siqueira\ Campos\ \-\ PR",
"55114716", "São\ João\ Novo\ \-\ SP",
"55312112", "Belo\ Horizonte\ \-\ MG",
"55643602", "Rio\ Verde\ \-\ GO",
"5541342", "Paranaguá\ \-\ PR",
"55483035", "São\ José\ \-\ SC",
"55624011", "Goiânia\ \-\ GO",
"55183273", "Álvares\ Machado\ \-\ SP",
"55623981", "Aparecida\ de\ Goiânia\ \-\ GO",
"55143405", "Pompéia\ \-\ SP",
"5511505", "São\ Paulo\ \-\ SP",
"55623533", "Goiânia\ \-\ GO",
"55993647", "Igarapé\ Grande\ \-\ MA",
"5511412", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55793221", "Aracaju\ \-\ SE",
"55213620", "Niterói\ \-\ RJ",
"55913621", "Caiçava\ \-\ PA",
"5511592", "São\ Paulo\ \-\ SP",
"55942101", "Marabá\ \-\ PA",
"55813641", "Vicência\ \-\ PE",
"55312559", "Contagem\ \-\ MG",
"55143542", "Promissão\ \-\ SP",
"55813419", "Recife\ \-\ PE",
"55213433", "Rio\ de\ Janeiro\ \-\ RJ",
"55193592", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55114142", "Itapevi\ \-\ SP",
"55843614", "Natal\ \-\ RN",
"55493254", "Ponte\ Alta\ do\ Norte\ \-\ SC",
"55353834", "Aguanil\ \-\ MG",
"55413442", "Guaratuba\ \-\ PR",
"55193861", "Mogi\-Guaçu\ \-\ SP",
"55443245", "Mandaguaçu\ \-\ PR",
"55333014", "Governador\ Valadares\ \-\ MG",
"55473041", "Blumenau\ \-\ SC",
"55823634", "Senador\ Rui\ Palmeira\ \-\ AL",
"55853404", "Fortaleza\ \-\ CE",
"55383647", "Formoso\ \-\ MG",
"55793483", "Nossa\ Senhora\ Aparecida\ \-\ SE",
"55913087", "Belém\ \-\ PA",
"55453332", "Nova\ Santa\ Rosa\ \-\ PR",
"55133507", "Mongaguá\ \-\ SP",
"55183608", "Araçatuba\ \-\ SP",
"55753428", "Pedrão\ \-\ BA",
"55873837", "Iguaraci\ \-\ PE",
"55143881", "Botucatu\ \-\ SP",
"55733542", "Km\ Cem\ \-\ BA",
"55544009", "Caxias\ do\ Sul\ \-\ RS",
"55873850", "Brejinho\ \-\ PE",
"55313305", "Belo\ Horizonte\ \-\ MG",
"55313739", "Minas\ Gerais",
"55442101", "Maringá\ \-\ PR",
"55513498", "Rio\ Grande\ do\ Sul",
"55863248", "Buriti\ dos\ Montes\ \-\ PI",
"55913777", "Ponta\ de\ Pedras\ \-\ PA",
"55913442", "Santa\ Maria\ do\ Pará\ \-\ PA",
"55283542", "Castelo\ \-\ ES",
"5511434", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55413003", "Curitiba\ \-\ PR",
"55383811", "Monte\ Azul\ \-\ MG",
"55483533", "Sombrio\ \-\ SC",
"55513548", "Riozinho\ \-\ RS",
"55273079", "Serra\ \-\ ES",
"55423655", "Altamira\ do\ Paraná\ \-\ PR",
"55242221", "Petrópolis\ \-\ RJ",
"55833382", "Juazeirinho\ \-\ PB",
"55493333", "Nova\ Erechim\ \-\ SC",
"55433558", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55483657", "São\ Ludgero\ \-\ SC",
"55514116", "Porto\ Alegre\ \-\ RS",
"55813446", "Recife\ \-\ PE",
"55212789", "Mangaratiba\ \-\ RJ",
"55192516", "Indaiatuba\ \-\ SP",
"55753624", "Feira\ de\ Santana\ \-\ BA",
"55553237", "São\ Gabriel\ \-\ RS",
"55933558", "Belterra\ \-\ PA",
"55513101", "Alvorada\ \-\ RS",
"55643654", "Cachoeira\ Alta\ \-\ GO",
"55613459", "Samambaia\ Sul\ \-\ DF",
"55853336", "Horizonte\ \-\ CE",
"55513655", "General\ Câmara\ \-\ RS",
"55643695", "Adelândia\ \-\ GO",
"5519353", "Rio\ Claro\ \-\ SP",
"55213762", "Nilópolis\ \-\ RJ",
"55813707", "Frei\ Miguelinho\ \-\ PE",
"55883443", "Quixeré\ \-\ CE",
"55143492", "Vera\ Cruz\ \-\ SP",
"55553250", "Nova\ Esperança\ do\ Sul\ \-\ RS",
"55513694", "Minas\ do\ Leão\ \-\ RS",
"55173681", "Nova\ Canaã\ Paulista\ \-\ SP",
"5519342", "Piracicaba\ \-\ SP",
"55843637", "Bento\ Fernandes\ \-\ RN",
"55313132", "Esmeraldas\ \-\ MG",
"55493202", "Joaçaba\ \-\ SC",
"55963282", "Santana\ \-\ AP",
"55143352", "Piraju\ \-\ SP",
"55173566", "Embaúba\ \-\ SP",
"55543363", "Constantina\ \-\ RS",
"55353446", "Albertina\ \-\ MG",
"5511471", "São\ Roque\ \-\ SP",
"55543359", "Vila\ Maria\ \-\ RS",
"55542621", "Bento\ Gonçalves\ \-\ RS",
"55643471", "Pontalina\ \-\ GO",
"55173257", "Baguaçu\ \-\ SP",
"55483244", "Florianópolis\ \-\ SC",
"55453375", "Esquina\ Ipiranga\ \-\ PR",
"55513661", "Tramandaí\ \-\ RS",
"55843553", "Jandaíra\ \-\ RN",
"55212645", "Itaboraí\ \-\ RJ",
"55713676", "Mata\ de\ São\ João\ \-\ BA",
"55112831", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55693413", "Urupá\ \-\ RO",
"55553328", "Fortaleza\ dos\ Valos\ \-\ RS",
"55513586", "Rio\ Grande\ do\ Sul",
"55323571", "Rio\ Pomba\ \-\ MG",
"55463540", "Pranchita\ \-\ PR",
"55173831", "Nova\ Castilho\ \-\ SP",
"55453287", "Boa\ Vista\ da\ Aparecida\ \-\ PR",
"55793316", "Nossa\ Senhora\ de\ Lourdes\ \-\ SE",
"55323348", "Cipotânea\ \-\ MG",
"55543908", "Vacaria\ \-\ RS",
"55823279", "Boca\ da\ Mata\ \-\ AL",
"55823528", "Lagoa\ da\ Canoa\ \-\ AL",
"55313336", "Minas\ Gerais",
"55343261", "Ituiutaba\ \-\ MG",
"55833625", "Marcação\ \-\ PB",
"55513793", "Venâncio\ Aires\ \-\ RS",
"55713602", "Candeias\ \-\ BA",
"55242483", "Miguel\ Pereira\ \-\ RJ",
"55963314", "Santana\ \-\ AP",
"55733526", "Jequié\ \-\ BA",
"55423661", "Porto\ Barreiro\ \-\ PR",
"55162111", "Ribeirão\ Preto\ \-\ SP",
"55893589", "Caracol\ \-\ PI",
"55313392", "Contagem\ \-\ MG",
"55373221", "Divinópolis\ \-\ MG",
"55193621", "Americana\ \-\ SP",
"55753337", "Utinga\ \-\ BA",
"55153534", "Taquarivaí\ \-\ SP",
"55552102", "Uruguaiana\ \-\ RS",
"55653384", "Porto\ Estrela\ \-\ MT",
"55153325", "Sorocaba\ \-\ SP",
"55483648", "Termas\ do\ Gravatal\ \-\ SC",
"55433547", "Figueira\ \-\ PR",
"55223866", "São\ José\ de\ Ubá\ \-\ RJ",
"55443576", "Águas\ de\ Jurema\ \-\ PR",
"55513633", "Pareci\ Novo\ \-\ RS",
"55343842", "Monte\ Carmelo\ \-\ MG",
"55733205", "Argolo\ \-\ BA",
"55553745", "Iraí\ \-\ RS",
"55124109", "São\ José\ dos\ Campos\ \-\ SP",
"55613521", "Brasília\ \-\ DF",
"55843289", "Serra\ de\ São\ Bento\ \-\ RN",
"55133848", "Iguape\ \-\ SP",
"55773481", "Bom\ Jesus\ da\ Lapa\ \-\ BA",
"55913311", "Castanhal\ \-\ PA",
"55543331", "Carazinho\ \-\ RS",
"55513883", "Montenegro\ \-\ RS",
"55943344", "Nova\ Ipixuna\ \-\ PA",
"55643597", "Itumbiara\ \-\ GO",
"55843425", "São\ João\ do\ Sabugi\ \-\ RN",
"55913784", "Portel\ \-\ PA",
"55513557", "Rio\ Grande\ do\ Sul",
"55713271", "Salvador\ \-\ BA",
"55453256", "Mercedes\ \-\ PR",
"55513266", "Rio\ Grande\ do\ Sul",
"55443344", "Maringá\ \-\ PR",
"55893472", "Francinópolis\ \-\ PI",
"55113402", "Atibaia\ \-\ SP",
"55813721", "Caruaru\ \-\ PE",
"55114853", "Suzano\ \-\ SP",
"55513409", "Miraguaia\ \-\ RS",
"55613605", "Cidade\ Ocidental\ \-\ GO",
"55434007", "Londrina\ \-\ PR",
"55513127", "Gravataí\ \-\ RS",
"55493355", "Lajeado\ Grande\ \-\ SC",
"55222751", "São\ Fidélis\ \-\ RJ",
"55833450", "Tavares\ \-\ PB",
"55423633", "Mato\ Rico\ \-\ PR",
"55323725", "Antônio\ Prado\ de\ Minas\ \-\ MG",
"55183699", "Lourdes\ \-\ SP",
"55313380", "Minas\ Gerais",
"55633355", "Miranorte\ \-\ TO",
"55163265", "Tapinas\ \-\ SP",
"55383727", "Monjolos\ \-\ MG",
"55694007", "Porto\ Velho\ \-\ RO",
"55623481", "Posse\ \-\ GO",
"55463562", "Manfrinópolis\ \-\ PR",
"55833437", "Cajazeirinhas\ \-\ PB",
"55553414", "Uruguaiana\ \-\ RS",
"55663493", "Pedra\ Preta\ \-\ MT",
"55653212", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55933547", "Óbidos\ \-\ PA",
"55633394", "Sandolândia\ \-\ TO",
"55883628", "Santa\ Quitéria\ \-\ CE",
"55623923", "Goiânia\ \-\ GO",
"55353222", "Varginha\ \-\ MG",
"55653341", "Santo\ Antônio\ do\ Leverger\ \-\ MT",
"55344004", "Uberlândia\ \-\ MG",
"55123321", "São\ José\ dos\ Campos\ \-\ SP",
"55533252", "Canguçu\ \-\ RS",
"55873773", "Lajedo\ \-\ PE",
"55633454", "Aguiarnópolis\ \-\ TO",
"55273115", "Linhares\ \-\ ES",
"55222765", "Macaé\ \-\ RJ",
"55493361", "Chapecó\ \-\ SC",
"55163951", "Cravinhos\ \-\ SP",
"55633361", "Paraíso\ do\ Tocantins\ \-\ TO",
"55183022", "Assis\ \-\ SP",
"55163251", "Guariba\ \-\ SP",
"55493454", "Xavantina\ \-\ SC",
"5514323", "Bauru\ \-\ SP",
"55773444", "Livramento\ de\ Nossa\ Senhora\ \-\ BA",
"55274007", "Vitória\ \-\ ES",
"55513734", "Pantano\ Grande\ \-\ RS",
"55833390", "Prata\ \-\ PB",
"55153243", "Votorantim\ \-\ SP",
"55463538", "Salto\ do\ Lontra\ \-\ PR",
"55193056", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"5512391", "São\ José\ dos\ Campos\ \-\ SP",
"55173248", "Mendonça\ \-\ SP",
"55913741", "Soure\ \-\ PA",
"55443445", "São\ João\ do\ Caiuá\ \-\ PR",
"55323330", "Correia\ de\ Almeida\ \-\ MG",
"55163752", "Aramina\ \-\ SP",
"55743259", "Macajuba\ \-\ BA",
"55283560", "Alegre\ \-\ ES",
"55193607", "Casa\ Branca\ \-\ SP",
"55213842", "Duque\ de\ Caxias\ \-\ RJ",
"55473652", "Itaiópolis\ \-\ SC",
"55843535", "Jardim\ de\ Angicos\ \-\ RN",
"55113117", "São\ Paulo\ \-\ SP",
"55793642", "Colônia\ Treze\ \-\ SE",
"55313511", "Betim\ \-\ MG",
"55743692", "América\ Dourada\ \-\ BA",
"55353721", "Poços\ de\ Caldas\ \-\ MG",
"55883517", "Jucás\ \-\ CE",
"55513420", "Rio\ Grande\ do\ Sul",
"55743636", "Caém\ \-\ BA",
"55453026", "Foz\ do\ Iguaçu\ \-\ PR",
"55323357", "Coronel\ Xavier\ Chaves\ \-\ MG",
"55114005", "São\ Paulo\ \-\ SP",
"55383671", "Paracatu\ \-\ MG",
"55712223", "Salvador\ \-\ BA",
"55173280", "Olímpia\ \-\ SP",
"55323452", "Itamarati\ de\ Minas\ \-\ MG",
"55443673", "Ivaté\ \-\ PR",
"55513536", "Conceição\ \-\ RS",
"55913014", "Ananindeua\ \-\ PA",
"55543034", "São\ Marcos\ \-\ RS",
"55453237", "Lindoeste\ \-\ PR",
"55633449", "Tupiratins\ \-\ TO",
"55433305", "Londrina\ \-\ PR",
"55753522", "Castro\ Alves\ \-\ BA",
"55513260", "Rio\ Grande\ do\ Sul",
"55773463", "Licínio\ de\ Almeida\ \-\ BA",
"55333087", "Teófilo\ Otoni\ \-\ MG",
"55493449", "Ipuaçu\ \-\ SC",
"553136", "Minas\ Gerais",
"55773459", "Tanhaçu\ \-\ BA",
"55843251", "São\ Paulo\ do\ Potengi\ \-\ RN",
"55513592", "São\ Leopoldo\ \-\ RS",
"55173631", "Santa\ Fé\ do\ Sul\ \-\ SP",
"55323273", "Matias\ Barbosa\ \-\ MG",
"55113599", "Osasco\ \-\ SP",
"55153264", "Águia\ da\ Castelo\ \-\ SP",
"55313718", "Baldim\ \-\ MG",
"55213078", "Rio\ de\ Janeiro\ \-\ RJ",
"55833456", "Pedra\ Branca\ \-\ PB",
"55173542", "Novo\ Horizonte\ \-\ SP",
"55112304", "Guarulhos\ \-\ SP",
"55463232", "Coronel\ Vivida\ \-\ PR",
"55353462", "Estiva\ \-\ MG",
"55913694", "Anapu\ \-\ PA",
"55183997", "Taciba\ \-\ SP",
"55893539", "Porto\ Alegre\ do\ Piauí\ \-\ PI",
"55242433", "Barra\ do\ Piraí\ \-\ RJ",
"55193498", "Nova\ Odessa\ \-\ SP",
"55833368", "Areial\ \-\ PB",
"55163324", "Araraquara\ \-\ SP",
"55793255", "Aracaju\ \-\ SE",
"55222789", "São\ Francisco\ de\ Paula\ \-\ RJ",
"55663385", "Nova\ Brasilândia\ \-\ MT",
"55414116", "Curitiba\ \-\ PR",
"5563341", "Araguaína\ \-\ TO",
"55373523", "Pompéu\ \-\ MG",
"55193821", "Elias\ Fausto\ \-\ SP",
"55623463", "Mimoso\ de\ Goiás\ \-\ GO",
"55853348", "Pacajus\ \-\ CE",
"55313386", "Minas\ Gerais",
"55113416", "Taboão\ da\ Serra\ \-\ SP",
"55623459", "Alto\ Paraíso\ de\ Goiás\ \-\ GO",
"55173844", "Pontes\ Gestal\ \-\ SP",
"55373433", "São\ Roque\ de\ Minas\ \-\ MG",
"55353438", "Camanducaia\ \-\ MG",
"55183558", "Sagres\ \-\ SP",
"55793261", "São\ Cristóvão\ \-\ SE",
"55853182", "Fortaleza\ \-\ CE",
"55213660", "Magé\ \-\ RJ",
"55913661", "Oeiras\ do\ Pará\ \-\ PA",
"55483231", "Florianópolis\ \-\ SC",
"55623085", "Aparecida\ de\ Goiânia\ \-\ GO",
"55313571", "Brumadinho\ \-\ MG",
"55873803", "Pesqueira\ \-\ PE",
"55213746", "Mesquita\ \-\ RJ",
"55483583", "Balneário\ Gaivota\ \-\ SC",
"55633383", "Cariri\ do\ Tocantins\ \-\ TO",
"55113177", "São\ Paulo\ \-\ SP",
"55193466", "Nova\ Odessa\ \-\ SP",
"55113307", "São\ Paulo\ \-\ SP",
"55833396", "Aroeiras\ \-\ PB",
"55173405", "Votuporanga\ \-\ SP",
"55713504", "Lauro\ de\ Freitas\ \-\ BA",
"55474105", "Itajaí\ \-\ SC",
"55222645", "Cabo\ Frio\ \-\ RJ",
"55893429", "São\ João\ da\ Canabrava\ \-\ PI",
"55163797", "Ribeirão\ Preto\ \-\ SP",
"55743657", "Lapão\ \-\ BA",
"55323336", "Desterro\ do\ Melo\ \-\ MG",
"55753496", "Adustina\ \-\ BA",
"55193909", "Hortolândia\ \-\ SP",
"55673676", "Nova\ Andradina\ \-\ MS",
"55123647", "Lagoinha\ \-\ SP",
"55153291", "Araçoiaba\ da\ Serra\ \-\ SP",
"55843265", "Poço\ Branco\ \-\ RN",
"55413586", "São\ José\ dos\ Pinhais\ \-\ PR",
"55333621", "Nanuque\ \-\ MG",
"55753432", "Aramari\ \-\ BA",
"55743630", "Mirangaba\ \-\ BA",
"55134104", "São\ Vicente\ \-\ SP",
"55183645", "Coroados\ \-\ SP",
"55513426", "Canoas\ \-\ RS",
"55553375", "Panambi\ \-\ RS",
"55143486", "Herculândia\ \-\ SP",
"55743533", "Campo\ Alegre\ de\ Lourdes\ \-\ BA",
"55373354", "Japaraíba\ \-\ MG",
"55513784", "Mato\ Leitão\ \-\ RS",
"55193717", "Limeira\ \-\ SP",
"55114109", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55673447", "Novo\ Horizonte\ do\ Sul\ \-\ MS",
"55943331", "São\ Geraldo\ do\ Araguaia\ \-\ PA",
"55114427", "Santo\ André\ \-\ SP",
"55534007", "Pelotas\ \-\ RS",
"55543344", "Tapejara\ \-\ RS",
"55383216", "Montes\ Claros\ \-\ MG",
"55983012", "São\ Luís\ \-\ MA",
"55343421", "Frutal\ \-\ MG",
"55483259", "São\ José\ \-\ SC",
"55833274", "Araçagi\ \-\ PB",
"55913633", "Curralinho\ \-\ PA",
"55483263", "Tijucas\ \-\ SC",
"55923311", "Cacau\ Pirêra\ \-\ AM",
"55893565", "Santa\ Luz\ \-\ PI",
"55243357", "Resende\ \-\ RJ",
"5522382", "Itaperuna\ \-\ RJ",
"55193807", "Amparo\ \-\ SP",
"55813877", "Carnaubeira\ da\ Penha\ \-\ PE",
"55212751", "São\ João\ de\ Meriti\ \-\ RJ",
"55153378", "Pilar\ do\ Sul\ \-\ SP",
"55452102", "Foz\ do\ Iguaçu\ \-\ PR",
"55273751", "Mucurici\ \-\ ES",
"55743686", "Ibipeba\ \-\ BA",
"55623605", "Goiânia\ \-\ GO",
"55213642", "Teresópolis\ \-\ RJ",
"5542322", "Ponta\ Grossa\ \-\ PR",
"55423311", "Ponta\ Grossa\ \-\ PR",
"55853357", "General\ Sampaio\ \-\ CE",
"55553256", "Manoel\ Viana\ \-\ RS",
"55843478", "São\ José\ do\ Seridó\ \-\ RN",
"55313913", "Contagem\ \-\ MG",
"55553567", "Campina\ das\ Missões\ \-\ RS",
"55413883", "Curitiba\ \-\ PR",
"55313725", "Caranaíba\ \-\ MG",
"55613053", "Brasília\ \-\ DF",
"55143457", "Oscar\ Bressane\ \-\ SP",
"55793302", "Aracaju\ \-\ SE",
"55913734", "Quatro\ Bocas\ \-\ PA",
"55173663", "Santa\ Clara\ D\'Oeste\ \-\ SP",
"55212765", "Nova\ Iguaçu\ \-\ RJ",
"55513741", "Venâncio\ Aires\ \-\ RS",
"55833042", "João\ Pessoa\ \-\ PB",
"55112663", "São\ Paulo\ \-\ SP",
"55793544", "Itabaianinha\ \-\ SE",
"55773431", "Poções\ \-\ BA",
"55843239", "Nísia\ Floresta\ \-\ RN",
"55543381", "Soledade\ \-\ RS",
"55173292", "Paulo\ de\ Faria\ \-\ SP",
"55273765", "Pinheiros\ \-\ ES",
"55423242", "Ipiranga\ \-\ PR",
"55463546", "Nova\ Esperança\ do\ Sudoeste\ \-\ PR",
"55513683", "Rio\ Grande\ do\ Sul",
"55513580", "Novo\ Hamburgo\ \-\ RS",
"55753275", "Monte\ Santo\ \-\ BA",
"55153584", "Taquarivaí\ \-\ SP",
"55753387", "Quijingue\ \-\ BA",
"55553026", "Santa\ Maria\ \-\ RS",
"55873874", "Ouricuri\ \-\ PE",
"55223842", "Porciúncula\ \-\ RJ",
"55114653", "Arujá\ \-\ SP",
"55133594", "Praia\ Grande\ \-\ SP",
"55883675", "Independência\ \-\ CE",
"55114669", "Itapecerica\ da\ Serra\ \-\ SP",
"55433252", "Arapongas\ \-\ PR",
"55323511", "Muriaé\ \-\ MG",
"55123117", "São\ José\ do\ Barreiro\ \-\ SP",
"55313330", "Belo\ Horizonte\ \-\ MG",
"55343283", "Monte\ Alegre\ de\ Minas\ \-\ MG",
"55713616", "Salvador\ \-\ BA",
"5564309", "Itumbiara\ \-\ GO",
"55643411", "Catalão\ \-\ GO",
"55114537", "Jundiaí\ \-\ SP",
"55543445", "Fagundes\ Varela\ \-\ RS",
"55643649", "Castelândia\ \-\ GO",
"55433473", "Lidianópolis\ \-\ PR",
"55693252", "Vila\ Extrema\ \-\ RO",
"55853213", "Caucaia\ \-\ CE",
"55483029", "São\ José\ \-\ SC",
"55733623", "Firmino\ Alves\ \-\ BA",
"55313357", "Contagem\ \-\ MG",
"55743648", "Ibipeba\ \-\ BA",
"55193819", "Hortolândia\ \-\ SP",
"55413662", "Cerro\ Azul\ \-\ PR",
"55643565", "Itumbiara\ \-\ GO",
"55163413", "São\ Carlos\ \-\ SP",
"55112668", "Mogi\ das\ Cruzes\ \-\ SP",
"55153292", "Salto\ de\ Pirapora\ \-\ SP",
"55513564", "Dois\ Irmãos\ \-\ RS",
"55753431", "Inhambupe\ \-\ BA",
"55333622", "Nanuque\ \-\ MG",
"55773275", "Maiquinique\ \-\ BA",
"55513688", "Rio\ Grande\ do\ Sul",
"5579", "Sergipe",
"55443274", "Sarandi\ \-\ PR",
"55323465", "Pirapetinga\ \-\ MG",
"55123653", "Caçapava\ \-\ SP",
"55114658", "Igaratá\ \-\ SP",
"55193709", "Campinas\ \-\ SP",
"55212656", "São\ João\ de\ Meriti\ \-\ RJ",
"55123669", "Campos\ do\ Jordão\ \-\ SP",
"55313572", "Itatiaiuçu\ \-\ MG",
"55823626", "Poço\ das\ Trincheiras\ \-\ AL",
"55483296", "Biguaçu\ \-\ SC",
"55353826", "Lavras\ \-\ MG",
"55793262", "Barra\ dos\ Coqueiros\ \-\ SE",
"55913662", "Terra\ Alta\ \-\ PA",
"55853181", "Fortaleza\ \-\ CE",
"55623387", "Anápolis\ \-\ GO",
"55483232", "Florianópolis\ \-\ SC",
"55353455", "São\ João\ da\ Mata\ \-\ MG",
"55433478", "Lunardelli\ \-\ PR",
"55383612", "Montalvânia\ \-\ MG",
"55273239", "Vila\ Velha\ \-\ ES",
"55733628", "Santa\ Luzia\ \-\ BA",
"55743643", "Mulungu\ do\ Morro\ \-\ BA",
"55183324", "Assis\ \-\ SP",
"55913110", "Belém\ \-\ PA",
"55193822", "Sumaré\ \-\ SP",
"55183289", "Tarabai\ \-\ SP",
"55183856", "Nova\ Guataporanga\ \-\ SP",
"55313874", "Minas\ Gerais",
"55213288", "Rio\ de\ Janeiro\ \-\ RJ",
"5545357", "Foz\ do\ Iguaçu\ \-\ PR",
"5522", "Rio\ de\ Janeiro",
"55543618", "Nonoai\ \-\ RS",
"55223013", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55483268", "Leoberto\ Leal\ \-\ SC",
"55513760", "Colinas\ \-\ RS",
"55173016", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55693239", "Campo\ Novo\ de\ Rondônia\ \-\ RO",
"55353461", "Bom\ Repouso\ \-\ MG",
"55633467", "Presidente\ Kennedy\ \-\ TO",
"55513591", "São\ Leopoldo\ \-\ RS",
"55983268", "São\ Luís\ \-\ MA",
"55173632", "Jales\ \-\ SP",
"55153373", "Itapetininga\ \-\ SP",
"55323364", "Paiva\ \-\ MG",
"55483303", "Florianópolis\ \-\ SC",
"55283534", "Anchieta\ \-\ ES",
"55423646", "Pitanga\ \-\ PR",
"55543527", "Áurea\ \-\ RS",
"55673435", "Antônio\ João\ \-\ MS",
"55114402", "Atibaia\ \-\ SP",
"55663442", "Vale\ dos\ Sonhos\ \-\ MT",
"55472102", "Blumenau\ \-\ SC",
"55112378", "Mogi\ das\ Cruzes\ \-\ SP",
"55843252", "Sítio\ Novo\ \-\ RN",
"55633612", "Gurupi\ \-\ TO",
"55843473", "Cruzeta\ \-\ RN",
"55323083", "Juiz\ de\ Fora\ \-\ MG",
"55323451", "Astolfo\ Dutra\ \-\ MG",
"55492049", "Chapecó\ \-\ SC",
"55343246", "Araguari\ \-\ MG",
"55624053", "Goiânia\ \-\ GO",
"55653513", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55893552", "Guadalupe\ \-\ PI",
"55693251", "Vista\ Alegre\ do\ Abunã\ \-\ RO",
"55353433", "Camanducaia\ \-\ MG",
"55463263", "Palmas\ \-\ PR",
"55273265", "Rio\ Bananal\ \-\ ES",
"55643412", "Itumbiara\ \-\ GO",
"55273021", "Guarapari\ \-\ ES",
"55883526", "Saboeiro\ \-\ CE",
"55453017", "Foz\ do\ Iguaçu\ \-\ PR",
"55213568", "Niterói\ \-\ RJ",
"55483664", "Florianópolis\ \-\ SC",
"55115819", "São\ Paulo\ \-\ SP",
"55114024", "Itu\ \-\ SP",
"55513941", "Canoas\ \-\ RS",
"55633388", "Santa\ Rosa\ do\ Tocantins\ \-\ TO",
"55673044", "Campo\ Grande\ \-\ MS",
"55313094", "Ipatinga\ \-\ MG",
"55183637", "Araçatuba\ \-\ SP",
"55133864", "Jacupiranga\ \-\ SP",
"55222123", "Macaé\ \-\ RJ",
"55313055", "Belo\ Horizonte\ \-\ MG",
"55623432", "Goiânia\ \-\ GO",
"55223841", "Natividade\ \-\ RJ",
"55482107", "Florianópolis\ \-\ SC",
"55193353", "Araras\ \-\ SP",
"55433251", "Cambé\ \-\ PR",
"55123635", "Taubaté\ \-\ SP",
"55323512", "Juiz\ de\ Fora\ \-\ MG",
"55162106", "São\ Carlos\ \-\ SP",
"55833499", "Aguiar\ \-\ PB",
"55983475", "Mata\ Roma\ \-\ MA",
"55113556", "São\ Paulo\ \-\ SP",
"55623519", "Goiânia\ \-\ GO",
"55222553", "Cantagalo\ \-\ RJ",
"55643667", "Arenópolis\ \-\ GO",
"55773496", "Santa\ Maria\ da\ Vitória\ \-\ BA",
"55813523", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55642104", "Rio\ Verde\ \-\ GO",
"55543382", "Alto\ Alegre\ \-\ RS",
"55773432", "Itambé\ \-\ BA",
"5562400", "Goiânia\ \-\ GO",
"55643539", "Itumbiara\ \-\ GO",
"55173291", "Riolândia\ \-\ SP",
"55143389", "Timburi\ \-\ SP",
"55913798", "Pacajá\ \-\ PA",
"55453323", "Cascavel\ \-\ PR",
"55513477", "Canoas\ \-\ RS",
"55983664", "Buriticupu\ \-\ MA",
"55513742", "Sobradinho\ \-\ RS",
"55743538", "Sobradinho\ \-\ BA",
"55993574", "Fortuna\ \-\ MA",
"55643377", "Mossâmedes\ \-\ GO",
"55483546", "Ermo\ \-\ SC",
"55443332", "Itaguajé\ \-\ PR",
"55673272", "Sidrolândia\ \-\ MS",
"55543625", "Capão\ Bonito\ do\ Sul\ \-\ RS",
"55414003", "Curitiba\ \-\ PR",
"5511334", "São\ Paulo\ \-\ SP",
"55613624", "Valparaíso\ de\ Goiás\ \-\ GO",
"55143224", "Bauru\ \-\ SP",
"55193917", "Ribeirão\ Preto\ \-\ SP",
"55653366", "Nova\ Mutum\ \-\ MT",
"55773468", "Mirante\ \-\ BA",
"55452101", "Cascavel\ \-\ PR",
"55273752", "Nova\ Venécia\ \-\ ES",
"55813433", "Paulista\ \-\ PE",
"55212752", "São\ João\ de\ Meriti\ \-\ RJ",
"55673453", "Caarapó\ \-\ MS",
"55173264", "Bálsamo\ \-\ SP",
"55673469", "Culturama\ \-\ MS",
"55323278", "Pequeri\ \-\ MG",
"55983374", "Santa\ Luzia\ do\ Paruá\ \-\ MA",
"55493346", "Quilombo\ \-\ SC",
"55833208", "João\ Pessoa\ \-\ PB",
"55424101", "Guarapuava\ \-\ PR",
"55823221", "Maceió\ \-\ AL",
"55313713", "Capim\ Branco\ \-\ MG",
"55923312", "Balbina\ \-\ AM",
"55623522", "Goiânia\ \-\ GO",
"55273251", "Serra\ \-\ ES",
"55513170", "Estância\ Velha\ \-\ RS",
"55153542", "Capão\ Bonito\ \-\ SP",
"55413543", "Rio\ Negro\ \-\ PR",
"55212687", "Itaguaí\ \-\ RJ",
"55212251", "São\ Gonçalo\ \-\ RJ",
"55242438", "Conservatória\ \-\ RJ",
"55453245", "Braganey\ \-\ PR",
"55713183", "Salvador\ \-\ BA",
"55833359", "Congo\ \-\ PB",
"55343834", "Guimarânia\ \-\ MG",
"55193493", "Rio\ das\ Pedras\ \-\ SP",
"55833363", "Solânea\ \-\ PB",
"55333726", "Jordânia\ \-\ MG",
"55943332", "São\ Domingos\ do\ Araguaia\ \-\ PA",
"55114295", "Suzano\ \-\ SP",
"55883436", "Itatira\ \-\ CE",
"55623356", "Nova\ Veneza\ \-\ GO",
"55983011", "São\ Luís\ \-\ MA",
"55493574", "Macieira\ \-\ SC",
"55313489", "Minas\ Gerais",
"55553756", "Cerro\ Grande\ \-\ RS",
"55433265", "São\ Sebastião\ da\ Amoreira\ \-\ PR",
"55914003", "Belém\ \-\ PA",
"55313061", "Conselheiro\ Lafaiete\ \-\ MG",
"55853343", "Canindé\ \-\ CE",
"55353523", "Alpinópolis\ \-\ MG",
"55623928", "Goiânia\ \-\ GO",
"55883623", "Barroquinha\ \-\ CE",
"55193484", "Nova\ Odessa\ \-\ SP",
"55343327", "Conceição\ das\ Alagoas\ \-\ MG",
"55663466", "Ponte\ Branca\ \-\ MT",
"55193622", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55373222", "Divinópolis\ \-\ MG",
"55313391", "Contagem\ \-\ MG",
"55713601", "Candeias\ \-\ BA",
"55793288", "Areia\ Branca\ \-\ SE",
"55133268", "Bertioga\ \-\ SP",
"55423662", "Paz\ \-\ PR",
"55183656", "Jatobá\ \-\ SP",
"55213938", "Rio\ de\ Janeiro\ \-\ RJ",
"5524224", "Petrópolis\ \-\ RJ",
"55343262", "Ituiutaba\ \-\ MG",
"55463533", "São\ João\ \-\ PR",
"55153248", "Ibiúna\ \-\ SP",
"55623579", "Goiânia\ \-\ GO",
"55173243", "Mirassol\ \-\ SP",
"55273324", "Vitória\ \-\ ES",
"55854062", "Fortaleza\ \-\ CE",
"5554302", "Caxias\ do\ Sul\ \-\ RS",
"55384141", "Montes\ Claros\ \-\ MG",
"55113120", "São\ Paulo\ \-\ SP",
"55553554", "Miraguaí\ \-\ RS",
"55323572", "Silveirânia\ \-\ MG",
"55673929", "Três\ Lagoas\ \-\ MS",
"55813626", "Goiana\ \-\ PE",
"55173832", "General\ Salgado\ \-\ SP",
"55513662", "Santo\ Antônio\ da\ Patrulha\ \-\ RS",
"55333524", "Ladainha\ \-\ MG",
"55553595", "Tuparendi\ \-\ RS",
"55113653", "Osasco\ \-\ SP",
"55333335", "São\ José\ do\ Mantimento\ \-\ MG",
"55143351", "Piraju\ \-\ SP",
"55963281", "Santana\ \-\ AP",
"55443437", "Amaporã\ \-\ PR",
"55613275", "Brasília\ \-\ DF",
"55112682", "São\ Paulo\ \-\ SP",
"55833613", "Campina\ Grande\ \-\ PB",
"5516333", "Araraquara\ \-\ SP",
"5571340", "Salvador\ \-\ BA",
"55643472", "Santa\ Cruz\ de\ Goiás\ \-\ GO",
"55112896", "Santo\ André\ \-\ SP",
"55963118", "Macapá\ \-\ AP",
"55853364", "Umirim\ \-\ CE",
"5534", "Minas\ Gerais",
"551121", "São\ Paulo\ \-\ SP",
"55613387", "Sobradinho\ \-\ DF",
"55463244", "Sulina\ \-\ PR",
"55213761", "Nilópolis\ \-\ RJ",
"55113427", "Mogi\ das\ Cruzes\ \-\ SP",
"55163305", "Araraquara\ \-\ SP",
"55143491", "Tupã\ \-\ SP",
"55483643", "Imaruí\ \-\ SC",
"55153286", "Jumirim\ \-\ SP",
"55513638", "Salvador\ do\ Sul\ \-\ RS",
"55443527", "Nova\ Cantu\ \-\ PR",
"55113379", "Jundiaí\ \-\ SP",
"55113109", "Jundiaí\ \-\ SP",
"55314062", "Belo\ Horizonte\ \-\ MG",
"55513372", "Rio\ Grande\ do\ Sul",
"55333434", "São\ Pedro\ do\ Suaçuí\ \-\ MG",
"55133843", "Ilha\ Comprida\ \-\ SP",
"55634141", "Palmas\ \-\ TO",
"55833445", "Paulista\ \-\ PB",
"55963423", "Calçoene\ \-\ AP",
"5521", "Rio\ de\ Janeiro",
"5582337", "Maceió\ \-\ AL",
"55543042", "Farroupilha\ \-\ RS",
"55553737", "Vicente\ Dutra\ \-\ RS",
"55433535", "Jaguariaíva\ \-\ PR",
"55383201", "Montes\ Claros\ \-\ MG",
"55483282", "Florianópolis\ \-\ SC",
"55242222", "Petrópolis\ \-\ RJ",
"55753345", "Nova\ Redenção\ \-\ BA",
"55193977", "Artur\ Nogueira\ \-\ SP",
"55833381", "Montadas\ \-\ PB",
"55423638", "Candói\ \-\ PR",
"55133296", "Santos\ \-\ SP",
"55963244", "Macapá\ \-\ AP",
"55353626", "Wenceslau\ Braz\ \-\ MG",
"55693535", "Ariquemes\ \-\ RO",
"55113754", "Arujá\ \-\ SP",
"55383812", "Espinosa\ \-\ MG",
"55663498", "Primavera\ do\ Leste\ \-\ MT",
"55213693", "Paracambi\ \-\ RJ",
"55923306", "Manaus\ \-\ AM",
"55193385", "Campinas\ \-\ SP",
"55383672", "Paracatu\ \-\ MG",
"5511316", "São\ Paulo\ \-\ SP",
"55543456", "Santa\ Tereza\ \-\ RS",
"55353722", "Poços\ de\ Caldas\ \-\ MG",
"55153257", "Porangaba\ \-\ SP",
"55543368", "Jacutinga\ \-\ RS",
"55153566", "Bairro\ Palmitalzinho\ \-\ SP",
"55813483", "Olinda\ \-\ PE",
"55333353", "Pingo\-D\'Água\ \-\ MG",
"55713627", "Camaçari\ \-\ BA",
"55513234", "Rio\ Grande\ do\ Sul",
"55613432", "Formosa\ \-\ GO",
"55313512", "Betim\ \-\ MG",
"55793641", "Riachão\ do\ Dantas\ \-\ SE",
"55473375", "Corupá\ \-\ SC",
"5561354", "Brasília\ \-\ DF",
"55343301", "Uberlândia\ \-\ MG",
"55693418", "Nova\ Brasilândia\ D\'Oeste\ \-\ RO",
"55114177", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55163751", "Buritizal\ \-\ SP",
"55213733", "Rio\ de\ Janeiro\ \-\ RJ",
"55813719", "Caruaru\ \-\ PE",
"55823620", "Dois\ Riachos\ \-\ AL",
"55183265", "Rancharia\ \-\ SP",
"55273553", "Guaçuí\ \-\ ES",
"55323343", "Senhora\ dos\ Remédios\ \-\ MG",
"55823523", "Limoeiro\ de\ Anadia\ \-\ AL",
"55463555", "Planalto\ \-\ PR",
"55633362", "Dois\ Irmãos\ do\ Tocantins\ \-\ TO",
"55163252", "Taquaritinga\ \-\ SP",
"55943382", "Sapucaia\ \-\ PA",
"55183021", "Birigui\ \-\ SP",
"55313439", "Minas\ Gerais",
"55533251", "São\ Lourenço\ do\ Sul\ \-\ RS",
"55743546", "Itiúba\ \-\ BA",
"55493362", "Novo\ Horizonte\ \-\ SC",
"55163952", "Pitangueiras\ \-\ SP",
"55423234", "Colônia\ Castrolanda\ \-\ PR",
"55653342", "Denise\ \-\ MT",
"55353221", "Varginha\ \-\ MG",
"555130", "Rio\ Grande\ do\ Sul",
"55212637", "Maricá\ \-\ RJ",
"55123322", "São\ José\ dos\ Campos\ \-\ SP",
"55413941", "Curitiba\ \-\ PR",
"55193879", "Monte\ Mor\ \-\ SP",
"55183251", "Presidente\ Epitácio\ \-\ SP",
"55623482", "Nova\ Roma\ \-\ GO",
"55623624", "Goiânia\ \-\ GO",
"55653211", "Cáceres\ \-\ MT",
"55483538", "Balneário\ Bela\ Torres\ \-\ SC",
"55513543", "Parobé\ \-\ RS",
"55143815", "Botucatu\ \-\ SP",
"55213634", "Rio\ Bonito\ \-\ RJ",
"55913116", "Belém\ \-\ PA",
"55913284", "Ananindeua\ \-\ PA",
"55112318", "São\ Paulo\ \-\ SP",
"55954009", "Boa\ Vista\ \-\ RR",
"55533265", "Chuí\ \-\ RS",
"55114599", "Jundiaí\ \-\ SP",
"55313529", "Betim\ \-\ MG",
"55513766", "Bom\ Retiro\ do\ Sul\ \-\ RS",
"55493338", "Cunhataí\ \-\ SC",
"55493030", "Concórdia\ \-\ SC",
"55123835", "Ubatuba\ \-\ SP",
"55893471", "Várzea\ Grande\ \-\ PI",
"55433553", "Nova\ América\ da\ Colina\ \-\ PR",
"55153313", "Sorocaba\ \-\ SP",
"55433569", "Pinhalão\ \-\ PR",
"55454009", "Cascavel\ \-\ PR",
"55443625", "Perobal\ \-\ PR",
"55313159", "Betim\ \-\ MG",
"55713272", "Salvador\ \-\ BA",
"55514003", "Porto\ Alegre\ \-\ RS",
"55613522", "Brasília\ \-\ DF",
"55493198", "Maravilha\ \-\ SC",
"55543332", "Não\-Me\-Toque\ \-\ RS",
"55773624", "Riachão\ das\ Neves\ \-\ BA",
"55843297", "Japi\ \-\ RN",
"55423543", "Paulo\ Frontin\ \-\ PR",
"55383227", "Brasília\ de\ Minas\ \-\ MG",
"55613468", "Brasília\ \-\ DF",
"55343841", "Coromandel\ \-\ MG",
"55543396", "Santo\ Expedito\ do\ Sul\ \-\ RS",
"5513335", "Guarujá\ \-\ SP",
"55323061", "Juiz\ de\ Fora\ \-\ MG",
"55743664", "Xique\-xique\ \-\ BA",
"55713453", "Salvador\ \-\ BA",
"55413116", "São\ José\ dos\ Pinhais\ \-\ PR",
"55883448", "Parambu\ \-\ CE",
"55552101", "Santa\ Maria\ \-\ RS",
"55983538", "Açailândia\ \-\ MA",
"55613356", "Taguatinga\ \-\ DF",
"55213171", "Rio\ de\ Janeiro\ \-\ RJ",
"55753244", "Conceição\ da\ Feira\ \-\ BA",
"55313265", "Minas\ Gerais",
"55683234", "Capixaba\ \-\ AC",
"55813316", "Recife\ \-\ PE",
"55353563", "Bom\ Jesus\ da\ Penha\ \-\ MG",
"55114091", "Diadema\ \-\ SP",
"55873845", "Calumbi\ \-\ PE",
"55353559", "Guaxupé\ \-\ MG",
"55193984", "Paulínia\ \-\ SP",
"55663557", "Tabaporã\ \-\ MT",
"55115646", "São\ Paulo\ \-\ SP",
"5511441", "Atibaia\ \-\ SP",
"55823261", "Rio\ Largo\ \-\ AL",
"5519372", "Campinas\ \-\ SP",
"55823025", "Maceió\ \-\ AL",
"55113198", "São\ Paulo\ \-\ SP",
"55183603", "Luiziânia\ \-\ SP",
"55443237", "Santa\ Zélia\ \-\ PR",
"55613475", "Brasília\ \-\ DF",
"55753423", "Alagoinhas\ \-\ BA",
"55513679", "Sentinela\ do\ Sul\ \-\ RS",
"55653326", "Tangará\ da\ Serra\ \-\ MT",
"55473332", "Gaspar\ \-\ SC",
"55673429", "Vila\ Macaúba\ \-\ MS",
"55114449", "Franco\ da\ Rocha\ \-\ SP",
"55163204", "Jaboticabal\ \-\ SP",
"55193312", "Indaiatuba\ \-\ SP",
"55673285", "Jaraguari\ \-\ MS",
"55323553", "Guiricema\ \-\ MG",
"55834105", "Cabedelo\ \-\ PB",
"55883644", "Santana\ do\ Acaraú\ \-\ CE",
"55443250", "Presidente\ Castelo\ Branco\ \-\ PR",
"55383635", "Arinos\ \-\ MG",
"55813078", "Recife\ \-\ PE",
"55163904", "Ribeirão\ Preto\ \-\ SP",
"55513493", "Viamão\ \-\ RS",
"55913726", "Ulianópolis\ \-\ PA",
"55483215", "Florianópolis\ \-\ SC",
"55863243", "Porto\ \-\ PI",
"55643453", "Caldas\ Novas\ \-\ GO",
"55143264", "Lençóis\ Paulista\ \-\ SP",
"55643469", "Anhanguera\ \-\ GO",
"55473396", "Brusque\ \-\ SC",
"55133519", "Santos\ \-\ SP",
"55113362", "São\ Paulo\ \-\ SP",
"55333234", "Engenheiro\ Caldas\ \-\ MG",
"55753281", "Paulo\ Afonso\ \-\ BA",
"55813746", "Jataúba\ \-\ PE",
"55843386", "Tenente\ Ananias\ \-\ RN",
"55983482", "Buriti\ \-\ MA",
"55473456", "Barra\ Velha\ \-\ SC",
"55693343", "Corumbiara\ \-\ RO",
"55433343", "Londrina\ \-\ PR",
"55643627", "Riverlândia\ \-\ GO",
"55313752", "Catas\ Altas\ da\ Noruega\ \-\ MG",
"55923369", "Careiro\ da\ Várzea\ \-\ AM",
"55143291", "Domélia\ \-\ SP",
"55993635", "Lago\ Verde\ \-\ MA",
"55543287", "Vila\ Cristina\ \-\ RS",
"55813563", "Gravatá\ \-\ PE",
"55483047", "São\ José\ \-\ SC",
"55543375", "Erval\ Grande\ \-\ RS",
"55163511", "Sertãozinho\ \-\ SP",
"55813559", "Ipojuca\ \-\ PE",
"55373073", "Itaúna\ \-\ MG",
"55953084", "Boa\ Vista\ \-\ RR",
"55193477", "Americana\ \-\ SP",
"55313251", "Santana\ do\ Paraíso\ \-\ MG",
"55943328", "Núcleo\ Carajás\ \-\ PA",
"55313850", "Minas\ Gerais",
"55433055", "Arapongas\ \-\ PR",
"55673412", "Douradina\ \-\ MS",
"55473903", "Joinville\ \-\ SC",
"55212713", "São\ Gonçalo\ \-\ RJ",
"55192105", "Piracicaba\ \-\ SP",
"55353100", "Extrema\ \-\ MG",
"55714119", "Candeias\ \-\ BA",
"55213097", "Teresópolis\ \-\ RJ",
"55313837", "Barão\ de\ Cocais\ \-\ MG",
"55823255", "Colônia\ Leopoldina\ \-\ AL",
"55183704", "Pereira\ Barreto\ \-\ SP",
"55463223", "Pato\ Branco\ \-\ PR",
"55273225", "Vitória\ \-\ ES",
"55183278", "Caiuá\ \-\ SP",
"55183529", "Osvaldo\ Cruz\ \-\ SP",
"55513045", "Viamão\ \-\ RS",
"55623538", "Goiânia\ \-\ GO",
"55213279", "Rio\ de\ Janeiro\ \-\ RJ",
"55213528", "Rio\ de\ Janeiro\ \-\ RJ",
"5512312", "Guaratinguetá\ \-\ SP",
"55823294", "União\ dos\ Palmares\ \-\ AL",
"55483624", "Jaguaruna\ \-\ SC",
"55832101", "Campina\ Grande\ \-\ PB",
"55883566", "Juazeiro\ do\ Norte\ \-\ CE",
"55684003", "Rio\ Branco\ \-\ AC",
"55733291", "Teixeira\ de\ Freitas\ \-\ BA",
"55123600", "São\ José\ dos\ Campos\ \-\ SP",
"55513434", "Viamão\ \-\ RS",
"55143108", "Bauru\ \-\ SP",
"55143632", "Dois\ Córregos\ \-\ SP",
"55343515", "Patrocínio\ \-\ MG",
"55993427", "Barra\ do\ Corda\ \-\ MA",
"55913441", "Igarapé\-Açu\ \-\ PA",
"55143378", "Salto\ Grande\ \-\ SP",
"55314115", "Lagoa\ Santa\ \-\ MG",
"55413385", "São\ José\ dos\ Pinhais\ \-\ PR",
"55843357", "Coronel\ João\ Pessoa\ \-\ RN",
"55693218", "Porto\ Velho\ \-\ RO",
"55442102", "Maringá\ \-\ PR",
"5551330", "Rio\ Grande\ do\ Sul",
"55222674", "Araruama\ \-\ RJ",
"55413099", "Curitiba\ \-\ PR",
"55323535", "Divinésia\ \-\ MG",
"55173875", "São\ João\ de\ Iracema\ \-\ SP",
"55373246", "Igaratinga\ \-\ MG",
"55193646", "São\ Sebastião\ da\ Grama\ \-\ SP",
"55513822", "Gravataí\ \-\ RS",
"55843330", "Itajá\ \-\ RN",
"55534062", "Pelotas\ \-\ RS",
"55143882", "Botucatu\ \-\ SP",
"55823302", "Maceió\ \-\ AL",
"55833554", "Nazarezinho\ \-\ PB",
"55313939", "Conselheiro\ Lafaiete\ \-\ MG",
"55633379", "Caseara\ \-\ TO",
"55273033", "Vila\ Velha\ \-\ ES",
"55163273", "Itápolis\ \-\ SP",
"55423434", "Guamirim\ \-\ PR",
"55733632", "Ilhéus\ \-\ BA",
"55633427", "Pequizeiro\ \-\ TO",
"55513720", "Estrêla\ \-\ RS",
"55553613", "Mato\ Queimado\ \-\ RS",
"55193862", "Mogi\ Mirim\ \-\ SP",
"55813642", "Condado\ \-\ PE",
"5579324", "Aracaju\ \-\ SE",
"55163973", "Guatapará\ \-\ SP",
"55143541", "Promissão\ \-\ SP",
"55824004", "Maceió\ \-\ AL",
"55114141", "Itapevi\ \-\ SP",
"55313239", "Belo\ Horizonte\ \-\ MG",
"55773415", "Ituaçu\ \-\ BA",
"55113514", "São\ Paulo\ \-\ SP",
"55913484", "Santarém\ Novo\ \-\ PA",
"55633653", "Arraias\ \-\ TO",
"55353866", "Santana\ do\ Jacaré\ \-\ MG",
"55793222", "Aracaju\ \-\ SE",
"55373288", "Araújos\ \-\ MG",
"55733668", "Trancoso\ \-\ BA",
"55312111", "Belo\ Horizonte\ \-\ MG",
"55643601", "São\ Luís\ de\ Montes\ Belos\ \-\ GO",
"55624012", "Goiânia\ \-\ GO",
"55493537", "Treze\ Tílias\ \-\ SC",
"55163392", "Américo\ Brasiliense\ \-\ SP",
"55353283", "Poço\ Fundo\ \-\ MG",
"55613303", "Brasília\ \-\ DF",
"55114871", "São\ Paulo\ \-\ SP",
"55663586", "Cocalinho\ \-\ MT",
"55353531", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55623282", "Aparecida\ de\ Goiânia\ \-\ GO",
"55133387", "Guarujá\ \-\ SP",
"55433572", "Londrina\ \-\ PR",
"55383754", "Três\ Marias\ \-\ MG",
"55753648", "Dom\ Macedo\ Costa\ \-\ BA",
"55433033", "Apucarana\ \-\ PR",
"55423524", "União\ da\ Vitória\ \-\ PR",
"55493653", "Anchieta\ \-\ SC",
"55773643", "Matina\ \-\ BA",
"55222773", "Macaé\ \-\ RJ",
"55273181", "Vitória\ \-\ ES",
"55143668", "Itaju\ \-\ SP",
"55983337", "Alcântara\ \-\ MA",
"55323425", "Santana\ de\ Cataguases\ \-\ MG",
"55673565", "Aparecida\ do\ Taboado\ \-\ MS",
"55923524", "Urucurituba\ \-\ AM",
"55115477", "Mogi\ das\ Cruzes\ \-\ SP",
"55553381", "São\ Miguel\ das\ Missões\ \-\ RS",
"55413622", "Lapa\ \-\ PR",
"55843062", "Mossoró\ \-\ RN",
"55333293", "São\ José\ da\ Safira\ \-\ MG",
"55713472", "Salvador\ \-\ BA",
"55623643", "Goiânia\ \-\ GO",
"55473274", "Jaraguá\ do\ Sul\ \-\ SC",
"55993537", "Senador\ La\ Roque\ \-\ MA",
"55513524", "Novo\ Hamburgo\ \-\ RS",
"55114916", "São\ Paulo\ \-\ SP",
"55112628", "São\ Paulo\ \-\ SP",
"55893447", "São\ José\ do\ Piauí\ \-\ PI",
"55143584", "Pirajuí\ \-\ SP",
"55513709", "Lajeado\ \-\ RS",
"55943315", "PA\ 275\ \-\ PA",
"55773475", "Rio\ de\ Contas\ \-\ BA",
"55963521", "Oiapoque\ \-\ AP",
"55493319", "Chapecó\ \-\ SC",
"55323021", "Ubá\ \-\ MG",
"55473625", "Irineópolis\ \-\ SC",
"55753680", "Rafael\ Jambeiro\ \-\ BA",
"55112705", "São\ Paulo\ \-\ SP",
"55163725", "Franca\ \-\ SP",
"55843392", "Antônio\ Martins\ \-\ RN",
"55473148", "Navegantes\ \-\ SC",
"55323265", "Descoberto\ \-\ MG",
"55743624", "Jacobina\ \-\ BA",
"55543237", "Bom\ Jesus\ \-\ RS",
"55413679", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55713285", "Salvador\ \-\ BA",
"55443665", "Icaraíma\ \-\ PR",
"55843336", "São\ Rafael\ \-\ RN",
"55193543", "Araras\ \-\ SP",
"55883542", "Missão\ Velha\ \-\ CE",
"55313123", "Belo\ Horizonte\ \-\ MG",
"55773664", "Paratinga\ \-\ BA",
"55383749", "Pirapora\ \-\ MG",
"55333284", "Frei\ Inocêncio\ \-\ MG",
"55153492", "Salto\ de\ Pirapora\ \-\ SP",
"55613562", "Taguatinga\ \-\ DF",
"55115102", "São\ Paulo\ \-\ SP",
"55653695", "Várzea\ Grande\ \-\ MT",
"55333312", "Mutum\ \-\ MG",
"55513726", "Lajeado\ \-\ RS",
"55124611", "Cotia\ \-\ SP",
"55353294", "Alterosa\ \-\ MG",
"55633685", "Combinado\ \-\ TO",
"55313553", "Cachoeira\ do\ Campo\ \-\ MG",
"55483432", "Içara\ \-\ SC",
"55433529", "Jacarezinho\ \-\ PR",
"55313887", "Acaiaca\ \-\ MG",
"55173815", "Guaraci\ \-\ SP",
"55883631", "Itapipoca\ \-\ CE",
"55623588", "Aparecida\ de\ Goiânia\ \-\ GO",
"55123672", "Tremembé\ \-\ SP",
"55813762", "Garanhuns\ \-\ PE",
"55473501", "Jaraguá\ do\ Sul\ \-\ SC",
"55843608", "Natal\ \-\ RN",
"55313637", "Santa\ Luzia\ \-\ MG",
"55143318", "Marília\ \-\ SP",
"55873789", "Brejão\ \-\ PE",
"55793279", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55194003", "Campinas\ \-\ SP",
"55493322", "Chapecó\ \-\ SC",
"55853123", "Caucaia\ \-\ CE",
"55114976", "Santo\ André\ \-\ SP",
"55114701", "Taboão\ da\ Serra\ \-\ SP",
"55713412", "Salvador\ \-\ BA",
"55483356", "Imbituba\ \-\ SC",
"55163357", "Araraquara\ \-\ SP",
"55353261", "Campanha\ \-\ MG",
"55834009", "João\ Pessoa\ \-\ PB",
"55813738", "Cupira\ \-\ PE",
"55493556", "Brunópolis\ \-\ SC",
"55273278", "Acioli\ \-\ ES",
"55193934", "Indaiatuba\ \-\ SP",
"55623374", "Itapirapuã\ \-\ GO",
"55212704", "Niterói\ \-\ RJ",
"55633322", "Palmas\ \-\ TO",
"55483522", "Araranguá\ \-\ SC",
"55333241", "Mantena\ \-\ MG",
"55933512", "Santarém\ \-\ PA",
"55653247", "Reserva\ do\ Cabaçal\ \-\ MT",
"55993556", "Mirador\ \-\ MA",
"55333329", "Caratinga\ \-\ MG",
"55843273", "São\ José\ de\ Mipibu\ \-\ RN",
"55713667", "Mata\ de\ São\ João\ \-\ BA",
"55323251", "Santos\ Dumont\ \-\ MG",
"55433512", "Arapoti\ \-\ PR",
"55343817", "Coromandel\ \-\ MG",
"55553359", "Cerro\ Largo\ \-\ RS",
"55553363", "São\ Nicolau\ \-\ RS",
"55114811", "Franco\ da\ Rocha\ \-\ SP",
"55853650", "Carnaubal\ \-\ CE",
"55983468", "São\ Benedito\ do\ Rio\ Preto\ \-\ MA",
"55193798", "Campinas\ \-\ SP",
"5511273", "São\ Paulo\ \-\ SP",
"55773691", "Malhada\ \-\ BA",
"55153526", "Itapeva\ \-\ SP",
"55373301", "Divinópolis\ \-\ MG",
"55813255", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55114202", "Carapicuíba\ \-\ SP",
"55473382", "Timbó\ \-\ SC",
"55623546", "Goiânia\ \-\ GO",
"55153205", "Tatuí\ \-\ SP",
"55913822", "Quatipuru\ \-\ PA",
"55213222", "Rio\ de\ Janeiro\ \-\ RJ",
"55483275", "Rancho\ Queimado\ \-\ SC",
"55663536", "Marcelândia\ \-\ MT",
"55144103", "Jaú\ \-\ SP",
"55823531", "Batalha\ \-\ AL",
"55212391", "Rio\ de\ Janeiro\ \-\ RJ",
"55433451", "São\ Pedro\ do\ Ivaí\ \-\ PR",
"55893573", "Corrente\ \-\ PI",
"55163386", "Dobrada\ \-\ SP",
"55473130", "Joinville\ \-\ SC",
"55193888", "Paulínia\ \-\ SP",
"55423277", "Ortigueira\ \-\ PR",
"55733534", "Jaguaquara\ \-\ BA",
"55833299", "Pitimbu\ \-\ PB",
"55863291", "Jardim\ do\ Mulato\ \-\ PI",
"55693451", "Pimenta\ Bueno\ \-\ RO",
"55663592", "Brasnorte\ \-\ MT",
"55373238", "Pará\ de\ Minas\ \-\ MG",
"5511269", "São\ Paulo\ \-\ SP",
"55623932", "Goiânia\ \-\ GO",
"55823283", "Viçosa\ \-\ AL",
"55833077", "Campina\ Grande\ \-\ PB",
"55313535", "Mateus\ Leme\ \-\ MG",
"55913434", "Garrafão\ do\ Norte\ \-\ PA",
"55613415", "Brasília\ \-\ DF",
"55513619", "Rio\ Grande\ do\ Sul",
"55313324", "Belo\ Horizonte\ \-\ MG",
"55713121", "Camaçari\ \-\ BA",
"55513441", "Cachoeirinha\ \-\ RS",
"55813544", "Ilha\ de\ Itamaracá\ \-\ PE",
"55143325", "Ourinhos\ \-\ SP",
"55542102", "Bento\ Gonçalves\ \-\ RS",
"55993587", "São\ Francisco\ do\ Brejão\ \-\ MA",
"55114134", "Barueri\ \-\ SP",
"5551364", "Rio\ Grande\ do\ Sul",
"55114043", "Diadema\ \-\ SP",
"55373755", "Morada\ Nova\ de\ Minas\ \-\ MG",
"55653028", "Cuiabá\ \-\ MT",
"55142109", "Bauru\ \-\ SP",
"55443639", "Umuarama\ \-\ PR",
"55694062", "Porto\ Velho\ \-\ RO",
"55353842", "Nazareno\ \-\ MG",
"55473390", "Itajaí\ \-\ SC",
"55813106", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55434062", "Londrina\ \-\ PR",
"55823642", "Mata\ Grande\ \-\ AL",
"5592364", "Manaus\ \-\ AM",
"55553331", "Ijuí\ \-\ RS",
"55813376", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55193306", "Sumaré\ \-\ SP",
"55112828", "Santo\ André\ \-\ SP",
"55443256", "Ângulo\ \-\ PR",
"55473098", "Itapema\ \-\ SC",
"55983387", "Palmeirândia\ \-\ MA",
"55443567", "Quinta\ do\ Sol\ \-\ PR",
"55513099", "São\ Leopoldo\ \-\ RS",
"55484053", "Criciúma\ \-\ SC",
"55753259", "Euclides\ da\ Cunha\ \-\ BA",
"55213219", "Rio\ de\ Janeiro\ \-\ RJ",
"55753263", "Valente\ \-\ BA",
"55753692", "Paulo\ Afonso\ \-\ BA",
"55673269", "Guia\ Lopes\ da\ Laguna\ \-\ MS",
"55353544", "Ibiraci\ \-\ MG",
"55853324", "Caridade\ \-\ CE",
"55753636", "Nazaré\ \-\ BA",
"55183918", "Presidente\ Prudente\ \-\ SP",
"55733243", "Floresta\ Azul\ \-\ BA",
"55115934", "São\ Paulo\ \-\ SP",
"55623303", "Montes\ Claros\ de\ Goiás\ \-\ GO",
"55513484", "Gravataí\ \-\ RS",
"5537", "Minas\ Gerais",
"55813581", "Chã\ de\ Alegria\ \-\ PE",
"55513622", "Arroio\ Teixeira\ \-\ RS",
"55193846", "Vinhedo\ \-\ SP",
"55273773", "São\ Mateus\ \-\ ES",
"55163348", "Motuca\ \-\ SP",
"55283517", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55114495", "Itatiba\ \-\ SP",
"55313289", "Minas\ Gerais",
"55273364", "Guarapari\ \-\ ES",
"55433465", "Rosário\ do\ Ivaí\ \-\ PR",
"5531350", "Minas\ Gerais",
"55313856", "São\ Domingos\ do\ Prata\ \-\ MG",
"55114454", "Santo\ André\ \-\ SP",
"5515323", "Sorocaba\ \-\ SP",
"55823421", "Palmeira\ dos\ Índios\ \-\ AL",
"55193662", "Caconde\ \-\ SP",
"55883659", "Croatá\ \-\ CE",
"55373262", "Lagoa\ da\ Prata\ \-\ MG",
"55733682", "Teixeira\ de\ Freitas\ \-\ BA",
"55883663", "Bela\ Cruz\ \-\ CE",
"55693465", "Teixeirópolis\ \-\ RO",
"55613540", "Brazlândia\ \-\ DF",
"55353698", "Alfenas\ \-\ MG",
"55243324", "Barra\ Mansa\ \-\ RJ",
"55863264", "José\ de\ Freitas\ \-\ PI",
"55133579", "São\ Vicente\ \-\ SP",
"55933542", "Jacareacanga\ \-\ PA",
"55132101", "Santos\ \-\ SP",
"55423552", "General\ Carneiro\ \-\ PR",
"55383722", "Curvelo\ \-\ MG",
"55373333", "Carmópolis\ de\ Minas\ \-\ MG",
"55883529", "Milhã\ \-\ CE",
"55973423", "Fonte\ Boa\ \-\ AM",
"55115816", "São\ Paulo\ \-\ SP",
"55193458", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55113129", "São\ Paulo\ \-\ SP",
"55493719", "Capinzal\ \-\ SC",
"55414107", "Curitiba\ \-\ PR",
"55793254", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55633483", "Bom\ Jesus\ do\ Tocantins\ \-\ TO",
"55183743", "Ilha\ Solteira\ \-\ SP",
"55533027", "Pelotas\ \-\ RS",
"55162109", "Araraquara\ \-\ SP",
"55893477", "Inhuma\ \-\ PI",
"55193366", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55113559", "São\ Paulo\ \-\ SP",
"55623516", "Goianira\ \-\ GO",
"55222566", "Bom\ Jardim\ \-\ RJ",
"55663212", "Sorriso\ \-\ MT",
"55914107", "Ananindeua\ \-\ PA",
"55513552", "Lindolfo\ Collor\ \-\ RS",
"55673498", "Caarapó\ \-\ MS",
"55313448", "Minas\ Gerais",
"55843291", "Santa\ Cruz\ \-\ RN",
"55773499", "Sussuarana\ \-\ BA",
"55283558", "Jerônimo\ Monteiro\ \-\ ES",
"55443463", "Paranacity\ \-\ PR",
"55543035", "Farroupilha\ \-\ RS",
"55913015", "Belém\ \-\ PA",
"55423122", "Ponta\ Grossa\ \-\ PR",
"55343847", "Abadia\ dos\ Dourados\ \-\ MG",
"55683342", "Rodrigues\ Alves\ \-\ AC",
"55383221", "Montes\ Claros\ \-\ MG",
"55433542", "Bandeirantes\ \-\ PR",
"55143386", "Taguaí\ \-\ SP",
"55433174", "Cambé\ \-\ PR",
"55473423", "Joinville\ \-\ SC",
"55433304", "Londrina\ \-\ PR",
"55122128", "Jacareí\ \-\ SP",
"55753332", "Palmeiras\ \-\ BA",
"55813362", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55773673", "Oliveira\ dos\ Brejinhos\ \-\ BA",
"55484020", "Florianópolis\ \-\ SC",
"55473533", "Ituporanga\ \-\ SC",
"5531356", "Minas\ Gerais",
"55843264", "Taipu\ \-\ RN",
"55163243", "Monte\ Alto\ \-\ SP",
"55683211", "Rio\ Branco\ \-\ AC",
"55913753", "Barcarena\ \-\ PA",
"55883512", "Juazeiro\ do\ Norte\ \-\ CE",
"55183644", "Birigui\ \-\ SP",
"55193513", "Limeira\ \-\ SP",
"55153251", "Tatuí\ \-\ SP",
"55753456", "Cardeal\ da\ Silva\ \-\ BA",
"55113112", "São\ Paulo\ \-\ SP",
"55813030", "Paulista\ \-\ PE",
"55653353", "Acorizal\ \-\ MT",
"55213847", "Rio\ de\ Janeiro\ \-\ RJ",
"55993221", "Imperatriz\ \-\ MA",
"55713621", "Camaçari\ \-\ BA",
"55193602", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55984009", "São\ Luís\ \-\ MA",
"55163943", "Barrinha\ \-\ SP",
"55894101", "Picos\ \-\ PI",
"55493349", "Irati\ \-\ SC",
"55823346", "Maceió\ \-\ AL",
"55883603", "Cruz\ \-\ CE",
"55813338", "Recife\ \-\ PE",
"55673466", "Glória\ de\ Dourados\ \-\ MS",
"55412118", "Curitiba\ \-\ PR",
"55663578", "Itanhangá\ \-\ MT",
"55813198", "Recife\ \-\ PE",
"55553546", "Alecrim\ \-\ RS",
"55123025", "Taubaté\ \-\ SP",
"55133323", "Santos\ \-\ SP",
"55274002", "Vitória\ \-\ ES",
"55114634", "Poá\ \-\ SP",
"55833356", "Cabaceiras\ \-\ PB",
"55484009", "Florianópolis\ \-\ SC",
"55753203", "Jeremoabo\ \-\ BA",
"55474104", "São\ Bento\ do\ Sul\ \-\ SC",
"55222644", "Cabo\ Frio\ \-\ RJ",
"55623363", "Porangatu\ \-\ GO",
"55883439", "Ibaretama\ \-\ CE",
"55173845", "Meridiano\ \-\ SP",
"55533257", "Piratini\ \-\ RS",
"55623359", "Jesúpolis\ \-\ GO",
"55123961", "Jacareí\ \-\ SP",
"55212631", "Magé\ \-\ RJ",
"55373276", "Conceição\ do\ Pará\ \-\ MG",
"55333342", "Durandé\ \-\ MG",
"5563331", "Gurupi\ \-\ TO",
"55163832", "Ipuã\ \-\ SP",
"55833522", "Sousa\ \-\ PB",
"55193447", "Piracicaba\ \-\ SP",
"55193816", "Indaiatuba\ \-\ SP",
"55114755", "Itaquaquecetuba\ \-\ SP",
"55113421", "Mauá\ \-\ SP",
"55193772", "Campinas\ \-\ SP",
"5531328", "Belo\ Horizonte\ \-\ MG",
"55813086", "Recife\ \-\ PE",
"55123842", "Ubatuba\ \-\ SP",
"55414121", "Fazenda\ Rio\ Grande\ \-\ PR",
"55443521", "Goioerê\ \-\ PR",
"55313724", "Cristiano\ Otoni\ \-\ MG",
"55163010", "Araraquara\ \-\ SP",
"55354141", "Poços\ de\ Caldas\ \-\ MG",
"55983652", "Bom\ Jesus\ das\ Selvas\ \-\ MA",
"55553232", "São\ Gabriel\ \-\ RS",
"55513075", "Canoas\ \-\ RS",
"55993626", "Pedreiras\ \-\ MA",
"55212791", "Nilópolis\ \-\ RJ",
"55313430", "Minas\ Gerais",
"55613613", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55212659", "Magé\ \-\ RJ",
"55483652", "Grão\ Pará\ \-\ SC",
"55123666", "Santo\ Antônio\ do\ Pinhal\ \-\ SP",
"5564392", "Itumbiara\ \-\ GO",
"55833275", "Serraria\ \-\ PB",
"55193706", "Campinas\ \-\ SP",
"55623331", "Pirenópolis\ \-\ GO",
"55833387", "São\ Sebastião\ de\ Lagoa\ de\ Roça\ \-\ PB",
"55823629", "Ouro\ Branco\ \-\ AL",
"55493626", "Bandeirante\ \-\ SC",
"55163690", "Jardinópolis\ \-\ SP",
"55883451", "Dom\ Maurício\ \-\ CE",
"55973561", "Coari\ \-\ AM",
"55713167", "Salvador\ \-\ BA",
"55353829", "Lavras\ \-\ MG",
"55813201", "Recife\ \-\ PE",
"55513785", "Rio\ Grande\ do\ Sul",
"55373355", "Doresópolis\ \-\ MG",
"55613502", "Luziânia\ \-\ GO",
"5511362", "São\ Paulo\ \-\ SP",
"55543345", "Sertão\ \-\ RS",
"55133852", "Ariri\ \-\ SP",
"55283547", "Conceição\ do\ Castelo\ \-\ ES",
"55513411", "Alvorada\ \-\ RS",
"55453540", "São\ Miguel\ do\ Iguaçu\ \-\ PR",
"55943431", "Santana\ do\ Araguaia\ \-\ PA",
"55313397", "Contagem\ \-\ MG",
"55513649", "Montenegro\ \-\ RS",
"55212103", "Rio\ de\ Janeiro\ \-\ RJ",
"55543444", "Serafina\ Corrêa\ \-\ RS",
"55124004", "São\ José\ dos\ Campos\ \-\ SP",
"55123106", "Silveiras\ \-\ SP",
"55893591", "Jurema\ \-\ PI",
"55553303", "Cruz\ Alta\ \-\ RS",
"55183286", "Anhumas\ \-\ SP",
"55112751", "São\ Paulo\ \-\ SP",
"55273373", "Linhares\ \-\ ES",
"55433560", "Cornélio\ Procópio\ \-\ PR",
"55883674", "Acaraú\ \-\ CE",
"55373361", "Oliveira\ \-\ MG",
"5532323", "Juiz\ de\ Fora\ \-\ MG",
"55823036", "Maceió\ \-\ AL",
"55863273", "Curralinhos\ \-\ PI",
"55643942", "Itumbiara\ \-\ GO",
"55313520", "Minas\ Gerais",
"55313623", "São\ José\ da\ Lapa\ \-\ MG",
"55693236", "Porto\ Velho\ \-\ RO",
"55114693", "Guararema\ \-\ SP",
"55123302", "São\ José\ dos\ Campos\ \-\ SP",
"55114761", "Mogi\ das\ Cruzes\ \-\ SP",
"55753274", "Cansanção\ \-\ BA",
"55453282", "Pato\ Bragado\ \-\ PR",
"55843696", "Caiçara\ do\ Norte\ \-\ RN",
"55423649", "Guará\ \-\ PR",
"55533248", "Pinheiro\ Machado\ \-\ RS",
"55115090", "São\ Paulo\ \-\ SP",
"55112473", "Bragança\ Paulista\ \-\ SP",
"55493907", "Lages\ \-\ SC",
"55653335", "Agrovila\ das\ Palmeiras\ \-\ MT",
"55153478", "Pilar\ do\ Sul\ \-\ SP",
"55873875", "Cabrobó\ \-\ PE",
"5592361", "Manaus\ \-\ AM",
"55713460", "Salvador\ \-\ BA",
"55553268", "Dona\ Francisca\ \-\ RS",
"55443431", "Paraíso\ do\ Norte\ \-\ PR",
"55143357", "Óleo\ \-\ SP",
"55343249", "Araguari\ \-\ MG",
"55613381", "Guará\ \-\ DF",
"55383626", "Ibiracatu\ \-\ MG",
"55273764", "Pedro\ Canário\ \-\ ES",
"55173699", "Pontalinda\ \-\ SP",
"55843378", "São\ Francisco\ do\ Oeste\ \-\ RN",
"55114013", "Itu\ \-\ SP",
"55123018", "São\ José\ dos\ Campos\ \-\ SP",
"55793545", "Tomar\ do\ Geru\ \-\ SE",
"55143452", "Pompéia\ \-\ SP",
"55553290", "Santa\ Maria\ \-\ RS",
"55513654", "Triunfo\ \-\ RS",
"55353346", "Cruzília\ \-\ MG",
"55543459", "Bento\ Gonçalves\ \-\ RS",
"55643655", "Paranaiguara\ \-\ GO",
"55614501", "Brasília\ \-\ DF",
"55473231", "Blumenau\ \-\ SC",
"55513695", "Harmonia\ \-\ RS",
"55153553", "Ribeirão\ Branco\ \-\ SP",
"55413552", "Araucária\ \-\ PR",
"55813080", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55983323", "Centro\ do\ Guilherme\ \-\ MA",
"55643694", "Palmelo\ \-\ GO",
"55533304", "Santa\ Maria\ \-\ RS",
"55933598", "Jamanchizinho\ \-\ PA",
"55115068", "São\ Paulo\ \-\ SP",
"55853352", "Pentecoste\ \-\ CE",
"55514", "Rio\ Grande\ do\ Sul",
"55193911", "Mogi\-Guaçu\ \-\ SP",
"556232", "Goiânia\ \-\ GO",
"55833215", "João\ Pessoa\ \-\ PB",
"55143273", "Fernão\ \-\ SP",
"55193802", "Holambra\ \-\ SP",
"55212681", "Seropédica\ \-\ RJ",
"55243352", "Itatiaia\ \-\ RJ",
"55493523", "Luzerna\ \-\ SC",
"55423654", "Catuporanga\ \-\ PR",
"55273257", "Ibiraçu\ \-\ ES",
"55613041", "Brasília\ \-\ DF",
"55753501", "Paulo\ Afonso\ \-\ BA",
"55643014", "Jataí\ \-\ GO",
"55313436", "Minas\ Gerais",
"55472122", "Balneário\ Camboriú\ \-\ SC",
"55114684", "Juquitiba\ \-\ SP",
"55743549", "Rômulo\ Campos\ \-\ BA",
"551", "São\ Paulo",
"55212743", "Teresópolis\ \-\ RJ",
"55733273", "Pau\ Brasil\ \-\ BA",
"5522252", "Nova\ Friburgo\ \-\ RJ",
"55673442", "Ivinhema\ \-\ MS",
"55643548", "Itumbiara\ \-\ GO",
"55413122", "Curitiba\ \-\ PR",
"55313067", "Itabira\ \-\ MG",
"55193876", "Vinhedo\ \-\ SP",
"55663435", "Tesouro\ \-\ MT",
"55273743", "Colatina\ \-\ ES",
"55633433", "Palmeiras\ do\ Tocantins\ \-\ TO",
"55333513", "Campanário\ \-\ MG",
"55663525", "Carlinda\ \-\ MT",
"5567342", "Dourados\ \-\ MS",
"55222542", "Nova\ Friburgo\ \-\ RJ",
"55115616", "São\ Paulo\ \-\ SP",
"55353716", "Poços\ de\ Caldas\ \-\ MG",
"55913119", "Belém\ \-\ PA",
"55114532", "Jundiaí\ \-\ SP",
"55373383", "Carmo\ da\ Mata\ \-\ MG",
"55693230", "Candeias\ do\ Jamari\ \-\ RO",
"55183631", "Araçatuba\ \-\ SP",
"55513753", "Roca\ Sales\ \-\ RS",
"55313526", "Minas\ Gerais",
"55823338", "Maceió\ \-\ AL",
"55513769", "Rio\ Grande\ do\ Sul",
"55114596", "Várzea\ Paulista\ \-\ SP",
"55923247", "Manaus\ \-\ AM",
"55123112", "Potim\ \-\ SP",
"55163668", "Santo\ Antônio\ da\ Alegria\ \-\ SP",
"55833624", "João\ Pessoa\ \-\ PB",
"55433257", "Pitangueiras\ \-\ PR",
"55913854", "Maracanã\ \-\ PA",
"55833482", "Imaculada\ \-\ PB",
"55433566", "Carlópolis\ \-\ PR",
"55223847", "Raposo\ \-\ RJ",
"55493433", "Xanxerê\ \-\ SC",
"55482101", "Criciúma\ \-\ SC",
"55643661", "Mineiros\ \-\ GO",
"55114783", "Embu\ das\ Artes\ \-\ SP",
"55483245", "Santo\ Amaro\ da\ Imperatriz\ \-\ SC",
"55553538", "Boa\ Vista\ do\ Buricá\ \-\ RS",
"55643586", "Itumbiara\ \-\ GO",
"55613084", "Luziânia\ \-\ GO",
"55893543", "Antônio\ Almeida\ \-\ PI",
"55883614", "Sobral\ \-\ CE",
"55423247", "Ivaí\ \-\ PR",
"55663601", "Nova\ Fronteira\ \-\ MT",
"55273313", "São\ Mateus\ \-\ ES",
"55383523", "Felício\ dos\ Santos\ \-\ MG",
"55115032", "São\ Paulo\ \-\ SP",
"55114419", "Mairiporã\ \-\ SP",
"55114641", "Itaquaquecetuba\ \-\ SP",
"55613363", "Guará\ \-\ DF",
"55613359", "Samambaia\ Sul\ \-\ DF",
"55963689", "Afuá\ \-\ PA",
"55513471", "Cachoeirinha\ \-\ RS",
"55773613", "Barreiras\ \-\ BA",
"55833228", "Cabedelo\ \-\ PB",
"55633354", "Cristalândia\ \-\ TO",
"55843243", "Goianinha\ \-\ RN",
"55323724", "Eugenópolis\ \-\ MG",
"55623093", "Goiânia\ \-\ GO",
"55653619", "Cuiabá\ \-\ MT",
"55183659", "Bilac\ \-\ SP",
"55123421", "Taubaté\ \-\ SP",
"55833490", "Bonito\ de\ Santa\ Fé\ \-\ PB",
"55222791", "Macaé\ \-\ RJ",
"55112547", "São\ Paulo\ \-\ SP",
"55423028", "Ponta\ Grossa\ \-\ PR",
"55183992", "Narandiba\ \-\ SP",
"55633461", "Brasilândia\ do\ Tocantins\ \-\ TO",
"55114893", "Campo\ Limpo\ Paulista\ \-\ SP",
"55493354", "Marema\ \-\ SC",
"55173547", "Itajobi\ \-\ SP",
"55843424", "Ipueira\ \-\ RN",
"55923028", "Manaus\ \-\ AM",
"55943345", "Jacundá\ \-\ PA",
"55613331", "Recanto\ das\ Emas\ \-\ DF",
"55113581", "Barueri\ \-\ SP",
"55513597", "Campo\ Bom\ \-\ RS",
"55673926", "Ponta\ Porã\ \-\ MS",
"55634052", "Palmas\ \-\ TO",
"55713717", "Camaçari\ \-\ BA",
"55223321", "Rio\ das\ Ostras\ \-\ RJ",
"55333082", "Governador\ Valadares\ \-\ MG",
"55153324", "Tatuí\ \-\ SP",
"5512362", "Taubaté\ \-\ SP",
"5565364", "Cuiabá\ \-\ MT",
"55153535", "Nova\ Campina\ \-\ SP",
"55273248", "Aracê\ \-\ ES",
"55623344", "Uruana\ \-\ GO",
"55453232", "Guaraniaçu\ \-\ PR",
"55643633", "Lagoa\ do\ Bauzinho\ \-\ GO",
"55952121", "Boa\ Vista\ \-\ RR",
"55114246", "Mairinque\ \-\ SP",
"55673226", "Ladário\ \-\ MS",
"55553744", "Frederico\ Westphalen\ \-\ RS",
"55733204", "Itaju\ do\ Colônia\ \-\ BA",
"55623502", "Bela\ Vista\ de\ Goiás\ \-\ GO",
"55823201", "Maceió\ \-\ AL",
"55653277", "Caramujo\ \-\ MT",
"55613703", "Brasília\ \-\ DF",
"55373216", "Divinópolis\ \-\ MG",
"55513958", "Charqueadas\ \-\ RS",
"55623445", "Damianópolis\ \-\ GO",
"55753437", "Nova\ Soure\ \-\ BA",
"55113376", "São\ Paulo\ \-\ SP",
"55222103", "Nova\ Friburgo\ \-\ RJ",
"55643998", "Itumbiara\ \-\ GO",
"55153289", "Ibiúna\ \-\ SP",
"55733046", "Jequié\ \-\ BA",
"55553282", "Lavras\ do\ Sul\ \-\ RS",
"55733511", "Eunápolis\ \-\ BA",
"55873828", "Tuparetama\ \-\ PE",
"55743652", "Ibititá\ \-\ BA",
"55453268", "Santa\ Helena\ \-\ PR",
"55913411", "Capanema\ \-\ PA",
"55843534", "Pedro\ Avelino\ \-\ RN",
"55843325", "Upanema\ \-\ RN",
"55473263", "Balneário\ Camboriú\ \-\ SC",
"55773445", "Condeúba\ \-\ BA",
"55493455", "Alto\ Bela\ Vista\ \-\ SC",
"55833350", "Ouro\ Velho\ \-\ PB",
"55512125", "Porto\ Alegre\ \-\ RS",
"55443444", "São\ Pedro\ do\ Paraná\ \-\ PR",
"55513179", "Taquara\ \-\ RS",
"55553643", "Boa\ Vista\ do\ Cadeado\ \-\ RS",
"55833058", "Campina\ Grande\ \-\ PB",
"55183373", "Tarumã\ \-\ SP",
"55413649", "Campo\ Largo\ \-\ PR",
"55513735", "Várzea\ do\ Capivarita\ \-\ RS",
"55133299", "Santos\ \-\ SP",
"55623381", "Estrela\ do\ Norte\ \-\ GO",
"55193573", "Leme\ \-\ SP",
"55553314", "Santo\ Ângelo\ \-\ RS",
"55353629", "Itajubá\ \-\ MG",
"55633494", "Barra\ do\ Ouro\ \-\ TO",
"55922125", "Manaus\ \-\ AM",
"55222764", "Rio\ das\ Ostras\ \-\ RJ",
"55313480", "Minas\ Gerais",
"55633455", "Nazaré\ \-\ TO",
"55193032", "Campinas\ \-\ SP",
"55553781", "Santo\ Augusto\ \-\ RS",
"55873882", "Serrita\ \-\ PE",
"55553228", "Boca\ do\ Monte\ \-\ RS",
"55673683", "Rio\ Verde\ de\ Mato\ Grosso\ \-\ MS",
"55493018", "Lages\ \-\ SC",
"55173330", "Guaíra\ \-\ SP",
"55513140", "Novo\ Hamburgo\ \-\ RS",
"55153572", "Itaberá\ \-\ SP",
"55413573", "Curitiba\ \-\ PR",
"55413032", "Campo\ Largo\ \-\ PR",
"55483344", "Palhoça\ \-\ SC",
"55453275", "São\ Clemente\ \-\ PR",
"55143473", "Alvinlândia\ \-\ SP",
"55273724", "Marilândia\ \-\ ES",
"55123185", "Lorena\ \-\ SP",
"5553323", "Rio\ Grande\ \-\ RS",
"55143252", "Pederneiras\ \-\ SP",
"55115854", "São\ Paulo\ \-\ SP",
"55413096", "São\ José\ dos\ Pinhais\ \-\ PR",
"55713298", "Simões\ Filho\ \-\ BA",
"55543259", "Nova\ Sardenha\ \-\ RS",
"55383740", "Pirapora\ \-\ MG",
"55813869", "Santa\ Maria\ da\ Boa\ Vista\ \-\ PE",
"55493544", "Campos\ Novos\ \-\ SC",
"55373249", "Itaúna\ \-\ MG",
"55613299", "Brasília\ \-\ DF",
"55193649", "Águas\ da\ Prata\ \-\ SP",
"55383233", "Francisco\ Sá\ \-\ MG",
"55443555", "Nice\ \-\ PR",
"55853373", "Acarape\ \-\ CE",
"55633376", "Barrolândia\ \-\ TO",
"55443648", "Santa\ Rita\ do\ Oeste\ \-\ PR",
"55973431", "São\ Paulo\ de\ Olivença\ \-\ AM",
"55993544", "Loreto\ \-\ MA",
"55433623", "Porecatu\ \-\ PR",
"55383842", "Salinas\ \-\ MG",
"55433520", "Cornélio\ Procópio\ \-\ PR",
"55673242", "Miranda\ \-\ MS",
"55313292", "Belo\ Horizonte\ \-\ MG",
"55283511", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55373321", "Formiga\ \-\ MG",
"55683028", "Rio\ Branco\ \-\ AC",
"55313663", "Pedro\ Leopoldo\ \-\ MG",
"55343454", "Carneirinho\ \-\ MG",
"55963214", "Macapá\ \-\ AP",
"55484042", "Balneário\ Camboriú\ \-\ SC",
"5511310", "São\ Paulo\ \-\ SP",
"55243373", "Paraty\ \-\ RJ",
"55214503", "Rio\ de\ Janeiro\ \-\ RJ",
"55443125", "Marialva\ \-\ PR",
"55483093", "Palhoça\ \-\ SC",
"55623595", "Goiânia\ \-\ GO",
"55823427", "Minador\ do\ Negrão\ \-\ AL",
"55183823", "Dracena\ \-\ SP",
"55693623", "Seringueiras\ \-\ RO",
"55333735", "Coronel\ Murta\ \-\ MG",
"55623554", "Varjão\ \-\ GO",
"55913032", "Ananindeua\ \-\ PA",
"55313236", "Belo\ Horizonte\ \-\ MG",
"55883425", "Ibicuitinga\ \-\ CE",
"55353853", "Campos\ Gerais\ \-\ MG",
"55883535", "Assaré\ \-\ CE",
"55143765", "Águas\ de\ Santa\ Bárbara\ \-\ SP",
"55423271", "Telêmaco\ Borba\ \-\ PR",
"55212397", "Duque\ de\ Caxias\ \-\ RJ",
"5511366", "São\ Paulo\ \-\ SP",
"55823537", "Campo\ Grande\ \-\ AL",
"55483381", "São\ José\ \-\ SC",
"55454053", "Foz\ do\ Iguaçu\ \-\ PR",
"55313373", "Belo\ Horizonte\ \-\ MG",
"55833282", "Pilar\ \-\ PB",
"55753414", "Cachoeira\ \-\ BA",
"55114052", "São\ Paulo\ \-\ SP",
"55493233", "São\ Joaquim\ \-\ SC",
"5511587", "São\ Paulo\ \-\ SP",
"55633233", "Palmas\ \-\ TO",
"55343671", "São\ Gotardo\ \-\ MG",
"55863297", "Agricolândia\ \-\ PI",
"55343355", "Pedrinópolis\ \-\ MG",
"55513447", "Alvorada\ \-\ RS",
"55613408", "Brasília\ \-\ DF",
"55113135", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55513772", "Arvorezinha\ \-\ RS",
"55113395", "Jundiaí\ \-\ SP",
"55424063", "Ponta\ Grossa\ \-\ PR",
"55113354", "São\ Paulo\ \-\ SP",
"55473521", "Rio\ do\ Sul\ \-\ SC",
"55513271", "Novo\ Hamburgo\ \-\ RS",
"55323286", "Santo\ Antônio\ do\ Aventureiro\ \-\ MG",
"55993666", "Santo\ Antônio\ dos\ Lopes\ \-\ MA",
"55443686", "Palotina\ \-\ PR",
"55833314", "São\ José\ da\ Mata\ \-\ PB",
"55752102", "Feira\ de\ Santana\ \-\ BA",
"55313764", "Conselheiro\ Lafaiete\ \-\ MG",
"55713633", "Vera\ Cruz\ \-\ BA",
"55143022", "Avaré\ \-\ SP",
"55983381", "Pinheiro\ \-\ MA",
"55273137", "Vitória\ \-\ ES",
"55513706", "Rio\ Grande\ do\ Sul",
"55423447", "São\ João\ do\ Triunfo\ \-\ PR",
"55333753", "Medina\ \-\ MG",
"55143404", "Tupã\ \-\ SP",
"55153343", "Votorantim\ \-\ SP",
"55833290", "Conde\ \-\ PB",
"55513602", "Caraá\ \-\ RS",
"55483034", "São\ José\ \-\ SC",
"55623323", "Ceres\ \-\ GO",
"55423676", "Faxinal\ da\ Boa\ Vista\ \-\ PR",
"55633025", "Palmas\ \-\ TO",
"55614020", "Brasília\ \-\ DF",
"55163351", "São\ Carlos\ \-\ SP",
"55353267", "Paraguaçu\ \-\ MG",
"55833562", "Poço\ Dantas\ \-\ PB",
"55813319", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55114707", "Jandira\ \-\ SP",
"55663472", "Serra\ Dourada\ \-\ MT",
"55353556", "Arceburgo\ \-\ MG",
"55853304", "Fortaleza\ \-\ CE",
"55513610", "Rio\ Grande\ do\ Sul",
"55833428", "Mãe\ d\'Água\ \-\ PB",
"55893493", "Acauã\ \-\ PI",
"55143845", "Conchas\ \-\ SP",
"55193895", "Socorro\ \-\ SP",
"55353322", "Seritinga\ \-\ MG",
"55493025", "Chapecó\ \-\ SC",
"55653241", "Mirassol\ D\'Oeste\ \-\ MT",
"55333247", "Itabirinha\ \-\ MG",
"55123221", "Caçapava\ \-\ SP",
"55133208", "Santos\ \-\ SP",
"55513676", "Arambaré\ \-\ RS",
"55883418", "Jaguaruana\ \-\ CE",
"55653329", "Tangará\ da\ Serra\ \-\ MT",
"55383255", "Botumirim\ \-\ MG",
"55413146", "São\ José\ dos\ Pinhais\ \-\ PR",
"55114817", "Jundiaí\ \-\ SP",
"55113433", "Embu\ das\ Artes\ \-\ SP",
"55313844", "Cava\ Grande\ \-\ MG",
"55114446", "Cajamar\ \-\ SP",
"55753328", "Ibiquera\ \-\ BA",
"55343811", "Presidente\ Olegário\ \-\ MG",
"55663406", "Torixoréu\ \-\ MT",
"55323257", "Juiz\ de\ Fora\ \-\ MG",
"55624105", "Senador\ Canedo\ \-\ GO",
"55843224", "Natal\ \-\ RN",
"55813685", "Quipapá\ \-\ PE",
"55323743", "Divino\ \-\ MG",
"55873964", "Serrolândia\ \-\ PE",
"55913729", "Paragominas\ \-\ PA",
"55173571", "Santa\ Adélia\ \-\ SP",
"55452031", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55473399", "Timbó\ \-\ SC",
"55673260", "Alcinópolis\ \-\ MS",
"55623945", "Goiânia\ \-\ GO",
"55643498", "Professor\ Jamil\ \-\ GO",
"55713655", "São\ Sebastião\ do\ Passé\ \-\ BA",
"55693448", "Ministro\ Andreazza\ \-\ RO",
"55772101", "Vitória\ da\ Conquista\ \-\ BA",
"55313542", "Nova\ Lima\ \-\ MG",
"55793611", "Simão\ Dias\ \-\ SE",
"55473459", "São\ Francisco\ do\ Sul\ \-\ SC",
"55543231", "Vacaria\ \-\ RS",
"55793449", "Ribeirópolis\ \-\ SE",
"55513458", "Esteio\ \-\ RS",
"55873991", "Vermelho\ \-\ PE",
"55173386", "Pirangi\ \-\ SP",
"55213202", "Rio\ de\ Janeiro\ \-\ RJ",
"55753237", "Teodoro\ Sampaio\ \-\ BA",
"55614009", "Brasília\ \-\ DF",
"55443423", "Paranavaí\ \-\ PR",
"55743673", "Uauá\ \-\ BA",
"55913802", "Mãe\ do\ Rio\ \-\ PA",
"55862106", "Teresina\ \-\ PI",
"55133499", "Praia\ Grande\ \-\ SP",
"55113153", "São\ Paulo\ \-\ SP",
"55124158", "Vargem\ Grande\ Paulista\ \-\ SP",
"55213976", "Rio\ de\ Janeiro\ \-\ RJ",
"55653312", "Santo\ Afonso\ \-\ MT",
"55314002", "Belo\ Horizonte\ \-\ MG",
"55193326", "Campinas\ \-\ SP",
"55883637", "Reriutaba\ \-\ CE",
"55833538", "São\ José\ da\ Lagoa\ Tapada\ \-\ PB",
"55343333", "Uberaba\ \-\ MG",
"55313881", "Ponte\ Nova\ \-\ MG",
"55173808", "Engenheiro\ Schimidt\ \-\ SP",
"55714116", "Dias\ d\'Ávila\ \-\ BA",
"55463527", "Francisco\ Beltrão\ \-\ PR",
"55443244", "Paiçandu\ \-\ PR",
"55973463", "Amaturá\ \-\ AM",
"55883553", "Milagres\ \-\ CE",
"55663023", "Rondonópolis\ \-\ MT",
"55114488", "Francisco\ Morato\ \-\ SP",
"55323313", "Juiz\ de\ Fora\ \-\ MG",
"55913712", "Castanhal\ \-\ PA",
"55873792", "Terezinha\ \-\ PE",
"55353835", "Cristais\ \-\ MG",
"55143305", "Piraju\ \-\ SP",
"55673003", "Campo\ Grande\ \-\ MS",
"55163491", "Sertãozinho\ \-\ SP",
"55193552", "Mogi\ Mirim\ \-\ SP",
"55883650", "Carnaubal\ \-\ CE",
"55883569", "Deputado\ Irapuan\ Pinheiro\ \-\ CE",
"55993642", "Pedreiras\ \-\ MA",
"55353653", "Conceição\ dos\ Ouros\ \-\ MG",
"55473444", "São\ Francisco\ do\ Sul\ \-\ SC",
"55493531", "Videira\ \-\ SC",
"55663539", "Novo\ Mundo\ \-\ MT",
"55643607", "Itumbiara\ \-\ GO",
"55833296", "Baía\ da\ Traição\ \-\ PB",
"55623999", "Goiânia\ \-\ GO",
"55163389", "São\ Lourenço\ do\ Turvo\ \-\ SP",
"55423573", "Porto\ Vitória\ \-\ PR",
"55793361", "Amparo\ de\ São\ Francisco\ \-\ SE",
"55113907", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55333411", "Peçanha\ \-\ MG",
"55353537", "Fortaleza\ de\ Minas\ \-\ MG",
"55833232", "Bayeux\ \-\ PB",
"55633531", "Divinópolis\ do\ Tocantins\ \-\ TO",
"5511567", "São\ Paulo\ \-\ SP",
"55883585", "Iguatu\ \-\ CE",
"55513616", "Rio\ Grande\ do\ Sul",
"55513032", "Canoas\ \-\ RS",
"55943012", "Marabá\ \-\ PA",
"55142106", "Bauru\ \-\ SP",
"55213508", "Itaboraí\ \-\ RJ",
"55413140", "Campo\ Largo\ \-\ PR",
"55443636", "Pérola\ \-\ PR",
"55553387", "Ajuricaba\ \-\ RS",
"55133445", "Mongaguá\ \-\ SP",
"55843365", "Messias\ Targino\ \-\ RN",
"55323292", "Bom\ Jardim\ de\ Minas\ \-\ MG",
"55513670", "Amaral\ Ferrador\ \-\ RS",
"55493642", "Guarujá\ do\ Sul\ \-\ SC",
"55663412", "Juscimeira\ \-\ MT",
"55773652", "Muquém\ de\ São\ Francisco\ \-\ BA",
"55517", "Rio\ Grande\ do\ Sul",
"55813379", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55313248", "Belo\ Horizonte\ \-\ MG",
"55613554", "Brasília\ \-\ DF",
"55443259", "Maringá\ \-\ PR",
"55873868", "Afrânio\ \-\ PE",
"55613595", "Sobradinho\ \-\ DF",
"55373545", "Paineiras\ \-\ MG",
"55993531", "Estreito\ \-\ MA",
"55973345", "Alvarães\ \-\ AM",
"55913447", "Cachoeira\ do\ Piriá\ \-\ PA",
"55753256", "Tucano\ \-\ BA",
"55323373", "São\ João\ Del\ Rei\ \-\ MG",
"55153364", "Boituva\ \-\ SP",
"55913772", "Mosqueiro\ \-\ PA",
"55993421", "Caxias\ \-\ MA",
"55813537", "Chã\ Grande\ \-\ PE",
"55373402", "Itaúna\ \-\ MG",
"55963332", "Macapá\ \-\ AP",
"55673557", "Três\ Lagoas\ \-\ MS",
"55843351", "Pau\ dos\ Ferros\ \-\ RN",
"55753639", "Santa\ Teresinha\ \-\ BA",
"55813653", "Lagoa\ do\ Itaenga\ \-\ PE",
"55733547", "Aiquara\ \-\ BA",
"55213916", "Rio\ de\ Janeiro\ \-\ RJ",
"55222623", "Armação\ dos\ Búzios\ \-\ RJ",
"55383531", "Diamantina\ \-\ MG",
"55115695", "São\ Paulo\ \-\ SP",
"55653102", "Nobres\ \-\ MT",
"55112088", "Guarulhos\ \-\ SP",
"55413971", "Matinhos\ \-\ PR",
"55193849", "Valinhos\ \-\ SP",
"55153451", "Tatuí\ \-\ SP",
"55123354", "Jacareí\ \-\ SP",
"55913082", "Belém\ \-\ PA",
"55313859", "João\ Monlevade\ \-\ MG",
"55213970", "Rio\ de\ Janeiro\ \-\ RJ",
"55633421", "Araguaína\ \-\ TO",
"55313863", "Ferros\ \-\ MG",
"55883656", "Graça\ \-\ CE",
"55714102", "Salvador\ \-\ BA",
"55833268", "João\ Pessoa\ \-\ PB",
"55673409", "Naviraí\ \-\ MS",
"55114147", "Itapecerica\ da\ Serra\ \-\ SP",
"55973481", "Eirunepé\ \-\ AM",
"55193597", "Rio\ Claro\ \-\ SP",
"55133576", "São\ Vicente\ \-\ SP",
"55143547", "Guaiçara\ \-\ SP",
"55893484", "Campinas\ do\ Piauí\ \-\ PI",
"55183623", "Araçatuba\ \-\ SP",
"55493316", "Chapecó\ \-\ SC",
"55753287", "Abaré\ \-\ BA",
"55383563", "São\ Gonçalo\ do\ Abaeté\ \-\ MG",
"55112336", "São\ Paulo\ \-\ SP",
"55213611", "São\ Gonçalo\ \-\ RJ",
"55993078", "Caxias\ \-\ MA",
"55753651", "Jiquiriçá\ \-\ BA",
"55413676", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55543533", "Caxias\ do\ Sul\ \-\ RS",
"55123609", "Taubaté\ \-\ SP",
"55193769", "Campinas\ \-\ SP",
"55543281", "Nova\ Petrópolis\ \-\ RS",
"55613697", "Taboquinha\ \-\ GO",
"55113820", "Guarulhos\ \-\ SP",
"55413398", "São\ José\ dos\ Pinhais\ \-\ PR",
"55143297", "Bairro\ de\ Santa\ Izabel\ \-\ SP",
"55643621", "Rio\ Verde\ \-\ GO",
"55173392", "Viradouro\ \-\ SP",
"5511331", "São\ Paulo\ \-\ SP",
"5531348", "Belo\ Horizonte\ \-\ MG",
"55433156", "Rolândia\ \-\ PR",
"55383746", "Ibiaí\ \-\ MG",
"55933526", "Alenquer\ \-\ PA",
"55983673", "Brejo\ de\ Areia\ \-\ MA",
"55112392", "São\ Paulo\ \-\ SP",
"55513729", "Lajeado\ \-\ RS",
"55163145", "Patrocínio\ Paulista\ \-\ SP",
"55512139", "Porto\ Alegre\ \-\ RS",
"55192118", "Hortolândia\ \-\ SP",
"55433526", "Santana\ do\ Itararé\ \-\ PR",
"55313681", "Lagoa\ Santa\ \-\ MG",
"55833664", "Santa\ Rita\ \-\ PB",
"55313230", "Minas\ Gerais",
"55143413", "Marília\ \-\ SP",
"55242254", "Comendador\ Levy\ Gasparian\ \-\ RJ",
"55663565", "Aripuanã\ \-\ MT",
"55693526", "Jaru\ \-\ RO",
"55313831", "Itabira\ \-\ MG",
"5521341", "Rio\ de\ Janeiro\ \-\ RJ",
"55873786", "Iati\ \-\ PE",
"55793276", "Pirambu\ \-\ SE",
"55733297", "Caravelas\ \-\ BA",
"55192533", "Piracicaba\ \-\ SP",
"55114462", "Santo\ André\ \-\ SP",
"55953624", "Boa\ Vista\ \-\ RR",
"5585348", "Fortaleza\ \-\ CE",
"55223811", "Itaperuna\ \-\ RJ",
"55114979", "Santo\ André\ \-\ SP",
"55833374", "Nova\ Floresta\ \-\ PB",
"5551332", "Rio\ Grande\ do\ Sul",
"55433436", "Cambira\ \-\ PR",
"55493563", "Caçador\ \-\ SC",
"55193695", "Mococa\ \-\ SP",
"55823267", "Coqueiro\ Seco\ \-\ AL",
"55543244", "São\ Francisco\ de\ Paula\ \-\ RS",
"55863252", "Campo\ Maior\ \-\ PI",
"55643442", "Catalão\ \-\ GO",
"55663551", "Nova\ Canaã\ do\ Norte\ \-\ MT",
"55823556", "Feliz\ Deserto\ \-\ AL",
"55313598", "Minas\ Gerais",
"55483084", "Florianópolis\ \-\ SC",
"55193654", "Santo\ Antônio\ do\ Jardim\ \-\ SP",
"55114528", "Cabreúva\ \-\ SP",
"55713003", "Salvador\ \-\ BA",
"55913366", "Belém\ \-\ PA",
"55133034", "Praia\ Grande\ \-\ SP",
"55333326", "Santa\ Bárbara\ do\ Leste\ \-\ MG",
"55993559", "Sucupira\ do\ Norte\ \-\ MA",
"55513712", "Estrêla\ \-\ RS",
"55993563", "Aldeias\ Altas\ \-\ MA",
"55443231", "Itambé\ \-\ PR",
"55553356", "Bossoroca\ \-\ RS",
"55114158", "Vargem\ Grande\ Paulista\ \-\ SP",
"55813635", "Itambé\ \-\ PE",
"55123153", "Lorena\ \-\ SP",
"55343611", "Araxá\ \-\ MG",
"55643087", "Itumbiara\ \-\ GO",
"55654003", "Cuiabá\ \-\ MT",
"55933067", "Santarém\ \-\ PA",
"55513700", "Rio\ Grande\ do\ Sul",
"55733645", "Medeiros\ Neto\ \-\ BA",
"55983363", "Morros\ \-\ MA",
"55153278", "Pilar\ do\ Sul\ \-\ SP",
"55774009", "Vitória\ da\ Conquista\ \-\ BA",
"55473035", "Blumenau\ \-\ SC",
"55623549", "Aparecida\ de\ Goiânia\ \-\ GO",
"55483208", "Florianópolis\ \-\ SC",
"55553522", "Três\ Passos\ \-\ RS",
"55983359", "São\ João\ Batista\ \-\ MA",
"55313432", "Belo\ Horizonte\ \-\ MG",
"55163263", "Itápolis\ \-\ SP",
"55773614", "Barreiras\ \-\ BA",
"55633353", "Alvorada\ \-\ TO",
"55843244", "Baía\ Formosa\ \-\ RN",
"55343235", "Uberlândia\ \-\ MG",
"55633369", "Novo\ Acordo\ \-\ TO",
"55913322", "Barcarena\ \-\ PA",
"5581332", "Recife\ \-\ PE",
"55323723", "Rosário\ da\ Limeira\ \-\ MG",
"55193388", "Campinas\ \-\ SP",
"55623094", "Aparecida\ de\ Goiânia\ \-\ GO",
"55663495", "Primavera\ do\ Leste\ \-\ MT",
"55243356", "Pinheiral\ \-\ RJ",
"55913556", "Senador\ José\ Porfírio\ \-\ PA",
"55613603", "Luziânia\ \-\ GO",
"55433538", "Andirá\ \-\ PR",
"55143203", "Bauru\ \-\ SP",
"55193872", "Cosmópolis\ \-\ SP",
"551130", "São\ Paulo\ \-\ SP",
"55193716", "Campinas\ \-\ SP",
"55653349", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55613500", "Brasília\ \-\ DF",
"55423635", "Laranjeiras\ do\ Sul\ \-\ PR",
"55133251", "Santos\ \-\ SP",
"55114894", "Itatiba\ \-\ SP",
"55673446", "Angélica\ \-\ MS",
"55213589", "Mesquita\ \-\ RJ",
"55383217", "Montes\ Claros\ \-\ MG",
"55493353", "Xaxim\ \-\ SC",
"5545352", "Foz\ do\ Iguaçu\ \-\ PR",
"55843423", "Jardim\ de\ Piranhas\ \-\ RN",
"55553257", "São\ Vicente\ do\ Sul\ \-\ RS",
"55833448", "Bom\ Sucesso\ \-\ PB",
"55353729", "Poços\ de\ Caldas\ \-\ MG",
"55813700", "Caruaru\ \-\ PE",
"55413556", "São\ José\ dos\ Pinhais\ \-\ PR",
"55933538", "Terra\ Santa\ \-\ PA",
"55383679", "Paracatu\ \-\ MG",
"55222664", "Araruama\ \-\ RJ",
"55653221", "Cáceres\ \-\ MT",
"55143456", "Oriente\ \-\ SP",
"55193806", "Mogi\ Mirim\ \-\ SP",
"55853468", "Fortaleza\ \-\ CE",
"55163308", "Gavião\ Peixoto\ \-\ SP",
"55813712", "Caruaru\ \-\ PE",
"55533011", "Pelotas\ \-\ RS",
"55623343", "Abadiânia\ \-\ GO",
"55643634", "Chapadão\ do\ Céu\ \-\ GO",
"55553743", "Jaboticaba\ \-\ RS",
"55733203", "Ibicaraí\ \-\ BA",
"55313519", "Belo\ Horizonte\ \-\ MG",
"55853356", "Apuiarés\ \-\ CE",
"55513635", "São\ Sebastião\ do\ Caí\ \-\ RS",
"55613704", "Brasília\ \-\ DF",
"55453280", "São\ Luiz\ D\'Oeste\ \-\ PR",
"55143332", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55463547", "Ampére\ \-\ PR",
"55773489", "Cocos\ \-\ BA",
"55115092", "São\ Paulo\ \-\ SP",
"55843281", "Nova\ Cruz\ \-\ RN",
"55543339", "Erebango\ \-\ RS",
"55413685", "Paiol\ de\ Baixo\ \-\ PR",
"55313152", "Sete\ Lagoas\ \-\ MG",
"55673488", "Aral\ Moreira\ \-\ MS",
"55553027", "Santa\ Maria\ \-\ RS",
"55713462", "Salvador\ \-\ BA",
"55353211", "Passos\ \-\ MG",
"55152101", "Sorocaba\ \-\ SP",
"55953542", "Mucajaí\ \-\ RR",
"55843533", "Afonso\ Bezerra\ \-\ RN",
"55473264", "Balneário\ Camboriú\ \-\ SC",
"55115612", "São\ Paulo\ \-\ SP",
"55183691", "Buritama\ \-\ SP",
"55353712", "Poços\ de\ Caldas\ \-\ MG",
"55443443", "Santo\ Antônio\ do\ Caiuá\ \-\ PR",
"55433428", "Marilândia\ do\ Sul\ \-\ PR",
"55453304", "Cascavel\ \-\ PR",
"55464007", "Francisco\ Beltrão\ \-\ PR",
"55153245", "Votorantim\ \-\ SP",
"55313356", "Contagem\ \-\ MG",
"55733678", "Monte\ Pascoal\ \-\ BA",
"55753182", "Alagoinhas\ \-\ BA",
"55433562", "Sertaneja\ \-\ PR",
"55793377", "Ilha\ das\ Flores\ \-\ SE",
"55513401", "Guaíba\ \-\ RS",
"55693428", "Nova\ Londrina\ \-\ RO",
"55553313", "Santo\ Ângelo\ \-\ RS",
"55633493", "Palmeirante\ \-\ TO",
"55123116", "Bananal\ \-\ SP",
"55813342", "Recife\ \-\ PE",
"55114592", "Itupeva\ \-\ SP",
"55313522", "Minas\ Gerais",
"55873775", "Águas\ Belas\ \-\ PE",
"55222759", "Macaé\ \-\ RJ",
"55112839", "São\ Paulo\ \-\ SP",
"55513653", "Taquari\ \-\ RS",
"5511405", "Diadema\ \-\ SP",
"55543464", "Garibaldi\ \-\ RS",
"55513550", "Rio\ Grande\ do\ Sul",
"55513669", "Nova\ Tramandaí\ \-\ RS",
"55613465", "Brasília\ \-\ DF",
"55153554", "Barra\ do\ Chapéu\ \-\ SP",
"55173839", "Parisi\ \-\ SP",
"55663902", "Rondonópolis\ \-\ MT",
"55983324", "Centro\ Novo\ do\ Maranhão\ \-\ MA",
"55323228", "Juiz\ de\ Fora\ \-\ MG",
"55693643", "Alto\ Alegre\ dos\ Parecis\ \-\ RO",
"55513537", "Porto\ Alegre\ \-\ RS",
"55383822", "Janaúba\ \-\ MG",
"55443628", "Jussara\ \-\ PR",
"55623506", "Trindade\ \-\ GO",
"55373341", "Itapecerica\ \-\ MG",
"55613391", "Brazlândia\ \-\ DF",
"55433540", "Rancho\ Alegre\ \-\ PR",
"55453236", "Serranópolis\ do\ Iguaçu\ \-\ PR",
"55543351", "David\ Canabarro\ \-\ RS",
"55643479", "Panamá\ \-\ GO",
"55143274", "Gália\ \-\ SP",
"55753330", "Boninal\ \-\ BA",
"55493335", "Planalto\ Alegre\ \-\ SC",
"55953236", "Caroebe\ \-\ RR",
"55493524", "Água\ Doce\ \-\ SC",
"55423653", "Rio\ Bonito\ do\ Iguaçu\ \-\ PR",
"5564", "Goiás",
"55373229", "Divinópolis\ \-\ MG",
"55193629", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55353573", "Monte\ Belo\ \-\ MG",
"55313387", "Minas\ Gerais",
"55623572", "Goiânia\ \-\ GO",
"55833457", "Princesa\ Isabel\ \-\ PB",
"55114683", "Juquitiba\ \-\ SP",
"55823271", "São\ Miguel\ dos\ Campos\ \-\ AL",
"55733274", "Vera\ Cruz\ \-\ BA",
"55183996", "Marabá\ Paulista\ \-\ SP",
"55633524", "Porto\ Alegre\ do\ Tocantins\ \-\ TO",
"55483324", "Florianópolis\ \-\ SC",
"55273744", "Governador\ Lindenberg\ \-\ ES",
"55483535", "Jacinto\ Machado\ \-\ SC",
"55343269", "Ituiutaba\ \-\ MG",
"55353068", "Varginha\ \-\ MG",
"55633434", "Juarina\ \-\ TO",
"55213747", "Rio\ de\ Janeiro\ \-\ RJ",
"55333514", "Malacacheta\ \-\ MG",
"55242485", "Paty\ do\ Alferes\ \-\ RJ",
"55163931", "Ribeirão\ Preto\ \-\ SP",
"55833397", "Natuba\ \-\ PB",
"55334141", "Governador\ Valadares\ \-\ MG",
"55673919", "Três\ Lagoas\ \-\ MS",
"55813616", "Goiana\ \-\ PE",
"55123862", "São\ Sebastião\ \-\ SP",
"55243387", "Visconde\ de\ Mauá\ \-\ RJ",
"55463558", "Pérola\ D\'Oeste\ \-\ PR",
"55373384", "Itaguara\ \-\ MG",
"55183268", "Nantes\ \-\ SP",
"55513754", "Imigrante\ \-\ RS",
"55833623", "Cuité\ de\ Mamanguape\ \-\ PB",
"55163231", "Guariba\ \-\ SP",
"55883576", "Jaguaretama\ \-\ CE",
"55273071", "Vitória\ \-\ ES",
"55333340", "Governador\ Valadares\ \-\ MG",
"55614062", "Brasília\ \-\ DF",
"55163830", "Ituverava\ \-\ SP",
"55753213", "Banzaê\ \-\ BA",
"55493434", "Vargeão\ \-\ SC",
"55113638", "São\ Paulo\ \-\ SP",
"55553286", "Santa\ Maria\ \-\ RS",
"55114784", "São\ Roque\ \-\ SP",
"55513379", "Rio\ Grande\ do\ Sul",
"55123646", "Roseira\ \-\ SP",
"55653626", "Cuiabá\ \-\ MT",
"55212643", "Teresópolis\ \-\ RJ",
"55413587", "São\ José\ dos\ Pinhais\ \-\ PR",
"55473632", "Campo\ Alegre\ \-\ SC",
"55683901", "Rio\ Branco\ \-\ AC",
"55843555", "Pedra\ Grande\ \-\ RN",
"55863214", "Teresina\ \-\ PI",
"5511422", "São\ Caetano\ do\ Sul\ \-\ SP",
"5531329", "Minas\ Gerais",
"55883510", "Iguatu\ \-\ CE",
"55513427", "Canoas\ \-\ RS",
"55373212", "Divinópolis\ \-\ MG",
"55893544", "Uruçuí\ \-\ PI",
"55883613", "Sobral\ \-\ CE",
"55412108", "Curitiba\ \-\ PR",
"55143487", "Júlio\ Mesquita\ \-\ SP",
"55273314", "Vitória\ \-\ ES",
"55474001", "Joinville\ \-\ SC",
"55753062", "Feira\ de\ Santana\ \-\ BA",
"55813032", "Recife\ \-\ PE",
"55613364", "Brasília\ \-\ DF",
"55923427", "Juruá\ \-\ AM",
"55743656", "Canarana\ \-\ BA",
"55543365", "Rondinha\ \-\ RS",
"55323337", "Mercês\ \-\ MG",
"55193503", "Hortolândia\ \-\ SP",
"55853387", "Caucaia\ \-\ CE",
"55133418", "Itariri\ \-\ SP",
"55313915", "Belo\ Horizonte\ \-\ MG",
"55693546", "Nova\ Dimensão\ \-\ RO",
"55873035", "Petrolina\ \-\ PE",
"55733214", "Itabuna\ \-\ BA",
"55513556", "Rio\ Grande\ do\ Sul",
"55613055", "Brasília\ \-\ DF",
"55313723", "Casa\ Grande\ \-\ MG",
"55543054", "Caxias\ do\ Sul\ \-\ RS",
"5582332", "Maceió\ \-\ AL",
"55453257", "Entre\ Rios\ do\ Oeste\ \-\ PR",
"55513267", "Rio\ Grande\ do\ Sul",
"55623512", "Senador\ Canedo\ \-\ GO",
"55753336", "Wagner\ \-\ BA",
"55673438", "Laguna\ Carapã\ \-\ MS",
"55173651", "Palmeira\ D\'Oeste\ \-\ SP",
"55413635", "São\ José\ dos\ Pinhais\ \-\ PR",
"55513749", "Palanque\ \-\ RS",
"55453230", "Diamante\ do\ Sul\ \-\ PR",
"55433546", "Ibaiti\ \-\ PR",
"55143382", "Fartura\ \-\ SP",
"55112651", "São\ Paulo\ \-\ SP",
"55433011", "Arapongas\ \-\ PR",
"55343412", "Campina\ Verde\ \-\ MG",
"55843231", "Natal\ \-\ RN",
"55773439", "Encruzilhada\ \-\ BA",
"55543389", "Fontoura\ Xavier\ \-\ RS",
"55643532", "Itumbiara\ \-\ GO",
"55313215", "Minas\ Gerais",
"55483265", "São\ João\ Batista\ \-\ SC",
"55212664", "Japeri\ \-\ RJ",
"55143214", "Bauru\ \-\ SP",
"55242453", "Valença\ \-\ RJ",
"55115812", "São\ Paulo\ \-\ SP",
"55613614", "Novo\ Gama\ \-\ GO",
"55643419", "Cromínia\ \-\ GO",
"55643641", "Santa\ Helena\ de\ Goiás\ \-\ GO",
"55383726", "Santo\ Hipólito\ \-\ MG",
"55893563", "Cristino\ Castro\ \-\ PI",
"55833436", "Vista\ Serrana\ \-\ PB",
"55893559", "Itaueira\ \-\ PI",
"55463252", "Clevelândia\ \-\ PR",
"55114661", "Embu\-Guaçu\ \-\ SP",
"55833492", "Monte\ Horebe\ \-\ PB",
"55193362", "Mogi\-Guaçu\ \-\ SP",
"55753608", "Barrocas\ \-\ BA",
"55193927", "Piracicaba\ \-\ SP",
"55353366", "Alagoa\ \-\ MG",
"55543443", "Guaporé\ \-\ RS",
"55483251", "Florianópolis\ \-\ SC",
"55833352", "São\ João\ do\ Tigre\ \-\ PB",
"55553304", "Santa\ Maria\ \-\ RS",
"55733625", "Mascote\ \-\ BA",
"55113170", "São\ Paulo\ \-\ SP",
"55212691", "Nilópolis\ \-\ RJ",
"55553542", "Tucunduva\ \-\ RS",
"55433475", "Jardim\ Alegre\ \-\ PR",
"55623529", "Brazabrantes\ \-\ GO",
"55883673", "Itapipoca\ \-\ CE",
"55623978", "Anápolis\ \-\ GO",
"55114655", "Arujá\ \-\ SP",
"55213667", "Duque\ de\ Caxias\ \-\ RJ",
"55813138", "Caruaru\ \-\ PE",
"55373272", "Maravilhas\ \-\ MG",
"55193672", "Santa\ Cruz\ das\ Palmeiras\ \-\ SP",
"55863274", "Brasileira\ \-\ PI",
"55313482", "Minas\ Gerais",
"55343429", "Frutal\ \-\ MG",
"55313624", "Ribeirão\ das\ Neves\ \-\ MG",
"55473318", "Gaspar\ \-\ SC",
"55193030", "Vinhedo\ \-\ SP",
"55114694", "Biritiba\-Mirim\ \-\ SP",
"55643684", "Aurilândia\ \-\ GO",
"55613489", "Planaltina\ \-\ DF",
"55883516", "Piquet\ Carneiro\ \-\ CE",
"55513685", "Capivari\ do\ Sul\ \-\ RS",
"55743637", "Gentio\ do\ Ouro\ \-\ BA",
"55154009", "Sorocaba\ \-\ SP",
"55453027", "Foz\ do\ Iguaçu\ \-\ PR",
"55323356", "Ritápolis\ \-\ MG",
"55663508", "Santo\ Antônio\ Fontoura\ \-\ MT",
"55212763", "Nova\ Iguaçu\ \-\ RJ",
"55823342", "Maceió\ \-\ AL",
"55743553", "Campo\ Formoso\ \-\ BA",
"55813676", "Tamandaré\ \-\ PE",
"55273763", "São\ Mateus\ \-\ ES",
"55753452", "Itatim\ \-\ BA",
"55114014", "Morungaba\ \-\ SP",
"55273759", "Água\ Doce\ do\ Norte\ \-\ ES",
"55493622", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55943351", "Palestina\ do\ Pará\ \-\ PA",
"55313579", "Aranha\ \-\ MG",
"55863332", "Caxingó\ \-\ PI",
"55193702", "Limeira\ \-\ SP",
"55893421", "Picos\ \-\ PI",
"55273296", "Aracruz\ \-\ ES",
"55123662", "Campos\ do\ Jordão\ \-\ SP",
"55373334", "Piracema\ \-\ MG",
"55483656", "Sangão\ \-\ SC",
"55433268", "Ibiporã\ \-\ PR",
"55813447", "Recife\ \-\ PE",
"55373525", "Moema\ \-\ MG",
"55273232", "Vitória\ \-\ ES",
"55133856", "Pariquera\-Açu\ \-\ SP",
"55553791", "Palmitinho\ \-\ RS",
"55313490", "Minas\ Gerais",
"55673440", "Amandina\ \-\ MS",
"55613506", "Brasília\ \-\ DF",
"55533282", "Pelotas\ \-\ RS",
"55483239", "Florianópolis\ \-\ SC",
"55633484", "Campos\ Lindos\ \-\ TO",
"55793269", "Riachuelo\ \-\ SE",
"55183744", "Nova\ Independência\ \-\ SP",
"55124242", "Cotia\ \-\ SP",
"55453248", "Iguatu\ \-\ PR",
"55623391", "Mundo\ Novo\ \-\ GO",
"55213551", "Rio\ de\ Janeiro\ \-\ RJ",
"55163981", "Pradópolis\ \-\ SP",
"55853337", "Aracoiaba\ \-\ CE",
"55773465", "Ibiassucê\ \-\ BA",
"55683612", "Sena\ Madureira\ \-\ AC",
"55413669", "Pinhais\ \-\ PR",
"55323275", "Santana\ do\ Deserto\ \-\ MG",
"55193812", "Cosmópolis\ \-\ SP",
"55913120", "Belém\ \-\ PA",
"55443464", "São\ Pedro\ do\ Paraná\ \-\ PR",
"55413653", "Pinhais\ \-\ PR",
"55993622", "Bacabal\ \-\ MA",
"55443351", "Cianorte\ \-\ PR",
"55443675", "Cidade\ Gaúcha\ \-\ PR",
"55813271", "Recife\ \-\ PE",
"55553236", "Formigueiro\ \-\ RS",
"55473424", "Pirabeiraba\ \-\ SC",
"55433303", "Arapongas\ \-\ PR",
"55983656", "Governador\ Newton\ Bello\ \-\ MA",
"55773674", "Ibipitanga\ \-\ BA",
"55493441", "Concórdia\ \-\ SC",
"55473534", "Agrolândia\ \-\ SC",
"55913795", "Baião\ \-\ PA",
"55773451", "Guanambi\ \-\ BA",
"55843259", "Barcelona\ \-\ RN",
"55713677", "Mata\ de\ São\ João\ \-\ BA",
"55843263", "Touros\ \-\ RN",
"55114409", "Jacaré\ \-\ SP",
"55163244", "Monte\ Alto\ \-\ SP",
"55743535", "Remanso\ \-\ BA",
"55282102", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55212303", "Rio\ de\ Janeiro\ \-\ RJ",
"5571324", "Salvador\ \-\ BA",
"55913754", "Barcarena\ \-\ PA",
"55553373", "Saldanha\ Marinho\ \-\ RS",
"55513587", "Novo\ Hamburgo\ \-\ RS",
"55843692", "Lagoa\ de\ Pedras\ \-\ RN",
"55183643", "Birigui\ \-\ SP",
"55453286", "Capitão\ Leônidas\ Marques\ \-\ PR",
"55212173", "Rio\ de\ Janeiro\ \-\ RJ",
"55173639", "Populina\ \-\ SP",
"55173889", "Altair\ \-\ SP",
"55843636", "Ruy\ Barbosa\ \-\ RN",
"55983478", "Araioses\ \-\ MA",
"55383622", "Pedras\ de\ Maria\ da\ Cruz\ \-\ MG",
"5583323", "João\ Pessoa\ \-\ PB",
"55163944", "Dumont\ \-\ SP",
"55173567", "Paraíso\ \-\ SP",
"55713052", "Salvador\ \-\ BA",
"55173256", "Santa\ Luzia\ \-\ SP",
"55483478", "Criciúma\ \-\ SC",
"55633385", "Talismã\ \-\ TO",
"55733527", "Jequié\ \-\ BA",
"55943365", "Vila\ Taboca\ \-\ PA",
"55133324", "Santos\ \-\ SP",
"55183282", "Teodoro\ Sampaio\ \-\ SP",
"55222540", "Nova\ Friburgo\ \-\ RJ",
"55623451", "Campos\ Belos\ \-\ GO",
"55353271", "Lambari\ \-\ MG",
"55123102", "Silveiras\ \-\ SP",
"55193829", "Valinhos\ \-\ SP",
"55753204", "Feira\ de\ Santana\ \-\ BA",
"55433232", "Sertanópolis\ \-\ PR",
"55222643", "Cabo\ Frio\ \-\ RJ",
"55623364", "São\ Miguel\ do\ Araguaia\ \-\ GO",
"55654052", "Cuiabá\ \-\ MT",
"55273268", "Domingos\ Martins\ \-\ ES",
"5565366", "Cuiabá\ \-\ MT",
"55893531", "Canto\ do\ Buriti\ \-\ PI",
"55373435", "Vargem\ Bonita\ \-\ MG",
"55643946", "Itumbiara\ \-\ GO",
"55493277", "Bom\ Retiro\ \-\ SC",
"55313337", "Belo\ Horizonte\ \-\ MG",
"55943491", "Redenção\ \-\ PA",
"55823032", "Maceió\ \-\ AL",
"55222781", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55613218", "Brasília\ \-\ DF",
"55833480", "Igaracy\ \-\ PB",
"55673238", "Ribas\ do\ Rio\ Pardo\ \-\ MS",
"55643677", "Amorinópolis\ \-\ GO",
"55193795", "Campinas\ \-\ SP",
"55323296", "Arantina\ \-\ MG",
"55383564", "Ruralminas\ I\ \-\ MG",
"55983465", "Nina\ Rodrigues\ \-\ MA",
"55443632", "Xambrê\ \-\ PR",
"55653233", "Salto\ do\ Céu\ \-\ MT",
"55753022", "Feira\ de\ Santana\ \-\ BA",
"55543325", "São\ José\ do\ Herval\ \-\ RS",
"55613535", "Brasília\ \-\ DF",
"55343212", "Uberlândia\ \-\ MG",
"55513036", "Novo\ Hamburgo\ \-\ RS",
"5511364", "São\ Paulo\ \-\ SP",
"55843431", "Currais\ Novos\ \-\ RN",
"55543534", "Caxias\ do\ Sul\ \-\ RS",
"55542109", "Farroupilha\ \-\ RS",
"55173487", "Magda\ \-\ SP",
"55444001", "Maringá\ \-\ PR",
"55983391", "Cururupu\ \-\ MA",
"55483131", "Florianópolis\ \-\ SC",
"55773656", "Brejolândia\ \-\ BA",
"55663416", "General\ Carneiro\ \-\ MT",
"55493646", "Cunha\ Porã\ \-\ SC",
"55513467", "Canoas\ \-\ RS",
"55732102", "Itabuna\ \-\ BA",
"55273275", "Aracruz\ \-\ ES",
"55513600", "Rio\ Grande\ do\ Sul",
"55833292", "Mamanguape\ \-\ PB",
"55993646", "Lima\ Campos\ \-\ MA",
"55213229", "Rio\ de\ Janeiro\ \-\ RJ",
"55913829", "Tomé\-Açú\ \-\ PA",
"55423036", "Guarapuava\ \-\ PR",
"55213485", "Rio\ de\ Janeiro\ \-\ RJ",
"55413048", "Araucária\ \-\ PR",
"55483465", "Urussanga\ \-\ SC",
"55513612", "Doutor\ Ricardo\ \-\ RS",
"55143414", "Marília\ \-\ SP",
"55113441", "São\ Paulo\ \-\ SP",
"55813735", "São\ Bento\ do\ Una\ \-\ PE",
"55183928", "Presidente\ Prudente\ \-\ SP",
"55443016", "Campo\ Mourão\ \-\ PR",
"55443541", "Moreira\ Sales\ \-\ PR",
"55663599", "Guariba\ \-\ MT",
"55843605", "Natal\ \-\ RN",
"55613797", "Brasília\ \-\ DF",
"55953623", "Boa\ Vista\ \-\ RR",
"5567", "Mato\ Grosso\ do\ Sul",
"55863474", "Pimenteiras\ \-\ PI",
"55833373", "Araruna\ \-\ PB",
"55193537", "Ipeúna\ \-\ SP",
"55493564", "Rio\ das\ Antas\ \-\ SC",
"55112818", "Mauá\ \-\ SP",
"55193653", "Aguaí\ \-\ SP",
"55313071", "Belo\ Horizonte\ \-\ MG",
"55173818", "Bady\ Bassitt\ \-\ SP",
"55433275", "Arapongas\ \-\ PR",
"55883652", "Guaraciaba\ do\ Norte\ \-\ CE",
"55193669", "Divinolândia\ \-\ SP",
"55983451", "Santa\ Rita\ \-\ MA",
"55753699", "Saubara\ \-\ BA",
"55464055", "Pato\ Branco\ \-\ PR",
"55993564", "Governador\ Eugênio\ Barros\ \-\ MA",
"55443668", "Serra\ dos\ Dourados\ \-\ PR",
"55313540", "Minas\ Gerais",
"55115635", "São\ Paulo\ \-\ SP",
"55353735", "Caldas\ \-\ MG",
"55913776", "Santa\ Bárbara\ do\ Pará\ \-\ PA",
"55484062", "Florianópolis\ \-\ SC",
"55213212", "Rio\ de\ Janeiro\ \-\ RJ",
"55873892", "Terra\ Nova\ \-\ PE",
"55913812", "Magalhães\ Barata\ \-\ PA",
"55753252", "Ruy\ Barbosa\ \-\ BA",
"55133506", "Mongaguá\ \-\ SP",
"55513629", "Rio\ Grande\ do\ Sul",
"55654004", "Várzea\ Grande\ \-\ MT",
"55793194", "Aracaju\ \-\ SE",
"55873836", "Sanharó\ \-\ PE",
"55843521", "Macau\ \-\ RN",
"55773478", "Ribeirão\ do\ Largo\ \-\ BA",
"55653376", "Nobres\ \-\ MT",
"55713288", "Lauro\ de\ Freitas\ \-\ BA",
"55443584", "Icaraíma\ \-\ PR",
"55162138", "Ribeirão\ Preto\ \-\ SP",
"55673479", "Sete\ Quedas\ \-\ MS",
"55173274", "Tanabi\ \-\ SP",
"55163728", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55313891", "Viçosa\ \-\ MG",
"55413606", "Colombo\ \-\ PR",
"55114821", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55813753", "São\ Joaquim\ do\ Monte\ \-\ PE",
"55683322", "Cruzeiro\ do\ Sul\ \-\ AC",
"55673240", "Aquidauana\ \-\ MS",
"55353654", "Gonçalves\ \-\ MG",
"55473443", "Itapoá\ \-\ SC",
"55652128", "Cuiabá\ \-\ MT",
"55214138", "Queimados\ \-\ RJ",
"55662103", "Rondonópolis\ \-\ MT",
"55793453", "Moita\ Bonita\ \-\ SE",
"55483439", "Criciúma\ \-\ SC",
"55353695", "São\ Lourenço\ \-\ MG",
"55112136", "Jundiaí\ \-\ SP",
"55733237", "Buerarema\ \-\ BA",
"55313562", "Itabirito\ \-\ MG",
"55433356", "Londrina\ \-\ PR",
"55313428", "Belo\ Horizonte\ \-\ MG",
"55683267", "Vila\ Campinas\ \(Pad\ Peixoto\)\ \-\ AC",
"55793272", "Japaratuba\ \-\ SE",
"55873782", "Saloá\ \-\ PE",
"55433468", "Rio\ Bom\ \-\ PR",
"55873880", "Granito\ \-\ PE",
"55173332", "Guaíra\ \-\ SP",
"55413672", "Quatro\ Barras\ \-\ PR",
"55613637", "Planaltina\ \-\ GO",
"55494101", "Chapecó\ \-\ SC",
"55853113", "Aquiraz\ \-\ CE",
"55193401", "Piracicaba\ \-\ SP",
"55813471", "Recife\ \-\ PE",
"55163345", "Dourado\ \-\ SP",
"55743061", "Juazeiro\ \-\ BA",
"55353015", "Varginha\ \-\ MG",
"55493312", "Chapecó\ \-\ SC",
"55183723", "Andradina\ \-\ SP",
"55643575", "Itumbiara\ \-\ GO",
"55112396", "Itu\ \-\ SP",
"55692183", "Ji\-Paraná\ \-\ RO",
"55933522", "Santarém\ \-\ PA",
"55383742", "Buritizeiro\ \-\ MG",
"55433152", "Arapongas\ \-\ PR",
"55913606", "Bagre\ \-\ PA",
"55613553", "Brasília\ \-\ DF",
"55883549", "Tarrafas\ \-\ CE",
"55773021", "Barreiras\ \-\ BA",
"55634101", "Palmas\ \-\ TO",
"55443264", "Sarandi\ \-\ PR",
"55473054", "Jaraguá\ do\ Sul\ \-\ SC",
"55212152", "Teresópolis\ \-\ RJ",
"55323374", "Rio\ das\ Mortes\ \-\ MG",
"55153363", "Boituva\ \-\ SP",
"55983278", "São\ Luís\ \-\ MA",
"55553352", "São\ Luiz\ Gonzaga\ \-\ RS",
"55833304", "São\ Sebastião\ do\ Umbuzeiro\ \-\ PB",
"55833542", "Santa\ Helena\ \-\ PB",
"55323691", "Juiz\ de\ Fora\ \-\ MG",
"55513716", "Arroio\ do\ Meio\ \-\ RS",
"55223081", "Macaé\ \-\ RJ",
"55333322", "Caratinga\ \-\ MG",
"55553526", "Sede\ Nova\ \-\ RS",
"55493241", "Curitibanos\ \-\ SC",
"55653025", "Cuiabá\ \-\ MT",
"55813654", "Salgadinho\ \-\ PE",
"55133343", "Guarujá\ \-\ SP",
"55114209", "Barueri\ \-\ SP",
"5511458", "Jundiaí\ \-\ SP",
"55333267", "Aimorés\ \-\ MG",
"55222624", "Iguaba\ Grande\ \-\ RJ",
"55773687", "Canápolis\ \-\ BA",
"55653261", "Araputanga\ \-\ MT",
"55414064", "Paranaguá\ \-\ PR",
"55693432", "Rolim\ de\ Moura\ \-\ RO",
"55373235", "Pará\ de\ Minas\ \-\ MG",
"55713641", "Catu\ \-\ BA",
"5511508", "São\ Paulo\ \-\ SP",
"55973389", "Apuí\ \-\ AM",
"55814107", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55313538", "Esmeraldas\ \-\ MG",
"55833280", "Salgado\ de\ São\ Félix\ \-\ PB",
"55663321", "Rondonópolis\ \-\ MT",
"55313864", "Carmésia\ \-\ MG",
"55493329", "Chapecó\ \-\ SC",
"55483529", "Praia\ Grande\ \-\ SC",
"55483278", "São\ José\ \-\ SC",
"55173203", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55823552", "Piaçabuçu\ \-\ AL",
"55633477", "Itaguatins\ \-\ TO",
"55193885", "Indaiatuba\ \-\ SP",
"55353471", "Santa\ Rita\ do\ Sapucaí\ \-\ MG",
"55114037", "Pedra\ Bela\ \-\ SP",
"55863256", "Alto\ Longá\ \-\ PI",
"55813015", "Recife\ \-\ PE",
"55893483", "São\ João\ do\ Piauí\ \-\ PI",
"55513770", "Sério\ \-\ RS",
"55433432", "Jandaia\ do\ Sul\ \-\ PR",
"55183624", "Araçatuba\ \-\ SP",
"55333754", "Cachoeira\ de\ Pajeú\ \-\ MG",
"55623535", "Santo\ Antônio\ de\ Goiás\ \-\ GO",
"5512364", "Pindamonhangaba\ \-\ SP",
"55513048", "Osório\ \-\ RS",
"55153344", "Piedade\ \-\ SP",
"55483033", "Palhoça\ \-\ SC",
"55183275", "Martinópolis\ \-\ SP",
"5521340", "Rio\ de\ Janeiro\ \-\ RJ",
"55733639", "Ilhéus\ \-\ BA",
"55913467", "Ourém\ \-\ PA",
"55823258", "Passo\ de\ Camaragibe\ \-\ AL",
"55433337", "Londrina\ \-\ PR",
"55673246", "Terenos\ \-\ MS",
"55633372", "Natividade\ \-\ TO",
"55213525", "Rio\ de\ Janeiro\ \-\ RJ",
"55313232", "Minas\ Gerais",
"55112618", "São\ Paulo\ \-\ SP",
"55163463", "Araraquara\ \-\ SP",
"55643515", "Itumbiara\ \-\ GO",
"55893494", "Paes\ Landim\ \-\ PI",
"55543541", "Trindade\ do\ Sul\ \-\ RS",
"55733256", "Ituberá\ \-\ BA",
"55813649", "Machados\ \-\ PE",
"55813411", "Belo\ Jardim\ \-\ PE",
"55973491", "Carauari\ \-\ AM",
"55193869", "Valinhos\ \-\ SP",
"55893455", "Caldeirão\ Grande\ do\ Piauí\ \-\ PI",
"55793711", "Aracaju\ \-\ SE",
"55192108", "Americana\ \-\ SP",
"55373551", "Dores\ do\ Indaiá\ \-\ MG",
"55193853", "Pedreira\ \-\ SP",
"55443534", "Mariluz\ \-\ PR",
"55993638", "Alto\ Alegre\ do\ Maranhão\ \-\ MA",
"55313731", "Congonhas\ \-\ MG",
"55383662", "Buritis\ \-\ MG",
"55553430", "São\ Borja\ \-\ RS",
"55413036", "Almirante\ Tamandaré\ \-\ PR",
"55113434", "São\ Paulo\ \-\ SP",
"55313843", "Antônio\ Dias\ \-\ MG",
"55543632", "Passo\ Fundo\ \-\ RS",
"55543378", "Ernestina\ \-\ RS",
"55873886", "Verdejante\ \-\ PE",
"55473365", "Camboriú\ \-\ SC",
"55843223", "Natal\ \-\ RN",
"55833248", "Cabedelo\ \-\ PB",
"55424141", "Ponta\ Grossa\ \-\ PR",
"55213194", "Rio\ de\ Janeiro\ \-\ RJ",
"55333427", "Materlândia\ \-\ MG",
"55213601", "Niterói\ \-\ RJ",
"55653421", "Rondonópolis\ \-\ MT",
"55544001", "Caxias\ do\ Sul\ \-\ RS",
"55993662", "Dom\ Pedro\ \-\ MA",
"55323282", "Pedro\ Teixeira\ \-\ MG",
"55513710", "Lajeado\ \-\ RS",
"55653531", "Sinop\ \-\ MT",
"55313303", "Belo\ Horizonte\ \-\ MG",
"55353411", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55473464", "Joinville\ \-\ SC",
"55613585", "Ceilândia\ \-\ DF",
"55513702", "Rio\ Grande\ do\ Sul",
"55143026", "Ourinhos\ \-\ SP",
"55473351", "Brusque\ \-\ SC",
"55613478", "Sobradinho\ \-\ DF",
"55543584", "Passo\ Fundo\ \-\ RS",
"55793341", "Aquidabã\ \-\ SE",
"55423901", "Ponta\ Grossa\ \-\ PR",
"55443424", "Paranavaí\ \-\ PR",
"55114607", "Jundiaí\ \-\ SP",
"55653283", "Comodoro\ \-\ MT",
"55413629", "Tijucas\ do\ Sul\ \-\ PR",
"55743674", "Lajes\ do\ Batata\ \-\ BA",
"55833286", "Caaporã\ \-\ PB",
"55273350", "Vila\ Velha\ \-\ ES",
"55973351", "Beruri\ \-\ AM",
"5571", "Bahia",
"55823028", "Maceió\ \-\ AL",
"55943424", "Redenção\ \-\ PA",
"55983181", "São\ Luís\ \-\ MA",
"55513776", "Relvado\ \-\ RS",
"55313268", "Minas\ Gerais",
"55533275", "Capão\ do\ Leão\ \-\ RS",
"55863250", "Prata\ do\ Piauí\ \-\ PI",
"55643440", "Cumari\ \-\ GO",
"55273337", "Vitória\ \-\ ES",
"55983218", "São\ Luís\ \-\ MA",
"55443243", "São\ Jorge\ do\ Ivaí\ \-\ PR",
"55973464", "Tonantins\ \-\ AM",
"55883554", "Barro\ \-\ CE",
"55433579", "Salto\ do\ Itararé\ \-\ PR",
"55323314", "Juiz\ de\ Fora\ \-\ MG",
"55823597", "Maceió\ \-\ AL",
"55623425", "São\ Domingos\ \-\ GO",
"55873848", "Custódia\ \-\ PE",
"55893461", "Colônia\ do\ Piauí\ \-\ PI",
"55133391", "Guarujá\ \-\ SP",
"55213133", "Rio\ de\ Janeiro\ \-\ RJ",
"55114777", "Cotia\ \-\ SP",
"55663402", "Barra\ do\ Garças\ \-\ MT",
"55433047", "Apucarana\ \-\ PR",
"55163605", "Ribeirão\ Preto\ \-\ SP",
"55114442", "Caieiras\ \-\ SP",
"55743529", "Andorinha\ \-\ BA",
"55122136", "São\ José\ dos\ Campos\ \-\ SP",
"55863315", "Parnaíba\ \-\ PI",
"55483343", "São\ José\ \-\ SC",
"55112625", "São\ Paulo\ \-\ SP",
"55473339", "Blumenau\ \-\ SC",
"55143474", "Lupércio\ \-\ SP",
"55273723", "Colatina\ \-\ ES",
"5531335", "Minas\ Gerais",
"55513672", "Tapes\ \-\ RS",
"55115853", "São\ Paulo\ \-\ SP",
"55513057", "Montenegro\ \-\ RS",
"55643462", "Goiandira\ \-\ GO",
"55663410", "Rondonópolis\ \-\ MT",
"55923030", "Manaus\ \-\ AM",
"55312", "Minas\ Gerais",
"55943786", "Breu\ Branco\ \-\ PA",
"55443593", "Jota\ Esse\ \-\ PR",
"55493543", "Anita\ Garibaldi\ \-\ SC",
"55913346", "Ananindeua\ \-\ PA",
"55383234", "São\ João\ da\ Ponte\ \-\ MG",
"55853104", "Fortaleza\ \-\ CE",
"55463213", "Pato\ Branco\ \-\ PR",
"55273215", "Vitória\ \-\ ES",
"55923672", "Manaus\ \-\ AM",
"55993543", "Tasso\ Fragoso\ \-\ MA",
"55353552", "Guaxupé\ \-\ MG",
"55833257", "Mata\ Redonda\ \-\ PB",
"55193835", "Indaiatuba\ \-\ SP",
"55663476", "Araguainha\ \-\ MT",
"55893433", "Monsenhor\ Hipólito\ \-\ PI",
"55923198", "Manaus\ \-\ AM",
"55634003", "Palmas\ \-\ TO",
"55343972", "Uberaba\ \-\ MG",
"55343453", "Limeira\ do\ Oeste\ \-\ MG",
"5585349", "Fortaleza\ \-\ CE",
"55133278", "Santos\ \-\ SP",
"55513606", "Rondinha\ Velha\ \-\ RS",
"55623637", "Goiânia\ \-\ GO",
"55163521", "Sertãozinho\ \-\ SP",
"55353326", "Minduri\ \-\ MG",
"55222519", "Nova\ Friburgo\ \-\ RJ",
"55623553", "Hidrolândia\ \-\ GO",
"55112501", "São\ Paulo\ \-\ SP",
"55733665", "Teixeira\ de\ Freitas\ \-\ BA",
"55483055", "Içara\ \-\ SC",
"55312107", "Sete\ Lagoas\ \-\ MG",
"55353854", "Ilicínea\ \-\ MG",
"55714112", "Salvador\ \-\ BA",
"55383543", "Gouveia\ \-\ MG",
"55673419", "Angélica\ \-\ MS",
"55492020", "Chapecó\ \-\ SC",
"55193749", "Campinas\ \-\ SP",
"55313374", "Minas\ Gerais",
"55183356", "Echaporã\ \-\ SP",
"55753413", "Esplanada\ \-\ BA",
"55193556", "Cordeirópolis\ \-\ SP",
"55633234", "Palmas\ \-\ TO",
"55873796", "Capoeiras\ \-\ PE",
"55733287", "Belmonte\ \-\ BA",
"55183522", "Adamantina\ \-\ SP",
"55483061", "Criciúma\ \-\ SC",
"55893523", "Floriano\ \-\ PI",
"55242107", "Volta\ Redonda\ \-\ RJ",
"55853475", "Caucaia\ \-\ CE",
"55323538", "Presidente\ Bernardes\ \-\ MG",
"55673596", "Cassilândia\ \-\ MS",
"55313546", "Minas\ Gerais",
"55513362", "Rio\ Grande\ do\ Sul",
"55833644", "Tenório\ \-\ PB",
"55453352", "Rio\ do\ Salto\ \-\ PR",
"55113353", "São\ Paulo\ \-\ SP",
"55873857", "Flores\ \-\ PE",
"55643438", "Domiciano\ Ribeiro\ \-\ GO",
"55813552", "Ipojuca\ \-\ PE",
"55143375", "Espírito\ Santo\ do\ Turvo\ \-\ SP",
"55833313", "Boa\ Vista\ \-\ PB",
"5516363", "Ribeirão\ Preto\ \-\ SP",
"55663545", "Sorriso\ \-\ MT",
"55923362", "Careiro\ \-\ AM",
"55313763", "Conselheiro\ Lafaiete\ \-\ MG",
"55873830", "Solidão\ \-\ PE",
"55713634", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"5531349", "Belo\ Horizonte\ \-\ MG",
"55273047", "Linhares\ \-\ ES",
"55543291", "São\ Marcos\ \-\ RS",
"55133500", "Santos\ \-\ SP",
"55143287", "Avaí\ \-\ SP",
"55313759", "Minas\ Gerais",
"55333089", "Governador\ Valadares\ \-\ MG",
"55112836", "São\ Paulo\ \-\ SP",
"55222652", "Saquarema\ \-\ RJ",
"55773457", "Riacho\ de\ Santana\ \-\ BA",
"55713671", "Camaçari\ \-\ BA",
"55223833", "Bom\ Jesus\ do\ Itabapoana\ \-\ RJ",
"55493447", "Ouro\ Verde\ \-\ SC",
"55513666", "Terra\ de\ Areia\ \-\ RS",
"55612141", "Brasília\ \-\ DF",
"55443062", "Paranavaí\ \-\ PR",
"55173836", "Cosmorama\ \-\ SP",
"55813622", "Carpina\ \-\ PE",
"55513581", "Novo\ Hamburgo\ \-\ RS",
"55713394", "Aratu\ \-\ BA",
"55513933", "Gravataí\ \-\ RS",
"55323576", "Dores\ do\ Turvo\ \-\ MG",
"55333354", "Bom\ Jesus\ do\ Galho\ \-\ MG",
"55543380", "Ibirapuitã\ \-\ RS",
"55483248", "Florianópolis\ \-\ SC",
"55773430", "Caatiba\ \-\ BA",
"55733605", "Itabatan\ \-\ BA",
"55453239", "Juvinópolis\ \-\ PR",
"552124", "Rio\ de\ Janeiro\ \-\ RJ",
"55633447", "São\ Miguel\ do\ Tocantins\ \-\ TO",
"55112892", "São\ Paulo\ \-\ SP",
"55553324", "Cruz\ Alta\ \-\ RS",
"55353441", "Ouro\ Fino\ \-\ MG",
"55173561", "Novais\ \-\ SP",
"55923581", "Manaus\ \-\ AM",
"55212124", "Duque\ de\ Caxias\ \-\ RJ",
"55553535", "Três\ de\ Maio\ \-\ RS",
"55513740", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55183652", "Penápolis\ \-\ SP",
"55893550", "Jerumenha\ \-\ PI",
"55833033", "Santa\ Rita\ \-\ PB",
"55853813", "São\ Paulo\ \-\ SP",
"55323344", "Bias\ Fortes\ \-\ MG",
"55823524", "Feira\ Grande\ \-\ AL",
"55193626", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55373226", "Nova\ Serrana\ \-\ MG",
"55343633", "Tapira\ \-\ MG",
"55623457", "Monte\ Alegre\ de\ Goiás\ \-\ GO",
"55933737", "Almeirim\ \-\ PA",
"55163665", "Altinópolis\ \-\ SP",
"55663528", "Luciára\ \-\ MT",
"55313331", "Minas\ Gerais",
"55713043", "Salvador\ \-\ BA",
"55183999", "Estrela\ do\ Norte\ \-\ SP",
"55893537", "Eliseu\ Martins\ \-\ PI",
"55423233", "Castro\ \-\ PR",
"55343266", "Canápolis\ \-\ MG",
"55223311", "Macaé\ \-\ RJ",
"55623520", "Goiânia\ \-\ GO",
"55483286", "Palhoça\ \-\ SC",
"55413642", "Araucária\ \-\ PR",
"55173648", "Paranapuã\ \-\ SP",
"55163287", "Vista\ Alegre\ do\ Alto\ \-\ SP",
"55513544", "Taquara\ \-\ RS",
"55663438", "Nova\ Xavantina\ \-\ MT",
"55213633", "Guapimirim\ \-\ RJ",
"55813619", "Fernando\ de\ Noronha\ \-\ PE",
"55923018", "Manaus\ \-\ AM",
"55543511", "Vacaria\ \-\ RS",
"55543046", "Passo\ Fundo\ \-\ RS",
"55893427", "Tanque\ do\ Piauí\ \-\ PI",
"55643545", "Itumbiara\ \-\ GO",
"55513310", "Rio\ Grande\ do\ Sul",
"55553797", "Novo\ Tiradentes\ \-\ RS",
"55673216", "Sidrolândia\ \-\ MS",
"55623397", "Rialma\ \-\ GO",
"55883579", "Quixelô\ \-\ CE",
"55353622", "Itajubá\ \-\ MG",
"55163987", "Serrana\ \-\ SP",
"55323445", "Argirita\ \-\ MG",
"55433554", "Congonhinhas\ \-\ PR",
"55513018", "Porto\ Alegre\ \-\ RS",
"55973473", "São\ Gabriel\ da\ Cachoeira\ \-\ AM",
"55123411", "Taubaté\ \-\ SP",
"55313164", "Santa\ Luzia\ \-\ MG",
"55853331", "Barreira\ \-\ CE",
"55553289", "Vale\ Vêneto\ \-\ RS",
"55193907", "Amparo\ \-\ SP",
"55423302", "Ponta\ Grossa\ \-\ PR",
"55153282", "Tietê\ \-\ SP",
"55413283", "São\ José\ dos\ Pinhais\ \-\ PR",
"55473473", "Joinville\ \-\ SC",
"55813099", "Olinda\ \-\ PE",
"55753628", "São\ Felipe\ \-\ BA",
"55443038", "Umuarama\ \-\ PR",
"55773623", "São\ Desidério\ \-\ BA",
"55643658", "São\ Simão\ \-\ GO",
"55924004", "Manaus\ \-\ AM",
"55112594", "São\ Paulo\ \-\ SP",
"55192511", "Campinas\ \-\ SP",
"55743659", "Várzea\ Nova\ \-\ BA",
"55513698", "Capela\ de\ Santana\ \-\ RS",
"55883624", "Granja\ \-\ CE",
"55163567", "Cajuru\ \-\ SP",
"55193483", "São\ Pedro\ \-\ SP",
"55483257", "São\ José\ \-\ SC",
"55163256", "Santa\ Ernestina\ \-\ SP",
"55943386", "Lindoeste\ \-\ PA",
"55432101", "Londrina\ \-\ PR",
"55633366", "Miracema\ do\ Tocantins\ \-\ TO",
"55313570", "Minas\ Gerais",
"55212697", "Mesquita\ \-\ RJ",
"55913746", "Bujaru\ \-\ PA",
"55134010", "Santos\ \-\ SP",
"55753443", "Crisópolis\ \-\ BA",
"55793260", "Barra\ dos\ Coqueiros\ \-\ SE",
"55493458", "Itá\ \-\ SC",
"55653346", "Nortelândia\ \-\ MT",
"55773448", "Dom\ Basílio\ \-\ BA",
"55692101", "Vilhena\ \-\ RO",
"55513738", "Venâncio\ Aires\ \-\ RS",
"55743542", "Senhor\ do\ Bonfim\ \-\ BA",
"55163956", "Pontal\ \-\ SP",
"55493366", "Pinhalzinho\ \-\ SC",
"55463534", "São\ Jorge\ D\'Oeste\ \-\ PR",
"55673449", "Nova\ Andradina\ \-\ MS",
"55313499", "Minas\ Gerais",
"55134002", "Santos\ \-\ SP",
"55743631", "Serrolândia\ \-\ BA",
"55153562", "Itaberá\ \-\ SP",
"55543452", "Bento\ Gonçalves\ \-\ RS",
"55963325", "Cutias\ \-\ AP",
"55843328", "Governador\ Dix\-Sept\ Rosado\ \-\ RN",
"55333523", "Teófilo\ Otoni\ \-\ MG",
"55383676", "Unaí\ \-\ MG",
"55833343", "Campina\ Grande\ \-\ PB",
"55663515", "Sinop\ \-\ MT",
"55113654", "Osasco\ \-\ SP",
"55853084", "Fortaleza\ \-\ CE",
"55513255", "Rio\ Grande\ do\ Sul",
"5521346", "Rio\ de\ Janeiro\ \-\ RJ",
"55932101", "Santarém\ \-\ PA",
"55813879", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55193809", "Hortolândia\ \-\ SP",
"55543273", "Nova\ Bassano\ \-\ RS",
"55643954", "Itumbiara\ \-\ GO",
"55274105", "Vila\ Velha\ \-\ ES",
"55853363", "Paraipaba\ \-\ CE",
"55983681", "Santa\ Inês\ \-\ MA",
"55163403", "Franca\ \-\ SP",
"55613436", "Brasília\ \-\ DF",
"55173423", "Votuporanga\ \-\ SP",
"55623448", "Flores\ de\ Goiás\ \-\ GO",
"55273245", "Serra\ \-\ ES",
"55463243", "Mangueirinha\ \-\ PR",
"55633602", "Paraíso\ do\ Tocantins\ \-\ TO",
"55653388", "Várzea\ Grande\ \-\ MT",
"55543336", "Ipiranga\ do\ Sul\ \-\ RS",
"55613526", "Brasília\ \-\ DF",
"55483644", "Laguna\ \-\ SC",
"55713276", "Salvador\ \-\ BA",
"55453251", "Ouro\ Verde\ do\ Oeste\ \-\ PR",
"55242442", "Barra\ do\ Piraí\ \-\ RJ",
"55112533", "São\ Paulo\ \-\ SP",
"55613352", "Taguatinga\ \-\ DF",
"55333433", "São\ José\ do\ Jacuri\ \-\ MG",
"55133844", "Juquiá\ \-\ SP",
"55943348", "Curionópolis\ \-\ PA",
"55863345", "São\ João\ da\ Fronteira\ \-\ PI",
"55413112", "Curitiba\ \-\ PR",
"55963424", "Pracuúba\ \-\ AP",
"55173281", "Olímpia\ \-\ SP",
"55843237", "Parnamirim\ \-\ RN",
"55112118", "Itu\ \-\ SP",
"55543392", "Lagoa\ dos\ Três\ Cantos\ \-\ RS",
"55112657", "Guarulhos\ \-\ SP",
"55433017", "Londrina\ \-\ PR",
"55223861", "Itaocara\ \-\ RJ",
"55443571", "Luiziana\ \-\ PR",
"55983313", "São\ Luís\ \-\ MA",
"55423025", "Ponta\ Grossa\ \-\ PR",
"55643647", "Maurilândia\ \-\ GO",
"55114539", "Joanópolis\ \-\ SP",
"55473404", "Itajaí\ \-\ SC",
"55483027", "Florianópolis\ \-\ SC",
"55993602", "Nova\ Colinas\ \-\ MA",
"55933017", "Santarém\ \-\ PA",
"5511367", "São\ Paulo\ \-\ SP",
"55623486", "Colinas\ do\ Sul\ \-\ GO",
"55123895", "Ilhabela\ \-\ SP",
"55115907", "São\ Paulo\ \-\ SP",
"55163026", "Franca\ \-\ SP",
"55343661", "Araxá\ \-\ MG",
"55833489", "São\ José\ de\ Caiana\ \-\ PB",
"55813726", "Belo\ Jardim\ \-\ PE",
"55963243", "Macapá\ \-\ AP",
"55123119", "Campos\ de\ Cunha\ \-\ SP",
"55114667", "Itapecerica\ da\ Serra\ \-\ SP",
"55513762", "Rio\ Grande\ do\ Sul",
"55272101", "Colatina\ \-\ ES",
"55213694", "Maricá\ \-\ RJ",
"55313084", "Belo\ Horizonte\ \-\ MG",
"55343074", "Uberaba\ \-\ MG",
"5592362", "Manaus\ \-\ AM",
"55823622", "São\ José\ da\ Tapera\ \-\ AL",
"55654141", "Cuiabá\ \-\ MT",
"55173848", "Gastão\ Vidigal\ \-\ SP",
"55833391", "Boqueirão\ \-\ PB",
"55353434", "Itapeva\ \-\ MG",
"55313576", "Bonfim\ \-\ MG",
"55112848", "São\ Paulo\ \-\ SP",
"55483659", "Pedras\ Grandes\ \-\ SC",
"55423421", "Irati\ \-\ PR",
"55273299", "Vila\ Velha\ \-\ ES",
"55243381", "Resende\ \-\ RJ",
"55213833", "Rio\ de\ Janeiro\ \-\ RJ",
"55163851", "Morro\ Agudo\ \-\ SP",
"55793530", "Estância\ \-\ SE",
"55114023", "Itu\ \-\ SP",
"55663488", "Santo\ Antonuio\ do\ Leste\ \-\ MT",
"55673043", "Campo\ Grande\ \-\ MS",
"55383616", "Matias\ Cardoso\ \-\ MG",
"55663575", "Peixoto\ de\ Azevedo\ \-\ MT",
"55713508", "Lauro\ de\ Freitas\ \-\ BA",
"55483236", "Florianópolis\ \-\ SC",
"55473547", "Braço\ do\ Trombudo\ \-\ SC",
"55793266", "Santo\ Amaro\ das\ Brotas\ \-\ SE",
"55353822", "Lavras\ \-\ MG",
"55413581", "Curitiba\ \-\ PR",
"55333626", "Santa\ Helena\ de\ Minas\ \-\ MG",
"55222554", "Macuco\ \-\ RJ",
"55943778", "Vila\ Residencial\ de\ Tucuruí\ \-\ PA",
"55123849", "Ubatuba\ \-\ SP",
"55673671", "Dourados\ \-\ MS",
"55813709", "Belo\ Jardim\ \-\ PE",
"55193779", "Campinas\ \-\ SP",
"55143481", "Marília\ \-\ SP",
"55413666", "Colombo\ \-\ PR",
"55813524", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55513421", "Gravataí\ \-\ RS",
"55114317", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55642103", "Itumbiara\ \-\ GO",
"55453324", "Cascavel\ \-\ PR",
"55474007", "Joinville\ \-\ SC",
"5542362", "Guarapuava\ \-\ PR",
"55212787", "Duque\ de\ Caxias\ \-\ RJ",
"55753491", "Feira\ de\ Santana\ \-\ BA",
"55513898", "Porto\ Alegre\ \-\ RS",
"55853381", "Maracanaú\ \-\ CE",
"55323331", "Barbacena\ \-\ MG",
"55843256", "Boa\ Saúde\ \-\ RN",
"55472106", "Jaraguá\ do\ Sul\ \-\ SC",
"55713270", "Salvador\ \-\ BA",
"55923531", "Barreirinha\ \-\ AM",
"55543038", "Garibaldi\ \-\ RS",
"55423642", "Turvo\ \-\ PR",
"55122125", "Taubaté\ \-\ SP",
"55543330", "Carazinho\ \-\ RS",
"55213311", "Macaé\ \-\ RJ",
"55513283", "Novo\ Hamburgo\ \-\ RS",
"55773480", "Coribe\ \-\ BA",
"55173636", "Dolcinópolis\ \-\ SP",
"55613623", "Luziânia\ \-\ GO",
"55143223", "Bauru\ \-\ SP",
"55313445", "Belo\ Horizonte\ \-\ MG",
"55673495", "Caracol\ \-\ MS",
"55613397", "Taguatinga\ \-\ DF",
"55413698", "Almirante\ Tamandaré\ \-\ PR",
"55913544", "Oriximiná\ \-\ PA",
"55173692", "Santana\ da\ Ponte\ Pensa\ \-\ SP",
"55343242", "Araguari\ \-\ MG",
"5511361", "São\ Paulo\ \-\ SP",
"55813434", "Paulista\ \-\ PE",
"55513983", "Venâncio\ Aires\ \-\ RS",
"55854042", "Fortaleza\ \-\ CE",
"55673454", "Maracaju\ \-\ MS",
"55112886", "São\ Paulo\ \-\ SP",
"55173263", "Mirassolândia\ \-\ SP",
"55283555", "Mimoso\ do\ Sul\ \-\ ES",
"55153268", "Boituva\ \-\ SP",
"55983373", "Maracaçumé\ \-\ MA",
"55543357", "Camargo\ \-\ RS",
"55313714", "Paraopeba\ \-\ MG",
"55193455", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55653901", "Cuiabá\ \-\ MT",
"55113411", "São\ Paulo\ \-\ SP",
"55313381", "Belo\ Horizonte\ \-\ MG",
"55343833", "Serra\ do\ Salitre\ \-\ MG",
"55833364", "Remígio\ \-\ PB",
"55193826", "Vinhedo\ \-\ SP",
"55893587", "Dirceu\ Arcoverde\ \-\ PI",
"55823277", "Anadia\ \-\ AL",
"55713216", "Simões\ Filho\ \-\ BA",
"55493573", "Calmon\ \-\ SC",
"55173012", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55833451", "Itaporanga\ \-\ PB",
"55353335", "Conceição\ do\ Rio\ Verde\ \-\ MG",
"55853344", "Paracuru\ \-\ CE",
"55353524", "São\ João\ Batista\ do\ Glória\ \-\ MG",
"55843287", "Lagoa\ D\'Anta\ \-\ RN",
"55553265", "Agudo\ \-\ RS",
"55913738", "Km\ 12\ \-\ PA",
"55443452", "Santa\ Cruz\ de\ Monte\ Castelo\ \-\ PR",
"55653057", "Cuiabá\ \-\ MT",
"55773492", "Presidente\ Jânio\ Quadros\ \-\ BA",
"55513660", "Rio\ Grande\ do\ Sul",
"55793548", "Santa\ Luzia\ do\ Itanhy\ \-\ SE",
"55513559", "Sapiranga\ \-\ RS",
"55843375", "Taboleiro\ Grande\ \-\ RN",
"55343003", "Uberlândia\ \-\ MG",
"55113552", "São\ Paulo\ \-\ SP",
"55513563", "Ivoti\ \-\ RS",
"55513746", "Rio\ Grande\ do\ Sul",
"55753339", "Souto\ Soares\ \-\ BA",
"553139", "Minas\ Gerais",
"55533245", "Candiota\ \-\ RS",
"55152107", "Porto\ Feliz\ \-\ SP",
"55443273", "Ivatuba\ \-\ PR",
"55433549", "Bandeirantes\ \-\ PR",
"55493802", "Lages\ \-\ SC",
"55873878", "Bodocó\ \-\ PE",
"55793014", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55773436", "Barra\ do\ Choça\ \-\ BA",
"55653338", "Gleba\ Ranchão\ \-\ MT",
"55543386", "Muliterno\ \-\ RS",
"55123654", "Caçapava\ \-\ SP",
"55183697", "Rubiácea\ \-\ SP",
"55314136", "Belo\ Horizonte\ \-\ MG",
"55313034", "Contagem\ \-\ MG",
"55883522", "Jaguaribe\ \-\ CE",
"55643416", "Morrinhos\ \-\ GO",
"55833439", "Lagoa\ \-\ PB",
"55383729", "Curvelo\ \-\ MG",
"55694009", "Porto\ Velho\ \-\ RO",
"55933549", "Porto\ Trombetas\ \-\ PA",
"55493700", "Chapecó\ \-\ SC",
"55383504", "Paracatu\ \-\ MG",
"55162102", "Ribeirão\ Preto\ \-\ SP",
"5511566", "São\ Paulo\ \-\ SP",
"55213855", "Rio\ de\ Janeiro\ \-\ RJ",
"55513407", "Porto\ Alegre\ \-\ RS",
"55434009", "Londrina\ \-\ PR",
"55953553", "Cantá\ \-\ RR",
"55743644", "Itaguaçu\ da\ Bahia\ \-\ BA",
"55113122", "São\ Paulo\ \-\ SP",
"55183323", "Assis\ \-\ SP",
"5511314", "São\ Paulo\ \-\ SP",
"55813217", "Recife\ \-\ PE",
"55513788", "Progresso\ \-\ RS",
"55943392", "Canaã\ dos\ Carajás\ \-\ PA",
"55313873", "Matipó\ \-\ MG",
"55153546", "Buri\ \-\ SP",
"55673202", "Campo\ Grande\ \-\ MS",
"55543348", "Água\ Santa\ \-\ RS",
"55242220", "Petrópolis\ \-\ RJ",
"55623526", "Goiânia\ \-\ GO",
"55343855", "Rio\ Paranaíba\ \-\ MG",
"55833278", "Alagoinha\ \-\ PB",
"55163839", "Ituverava\ \-\ SP",
"55983304", "São\ Luís\ \-\ MA",
"55553752", "Ametista\ do\ Sul\ \-\ RS",
"55673902", "Dourados\ \-\ MS",
"55483631", "Tubarão\ \-\ SC",
"55343426", "Pirajuba\ \-\ MG",
"55182101", "Presidente\ Prudente\ \-\ SP",
"558532", "Fortaleza\ \-\ CE",
"55883432", "Icapuí\ \-\ CE",
"55333722", "Mata\ Verde\ \-\ MG",
"55323363", "Lagoa\ Dourada\ \-\ MG",
"55283533", "Rio\ Novo\ do\ Sul\ \-\ ES",
"55883519", "Granjeiro\ \-\ CE",
"55613486", "Brasília\ \-\ DF",
"55553251", "Santiago\ \-\ RS",
"55413025", "Curitiba\ \-\ PR",
"55333221", "Governador\ Valadares\ \-\ MG",
"55513370", "Rio\ Grande\ do\ Sul",
"55653927", "Várzea\ Grande\ \-\ MT",
"55493342", "Galvão\ \-\ SC",
"55323084", "Juiz\ de\ Fora\ \-\ MG",
"55813679", "Gameleira\ \-\ PE",
"55212756", "São\ João\ de\ Meriti\ \-\ RJ",
"55984002", "São\ Luís\ \-\ MA",
"55163315", "Ribeirão\ Preto\ \-\ SP",
"55743681", "Ourolândia\ \-\ BA",
"55273756", "Barra\ de\ São\ Francisco\ \-\ ES",
"55653362", "Várzea\ Grande\ \-\ MT",
"55473348", "Itajaí\ \-\ SC",
"55313697", "Bairro\ Eldorado\ \-\ Sete\ Lagoas\ MG",
"55833265", "Duas\ Estradas\ \-\ PB",
"55123676", "Redenção\ da\ Serra\ \-\ SP",
"55212673", "Duque\ de\ Caxias\ \-\ RJ",
"55713177", "Salvador\ \-\ BA",
"55483436", "Nova\ Veneza\ \-\ SC",
"55144104", "Garça\ \-\ SP",
"55513722", "Cachoeira\ do\ Sul\ \-\ RS",
"55893574", "Curimatá\ \-\ PI",
"55333316", "Pocrane\ \-\ MG",
"55733533", "Maracas\ \-\ BA",
"55553512", "Santa\ Rosa\ \-\ RS",
"55733281", "Eunápolis\ \-\ BA",
"55312586", "Contagem\ \-\ MG",
"55823284", "Cajueiro\ \-\ AL",
"55153519", "Sorocaba\ \-\ SP",
"55883691", "Crateús\ \-\ CE",
"55423221", "Telêmaco\ Borba\ \-\ PR",
"55313323", "Belo\ Horizonte\ \-\ MG",
"55813543", "Igarassu\ \-\ PE",
"55123602", "Taubaté\ \-\ SP",
"55114133", "Barueri\ \-\ SP",
"55114044", "Diadema\ \-\ SP",
"55843396", "Lucrécia\ \-\ RN",
"55143533", "Lins\ \-\ SP",
"55112085", "Guarulhos\ \-\ SP",
"55873851", "Petrolândia\ \-\ PE",
"55353798", "Areado\ \-\ MG",
"55823312", "Maceió\ \-\ AL",
"55923221", "Manaus\ \-\ AM",
"55453055", "Toledo\ \-\ PR",
"55814003", "Recife\ \-\ PE",
"55513065", "Novo\ Hamburgo\ \-\ RS",
"55114518", "Mauá\ \-\ SP",
"5513356", "São\ Vicente\ \-\ SP",
"55143281", "Bauru\ \-\ SP",
"55883546", "Nova\ Olinda\ \-\ CE",
"55543297", "Flores\ da\ Cunha\ \-\ RS",
"55843332", "Areia\ Branca\ \-\ RN",
"55143880", "Botucatu\ \-\ SP",
"55324009", "Juiz\ de\ Fora\ \-\ MG",
"55313245", "Belo\ Horizonte\ \-\ MG",
"55673295", "São\ Gabriel\ do\ Oeste\ \-\ MS",
"5511279", "São\ Paulo\ \-\ SP",
"55333746", "Rubim\ \-\ MG",
"55753264", "Riachão\ do\ Jacuípe\ \-\ BA",
"55673254", "Sonora\ \-\ MS",
"55173463", "Fernandópolis\ \-\ SP",
"55873865", "Dormentes\ \-\ PE",
"55943305", "Bannach\ \-\ PA",
"55513719", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55353543", "Capetinga\ \-\ MG",
"55993552", "Colinas\ \-\ MA",
"55853323", "Tejuçuoca\ \-\ CE",
"55623542", "Goiânia\ \-\ GO",
"55983352", "Vitória\ do\ Mearim\ \-\ MA",
"55553278", "Pinhal\ Grande\ \-\ RS",
"55473386", "Rio\ dos\ Cedros\ \-\ SC",
"55114206", "Jandira\ \-\ SP",
"55212774", "São\ João\ de\ Meriti\ \-\ RJ",
"55733244", "Itagibá\ \-\ BA",
"55413523", "Curitiba\ \-\ PR",
"55153522", "Itapeva\ \-\ SP",
"55513051", "Canoas\ \-\ RS",
"55693516", "Ariquemes\ \-\ RO",
"55115933", "São\ Paulo\ \-\ SP",
"5521342", "Rio\ de\ Janeiro\ \-\ RJ",
"55513483", "Alvorada\ \-\ RS",
"55993326", "Timon\ \-\ MA",
"55613027", "Taguatinga\ \-\ DF",
"55843368", "Triunfo\ Potiguar\ \-\ RN",
"55133448", "Mongaguá\ \-\ SP",
"55114081", "São\ Paulo\ \-\ SP",
"55213621", "Rio\ de\ Janeiro\ \-\ RJ",
"55833251", "João\ Pessoa\ \-\ PB",
"55623631", "Jataí\ \-\ GO",
"55193955", "Socorro\ \-\ SP",
"55114469", "Santo\ André\ \-\ SP",
"55493326", "Caxambu\ do\ Sul\ \-\ SC",
"55113188", "São\ Paulo\ \-\ SP",
"55483526", "Balneário\ Arroio\ do\ Silva\ \-\ SC",
"55623280", "Aparecida\ de\ Goiânia\ \-\ GO",
"55373371", "Piumhi\ \-\ MG",
"55883664", "Marco\ \-\ CE",
"55114272", "Santana\ de\ Parnaíba\ \-\ SP",
"5511332", "São\ Paulo\ \-\ SP",
"55863259", "Lagoa\ do\ Piauí\ \-\ PI",
"55643611", "Rio\ Verde\ \-\ GO",
"55312101", "Belo\ Horizonte\ \-\ MG",
"55443305", "Maringá\ \-\ PR",
"55493552", "Lacerdópolis\ \-\ SC",
"55112507", "São\ Paulo\ \-\ SP",
"55243323", "Barra\ Mansa\ \-\ RJ",
"55863263", "Cocal\ de\ Telha\ \-\ PI",
"55273084", "Vitória\ \-\ ES",
"55333531", "Caraí\ \-\ MG",
"55473330", "Blumenau\ \-\ SC",
"55183502", "Adamantina\ \-\ SP",
"55513039", "Sapiranga\ \-\ RS",
"55483205", "Florianópolis\ \-\ SC",
"55183344", "Presidente\ Prudente\ \-\ SP",
"55153275", "Itapetininga\ \-\ SP",
"55542106", "Erechim\ \-\ RS",
"55413455", "Pontal\ do\ Paraná\ \-\ PR",
"55793347", "Cedro\ de\ São\ João\ \-\ SE",
"55473357", "Ibirama\ \-\ SC",
"55193544", "Araras\ \-\ SP",
"55443252", "Nova\ Esperança\ \-\ PR",
"5571321", "Salvador\ \-\ BA",
"55223717", "Macaé\ \-\ RJ",
"55773663", "Morpará\ \-\ BA",
"55813372", "Paulista\ \-\ PE",
"55163214", "Araraquara\ \-\ SP",
"55193302", "Piracicaba\ \-\ SP",
"55114601", "Jundiaí\ \-\ SP",
"55493649", "Barra\ Bonita\ \-\ SC",
"55823646", "Canapi\ \-\ AL",
"55883303", "Aracati\ \-\ CE",
"55813638", "Bom\ Jardim\ \-\ PE",
"55213167", "Duque\ de\ Caxias\ \-\ RJ",
"55423907", "Irati\ \-\ PR",
"55663419", "Campo\ Verde\ \-\ MT",
"55163382", "Matão\ \-\ SP",
"55353293", "Areado\ \-\ MG",
"55663532", "Sinop\ \-\ MT",
"55313554", "Lavras\ Novas\ \-\ MG",
"5511263", "São\ Paulo\ \-\ SP",
"55993649", "Peritoró\ \-\ MA",
"55353662", "Maria\ da\ Fé\ \-\ MG",
"55913494", "Muaná\ \-\ PA",
"55273331", "Vitória\ \-\ ES",
"55242266", "Werneck\ \-\ RJ",
"55163878", "Ribeirão\ Preto\ \-\ SP",
"55893467", "Lagoa\ do\ Sítio\ \-\ PI",
"55663596", "Paranorte\ \-\ MT",
"55443019", "Cianorte\ \-\ PR",
"55453218", "Cascavel\ \-\ PR",
"55913461", "Colares\ \-\ PA",
"55663568", "São\ José\ do\ Xingu\ \-\ MT",
"55313852", "João\ Monlevade\ \-\ MG",
"55673410", "Dourados\ \-\ MS",
"55554062", "Santa\ Maria\ \-\ RS",
"5598323", "São\ Luís\ \-\ MA",
"55123971", "São\ Bento\ do\ Sapucaí\ \-\ SP",
"55813846", "Santa\ Cruz\ da\ Baixa\ Verde\ \-\ PE",
"55312557", "Contagem\ \-\ MG",
"55733561", "Ubaitaba\ \-\ BA",
"55193581", "Porto\ Ferreira\ \-\ SP",
"55193933", "Paulínia\ \-\ SP",
"55623373", "Jussara\ \-\ GO",
"55212703", "Niterói\ \-\ RJ",
"55714109", "Salvador\ \-\ BA",
"55533613", "Pedras\ Altas\ \-\ RS",
"55843274", "Ceará\-Mirim\ \-\ RN",
"55112521", "São\ Paulo\ \-\ SP",
"55753696", "Saubara\ \-\ BA",
"55313737", "Minas\ Gerais",
"55613114", "Brasília\ \-\ DF",
"55173521", "Catanduva\ \-\ SP",
"55473062", "Balneário\ Camboriú\ \-\ SC",
"55163501", "São\ Carlos\ \-\ SP",
"55193842", "Serra\ Negra\ \-\ SP",
"55313750", "Minas\ Gerais",
"55513626", "Torres\ \-\ RS",
"55873839", "Alagoinha\ \-\ PE",
"55673476", "Itaquiraí\ \-\ MS",
"55544007", "Caxias\ do\ Sul\ \-\ RS",
"55114161", "Barueri\ \-\ SP",
"55993075", "Imperatriz\ \-\ MA",
"5513328", "Santos\ \-\ SP",
"55333421", "Guanhães\ \-\ MG",
"55753632", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55813662", "Palmares\ \-\ PE",
"55513433", "Rio\ Grande\ do\ Sul",
"552122", "Rio\ de\ Janeiro\ \-\ RJ",
"55122139", "São\ José\ dos\ Campos\ \-\ SP",
"55163818", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55223087", "Macaé\ \-\ RJ",
"55473336", "Blumenau\ \-\ SC",
"55353241", "São\ Gonçalo\ do\ Sapucaí\ \-\ MG",
"55653322", "Cuiabá\ \-\ MT",
"55222673", "Araruama\ \-\ RJ",
"5566", "Mato\ Grosso",
"55823543", "Teotônio\ Vilela\ \-\ AL",
"55333025", "Governador\ Valadares\ \-\ MG",
"55913722", "Curuçá\ \-\ PA",
"55493247", "Lebon\ Régis\ \-\ SC",
"55323323", "São\ João\ Del\ Rei\ \-\ MG",
"55333261", "Conselheiro\ Pena\ \-\ MG",
"55833553", "Carrapateira\ \-\ PB",
"55193112", "Campinas\ \-\ SP",
"55663479", "Novo\ São\ Joaquim\ \-\ MT",
"55713647", "Catu\ \-\ BA",
"55163708", "Franca\ \-\ SP",
"55323017", "Juiz\ de\ Fora\ \-\ MG",
"55123146", "Lavrinhas\ \-\ SP",
"55113138", "São\ Paulo\ \-\ SP",
"55553343", "Cruz\ Alta\ \-\ RS",
"55113602", "Osasco\ \-\ SP",
"55513609", "Rio\ Grande\ do\ Sul",
"55352105", "Varginha\ \-\ MG",
"55143768", "Jurumirim\ \-\ SP",
"55883538", "Potengi\ \-\ CE",
"55553614", "Vitória\ das\ Missões\ \-\ RS",
"55373426", "Campos\ Altos\ \-\ MG",
"55163974", "Ribeirão\ Preto\ \-\ SP",
"55115642", "São\ Paulo\ \-\ SP",
"55353742", "Bandeira\ do\ Sul\ \-\ MG",
"55114031", "Bragança\ Paulista\ \-\ SP",
"55633471", "Tocantinópolis\ \-\ TO",
"55113513", "São\ Paulo\ \-\ SP",
"55343821", "Patos\ de\ Minas\ \-\ MG",
"55913483", "São\ Domingos\ do\ Capim\ \-\ PA",
"55623598", "Aparecida\ de\ Goiânia\ \-\ GO",
"55633654", "Taguatinga\ \-\ TO",
"55993015", "Imperatriz\ \-\ MA",
"5511562", "São\ Paulo\ \-\ SP",
"55123876", "São\ José\ dos\ Campos\ \-\ SP",
"55313897", "São\ Miguel\ do\ Anta\ \-\ MG",
"55673416", "Dourados\ \-\ MS",
"55633695", "Novo\ Alegre\ \-\ TO",
"55883428", "Iracema\ \-\ CE",
"55733231", "Ilhéus\ \-\ BA",
"55314009", "Belo\ Horizonte\ \-\ MG",
"55193746", "Campinas\ \-\ SP",
"55333738", "Francisco\ Badaró\ \-\ MG",
"55653319", "Cuiabá\ \-\ MT",
"55823234", "Maceió\ \-\ AL",
"55353284", "Serrania\ \-\ MG",
"55683261", "Humaitá\ \(Pad\ Humaitá\)\ \-\ AC",
"55613304", "Guará\ \-\ DF",
"55733680", "Ilhéus\ \-\ BA",
"55143732", "Avaré\ \-\ SP",
"55883562", "Mineirolândia\ \-\ CE",
"55142122", "Avaré\ \-\ SP",
"55193563", "Pirassununga\ \-\ SP",
"55443645", "Terra\ Roxa\ \-\ PR",
"55213037", "Nova\ Iguaçu\ \-\ RJ",
"55383753", "Felixlândia\ \-\ MG",
"5531351", "Minas\ Gerais",
"55423523", "União\ da\ Vitória\ \-\ PR",
"55493654", "São\ Bernardino\ \-\ SC",
"55683025", "Rio\ Branco\ \-\ AC",
"55773644", "Brotas\ de\ Macaúbas\ \-\ BA",
"55193129", "Vinhedo\ \-\ SP",
"55613631", "Formosa\ \-\ GO",
"55473452", "Araquari\ \-\ SC",
"55313549", "Minas\ Gerais",
"55793442", "Malhador\ \-\ SE",
"55843382", "Luís\ Gomes\ \-\ RN",
"55813742", "Cachoeirinha\ \-\ PE",
"55753690", "Capela\ do\ Alto\ Alegre\ \-\ BA",
"55633015", "Palmas\ \-\ TO",
"55813477", "Recife\ \-\ PE",
"55193407", "Americana\ \-\ SP",
"55753593", "Heliópolis\ \-\ BA",
"55153624", "Itapeva\ \-\ SP",
"55123211", "Cruzeiro\ \-\ SP",
"55913809", "Inhangapi\ \-\ PA",
"55322101", "Juiz\ de\ Fora\ \-\ MG",
"55163042", "Sertãozinho\ \-\ SP",
"55333294", "Nacip\ Raydan\ \-\ MG",
"55493015", "Lages\ \-\ SC",
"55513523", "Parobé\ \-\ RS",
"55513620", "Rio\ Grande\ do\ Sul",
"55354101", "Varginha\ \-\ MG",
"55313756", "Minas\ Gerais",
"55453278", "Toledo\ \-\ PR",
"55143583", "Balbinos\ \-\ SP",
"55753243", "Conceição\ do\ Jacuípe\ \-\ BA",
"55473046", "Itajaí\ \-\ SC",
"55493258", "Cerro\ Negro\ \-\ SC",
"55843618", "Natal\ \-\ RN",
"55483430", "Criciúma\ \-\ SC",
"55114578", "Mauá\ \-\ SP",
"55683233", "Porto\ Acre\ \-\ AC",
"55143308", "Fartura\ \-\ SP",
"55353564", "Conceição\ da\ Aparecida\ \-\ MG",
"55114485", "Mairiporã\ \-\ SP",
"55553506", "São\ Francisco\ de\ Assis\ \-\ RS",
"55733263", "Teixeira\ de\ Freitas\ \-\ BA",
"55112805", "Diadema\ \-\ SP",
"55163456", "Ribeirão\ Preto\ \-\ SP",
"55413907", "Curitiba\ \-\ PR",
"55733259", "Ibirapitanga\ \-\ BA",
"55813646", "Tracunhaém\ \-\ PE",
"55193866", "Conchal\ \-\ SP",
"55833535", "São\ João\ do\ Rio\ do\ Peixe\ \-\ PB",
"55733692", "Camacan\ \-\ BA",
"55183604", "Vicentinópolis\ \-\ SP",
"55553033", "Santa\ Maria\ \-\ RS",
"55753424", "Muritiba\ \-\ BA",
"55753682", "Gavião\ \-\ BA",
"5513323", "Santos\ \-\ SP",
"55163203", "Jaboticabal\ \-\ SP",
"55873889", "Cedro\ \-\ PE",
"55115112", "São\ Paulo\ \-\ SP",
"55273344", "Viana\ \-\ ES",
"55323554", "Ervália\ \-\ MG",
"55623248", "Aparecida\ de\ Goiânia\ \-\ GO",
"55493735", "Fazenda\ Zandavalli\ \-\ SC",
"55143886", "Pardinho\ \-\ SP",
"55663301", "Rondonópolis\ \-\ MT",
"55693445", "São\ Felipe\ do\ Oeste\ \-\ RO",
"55643495", "Goiatuba\ \-\ GO",
"55883643", "Massapê\ \-\ CE",
"55193642", "Águas\ da\ Prata\ \-\ SP",
"55373242", "Itaúna\ \-\ MG",
"55112715", "Itu\ \-\ SP",
"55513494", "Itapuã\ \-\ RS",
"55112923", "Jundiaí\ \-\ SP",
"55863244", "Miguel\ Alves\ \-\ PI",
"55643454", "Caldas\ Novas\ \-\ GO",
"55143263", "Lençóis\ Paulista\ \-\ SP",
"55513455", "Rio\ Grande\ do\ Sul",
"55733012", "Porto\ Seguro\ \-\ BA",
"55424052", "Guarapuava\ \-\ PR",
"55333233", "Tarumirim\ \-\ MG",
"55513354", "Rio\ Grande\ do\ Sul",
"55813688", "São\ José\ da\ Coroa\ Grande\ \-\ PE",
"55643671", "São\ Luís\ de\ Montes\ Belos\ \-\ GO",
"55223056", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55173481", "São\ João\ das\ Duas\ Pontes\ \-\ SP",
"55843437", "Lagoa\ Nova\ \-\ RN",
"55283521", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55313408", "Belo\ Horizonte\ \-\ MG",
"55693344", "Pimenteiras\ do\ Oeste\ \-\ RO",
"55983397", "Turiaçu\ \-\ MA",
"55433344", "Londrina\ \-\ PR",
"55883415", "Palhano\ \-\ CE",
"55114912", "São\ Paulo\ \-\ SP",
"55444007", "Maringá\ \-\ PR",
"55513461", "Esteio\ \-\ RS",
"55683302", "Rio\ Branco\ \-\ AC",
"55753325", "Iaçu\ \-\ BA",
"55333581", "Nova\ Módica\ \-\ MG",
"55413626", "Mandirituba\ \-\ PR",
"55163396", "Santa\ Lúcia\ \-\ SP",
"55193898", "Lindóia\ \-\ SP",
"55143848", "Itatinga\ \-\ SP",
"55833289", "Juripiranga\ \-\ PB",
"55353591", "Monte\ Santo\ de\ Minas\ \-\ MG",
"55454062", "Cascavel\ \-\ PR",
"55833425", "Quixabá\ \-\ PB",
"55473904", "Itapema\ \-\ SC",
"55273381", "Vitória\ \-\ ES",
"55933502", "Castelo\ dos\ Sonhos\ \-\ PA",
"55113447", "Osasco\ \-\ SP",
"55183703", "Bairro\ Formosa\ \-\ SP",
"55463224", "Pato\ Branco\ \-\ PR",
"55633028", "Palmas\ \-\ TO",
"55513779", "Rio\ Grande\ do\ Sul",
"55173345", "Bebedouro\ \-\ SP",
"55473204", "São\ Francisco\ do\ Sul\ \-\ SC",
"55823293", "Paripueira\ \-\ AL",
"55483623", "Capivari\ de\ Baixo\ \-\ SC",
"55863281", "Milton\ Brandão\ \-\ PI",
"55663582", "Gaúcha\ do\ Norte\ \-\ MT",
"55982016", "São\ Luís\ \-\ MA",
"55113303", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55183638", "Birigui\ \-\ SP",
"55733525", "Jequié\ \-\ BA",
"55633387", "Jaú\ do\ Tocantins\ \-\ TO",
"55163661", "Batatais\ \-\ SP",
"55813510", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55353714", "Poços\ de\ Caldas\ \-\ MG",
"55115614", "São\ Paulo\ \-\ SP",
"55213639", "Itaboraí\ \-\ RJ",
"55813613", "Limoeiro\ \-\ PE",
"55482108", "Florianópolis\ \-\ SC",
"55813344", "Recife\ \-\ PE",
"55114594", "Itatiba\ \-\ SP",
"55913425", "Bragança\ \-\ PA",
"55313524", "Belo\ Horizonte\ \-\ MG",
"55943222", "Marabá\ \-\ PA",
"55493275", "Otacílio\ Costa\ \-\ SC",
"55313335", "Belo\ Horizonte\ \-\ MG",
"55143601", "Jaú\ \-\ SP",
"55433564", "Quatiguá\ \-\ PR",
"55193572", "Leme\ \-\ SP",
"55114555", "Mauá\ \-\ SP",
"55844102", "Natal\ \-\ RN",
"55533293", "Rio\ Grande\ \-\ RS",
"5547", "Santa\ Catarina",
"55222102", "Nova\ Friburgo\ \-\ RJ",
"55453376", "Nova\ Concórdia\ \-\ PR",
"55212646", "São\ Gonçalo\ \-\ RJ",
"55613702", "Brasília\ \-\ DF",
"5597", "Amazonas",
"55743537", "Sento\ Sé\ \-\ BA",
"55773629", "Recife\ \-\ PE",
"55513585", "Campo\ Bom\ \-\ RS",
"55813093", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55115094", "São\ Paulo\ \-\ SP",
"55513478", "Rio\ Grande\ do\ Sul",
"55643668", "Serranópolis\ \-\ GO",
"55313819", "Ponte\ Nova\ \-\ MG",
"55813576", "Sirinhaém\ \-\ PE",
"55212760", "Rio\ das\ Ostras\ \-\ RJ",
"55743653", "Morro\ do\ Chapéu\ \-\ BA",
"55353445", "Borda\ da\ Mata\ \-\ MG",
"55743669", "Várzea\ da\ Roça\ \-\ BA",
"55684062", "Rio\ Branco\ \-\ AC",
"55653397", "Diamantino\ \-\ MT",
"55553421", "Alegrete\ \-\ RS",
"55222662", "Arraial\ do\ Cabo\ \-\ RJ",
"55115061", "São\ Paulo\ \-\ SP",
"55623612", "Goiânia\ \-\ GO",
"55353344", "Aiuruoca\ \-\ MG",
"55513656", "Arroio\ dos\ Ratos\ \-\ RS",
"55163014", "Araraquara\ \-\ SP",
"55313720", "Minas\ Gerais",
"55773467", "Jacaraci\ \-\ BA",
"55643696", "Campo\ Alegre\ de\ Goiás\ \-\ GO",
"5571301", "Salvador\ \-\ BA",
"55323277", "Chácara\ \-\ MG",
"55643632", "Jataí\ \-\ GO",
"55453233", "Campo\ Bonito\ \-\ PR",
"55193181", "Floresta\ Escura\ \-\ SP",
"55623503", "Abadia\ de\ Goiás\ \-\ GO",
"55513239", "Rio\ Grande\ do\ Sul",
"55473238", "Blumenau\ \-\ SC",
"55443677", "Tapejara\ \-\ PR",
"55413535", "Curitiba\ \-\ PR",
"55173551", "Ibirá\ \-\ SP",
"55623092", "Goiânia\ \-\ GO",
"55423656", "Goioxim\ \-\ PR",
"55443219", "Maringá\ \-\ PR",
"55893560", "Francisco\ Ayres\ \-\ PI",
"5531330", "Minas\ Gerais",
"55663452", "Novo\ São\ Joaquim\ \-\ MT",
"55313434", "Belo\ Horizonte\ \-\ MG",
"55643541", "Itumbiara\ \-\ GO",
"55773612", "Barreiras\ \-\ BA",
"55163101", "Ribeirão\ Preto\ \-\ SP",
"55843242", "Arês\ \-\ RN",
"55173121", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55614141", "Brasília\ \-\ DF",
"55623467", "Teresina\ de\ Goiás\ \-\ GO",
"55813445", "Recife\ \-\ PE",
"55183993", "Cuiabá\ Paulista\ \-\ SP",
"55212688", "Itaguaí\ \-\ RJ",
"55114892", "Bragança\ Paulista\ \-\ SP",
"55423239", "Ponta\ Grossa\ \-\ PR",
"55114686", "São\ Lourenço\ da\ Serra\ \-\ SP",
"55243335", "Rio\ Claro\ \-\ RJ",
"55613048", "Taguatinga\ \-\ DF",
"55193874", "Paulínia\ \-\ SP",
"55323441", "Leopoldina\ \-\ MG",
"55343256", "Uberlândia\ \-\ MG",
"55242437", "Ipiabas\ \-\ RJ",
"55373214", "Divinópolis\ \-\ MG",
"55513687", "Arroio\ do\ Sal\ \-\ RS",
"55893542", "Landri\ Sales\ \-\ PI",
"55743635", "Tapiramutá\ \-\ BA",
"55453025", "Foz\ do\ Iguaçu\ \-\ PR",
"55343799", "Araguari\ \-\ MG",
"55843260", "São\ Bento\ do\ Norte\ \-\ RN",
"55212008", "Teresópolis\ \-\ RJ",
"55663511", "Sinop\ \-\ MT",
"55473634", "São\ Bento\ do\ Sul\ \-\ SC",
"55963321", "Serra\ do\ Navio\ \-\ AP",
"55113374", "Mogi\ das\ Cruzes\ \-\ SP",
"55863212", "Timon\ \-\ MA",
"55633519", "Lajeado\ \-\ TO",
"55613362", "Guará\ \-\ DF",
"55173667", "Turmalina\ \-\ SP",
"55513951", "Novo\ Hamburgo\ \-\ RS",
"55273312", "São\ Mateus\ \-\ ES",
"55843536", "Pedra\ Preta\ \-\ RN",
"55313045", "Belo\ Horizonte\ \-\ MG",
"55223851", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55873821", "Arcoverde\ \-\ PE",
"55432105", "Londrina\ \-\ PR",
"55222543", "Nova\ Friburgo\ \-\ RJ",
"55123864", "São\ Sebastião\ \-\ SP",
"55114533", "Jundiaí\ \-\ SP",
"55222640", "Cabo\ Frio\ \-\ RJ",
"55633432", "Bandeirantes\ do\ Tocantins\ \-\ TO",
"55733627", "Santa\ Cruz\ da\ Vitória\ \-\ BA",
"55193055", "Pirassununga\ \-\ SP",
"55423251", "Papagaios\ Novos\ \-\ PR",
"55333512", "Frei\ Gaspar\ \-\ MG",
"55433477", "São\ João\ do\ Ivaí\ \-\ PR",
"55443446", "Paranavaí\ \-\ PR",
"55843003", "Natal\ \-\ RN",
"55213665", "Queimados\ \-\ RJ",
"55114657", "Santa\ Isabel\ \-\ SP",
"55833483", "Olho\ d\'Água\ \-\ PB",
"55493432", "Irani\ \-\ SC",
"55833051", "Campina\ Grande\ \-\ PB",
"5511349", "São\ Paulo\ \-\ SP",
"55513752", "Jacarezinho\ \-\ RS",
"55473301", "Indaial\ \-\ SC",
"55483267", "Nova\ Trento\ \-\ SC",
"55323726", "Patrocínio\ do\ Muriaé\ \-\ MG",
"55213987", "Rio\ de\ Janeiro\ \-\ RJ",
"55913637", "Melgaço\ \-\ PA",
"55633356", "Peixe\ \-\ TO",
"55543617", "Tapejara\ \-\ RS",
"55163266", "Borborema\ \-\ SP",
"55633468", "Couto\ de\ Magalhães\ \-\ TO",
"55243353", "Porto\ Real\ \-\ RJ",
"55123891", "São\ Sebastião\ \-\ SP",
"55493522", "Joaçaba\ \-\ SC",
"55633522", "Lagoa\ do\ Tocantins\ \-\ TO",
"55193713", "Limeira\ \-\ SP",
"55483322", "Florianópolis\ \-\ SC",
"55753449", "Conde\ \-\ BA",
"55623142", "Goiânia\ \-\ GO",
"55273742", "São\ Domingos\ do\ Norte\ \-\ ES",
"55613606", "Santo\ Antônio\ do\ Descoberto\ \-\ GO",
"55472123", "Blumenau\ \-\ SC",
"55493356", "Arvoredo\ \-\ SC",
"55212742", "Teresópolis\ \-\ RJ",
"55673443", "Batayporã\ \-\ MS",
"55733272", "Ibicuí\ \-\ BA",
"55833065", "Campina\ Grande\ \-\ PB",
"55153552", "Apiaí\ \-\ SP",
"55553563", "São\ Paulo\ das\ Missões\ \-\ RS",
"55983322", "Boa\ Vista\ do\ Gurupi\ \-\ MA",
"55553559", "Braga\ \-\ RS",
"55663904", "Barra\ do\ Garças\ \-\ MT",
"55433312", "Arapongas\ \-\ PR",
"55843426", "Serra\ Negra\ do\ Norte\ \-\ RN",
"55143453", "Marília\ \-\ SP",
"55543462", "Garibaldi\ \-\ RS",
"55333529", "Teófilo\ Otoni\ \-\ MG",
"55453255", "São\ Pedro\ do\ Iguaçu\ \-\ PR",
"5521345", "Rio\ de\ Janeiro\ \-\ RJ",
"55434101", "Apucarana\ \-\ PR",
"55923021", "Manaus\ \-\ AM",
"55543528", "Itatiba\ do\ Sul\ \-\ RS",
"55112429", "Itu\ \-\ SP",
"55543279", "Linha\ Oitenta\ \-\ RS",
"55413637", "Bugre\ \-\ PR",
"55613338", "Brasília\ \-\ DF",
"55813873", "Araripina\ \-\ PE",
"55193803", "Sumaré\ \-\ SP",
"55223865", "São\ João\ do\ Paraíso\ \-\ RJ",
"55853353", "Uruburetama\ \-\ CE",
"55443575", "Roncador\ \-\ PR",
"55383824", "Rio\ Pardo\ de\ Minas\ \-\ MG",
"55993522", "Tuntum\ \-\ MA",
"55733206", "Mucuri\ \-\ BA",
"55553746", "Seberi\ \-\ RS",
"55163409", "Franca\ \-\ SP",
"55853369", "Maranguape\ \-\ CE",
"5551350", "Rio\ Grande\ do\ Sul",
"55673675", "Tacuru\ \-\ MS",
"55843266", "Pureza\ \-\ RN",
"55173472", "Nhandeara\ \-\ SP",
"55114000", "Arujá\ \-\ SP",
"55413585", "Curitiba\ \-\ PR",
"55713628", "Arembepe\ \-\ BA",
"55453283", "Margarida\ \-\ PR",
"55643682", "Turvânia\ \-\ GO",
"55513425", "Canoas\ \-\ RS",
"55114308", "Diadema\ \-\ SP",
"55442033", "Palotina\ \-\ PR",
"55613629", "Valparaíso\ de\ Goiás\ \-\ GO",
"55183646", "Brejo\ Alegre\ \-\ SP",
"55114178", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55553376", "Panambi\ \-\ RS",
"55513289", "Rio\ Grande\ do\ Sul",
"55433417", "Ribeirão\ Bonito\ \-\ PR",
"55114012", "Bom\ Jesus\ dos\ Perdões\ \-\ SP",
"55173253", "Mirassol\ \-\ SP",
"55823344", "Maceió\ \-\ AL",
"55543367", "Três\ Palmeiras\ \-\ RS",
"55323335", "Piedade\ do\ Rio\ Grande\ \-\ MG",
"55153258", "Guareí\ \-\ SP",
"55173269", "Ipiguá\ \-\ SP",
"55443440", "Inajá\ \-\ PR",
"55863081", "Teresina\ \-\ PI",
"55623086", "Goiânia\ \-\ GO",
"55213745", "Nova\ Iguaçu\ \-\ RJ",
"55553544", "Novo\ Machado\ \-\ RS",
"55183862", "Pacaembu\ \-\ SP",
"55833395", "Umbuzeiro\ \-\ PB",
"55242487", "Avelar\ \-\ RJ",
"55273372", "Linhares\ \-\ ES",
"55343839", "Patrocínio\ \-\ MG",
"55212638", "Maricá\ \-\ RJ",
"55833354", "Serra\ Branca\ \-\ PB",
"55553302", "Santa\ Maria\ \-\ RS",
"55222760", "Rio\ das\ Ostras\ \-\ RJ",
"55114886", "Itu\ \-\ SP",
"55493228", "Bocaina\ do\ Sul\ \-\ SC",
"55663571", "Colniza\ \-\ MT",
"55833461", "Santa\ Luzia\ \-\ PB",
"55313622", "Vespasiano\ \-\ MG",
"55114692", "Biritiba\-Mirim\ \-\ SP",
"55773201", "Vitória\ da\ Conquista\ \-\ BA",
"55373274", "Papagaios\ \-\ MG",
"55813604", "Surubim\ \-\ PE",
"55193674", "Casa\ Branca\ \-\ SP",
"55433662", "Florestópolis\ \-\ PR",
"55193451", "Limeira\ \-\ SP",
"55493337", "Jardinópolis\ \-\ SC",
"55313277", "Minas\ Gerais",
"55112317", "São\ Paulo\ \-\ SP",
"55463254", "Coronel\ Domingos\ Soares\ \-\ PR",
"55213839", "Rio\ de\ Janeiro\ \-\ RJ",
"55143212", "Bauru\ \-\ SP",
"55613612", "Cristalina\ \-\ GO",
"5598308", "São\ Luís\ \-\ MA",
"55342102", "Uberlândia\ \-\ MG",
"55483653", "Rio\ Fortuna\ \-\ SC",
"55774141", "Vitória\ da\ Conquista\ \-\ BA",
"55313385", "Minas\ Gerais",
"55833455", "Santana\ de\ Mangueira\ \-\ PB",
"55114029", "Salto\ \-\ SP",
"55863393", "Luzilândia\ \-\ PI",
"55833494", "Diamante\ \-\ PB",
"55353331", "São\ Lourenço\ \-\ MG",
"55793256", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55613503", "Planaltina\ \-\ GO",
"55913656", "Santa\ Bárbara\ do\ Pará\ \-\ PA",
"55483537", "Meleiro\ \-\ SC",
"55663386", "São\ José\ do\ Rio\ Claro\ \-\ MT",
"55733212", "Itabuna\ \-\ BA",
"55123843", "Ubatuba\ \-\ SP",
"55923324", "Presidente\ Figueiredo\ \-\ AM",
"55863133", "Teresina\ \-\ PI",
"55624141", "Goiânia\ \-\ GO",
"55613467", "Brasília\ \-\ DF",
"55543052", "Bento\ Gonçalves\ \-\ RS",
"55383228", "Coração\ de\ Jesus\ \-\ MG",
"55222564", "Trajano\ de\ Morais\ \-\ RJ",
"55623514", "Inhumas\ \-\ GO",
"55413656", "Colombo\ \-\ PR",
"55883447", "Limoeiro\ do\ Norte\ \-\ CE",
"55453421", "Toledo\ \-\ PR",
"55193773", "Campinas\ \-\ SP",
"55115704", "Itupeva\ \-\ SP",
"55343414", "Contagem\ \-\ MG",
"55643534", "Itumbiara\ \-\ GO",
"55313441", "Minas\ Gerais",
"55983653", "Santa\ Inês\ \-\ MA",
"55433306", "Londrina\ \-\ PR",
"55143711", "Avaré\ \-\ SP",
"55843298", "São\ Bento\ do\ Trairí\ \-\ RN",
"55553233", "São\ Sepé\ \-\ RS",
"55433176", "Rolândia\ \-\ PR",
"55283551", "Divino\ de\ São\ Lourenço\ \-\ ES",
"55623340", "São\ Patrício\ \-\ GO",
"55183284", "Rosana\ \-\ SP",
"55123104", "Aparecida\ \-\ SP",
"55543446", "Cotiporã\ \-\ RS",
"55753202", "Retirolândia\ \-\ BA",
"55353363", "Itamonte\ \-\ MG",
"55313879", "Belo\ Horizonte\ \-\ MG",
"55153247", "Votorantim\ \-\ SP",
"55274003", "Vitória\ \-\ ES",
"55473641", "Mafra\ \-\ SC",
"55793651", "Salgado\ \-\ SE",
"55333343", "Alto\ Jequitibá\ \-\ MG",
"55733031", "Itamaraju\ \-\ BA",
"55343328", "Campo\ Florido\ \-\ MG",
"55213851", "Nova\ Iguaçu\ \-\ RJ",
"55623362", "Porangatu\ \-\ GO",
"55193439", "Saltinho\ \-\ SP",
"55323353", "Dores\ de\ Campos\ \-\ MG",
"55913752", "Tailândia\ \-\ PA",
"55463545", "Nova\ Prata\ do\ Iguaçu\ \-\ PR",
"55883513", "Crato\ \-\ CE",
"55283539", "Itaoca\ \-\ ES",
"55843694", "Monte\ das\ Gameleiras\ \-\ RN",
"55553261", "Restinga\ Seca\ \-\ RS",
"55193512", "Campinas\ \-\ SP",
"55753276", "Ribeira\ do\ Pombal\ \-\ BA",
"55443438", "São\ Carlos\ do\ Ivaí\ \-\ PR",
"5522272", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55613388", "Planaltina\ \-\ DF",
"55843371", "Itaú\ \-\ RN",
"55553025", "Santa\ Maria\ \-\ RS",
"55163242", "Monte\ Alto\ \-\ SP",
"55963117", "Macapá\ \-\ AP",
"55123011", "Taubaté\ \-\ SP",
"55813673", "Catende\ \-\ PE",
"55184101", "Presidente\ Prudente\ \-\ SP",
"55163942", "Sertãozinho\ \-\ SP",
"55533241", "Bagé\ \-\ RS",
"55713054", "Camaçari\ \-\ BA",
"55113113", "São\ Paulo\ \-\ SP",
"55653352", "Nova\ Marilândia\ \-\ MT",
"55383624", "São\ Romão\ \-\ MG",
"55643593", "Itumbiara\ \-\ GO",
"55553255", "Jaguari\ \-\ RS",
"55193814", "Mogi\ Mirim\ \-\ SP",
"55443462", "Querência\ do\ Norte\ \-\ PR",
"55653492", "Ouro\ Branco\ \(Antiga\ Raposolândia\)\ \-\ MT",
"55333225", "Governador\ Valadares\ \-\ MG",
"55453559", "Itaipulândia\ \-\ PR",
"55313726", "Santana\ dos\ Montes\ \-\ MG",
"55533312", "Bagé\ \-\ RS",
"55513569", "Morro\ Reuter\ \-\ RS",
"55513650", "Barão\ do\ Triunfo\ \-\ RS",
"55312136", "Ipatinga\ \-\ MG",
"55513553", "Novo\ Hamburgo\ \-\ RS",
"55843661", "Natal\ \-\ RN",
"55163311", "Araraquara\ \-\ SP",
"55863194", "Teresina\ \-\ PI",
"55473422", "Joinville\ \-\ SC",
"55613574", "Brasília\ \-\ DF",
"55813363", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55112867", "São\ Paulo\ \-\ SP",
"55183941", "Espigão\ \-\ SP",
"55743685", "Mundo\ Novo\ \-\ BA",
"55443528", "Assis\ Chateaubriand\ \-\ PR",
"55513637", "Feliz\ \-\ RS",
"55683343", "Mâncio\ Lima\ \-\ AC",
"55433543", "Itambaracá\ \-\ PR",
"55193704", "Limeira\ \-\ SP",
"55123664", "Campos\ do\ Jordão\ \-\ SP",
"55373332", "São\ Francisco\ de\ Paula\ \-\ MG",
"55933543", "Rurópolis\ \-\ PA",
"55493624", "Romelândia\ \-\ SC",
"55663497", "Primavera\ do\ Leste\ \-\ MT",
"55423553", "Bituruna\ \-\ PR",
"55833433", "Coremas\ \-\ PB",
"55893566", "Redenção\ do\ Gurguéia\ \-\ PI",
"55493482", "Concórdia\ \-\ SC",
"55694003", "Porto\ Velho\ \-\ RO",
"55383723", "Inimutaba\ \-\ MG",
"55533284", "Pelotas\ \-\ RS",
"55183742", "Ilha\ Solteira\ \-\ SP",
"55553738", "Caiçara\ \-\ RS",
"55913265", "Ananindeua\ \-\ PA",
"55343851", "Carmo\ do\ Paranaíba\ \-\ MG",
"55423637", "Nova\ Laranjeiras\ \-\ PR",
"55623338", "Corumbá\ de\ Goiás\ \-\ GO",
"55183329", "Tarumã\ \-\ SP",
"55114680", "Santa\ Isabel\ \-\ SP",
"55213020", "Rio\ de\ Janeiro\ \-\ RJ",
"55513123", "Porto\ Alegre\ \-\ RS",
"55123152", "Lorena\ \-\ SP",
"55543568", "Ponte\ Preta\ \-\ RS",
"55753254", "Ipirá\ \-\ BA",
"55173453", "Cardoso\ \-\ SP",
"55513713", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55853329", "Aratuba\ \-\ CE",
"55993562", "Gonçalves\ Dias\ \-\ MA",
"55873855", "Buíque\ \-\ PE",
"55653631", "Cuiabá\ \-\ MT",
"55413978", "Antonina\ \-\ PR",
"55983362", "Icatu\ \-\ MA",
"55443582", "Guaiporã\ \-\ PR",
"55143377", "São\ Pedro\ do\ Turvo\ \-\ SP",
"55173272", "Tanabi\ \-\ SP",
"55663547", "Tapurah\ \-\ MT",
"55553523", "Padre\ Gonzales\ \-\ RS",
"55313312", "Belo\ Horizonte\ \-\ MG",
"5561334", "Brasília\ \-\ DF",
"55473488", "Blumenau\ \-\ SC",
"55513489", "Gravataí\ \-\ RS",
"55843358", "Rafael\ Fernandes\ \-\ RN",
"55143285", "Cabrália\ Paulista\ \-\ SP",
"55833261", "Belém\ \-\ PB",
"55193965", "Hortolândia\ \-\ SP",
"55114463", "Santo\ André\ \-\ SP",
"5511479", "Mogi\ das\ Cruzes\ \-\ SP",
"55773401", "Vitória\ da\ Conquista\ \-\ BA",
"55273369", "Vila\ Velha\ \-\ ES",
"55112771", "São\ Paulo\ \-\ SP",
"55123522", "Pindamonhangaba\ \-\ SP",
"55733285", "Potiraguá\ \-\ BA",
"55883654", "Mucambo\ \-\ CE",
"55493562", "Pinheiro\ Preto\ \-\ SC",
"55863269", "Beneditinos\ \-\ PI",
"55633428", "Araguanã\ \-\ TO",
"55883695", "Sobral\ \-\ CE",
"55313116", "Belo\ Horizonte\ \-\ MG",
"55863253", "Juazeiro\ do\ Piauí\ \-\ PI",
"55643443", "Catalão\ \-\ GO",
"55173044", "Bebedouro\ \-\ SP",
"55833255", "João\ Pessoa\ \-\ PB",
"55193837", "Jaguariúna\ \-\ SP",
"55413603", "Itaperuçu\ \-\ PR",
"55633538", "Aparecida\ do\ Rio\ Negro\ \-\ TO",
"55833294", "Itapororoca\ \-\ PB",
"55733539", "Itagi\ \-\ BA",
"55483030", "Florianópolis\ \-\ SC",
"55123432", "Taubaté\ \-\ SP",
"55983198", "São\ Luís\ \-\ MA",
"55753647", "Aratuípe\ \-\ BA",
"55473446", "Barra\ Velha\ \-\ SC",
"55192532", "Piracicaba\ \-\ SP",
"55313742", "Ouro\ Branco\ \-\ MG",
"55313329", "Minas\ Gerais",
"55513614", "Maratá\ \-\ RS",
"55493538", "Ibicaré\ \-\ SC",
"55133872", "Sete\ Barras\ \-\ SP",
"55373287", "Perdigão\ \-\ MG",
"55733667", "Itamaraju\ \-\ BA",
"55643615", "Quirinópolis\ \-\ GO",
"55112518", "São\ Paulo\ \-\ SP",
"55313840", "Minas\ Gerais",
"55114775", "Itapecerica\ da\ Serra\ \-\ SP",
"55142104", "Jaú\ \-\ SP",
"55543532", "São\ João\ da\ Urtiga\ \-\ RS",
"55732011", "Teixeira\ de\ Freitas\ \-\ BA",
"55163607", "Ribeirão\ Preto\ \-\ SP",
"55313241", "Belo\ Horizonte\ \-\ MG",
"55673291", "Coxim\ \-\ MS",
"55893448", "Bocaina\ \-\ PI",
"55943301", "Maracajá\ \-\ PA",
"55383562", "Brasilândia\ de\ Minas\ \-\ MG",
"55553433", "Itaqui\ \-\ RS",
"55443634", "São\ Jorge\ do\ Patrocínio\ \-\ PR",
"55753024", "Feira\ de\ Santana\ \-\ BA",
"55993538", "Açailândia\ \-\ MA",
"55123519", "São\ José\ dos\ Campos\ \-\ SP",
"55513055", "Guaíba\ \-\ RS",
"55814009", "Recife\ \-\ PE",
"55143667", "Itaju\ \-\ SP",
"55983672", "Bom\ Jardim\ \-\ MA",
"55643054", "Rio\ Verde\ \-\ GO",
"55843220", "Natal\ \-\ RN",
"55513218", "Rio\ Grande\ do\ Sul",
"55953626", "Boa\ Vista\ \-\ RR",
"55663558", "Santa\ Terezinha\ \-\ MT",
"55313862", "Alvorada\ de\ Minas\ \-\ MG",
"55414062", "Curitiba\ \-\ PR",
"55673541", "Bataguassu\ \-\ MS",
"55693434", "Santa\ Luzia\ D\'Oeste\ \-\ RO",
"55554052", "Santa\ Maria\ \-\ RS",
"55673016", "Dourados\ \-\ MS",
"55833376", "Barra\ de\ Santa\ Rosa\ \-\ PB",
"55823554", "Igreja\ Nova\ \-\ AL",
"55623379", "Minaçu\ \-\ GO",
"5561303", "Brasília\ \-\ DF",
"55753402", "Entre\ Rios\ \-\ BA",
"55733551", "Aurelino\ Leal\ \-\ BA",
"55183622", "Araçatuba\ \-\ SP",
"55273335", "Vitória\ \-\ ES",
"55133036", "Santos\ \-\ SP",
"55212709", "Niterói\ \-\ RJ",
"55193656", "Mococa\ \-\ SP",
"55483086", "Palhoça\ \-\ SC",
"55333535", "Pavão\ \-\ MG",
"55833544", "Marizópolis\ \-\ PB",
"55674001", "Campo\ Grande\ \-\ MS",
"55333324", "Vargem\ Alegre\ \-\ MG",
"55473052", "Indaial\ \-\ SC",
"55153271", "Itapetininga\ \-\ SP",
"55323372", "São\ João\ Del\ Rei\ \-\ MG",
"55553354", "Porto\ Xavier\ \-\ RS",
"55833302", "Camalaú\ \-\ PB",
"55313760", "Minas\ Gerais",
"55873833", "Venturosa\ \-\ PE",
"55222622", "Arraial\ do\ Cabo\ \-\ RJ",
"55115021", "São\ Paulo\ \-\ SP",
"55443238", "Doutor\ Camargo\ \-\ PR",
"55413083", "Curitiba\ \-\ PR",
"55813652", "Camutanga\ \-\ PE",
"55833310", "Campina\ Grande\ \-\ PB",
"55114605", "Caieiras\ \-\ SP",
"55543288", "Gramado\ \-\ RS",
"55633540", "Monte\ do\ Carmo\ \-\ TO",
"55112334", "São\ Paulo\ \-\ SP",
"55413391", "Campo\ Largo\ \-\ PR",
"55473222", "Blumenau\ \-\ SC",
"55323293", "Liberdade\ \-\ MG",
"55643628", "Ouroana\ \-\ GO",
"55273720", "Itarana\ \-\ ES",
"5594", "Pará",
"55453039", "Cascavel\ \-\ PR",
"55713682", "Bom\ Despacho\ \-\ BA",
"55913131", "Belém\ \-\ PA",
"55743629", "Barro\ Alto\ \-\ BA",
"55855672", "São\ Paulo\ \-\ SP",
"55173334", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55413674", "Tijucas\ do\ Sul\ \-\ PR",
"55513033", "Esteio\ \-\ RS",
"55943013", "Parauapebas\ \-\ PA",
"55173525", "Catanduva\ \-\ SP",
"55473367", "Balneário\ Camboriú\ \-\ SC",
"55923572", "São\ Sebastião\ do\ Uatumã\ \-\ AM",
"55673668", "Paranaíba\ \-\ MS",
"55413465", "Morretes\ \-\ PR",
"55183441", "Araçatuba\ \-\ SP",
"55124715", "Alumínio\ \-\ SP",
"55333425", "Braúnas\ \-\ MG",
"55493643", "São\ José\ do\ Cedro\ \-\ SC",
"55933524", "Santarém\ \-\ PA",
"55484141", "Florianópolis\ \-\ SC",
"55463902", "Pato\ Branco\ \-\ PR",
"55114165", "Itapecerica\ da\ Serra\ \-\ SP",
"55753658", "Fátima\ \-\ BA",
"55383744", "Jequitaí\ \-\ MG",
"55433154", "Cambé\ \-\ PR",
"55623537", "Aparecida\ de\ Goiânia\ \-\ GO",
"55753545", "Milagres\ \-\ BA",
"55183277", "Sandovalina\ \-\ SP",
"55353299", "Alfenas\ \-\ MG",
"55313838", "Santa\ Maria\ de\ Itabira\ \-\ MG",
"5577308", "Vitória\ da\ Conquista\ \-\ BA",
"55433524", "Cornélio\ Procópio\ \-\ PR",
"55984141", "São\ Luís\ \-\ MA",
"55993643", "Barra\ do\ Corda\ \-\ MA",
"55193585", "Porto\ Ferreira\ \-\ SP",
"55114431", "Jundiaí\ \-\ SP",
"55643517", "Itumbiara\ \-\ GO",
"55943327", "Núcleo\ Carajás\ \-\ PA",
"55693524", "Governador\ Jorge\ Teixeira\ \-\ RO",
"55193478", "Americana\ \-\ SP",
"55623550", "Aragoiânia\ \-\ GO",
"55123975", "Santa\ Branca\ \-\ SP",
"55192111", "Rio\ Claro\ \-\ SP",
"55893457", "Jaicós\ \-\ PI",
"55793274", "Rosário\ do\ Catete\ \-\ SE",
"5544", "Paraná",
"55413131", "Curitiba\ \-\ PR",
"55873784", "São\ João\ \-\ PE",
"55833370", "Caiçara\ \-\ PB",
"55343332", "Uberaba\ \-\ MG",
"55383546", "São\ Gonçalo\ do\ Rio\ Preto\ \-\ MG",
"55943422", "Piçarras\ \-\ PA",
"55113152", "São\ Paulo\ \-\ SP",
"55613401", "Taguatinga\ \-\ DF",
"55653313", "Cuiabá\ \-\ MT",
"55314003", "Belo\ Horizonte\ \-\ MG",
"55473158", "Itajaí\ \-\ SC",
"55883552", "Mauriti\ \-\ CE",
"55323312", "Juiz\ de\ Fora\ \-\ MG",
"55543733", "Caxias\ do\ Sul\ \-\ RS",
"55663022", "Rondonópolis\ \-\ MT",
"55873793", "Calçado\ \-\ PE",
"55352101", "Poços\ de\ Caldas\ \-\ MG",
"55633475", "Esperantina\ \-\ TO",
"55423278", "Imbaú\ \-\ PR",
"55193887", "Hortolândia\ \-\ SP",
"55114035", "Bragança\ Paulista\ \-\ SP",
"55324101", "Barbacena\ \-\ MG",
"55383759", "Lassance\ \-\ MG",
"55493664", "Maravilha\ \-\ SC",
"55313543", "Raposos\ \-\ MG",
"55193123", "Campinas\ \-\ SP",
"55173827", "Potirendaba\ \-\ SP",
"55323284", "Belmiro\ Braga\ \-\ MG",
"55443568", "Mamborê\ \-\ PR",
"55983388", "Peri\ Mirim\ \-\ MA",
"55713264", "Salvador\ \-\ BA",
"55112827", "São\ Paulo\ \-\ SP",
"55653027", "Cuiabá\ \-\ MT",
"55833316", "Riachão\ do\ Bacamarte\ \-\ PB",
"55443422", "Paranavaí\ \-\ PR",
"55333021", "Governador\ Valadares\ \-\ MG",
"55443684", "Guaporema\ \-\ PR",
"55913803", "Bonito\ \-\ PA",
"55743672", "Morro\ do\ Chapéu\ \-\ BA",
"55413061", "Curitiba\ \-\ PR",
"5516396", "Ribeirão\ Preto\ \-\ SP",
"55513704", "Monte\ Alverne\ \-\ RS",
"55143589", "Reginópolis\ \-\ SP",
"55333265", "Santa\ Rita\ do\ Itueto\ \-\ MG",
"55313766", "Minas\ Gerais",
"55513529", "Sapiranga\ \-\ RS",
"55793214", "Aracaju\ \-\ SE",
"55183917", "Presidente\ Prudente\ \-\ SP",
"55113432", "Carapicuíba\ \-\ SP",
"55513439", "Cachoeirinha\ \-\ RS",
"5511354", "São\ Paulo\ \-\ SP",
"55713291", "Salvador\ \-\ BA",
"55812101", "Recife\ \-\ PE",
"55443532", "Moreira\ Sales\ \-\ PR",
"55163347", "Cambaratiba\ \-\ SP",
"55273726", "Pancas\ \-\ ES",
"55553921", "Santa\ Maria\ \-\ RS",
"55533045", "Rio\ Grande\ \-\ RS",
"55483346", "São\ José\ \-\ SC",
"55493546", "Monte\ Carlo\ \-\ SC",
"553130", "Minas\ Gerais",
"55333251", "Santana\ do\ Paraíso\ \-\ MG",
"55653257", "Rio\ Branco\ \-\ MT",
"55323742", "Fervedouro\ \-\ MG",
"55854003", "Fortaleza\ \-\ CE",
"55183217", "Presidente\ Prudente\ \-\ SP",
"55843087", "Natal\ \-\ RN",
"55653566", "Juína\ \-\ MT",
"55893436", "Alegrete\ do\ Piauí\ \-\ PI",
"55833559", "Bom\ Jesus\ \-\ PB",
"55633374", "Figueirópolis\ \-\ TO",
"55133227", "Santos\ \-\ SP",
"55153342", "Sorocaba\ \-\ SP",
"55513603", "Rainha\ do\ Mar\ \-\ RS",
"55353697", "Poços\ de\ Caldas\ \-\ MG",
"55323241", "Juiz\ de\ Fora\ \-\ MG",
"55633691", "Rio\ da\ Conceição\ \-\ TO",
"55343456", "União\ de\ Minas\ \-\ MG",
"55923512", "Borba\ \-\ AM",
"55353323", "São\ Vicente\ de\ Minas\ \-\ MG",
"55443641", "Terra\ Boa\ \-\ PR",
"55413614", "Araucária\ \-\ PR",
"55283518", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55313234", "Minas\ Gerais",
"55983346", "Bacabeira\ \-\ MA",
"55893492", "Campo\ Alegre\ do\ Fidalgo\ \-\ PI",
"55824009", "Maceió\ \-\ AL",
"55424062", "Ponta\ Grossa\ \-\ PR",
"55833642", "Santa\ Cecília\ \-\ PB",
"55433441", "Marumbi\ \-\ PR",
"55223066", "Nova\ Friburgo\ \-\ RJ",
"55353737", "São\ Pedro\ de\ Caldas\ \-\ MG",
"55433619", "Ibaiti\ \-\ PR",
"55133048", "São\ Vicente\ \-\ SP",
"55923364", "Caapiranga\ \-\ AM",
"55713632", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55913181", "Belém\ \-\ PA",
"55713378", "Lauro\ de\ Freitas\ \-\ BA",
"55693441", "Cacoal\ \-\ RO",
"55643491", "Ipameri\ \-\ GO",
"55543238", "Caxias\ do\ Sul\ \-\ RS",
"55513451", "Rio\ Grande\ do\ Sul",
"55213818", "Rio\ de\ Janeiro\ \-\ RJ",
"55114069", "Diadema\ \-\ SP",
"55213974", "Rio\ de\ Janeiro\ \-\ RJ",
"55133829", "Registro\ \-\ SP",
"55514062", "Porto\ Alegre\ \-\ RS",
"55833283", "Sapé\ \-\ PB",
"55313372", "Minas\ Gerais",
"55454052", "Foz\ do\ Iguaçu\ \-\ PR",
"55493232", "Bom\ Jardim\ da\ Serra\ \-\ SC",
"55114481", "Bragança\ Paulista\ \-\ SP",
"55372102", "Divinópolis\ \-\ MG",
"55193324", "Campinas\ \-\ SP",
"5553330", "Pelotas\ \-\ RS",
"55893480", "Socorro\ do\ Piauí\ \-\ PI",
"5592365", "Manaus\ \-\ AM",
"55513773", "Poço\ das\ Antas\ \-\ RS",
"55633232", "Palmas\ \-\ TO",
"55623587", "Aparecida\ de\ Goiânia\ \-\ GO",
"55833531", "Cajazeiras\ \-\ PB",
"55163821", "Orlândia\ \-\ SP",
"55313888", "Minas\ Gerais",
"55213274", "Rio\ de\ Janeiro\ \-\ RJ",
"55823299", "Atalaia\ \-\ AL",
"55173801", "Riolândia\ \-\ SP",
"55443246", "Maringá\ \-\ PR",
"55833421", "Patos\ \-\ PB",
"55273277", "Timbuí\ \-\ ES",
"55313662", "Pedro\ Leopoldo\ \-\ MG",
"55383731", "Várzea\ da\ Palma\ \-\ MG",
"55923131", "Manaus\ \-\ AM",
"55753249", "Tanquinho\ \-\ BA",
"55243372", "Paraty\ \-\ RJ",
"55143406", "Garça\ \-\ SP",
"55353554", "São\ Pedro\ da\ União\ \-\ MG",
"55383843", "Novorizonte\ \-\ MG",
"55433622", "Jaboti\ \-\ PR",
"55273385", "Serra\ \-\ ES",
"55673243", "Dois\ Irmãos\ do\ Buriti\ \-\ MS",
"55483467", "Içara\ \-\ SC",
"55183822", "Dracena\ \-\ SP",
"5554", "Rio\ Grande\ do\ Sul",
"55733269", "Ilhéus\ \-\ BA",
"55173341", "Colina\ \-\ SP",
"55853306", "Fortaleza\ \-\ CE",
"55813737", "Bonito\ \-\ PE",
"55193856", "Vinhedo\ \-\ SP",
"55163358", "Araraquara\ \-\ SP",
"55863285", "Elesbão\ Veloso\ \-\ PI",
"55112341", "São\ Paulo\ \-\ SP",
"55283155", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55114715", "Alumínio\ \-\ SP",
"55413033", "Pinhais\ \-\ PR",
"55643675", "Palminópolis\ \-\ GO",
"55112229", "Guarulhos\ \-\ SP",
"55193797", "Campinas\ \-\ SP",
"55143472", "Ubirajara\ \-\ SP",
"55513674", "Tavares\ \-\ RS",
"55873883", "Parnamirim\ \-\ PE",
"55543327", "Passo\ Fundo\ \-\ RS",
"55673682", "Camapuã\ \-\ MS",
"55472033", "Balneário\ Camboriú\ \-\ SC",
"55153573", "Barão\ de\ Antonina\ \-\ SP",
"55283525", "Jaciguá\ \-\ ES",
"55443288", "Sarandi\ \-\ PR",
"55114444", "Franco\ da\ Rocha\ \-\ SP",
"55163209", "Jaboticabal\ \-\ SP",
"55313846", "Coronel\ Fabriciano\ \-\ MG",
"55173485", "Valentim\ Gentil\ \-\ SP",
"55133201", "Santos\ \-\ SP",
"55383232", "Cristália\ \-\ MG",
"55883411", "Russas\ \-\ CE",
"55853372", "São\ Gonçalo\ do\ Amarante\ \-\ CE",
"55883649", "Meruoca\ \-\ CE",
"55114805", "Jundiaí\ \-\ SP",
"55753321", "Feira\ de\ Santana\ \-\ BA",
"55343818", "Patos\ de\ Minas\ \-\ MG",
"55143269", "Lençóis\ Paulista\ \-\ SP",
"55513465", "Canoas\ \-\ RS",
"55873966", "Exu\ \-\ PE",
"55613669", "Valparaíso\ de\ Goiás\ \-\ GO",
"55433122", "Apucarana\ \-\ PR",
"55543333", "Chapada\ \-\ RS",
"55773483", "Santa\ Maria\ da\ Vitória\ \-\ BA",
"55933552", "Placas\ \-\ PA",
"55463246", "Saudade\ do\ Iguaçu\ \-\ PR",
"55613620", "Luziânia\ \-\ GO",
"55423542", "Mallet\ \-\ PR",
"55112536", "São\ Paulo\ \-\ SP",
"55313162", "Betim\ \-\ MG",
"55114009", "São\ Paulo\ \-\ SP",
"55653225", "Porto\ Esperidião\ \-\ MT",
"55713273", "Salvador\ \-\ BA",
"55423304", "Guarapuava\ \-\ PR",
"55153284", "Cerquilho\ \-\ SP",
"55223533", "Vila\ Velha\ \-\ ES",
"55653925", "Cuiabá\ \-\ MT",
"55713452", "Salvador\ \-\ BA",
"55533015", "Pelotas\ \-\ RS",
"55112592", "São\ Paulo\ \-\ SP",
"55193448", "Ibitiruna\ \-\ SP",
"55333436", "Rio\ Vermelho\ \-\ MG",
"55513631", "Escadinhas\ \-\ RS",
"55383084", "Montes\ Claros\ \-\ MG",
"55112861", "São\ Paulo\ \-\ SP",
"55924002", "Manaus\ \-\ AM",
"55224104", "Macaé\ \-\ RJ",
"55513542", "Taquara\ \-\ RS",
"55843412", "Currais\ Novos\ \-\ RN",
"55283548", "Irupi\ \-\ ES",
"55623483", "Sítio\ D\'Abadia\ \-\ GO",
"55353624", "Delfim\ Moreira\ \-\ MG",
"55923542", "Maués\ \-\ AM",
"55433552", "Nova\ Fátima\ \-\ PR",
"55813723", "Caruaru\ \-\ PE",
"55813915", "Aripibu\ \-\ PE",
"55833388", "Seridó\ \-\ PB",
"55423631", "Guarapuava\ \-\ PR",
"55633363", "Porto\ Nacional\ \-\ TO",
"55163253", "Taquaritinga\ \-\ SP",
"55543210", "Passo\ Fundo\ \-\ RS",
"55323729", "Muriaé\ \-\ MG",
"55183695", "Planalto\ \-\ SP",
"55213830", "Rio\ de\ Janeiro\ \-\ RJ",
"55633359", "São\ Valério\ da\ Natividade\ \-\ TO",
"55193486", "Charqueada\ \-\ SP",
"55183654", "Penápolis\ \-\ SP",
"55153241", "Ibiúna\ \-\ SP",
"55323342", "Santa\ Rita\ de\ Ibitipoca\ \-\ MG",
"5562331", "Anápolis\ \-\ GO",
"55543902", "Passo\ Fundo\ \-\ RS",
"55823522", "Arapiraca\ \-\ AL",
"55653343", "Arenápolis\ \-\ MT",
"55623921", "Goiânia\ \-\ GO",
"55213857", "São\ Gonçalo\ \-\ RJ",
"55643404", "Itumbiara\ \-\ GO",
"55513405", "Rio\ Grande\ do\ Sul",
"55753446", "Sátiro\ Dias\ \-\ BA",
"55313398", "Minas\ Gerais",
"55473647", "Mafra\ \-\ SC",
"55273326", "Vila\ Velha\ \-\ ES",
"55873771", "Bom\ Conselho\ \-\ PE",
"55793281", "Laranjeiras\ \-\ SE",
"55133261", "Santos\ \-\ SP",
"55313090", "Belo\ Horizonte\ \-\ MG",
"5511418", "Carapicuíba\ \-\ SP",
"55163472", "Araraquara\ \-\ SP",
"55493363", "Bom\ Jesus\ do\ Oeste\ \-\ SC",
"55163953", "Pontal\ \-\ SP",
"5551352", "Rio\ Grande\ do\ Sul",
"55543701", "Bento\ Gonçalves\ \-\ RS",
"55843285", "Várzea\ \-\ RN",
"55553267", "Ivorá\ \-\ RS",
"55813624", "Surubim\ \-\ PE",
"55813482", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55843429", "Jucurutu\ \-\ RN",
"55773221", "Itapetinga\ \-\ BA",
"55653055", "Cuiabá\ \-\ MT",
"55553556", "Redentora\ \-\ RS",
"55873272", "Parnamirim\ \-\ RN",
"55222654", "Sampaio\ Correia\ \-\ RJ",
"55843377", "Portalegre\ \-\ RN",
"55833346", "Barra\ de\ Santana\ \-\ PB",
"55383673", "Guarda\-Mor\ \-\ MG",
"55333526", "Ataléia\ \-\ MG",
"55112894", "São\ Paulo\ \-\ SP",
"55493908", "Fraiburgo\ \-\ SC",
"55553322", "Cruz\ Alta\ \-\ RS",
"55623349", "Hidrolina\ \-\ GO",
"55533247", "Bagé\ \-\ RS",
"55152105", "Sorocaba\ \-\ SP",
"55543276", "Protásio\ Alves\ \-\ RS",
"55173426", "Votuporanga\ \-\ SP",
"55333352", "São\ Pedro\ dos\ Ferros\ \-\ MG",
"55613433", "Brasília\ \-\ DF",
"55163406", "Franca\ \-\ SP",
"55853366", "Fortaleza\ \-\ CE",
"55733209", "Posto\ da\ Mata\ \-\ BA",
"55313870", "Minas\ Gerais",
"55713204", "Salvador\ \-\ BA",
"55993604", "São\ Pedro\ dos\ Crentes\ \-\ MA",
"55623626", "Goiânia\ \-\ GO",
"55483283", "Palhoça\ \-\ SC",
"55242223", "Petrópolis\ \-\ RJ",
"55153646", "Buri\ \-\ SP",
"55222735", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55193457", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55113408", "Itatiba\ \-\ SP",
"55533028", "Pelotas\ \-\ RS",
"55112784", "São\ Paulo\ \-\ SP",
"5517322", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55173311", "Catanduva\ \-\ SP",
"55473402", "Joinville\ \-\ SC",
"55893585", "Coronel\ José\ Dias\ \-\ PI",
"55673213", "Campo\ Grande\ \-\ MS",
"55513764", "Cruzeiro\ do\ Sul\ \-\ RS",
"55383813", "Mato\ Verde\ \-\ MG",
"55823275", "Campo\ Alegre\ \-\ AL",
"55913286", "Ananindeua\ \-\ PA",
"55483531", "Morro\ Grande\ \-\ SC",
"55213263", "Rio\ de\ Janeiro\ \-\ RJ",
"55913859", "Salinópolis\ \-\ PA",
"55833629", "São\ Miguel\ de\ Taipu\ \-\ PB",
"5521261", "Niterói\ \-\ RJ",
"55483642", "Gravatal\ \-\ SC",
"55212649", "Cachoeiras\ de\ Macacu\ \-\ RJ",
"55343848", "Romaria\ \-\ MG",
"55613461", "Ceilândia\ \-\ DF",
"55453379", "Toledo\ \-\ PR",
"55242444", "Barra\ do\ Piraí\ \-\ RJ",
"55883619", "Forquilha\ \-\ CE",
"55883441", "Quixeramobim\ \-\ CE",
"55122127", "Jacareí\ \-\ SP",
"55773626", "Wanderley\ \-\ BA",
"55753677", "Valença\ \-\ BA",
"55313447", "Belo\ Horizonte\ \-\ MG",
"55613395", "Santa\ Maria\ \-\ DF",
"55543394", "Santo\ Antônio\ do\ Palma\ \-\ RS",
"55613354", "Brasília\ \-\ DF",
"55133842", "Ilha\ Comprida\ \-\ SP",
"55283557", "Apiacá\ \-\ ES",
"55543355", "Ibiraiaras\ \-\ RS",
"55963422", "Tartarugalzinho\ \-\ AP",
"55513663", "Osório\ \-\ RS",
"55113652", "Osasco\ \-\ SP",
"55453550", "São\ Jorge\ \-\ PR",
"55513560", "Araricá\ \-\ RS",
"55793648", "Pedrinhas\ \-\ SE",
"55513659", "Rio\ Grande\ do\ Sul",
"55323032", "Juiz\ de\ Fora\ \-\ MG",
"55115486", "São\ Paulo\ \-\ SP",
"55693411", "Ji\-Paraná\ \-\ RO",
"55323573", "Piraúba\ \-\ MG",
"55643699", "Buriti\ de\ Goiás\ \-\ GO",
"55173833", "Estrela\ D\'Oeste\ \-\ SP",
"55133302", "Praia\ Grande\ \-\ SP",
"55923663", "Manaus\ \-\ AM",
"55443270", "Uniflor\ \-\ PR",
"55532125", "Rio\ Grande\ \-\ RS",
"55513236", "Rio\ Grande\ do\ Sul",
"55543361", "Sarandi\ \-\ RS",
"55112683", "São\ Paulo\ \-\ SP",
"55833612", "João\ Pessoa\ \-\ PB",
"55673038", "Dourados\ \-\ MS",
"55423659", "Samambaia\ \-\ PR",
"55423560", "Fluviópolis\ \-\ PR",
"55533258", "Santana\ da\ Boa\ Vista\ \-\ RS",
"55423663", "Palmeirinha\ \-\ PR",
"55863087", "Teresina\ \-\ PI",
"55953537", "São\ Luiz\ \-\ RR",
"55193623", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55423236", "Ponta\ Grossa\ \-\ PR",
"55463532", "Quedas\ do\ Iguaçu\ \-\ PR",
"55833467", "São\ José\ do\ Sabugi\ \-\ PB",
"55173242", "Mirassol\ \-\ SP",
"55134004", "Santos\ \-\ SP",
"55663577", "Canabrava\ do\ Norte\ \-\ MT",
"55473545", "Pouso\ Redondo\ \-\ SC",
"5561337", "Ceilândia\ \-\ DF",
"55343263", "Capinópolis\ \-\ MG",
"55343259", "Uberlândia\ \-\ MG",
"55423027", "Ponta\ Grossa\ \-\ PR",
"55643645", "Acreúna\ \-\ GO",
"55543449", "Bento\ Gonçalves\ \-\ RS",
"55543611", "André\ da\ Rocha\ \-\ RS",
"55213630", "Magé\ \-\ RJ",
"55193492", "Capivari\ \-\ SP",
"55833362", "Areia\ \-\ PB",
"55813519", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55313712", "Matozinhos\ \-\ MG",
"55483025", "Florianópolis\ \-\ SC",
"55173548", "Marapoama\ \-\ SP",
"55623523", "Goiânia\ \-\ GO",
"55693654", "São\ Domingos\ \-\ RO",
"55153543", "Capão\ Bonito\ \-\ SP",
"55123897", "Caraguatatuba\ \-\ SP",
"55114474", "Santo\ André\ \-\ SP",
"55313876", "Urucânia\ \-\ MG",
"55213118", "Rio\ de\ Janeiro\ \-\ RJ",
"55473416", "Joinville\ \-\ SC",
"55853342", "Caucaia\ \-\ CE",
"55114665", "Embu\-Guaçu\ \-\ SP",
"55353522", "Passos\ \-\ MG",
"55943333", "Itupiranga\ \-\ PA",
"55513313", "Nova\ Santa\ Rita\ \-\ RS",
"55343423", "Frutal\ \-\ MG",
"55553401", "Uruguaiana\ \-\ RS",
"55873031", "Petrolina\ \-\ PE",
"55834064", "Campina\ Grande\ \-\ PB",
"55423644", "Santa\ Maria\ do\ Oeste\ \-\ PR",
"55613483", "Sobradinho\ \-\ DF",
"55283536", "Anchieta\ \-\ ES",
"55753279", "Paripiranga\ \-\ BA",
"55773620", "Serra\ do\ Ramalho\ \-\ BA",
"55323366", "Oliveira\ Fortes\ \-\ MG",
"55313911", "Contagem\ \-\ MG",
"55653529", "Santa\ Rita\ do\ Trivelato\ \-\ MT",
"55823215", "Maceió\ \-\ AL",
"55743559", "Pindobaçu\ \-\ BA",
"55212753", "São\ João\ de\ Meriti\ \-\ RJ",
"55513598", "Campo\ Bom\ \-\ RS",
"55673452", "Rio\ Brilhante\ \-\ MS",
"55173101", "Uchoa\ \-\ SP",
"55863347", "Batalha\ \-\ PI",
"55212769", "Nova\ Iguaçu\ \-\ RJ",
"55313211", "Minas\ Gerais",
"5511439", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55843235", "Natal\ \-\ RN",
"55273753", "Vila\ Pavão\ \-\ ES",
"55173694", "Dirce\ Reis\ \-\ SP",
"55112655", "São\ Paulo\ \-\ SP",
"55273769", "Jaguaré\ \-\ ES",
"55643558", "Itumbiara\ \-\ GO",
"55343244", "Uberlândia\ \-\ MG",
"55433015", "Rolândia\ \-\ PR",
"55753462", "Itapicuru\ \-\ BA",
"55513681", "Cidreira\ \-\ RS",
"55273015", "Vitória\ \-\ ES",
"5546", "Paraná",
"55513930", "Porto\ Alegre\ \-\ RS",
"55813522", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55313342", "Belo\ Horizonte\ \-\ MG",
"5561331", "Brasília\ \-\ DF",
"55313729", "Minas\ Gerais",
"55513566", "São\ Leopoldo\ \-\ RS",
"5584320", "Natal\ \-\ RN",
"55663517", "Sinop\ \-\ MT",
"55313504", "Belo\ Horizonte\ \-\ MG",
"55222552", "Santa\ Rita\ da\ Floresta\ \-\ RJ",
"55453267", "Vera\ Cruz\ do\ Oeste\ \-\ PR",
"55923681", "Manaus\ \-\ AM",
"55173661", "Rubinéia\ \-\ SP",
"55513743", "Candelária\ \-\ RS",
"55543383", "Espumoso\ \-\ RS",
"55833198", "João\ Pessoa\ \-\ PB",
"55773433", "Boa\ Nova\ \-\ BA",
"55112661", "São\ Paulo\ \-\ SP",
"55453322", "Cascavel\ \-\ PR",
"55643997", "Itumbiara\ \-\ GO",
"55443276", "Maringá\ \-\ PR",
"55623609", "Goiânia\ \-\ GO",
"55813468", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55753438", "São\ Félix\ \-\ BA",
"55643413", "Morrinhos\ \-\ GO",
"55242463", "Engenheiro\ Paulo\ de\ Frontin\ \-\ RJ",
"55443902", "Paranavaí\ \-\ PR",
"55314133", "Belo\ Horizonte\ \-\ MG",
"55483255", "Imbituba\ \-\ SC",
"55893553", "Júlio\ Borges\ \-\ PI",
"55433471", "Jacutinga\ \-\ PR",
"55823624", "Pão\ de\ Açúcar\ \-\ AL",
"55733621", "Dário\ Meira\ \-\ BA",
"55463262", "Palmas\ \-\ PR",
"55353432", "Córrego\ do\ Bom\ Jesus\ \-\ MG",
"55893569", "Santa\ Filomena\ \-\ PI",
"55183552", "Pracinha\ \-\ SP",
"55823482", "Arapiraca\ \-\ AL",
"55193352", "Araras\ \-\ SP",
"5596", "Amapá",
"55114651", "Arujá\ \-\ SP",
"55693471", "Presidente\ Médici\ \-\ RO",
"55353824", "Ingaí\ \-\ MG",
"55343281", "Tupaciguara\ \-\ MG",
"55413405", "São\ José\ dos\ Pinhais\ \-\ PR",
"55713040", "Camaçari\ \-\ BA",
"55473307", "Jaraguá\ do\ Sul\ \-\ SC",
"55773461", "Bom\ Jesus\ da\ Serra\ \-\ BA",
"55843269", "Riachuelo\ \-\ RN",
"55114403", "Itu\ \-\ SP",
"55993576", "Matões\ \-\ MA",
"55483544", "Morro\ Grande\ \-\ SC",
"55933597", "Tabocal\ \-\ PA",
"55472103", "Itajaí\ \-\ SC",
"55843253", "Bom\ Jesus\ \-\ RN",
"55633344", "Carrasco\ Bonito\ \-\ TO",
"55273735", "Afonso\ Cláudio\ \-\ ES",
"55143226", "Bauru\ \-\ SP",
"55873929", "Serra\ Talhada\ \-\ PE",
"55183649", "Birigui\ \-\ SP",
"55613626", "Santo\ Antônio\ do\ Descoberto\ \-\ GO",
"55153372", "Itapetininga\ \-\ SP",
"55173633", "Santa\ Albertina\ \-\ SP",
"55913764", "São\ Sebastião\ da\ Boa\ Vista\ \-\ PA",
"55323271", "Bicas\ \-\ MG",
"55833201", "Campina\ Grande\ \-\ PB",
"55553379", "Condor\ \-\ RS",
"55513114", "Guaíba\ \-\ RS",
"55483018", "Florianópolis\ \-\ SC",
"55443355", "Maringá\ \-\ PR",
"55193187", "Santa\ Maria\ da\ Serra\ \-\ SP",
"55624052", "Goiânia\ \-\ GO",
"55653364", "Várzea\ Grande\ \-\ MT",
"55173557", "Sales\ \-\ SP",
"55493344", "São\ Lourenço\ do\ Oeste\ \-\ SC",
"55843472", "Jardim\ do\ Seridó\ \-\ RN",
"55173266", "Cedral\ \-\ SP",
"55112883", "Mogi\ das\ Cruzes\ \-\ SP",
"55223308", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55623089", "Goiânia\ \-\ GO",
"55443043", "Paiçandu\ \-\ PR",
"55943355", "Marabá\ \-\ PA",
"55373521", "Bom\ Despacho\ \-\ MG",
"55623461", "Pires\ do\ Rio\ \-\ GO",
"55484004", "Florianópolis\ \-\ SC",
"55343836", "São\ João\ da\ Serra\ Negra\ \-\ MG",
"55114639", "Poá\ \-\ SP",
"55893425", "Sussuapara\ \-\ PI",
"55643547", "Indiara\ \-\ GO",
"55993613", "Grajaú\ \-\ MA",
"55273258", "João\ Neiva\ \-\ ES",
"55623354", "Niquelândia\ \-\ GO",
"55654062", "Cuiabá\ \-\ MT",
"55883434", "Ererê\ \-\ CE",
"55333724", "Divisópolis\ \-\ MG",
"55213555", "Rio\ de\ Janeiro\ \-\ RJ",
"55242431", "Piraí\ \-\ RJ",
"55323447", "Leopoldina\ \-\ MG",
"55983302", "São\ Luís\ \-\ MA",
"55223012", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55114256", "Suzano\ \-\ SP",
"55553754", "Pinhal\ \-\ RS",
"55313573", "Rio\ Manso\ \-\ MG",
"55633381", "Conceição\ do\ Tocantins\ \-\ TO",
"55823337", "Maceió\ \-\ AL",
"55623494", "Cavalcante\ \-\ GO",
"55123652", "Caçapava\ \-\ SP",
"55623455", "Povoado\ de\ São\ Jorge\ \-\ GO",
"55433258", "Ibiporã\ \-\ PR",
"55883524", "Aiuaba\ \-\ CE",
"55163667", "Cajuru\ \-\ SP",
"55933735", "Monte\ Dourado\ \-\ PA",
"55373431", "Bambuí\ \-\ MG",
"55383613", "Itacarambi\ \-\ MG",
"55313096", "Ipatinga\ \-\ MG",
"55973321", "Barcelos\ \-\ AM",
"55893535", "Manoel\ Emídio\ \-\ PI",
"5571210", "Salvador\ \-\ BA",
"55743642", "Irecê\ \-\ BA",
"55114026", "Itu\ \-\ SP",
"55793263", "Capela\ \-\ SE",
"55317", "Minas\ Gerais",
"55222785", "Cardoso\ Moreira\ \-\ RJ",
"55473249", "Itajaí\ \-\ SC",
"55793259", "Aracaju\ \-\ SE",
"55163412", "São\ Carlos\ \-\ SP",
"55153293", "Sorocaba\ \-\ SP",
"55413292", "Campo\ Largo\ \-\ PR",
"55773455", "Caculé\ \-\ BA",
"55113554", "São\ Paulo\ \-\ SP",
"55512117", "Porto\ Alegre\ \-\ RS",
"55493445", "Abelardo\ Luz\ \-\ SC",
"55333623", "Fronteira\ dos\ Vales\ \-\ MG",
"55413659", "Tunas\ \-\ PR",
"55413663", "Colombo\ \-\ PR",
"55113595", "São\ Paulo\ \-\ SP",
"55743531", "Curaçá\ \-\ BA",
"55773494", "Tremedal\ \-\ BA",
"55833048", "João\ Pessoa\ \-\ PB",
"55493804", "Lages\ \-\ SC",
"55443361", "Umuarama\ \-\ PR",
"55653391", "Cuiabá\ \-\ MT",
"55553537", "Horizontina\ \-\ RS",
"552133", "Rio\ de\ Janeiro\ \-\ RJ",
"55713038", "Salvador\ \-\ BA",
"55833427", "Catingueira\ \-\ PB",
"5575", "Bahia",
"55213481", "Rio\ de\ Janeiro\ \-\ RJ",
"55483354", "Garopaba\ \-\ SC",
"55633554", "Taquarussu\ do\ Porto\ \-\ TO",
"55553201", "Santo\ Ângelo\ \-\ RS",
"55833379", "Cacimba\ de\ Dentro\ \-\ PB",
"55623376", "Aruanã\ \-\ GO",
"55193936", "Indaiatuba\ \-\ SP",
"55113445", "Itaquaquecetuba\ \-\ SP",
"55793431", "Itabaiana\ \-\ SE",
"55493554", "Herval\ D\'Oeste\ \-\ SC",
"55173347", "Jaborandi\ \-\ SP",
"55423520", "São\ Mateus\ do\ Sul\ \-\ PR",
"55513137", "Alvorada\ \-\ RS",
"55613642", "Formosa\ \-\ GO",
"55483461", "Criciúma\ \-\ SC",
"55273082", "Vitória\ \-\ ES",
"55112347", "São\ Paulo\ \-\ SP",
"55443545", "Yolanda\ \-\ PR",
"55733683", "Guarani\ \-\ BA",
"55193663", "Divinolândia\ \-\ SP",
"55114708", "Mairinque\ \-\ SP",
"55373259", "Pitangui\ \-\ MG",
"55483089", "São\ José\ \-\ SC",
"55813731", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55983461", "Vargem\ Grande\ \-\ MA",
"55753693", "Pintadas\ \-\ BA",
"55993554", "Paraibano\ \-\ MA",
"55773698", "Ibotirama\ \-\ BA",
"55313411", "Minas\ Gerais",
"55843435", "Florânia\ \-\ RN",
"55313649", "Santa\ Luzia\ \-\ MG",
"55543321", "Erechim\ \-\ RS",
"55753262", "Conceição\ do\ Coité\ \-\ BA",
"5554321", "Caxias\ do\ Sul\ \-\ RS",
"55473270", "Jaraguá\ do\ Sul\ \-\ SC",
"55983395", "Godofredo\ Viana\ \-\ MA",
"55623302", "Jussara\ \-\ GO",
"55513623", "Rio\ Grande\ do\ Sul",
"55273772", "Nova\ Venécia\ \-\ ES",
"55542992", "Caxias\ do\ Sul\ \-\ RS",
"55323258", "Coronel\ Pacheco\ \-\ MG",
"55153335", "Sorocaba\ \-\ SP",
"55753327", "Lajedinho\ \-\ BA",
"55212772", "Duque\ de\ Caxias\ \-\ RJ",
"55673473", "Eldorado\ \-\ MS",
"55733242", "Ibicaraí\ \-\ BA",
"55114818", "Terra\ Preta\ \-\ SP",
"55153524", "Itapeva\ \-\ SP",
"55733311", "Teixeira\ de\ Freitas\ \-\ BA",
"55714007", "Salvador\ \-\ BA",
"55823314", "Maceió\ \-\ AL",
"55353843", "Ijaci\ \-\ MG",
"55983455", "Matões\ do\ Norte\ \-\ MA",
"55113576", "São\ Paulo\ \-\ SP",
"55683248", "Rio\ Branco\ \-\ AC",
"55123604", "Pindamonhangaba\ \-\ SP",
"55673022", "Campo\ Grande\ \-\ MS",
"55513430", "Gravataí\ \-\ RS",
"55734102", "Ilhéus\ \-\ BA",
"55542103", "Passo\ Fundo\ \-\ RS",
"55453036", "Cascavel\ \-\ PR",
"55743626", "Mundo\ Novo\ \-\ BA",
"55353731", "Andradas\ \-\ MG",
"55115631", "São\ Paulo\ \-\ SP",
"55753238", "Terra\ Nova\ \-\ BA",
"55693447", "Parecis\ \-\ RO",
"55643497", "Santo\ Antônio\ do\ Rio\ Verde\ \-\ GO",
"55843525", "Guamaré\ \-\ RN",
"55843334", "Serra\ do\ Mel\ \-\ RN",
"55112717", "São\ Paulo\ \-\ SP",
"55713115", "Salvador\ \-\ BA",
"55823643", "Olho\ d\'Água\ do\ Casado\ \-\ AL",
"55434063", "Londrina\ \-\ PR",
"55513457", "Rio\ Grande\ do\ Sul",
"55513509", "São\ Leopoldo\ \-\ RS",
"55893572", "Parnaguá\ \-\ PI",
"55113502", "São\ Paulo\ \-\ SP",
"55353296", "Fama\ \-\ MG",
"55513724", "Cachoeira\ do\ Sul\ \-\ RS",
"55913823", "Americano\ \-\ PA",
"55143311", "Marília\ \-\ SP",
"55114487", "Itatiba\ \-\ SP",
"55242263", "Paraíba\ do\ Sul\ \-\ RJ",
"55213923", "Rio\ de\ Janeiro\ \-\ RJ",
"55112807", "Embu\ das\ Artes\ \-\ SP",
"55242259", "Petrópolis\ \-\ RJ",
"55173807", "Ubarana\ \-\ SP",
"55663593", "Apiacás\ \-\ MT",
"55423457", "Rebouças\ \-\ PR",
"55623581", "Goiânia\ \-\ GO",
"55193373", "Piracicaba\ \-\ SP",
"55883638", "Hidrolândia\ \-\ CE",
"55623933", "Goiânia\ \-\ GO",
"55823282", "Paulo\ Jacinto\ \-\ AL",
"55983523", "Imperatriz\ \-\ MA",
"55713297", "Salvador\ \-\ BA",
"5519352", "Rio\ Claro\ \-\ SP",
"55333743", "Felisburgo\ \-\ MG",
"55553362", "Dezesseis\ de\ Novembro\ \-\ RS",
"55743221", "Senhor\ do\ Bonfim\ \-\ BA",
"55153353", "Votorantim\ \-\ SP",
"55183911", "Eneida\ \-\ SP",
"55643571", "Palmeiras\ de\ Goiás\ \-\ GO",
"55853326", "Capistrano\ \-\ CE",
"55353011", "Alfenas\ \-\ MG",
"55743065", "Juazeiro\ \-\ BA",
"5561219", "Brasília\ \-\ DF",
"55843272", "Parnamirim\ \-\ RN",
"55173466", "Cardoso\ \-\ SP",
"55163341", "Ibitinga\ \-\ SP",
"55813475", "Recife\ \-\ PE",
"55193405", "Americana\ \-\ SP",
"55773261", "Itapetinga\ \-\ BA",
"55473383", "Ascurra\ \-\ SC",
"55533342", "Pelotas\ \-\ RS",
"55553227", "Itaara\ \-\ RS",
"55753634", "Amargosa\ \-\ BA",
"55382101", "Montes\ Claros\ \-\ MG",
"55193844", "Paulínia\ \-\ SP",
"55183211", "Birigui\ \-\ SP",
"55513486", "Morungava\ \-\ RS",
"55653251", "São\ José\ dos\ Quatro\ Marcos\ \-\ MT",
"55993017", "Imperatriz\ \-\ MA",
"55753301", "Feira\ de\ Santana\ \-\ BA",
"55313895", "Teixeiras\ \-\ MG",
"55433398", "Tamarana\ \-\ PR",
"55493323", "Chapecó\ \-\ SC",
"55353691", "Três\ Corações\ \-\ MG",
"55183876", "Paulicéia\ \-\ SP",
"55114456", "Salto\ \-\ SP",
"55313854", "Rio\ Piracicaba\ \-\ MG",
"5513331", "Bertioga\ \-\ SP",
"55323753", "Miradouro\ \-\ MG",
"5511258", "São\ Paulo\ \-\ SP",
"55823891", "Viçosa\ \-\ MG",
"55173209", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55483523", "Maracajá\ \-\ SC",
"55663424", "Rondonópolis\ \-\ MT",
"55443647", "Maripá\ \-\ PR",
"55213035", "Rio\ de\ Janeiro\ \-\ RJ",
"55893489", "Conceição\ do\ Canindé\ \-\ PI",
"55863298", "Angical\ do\ Piauí\ \-\ PI",
"55813759", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55163711", "Franca\ \-\ SP",
"55453346", "São\ João\ d\'Oeste\ \-\ PR",
"55373231", "Pará\ de\ Minas\ \-\ MG",
"55713645", "Pojuca\ \-\ BA",
"55353664", "Conceição\ das\ Pedras\ \-\ MG",
"55323015", "Juiz\ de\ Fora\ \-\ MG",
"55733536", "Santa\ Inês\ \-\ BA",
"55163384", "Matão\ \-\ SP",
"55333313", "Inhapim\ \-\ MG",
"55313552", "Ouro\ Preto\ \-\ MG",
"55663534", "Terra\ Nova\ do\ Norte\ \-\ MT",
"55143003", "Bauru\ \-\ SP",
"55473449", "São\ Francisco\ do\ Sul\ \-\ SC",
"55492101", "Lages\ \-\ SC",
"55483433", "Criciúma\ \-\ SC",
"551132", "São\ Paulo\ \-\ SP",
"55793459", "Pedra\ Mole\ \-\ SE",
"55513448", "Rio\ Grande\ do\ Sul",
"55352107", "Poços\ de\ Caldas\ \-\ MG",
"551139", "São\ Paulo\ \-\ SP",
"55833635", "Damião\ \-\ PB",
"55194002", "Campinas\ \-\ SP",
"55313326", "Belo\ Horizonte\ \-\ MG",
"55273090", "Cariacica\ \-\ ES",
"55843133", "Natal\ \-\ RN",
"55193881", "Valinhos\ \-\ SP",
"55843393", "João\ Dias\ \-\ RN",
"55553338", "Nova\ Ramada\ \-\ RS",
"55114136", "Araçariguama\ \-\ SP",
"55273138", "Serra\ \-\ ES",
"55193304", "Campinas\ \-\ SP",
"55613559", "Samambaia\ Sul\ \-\ DF",
"55613563", "Taguatinga\ \-\ DF",
"55115103", "São\ Paulo\ \-\ SP",
"55433162", "Apucarana\ \-\ PR",
"55493245", "Curitibanos\ \-\ SC",
"55992101", "Imperatriz\ \-\ MA",
"55653265", "Conquista\ D\'Oeste\ \-\ MT",
"55813691", "Panelas\ \-\ PE",
"55883640", "Alcântaras\ \-\ CE",
"55193542", "Araras\ \-\ SP",
"55443254", "Atalaia\ \-\ PR",
"55883543", "Aurora\ \-\ CE",
"5519343", "Piracicaba\ \-\ SP",
"55813744", "Agrestina\ \-\ PE",
"55353643", "Piranguçu\ \-\ MG",
"55143298", "Macatuba\ \-\ SP",
"55333236", "Alpercata\ \-\ MG",
"55313309", "Belo\ Horizonte\ \-\ MG",
"55853320", "Paramoti\ \-\ CE",
"55313735", "Jeceaba\ \-\ MG",
"55433616", "Sengés\ \-\ PR",
"55713699", "Saubara\ \-\ BA",
"55163518", "Cravinhos\ \-\ SP",
"55223053", "Cabo\ Frio\ \-\ RJ",
"55843384", "Pilões\ \-\ RN",
"55513480", "Guaíba\ \-\ RS",
"55822121", "Maceió\ \-\ AL",
"55473361", "Balneário\ Camboriú\ \-\ SC",
"55672106", "Campo\ Grande\ \-\ MS",
"55413623", "Quitandinha\ \-\ PR",
"55193948", "Louveira\ \-\ SP",
"55163133", "Cristais\ Paulista\ \-\ SP",
"55713473", "Salvador\ \-\ BA",
"55553629", "Jacuizinho\ \-\ RS",
"55333292", "Marilac\ \-\ MG",
"55623642", "Goiânia\ \-\ GO",
"55114066", "Diadema\ \-\ SP",
"55823232", "Maceió\ \-\ AL",
"55183271", "Presidente\ Venceslau\ \-\ SP",
"5592323", "Manaus\ \-\ AM",
"55133494", "Praia\ Grande\ \-\ SP",
"55163393", "Américo\ Brasiliense\ \-\ SP",
"55953086", "Boa\ Vista\ \-\ RR",
"55353282", "Carvalhópolis\ \-\ MG",
"55623983", "Aparecida\ de\ Goiânia\ \-\ GO",
"55413150", "Fazenda\ Rio\ Grande\ \-\ PR",
"55793223", "Aracaju\ \-\ SE",
"55733298", "Prado\ \-\ BA",
"55433032", "Londrina\ \-\ PR",
"55343431", "Prata\ \-\ MG",
"55943321", "Marabá\ \-\ PA",
"55243320", "Volta\ Redonda\ \-\ RJ",
"55493652", "Palma\ Sola\ \-\ SC",
"55863260", "Demerval\ Lobão\ \-\ PI",
"55183706", "Suzanápolis\ \-\ SP",
"55222772", "Macaé\ \-\ RJ",
"55773642", "Oliveira\ dos\ Brejinhos\ \-\ BA",
"55613302", "Sobradinho\ \-\ DF",
"55883564", "Cedro\ \-\ CE",
"55623283", "Aparecida\ de\ Goiânia\ \-\ GO",
"55483626", "Tubarão\ \-\ SC",
"55443249", "Lobato\ \-\ PR",
"55823296", "Maragogi\ \-\ AL",
"55433573", "Guapirama\ \-\ PR",
"55192117", "Campinas\ \-\ SP",
"55893451", "Santo\ Inácio\ do\ Piauí\ \-\ PI",
"55733633", "Ilhéus\ \-\ BA",
"55333764", "Minas\ Novas\ \-\ MG",
"55823268", "Santa\ Luzia\ do\ Norte\ \-\ AL",
"55753246", "São\ Gonçalo\ dos\ Campos\ \-\ BA",
"55483039", "Florianópolis\ \-\ SC",
"55733530", "Entroncamento\ de\ Jaguaquara\ \-\ BA",
"55273032", "Vila\ Velha\ \-\ ES",
"55212670", "Japeri\ \-\ RJ",
"55113191", "São\ Paulo\ \-\ SP",
"55813314", "Recife\ \-\ PE",
"55673547", "Debrasa\ \-\ MS",
"55813643", "Itaquitinga\ \-\ PE",
"55942103", "Marabá\ \-\ PA",
"55163972", "Bonfim\ Paulista\ \-\ SP",
"55213431", "Rio\ de\ Janeiro\ \-\ RJ",
"5531381", "Minas\ Gerais",
"55313320", "Ipaba\ \-\ MG",
"55733266", "Itarantim\ \-\ BA",
"55893465", "Valença\ do\ Piauí\ \-\ PI",
"55114098", "Salto\ \-\ SP",
"55193859", "Valinhos\ \-\ SP",
"55553612", "Dilermando\ de\ Aguiar\ \-\ RS",
"55193863", "Itapira\ \-\ SP",
"55623421", "Alvorada\ do\ Norte\ \-\ GO",
"55674007", "Campo\ Grande\ \-\ MS",
"55543476", "União\ da\ Serra\ \-\ RS",
"55442103", "Maringá\ \-\ PR",
"55643088", "Itumbiara\ \-\ GO",
"55483207", "Florianópolis\ \-\ SC",
"55114130", "São\ Roque\ \-\ SP",
"55613233", "Guará\ \-\ DF",
"55313849", "Timóteo\ \-\ MG",
"55153277", "Tapiraí\ \-\ SP",
"55413457", "Pontal\ do\ Paraná\ \-\ PR",
"5521388", "Rio\ de\ Janeiro\ \-\ RJ",
"55473355", "Brusque\ \-\ SC",
"55333373", "Santana\ do\ Manhuaçu\ \-\ MG",
"55883646", "Cariré\ \-\ CE",
"55843229", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55613581", "Ceilândia\ \-\ DF",
"5531370", "Minas\ Gerais",
"55622765", "Goiânia\ \-\ GO",
"55143883", "Bofete\ \-\ SP",
"55114618", "Jandira\ \-\ SP",
"55473394", "Indaial\ \-\ SC",
"55913724", "Benevides\ \-\ PA",
"55673413", "Panambi\ \-\ MS",
"55473902", "Jaraguá\ do\ Sul\ \-\ SC",
"55114878", "Barueri\ \-\ SP",
"55212712", "São\ Gonçalo\ \-\ RJ",
"55353864", "Perdões\ \-\ MG",
"55193831", "Mogi\-Guaçu\ \-\ SP",
"5541356", "Curitiba\ \-\ PR",
"55753641", "Valença\ \-\ BA",
"55833685", "Sertãozinho\ \-\ PB",
"55183366", "Quatá\ \-\ SP",
"55193743", "Campinas\ \-\ SP",
"55212700", "Itaguaí\ \-\ RJ",
"55193566", "Analândia\ \-\ SP",
"55663584", "Sorriso\ \-\ MT",
"55193681", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55373281", "Santo\ Antônio\ do\ Monte\ \-\ MG",
"55733661", "Vereda\ \-\ BA",
"55423526", "Porto\ União\ \-\ SC",
"55643608", "Bom\ Jesus\ de\ Goiás\ \-\ GO",
"55383756", "Buenópolis\ \-\ MG",
"55623370", "Montes\ Claros\ de\ Goiás\ \-\ GO",
"55673297", "Chapadão\ do\ Baús\ \-\ MS",
"55313247", "Belo\ Horizonte\ \-\ MG",
"55983483", "Magalhães\ de\ Almeida\ \-\ MA",
"55163601", "Ribeirão\ Preto\ \-\ SP",
"55173621", "Jales\ \-\ SP",
"55693342", "Cerejeiras\ \-\ RO",
"55384009", "Montes\ Claros\ \-\ MG",
"5531367", "Sabará\ \-\ MG",
"55112621", "São\ Paulo\ \-\ SP",
"5524336", "Angra\ dos\ Reis\ \-\ RJ",
"55113359", "São\ Paulo\ \-\ SP",
"5586322", "Teresina\ \-\ PI",
"55613961", "Brasília\ \-\ DF",
"55813562", "Primavera\ \-\ PE",
"55613261", "Brasília\ \-\ DF",
"55683542", "Xapuri\ \-\ AC",
"55433342", "Londrina\ \-\ PR",
"55143586", "Guarantã\ \-\ SP",
"55283037", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"5582335", "Maceió\ \-\ AL",
"55313753", "Rio\ Espera\ \-\ MG",
"55114914", "São\ Paulo\ \-\ SP",
"55313769", "Conselheiro\ Lafaiete\ \-\ MG",
"55733548", "Irajuba\ \-\ BA",
"55953198", "Boa\ Vista\ \-\ RR",
"55743620", "São\ Gabriel\ \-\ BA",
"55213139", "Rio\ de\ Janeiro\ \-\ RJ",
"55453030", "Foz\ do\ Iguaçu\ \-\ PR",
"55623407", "São\ Miguel\ do\ Passa\ Quatro\ \-\ GO",
"55513436", "Viamão\ \-\ RS",
"5543332", "Londrina\ \-\ PR",
"55273729", "São\ Roque\ do\ Canaã\ \-\ ES",
"55653637", "Cuiabá\ \-\ MT",
"55112087", "Guarulhos\ \-\ SP",
"55183602", "Gabriel\ Monteiro\ \-\ SP",
"55753422", "Alagoinhas\ \-\ BA",
"5531336", "Minas\ Gerais",
"55753684", "Ichu\ \-\ BA",
"55473333", "Indaial\ \-\ SC",
"55663016", "Primavera\ do\ Leste\ \-\ MT",
"55863242", "Barras\ \-\ PI",
"55513067", "Novo\ Hamburgo\ \-\ RS",
"55643452", "Rio\ Quente\ \-\ GO",
"55493549", "Vargem\ \-\ SC",
"55443599", "Campo\ Mourão\ \-\ PR",
"55663541", "Colíder\ \-\ MT",
"55913448", "Maracanã\ \-\ PA",
"55433911", "Jacarezinho\ \-\ PR",
"55543295", "Gramado\ \-\ RS",
"55373244", "Carmo\ do\ Cajuru\ \-\ MG",
"55513492", "Viamão\ \-\ RS",
"55423436", "Imbituva\ \-\ PR",
"55893439", "Marcolândia\ \-\ PI",
"55833267", "Juarez\ Távora\ \-\ PB",
"55353562", "Nova\ Resende\ \-\ MG",
"55634009", "Palmas\ \-\ TO",
"55173442", "Fernandópolis\ \-\ SP",
"55833556", "São\ Gonçalo\ \-\ PB",
"55343459", "Frutal\ \-\ MG",
"55114148", "Cotia\ \-\ SP",
"55123143", "Cruzeiro\ \-\ SP",
"55123034", "Caraguatatuba\ \-\ SP",
"55833322", "Campina\ Grande\ \-\ PB",
"55733694", "São\ José\ da\ Vitória\ \-\ BA",
"55983349", "Barreirinhas\ \-\ MA",
"55483065", "Florianópolis\ \-\ SC",
"55314", "Minas\ Gerais",
"55373423", "Tapiraí\ \-\ MG",
"55143014", "Bauru\ \-\ SP",
"55443627", "São\ Lourenço\ \-\ PR",
"55213002", "Rio\ de\ Janeiro\ \-\ RJ",
"55472104", "Itajaí\ \-\ SC",
"55843254", "São\ Pedro\ \-\ RN",
"55513538", "Canoas\ \-\ RS",
"55813492", "Olinda\ \-\ PE",
"55973412", "Tabatinga\ \-\ AM",
"55193519", "Campinas\ \-\ SP",
"55173634", "Urânia\ \-\ SP",
"55323362", "Barbacena\ \-\ MG",
"55153261", "Porto\ Feliz\ \-\ SP",
"55843295", "Jaçanã\ \-\ RN",
"5511433", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55283532", "Marataízes\ \-\ ES",
"55813436", "Paulista\ \-\ PE",
"55543031", "Canela\ \-\ RS",
"55913011", "Paragominas\ \-\ PA",
"55653363", "Cuiabá\ \-\ MT",
"55493343", "Formosa\ do\ Sul\ \-\ SC",
"55273401", "Baixo\ Guandu\ \-\ ES",
"55112884", "Mogi\ das\ Cruzes\ \-\ SP",
"55753358", "Coronel\ Octaviano\ Alves\ \-\ BA",
"55673456", "Nova\ Alvorada\ do\ Sul\ \-\ MS",
"55163949", "Cruz\ das\ Posses\ \-\ SP",
"55613879", "Brasília\ \-\ DF",
"5516391", "Ribeirão\ Preto\ \-\ SP",
"55313872", "Abre\ Campo\ \-\ MG",
"55132105", "Santos\ \-\ SP",
"55333215", "Governador\ Valadares\ \-\ MG",
"55443133", "Mandaguari\ \-\ PR",
"55123687", "Quiririm\ \-\ SP",
"55833458", "Manaíra\ \-\ PB",
"55313716", "Inhaúma\ \-\ MG",
"55484003", "Florianópolis\ \-\ SC",
"55193824", "Águas\ de\ Lindóia\ \-\ SP",
"55833366", "Lagoa\ Seca\ \-\ PB",
"55193496", "Rafard\ \-\ SP",
"5521260", "São\ Gonçalo\ \-\ RJ",
"55713186", "Salvador\ \-\ BA",
"55443518", "Campo\ Mourão\ \-\ PR",
"5511419", "Barueri\ \-\ SP",
"55993614", "Itaipava\ do\ Grajaú\ \-\ MA",
"55623353", "Goianésia\ \-\ GO",
"55112301", "São\ Paulo\ \-\ SP",
"55883433", "Aracati\ \-\ CE",
"55892101", "Picos\ \-\ PI",
"55533267", "Herval\ \-\ RS",
"55313080", "Belo\ Horizonte\ \-\ MG",
"55333723", "Jacinto\ \-\ MG",
"55173301", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55113418", "Taboão\ da\ Serra\ \-\ SP",
"55353526", "Passos\ \-\ MG",
"55853346", "Itapagé\ \-\ CE",
"55313388", "Belo\ Horizonte\ \-\ MG",
"55914006", "Belém\ \-\ PA",
"55163321", "Tabatinga\ \-\ SP",
"55553753", "São\ José\ das\ MissõEs\ \-\ RS",
"55423562", "Paula\ Freitas\ \-\ PR",
"55313574", "Crucilândia\ \-\ MG",
"55663481", "Alto\ Araguaia\ \-\ MT",
"55183556", "Inúbia\ Paulista\ \-\ SP",
"55123021", "São\ José\ dos\ Campos\ \-\ SP",
"55353436", "Toledo\ \-\ MG",
"55183267", "Santo\ Expedito\ \-\ SP",
"55713501", "Salvador\ \-\ BA",
"55553015", "Santa\ Maria\ \-\ RS",
"55463557", "Bela\ Vista\ da\ Caroba\ \-\ PR",
"55843647", "Parnamirim\ \-\ RN",
"55883523", "Crato\ \-\ CE",
"55443906", "Umuarama\ \-\ PR",
"55123965", "Jacareí\ \-\ SP",
"55953552", "Bonfim\ \-\ RR",
"55173841", "Arabá\ \-\ SP",
"55833398", "Itatuba\ \-\ PB",
"55383614", "Montalvânia\ \-\ MG",
"55343690", "Araguari\ \-\ MG",
"55213748", "Belford\ Roxo\ \-\ RJ",
"55353067", "Varginha\ \-\ MG",
"55183322", "Assis\ \-\ SP",
"55733575", "Arraial\ d\'Ajuda\ \-\ BA",
"55112841", "São\ Paulo\ \-\ SP",
"55793264", "Itaporanga\ d\'Ajuda\ \-\ SE",
"55243388", "Resende\ \-\ RJ",
"55153294", "Ibiúna\ \-\ SP",
"55222556", "São\ Sebastião\ do\ Alto\ \-\ RJ",
"55433401", "Cornélio\ Procópio\ \-\ PR",
"55513562", "Portão\ \-\ RS",
"55333624", "Carlos\ Chagas\ \-\ MG",
"55313346", "Belo\ Horizonte\ \-\ MG",
"55153255", "Angatuba\ \-\ SP",
"55813526", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55323338", "Madre\ de\ Deus\ de\ Minas\ \-\ MG",
"55413664", "Doutor\ Ulysses\ \-\ PR",
"55443453", "Santa\ Isabel\ do\ Ivaí\ \-\ PR",
"55773493", "Guanambi\ \-\ BA",
"55713625", "Dias\ d\'Ávila\ \-\ BA",
"55443272", "Fênix\ \-\ PR",
"55413588", "São\ José\ dos\ Pinhais\ \-\ PR",
"55453326", "Cascavel\ \-\ PR",
"55113637", "São\ Paulo\ \-\ SP",
"55473377", "Luiz\ Alves\ \-\ SC",
"55143488", "Quintana\ \-\ SP",
"55412107", "Curitiba\ \-\ PR",
"55833513", "João\ Pessoa\ \-\ PB",
"55343318", "Uberaba\ \-\ MG",
"55513428", "Rio\ Grande\ do\ Sul",
"55114739", "Mogi\ das\ Cruzes\ \-\ SP",
"55483372", "São\ José\ \-\ SC",
"55323201", "Cataguases\ \-\ MG",
"55453411", "Cascavel\ \-\ PR",
"55513540", "Rio\ Grande\ do\ Sul",
"55633572", "Palmas\ \-\ TO",
"55833271", "Guarabira\ \-\ PB",
"55343832", "Patrocínio\ \-\ MG",
"55213534", "Rio\ de\ Janeiro\ \-\ RJ",
"55433537", "Barra\ do\ Jacaré\ \-\ PR",
"55153302", "Sorocaba\ \-\ SP",
"55623524", "Goiânia\ \-\ GO",
"55383218", "Montes\ Claros\ \-\ MG",
"55153544", "Ribeirão\ Grande\ \-\ SP",
"55733222", "Ilhéus\ \-\ BA",
"55623335", "Vianópolis\ \-\ GO",
"55114473", "Santo\ André\ \-\ SP",
"5561202", "Brasília\ \-\ DF",
"55242491", "Vassouras\ \-\ RJ",
"55373351", "Arcos\ \-\ MG",
"55513781", "Rio\ Grande\ do\ Sul",
"55223016", "Nova\ Friburgo\ \-\ RJ",
"55114699", "Mogi\ das\ Cruzes\ \-\ SP",
"55543341", "Getúlio\ Vargas\ \-\ RS",
"55343424", "Itapagipe\ \-\ MG",
"55193387", "Campinas\ \-\ SP",
"55493572", "Matos\ Costa\ \-\ SC",
"55423643", "Nova\ Tebas\ \-\ PR",
"55483306", "Florianópolis\ \-\ SC",
"55113425", "Diadema\ \-\ SP",
"55923071", "Manaus\ \-\ AM",
"55114751", "Suzano\ \-\ SP",
"55163307", "São\ Carlos\ \-\ SP",
"55153376", "Itapetininga\ \-\ SP",
"55613622", "Luziânia\ \-\ GO",
"55643689", "Diorama\ \-\ GO",
"55143222", "Bauru\ \-\ SP",
"55853092", "Fortaleza\ \-\ CE",
"55993572", "Buriti\ Bravo\ \-\ MA",
"55443525", "Campo\ Mourão\ \-\ PR",
"55673274", "Figueirão\ \-\ MS",
"55713450", "Salvador\ \-\ BA",
"55933537", "Mujuí\ dos\ Campos\ \-\ PA",
"5535323", "Três\ Corações\ \-\ MG",
"55173262", "Nova\ Granada\ \-\ SP",
"55843476", "Santana\ do\ Seridó\ \-\ RN",
"55833447", "Belém\ do\ Brejo\ do\ Cruz\ \-\ PB",
"55553258", "Nova\ Esperança\ do\ Sul\ \-\ RS",
"55983372", "Santo\ Antônio\ dos\ Lopes\ \-\ MA",
"55114019", "Itu\ \-\ SP",
"55273754", "Montanha\ \-\ ES",
"55173693", "São\ Francisco\ \-\ SP",
"55343243", "Amanhece\ \-\ MG",
"55473565", "Mirim\ Doce\ \-\ SC",
"55513982", "Lajeado\ \-\ RS",
"55873871", "Salgueiro\ \-\ PE",
"55163847", "Nuporanga\ \-\ SP",
"55653331", "Barão\ de\ Melgaço\ \-\ MT",
"55443435", "Planaltina\ do\ Paraná\ \-\ PR",
"55913731", "Vigia\ \-\ PA",
"55463548", "Bom\ Jesus\ do\ Sul\ \-\ PR",
"55513744", "Ibarama\ \-\ RS",
"55543384", "Barros\ Cassal\ \-\ RS",
"55642102", "Jataí\ \-\ GO",
"55793541", "Tobias\ Barreto\ \-\ SE",
"55773434", "Planalto\ \-\ BA",
"55553028", "Santa\ Maria\ \-\ RS",
"55673487", "Vila\ Marques\ \-\ MS",
"55273120", "Colatina\ \-\ ES",
"55212653", "Duque\ de\ Caxias\ \-\ RJ",
"55693427", "Nova\ Colina\ \-\ RO",
"55613619", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55342109", "Araguari\ \-\ MG",
"55513415", "Canoas\ \-\ RS",
"55943435", "São\ Félix\ do\ Xingu\ \-\ PA",
"55212669", "Nova\ Iguaçu\ \-\ RJ",
"55893554", "São\ José\ do\ Peixe\ \-\ PI",
"55823623", "Olho\ d\'Água\ das\ Flores\ \-\ AL",
"55383506", "Buritis\ \-\ MG",
"55823520", "Girau\ do\ Ponciano\ \-\ AL",
"55623434", "Goiânia\ \-\ GO",
"55133591", "Praia\ Grande\ \-\ SP",
"55963014", "Macapá\ \-\ AP",
"55353823", "Itumirim\ \-\ MG",
"55324141", "Juiz\ de\ Fora\ \-\ MG",
"55743646", "Cafarnaum\ \-\ BA",
"55114022", "Itu\ \-\ SP",
"55733677", "Coroa\ Vermelha\ \-\ BA",
"55213896", "Duque\ de\ Caxias\ \-\ RJ",
"55133862", "Colonização\ \-\ SP",
"55713203", "Salvador\ \-\ BA",
"55633439", "Itacajá\ \-\ TO",
"55242224", "São\ José\ do\ Vale\ do\ Rio\ Preto\ \-\ RJ",
"55212685", "Mangaratiba\ \-\ RJ",
"55983312", "São\ Luís\ \-\ MA",
"55453247", "Penha\ \-\ PR",
"55883221", "Juazeiro\ do\ Norte\ \-\ CE",
"55112783", "São\ Paulo\ \-\ SP",
"55513011", "Lajeado\ \-\ RS",
"55853198", "Fortaleza\ \-\ CE",
"55513546", "Três\ Coroas\ \-\ RS",
"55613045", "Brasília\ \-\ DF",
"55513763", "Rio\ Grande\ do\ Sul",
"55383814", "Mamonas\ \-\ MG",
"55693322", "Vilhena\ \-\ RO",
"55954400", "Caracaraí\ \-\ RR",
"55173641", "Santa\ Fé\ do\ Sul\ \-\ SP",
"55513759", "Travesseiro\ \-\ RS",
"55813448", "Recife\ \-\ PE",
"55433267", "São\ Jerônimo\ da\ Serra\ \-\ PR",
"55493439", "Linha\ Planalto\ \-\ SC",
"55663431", "Guiratinga\ \-\ MT",
"55433556", "Abatiá\ \-\ PR",
"55963242", "Macapá\ \-\ AP",
"55112419", "Bragança\ Paulista\ \-\ SP",
"55112641", "São\ Paulo\ \-\ SP",
"55863219", "Teresina\ \-\ PI",
"55643651", "Quirinópolis\ \-\ GO",
"55313166", "Belo\ Horizonte\ \-\ MG",
"55242443", "Barra\ do\ Piraí\ \-\ RJ",
"55112532", "São\ Paulo\ \-\ SP",
"55114789", "Jandira\ \-\ SP",
"55893549", "Alvorada\ do\ Gurguéia\ \-\ PI",
"55463242", "Chopinzinho\ \-\ PR",
"55513691", "Rio\ Grande\ do\ Sul",
"55853338", "Beberibe\ \-\ CE",
"55543393", "Mormaço\ \-\ RS",
"55183401", "Valparaíso\ \-\ SP",
"55613353", "Taguatinga\ \-\ DF",
"55333432", "São\ Sebastião\ do\ Maranhão\ \-\ MG",
"55753621", "Cruz\ das\ Almas\ \-\ BA",
"55413113", "Campo\ Largo\ \-\ PR",
"55613369", "Paranoá\ \-\ DF",
"55513664", "Torres\ \-\ RS",
"55983477", "São\ Bernardo\ \-\ MA",
"55333522", "Teófilo\ Otoni\ \-\ MG",
"55483241", "São\ José\ \-\ SC",
"55833342", "Campina\ Grande\ \-\ PB",
"55213792", "Duque\ de\ Caxias\ \-\ RJ",
"55112834", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55643665", "Piranhas\ \-\ GO",
"55733617", "Itabuna\ \-\ BA",
"55553552", "Vista\ Gaúcha\ \-\ RS",
"55323574", "Tocantins\ \-\ MG",
"55413562", "Colombo\ \-\ PR",
"55713396", "Simões\ Filho\ \-\ BA",
"55153563", "Guapiara\ \-\ SP",
"55813486", "Recife\ \-\ PE",
"55173834", "Guarani\ D\'Oeste\ \-\ SP",
"5521271", "Niterói\ \-\ RJ",
"55923664", "Manaus\ \-\ AM",
"55114645", "Itaquaquecetuba\ \-\ SP",
"55853362", "Aquiraz\ \-\ CE",
"55463311", "Pato\ Branco\ \-\ PR",
"55512107", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55333356", "São\ João\ do\ Oriente\ \-\ MG",
"55173422", "Votuporanga\ \-\ SP",
"55613679", "São\ Gabriel\ de\ Goiás\ \-\ GO",
"55793318", "Monte\ Alegre\ de\ Sergipe\ \-\ SE",
"55513475", "Canoas\ \-\ RS",
"55143279", "Tibiriçá\ \-\ SP",
"55112684", "São\ Paulo\ \-\ SP",
"55213736", "Rio\ de\ Janeiro\ \-\ RJ",
"55543272", "Guabiju\ \-\ RS",
"55513588", "São\ Leopoldo\ \-\ RS",
"55553326", "Cruz\ Alta\ \-\ RS",
"55643474", "Orizona\ \-\ GO",
"55663521", "Alta\ Floresta\ \-\ MT",
"55823526", "Coité\ do\ Nóia\ \-\ AL",
"55313338", "Nova\ Lima\ \-\ MG",
"55493278", "Urubici\ \-\ SC",
"55543906", "Farroupilha\ \-\ RS",
"55323346", "Antônio\ Carlos\ \-\ MG",
"5596322", "Macapá\ \-\ AP",
"55423664", "Faxinal\ do\ Céu\ \-\ PR",
"55873202", "Petrolina\ \-\ PE",
"55273267", "Fundão\ \-\ ES",
"55193482", "Águas\ de\ São\ Pedro\ \-\ SP",
"55453015", "Cascavel\ \-\ PR",
"55613217", "Brasília\ \-\ DF",
"55193624", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55863367", "Luís\ Correia\ \-\ PI",
"55213890", "Rio\ de\ Janeiro\ \-\ RJ",
"55733528", "Jequié\ \-\ BA",
"55873811", "Jirau\ \-\ PE",
"55733279", "Teolândia\ \-\ BA",
"55134003", "Praia\ Grande\ \-\ SP",
"55273322", "Vitória\ \-\ ES",
"55743640", "Presidente\ Dutra\ \-\ BA",
"55313057", "Belo\ Horizonte\ \-\ MG",
"55343264", "Gurinhatã\ \-\ MG",
"55123637", "Moreira\ César\ \-\ SP",
"55512", "Rio\ Grande\ do\ Sul",
"55473472", "Joinville\ \-\ SC",
"55113585", "São\ Paulo\ \-\ SP",
"55543334", "Colorado\ \-\ RS",
"55773484", "Santana\ \-\ BA",
"55613335", "São\ Sebastião\ \-\ DF",
"55773622", "Angical\ \-\ BA",
"55543525", "Severiano\ de\ Almeida\ \-\ RS",
"55943341", "Bom\ Jesus\ do\ Tocantins\ \-\ PA",
"55673437", "Ponta\ Porã\ \-\ MS",
"55913781", "Cametá\ \-\ PA",
"55213780", "Duque\ de\ Caxias\ \-\ RJ",
"55313201", "Belo\ Horizonte\ \-\ MG",
"55813457", "Paulista\ \-\ PE",
"55423303", "Guarapuava\ \-\ PR",
"55153283", "Laranjal\ Paulista\ \-\ SP",
"55483646", "Laguna\ \-\ SC",
"55413282", "São\ José\ dos\ Pinhais\ \-\ PR",
"55743662", "Barra\ \-\ BA",
"55963426", "Lourenço\ \-\ AP",
"55153531", "Itararé\ \-\ SP",
"55133846", "Pedro\ Barros\ \-\ SP",
"55453258", "Ramilândia\ \-\ PR",
"55383083", "Montes\ Claros\ \-\ MG",
"55473406", "Balneário\ Camboriú\ \-\ SC",
"55213632", "Magé\ \-\ RJ",
"55833360", "Borborema\ \-\ PB",
"55313710", "Minas\ Gerais",
"55163024", "Ribeirão\ Preto\ \-\ SP",
"55183379", "São\ José\ Laranjeiras\ \-\ SP",
"55623484", "Mambaí\ \-\ GO",
"55413643", "Araucária\ \-\ PR",
"55623622", "Goiânia\ \-\ GO",
"55553411", "Uruguaiana\ \-\ RS",
"55553649", "Sanchuri\ \-\ RS",
"55483591", "Jacinto\ Machado\ \-\ SC",
"55543601", "Passo\ Fundo\ \-\ RS",
"55353623", "Itajubá\ \-\ MG",
"55663399", "Campo\ Verde\ \-\ MT",
"55844109", "Mossoró\ \-\ RN",
"55193579", "Campinas\ \-\ SP",
"55853048", "Fortaleza\ \-\ CE",
"5528", "Espirito\ Santo",
"55493674", "Mondaí\ \-\ SC",
"55633465", "Itapiratins\ \-\ TO",
"55633364", "Lagoa\ da\ Confusão\ \-\ TO",
"55213668", "São\ João\ de\ Meriti\ \-\ RJ",
"55163254", "Guariroba\ \-\ SP",
"55663463", "Primavera\ do\ Leste\ \-\ MT",
"55773619", "Catolândia\ \-\ BA",
"55493451", "Paial\ \-\ SC",
"55843249", "Espírito\ Santo\ \-\ RN",
"55773441", "Brumado\ \-\ BA",
"55883626", "São\ Benedito\ \-\ CE",
"55513731", "Rio\ Pardo\ \-\ RS",
"55183653", "Penápolis\ \-\ SP",
"55833032", "Santa\ Rita\ \-\ PB",
"55473317", "Indaial\ \-\ SC",
"5571325", "Salvador\ \-\ BA",
"55913744", "Santa\ Isabel\ do\ Pará\ \-\ PA",
"55653613", "Cuiabá\ \-\ MT",
"55512121", "Porto\ Alegre\ \-\ RS",
"55623099", "Anápolis\ \-\ GO",
"55653344", "Jangada\ \-\ MT",
"55623385", "Nova\ Crixás\ \-\ GO",
"55163995", "Ribeirão\ Preto\ \-\ SP",
"55353457", "Heliodora\ \-\ MG",
"55623277", "Aparecida\ de\ Goiânia\ \-\ GO",
"55553785", "Inhacorá\ \-\ RS",
"55633451", "Rio\ Sono\ \-\ TO",
"55114899", "Caieiras\ \-\ SP",
"55463536", "Dois\ Vizinhos\ \-\ PR",
"55133372", "Cubatão\ \-\ SP",
"55493364", "Serra\ Alta\ \-\ SC",
"55163954", "Santa\ Rosa\ de\ Viterbo\ \-\ SP",
"55922121", "Manaus\ \-\ AM",
"55423232", "Castro\ \-\ PR",
"55213584", "Nova\ Iguaçu\ \-\ RJ",
"55643567", "Itumbiara\ \-\ GO",
"55313048", "Belo\ Horizonte\ \-\ MG",
"55222653", "Saquarema\ \-\ RJ",
"55383674", "Cabeceira\ Grande\ \-\ MG",
"55223832", "Rosal\ \-\ RJ",
"55623441", "Catalão\ \-\ GO",
"55112893", "São\ Paulo\ \-\ SP",
"55453028", "Foz\ do\ Iguaçu\ \-\ PR",
"55643956", "Itumbiara\ \-\ GO",
"55222537", "Carmo\ \-\ RJ",
"55663507", "Simione\ \-\ MT",
"5584321", "Natal\ \-\ RN",
"55843321", "Mossoró\ \-\ RN",
"55212005", "Rio\ de\ Janeiro\ \-\ RJ",
"55613434", "Recanto\ das\ Emas\ \-\ DF",
"55173893", "Palestina\ \-\ SP",
"55643639", "Perolândia\ \-\ GO",
"55543435", "Boa\ Vista\ do\ Sul\ \-\ RS",
"55673414", "Vila\ Vargas\ \-\ MS",
"55114497", "Jundiaí\ \-\ SP",
"55283515", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55353863", "Santo\ Antônio\ do\ Amparo\ \-\ MG",
"5551329", "Rio\ Grande\ do\ Sul",
"55353286", "Divisa\ Nova\ \-\ MG",
"55433467", "Rio\ Branco\ do\ Ivaí\ \-\ PR",
"55133822", "Registro\ \-\ SP",
"55313379", "Minas\ Gerais",
"55114062", "São\ Paulo\ \-\ SP",
"55454063", "Cascavel\ \-\ PR",
"55193744", "Campinas\ \-\ SP",
"55623591", "Goiânia\ \-\ GO",
"55823292", "Porto\ Calvo\ \-\ AL",
"55483622", "Tubarão\ \-\ SC",
"55753311", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55663583", "Vera\ \-\ MT",
"5575322", "Feira\ de\ Santana\ \-\ BA",
"55693467", "Rondominas\ \-\ RO",
"55613306", "Brasília\ \-\ DF",
"55773646", "Ipupiara\ \-\ BA",
"55733238", "Itajuípe\ \-\ BA",
"55183702", "Andradina\ \-\ SP",
"55883421", "Aracati\ \-\ CE",
"55493656", "Saltinho\ \-\ SC",
"55333731", "Araçuaí\ \-\ MG",
"55214137", "Nilópolis\ \-\ RJ",
"55983484", "Afonso\ Cunha\ \-\ MA",
"55983622", "Bacabal\ \-\ MA",
"55333232", "Sobrália\ \-\ MG",
"55413058", "São\ José\ dos\ Pinhais\ \-\ PR",
"55534141", "Pelotas\ \-\ RS",
"55453271", "Sede\ Alvorada\ \-\ PR",
"55683303", "Rio\ Branco\ \-\ AC",
"55333296", "Sardoá\ \-\ MG",
"55313754", "Lamim\ \-\ MG",
"55443551", "Iracema\ do\ Oeste\ \-\ PR",
"55413579", "Curitiba\ \-\ PR",
"55163202", "Jaboticabal\ \-\ SP",
"55513387", "Rio\ Grande\ do\ Sul",
"55813114", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55713026", "Lauro\ de\ Freitas\ \-\ BA",
"55553032", "Santa\ Maria\ \-\ RS",
"55143479", "Avencas\ \-\ SP",
"55473525", "Rio\ do\ Sul\ \-\ SC",
"55333268", "Aimorés\ \-\ MG",
"55773688", "Novo\ Paraná\ \-\ BA",
"55543472", "São\ Valentim\ do\ Sul\ \-\ RS",
"55753683", "Humildes\ \-\ BA",
"55473334", "Blumenau\ \-\ SC",
"55963621", "Laranjal\ do\ Jari\ \-\ AP",
"55813863", "Petrolina\ \-\ PE",
"5573", "Bahia",
"55543253", "Jaquirana\ \-\ RS",
"55483441", "Urussanga\ \-\ SC",
"55143262", "Agudos\ \-\ SP",
"55733013", "Teixeira\ de\ Freitas\ \-\ BA",
"55163811", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55533201", "Rio\ Grande\ \-\ RS",
"55883642", "Moraújo\ \-\ CE",
"55193643", "Vargem\ Grande\ do\ Sul\ \-\ SP",
"55373243", "Itaúna\ \-\ MG",
"55983385", "Bequimão\ \-\ MA",
"55383239", "Mirabela\ \-\ MG",
"55443565", "Tuneiras\ do\ Oeste\ \-\ PR",
"55163902", "Ribeirão\ Preto\ \-\ SP",
"55683232", "Senador\ Guiomard\ \-\ AC",
"55153207", "Gramadinho\ \-\ SP",
"55883531", "Brejo\ Santo\ \-\ CE",
"55143761", "Itaí\ \-\ SP",
"55632111", "Palmas\ \-\ TO",
"55483277", "São\ Pedro\ de\ Alcântara\ \-\ SC",
"55753242", "Amélia\ Rodrigues\ \-\ BA",
"55243379", "Angra\ dos\ Reis\ \-\ RJ",
"55313550", "Minas\ Gerais",
"55114038", "Campo\ Limpo\ Paulista\ \-\ SP",
"55123144", "Cruzeiro\ \-\ SP",
"55423275", "Tibagi\ \-\ PR",
"55633478", "Filadélfia\ \-\ TO",
"55343351", "Sacramento\ \-\ MG",
"55213828", "Rio\ de\ Janeiro\ \-\ RJ",
"55973334", "Canutama\ \-\ AM",
"55733262", "Eunápolis\ \-\ BA",
"55313537", "Serra\ Azul\ \-\ MG",
"5531377", "Minas\ Gerais",
"5521301", "Rio\ de\ Janeiro\ \-\ RJ",
"55163976", "Ribeirão\ Preto\ \-\ SP",
"55373424", "Córrego\ Danta\ \-\ MG",
"55383251", "Bocaiúva\ \-\ MG",
"55813743", "Camocim\ de\ São\ Félix\ \-\ PE",
"55473081", "Balneário\ Camboriú\ \-\ SC",
"55623312", "Itapuranga\ \-\ GO",
"55673250", "Corguinho\ \-\ MS",
"55353644", "Piranguinho\ \-\ MG",
"55693346", "Chupinguaia\ \-\ RO",
"55813831", "Serra\ Talhada\ \-\ PE",
"55513468", "Rio\ Grande\ do\ Sul",
"55624101", "Goiânia\ \-\ GO",
"55473453", "Joinville\ \-\ SC",
"55114808", "Jundiaí\ \-\ SP",
"55793443", "Campo\ do\ Brito\ \-\ SE",
"55223054", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55843383", "José\ da\ Penha\ \-\ RN",
"55513522", "Morro\ da\ Pedra\ \-\ RS",
"55813681", "Xexéu\ \-\ PE",
"55143582", "Uru\ \-\ SP",
"55273770", "Colatina\ \-\ ES",
"55643678", "Israelândia\ \-\ GO",
"55683546", "Brasiléia\ \-\ AC",
"55413624", "Agudos\ do\ Sul\ \-\ PR",
"55283528", "Vargem\ Alta\ \-\ ES",
"55163134", "Jeriquara\ \-\ SP",
"55614003", "Brasília\ \-\ DF",
"5554320", "Caxias\ do\ Sul\ \-\ RS",
"55733240", "Gongogi\ \-\ BA",
"55443429", "Diamante\ do\ Norte\ \-\ PR",
"55413482", "Guaraqueçaba\ \-\ PR",
"55183362", "Paraguaçu\ Paulista\ \-\ SP",
"55113159", "São\ Paulo\ \-\ SP",
"55624014", "Anápolis\ \-\ GO",
"55133493", "Praia\ Grande\ \-\ SP",
"55163394", "Matão\ \-\ SP",
"55114718", "Mairinque\ \-\ SP",
"55913482", "Augusto\ Corrêa\ \-\ PA",
"55483879", "Florianópolis\ \-\ SC",
"55863288", "Palmeirais\ \-\ PI",
"55793224", "Aracaju\ \-\ SE",
"55143841", "São\ Manuel\ \-\ SP",
"55193891", "Mogi\-Guaçu\ \-\ SP",
"55423522", "União\ da\ Vitória\ \-\ PR",
"55373690", "Divinópolis\ \-\ MG",
"55463226", "Mariópolis\ \-\ PR",
"55273080", "Serra\ \-\ ES",
"55413047", "Almirante\ Tamandaré\ \-\ PR",
"55273388", "Vila\ Velha\ \-\ ES",
"55973453", "Boca\ do\ Acre\ \-\ AM",
"55883563", "Icó\ \-\ CE",
"55143733", "Avaré\ \-\ SP",
"55883660", "Cruz\ \-\ CE",
"55193562", "Pirassununga\ \-\ SP",
"55883559", "Penaforte\ \-\ CE",
"55493021", "Lages\ \-\ SC",
"55733634", "Ilhéus\ \-\ BA",
"55113603", "Osasco\ \-\ SP",
"55893570", "Baixa\ Grande\ do\ Ribeiro\ \-\ PI",
"55473044", "Brusque\ \-\ SC",
"55153349", "Ibiúna\ \-\ SP",
"55833552", "São\ José\ de\ Piranhas\ \-\ PB",
"55173817", "Severínia\ \-\ SP",
"55313885", "Viçosa\ \-\ MG",
"55883112", "Sobral\ \-\ CE",
"55813644", "Cumaru\ \-\ PE",
"55353743", "Campestre\ \-\ MG",
"55824002", "Maceió\ \-\ AL",
"55115643", "São\ Paulo\ \-\ SP",
"55843611", "Natal\ \-\ RN",
"55493251", "Lages\ \-\ SC",
"55113512", "São\ Paulo\ \-\ SP",
"55893499", "Bela\ Vista\ do\ Piauí\ \-\ PI",
"55114571", "São\ Paulo\ \-\ SP",
"55353831", "Campo\ Belo\ \-\ MG",
"55193538", "Ajapi\ \-\ SP",
"55823280", "Pindoba\ \-\ AL",
"55773477", "Lagoa\ Real\ \-\ BA",
"55713651", "São\ Francisco\ do\ Conde\ \-\ BA",
"55623941", "Goiânia\ \-\ GO",
"55473627", "Canoinhas\ \-\ SC",
"55112707", "São\ Paulo\ \-\ SP",
"55753426", "Rio\ Real\ \-\ BA",
"55713105", "Salvador\ \-\ BA",
"55183606", "Guararapes\ \-\ SP",
"55323556", "São\ Geraldo\ \-\ MG",
"55513432", "Gravataí\ \-\ RS",
"55613234", "Guará\ \-\ DF",
"55222030", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55323267", "São\ João\ Nepomuceno\ \-\ MG",
"55113439", "Santo\ André\ \-\ SP",
"55162137", "Ribeirão\ Preto\ \-\ SP",
"55543235", "Campestre\ da\ Serra\ \-\ RS",
"55612328", "Brasília\ \-\ DF",
"55713287", "Lauro\ de\ Freitas\ \-\ BA",
"55793615", "Simão\ Dias\ \-\ SE",
"55513496", "Gravataí\ \-\ RS",
"55443667", "Santa\ Eliza\ \-\ PR",
"55323749", "Faria\ Lemos\ \-\ MG",
"55733301", "Itabuna\ \-\ BA",
"55423519", "União\ da\ Vitória\ \-\ PR",
"55143884", "Anhembi\ \-\ SP",
"55473393", "Bombinhas\ \-\ SC",
"55243401", "Barra\ Mansa\ \-\ RJ",
"55823542", "São\ Sebastião\ \-\ AL",
"55913723", "Marapanim\ \-\ PA",
"55323322", "Nazareno\ \-\ MG",
"55323379", "São\ João\ Del\ Rei\ \-\ MG",
"55753266", "Araci\ \-\ BA",
"55813236", "Recife\ \-\ PE",
"55434141", "Londrina\ \-\ PR",
"55833309", "São\ José\ dos\ Cordeiros\ \-\ PB",
"55983524", "Imperatriz\ \-\ MA",
"55553271", "Júlio\ de\ Castilhos\ \-\ RS",
"55333744", "Rio\ do\ Prado\ \-\ MG",
"55473059", "São\ Bento\ do\ Sul\ \-\ SC",
"55843361", "Patu\ \-\ RN",
"55733246", "Itapitanga\ \-\ BA",
"55114204", "Araçariguama\ \-\ SP",
"55473384", "Rodeio\ \-\ SC",
"55192121", "Campinas\ \-\ SP",
"55543551", "Machadinho\ \-\ RS",
"55993535", "Pequiá\ \-\ MA",
"55373016", "Divinópolis\ \-\ MG",
"55273776", "Barra\ de\ São\ Francisco\ \-\ ES",
"55193843", "Itapira\ \-\ SP",
"55613591", "Sobradinho\ \-\ DF",
"55373541", "Abaeté\ \-\ MG",
"55153461", "Porto\ Feliz\ \-\ SP",
"55863301", "Teresina\ \-\ PI",
"55893445", "Santa\ Cruz\ do\ Piauí\ \-\ PI",
"55513337", "Rio\ Grande\ do\ Sul",
"55533503", "Bagé\ \-\ RS",
"55713414", "Salvador\ \-\ BA",
"55353373", "Virgínia\ \-\ MG",
"55743619", "Jaguarari\ \-\ BA",
"55312108", "Belo\ Horizonte\ \-\ MG",
"55313869", "Congonhas\ do\ Norte\ \-\ MG",
"55313853", "Bela\ Vista\ de\ Minas\ \-\ MG",
"55473212", "Brusque\ \-\ SC",
"55493535", "Arroio\ Trinta\ \-\ SC",
"55323754", "São\ Francisco\ do\ Glória\ \-\ MG",
"55633535", "Marianópolis\ do\ Tocantins\ \-\ TO",
"55553816", "Condor\ \-\ RS",
"55333415", "Gonzaga\ \-\ MG",
"55483524", "Araranguá\ \-\ SC",
"55793365", "Malhada\ dos\ Bois\ \-\ SE",
"55833258", "João\ Pessoa\ \-\ PB",
"55854117", "Maracanaú\ \-\ CE",
"55933514", "Brasil\ Novo\ \-\ PA",
"55663423", "Rondonópolis\ \-\ MT",
"55883581", "Iguatu\ \-\ CE",
"55463220", "Pato\ Branco\ \-\ PR",
"55623372", "Goiás\ \-\ GO",
"55733288", "Porto\ Seguro\ \-\ BA",
"55353663", "Pedralva\ \-\ MG",
"55123674", "Tremembé\ \-\ SP",
"55163383", "Matão\ \-\ SP",
"55333314", "Ipanema\ \-\ MG",
"55353292", "Alfenas\ \-\ MG",
"55893576", "Cristalândia\ do\ Piauí\ \-\ PI",
"55633425", "Pau\ D\'Arco\ \-\ TO",
"55143004", "Bauru\ \-\ SP",
"55663533", "Sinop\ \-\ MT",
"55483434", "Morro\ da\ Fumaça\ \-\ SC",
"55493289", "Lages\ \-\ SC",
"55473341", "Itajaí\ \-\ SC",
"55823286", "Murici\ \-\ AL",
"55353236", "São\ Bento\ Abade\ \-\ MG",
"55913275", "Ananindeua\ \-\ PA",
"55863582", "São\ Raimundo\ Nonato\ \-\ PI",
"55793351", "Porto\ da\ Folha\ \-\ SE",
"55493425", "Concórdia\ \-\ SC",
"55973485", "Guajará\ \-\ AM",
"55773417", "Guajeru\ \-\ BA",
"55993425", "Jenipapo\ dos\ Vieiras\ \-\ MA",
"55843394", "Frutuoso\ Gomes\ \-\ RN",
"55743622", "Jacobina\ \-\ BA",
"55114511", "Mauá\ \-\ SP",
"55143288", "Bauru\ \-\ SP",
"55843355", "Venha\-Ver\ \-\ RN",
"55113572", "São\ Paulo\ \-\ SP",
"55433901", "Apucarana\ \-\ PR",
"55753420", "Entre\ Rios\ \-\ BA",
"55273048", "Linhares\ \-\ ES",
"55513579", "São\ Leopoldo\ \-\ RS",
"55773662", "Palmas\ de\ Monte\ Alto\ \-\ BA",
"55123131", "São\ José\ dos\ Campos\ \-\ SP",
"55863240", "Cabeceiras\ do\ Piauí\ \-\ PI",
"55153494", "Ibiúna\ \-\ SP",
"55643450", "Marzagão\ \-\ GO",
"55323537", "Paula\ Cândido\ \-\ MG",
"55873858", "Pedra\ \-\ PE",
"55115691", "São\ Paulo\ \-\ SP",
"55383535", "Datas\ \-\ MG",
"55223828", "Boaventura\ \-\ RJ",
"55443253", "Maringá\ \-\ PR",
"55923228", "Manaus\ \-\ AM",
"55883544", "Farias\ Brito\ \-\ CE",
"55513490", "Gravataí\ \-\ RS",
"55493637", "Cristo\ Rei\ \-\ SC",
"55123978", "Jambeiro\ \-\ SP",
"55273362", "Guarapari\ \-\ ES",
"55183872", "Ouro\ Verde\ \-\ SP",
"55614101", "Brasília\ \-\ DF",
"55193588", "Porto\ Ferreira\ \-\ SP",
"5531334", "Minas\ Gerais",
"55483369", "Florianópolis\ \-\ SC",
"55192107", "Indaiatuba\ \-\ SP",
"55313685", "Nova\ União\ \-\ MG",
"55793339", "Santana\ do\ São\ Francisco\ \-\ SE",
"55313835", "Itabira\ \-\ MG",
"55323401", "Leopoldina\ \-\ MG",
"55453211", "Santa\ Maria\ \-\ PR",
"55823257", "Campestre\ \-\ AL",
"55273227", "Vitória\ \-\ ES",
"55913468", "Capitão\ Poço\ \-\ PA",
"55833471", "Malta\ \-\ PB",
"55493553", "Piratuba\ \-\ SC",
"55663561", "Itaúba\ \-\ MT",
"55513047", "Gravataí\ \-\ RS",
"55243322", "Barra\ Mansa\ \-\ RJ",
"55863262", "Altos\ \-\ PI",
"55733684", "Itamaraty\ \-\ BA",
"55653549", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55114273", "Caieiras\ \-\ SP",
"55242291", "Petrópolis\ \-\ RJ",
"55753694", "Santanópolis\ \-\ BA",
"55173462", "Fernandópolis\ \-\ SP",
"55993569", "Senador\ Alexandre\ Costa\ \-\ MA",
"55413468", "Alexandra\ \-\ PR",
"55843276", "Monte\ Alegre\ \-\ RN",
"55993553", "Sucupira\ do\ Riachão\ \-\ MA",
"55673665", "Água\ Clara\ \-\ MS",
"55853322", "Ocara\ \-\ CE",
"55553366", "Itacurubi\ \-\ RS",
"55114168", "Barueri\ \-\ SP",
"55333428", "Santo\ Antônio\ do\ Itambé\ \-\ MG",
"55123159", "Lorena\ \-\ SP",
"55115932", "São\ Paulo\ \-\ SP",
"55112528", "São\ Paulo\ \-\ SP",
"55112279", "Guarulhos\ \-\ SP",
"55513482", "Barra\ do\ Ribeiro\ \-\ RS",
"55654009", "Cuiabá\ \-\ MT",
"55513624", "Santa\ Terezinha\ \-\ RS",
"55993637", "Joselândia\ \-\ MA",
"55543285", "Picada\ Café\ \-\ RS",
"55173279", "Olímpia\ \-\ SP",
"55983353", "Apicum\-Açu\ \-\ MA",
"55483045", "Criciúma\ \-\ SC",
"55543377", "Santo\ Antônio\ do\ Planalto\ \-\ RS",
"55983369", "Santo\ Amaro\ do\ Maranhão\ \-\ MA",
"55163508", "Araraquara\ \-\ SP",
"55673474", "Mundo\ Novo\ \-\ MS",
"5586", "Piauí",
"55153523", "Caputera\ \-\ SP",
"55353844", "Ibituruna\ \-\ MG",
"55413432", "Antonina\ \-\ PR",
"55833015", "João\ Pessoa\ \-\ PB",
"55542104", "Passo\ Fundo\ \-\ RS",
"55114608", "Francisco\ Morato\ \-\ SP",
"55114132", "Pirapora\ do\ Bom\ Jesus\ \-\ SP",
"55423915", "Carambeí\ \-\ PR",
"55143532", "Lins\ \-\ SP",
"55673287", "Porto\ Murtinho\ \-\ MS",
"55813631", "Timbaúba\ \-\ PE",
"55193546", "Cordeirópolis\ \-\ SP",
"55843333", "Apodi\ \-\ RN",
"55823644", "Água\ Branca\ \-\ AL",
"55473031", "Joinville\ \-\ SC",
"55123512", "São\ José\ dos\ Campos\ \-\ SP",
"55273198", "Vitória\ \-\ ES",
"5531380", "Minas\ Gerais",
"55313556", "Mariana\ \-\ MG",
"55513723", "Cachoeira\ do\ Sul\ \-\ RS",
"55853319", "Chorozinho\ \-\ CE",
"55733532", "Itamari\ \-\ BA",
"55313267", "Belo\ Horizonte\ \-\ MG",
"55923215", "Manaus\ \-\ AM",
"5524334", "Volta\ Redonda\ \-\ RJ",
"55873847", "Tabira\ \-\ PE",
"55213224", "Rio\ de\ Janeiro\ \-\ RJ",
"55983217", "São\ Luís\ \-\ MA",
"55663555", "Cotriguaçu\ \-\ MT",
"55543412", "Farroupilha\ \-\ RS",
"55613241", "Olinda\ \-\ PE",
"55143641", "Barra\ Bonita\ \-\ SP",
"55313322", "Minas\ Gerais",
"55813542", "Abreu\ e\ Lima\ \-\ PE",
"55513215", "Rio\ Grande\ do\ Sul",
"55133879", "Barra\ do\ Braço\ \-\ SP",
"55553513", "Santa\ Rosa\ \-\ RS",
"55663594", "Santa\ Cruz\ do\ Xingu\ \-\ MT",
"55823027", "Maceió\ \-\ AL",
"55313749", "Ouro\ Branco\ \-\ MG",
"55193374", "Piracicaba\ \-\ SP",
"55183283", "Euclides\ da\ Cunha\ Paulista\ \-\ SP",
"55773447", "Cordeiros\ \-\ BA",
"55843013", "Natal\ \-\ RN",
"55493457", "Presidente\ Castelo\ Branco\ \-\ SC",
"55123103", "Cachoeira\ Paulista\ \-\ SP",
"55753161", "Feira\ de\ Santana\ \-\ BA",
"55813131", "Recife\ \-\ PE",
"55693581", "Machadinho\ D\'Oeste\ \-\ RO",
"55353364", "Pouso\ Alto\ \-\ MG",
"5584", "Rio\ Grande\ do\ Norte",
"55115041", "São\ Paulo\ \-\ SP",
"55633430", "Carmolândia\ \-\ TO",
"55183866", "Flora\ Rica\ \-\ SP",
"5551357", "Rio\ Grande\ do\ Sul",
"55513737", "Rio\ Grande\ do\ Sul",
"55823033", "Maceió\ \-\ AL",
"55483258", "São\ José\ \-\ SC",
"55333344", "Lajinha\ \-\ MG",
"55953591", "Uiramutã\ \-\ RR",
"55793022", "Aracaju\ \-\ SE",
"55922127", "Manaus\ \-\ AM",
"55114696", "Salesópolis\ \-\ SP",
"55693233", "Triunfo\ \-\ RO",
"55313626", "Ribeirão\ das\ Neves\ \-\ MG",
"55513750", "Vale\ do\ Sol\ \-\ RS",
"5544326", "Maringá\ \-\ PR",
"55633457", "Colméia\ \-\ TO",
"55114882", "Carapicuíba\ \-\ SP",
"55863276", "Piripiri\ \-\ PI",
"55353451", "Silvianópolis\ \-\ MG",
"55884141", "Juazeiro\ do\ Norte\ \-\ CE",
"55323354", "Resende\ Costa\ \-\ MG",
"55633509", "Dianópolis\ \-\ TO",
"55553372", "Santa\ Bárbara\ do\ Sul\ \-\ RS",
"55843693", "Touros\ \-\ RN",
"55883514", "Cariús\ \-\ CE",
"55183642", "Birigui\ \-\ SP",
"55643686", "Moiporá\ \-\ GO",
"55153379", "São\ Miguel\ Arcanjo\ \-\ SP",
"55753435", "Cipó\ \-\ BA",
"55273302", "Aracruz\ \-\ ES",
"55843262", "João\ Câmara\ \-\ RN",
"55843479", "Carnaúba\ dos\ Dantas\ \-\ RN",
"55673521", "Três\ Lagoas\ \-\ MS",
"55114016", "Jarinu\ \-\ SP",
"55323461", "Angustura\ \-\ MG",
"55222531", "Sumidouro\ \-\ RJ",
"55383623", "Januária\ \-\ MG",
"55663501", "Alta\ Floresta\ \-\ MT",
"55843327", "Grossos\ \-\ RN",
"55643594", "Itumbiara\ \-\ GO",
"55673431", "Ponta\ Porã\ \-\ MS",
"55943347", "Eldorado\ dos\ Carajás\ \-\ PA",
"55693544", "Nova\ Mamoré\ \-\ RO",
"55893415", "Picos\ \-\ PI",
"55193813", "Itapira\ \-\ SP",
"55373511", "Divinópolis\ \-\ MG",
"5574361", "Juazeiro\ \-\ BA",
"55153653", "Capão\ Bonito\ \-\ SP",
"55513595", "Novo\ Hamburgo\ \-\ RS",
"55413652", "Rio\ Branco\ do\ Sul\ \-\ PR",
"55693302", "Porto\ Velho\ \-\ RO",
"55543056", "Farroupilha\ \-\ RS",
"55643555", "Avelinópolis\ \-\ GO",
"55112658", "Poá\ \-\ SP",
"55313207", "Belo\ Horizonte\ \-\ MG",
"55843238", "Parnamirim\ \-\ RN",
"55513554", "São\ Leopoldo\ \-\ RS",
"55223022", "Itaperuna\ \-\ RJ",
"55433172", "Arapongas\ \-\ PR",
"55613573", "Brasília\ \-\ DF",
"55653387", "Campos\ de\ Júlio\ \-\ MT",
"55433302", "Londrina\ \-\ PR",
"55153537", "Itapetininga\ \-\ SP",
"55753334", "Lençóis\ \-\ BA",
"55823218", "Maceió\ \-\ AL",
"55993623", "Bom\ Lugar\ \-\ MA",
"55433544", "Santa\ Amélia\ \-\ PR",
"55653275", "Glória\ D\'Oeste\ \-\ MT",
"55313039", "Timóteo\ \-\ MG",
"55114668", "Itapecerica\ da\ Serra\ \-\ SP",
"55123663", "Campos\ do\ Jordão\ \-\ SP",
"55613616", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55342106", "Patos\ de\ Minas\ \-\ MG",
"55212666", "Nova\ Iguaçu\ \-\ RJ",
"55183421", "Assis\ \-\ SP",
"55633397", "Pugmil\ \-\ TO",
"55933544", "Oriximiná\ \-\ PA",
"55493623", "Descanso\ \-\ SC",
"55423554", "Cruz\ Machado\ \-\ PR",
"55833434", "Guarabira\ \-\ PB",
"55383724", "Presidente\ Juscelino\ \-\ MG",
"55434004", "Londrina\ \-\ PR",
"55473242", "Pomerode\ \-\ SC",
"55533283", "Pelotas\ \-\ RS",
"55793252", "Aracaju\ \-\ SE",
"55633520", "Nova\ Rosalândia\ \-\ TO",
"55214007", "Rio\ de\ Janeiro\ \-\ RJ",
"55814062", "Recife\ \-\ PE",
"55643648", "Itajá\ \-\ GO",
"55273233", "Vitória\ \-\ ES",
"55743649", "Uibaí\ \-\ BA",
"55115908", "São\ Paulo\ \-\ SP",
"55353465", "Monte\ Sião\ \-\ MG",
"55713444", "Salvador\ \-\ BA",
"55733270", "Itabela\ \-\ BA",
"55483028", "Florianópolis\ \-\ SC",
"55213899", "Rio\ de\ Janeiro\ \-\ RJ",
"55922101", "Manaus\ \-\ AM",
"55163246", "Taiúva\ \-\ SP",
"55313809", "Santa\ Bárbara\ \-\ MG",
"55213789", "Mangaratiba\ \-\ RJ",
"55473536", "Petrolândia\ \-\ SC",
"55983471", "Chapadinha\ \-\ MA",
"55483247", "São\ José\ \-\ SC",
"55183788", "Murutinga\ do\ Sul\ \-\ SP",
"55753272", "Tucano\ \-\ BA",
"55193516", "Campinas\ \-\ SP",
"55453284", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55913756", "Moju\ \-\ PA",
"55423245", "Socavão\ \-\ PR",
"55414009", "Curitiba\ \-\ PR",
"55633448", "Babaçulândia\ \-\ TO",
"55512101", "Porto\ Alegre\ \-\ RS",
"55273762", "Conceição\ da\ Barra\ \-\ ES",
"55493448", "Arabutã\ \-\ SC",
"55773458", "Brumado\ \-\ BA",
"55653356", "Rosário\ Oeste\ \-\ MT",
"55753469", "Cícero\ Dantas\ \-\ BA",
"55173295", "Monte\ Aprazível\ \-\ SP",
"55843634", "Ceará\-Mirim\ \-\ RN",
"55753453", "Itanagra\ \-\ BA",
"55173254", "Mirassol\ \-\ SP",
"55673463", "Juti\ \-\ MS",
"5531374", "Minas\ Gerais",
"55823343", "Maceió\ \-\ AL",
"55163946", "Sertãozinho\ \-\ SP",
"55743552", "Campo\ Formoso\ \-\ BA",
"55273261", "Guarapari\ \-\ ES",
"55893538", "Colônia\ do\ Gurguéia\ \-\ PI",
"55212025", "Rio\ de\ Janeiro\ \-\ RJ",
"55553543", "Tuparendi\ \-\ RS",
"55313719", "Minas\ Gerais",
"55663527", "Nova\ União\ \-\ MT",
"55843301", "Natal\ \-\ RN",
"55833369", "Arara\ \-\ PB",
"55813512", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55193499", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"5561332", "Brasília\ \-\ DF",
"5519375", "Campinas\ \-\ SP",
"55833353", "Sumé\ \-\ PB",
"55513945", "Gravataí\ \-\ RS",
"55873817", "Alagoinha\ \-\ PE",
"55422101", "Ponta\ Grossa\ \-\ PR",
"55623366", "Mara\ Rosa\ \-\ GO",
"55454101", "Cascavel\ \-\ PR",
"55923245", "Manaus\ \-\ AM",
"55114264", "Francisco\ Morato\ \-\ SP",
"55123631", "Taubaté\ \-\ SP",
"55433255", "Rolândia\ \-\ PR",
"55243065", "Petrópolis\ \-\ RJ",
"55353529", "Passos\ \-\ MG",
"55883672", "Nova\ Russas\ \-\ CE",
"55193673", "Tambaú\ \-\ SP",
"55373273", "Onça\ de\ Pitangui\ \-\ MG",
"55553798", "Rodeio\ Bonito\ \-\ RS",
"55893562", "Bom\ Jesus\ \-\ PI",
"55273255", "Viana\ \-\ ES",
"55242452", "Valença\ \-\ RJ",
"55973426", "Japurá\ \-\ AM",
"55843240", "Montanhas\ \-\ RN",
"55483654", "Santa\ Rosa\ de\ Lima\ \-\ SC",
"55693025", "Porto\ Velho\ \-\ RO",
"55623398", "Itaguaru\ \-\ GO",
"55453241", "Cafelândia\ \-\ PR",
"55443209", "Nova\ Esperança\ \-\ PR",
"55423323", "Ponta\ Grossa\ \-\ PR",
"55983015", "São\ Luís\ \-\ MA",
"55313820", "Minas\ Gerais",
"55943358", "Canaã\ dos\ Carajás\ \-\ PA",
"5531331", "Minas\ Gerais",
"55133854", "Cajati\ \-\ SP",
"5511348", "São\ Paulo\ \-\ SP",
"55112647", "São\ Paulo\ \-\ SP",
"55893428", "Santa\ Rosa\ do\ Piauí\ \-\ PI",
"55193363", "Paulínia\ \-\ SP",
"55833493", "Boa\ Ventura\ \-\ PB",
"55163111", "Franca\ \-\ SP",
"55183746", "Pereira\ Barreto\ \-\ SP",
"55414020", "Curitiba\ \-\ PR",
"55663437", "Campinápolis\ \-\ MT",
"55613504", "Cristalina\ \-\ GO",
"55222559", "São\ Sebastião\ do\ Alto\ \-\ RJ",
"55923323", "Pitinga\ \-\ AM",
"55643657", "Bom\ Jardim\ de\ Goiás\ \-\ GO",
"55313722", "Queluzito\ \-\ MG",
"55623513", "Nerópolis\ \-\ GO",
"55513697", "Brochier\ \-\ RS",
"55853051", "Fortaleza\ \-\ CE",
"55484107", "Palhoça\ \-\ SC",
"55343413", "São\ Francisco\ de\ Sales\ \-\ MG",
"55643533", "Itumbiara\ \-\ GO",
"55452105", "Foz\ do\ Iguaçu\ \-\ PR",
"55983654", "Santa\ Luzia\ \-\ MA",
"55833217", "Santa\ Rita\ \-\ PB",
"55473426", "Joinville\ \-\ SC",
"55553234", "Vila\ Nova\ do\ Sul\ \-\ RS",
"55753627", "Sapeaçu\ \-\ BA",
"55114736", "Mogi\ das\ Cruzes\ \-\ SP",
"55373213", "Divinópolis\ \-\ MG",
"55152108", "Tietê\ \-\ SP",
"55493905", "Chapecó\ \-\ SC",
"55653337", "Diamantino\ \-\ MT",
"55183302", "Assis\ \-\ SP",
"55873877", "Floresta\ \-\ PE",
"55733043", "Itabuna\ \-\ BA",
"55333331", "Manhuaçu\ \-\ MG",
"55212642", "Teresópolis\ \-\ RJ",
"55823131", "Maceió\ \-\ AL",
"55473633", "São\ Bento\ do\ Sul\ \-\ SC",
"55222106", "Macaé\ \-\ RJ",
"55483411", "Criciúma\ \-\ SC",
"55613271", "Belo\ Horizonte\ \-\ MG",
"55543717", "Nova\ Prata\ \-\ RS",
"55193502", "Rio\ Claro\ \-\ SP",
"55133849", "Iguape\ \-\ SP",
"55843288", "Passa\ e\ Fica\ \-\ RN",
"55143355", "Manduri\ \-\ SP",
"55713521", "Salvador\ \-\ BA",
"55115034", "São\ Paulo\ \-\ SP",
"55673481", "Amambaí\ \-\ MS",
"55313779", "Sete\ Lagoas\ \-\ MG",
"55813033", "Recife\ \-\ PE",
"55473557", "Imbuia\ \-\ SC",
"55793547", "Arauá\ \-\ SE",
"55313395", "Contagem\ \-\ MG",
"55513408", "Rio\ Grande\ do\ Sul",
"55123863", "Maresias\ \-\ SP",
"55693421", "Ji\-Paraná\ \-\ RO",
"55114534", "Itatiba\ \-\ SP",
"55183376", "Cruzália\ \-\ SP",
"55453306", "Cascavel\ \-\ PR",
"55713605", "Candeias\ \-\ BA",
"55833622", "Capim\ \-\ PB",
"55213252", "Rio\ de\ Janeiro\ \-\ RJ",
"55193576", "Ipeúna\ \-\ SP",
"55183698", "Lavínia\ \-\ SP",
"55863383", "Esperantina\ \-\ PI",
"55833484", "Juru\ \-\ PB",
"55614063", "Brasília\ \-\ DF",
"55213699", "Queimados\ \-\ RJ",
"55733671", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55433531", "Santa\ Mariana\ \-\ PR",
"55843246", "Pipa\ \-\ RN",
"55833277", "Pirpirituba\ \-\ PB",
"55883629", "Novo\ Oriente\ \-\ CE",
"55773616", "Formosa\ do\ Rio\ Preto\ \-\ BA",
"55183581", "Flórida\ Paulista\ \-\ SP",
"55753341", "João\ Amaro\ \-\ BA",
"55133258", "Santos\ \-\ SP",
"55833385", "Cubati\ \-\ PB",
"55243354", "Resende\ \-\ RJ",
"55623096", "Goiânia\ \-\ GO",
"55423652", "Boa\ Ventura\ de\ São\ Roque\ \-\ PR",
"55343252", "Ipiaçu\ \-\ MG",
"55833099", "Campina\ Grande\ \-\ PB",
"55513787", "Pinheiral\ \-\ RS",
"55623573", "Goiânia\ \-\ GO",
"55173249", "Potirendaba\ \-\ SP",
"55114682", "Juquitiba\ \-\ SP",
"55443607", "São\ Tomé\ \-\ PR",
"55543347", "Casca\ \-\ RS",
"55313826", "Minas\ Gerais",
"55114424", "Santo\ André\ \-\ SP",
"55673444", "Taquarussu\ \-\ MS",
"55463539", "Doutor\ Antônio\ Paranhos\ \-\ PR",
"55283545", "Iúna\ \-\ ES",
"55413554", "Quatro\ Barras\ \-\ PR",
"55163301", "Araraquara\ \-\ SP",
"55853461", "Fortaleza\ \-\ CE",
"55713431", "Salvador\ \-\ BA",
"55143495", "Tupã\ \-\ SP",
"55183842", "Junqueirópolis\ \-\ SP",
"55743258", "Baixa\ Grande\ \-\ BA",
"55163171", "Pedregulho\ \-\ SP",
"55663903", "Alta\ Floresta\ \-\ MT",
"55213765", "Mesquita\ \-\ RJ",
"5517321", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55443056", "Umuarama\ \-\ PR",
"55693642", "São\ Miguel\ do\ Guaporé\ \-\ RO",
"55443460", "Tamboara\ \-\ PR",
"55653928", "Cuiabá\ \-\ MT",
"55143454", "Marília\ \-\ SP",
"55533310", "Pelotas\ \-\ RS",
"55513652", "Butiá\ \-\ RS",
"55112321", "São\ Paulo\ \-\ SP",
"55113659", "Osasco\ \-\ SP",
"55222666", "São\ Vicente\ de\ Paula\ \-\ RJ",
"5521262", "Niterói\ \-\ RJ",
"55143361", "Botucatu\ \-\ SP",
"55833441", "Catolé\ do\ Rocha\ \-\ PB",
"55513077", "Canoas\ \-\ RS",
"55933531", "Medicilândia\ \-\ PA",
"55193804", "Mogi\ Mirim\ \-\ SP",
"55383823", "Riacho\ dos\ Machados\ \-\ MG",
"55653228", "Lambari\ D\'Oeste\ \-\ MT",
"55114243", "Cotia\ \-\ SP",
"55643636", "Jataí\ \-\ GO",
"55443442", "Guairaçá\ \-\ PR",
"55113304", "São\ Paulo\ \-\ SP",
"55183261", "Ribeirão\ dos\ Índios\ \-\ SP",
"55333516", "Capelinha\ \-\ MG",
"55123027", "São\ José\ dos\ Campos\ \-\ SP",
"55424009", "Ponta\ Grossa\ \-\ PR",
"55453543", "Vila\ Ipiranga\ \-\ PR",
"55843641", "Natal\ \-\ RN",
"55513549", "Igrejinha\ \-\ RS",
"55353713", "Poços\ de\ Caldas\ \-\ MG",
"55813343", "Recife\ \-\ PE",
"55114593", "Itupeva\ \-\ SP",
"55222762", "Macaé\ \-\ RJ",
"55313523", "Sítio\ Novo\ \-\ MG",
"55173847", "Floreal\ \-\ SP",
"55513756", "Anta\ Gorda\ \-\ RS",
"55533255", "Pedro\ Osório\ \-\ RS",
"55493436", "Faxinal\ dos\ Guedes\ \-\ SC",
"55433563", "Tomazina\ \-\ PR",
"55553312", "Santo\ Ângelo\ \-\ RS",
"55883574", "Barbalha\ \-\ CE",
"55433559", "Joaquim\ Távora\ \-\ PR",
"55433660", "Lupionópolis\ \-\ PR",
"55353225", "Carmo\ da\ Cachoeira\ \-\ MG",
"55863216", "Teresina\ \-\ PI",
"5562332", "Anápolis\ \-\ GO",
"55313153", "Sete\ Lagoas\ \-\ MG",
"55514009", "Porto\ Alegre\ \-\ RS",
"55653624", "Cuiabá\ \-\ MT",
"55114786", "Taboão\ da\ Serra\ \-\ SP",
"55532128", "Pelotas\ \-\ RS",
"55454003", "Foz\ do\ Iguaçu\ \-\ PR",
"55933559", "Trairão\ \-\ PA",
"55643680", "Nazário\ \-\ GO",
"55893546", "Bertolínia\ \-\ PI",
"55813094", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55643931", "Itumbiara\ \-\ GO",
"55933563", "Curuá\ \-\ PA",
"55613458", "Samambaia\ Sul\ \-\ DF",
"55473371", "Jaraguá\ do\ Sul\ \-\ SC",
"55793645", "Boquim\ \-\ SE",
"55473655", "Major\ Vieira\ \-\ SC",
"55924009", "Manaus\ \-\ AM",
"55843532", "Lajes\ \-\ RN",
"5551351", "Rio\ Grande\ do\ Sul",
"55323051", "Barbacena\ \-\ MG",
"55213845", "Duque\ de\ Caxias\ \-\ RJ",
"5513336", "Cubatão\ \-\ SP",
"55993492", "Lagoa\ do\ Mato\ \-\ MA",
"55383526", "Carbonita\ \-\ MG",
"55743654", "Barra\ do\ Mendes\ \-\ BA",
"55112599", "São\ Paulo\ \-\ SP",
"551932", "Campinas\ \-\ SP",
"55613366", "Brasília\ \-\ DF",
"55953543", "Iracema\ \-\ RR",
"55443621", "Umuarama\ \-\ PR",
"55753031", "Alagoinhas\ \-\ BA",
"55353343", "Baependi\ \-\ MG",
"55333084", "Governador\ Valadares\ \-\ MG",
"55433316", "Arapongas\ \-\ PR",
"55843422", "Mossoró\ \-\ RN",
"55543358", "Lagoa\ Vermelha\ \-\ RS",
"55153267", "Capela\ do\ Alto\ \-\ SP",
"55983326", "Presidente\ Médici\ \-\ MA",
"55153556", "Iporanga\ \-\ SP",
"55453234", "Catanduvas\ \-\ PR",
"55543037", "Carlos\ Barbosa\ \-\ RS",
"55913017", "Ananindeua\ \-\ PA",
"55553742", "Palmeira\ das\ Missões\ \-\ RS",
"55273129", "Guarapari\ \-\ ES",
"55733202", "Barra\ do\ Rocha\ \-\ BA",
"55343845", "Iraí\ de\ Minas\ \-\ MG",
"55693316", "Vilhena\ \-\ RO",
"55163761", "Batatais\ \-\ SP",
"55213175", "Nilópolis\ \-\ RJ",
"55744400", "Pilão\ Arcado\ \-\ BA",
"55143276", "Bauru\ \-\ SP",
"55553329", "Entre\ Ijuís\ \-\ RS",
"55623342", "Ipiranga\ de\ Goiás\ \-\ GO",
"55123681", "Taubaté\ \-\ SP",
"55823278", "Tanque\ D\'Arca\ \-\ AL",
"55823529", "Arapiraca\ \-\ AL",
"55493526", "Jaborá\ \-\ SC",
"55553241", "Santana\ do\ Livramento\ \-\ RS",
"55463565", "Flor\ da\ Serra\ do\ Sul\ \-\ PR",
"55163693", "Jardinópolis\ \-\ SP",
"55183255", "Rancharia\ \-\ SP",
"55313433", "Belo\ Horizonte\ \-\ MG",
"55163262", "Itápolis\ \-\ SP",
"55633352", "Crixás\ do\ Tocantins\ \-\ TO",
"55143811", "Botucatu\ \-\ SP",
"55913323", "Belém\ \-\ PA",
"55323722", "Muriaé\ \-\ MG",
"55183994", "Emilianópolis\ \-\ SP",
"55312571", "Betim\ \-\ MG",
"55733276", "Apuarema\ \-\ BA",
"55793297", "Siriri\ \-\ SE",
"55123957", "São\ Silvestre\ \-\ SP",
"55533261", "Jaguarão\ \-\ RS",
"5511352", "São\ Paulo\ \-\ SP",
"55893588", "Anísio\ de\ Abreu\ \-\ PI",
"55143202", "Bauru\ \-\ SP",
"55273746", "Alto\ Rio\ Novo\ \-\ ES",
"55193873", "Sumaré\ \-\ SP",
"55533025", "Pelotas\ \-\ RS",
"55893475", "Novo\ Oriente\ do\ Piauí\ \-\ PI",
"55513363", "Rio\ Grande\ do\ Sul",
"55473358", "Witmarsum\ \-\ SC",
"55613471", "Ceilândia\ \-\ DF",
"55133513", "Santos\ \-\ SP",
"55793348", "Japoatã\ \-\ SE",
"55923084", "Manaus\ \-\ AM",
"55843488", "Cerro\ Corá\ \-\ RN",
"55753667", "Nossa\ Senhora\ da\ Ajuda\ \-\ BA",
"55813637", "Aliança\ \-\ PE",
"55473050", "Camboriú\ \-\ SC",
"55413873", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55923363", "Manaquiri\ \-\ AM",
"55193017", "Indaiatuba\ \-\ SP",
"55313762", "Conselheiro\ Lafaiete\ \-\ MG",
"55383631", "São\ Francisco\ \-\ MG",
"55834101", "Campina\ Grande\ \-\ PB",
"55813887", "Orocó\ \-\ PE",
"55153388", "Sorocaba\ \-\ SP",
"55743676", "Quixabeira\ \-\ BA",
"55813553", "Amaraji\ \-\ PE",
"55483211", "Florianópolis\ \-\ SC",
"55313261", "Belo\ Horizonte\ \-\ MG",
"55833284", "Caldas\ Brandão\ \-\ PB",
"55313860", "Minas\ Gerais",
"55714113", "Lauro\ de\ Freitas\ \-\ BA",
"55943426", "Xinguara\ \-\ PA",
"55343336", "Uberaba\ \-\ MG",
"55873841", "Sertânia\ \-\ PE",
"55133398", "Guarujá\ \-\ SP",
"55893468", "Aroazes\ \-\ PI",
"55163877", "Ribeirão\ Preto\ \-\ SP",
"55823265", "Pilar\ \-\ AL",
"5599352", "Imperatriz\ \-\ MA",
"55513774", "Ilópolis\ \-\ RS",
"55893522", "Floriano\ \-\ PI",
"55663026", "Rondonópolis\ \-\ MT",
"55273051", "Serra\ \-\ ES",
"55883556", "Catarina\ \-\ CE",
"55433051", "Rolândia\ \-\ PR",
"55963212", "Macapá\ \-\ AP",
"55863321", "Parnaíba\ \-\ PI",
"55623326", "Jaraguá\ \-\ GO",
"55493631", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55353553", "Juruaia\ \-\ MG",
"55993542", "Balsas\ \-\ MA",
"55192101", "Campinas\ \-\ SP",
"554132", "Curitiba\ \-\ PR",
"55893432", "Cajazeiras\ do\ Piauí\ \-\ PI",
"55883685", "Ipueiras\ \-\ CE",
"55733254", "Gandu\ \-\ BA",
"55513041", "Cachoeirinha\ \-\ RS",
"55893496", "São\ Francisco\ de\ Assis\ do\ Piauí\ \-\ PI",
"55623552", "Guapó\ \-\ GO",
"55833477", "Livramento\ \-\ PB",
"55823251", "Matriz\ de\ Camaragibe\ \-\ AL",
"55733295", "Itanhém\ \-\ BA",
"55743162", "Juazeiro\ \-\ BA",
"55273065", "Serra\ \-\ ES",
"55483342", "Palhoça\ \-\ SC",
"55413034", "Piraquara\ \-\ PR",
"55633542", "Silvanópolis\ \-\ TO",
"55753285", "Rodelas\ \-\ BA",
"55183609", "Araçatuba\ \-\ SP",
"55273722", "Colatina\ \-\ ES",
"5511407", "Diadema\ \-\ SP",
"55513673", "Mostardas\ \-\ RS",
"55443536", "Brasiliana\ \-\ PR",
"55753429", "Conde\ \-\ BA",
"55873884", "São\ José\ do\ Belmonte\ \-\ PE",
"55323559", "Visconde\ do\ Rio\ Branco\ \-\ MG",
"55114443", "Franco\ da\ Rocha\ \-\ SP",
"55212722", "Niterói\ \-\ RJ",
"55113436", "Guarulhos\ \-\ SP",
"55993631", "São\ Luís\ Gonzaga\ do\ Maranhão\ \-\ MA",
"55313738", "São\ Brás\ do\ Suaçuí\ \-\ MG",
"55513499", "Eldorado\ do\ Sul\ \-\ RS",
"55323746", "Espera\ Feliz\ \-\ MG",
"55143295", "Boracéia\ \-\ SP",
"55493304", "Chapecó\ \-\ SC",
"55312128", "Belo\ Horizonte\ \-\ MG",
"55423516", "Rio\ Claro\ do\ Sul\ \-\ PR",
"55923673", "Manaus\ \-\ AM",
"55115852", "São\ Paulo\ \-\ SP",
"55163515", "Ribeirão\ Preto\ \-\ SP",
"55863249", "São\ Miguel\ do\ Tapuio\ \-\ PI",
"559132", "Belém\ \-\ PA",
"55543371", "Marau\ \-\ RS",
"55493542", "Erval\ Velho\ \-\ SC",
"55633659", "Ponte\ Alta\ do\ Bom\ Jesus\ \-\ TO",
"55353856", "Guapé\ \-\ MG",
"55493236", "Urupema\ \-\ SC",
"55183354", "Platina\ \-\ SP",
"55313376", "Belo\ Horizonte\ \-\ MG",
"55653314", "Cuiabá\ \-\ MT",
"55314004", "Belo\ Horizonte\ \-\ MG",
"55443242", "Floraí\ \-\ PR",
"55873794", "Ibirajuba\ \-\ PE",
"55473347", "Piçarras\ \-\ SC",
"55193554", "Leme\ \-\ SP",
"55773411", "Ibitira\ \-\ BA",
"55222779", "Conceição\ de\ Macabu\ \-\ RJ",
"55114145", "Itapevi\ \-\ SP",
"55313544", "Betim\ \-\ MG",
"55643431", "Itumbiara\ \-\ GO",
"55913445", "Santa\ Luzia\ do\ Pará\ \-\ PA",
"55112970", "Barueri\ \-\ SP",
"55314111", "Belo\ Horizonte\ \-\ MG",
"55343511", "Patrocínio\ \-\ MG",
"55193124", "Piracicaba\ \-\ SP",
"55813535", "Moreno\ \-\ PE",
"55993663", "Presidente\ Dutra\ \-\ MA",
"55323283", "Rio\ Preto\ \-\ MG",
"55333299", "Açucena\ \-\ MG",
"55443683", "Doutor\ Oliveira\ Castro\ \-\ PR",
"55323531", "Ubá\ \-\ MG",
"55513703", "Rio\ Grande\ do\ Sul",
"55713636", "Vera\ Cruz\ \-\ BA",
"5531382", "Ipatinga\ \-\ MG",
"55122134", "São\ José\ dos\ Campos\ \-\ SP",
"55793213", "Aracaju\ \-\ SE",
"55313842", "Coronel\ Fabriciano\ \-\ MG",
"55413576", "Curitiba\ \-\ PR",
"55553277", "São\ Martinho\ da\ Serra\ \-\ RS",
"55673686", "Bonito\ \-\ MS",
"55713029", "Lauro\ de\ Freitas\ \-\ BA",
"55383663", "Buritis\ \-\ MG",
"55243302", "Petrópolis\ \-\ RJ",
"55843367", "Paraú\ \-\ RN",
"55143476", "Campos\ Novos\ Paulista\ \-\ SP",
"55323421", "Cataguases\ \-\ MG",
"55192127", "Campinas\ \-\ SP",
"55543266", "Santa\ Lúcia\ do\ Piaí\ \-\ RS",
"55843222", "Natal\ \-\ RN",
"55943311", "Parauapebas\ \-\ PA",
"55853376", "Guaiúba\ \-\ CE",
"55153467", "Capela\ do\ Alto\ \-\ SP",
"55643521", "Itumbiara\ \-\ GO",
"55383236", "Juramento\ \-\ MG",
"55613597", "Taguatinga\ \-\ DF",
"55913344", "Belém\ \-\ PA",
"55534052", "Pelotas\ \-\ RS",
"55833564", "Poço\ de\ José\ de\ Moura\ \-\ PB",
"55313581", "Nova\ Lima\ \-\ MG",
"55513191", "Portão\ \-\ RS",
"5587", "Pernambuco",
"55433626", "Jundiaí\ do\ Sul\ \-\ PR",
"55633373", "Almas\ \-\ TO",
"55143402", "Marília\ \-\ SP",
"55513604", "Rio\ Grande\ do\ Sul",
"556733", "Campo\ Grande\ \-\ MS",
"55244004", "Petrópolis\ \-\ RJ",
"5544322", "Maringá\ \-\ PR",
"55443311", "Jardim\ Olinda\ \-\ PR",
"55353535", "São\ Tomás\ de\ Aquino\ \-\ MG",
"55343088", "Uberlândia\ \-\ MG",
"55193852", "Pedreira\ \-\ SP",
"55853302", "Apuiarés\ \-\ CE",
"55313233", "Minas\ Gerais",
"55133271", "Santos\ \-\ SP",
"55873761", "Garanhuns\ \-\ PE",
"55883587", "Juazeiro\ do\ Norte\ \-\ CE",
"55163979", "Ribeirão\ Preto\ \-\ SP",
"55115787", "São\ Paulo\ \-\ SP",
"55413908", "Curitiba\ \-\ PR",
"5511356", "São\ Paulo\ \-\ SP",
"55313370", "Minas\ Gerais",
"55112811", "Salto\ \-\ SP",
"55682101", "Rio\ Branco\ \-\ AC",
"55883635", "Irauçuba\ \-\ CE",
"55313078", "Belo\ Horizonte\ \-\ MG",
"55173811", "Nova\ Aliança\ \-\ SP",
"55353251", "Cambuquira\ \-\ MG",
"55823553", "Porto\ Real\ do\ Colégio\ \-\ AL",
"55463525", "Marmeleiro\ \-\ PR",
"55493257", "Frei\ Rogério\ \-\ SC",
"55893482", "Simplício\ Mendes\ \-\ PI",
"55493566", "Videira\ \-\ SC",
"55433433", "Ariranha\ do\ Ivaí\ \-\ PR",
"55173202", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55533921", "Pelotas\ \-\ RS",
"55143307", "Ibirarema\ \-\ SP",
"55114577", "Mauá\ \-\ SP",
"55713118", "Salvador\ \-\ BA",
"55473621", "Canoinhas\ \-\ SC",
"55833543", "Aparecida\ \-\ PB",
"55323025", "Juiz\ de\ Fora\ \-\ MG",
"55843279", "Extremoz\ \-\ RN",
"55773471", "Paramirim\ \-\ BA",
"55333323", "Ubaporanga\ \-\ MG",
"55553369", "São\ Pedro\ do\ Butiá\ \-\ RS",
"55323261", "São\ João\ Nepomuceno\ \-\ MG",
"55212153", "Rio\ de\ Janeiro\ \-\ RJ",
"55163721", "Franca\ \-\ SP",
"55123156", "Piquete\ \-\ SP",
"55913774", "São\ Francisco\ do\ Pará\ \-\ PA",
"55553353", "Guarani\ das\ Missões\ \-\ RS",
"55653374", "Cangas\ \-\ MT",
"55873834", "Poção\ \-\ PE",
"55713533", "Salvador\ \-\ BA",
"55813021", "Paulista\ \-\ PE",
"55813265", "Recife\ \-\ PE",
"55753235", "Candeal\ \-\ BA",
"55653691", "Várzea\ Grande\ \-\ MT",
"55173276", "Engenheiro\ Balduíno\ \-\ SP",
"55133342", "Guarujá\ \-\ SP",
"55133211", "Santos\ \-\ SP",
"55332101", "Governador\ Valadares\ \-\ MG",
"55323294", "Bocaina\ de\ Minas\ \-\ MG",
"55983398", "Cedral\ \-\ MA",
"55473087", "Brusque\ \-\ SC",
"55883401", "Limoeiro\ do\ Norte\ \-\ CE",
"55183722", "Andradina\ \-\ SP",
"55493313", "Chapecó\ \-\ SC",
"55114815", "Jundiaí\ \-\ SP",
"55183349", "Frutal\ do\ Campo\ \-\ SP",
"55543536", "Caxias\ do\ Sul\ \-\ RS",
"55413673", "Piraquara\ \-\ PR",
"55242404", "Angra\ dos\ Reis\ \-\ RJ",
"55513034", "Sapucaia\ do\ Sul\ \-\ RS",
"55212609", "Niterói\ \-\ RJ",
"55323255", "Ewbank\ da\ Câmara\ \-\ MG",
"55773695", "Tanque\ Novo\ \-\ BA",
"55673231", "Corumbá\ \-\ MS",
"55813687", "Bonito\ \-\ PE",
"55443655", "Cafezal\ do\ Sul\ \-\ PR",
"55383831", "Porteirinha\ \-\ MG",
"55193549", "Mogi\ Mirim\ \-\ SP",
"55493644", "Dionísio\ Cerqueira\ \-\ SC",
"55933523", "Santarém\ \-\ PA",
"55623015", "Goiânia\ \-\ GO",
"55543260", "Caravaggio\ \-\ RS",
"55843438", "Tenente\ Laurentino\ Cruz\ \-\ RN",
"55383743", "Pirapora\ \-\ MG",
"55613552", "Núcleo\ Bandeirante\ \-\ DF",
"55473442", "São\ Francisco\ do\ Sul\ \-\ SC",
"55313660", "Pedro\ Leopoldo\ \-\ MG",
"55313559", "Ouro\ Preto\ \-\ MG",
"55353021", "Passos\ \-\ MG",
"55243370", "Angra\ dos\ Reis\ \-\ RJ",
"555132", "Porto\ Alegre\ \-\ RS",
"55113448", "Osasco\ \-\ SP",
"55313563", "Itabirito\ \-\ MG",
"55353265", "Três\ Pontas\ \-\ MG",
"55114705", "Santana\ de\ Parnaíba\ \-\ SP",
"55433523", "Cornélio\ Procópio\ \-\ PR",
"55993644", "Lago\ da\ Pedra\ \-\ MA",
"55693523", "Theobroma\ \-\ RO",
"55143847", "Itatinga\ \-\ SP",
"55193897", "Hortolândia\ \-\ SP",
"55143416", "Jaú\ \-\ SP",
"55183221", "Presidente\ Prudente\ \-\ SP",
"55194009", "Campinas\ \-\ SP",
"55313746", "Piranga\ \-\ MG",
"555139", "Rio\ Grande\ do\ Sul",
"55333245", "Divino\ das\ Laranjeiras\ \-\ MG",
"55443014", "Marialva\ \-\ PR",
"55483090", "São\ José\ \-\ SC",
"55413041", "Curitiba\ \-\ PR",
"55873783", "Caetés\ \-\ PE",
"55833306", "Coxixola\ \-\ PB",
"55493248", "Ponte\ Alta\ \-\ SC",
"55513381", "Rio\ Grande\ do\ Sul",
"55713594", "Simões\ Filho\ \-\ BA",
"55323376", "São\ Tiago\ \-\ MG",
"55213213", "Rio\ de\ Janeiro\ \-\ RJ",
"55753269", "Riachão\ do\ Jacuípe\ \-\ BA",
"55793046", "Aracaju\ \-\ SE",
"55873893", "Itacuruba\ \-\ PE",
"55143321", "Bauru\ \-\ SP",
"55473056", "Balneário\ Camboriú\ \-\ SC",
"55513714", "Lajeado\ \-\ RS",
"55713555", "Salvador\ \-\ BA",
"5512393", "São\ José\ dos\ Campos\ \-\ SP",
"55653268", "Vale\ de\ São\ Domingos\ \-\ MT",
"55173361", "Monte\ Azul\ Paulista\ \-\ SP",
"55813656", "Orobó\ \-\ PE",
"55553335", "Eugênio\ de\ Castro\ \-\ RS",
"55733249", "Barro\ Preto\ \-\ BA",
"5543337", "Londrina\ \-\ PR",
"55983271", "São\ Luís\ \-\ MA",
"55553524", "Crissiumal\ \-\ RS",
"55483447", "Cocal\ do\ Sul\ \-\ SC",
"55213913", "Itaboraí\ \-\ RJ",
"55273395", "Vitória\ \-\ ES",
"55483271", "Florianópolis\ \-\ SC",
"55833372", "Cuité\ \-\ PB",
"55833638", "Nova\ Palmeira\ \-\ PB",
"55243421", "Angra\ dos\ Reis\ \-\ RJ",
"55143767", "Coronel\ Macedo\ \-\ SP",
"55883537", "Salitre\ \-\ CE",
"55313866", "Dom\ Joaquim\ \-\ MG",
"55273354", "Viana\ \-\ ES",
"55823535", "Olho\ d\'Água\ Grande\ \-\ AL",
"55883669", "Vila\ de\ Jericoacoara\ \-\ CE",
"55193652", "Aguaí\ \-\ SP",
"55713648", "Dias\ d\'Ávila\ \-\ BA",
"55163707", "Franca\ \-\ SP",
"55172137", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55863295", "São\ Félix\ do\ Piauí\ \-\ PI",
"55883653", "Ibiapina\ \-\ CE",
"55873946", "Salgueiro\ \-\ PE",
"55513445", "Presidente\ Lucena\ \-\ RS",
"55613411", "Brasília\ \-\ DF",
"55713125", "Camaçari\ \-\ BA",
"55543242", "Nova\ Prata\ \-\ RS",
"55863254", "Assunção\ do\ Piauí\ \-\ PI",
"55643444", "Buriti\ Alegre\ \-\ GO",
"55313531", "Betim\ \-\ MG",
"55663328", "Planalto\ da\ Serra\ \-\ MT",
"55353656", "Consolação\ \-\ MG",
"55173043", "Barretos\ \-\ SP",
"55163488", "São\ Simão\ \-\ SP",
"5554322", "Caxias\ do\ Sul\ \-\ RS",
"55413604", "Fazenda\ Rio\ Grande\ \-\ PR",
"55732103", "Itabuna\ \-\ BA",
"55833293", "Lucena\ \-\ PB",
"55463272", "Pato\ Branco\ \-\ PR",
"557133", "Salvador\ \-\ BA",
"55513502", "Capão\ da\ Canoa\ \-\ RS",
"55433461", "Faxinal\ \-\ PR",
"55693461", "Ouro\ Preto\ do\ Oeste\ \-\ RO",
"55313898", "Cajuri\ \-\ MG",
"55823289", "Santana\ do\ Mundaú\ \-\ AL",
"55433354", "Londrina\ \-\ PR",
"55823425", "Taquarana\ \-\ AL",
"55623597", "Goiânia\ \-\ GO",
"55513613", "Fazenda\ Vilanova\ \-\ RS",
"55652121", "Cuiabá\ \-\ MT",
"55242252", "Três\ Rios\ \-\ RJ",
"55333737", "Berilo\ \-\ MG",
"55883427", "Boa\ Viagem\ \-\ CE",
"55343213", "Uberlândia\ \-\ MG",
"55673029", "Campo\ Grande\ \-\ MS",
"55114049", "Diadema\ \-\ SP",
"55453277", "Toledo\ \-\ PR",
"55963081", "Macapá\ \-\ AP",
"55443633", "São\ João\ \-\ PR",
"55753023", "Feira\ de\ Santana\ \-\ BA",
"55434052", "Londrina\ \-\ PR",
"55173355", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55813478", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55193408", "Americana\ \-\ SP",
"55443557", "Terra\ Nova\ do\ Piquirí\ \-\ PR",
"55933515", "Altamira\ \-\ PA",
"55793364", "Telha\ \-\ SE",
"55133384", "Guarujá\ \-\ SP",
"55333414", "Divinolândia\ de\ Minas\ \-\ MG",
"55483525", "Turvo\ \-\ SC",
"55193567", "Santa\ Cruz\ da\ Conceição\ \-\ SP",
"55272144", "Vila\ Velha\ \-\ ES",
"55483334", "Florianópolis\ \-\ SC",
"55323755", "Vieiras\ \-\ MG",
"55633534", "Mateiros\ \-\ TO",
"55833298", "Conde\ \-\ PB",
"55243111", "Petrópolis\ \-\ RJ",
"55193889", "Monte\ Mor\ \-\ SP",
"55983194", "São\ Luís\ \-\ MA",
"55383757", "Joaquim\ Felício\ \-\ MG",
"55183222", "Presidente\ Prudente\ \-\ SP",
"55313893", "Porto\ Firme\ \-\ MG",
"55813751", "Frei\ Miguelinho\ \-\ PE",
"55853004", "Fortaleza\ \-\ CE",
"55973385", "Manicoré\ \-\ AM",
"55493534", "Ibiam\ \-\ SC",
"55513618", "Barão\ \-\ RS",
"55662101", "Rondonópolis\ \-\ MT",
"55183367", "Borá\ \-\ SP",
"55493325", "São\ Carlos\ \-\ SC",
"55353022", "Pouso\ Alegre\ \-\ MG",
"55513157", "Três\ Coroas\ \-\ RS",
"55692181", "Porto\ Velho\ \-\ RO",
"55753320", "Itaeté\ \-\ BA",
"55142108", "Bauru\ \-\ SP",
"55473385", "Benedito\ Novo\ \-\ SC",
"55653029", "Várzea\ Grande\ \-\ MT",
"55114205", "Itapevi\ \-\ SP",
"55813252", "Recife\ \-\ PE",
"55613551", "Brasília\ \-\ DF",
"55673232", "Corumbá\ \-\ MS",
"55143587", "Presidente\ Alves\ \-\ SP",
"55283036", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55893444", "Dom\ Expedito\ Lopes\ \-\ PI",
"55873983", "Petrolina\ \-\ PE",
"55222222", "Nova\ Friburgo\ \-\ RJ",
"55383832", "São\ João\ do\ Paraíso\ \-\ MG",
"55883410", "Itaiçaba\ \-\ CE",
"55813699", "Panelas\ \-\ PE",
"55993534", "Davinópolis\ \-\ MA",
"55973441", "Santa\ Isabel\ do\ Rio\ Negro\ \-\ AM",
"55153355", "Angatuba\ \-\ SP",
"55313246", "Minas\ Gerais",
"55333745", "Joaíma\ \-\ MG",
"55983525", "Imperatriz\ \-\ MA",
"55173829", "Talhado\ \-\ SP",
"55813473", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55853111", "Fortaleza\ \-\ CE",
"55153394", "Ibiúna\ \-\ SP",
"55332102", "Governador\ Valadares\ \-\ MG",
"55133212", "Santos\ \-\ SP",
"55183721", "Andradina\ \-\ SP",
"55112829", "Santo\ André\ \-\ SP",
"55423618", "Virmond\ \-\ PR",
"55453056", "Toledo\ \-\ PR",
"55653692", "Várzea\ Grande\ \-\ MT",
"55493243", "Correia\ Pinto\ \-\ SC",
"55513066", "Novo\ Hamburgo\ \-\ RS",
"55115105", "São\ Paulo\ \-\ SP",
"55513450", "Rio\ Grande\ do\ Sul",
"55133341", "Guarujá\ \-\ SP",
"55753258", "Araci\ \-\ BA",
"55673268", "Bodoquena\ \-\ MS",
"55653259", "Vila\ Bela\ da\ Santíssima\ Trindade\ \-\ MT",
"55883545", "Santana\ do\ Cariri\ \-\ CE",
"55383534", "Diamantina\ \-\ MG",
"55443662", "Maria\ Helena\ \-\ PR",
"55433440", "Pirapó\ \-\ PR",
"55323262", "Rochedo\ de\ Minas\ \-\ MG",
"55162132", "Ribeirão\ Preto\ \-\ SP",
"55843395", "Almino\ Afonso\ \-\ RN",
"55163722", "Franca\ \-\ SP",
"55623406", "Buritinópolis\ \-\ GO",
"55513437", "Rio\ Grande\ do\ Sul",
"55112086", "Guarulhos\ \-\ SP",
"55163349", "Trabiju\ \-\ SP",
"55473622", "Canoinhas\ \-\ SC",
"55323693", "Barbacena\ \-\ MG",
"55643579", "Itumbiara\ \-\ GO",
"55843354", "Encanto\ \-\ RN",
"55773472", "Maetinga\ \-\ BA",
"55173201", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55163820", "Orlândia\ \-\ SP",
"55493424", "Bom\ Jesus\ \-\ SC",
"55163221", "Matão\ \-\ SP",
"55833633", "Baraúna\ \-\ PB",
"55973484", "Itamarati\ \-\ AM",
"55313111", "São\ Joaquim\ de\ Bicas\ \-\ MG",
"55353473", "Santa\ Rita\ do\ Sapucaí\ \-\ MG",
"55193026", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55123351", "Jacareí\ \-\ SP",
"55682102", "Rio\ Branco\ \-\ AC",
"55833266", "Mogeiro\ \-\ PB",
"55173812", "Icém\ \-\ SP",
"55883658", "Poranga\ \-\ CE",
"55483435", "Siderópolis\ \-\ SC",
"5532", "Minas\ Gerais",
"55633424", "Goianorte\ \-\ TO",
"55553347", "Santa\ Maria\ \-\ RS",
"55333315", "Inhapim\ \-\ MG",
"55653308", "Nova\ Mutum\ \-\ MT",
"55793465", "São\ Miguel\ do\ Aleixo\ \-\ SE",
"55112812", "Guarulhos\ \-\ SP",
"55543284", "Caxias\ do\ Sul\ \-\ RS",
"55444003", "Maringá\ \-\ PR",
"55513625", "Capão\ da\ Canoa\ \-\ RS",
"55963271", "Mazagão\ \-\ AP",
"55643624", "Itumbiara\ \-\ GO",
"55983393", "Luís\ Domingues\ \-\ MA",
"55673475", "Japorã\ \-\ MS",
"55413678", "Adrianópolis\ \-\ PR",
"55613107", "Brasília\ \-\ DF",
"55333237", "Fernandes\ Tourinho\ \-\ MG",
"55753695", "São\ Domingos\ \-\ BA",
"55353739", "Andradas\ \-\ MG",
"55933528", "Novo\ Progresso\ \-\ PA",
"55843433", "Acari\ \-\ RN",
"55753654", "Brejões\ \-\ BA",
"55433158", "Ibiporã\ \-\ PR",
"55652122", "Cáceres\ \-\ MT",
"55242251", "Três\ Rios\ \-\ RJ",
"55124448", "Cajamar\ \-\ SP",
"55423625", "Entre\ Rios\ \-\ PR",
"55313834", "Itabira\ \-\ MG",
"55113443", "São\ Paulo\ \-\ SP",
"55623589", "Goiânia\ \-\ GO",
"55443640", "Esperança\ Nova\ \-\ PR",
"55433528", "Wenceslau\ Braz\ \-\ PR",
"55823297", "Japaratinga\ \-\ AL",
"55193665", "Mococa\ \-\ SP",
"55443543", "Ubiratã\ \-\ PR",
"55114067", "Diadema\ \-\ SP",
"55753015", "Feira\ de\ Santana\ \-\ BA",
"55343061", "Patos\ de\ Minas\ \-\ MG",
"55223512", "Nova\ Friburgo\ \-\ RJ",
"55313684", "Taquaraçu\ de\ Minas\ \-\ MG",
"55114492", "Jundiaí\ \-\ SP",
"55873788", "Angelim\ \-\ PE",
"55483469", "Treviso\ \-\ SC",
"55733556", "Lajedo\ do\ Tabocal\ \-\ BA",
"55112166", "Barueri\ \-\ SP",
"55733267", "Itororó\ \-\ BA",
"55313532", "Betim\ \-\ MG",
"55663554", "Vila\ Rica\ \-\ MT",
"55193651", "Espírito\ Santo\ do\ Pinhal\ \-\ SP",
"55483081", "Criciúma\ \-\ SC",
"55193375", "Piracicaba\ \-\ SP",
"55813739", "Altinho\ \-\ PE",
"55663595", "Matupá\ \-\ MT",
"55812129", "Recife\ \-\ PE",
"55823558", "Penedo\ \-\ AL",
"55953621", "Boa\ Vista\ \-\ RR",
"55753247", "Irará\ \-\ BA",
"55913456", "Benfica\ \-\ PA",
"55483272", "Antônio\ Carlos\ \-\ SC",
"55833371", "Picuí\ \-\ PB",
"55683237", "Plácido\ de\ Castro\ \-\ AC",
"55673546", "Brasilândia\ \-\ MS",
"55153202", "Sorocaba\ \-\ SP",
"55753471", "Feira\ de\ Santana\ \-\ BA",
"55413456", "Matinhos\ \-\ PR",
"55413060", "Fazenda\ Rio\ Grande\ \-\ PR",
"55713113", "Salvador\ \-\ BA",
"55883647", "Groaíras\ \-\ CE",
"55843523", "Alto\ do\ Rodrigues\ \-\ RN",
"55483906", "Tubarão\ \-\ SC",
"55333328", "Alvarenga\ \-\ MG",
"55143556", "Cafelândia\ \-\ SP",
"55173362", "Marcondésia\ \-\ SP",
"55143267", "Borebi\ \-\ SP",
"55823645", "Inhapi\ \-\ AL",
"55983272", "São\ Luís\ \-\ MA",
"55553358", "Salvador\ das\ Missões\ \-\ RS",
"55213803", "Niterói\ \-\ RJ",
"55983453", "Arari\ \-\ MA",
"55543477", "Paraí\ \-\ RS",
"55983469", "Urbano\ Santos\ \-\ MA",
"55443234", "Astorga\ \-\ PR",
"55543329", "Carazinho\ \-\ RS",
"55343614", "Perdizes\ \-\ MG",
"55513382", "Rio\ Grande\ do\ Sul",
"55542105", "Bento\ Gonçalves\ \-\ RS",
"55153276", "Sarapuí\ \-\ SP",
"55383690", "Montes\ Claros\ \-\ MG",
"55313419", "Minas\ Gerais",
"55113389", "São\ Paulo\ \-\ SP",
"55313641", "Santa\ Luzia\ \-\ MG",
"55143322", "Ourinhos\ \-\ SP",
"55114509", "Santo\ André\ \-\ SP",
"55143379", "Ribeirão\ do\ Sul\ \-\ SP",
"55115851", "São\ Paulo\ \-\ SP",
"55543372", "Marcelino\ Ramos\ \-\ RS",
"55493541", "Campos\ Novos\ \-\ SC",
"55993632", "Lago\ dos\ Rodrigues\ \-\ MA",
"55513487", "Glorinha\ \-\ RS",
"55313755", "Senhora\ de\ Oliveira\ \-\ MG",
"55463211", "Francisco\ Beltrão\ \-\ PR",
"5524", "Rio\ de\ Janeiro",
"55983229", "Raposa\ \-\ MA",
"55213131", "Rio\ de\ Janeiro\ \-\ RJ",
"55713296", "Simões\ Filho\ \-\ BA",
"55983485", "Água\ Doce\ do\ Maranhão\ \-\ MA",
"55212721", "Niterói\ \-\ RJ",
"55153141", "Sorocaba\ \-\ SP",
"55483341", "Palhoça\ \-\ SC",
"55273721", "Colatina\ \-\ ES",
"55173467", "Nhandeara\ \-\ SP",
"55113365", "São\ Paulo\ \-\ SP",
"5585", "Ceará",
"55213674", "Niterói\ \-\ RJ",
"55633378", "Ponte\ Alta\ do\ Tocantins\ \-\ TO",
"55443646", "Pérola\ Independente\ \-\ PR",
"55863267", "Lagoa\ Alegre\ \-\ PI",
"55513042", "Gravataí\ \-\ RS",
"55112503", "São\ Paulo\ \-\ SP",
"55623551", "Bela\ Vista\ de\ Goiás\ \-\ GO",
"55273222", "Vitória\ \-\ ES",
"55823252", "Joaquim\ Gomes\ \-\ AL",
"55683026", "Rio\ Branco\ \-\ AC",
"55993541", "Balsas\ \-\ MA",
"55192102", "Campinas\ \-\ SP",
"5511369", "Osasco\ \-\ SP",
"55413157", "Quatro\ Barras\ \-\ PR",
"55893431", "Padre\ Marcos\ \-\ PI",
"55373324", "Pimenta\ \-\ MG",
"55634001", "Palmas\ \-\ TO",
"55633696", "Novo\ Jardim\ \-\ TO",
"55313238", "Belo\ Horizonte\ \-\ MG",
"55312535", "Belo\ Horizonte\ \-\ MG",
"55112612", "São\ Paulo\ \-\ SP",
"55863322", "Parnaíba\ \-\ PI",
"55493632", "Tunápolis\ \-\ SC",
"55433367", "Londrina\ \-\ PR",
"55352106", "Varginha\ \-\ MG",
"55313479", "Minas\ Gerais",
"55343674", "Matutina\ \-\ MG",
"55623565", "Goiânia\ \-\ GO",
"55373425", "Luz\ \-\ MG",
"55313327", "Belo\ Horizonte\ \-\ MG",
"55693222", "Porto\ Velho\ \-\ RO",
"55893521", "Floriano\ \-\ PI",
"55473154", "Rio\ dos\ Cedros\ \-\ SC",
"55313590", "Minas\ Gerais",
"55983212", "São\ Luís\ \-\ MA",
"55193839", "Amparo\ \-\ SP",
"55383541", "Serro\ \-\ MG",
"55873842", "Ibimirim\ \-\ PE",
"55423274", "Ventania\ \-\ PR",
"55733537", "Ibirataia\ \-\ BA",
"55313262", "Belo\ Horizonte\ \-\ MG",
"55123145", "Cruzeiro\ \-\ SP",
"55753649", "Elísio\ Medrado\ \-\ BA",
"55493668", "Flor\ do\ Sertão\ \-\ SC",
"55143653", "Brotas\ \-\ SP",
"55933222", "Santarém\ \-\ PA",
"5583322", "João\ Pessoa\ \-\ PB",
"55814007", "Recife\ \-\ PE",
"55483212", "Florianópolis\ \-\ SC",
"55214062", "Rio\ de\ Janeiro\ \-\ RJ",
"55323288", "Olaria\ \-\ MG",
"55993668", "Timbiras\ \-\ MA",
"5511518", "São\ Paulo\ \-\ SP",
"55313761", "Conselheiro\ Lafaiete\ \-\ MG",
"55983384", "Presidente\ Sarney\ \-\ MA",
"55383632", "Santa\ Fé\ de\ Minas\ \-\ MG",
"55543293", "Antônio\ Prado\ \-\ RS",
"55343131", "Uberlândia\ \-\ MG",
"55443688", "Xambrê\ \-\ PR",
"55114137", "Taboão\ da\ Serra\ \-\ SP",
"55993584", "Lajeado\ Novo\ \-\ MA",
"55213773", "Nova\ Iguaçu\ \-\ RJ",
"55513708", "Sinimbu\ \-\ RS",
"55473524", "Aurora\ \-\ SC",
"55513274", "Rio\ Grande\ do\ Sul",
"55623377", "Formoso\ \-\ GO",
"55193937", "Jaguariúna\ \-\ SP",
"55163461", "Araraquara\ \-\ SP",
"55853301", "Beberibe\ \-\ CE",
"55173346", "Bebedouro\ \-\ SP",
"55133272", "Santos\ \-\ SP",
"55813413", "Recife\ \-\ PE",
"55112346", "São\ Paulo\ \-\ SP",
"55433575", "Londrina\ \-\ PR",
"55653244", "Jauru\ \-\ MT",
"55623429", "Posse\ \-\ GO",
"55353558", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55123224", "Caçapava\ \-\ SP",
"55212707", "Niterói\ \-\ RJ",
"55373553", "Estrela\ do\ Indaiá\ \-\ MG",
"55193851", "Mogi\-Guaçu\ \-\ SP",
"55163395", "Rincão\ \-\ SP",
"55624015", "Anápolis\ \-\ GO",
"55483031", "Florianópolis\ \-\ SC",
"55443312", "Nossa\ Senhora\ das\ Graças\ \-\ PR",
"55833426", "Emas\ \-\ PB",
"55163354", "Guarapiranga\ \-\ SP",
"55513192", "Novo\ Hamburgo\ \-\ RS",
"55444101", "Sarandi\ \-\ PR",
"55943312", "Marabá\ \-\ PA",
"55843221", "Natal\ \-\ RN",
"5584331", "Mossoró\ \-\ RN",
"55883416", "Tauá\ \-\ CE",
"55643522", "Itumbiara\ \-\ GO",
"55113705", "Santo\ André\ \-\ SP",
"55513678", "Cristal\ \-\ RS",
"55663408", "São\ José\ do\ Couto\ \-\ MT",
"55163135", "Rifaina\ \-\ SP",
"5561320", "Brasília\ \-\ DF",
"55544003", "Caxias\ do\ Sul\ \-\ RS",
"55753326", "Boa\ Vista\ do\ Tupim\ \-\ BA",
"55843065", "Mossoró\ \-\ RN",
"55114448", "Cajamar\ \-\ SP",
"55413625", "Contenda\ \-\ PR",
"55313733", "Joaquim\ Murtinho\ \-\ MG",
"5515341", "Sorocaba\ \-\ SP",
"55223094", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55353645", "São\ José\ do\ Alegre\ \-\ MG",
"55323422", "Cataguases\ \-\ MG",
"55673562", "Chapadão\ do\ Sul\ \-\ MS",
"55313841", "Coronel\ Fabriciano\ \-\ MG",
"55513396", "Rio\ Grande\ do\ Sul",
"55343814", "Patos\ de\ Minas\ \-\ MG",
"55213512", "Rio\ de\ Janeiro\ \-\ RJ",
"55313240", "Perpétuo\ Socorro\ \-\ MG",
"55513368", "Rio\ Grande\ do\ Sul",
"55823305", "Maceió\ \-\ AL",
"55693446", "Primavera\ de\ Rondônia\ \-\ RO",
"55143885", "Pirambóia\ \-\ SP",
"55643496", "Aloândia\ \-\ GO",
"55473353", "Apiúna\ \-\ SC",
"55793343", "Pacatuba\ \-\ SE",
"55423903", "União\ da\ Vitória\ \-\ PR",
"55553621", "Santana\ do\ Livramento\ \-\ RS",
"55623412", "Goiânia\ \-\ GO",
"55323532", "Ubá\ \-\ MG",
"55513456", "Canoas\ \-\ RS",
"55773667", "Pindaí\ \-\ BA",
"55353413", "Passos\ \-\ MG",
"55153383", "Laranjal\ Paulista\ \-\ SP",
"55413382", "São\ José\ dos\ Pinhais\ \-\ PR",
"55643432", "Itumbiara\ \-\ GO",
"55453037", "Cascavel\ \-\ PR",
"5516337", "São\ Carlos\ \-\ SP",
"55543234", "São\ José\ dos\ Ausentes\ \-\ RS",
"55743627", "Miguel\ Calmon\ \-\ BA",
"55213814", "Rio\ de\ Janeiro\ \-\ RJ",
"55343512", "Araguari\ \-\ MG",
"55115839", "São\ Paulo\ \-\ SP",
"55313634", "Santa\ Luzia\ \-\ MG",
"5571349", "Salvador\ \-\ BA",
"55213978", "Rio\ de\ Janeiro\ \-\ RJ",
"5511255", "São\ Paulo\ \-\ SP",
"55773412", "Iramaia\ \-\ BA",
"55112806", "Diadema\ \-\ SP",
"55643519", "Itumbiara\ \-\ GO",
"55813645", "Feira\ Nova\ \-\ PE",
"55193865", "Hortolândia\ \-\ SP",
"55893459", "Patos\ do\ Piauí\ \-\ PI",
"55833536", "Santa\ Cruz\ \-\ PB",
"55193328", "Indaiatuba\ \-\ SP",
"55183279", "Regente\ Feijó\ \-\ SP",
"55183528", "Osvaldo\ Cruz\ \-\ SP",
"55623539", "Goiânia\ \-\ GO",
"55473045", "Itajaí\ \-\ SC",
"55973353", "Codajás\ \-\ AM",
"5564400", "Itumbiara\ \-\ GO",
"55353297", "Alfenas\ \-\ MG",
"55114486", "Terra\ Preta\ \-\ SP",
"55313884", "Minas\ Gerais",
"55553505", "Alegrete\ \-\ RS",
"55654104", "Várzea\ Grande\ \-\ MT",
"55193186", "Charqueada\ \-\ SP",
"55613393", "Santa\ Maria\ \-\ DF",
"55733166", "Eunápolis\ \-\ BA",
"55373343", "Camacho\ \-\ MG",
"55543353", "Caseiros\ \-\ RS",
"55173556", "Irapuã\ \-\ SP",
"55983377", "Nova\ Olinda\ do\ Maranhão\ \-\ MA",
"55173267", "Guapiaçu\ \-\ SP",
"55543369", "Barra\ Funda\ \-\ RS",
"55933532", "Uruará\ \-\ PA",
"55513375", "Rio\ Grande\ do\ Sul",
"55513651", "São\ Jerônimo\ \-\ RS",
"55413020", "Curitiba\ \-\ PR",
"55933596", "São\ José\ \-\ PA",
"55993577", "Parnarama\ \-\ MA",
"55553426", "Alegrete\ \-\ RS",
"55115066", "São\ Paulo\ \-\ SP",
"55473234", "Blumenau\ \-\ SC",
"55333825", "Belo\ Oriente\ \-\ MG",
"55143227", "Bauru\ \-\ SP",
"55613627", "Valparaíso\ de\ Goiás\ \-\ GO",
"55853462", "Fortaleza\ \-\ CE",
"55183841", "Junqueirópolis\ \-\ SP",
"55163172", "Igarapava\ \-\ SP",
"55693641", "Alta\ Floresta\ do\ Oeste\ \-\ RO",
"55643691", "Vicentinópolis\ \-\ GO",
"55333203", "Governador\ Valadares\ \-\ MG",
"55823273", "Coruripe\ \-\ AL",
"55114681", "Juquitiba\ \-\ SP",
"55693532", "Cacaulândia\ \-\ RO",
"55114566", "Mogi\ das\ Cruzes\ \-\ SP",
"55313438", "Minas\ Gerais",
"55343251", "Santa\ Vitória\ \-\ MG",
"55323446", "Palma\ \-\ MG",
"55222733", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55242225", "Petrópolis\ \-\ RJ",
"55483285", "Biguaçu\ \-\ SC",
"55423651", "Reserva\ do\ Iguaçu\ \-\ PR",
"55153307", "Itapetininga\ \-\ SP",
"55613044", "Taguatinga\ \-\ DF",
"55114230", "Itupeva\ \-\ SP",
"55433532", "Cambará\ \-\ PR",
"55193878", "Louveira\ \-\ SP",
"55353571", "Muzambinho\ \-\ MG",
"55273422", "Cariacica\ \-\ ES",
"55183582", "Parapuã\ \-\ SP",
"55543045", "Passo\ Fundo\ \-\ RS",
"55643546", "Itumbiara\ \-\ GO",
"55183634", "Birigui\ \-\ SP",
"55673047", "Campo\ Grande\ \-\ MS",
"55733672", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55114027", "Salto\ \-\ SP",
"55313462", "Belo\ Horizonte\ \-\ MG",
"55483539", "São\ João\ do\ Sul\ \-\ SC",
"55343265", "Cachoeira\ Dourada\ \-\ MG",
"55753211", "Feira\ de\ Santana\ \-\ BA",
"55213850", "Rio\ de\ Janeiro\ \-\ RJ",
"55473543", "Rio\ do\ Oeste\ \-\ SC",
"55114598", "Vargem\ \-\ SP",
"55493339", "Águas\ de\ Chapecó\ \-\ SC",
"55313528", "Belo\ Horizonte\ \-\ MG",
"55823336", "Maceió\ \-\ AL",
"55613906", "Luziânia\ \-\ GO",
"55153416", "Votorantim\ \-\ SP",
"55112319", "São\ Paulo\ \-\ SP",
"55193625", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55373225", "Nova\ Serrana\ \-\ MG",
"55213837", "Rio\ de\ Janeiro\ \-\ RJ",
"55693422", "Ji\-Paraná\ \-\ RO",
"55163666", "Santa\ Cruz\ da\ Esperança\ \-\ SP",
"55474003", "Blumenau\ \-\ SC",
"55532123", "Pelotas\ \-\ RS",
"55114644", "Itaquaquecetuba\ \-\ SP",
"55643475", "Três\ Ranchos\ \-\ GO",
"55113964", "Jundiaí\ \-\ SP",
"55112685", "São\ Paulo\ \-\ SP",
"55643588", "Itumbiara\ \-\ GO",
"55553536", "Alegria\ \-\ RS",
"55613272", "Brasília\ \-\ DF",
"55533240", "Bagé\ \-\ RS",
"55493199", "Chapecó\ \-\ SC",
"55193501", "Hortolândia\ \-\ SP",
"55513474", "Sapucaia\ do\ Sul\ \-\ RS",
"55113264", "Salvador\ \-\ BA",
"55183301", "Araçatuba\ \-\ SP",
"55643664", "Doverlândia\ \-\ GO",
"55613453", "Sobradinho\ \-\ DF",
"55112835", "São\ Caetano\ do\ Sul\ \-\ SP",
"55333332", "Manhuaçu\ \-\ MG",
"55212641", "Teresópolis\ \-\ RJ",
"55513665", "Capão\ da\ Canoa\ \-\ RS",
"55883611", "Sobral\ \-\ CE",
"55323575", "Guarani\ \-\ MG",
"55613081", "Brasília\ \-\ DF",
"55883449", "Senador\ Pompeu\ \-\ CE",
"55753616", "Feira\ de\ Santana\ \-\ BA",
"55143201", "Bauru\ \-\ SP",
"55613601", "Luziânia\ \-\ GO",
"55123832", "Ubatuba\ \-\ SP",
"55312572", "Betim\ \-\ MG",
"55633464", "Guaraí\ \-\ TO",
"55533262", "Arroio\ Grande\ \-\ RS",
"55493351", "Entre\ Rios\ \-\ SC",
"55493675", "Riqueza\ \-\ SC",
"55873779", "Jupi\ \-\ PE",
"55133269", "Santos\ \-\ SP",
"55423026", "Ponta\ Grossa\ \-\ PR",
"55633351", "Gurupi\ \-\ TO",
"55143812", "São\ Manuel\ \-\ SP",
"55323721", "Muriaé\ \-\ MG",
"55733086", "Ilhéus\ \-\ BA",
"55123682", "Taubaté\ \-\ SP",
"55623578", "Aparecida\ de\ Goiânia\ \-\ GO",
"55553242", "Santana\ do\ Livramento\ \-\ RS",
"55123896", "Ilhabela\ \-\ SP",
"55123424", "Taubaté\ \-\ SP",
"55313877", "Jequeri\ \-\ MG",
"55153249", "Ibiúna\ \-\ SP",
"55163025", "Franca\ \-\ SP",
"55153321", "Sorocaba\ \-\ SP",
"5515321", "Sorocaba\ \-\ SP",
"5553", "Rio\ Grande\ do\ Sul",
"55623341", "Goianápolis\ \-\ GO",
"55863346", "São\ José\ do\ Divino\ \-\ PI",
"55323222", "Juiz\ de\ Fora\ \-\ MG",
"55313440", "Minas\ Gerais",
"55823204", "Chã\ Preta\ \-\ AL",
"55843421", "Caicó\ \-\ RN",
"55773229", "Brumado\ \-\ BA",
"55283537", "Iconha\ \-\ ES",
"55543524", "Mariano\ Moro\ \-\ RS",
"55613334", "Recanto\ das\ Emas\ \-\ DF",
"55323367", "Alfredo\ Vasconcelos\ \-\ MG",
"55773485", "Carinhanha\ \-\ BA",
"55113584", "São\ Paulo\ \-\ SP",
"55973417", "Atalaia\ do\ Norte\ \-\ AM",
"55133406", "São\ Vicente\ \-\ SP",
"55813497", "Recife\ \-\ PE",
"55613525", "Brasília\ \-\ DF",
"55443622", "Umuarama\ \-\ PR",
"55653223", "Cáceres\ \-\ MT",
"55673579", "Selvíria\ \-\ MS",
"55473372", "Jaraguá\ do\ Sul\ \-\ SC",
"55315", "Minas\ Gerais",
"55313515", "Belo\ Horizonte\ \-\ MG",
"55173587", "Palmares\ Paulista\ \-\ SP",
"55843531", "Angicos\ \-\ RN",
"55543434", "Silva\ Jardim\ \-\ RS",
"55513639", "São\ Vendelino\ \-\ RS",
"55613435", "Brasília\ \-\ DF",
"55643996", "Itumbiara\ \-\ GO",
"55853877", "Fortaleza\ \-\ CE",
"55323052", "Barbacena\ \-\ MG",
"55443277", "Corumbataí\ do\ Sul\ \-\ PR",
"55113378", "Jundiaí\ \-\ SP",
"55653053", "Várzea\ Grande\ \-\ MT",
"55643932", "Itumbiara\ \-\ GO",
"55843283", "Brejinho\ \-\ RN",
"55963326", "Ferreira\ Gomes\ \-\ AP",
"55513567", "Santa\ Maria\ do\ Herval\ \-\ RS",
"55383675", "Bonfinópolis\ de\ Minas\ \-\ MG",
"55513256", "Rio\ Grande\ do\ Sul",
"55734141", "Itabuna\ \-\ BA",
"55453266", "Céu\ Azul\ \-\ PR",
"5565368", "Várzea\ Grande\ \-\ MT",
"55513403", "Guaíba\ \-\ RS",
"55273288", "Marechal\ Floriano\ \-\ ES",
"55623384", "Taquaral\ de\ Goiás\ \-\ GO",
"55553311", "Santa\ Maria\ \-\ RS",
"5555322", "Santa\ Maria\ \-\ RS",
"55633491", "Luzinópolis\ \-\ TO",
"55653345", "Poconé\ \-\ MT",
"55493365", "Modelo\ \-\ SC",
"55273111", "Aracruz\ \-\ ES",
"55423639", "Foz\ do\ Jordão\ \-\ PR",
"55533238", "São\ José\ do\ Norte\ \-\ RS",
"55553784", "Chiapetta\ \-\ RS",
"55843642", "Natal\ \-\ RN",
"55183693", "Piacatu\ \-\ SP",
"55943385", "Vila\ Santa\ Fé\ \-\ PA",
"55633365", "Fátima\ \-\ TO",
"55463552", "Capanema\ \-\ PR",
"55493491", "Seara\ \-\ SC",
"55443441", "Terra\ Rica\ \-\ PR",
"55663499", "Araguaiana\ \-\ MT",
"55423256", "Porto\ Amazonas\ \-\ PR",
"55443619", "Cianorte\ \-\ PR",
"55183262", "Presidente\ Bernardes\ \-\ SP",
"55413414", "Tagaçaba\ \-\ PR",
"55913287", "Ananindeua\ \-\ PA",
"55473241", "Itajaí\ \-\ SC",
"55115818", "São\ Paulo\ \-\ SP",
"55793251", "Aracaju\ \-\ SE",
"5511415", "Santana\ de\ Parnaíba\ \-\ SP",
"55163983", "Luís\ Antônio\ \-\ SP",
"55213553", "Rio\ de\ Janeiro\ \-\ RJ",
"55623393", "Bonópolis\ \-\ GO",
"55943353", "Vila\ Cruzeiro\ do\ Sul\ \-\ PA",
"55443045", "Paranavaí\ \-\ PR",
"55873809", "Iguaraci\ \-\ PE",
"55943369", "Parauapebas\ \-\ PA",
"55193456", "Iracemápolis\ \-\ SP",
"55633389", "Abreulândia\ \-\ TO",
"55833498", "Serra\ Grande\ \-\ PB",
"55753602", "Feira\ de\ Santana\ \-\ BA",
"55193825", "Indaiatuba\ \-\ SP",
"55183422", "Assis\ \-\ SP",
"55313817", "Ponte\ Nova\ \-\ MG",
"55673496", "Ponta\ Porã\ \-\ MS",
"55313446", "Belo\ Horizonte\ \-\ MG",
"55923328", "Rio\ Preto\ da\ Eva\ \-\ AM",
"55623518", "Aparecida\ de\ Goiânia\ \-\ GO",
"55223021", "Araruama\ \-\ RJ",
"55813273", "Recife\ \-\ PE",
"55863340", "Matias\ Olímpio\ \-\ PI",
"55923020", "Manaus\ \-\ AM",
"55283556", "São\ José\ do\ Calçado\ \-\ ES",
"55112885", "Guarulhos\ \-\ SP",
"55433301", "Londrina\ \-\ PR",
"55743667", "Piritiba\ \-\ BA",
"55273733", "Brejetuba\ \-\ ES",
"55843255", "Senador\ Elói\ de\ Souza\ \-\ RN",
"55114405", "Piracaia\ \-\ SP",
"55193903", "Sumaré\ \-\ SP",
"55813452", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55673432", "Ponta\ Porã\ \-\ MS",
"55122126", "Pindamonhangaba\ \-\ SP",
"55843294", "São\ José\ do\ Campestre\ \-\ RN",
"5531359", "Betim\ \-\ MG",
"55413375", "São\ José\ dos\ Pinhais\ \-\ PR",
"55283322", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55173635", "Aparecida\ D\'Oeste\ \-\ SP",
"55373512", "Divinópolis\ \-\ MG",
"55753676", "São\ Miguel\ das\ Matas\ \-\ BA",
"55413651", "São\ Luiz\ do\ Purunã\ \-\ PR",
"5511452", "Jundiaí\ \-\ SP",
"55433240", "São\ Martinho\ \-\ PR",
"55873221", "Garanhuns\ \-\ PE",
"55323462", "Além\ Paraíba\ \-\ MG",
"55673522", "Três\ Lagoas\ \-\ MS",
"55223850", "Miracema\ \-\ RJ",
"5511443", "Santo\ André\ \-\ SP",
"55443679", "Tapira\ \-\ PR",
"5511260", "São\ Paulo\ \-\ SP",
"55513237", "Rio\ Grande\ do\ Sul",
"55713624", "Camaçari\ \-\ BA",
"5516362", "Ribeirão\ Preto\ \-\ SP",
"55114174", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55333625", "Serra\ dos\ Aimorés\ \-\ MG",
"55493443", "São\ Domingos\ \-\ SC",
"55693733", "Porto\ Velho\ \-\ RO",
"55453260", "Missal\ \-\ PR",
"55773453", "Brumado\ \-\ BA",
"55663510", "Juara\ \-\ MT",
"55273171", "Linhares\ \-\ ES",
"55843261", "Maxaranguape\ \-\ RN",
"55933582", "Santa\ Maria\ do\ Uruará\ \-\ PA",
"55683214", "Rio\ Branco\ \-\ AC",
"55212301", "Rio\ de\ Janeiro\ \-\ RJ",
"55673468", "Vicentina\ \-\ MS",
"55833209", "João\ Pessoa\ \-\ PB",
"55413665", "Pinhais\ \-\ PR",
"55183641", "Birigui\ \-\ SP",
"55423237", "Piraí\ do\ Sul\ \-\ PR",
"55893533", "Rio\ Grande\ do\ Piauí\ \-\ PI",
"55833466", "Assunção\ \-\ PB",
"55193396", "Sumaré\ \-\ SP",
"55114280", "Cotia\ \-\ SP",
"55133377", "Cubatão\ \-\ SP",
"55143346", "Bernardino\ de\ Campos\ \-\ SP",
"55114881", "Francisco\ Morato\ \-\ SP",
"55553548", "Cândido\ Godói\ \-\ RS",
"55383615", "Manga\ \-\ MG",
"55473300", "Rio\ do\ Sul\ \-\ SC",
"55353452", "Careaçu\ \-\ MG",
"55222783", "Italva\ \-\ RJ",
"55212634", "Maricá\ \-\ RJ",
"55913665", "Benevides\ \-\ PA",
"55833358", "Barra\ de\ São\ Miguel\ \-\ PB",
"55793265", "Nossa\ Senhora\ das\ Dores\ \-\ SE",
"55953592", "Pacaraima\ \-\ RR",
"55313488", "Minas\ Gerais",
"55163421", "Ribeirão\ Preto\ \-\ SP",
"55423250", "Abapã\ \-\ PR",
"55473312", "Timbó\ \-\ SC",
"55863086", "Teresina\ \-\ PI",
"55313575", "Moeda\ \-\ MG",
"55353273", "Jesuânia\ \-\ MG",
"55343637", "Pratinha\ \-\ MG",
"55693582", "Cujubim\ \-\ RO",
"55753162", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55193678", "Canoas\ \-\ SP",
"55373278", "Pequi\ \-\ MG",
"55115042", "São\ Paulo\ \-\ SP",
"55643071", "Rio\ Verde\ \-\ GO",
"55193818", "Mogi\-Guaçu\ \-\ SP",
"55812626", "Recife\ \-\ PE",
"55212755", "São\ João\ de\ Meriti\ \-\ RJ",
"55964400", "Macapá\ \-\ AP",
"55473564", "Rio\ do\ Campo\ \-\ SC",
"55112653", "São\ Paulo\ \-\ SP",
"55644012", "Itumbiara\ \-\ GO",
"55273755", "Ecoporanga\ \-\ ES",
"5543", "Paraná",
"5569", "Rondônia",
"55863198", "Teresina\ \-\ PI",
"55143629", "Potunduva\ \-\ SP",
"55613578", "Brasília\ \-\ DF",
"55113424", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55513689", "Xangri\-Lá\ \-\ RS",
"55613485", "Sobradinho\ \-\ DF",
"55543622", "Passo\ Fundo\ \-\ RS",
"55313721", "Conselheiro\ Lafaiete\ \-\ MG",
"55443524", "Campo\ Mourão\ \-\ PR",
"55193708", "Campinas\ \-\ SP",
"55114663", "Embu\-Guaçu\ \-\ SP",
"55343856", "Arapuá\ \-\ MG",
"55123668", "Campos\ do\ Jordão\ \-\ SP",
"55813204", "Recife\ \-\ PE",
"55433262", "Assaí\ \-\ PR",
"55343425", "Frutal\ \-\ MG",
"55613341", "Cruzeiro\ \-\ DF",
"55114292", "Suzano\ \-\ SP",
"55943335", "Itinga\ do\ Maranhão\ \-\ PA",
"55643643", "Porteirão\ \-\ GO",
"55453242", "Corbélia\ \-\ PR",
"55733629", "São\ João\ do\ Paraíso\ \-\ BA",
"55623334", "Petrolina\ de\ Goiás\ \-\ GO",
"5593", "Pará",
"55483023", "Palhoça\ \-\ SC",
"55183288", "Rosana\ \-\ SP",
"55114103", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55213856", "São\ Gonçalo\ \-\ RJ",
"55883671", "Tianguá\ \-\ CE",
"55123632", "Taubaté\ \-\ SP",
"55123108", "Aparecida\ \-\ SP",
"55753447", "Ouriçangas\ \-\ BA",
"55114373", "São\ Paulo\ \-\ SP",
"55483953", "Florianópolis\ \-\ SC",
"55212479", "São\ Gonçalo\ \-\ RJ",
"5545322", "Cascavel\ \-\ PR",
"55273327", "Vitória\ \-\ ES",
"55863362", "Cocal\ \-\ PI",
"55422102", "Ponta\ Grossa\ \-\ PR",
"55943434", "Ourilândia\ do\ Norte\ \-\ PA",
"55163660", "Batatais\ \-\ SP",
"55483269", "Florianópolis\ \-\ SC",
"55813046", "Caruaru\ \-\ PE",
"55613212", "Brasília\ \-\ DF",
"55483253", "Paulo\ Lopes\ \-\ SC",
"55543441", "Veranópolis\ \-\ RS",
"55242465", "Mendes\ \-\ RJ",
"55193487", "Santa\ Maria\ da\ Serra\ \-\ SP",
"55343324", "Água\ Comprida\ \-\ MG",
"55693238", "Buritis\ \-\ RO",
"55273262", "Guarapari\ \-\ ES",
"55112754", "São\ Paulo\ \-\ SP",
"55212693", "Nilópolis\ \-\ RJ",
"55893555", "Arraial\ \-\ PI",
"5587386", "Petrolina\ \-\ PE",
"55513745", "Segredo\ \-\ RS",
"55413639", "Lapa\ \-\ PR",
"55533246", "Aceguá\ \-\ RS",
"55112427", "Atibaia\ \-\ SP",
"55743551", "Filadélfia\ \-\ BA",
"55983269", "São\ Luís\ \-\ MA",
"55273761", "São\ Mateus\ \-\ ES",
"55773435", "Anagé\ \-\ BA",
"55543385", "Tapera\ \-\ RS",
"55753271", "Euclides\ da\ Cunha\ \-\ BA",
"55193042", "Piracicaba\ \-\ SP",
"5527", "Espirito\ Santo",
"55553266", "Nova\ Palma\ \-\ RS",
"55553557", "Coronel\ Bicaco\ \-\ RS",
"55423414", "Rio\ da\ Areia\ \-\ PR",
"55733612", "Itabuna\ \-\ BA",
"55843376", "Viçosa\ \-\ RN",
"55833347", "Gado\ Bravo\ \-\ PB",
"55333527", "Ouro\ Verde\ de\ Minas\ \-\ MG",
"55983472", "Brejo\ \-\ MA",
"55194113", "Sumaré\ \-\ SP",
"55133505", "Mongaguá\ \-\ SP",
"55873835", "Pesqueira\ \-\ PE",
"55683244", "Rio\ Branco\ \-\ AC",
"55123132", "Guaratinguetá\ \-\ SP",
"55123608", "Taubaté\ \-\ SP",
"55773661", "Candiba\ \-\ BA",
"55663540", "União\ do\ Sul\ \-\ MT",
"55193768", "Campinas\ \-\ SP",
"5513342", "Itanhaém\ \-\ SP",
"55114603", "Bragança\ Paulista\ \-\ SP",
"55433202", "Apucarana\ \-\ PR",
"55213448", "Rio\ de\ Janeiro\ \-\ RJ",
"55753234", "Nova\ Fátima\ \-\ BA",
"55113571", "São\ Paulo\ \-\ SP",
"55843672", "Natal\ \-\ RN",
"55333533", "Novo\ Cruzeiro\ \-\ MG",
"55843338", "Carnaubais\ \-\ RN",
"55413399", "Campo\ Largo\ \-\ PR",
"55373405", "Arcos\ \-\ MG",
"55143112", "Botucatu\ \-\ SP",
"55913775", "Santo\ Antônio\ do\ Tauá\ \-\ PA",
"55353736", "Cabo\ Verde\ \-\ MG",
"55453031", "Foz\ do\ Iguaçu\ \-\ PR",
"55743621", "Jacobina\ \-\ BA",
"55273333", "Vitória\ \-\ ES",
"55623661", "Goiânia\ \-\ GO",
"55513728", "Rio\ Grande\ do\ Sul",
"55463524", "Francisco\ Beltrão\ \-\ PR",
"55473342", "Navegantes\ \-\ SC",
"55843198", "Natal\ \-\ RN",
"55242280", "Petrópolis\ \-\ RJ",
"55623586", "Goiânia\ \-\ GO",
"55793352", "Neópolis\ \-\ SE",
"55483821", "Florianópolis\ \-\ SC",
"55192119", "Hortolândia\ \-\ SP",
"55433276", "Arapongas\ \-\ PR",
"55443247", "Santa\ Fé\ \-\ PR",
"55843606", "Natal\ \-\ RN",
"55353291", "Alfenas\ \-\ MG",
"55793526", "Estância\ \-\ SE",
"55143316", "Marília\ \-\ SP",
"55883634", "Ubajara\ \-\ CE",
"55483466", "Orleans\ \-\ SC",
"55883582", "Iguatu\ \-\ CE",
"55114978", "Santo\ André\ \-\ SP",
"55623371", "Goiás\ \-\ GO",
"55193583", "Descalvado\ \-\ SP",
"55793436", "Itabaiana\ \-\ SE",
"55813736", "São\ Caetano\ \-\ PE",
"55193857", "Engenheiro\ Coelho\ \-\ SP",
"55443015", "Marialva\ \-\ PR",
"55333244", "Galiléia\ \-\ MG",
"55313470", "Minas\ Gerais",
"55812126", "Recife\ \-\ PE",
"55273276", "Guaraná\ \-\ ES",
"55493558", "Ipira\ \-\ SC",
"55483037", "Florianópolis\ \-\ SC",
"55613003", "Brasília\ \-\ DF",
"556432", "Itumbiara\ \-\ GO",
"55143407", "Garça\ \-\ SP",
"5547332", "Blumenau\ \-\ SC",
"55473211", "Brusque\ \-\ SC",
"55993645", "Esperantinópolis\ \-\ MA",
"55114704", "Embu\ das\ Artes\ \-\ SP",
"55353264", "Elói\ Mendes\ \-\ MG",
"55423035", "Guarapuava\ \-\ PR",
"55313599", "Ibirité\ \-\ MG",
"55114529", "Jacaré\ \-\ SP",
"55114278", "Santa\ Isabel\ \-\ SP",
"55115029", "São\ Paulo\ \-\ SP",
"55863302", "Teresina\ \-\ PI",
"55443654", "Brasilândia\ do\ Sul\ \-\ PR",
"55993558", "Passagem\ Franca\ \-\ MA",
"55843227", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55114163", "Barueri\ \-\ SP",
"55114159", "Vargem\ Grande\ Paulista\ \-\ SP",
"55663415", "Ribeirãozinho\ \-\ MT",
"55192122", "Campinas\ \-\ SP",
"55543552", "Cacique\ Doble\ \-\ RS",
"55493645", "Guaraciaba\ \-\ SC",
"55873967", "Ouricuri\ \-\ PE",
"55333423", "Sabinópolis\ \-\ MG",
"55193796", "Campinas\ \-\ SP",
"55533611", "Portão\ \-\ RS",
"55112523", "São\ Paulo\ \-\ SP",
"55323295", "Passa\-Vinte\ \-\ MG",
"55843362", "Campo\ Grande\ \-\ RN",
"55983466", "Pirapemas\ \-\ MA",
"55323254", "Piau\ \-\ MG",
"55543326", "Campos\ Borges\ \-\ RS",
"55173523", "Catanduva\ \-\ SP",
"55623548", "Aparecida\ de\ Goiânia\ \-\ GO",
"55613536", "Brasília\ \-\ DF",
"55983358", "Penalva\ \-\ MA",
"55553272", "Tupanciretã\ \-\ RS",
"55513035", "Novo\ Hamburgo\ \-\ RS",
"55313847", "Minas\ Gerais",
"55153279", "Sao\ Miguel\ Arcanjo\ \-\ SP",
"55733283", "Camacã\ \-\ BA",
"55242103", "Petrópolis\ \-\ RJ",
"55193886", "Vinhedo\ \-\ SP",
"55623998", "Goiânia\ \-\ GO",
"55663538", "Bom\ Jesus\ do\ Araguaia\ \-\ MT",
"55143642", "Barra\ Bonita\ \-\ SP",
"5531321", "Belo\ Horizonte\ \-\ MG",
"55313321", "Minas\ Gerais",
"55223205", "Saquarema\ \-\ RJ",
"55813541", "Abreu\ e\ Lima\ \-\ PE",
"55513444", "Viamão\ \-\ RS",
"55483717", "Florianópolis\ \-\ SC",
"55212671", "Duque\ de\ Caxias\ \-\ RJ",
"55383547", "Serra\ Azul\ de\ Minas\ \-\ MG",
"55823534", "Jacaré\ dos\ Homens\ \-\ AL",
"55212394", "Rio\ de\ Janeiro\ \-\ RJ",
"55433454", "Cruzmaltina\ \-\ PR",
"55273355", "Vitória\ \-\ ES",
"55733531", "Ipiaú\ \-\ BA",
"55553525", "Humaitá\ \-\ RS",
"55653026", "Várzea\ Grande\ \-\ MT",
"55833317", "Galante\ \-\ PB",
"55553334", "Augusto\ Pestana\ \-\ RS",
"55213724", "Rio\ de\ Janeiro\ \-\ RJ",
"55143283", "Pederneiras\ \-\ SP",
"5588", "Ceará",
"55313767", "Minas\ Gerais",
"55813378", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55193308", "Campinas\ \-\ SP",
"55114131", "Pirapora\ do\ Bom\ Jesus\ \-\ SP",
"55313249", "Belo\ Horizonte\ \-\ MG",
"55753662", "Laje\ \-\ BA",
"55173826", "Uchoa\ \-\ SP",
"55873853", "Itapetim\ \-\ PE",
"55923223", "Manaus\ \-\ AM",
"55113357", "São\ Paulo\ \-\ SP",
"55443258", "Munhoz\ de\ Melo\ \-\ PR",
"55193000", "Vinhedo\ \-\ SP",
"55513715", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55943309", "Cumaru\ do\ Norte\ \-\ PA",
"55873869", "Santa\ Maria\ da\ Boa\ Vista\ \-\ PE",
"55493547", "Celso\ Ramos\ \-\ SC",
"55173354", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55793205", "Aracaju\ \-\ SE",
"55513053", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55913605", "Anajás\ \-\ PA",
"55115931", "São\ Paulo\ \-\ SP",
"55513481", "Eldorado\ do\ Sul\ \-\ RS",
"55693043", "Porto\ Velho\ \-\ RO",
"55173395", "Terra\ Roxa\ \-\ SP",
"55112354", "São\ Paulo\ \-\ SP",
"55473360", "Balneário\ Camboriú\ \-\ SC",
"55183916", "Presidente\ Prudente\ \-\ SP",
"552125", "Rio\ de\ Janeiro\ \-\ RJ",
"55114773", "Itapevi\ \-\ SP",
"55213137", "Rio\ de\ Janeiro\ \-\ RJ",
"55753638", "Governador\ Mangabeira\ \-\ BA",
"55163346", "Boa\ Esperança\ do\ Sul\ \-\ SP",
"55273727", "São\ Gabriel\ da\ Palha\ \-\ ES",
"55193848", "Louveira\ \-\ SP",
"55173461", "General\ Salgado\ \-\ SP",
"55553435", "Maçambara\ \-\ RS",
"55353541", "Cássia\ \-\ MG",
"55633547", "Porto\ Nacional\ \-\ TO",
"55953212", "Boa\ Vista\ \-\ RR",
"55643576", "Itumbiara\ \-\ GO",
"55853321", "Guaramiranga\ \-\ CE",
"55823424", "Major\ Isidoro\ \-\ AL",
"55433355", "Londrina\ \-\ PR",
"55733421", "Porto\ Seguro\ \-\ BA",
"55373373", "Capitólio\ \-\ MG",
"55893450", "Francisco\ Santos\ \-\ PI",
"55242292", "Petrópolis\ \-\ RJ",
"55312103", "Belo\ Horizonte\ \-\ MG",
"55643613", "Rio\ Verde\ \-\ GO",
"55623557", "Campestre\ de\ Goiás\ \-\ GO",
"55833472", "Teixeira\ \-\ PB",
"55243321", "Resende\ \-\ RJ",
"55313858", "Dionísio\ \-\ MG",
"55663562", "Santa\ Carmem\ \-\ MT",
"55193029", "Campinas\ \-\ SP",
"55513345", "Rio\ Grande\ do\ Sul",
"55213520", "Rio\ de\ Janeiro\ \-\ RJ",
"55634007", "Palmas\ \-\ TO",
"55913521", "Paragominas\ \-\ PA",
"55413605", "Colombo\ \-\ PR",
"5561322", "Brasília\ \-\ DF",
"5514362", "Jaú\ \-\ SP",
"55833253", "Bayeux\ \-\ PB",
"55993547", "São\ Raimundo\ das\ Mangabeiras\ \-\ MA",
"55114083", "São\ Paulo\ \-\ SP",
"55273361", "Guarapari\ \-\ ES",
"55183871", "Panorama\ \-\ SP",
"55614102", "Brasília\ \-\ DF",
"55353696", "Guaxupé\ \-\ MG",
"55963217", "Macapá\ \-\ AP",
"55163142", "São\ José\ da\ Bela\ Vista\ \-\ SP",
"55343457", "Carneirinho\ \-\ MG",
"55773409", "Iguatemi\ \-\ BA",
"55733261", "Eunápolis\ \-\ BA",
"55513775", "Pouso\ Novo\ \-\ RS",
"55173349", "Turvínia\ \-\ SP",
"55273091", "Cariacica\ \-\ ES",
"55113608", "Osasco\ \-\ SP",
"55813010", "Paulista\ \-\ PE",
"55823264", "Atalaia\ \-\ AL",
"55343352", "Uberaba\ \-\ MG",
"55193657", "Tapiratiba\ \-\ SP",
"55753241", "Santo\ Amaro\ \-\ BA",
"551138", "São\ Paulo\ \-\ SP",
"55833285", "Gurinhém\ \-\ PB",
"55433064", "Londrina\ \-\ PR",
"55833429", "São\ Bentinho\ \-\ PB",
"55683231", "Bujari\ \-\ AC",
"55632112", "Araguaína\ \-\ TO",
"55883532", "Barbalha\ \-\ CE",
"55114094", "Diadema\ \-\ SP",
"55143762", "Taquarituba\ \-\ SP",
"55213492", "Niterói\ \-\ RJ",
"55833377", "Dona\ Inês\ \-\ PB",
"55883419", "Arneiroz\ \-\ CE",
"55883641", "Pacujá\ \-\ CE",
"55143025", "Lins\ \-\ SP",
"55133209", "Santos\ \-\ SP",
"55933064", "Santarém\ \-\ PA",
"55753477", "Chorrochó\ \-\ BA",
"55483442", "Criciúma\ \-\ SC",
"55143261", "Agudos\ \-\ SP",
"55612323", "Brasília\ \-\ DF",
"5531327", "Belo\ Horizonte\ \-\ MG",
"55543471", "Dois\ Lajeados\ \-\ RS",
"55963622", "Vitória\ do\ Jari\ \-\ AP",
"55513399", "Rio\ Grande\ do\ Sul",
"55913728", "Concórdia\ do\ Pará\ \-\ PA",
"55113392", "São\ Paulo\ \-\ SP",
"55473366", "Balneário\ Camboriú\ \-\ SC",
"55813748", "Sairé\ \-\ PE",
"55693449", "Rolim\ de\ Moura\ \-\ RO",
"55443552", "Boa\ Esperança\ \-\ PR",
"55112719", "São\ Paulo\ \-\ SP",
"55143294", "Iacanga\ \-\ SP",
"55513463", "Rio\ Grande\ do\ Sul",
"55613101", "Brasília\ \-\ DF",
"5551379", "Rio\ Grande\ do\ Sul",
"55473458", "São\ João\ do\ Itaperiú\ \-\ SC",
"55513459", "Esteio\ \-\ RS",
"55333583", "Pescador\ \-\ MG",
"55163514", "Ribeirão\ Preto\ \-\ SP",
"55843388", "Major\ Sales\ \-\ RN",
"55643570", "Claudinápolis\ \-\ GO",
"55714009", "Salvador\ \-\ BA",
"55333231", "Itanhomi\ \-\ MG",
"55753284", "Macururé\ \-\ BA",
"55453272", "Diamante\ D\'Oeste\ \-\ PR",
"55413035", "São\ José\ dos\ Pinhais\ \-\ PR",
"55173483", "Nova\ Luzitânia\ \-\ SP",
"55283523", "Gironda\ \-\ ES",
"55983621", "Bacabal\ \-\ MA",
"55873885", "Mirandiba\ \-\ PE",
"55543015", "Erechim\ \-\ RS",
"55883422", "Morada\ Nova\ \-\ CE",
"55242566", "Bom\ Jardim\ \-\ RJ",
"55183701", "Mirandópolis\ \-\ SP",
"55112809", "Guarulhos\ \-\ SP",
"55943326", "Rondon\ do\ Pará\ \-\ PA",
"55333732", "Comercinho\ \-\ MG",
"55733255", "Camamu\ \-\ BA",
"55242257", "Areal\ \-\ RJ",
"55124159", "Vargem\ Grande\ Paulista\ \-\ SP",
"55754101", "Feira\ de\ Santana\ \-\ BA",
"55883684", "Ipaporanga\ \-\ CE",
"55423459", "Fernandes\ Pinheiro\ \-\ PR",
"55623592", "Goiânia\ \-\ GO",
"55893456", "Simões\ \-\ PI",
"55173809", "Mendonça\ \-\ SP",
"55823291", "Barra\ de\ Santo\ Antônio\ \-\ AL",
"55273064", "Serra\ \-\ ES",
"55733294", "Itamaraju\ \-\ BA",
"55423463", "Rio\ Azul\ \-\ PR",
"55753312", "Cruz\ das\ Almas\ \-\ BA",
"55833539", "Triunfo\ \-\ PB",
"55163829", "Ituverava\ \-\ SP",
"55623536", "Goiânia\ \-\ GO",
"55443122", "Maringá\ \-\ PR",
"55133821", "Registro\ \-\ SP",
"55313254", "Belo\ Horizonte\ \-\ MG",
"55183276", "Piquerobi\ \-\ SP",
"55353690", "Varginha\ \-\ MG",
"55453206", "Agro\ Cafeeira\ \-\ PR",
"55353593", "Jacuí\ \-\ MG",
"55114061", "Diadema\ \-\ SP",
"55673245", "Anastácio\ \-\ MS",
"55313295", "Belo\ Horizonte\ \-\ MG",
"55973458", "Pauini\ \-\ AM",
"55883568", "Jaguaribara\ \-\ CE",
"5511274", "São\ Paulo\ \-\ SP",
"55383845", "Taiobeiras\ \-\ MG",
"55114489", "Francisco\ Morato\ \-\ SP",
"55733544", "Planaltino\ \-\ BA",
"55133347", "Guarujá\ \-\ SP",
"55143376", "Sodrélia\ \-\ SP",
"55953194", "Boa\ Vista\ \-\ RR",
"55143106", "Bauru\ \-\ SP",
"55823541", "Junqueiro\ \-\ AL",
"55144004", "Bauru\ \-\ SP",
"55663546", "Cláudia\ \-\ MT",
"5532321", "Juiz\ de\ Fora\ \-\ MG",
"55493019", "Lages\ \-\ SC",
"55773683", "Jaborandi\ \-\ BA",
"55333263", "Resplendor\ \-\ MG",
"55753688", "Lamarão\ \-\ BA",
"55693216", "Porto\ Velho\ \-\ RO",
"55813534", "Escada\ \-\ PE",
"55513431", "Gravataí\ \-\ RS",
"55913444", "Mãe\ do\ Rio\ \-\ PA",
"55313545", "Rio\ Acima\ \-\ MG",
"55713652", "São\ Francisco\ do\ Conde\ \-\ BA",
"55623942", "Goiânia\ \-\ GO",
"55613298", "Brasília\ \-\ DF",
"55193555", "Leme\ \-\ SP",
"55143302", "Ourinhos\ \-\ SP",
"55433270", "Santa\ Cecília\ do\ Pavão\ \-\ PR",
"55353832", "Campo\ Belo\ \-\ MG",
"55623683", "Santa\ Bárbara\ de\ Goiás\ \-\ GO",
"55873795", "Jurema\ \-\ PE",
"55443649", "Palotina\ \-\ PR",
"55893487", "Paulistana\ \-\ PI",
"55222134", "Iguaba\ Grande\ \-\ RJ",
"55193594", "Descalvado\ \-\ SP",
"55114033", "Bragança\ Paulista\ \-\ SP",
"55493252", "Timbó\ Grande\ \-\ SC",
"55114144", "Itapevi\ \-\ SP",
"55633473", "Xambioá\ \-\ TO",
"55213823", "Rio\ de\ Janeiro\ \-\ RJ",
"55883111", "Sobral\ \-\ CE",
"55353424", "Congonhal\ \-\ MG",
"55823632", "Olivença\ \-\ AL",
"5592363", "Manaus\ \-\ AM",
"55183355", "Presidente\ Prudente\ \-\ SP",
"55353534", "Itamogi\ \-\ MG",
"55193561", "Pirassununga\ \-\ SP",
"55353325", "Andrelândia\ \-\ MG",
"55383751", "Corinto\ \-\ MG",
"55193892", "Serra\ Negra\ \-\ SP",
"55433141", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55474063", "Joinville\ \-\ SC",
"55143842", "São\ Manuel\ \-\ SP",
"55423521", "União\ da\ Vitória\ \-\ PR",
"55373286", "São\ Sebastião\ do\ Oeste\ \-\ MG",
"55163338", "Gavião\ Peixoto\ \-\ SP",
"55773311", "Brumado\ \-\ BA",
"55913481", "Primavera\ \-\ PA",
"55343823", "Patos\ de\ Minas\ \-\ MG",
"55813757", "Santa\ Maria\ do\ Cambucá\ \-\ PE",
"55193836", "Vinhedo\ \-\ SP",
"55833565", "João\ Pessoa\ \-\ PB",
"55663588", "Ipiranga\ do\ Norte\ \-\ MT",
"55513151", "Porto\ Alegre\ \-\ RS",
"55183361", "Paraguaçu\ Paulista\ \-\ SP",
"55643604", "Mairipotaba\ \-\ GO",
"55222727", "São\ Francisco\ de\ Itabapoana\ \-\ RJ",
"55793457", "Macambira\ \-\ SE",
"55513605", "Torres\ \-\ RS",
"55273270", "Barra\ do\ Riacho\ \-\ ES",
"55753646", "Guaibim\ \-\ BA",
"55473447", "Araquari\ \-\ SC",
"55313402", "Nova\ Lima\ \-\ MG",
"55143666", "Bocaina\ \-\ SP",
"55943785", "Novo\ Repartimento\ \-\ PA",
"55813682", "Joaquim\ Nabuco\ \-\ PE",
"55354103", "Passos\ \-\ MG",
"55143581", "Pongaí\ \-\ SP",
"55313410", "Minas\ Gerais",
"55613633", "Padre\ Bernardo\ \-\ GO",
"5521323", "Rio\ de\ Janeiro\ \-\ RJ",
"55383252", "Engenheiro\ Dolabela\ \-\ MG",
"55613966", "Brasília\ \-\ DF",
"55923521", "Itacoatiara\ \-\ AM",
"55753441", "Aporá\ \-\ BA",
"55833485", "Santana\ dos\ Garrotes\ \-\ PB",
"55663468", "Água\ Boa\ \-\ MT",
"55883677", "Sobral\ \-\ CE",
"55833229", "Santa\ Rita\ \-\ PB",
"55123115", "Arapeí\ \-\ SP",
"55183658", "Clementina\ \-\ SP",
"55273321", "Vitória\ \-\ ES",
"55183117", "Araçatuba\ \-\ SP",
"55193481", "São\ Pedro\ \-\ SP",
"55114535", "Jundiaí\ \-\ SP",
"55643408", "Joviânia\ \-\ GO",
"554133", "Curitiba\ \-\ PR",
"55793114", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55543447", "Vila\ Flores\ \-\ RS",
"55213236", "Nilópolis\ \-\ RJ",
"55313394", "Belo\ Horizonte\ \-\ MG",
"55813517", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55432103", "Londrina\ \-\ PR",
"55663522", "São\ Félix\ do\ Araguaia\ \-\ MT",
"55713604", "Madre\ de\ Deus\ \-\ BA",
"55963312", "Macapá\ \-\ AP",
"55193053", "Leme\ \-\ SP",
"55153246", "Cesário\ Lange\ \-\ SP",
"55873201", "Petrolina\ \-\ PE",
"55143354", "Botucatu\ \-\ SP",
"55443068", "Campo\ Mourão\ \-\ PR",
"5531347", "Belo\ Horizonte\ \-\ MG",
"55813628", "Limoeiro\ \-\ PE",
"55613717", "Brasília\ \-\ DF",
"55212767", "Nova\ Iguaçu\ \-\ RJ",
"55543271", "São\ Jorge\ \-\ RS",
"55193345", "Campinas\ \-\ SP",
"55983683", "Satubinha\ \-\ MA",
"55853361", "Aquiraz\ \-\ CE",
"55813145", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55273767", "São\ Mateus\ \-\ ES",
"55173421", "Votuporanga\ \-\ SP",
"55553551", "Tenente\ Portela\ \-\ RS",
"55743633", "Saúde\ \-\ BA",
"55273249", "Paraju\ \-\ ES",
"55753277", "Antas\ \-\ BA",
"55333521", "Teófilo\ Otoni\ \-\ MG",
"55483242", "Palhoça\ \-\ SC",
"55833341", "Campina\ Grande\ \-\ PB",
"55963116", "Santana\ \-\ AP",
"55193805", "Mogi\ Mirim\ \-\ SP",
"55183402", "Assis\ \-\ SP",
"55753622", "Feira\ de\ Santana\ \-\ BA",
"55513959", "Sapiranga\ \-\ RS",
"55333431", "Santa\ Maria\ do\ Suaçuí\ \-\ MG",
"5548322", "Florianópolis\ \-\ SC",
"55173283", "Jaci\ \-\ SP",
"55873829", "Ingazeira\ \-\ PE",
"55433249", "Cambé\ \-\ PR",
"55623607", "Goiânia\ \-\ GO",
"55853355", "São\ Luís\ do\ Curu\ \-\ CE",
"55513636", "Rio\ Grande\ do\ Sul",
"55153288", "Cerquilho\ \-\ SP",
"55443573", "Iretama\ \-\ PR",
"55643999", "Itumbiara\ \-\ GO",
"55223863", "Jaguarembé\ \-\ RJ",
"55553565", "Porto\ Lucena\ \-\ RS",
"55173531", "Catanduva\ \-\ SP",
"55413555", "Campo\ Largo\ \-\ PR",
"55513692", "Camaquã\ \-\ RS",
"55513263", "Rio\ Grande\ do\ Sul",
"55773460", "Igaporã\ \-\ BA",
"55643652", "Cristianópolis\ \-\ GO",
"55453253", "Nova\ Santa\ Rosa\ \-\ PR",
"55313727", "Capela\ Nova\ \-\ MG",
"55473258", "Vitor\ Meireles\ \-\ SC",
"55453269", "Vila\ Nova\ \-\ PR",
"55242430", "Barra\ do\ Piraí\ \-\ RJ",
"5511450", "São\ Paulo\ \-\ SP",
"55663432", "Poxoréo\ \-\ MT",
"55343663", "Perdizes\ \-\ MG",
"55213103", "Nova\ Iguaçu\ \-\ RJ",
"55923012", "Manaus\ \-\ AM",
"55112642", "São\ Paulo\ \-\ SP",
"55473309", "Blumenau\ \-\ SC",
"55423636", "Cantagalo\ \-\ PR",
"55833063", "Campina\ Grande\ \-\ PB",
"55272103", "Linhares\ \-\ ES",
"55283544", "Muniz\ Freire\ \-\ ES",
"55673445", "Anaurilândia\ \-\ MS",
"55413648", "Bateias\ \-\ PR",
"55173642", "Vitória\ Brasil\ \-\ SP",
"55343292", "Uberlândia\ \-\ MG",
"55693321", "Vilhena\ \-\ RO",
"55472125", "Balneário\ Camboriú\ \-\ SC",
"55283310", "Castelo\ \-\ ES",
"5598322", "São\ Luís\ \-\ MA",
"55983311", "São\ Luís\ \-\ MA",
"5585347", "Fortaleza\ \-\ CE",
"55343236", "Uberlândia\ \-\ MG",
"55133298", "Santos\ \-\ SP",
"55242457", "Santa\ Isabel\ do\ Rio\ Preto\ \-\ RJ",
"55713164", "Salvador\ \-\ BA",
"55423259", "Ventania\ \-\ PR",
"55663496", "Alto\ Taquari\ \-\ MT",
"55893567", "Ribeiro\ Gonçalves\ \-\ PI",
"55243355", "Resende\ \-\ RJ",
"55833384", "Pocinhos\ \-\ PB",
"55543458", "Tuiutí\ \-\ RS",
"55213844", "Nova\ Iguaçu\ \-\ RJ",
"55473654", "Monte\ Castelo\ \-\ SC",
"55793644", "Lagarto\ \-\ SE",
"55343304", "Uberlândia\ \-\ MG",
"55353443", "Jacutinga\ \-\ MG",
"55543366", "Campinas\ do\ Sul\ \-\ RS",
"55743655", "Central\ \-\ BA",
"55173563", "Cajobi\ \-\ SP",
"55422122", "Castro\ \-\ PR",
"55273177", "Colatina\ \-\ ES",
"55843267", "Ielmo\ Marinho\ \-\ RN",
"55653625", "Cuiabá\ \-\ MT",
"55223831", "Bom\ Jesus\ do\ Itabapoana\ \-\ RJ",
"55793313", "Feira\ Nova\ \-\ SE",
"55143523", "Lins\ \-\ SP",
"55813095", "Caruaru\ \-\ PE",
"55513680", "Quintão\ \-\ RS",
"55183647", "Glicério\ \-\ SP",
"55513931", "Porto\ Alegre\ \-\ RS",
"55553377", "Pejuçara\ \-\ RS",
"55513583", "Rio\ Grande\ do\ Sul",
"55693416", "Ji\-Paraná\ \-\ RO",
"55713041", "Camaçari\ \-\ BA",
"55313333", "Minas\ Gerais",
"55533254", "Cerrito\ \-\ RS",
"55114887", "Jarinu\ \-\ SP",
"55633452", "Nova\ Olinda\ \-\ TO",
"5511568", "São\ Paulo\ \-\ SP",
"55423231", "Carambeí\ \-\ PR",
"55913423", "Salinópolis\ \-\ PA",
"55323449", "Leopoldina\ \-\ MG",
"55883575", "Jati\ \-\ CE",
"5521315", "Rio\ de\ Janeiro\ \-\ RJ",
"55513732", "Rio\ Grande\ do\ Sul",
"55743548", "Pindobaçu\ \-\ BA",
"55623087", "Goiânia\ \-\ GO",
"55443810", "Campo\ Mourão\ \-\ PR",
"55113175", "São\ Paulo\ \-\ SP",
"55113305", "São\ Paulo\ \-\ SP",
"55222647", "Cabo\ Frio\ \-\ RJ",
"55343631", "Ibiá\ \-\ MG",
"55163379", "Fazenda\ Babilônia\ \-\ SP",
"55493452", "Seara\ \-\ SC",
"55773442", "Buritirama\ \-\ BA",
"55243333", "Arrozal\ \-\ RJ",
"5577342", "Vitória\ da\ Conquista\ \-\ BA",
"5511333", "São\ Paulo\ \-\ SP",
"55183995", "Indiana\ \-\ SP",
"55913118", "Belém\ \-\ PA",
"55443342", "Paranapoema\ \-\ PR",
"55113404", "Bragança\ Paulista\ \-\ SP",
"55893474", "Pimenteiras\ \-\ PI",
"55793257", "São\ Cristóvão\ \-\ SE",
"55973471", "São\ Gabriel\ da\ Cachoeira\ \-\ AM",
"55483536", "Timbé\ do\ Sul\ \-\ SC",
"55513768", "Rio\ Grande\ do\ Sul",
"55493336", "Guatambú\ \-\ SC",
"55313276", "Minas\ Gerais",
"55953235", "São\ João\ da\ Baliza\ \-\ RR",
"55683463", "Feijó\ \-\ AC",
"55463564", "Salgado\ Filho\ \-\ PR",
"55553412", "Uruguaiana\ \-\ RS",
"55623621", "Goiânia\ \-\ GO",
"55163669", "Cássia\ dos\ Coqueiros\ \-\ SP",
"55213980", "Rio\ de\ Janeiro\ \-\ RJ",
"55313210", "Minas\ Gerais",
"55483003", "Florianópolis\ \-\ SC",
"5553327", "Pelotas\ \-\ RS",
"55343844", "Grupiara\ \-\ MG",
"55143433", "Marília\ \-\ SP",
"55623505", "Trindade\ \-\ GO",
"55453235", "Três\ Barras\ do\ Paraná\ \-\ PR",
"55213304", "Belford\ Roxo\ \-\ RJ",
"55743661", "Xique\-Xique\ \-\ BA",
"55153532", "Itararé\ \-\ SP",
"55112078", "Barueri\ \-\ SP",
"55653382", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55192513", "Campinas\ \-\ SP",
"55553539", "Independência\ \-\ RS",
"55914104", "Ananindeua\ \-\ PA",
"55123413", "Taubaté\ \-\ SP",
"55313202", "Belo\ Horizonte\ \-\ MG",
"55543398", "Charrua\ \-\ RS",
"55192138", "Campinas\ \-\ SP",
"55413657", "Almirante\ Tamandaré\ \-\ PR",
"55473471", "São\ Francisco\ do\ Sul\ \-\ SC",
"55613358", "Samambaia\ Sul\ \-\ DF",
"55883446", "Aracati\ \-\ CE",
"55773621", "Cotegipe\ \-\ BA",
"55943342", "Abel\ Figueiredo\ \-\ PA",
"5513346", "São\ Vicente\ \-\ SP",
"55542521", "Bento\ Gonçalves\ \-\ RS",
"55543360", "Nova\ Boa\ Vista\ \-\ RS",
"55813351", "Recife\ \-\ PE",
"55813675", "Barreiros\ \-\ PE",
"55113115", "São\ Paulo\ \-\ SP",
"55313508", "Belo\ Horizonte\ \-\ MG",
"55134102", "Guarujá\ \-\ SP",
"55463543", "Realeza\ \-\ PR",
"55513686", "Magistério\ \-\ RS",
"55883515", "Pedra\ Branca\ \-\ CE",
"55323355", "Tiradentes\ \-\ MG",
"55114007", "São\ Paulo\ \-\ SP",
"5524223", "Petrópolis\ \-\ RJ",
"55753434", "Acajutiba\ \-\ BA",
"55843653", "Natal\ \-\ RN",
"55513561", "Estância\ Velha\ \-\ RS",
"55833525", "Sousa\ \-\ PB",
"55163835", "Miguelópolis\ \-\ SP",
"55633497", "Tupirama\ \-\ TO",
"55553317", "Santa\ Maria\ \-\ RS",
"55343859", "Patos\ de\ Minas\ \-\ MG",
"55333345", "Chalé\ \-\ MG",
"55114656", "Santa\ Isabel\ \-\ SP",
"55483298", "Florianópolis\ \-\ SC",
"55823628", "Monteirópolis\ \-\ AL",
"55173842", "Indiaporã\ \-\ SP",
"55183321", "Assis\ \-\ SP",
"55222767", "Cambuci\ \-\ RJ",
"55193521", "Campinas\ \-\ SP",
"55353365", "São\ Sebastião\ do\ Rio\ Verde\ \-\ MG",
"55733626", "Núcleo\ Colonial\ de\ Una\ \-\ BA",
"55123022", "Taubaté\ \-\ SP",
"55433476", "Cândido\ de\ Abreu\ \-\ PR",
"55443447", "Alto\ Paraná\ \-\ PR",
"555133", "Porto\ Alegre\ \-\ RS",
"55173302", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55163322", "Araraquara\ \-\ SP",
"55613607", "Distrito\ de\ Campos\ Lindos\ \-\ GO",
"55473411", "Rio\ do\ Sul\ \-\ SC",
"55182103", "Araçatuba\ \-\ SP",
"55193431", "Tanquinho\ \-\ SP",
"55163749", "Ribeirão\ Corrente\ \-\ SP",
"55353464", "Inconfidentes\ \-\ MG",
"55463234", "Bom\ Sucesso\ do\ Sul\ \-\ PR",
"55913692", "Gurupá\ \-\ PA",
"55213114", "Rio\ de\ Janeiro\ \-\ RJ",
"55483266", "Florianópolis\ \-\ SC",
"55323727", "Barão\ de\ Monte\ Alto\ \-\ MG",
"55913636", "Limoeiro\ do\ Ajuru\ \-\ PA",
"55633357", "Formoso\ do\ Araguaia\ \-\ TO",
"55185821", "Dracena\ \-\ SP",
"55793236", "Aracaju\ \-\ SE",
"55413012", "Curitiba\ \-\ PR",
"55313871", "Rio\ Casca\ \-\ MG",
"55383725", "Morro\ da\ Garça\ \-\ MG",
"55833435", "Jericó\ \-\ PB",
"55533321", "Pelotas\ \-\ RS",
"55493330", "Chapecó\ \-\ SC",
"55533249", "Hulha\ Negra\ \-\ RS",
"55623347", "Campinorte\ \-\ GO",
"55753335", "Andaraí\ \-\ BA",
"55423648", "Marquinho\ \-\ PR",
"55413636", "Balsa\ Nova\ \-\ PR",
"55174004", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55153327", "Sorocaba\ \-\ SP",
"55433545", "Curiúva\ \-\ PR",
"55733207", "Nova\ Canaã\ \-\ BA",
"55553747", "Boa\ Vista\ das\ Missões\ \-\ RS",
"55543032", "Flores\ da\ Cunha\ \-\ RS",
"55313216", "Minas\ Gerais",
"55553269", "São\ João\ do\ Polêsine\ \-\ RS",
"55313184", "Itaguara\ \-\ MG",
"55813491", "Olinda\ \-\ PE",
"55513594", "Novo\ Hamburgo\ \-\ RS",
"55323361", "Carandaí\ \-\ MG",
"55313916", "Belo\ Horizonte\ \-\ MG",
"55153262", "Porto\ Feliz\ \-\ SP",
"5519363", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55843427", "Timbaúba\ dos\ Batistas\ \-\ RN",
"55643595", "Itumbiara\ \-\ GO",
"55283531", "Itapemirim\ \-\ ES",
"55453565", "São\ Miguel\ do\ Iguaçu\ \-\ PR",
"55513555", "Rio\ Grande\ do\ Sul",
"55963234", "Porto\ Grande\ \-\ AP",
"55123019", "São\ José\ dos\ Campos\ \-\ SP",
"55343248", "Cascalho\ Rico\ \-\ MG",
"55843379", "Francisco\ Dantas\ \-\ RN",
"55114021", "Salto\ \-\ SP",
"55673041", "Campo\ Grande\ \-\ MS",
"55643945", "Itumbiara\ \-\ GO",
"55753217", "Santo\ Amaro\ \-\ BA",
"55353339", "São\ Lourenço\ \-\ MG",
"55623920", "Goiânia\ \-\ GO",
"55223844", "Porciúncula\ \-\ RJ",
"55133592", "Praia\ Grande\ \-\ SP",
"55243064", "Petrópolis\ \-\ RJ",
"55433254", "Cambé\ \-\ PR",
"55833627", "Pilõezinhos\ \-\ PB",
"55114265", "Itapecerica\ da\ Serra\ \-\ SP",
"55794002", "Aracaju\ \-\ SE",
"55833393", "Fagundes\ \-\ PB",
"55193463", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55633386", "Palmeirópolis\ \-\ TO",
"55213743", "Nilópolis\ \-\ RJ",
"55943366", "Vila\ Novo\ Paraíso\ \-\ PA",
"55162108", "Araraquara\ \-\ SP",
"55793631", "Lagarto\ \-\ SE",
"55423423", "Irati\ \-\ PR",
"5531341", "Belo\ Horizonte\ \-\ MG",
"55733051", "Alcobaça\ \-\ BA",
"55443366", "Maringá\ \-\ PR",
"55793542", "Cristinápolis\ \-\ SE",
"55642101", "Rio\ Verde\ \-\ GO",
"55313611", "Viçosa\ \-\ MG",
"55843635", "Santa\ Maria\ \-\ RN",
"55673499", "Vila\ Nova\ Casa\ Verde\ \-\ MS",
"55313449", "Belo\ Horizonte\ \-\ MG",
"55983661", "Codó\ \-\ MA",
"55853383", "Maracanaú\ \-\ CE",
"55193507", "Araras\ \-\ SP",
"55813577", "Sirinhaém\ \-\ PE",
"55283559", "Dores\ do\ Rio\ Preto\ \-\ ES",
"55323333", "Barbacena\ \-\ MG",
"55543712", "Erechim\ \-\ RS",
"55913732", "Acará\ \-\ PA",
"55793304", "Aracaju\ \-\ SE",
"55912122", "Ananindeua\ \-\ PA",
"55833133", "João\ Pessoa\ \-\ PB",
"55773498", "Formoso\ A\ \-\ BA",
"55653396", "Alto\ Paraguai\ \-\ MT",
"55453377", "Foz\ do\ Iguaçu\ \-\ PR",
"55212647", "Magé\ \-\ RJ",
"55913796", "Mocajuba\ \-\ PA",
"55873872", "Araripina\ \-\ PE",
"55653332", "Nova\ Olímpia\ \-\ MT",
"55673673", "Jateí\ \-\ MS",
"55743536", "Casa\ Nova\ \-\ BA",
"55883617", "Tamboril\ \-\ CE",
"55513423", "Gravataí\ \-\ RS",
"55453285", "Subsede\ São\ Francisco\ \-\ PR",
"55452104", "Cascavel\ \-\ PR",
"55513630", "Rio\ Grande\ do\ Sul",
"55213644", "Teresópolis\ \-\ RJ",
"55483548", "Passo\ de\ Torres\ \-\ SC",
"55443676", "Cruzeiro\ do\ Oeste\ \-\ PR",
"55173261", "Nova\ Granada\ \-\ SP",
"55983655", "Zé\ Doca\ \-\ MA",
"55983371", "Governador\ Nunes\ Freire\ \-\ MA",
"55993571", "Porto\ Franco\ \-\ MA",
"55483014", "São\ João\ Batista\ \-\ SC",
"55513657", "Vendinha\ \-\ RS",
"55123845", "Ubatuba\ \-\ SP",
"55773466", "Jacaraci\ \-\ BA",
"55923533", "Parintins\ \-\ AM",
"55493348", "União\ do\ Oeste\ \-\ SC",
"55643697", "Davinópolis\ \-\ GO",
"55813705", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55193775", "Campinas\ \-\ SP",
"55813339", "Recife\ \-\ PE",
"55323276", "Mar\ de\ Espanha\ \-\ MG",
"55753353", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55143221", "Marília\ \-\ SP",
"55613621", "Luziânia\ \-\ GO",
"55833469", "Várzea\ \-\ PB",
"55193399", "Sumaré\ \-\ SP",
"55133855", "Tatuí\ \-\ SP",
"55423533", "Antônio\ Olinto\ \-\ PR",
"5561342", "Brasília\ \-\ DF",
"55543342", "Marau\ \-\ RS",
"55983014", "São\ Luís\ \-\ MA",
"55114687", "São\ Lourenço\ da\ Serra\ \-\ SP",
"55833453", "Conceição\ \-\ PB",
"55423630", "Guarapuava\ \-\ PR",
"55663579", "Nova\ Ubiratã\ \-\ MT",
"55514104", "Canoas\ \-\ RS",
"55613505", "Luziânia\ \-\ GO",
"55373352", "Arcos\ \-\ MG",
"55513782", "Santa\ Clara\ do\ Sul\ \-\ RS",
"55313064", "Belo\ Horizonte\ \-\ MG",
"55114850", "Itu\ \-\ SP",
"55343257", "Uberlândia\ \-\ MG",
"55143722", "Tupã\ \-\ SP",
"55192146", "Capivari\ \-\ SP",
"55273254", "Cariacica\ \-\ ES",
"55423657", "Palmital\ \-\ PR",
"55623358", "Santa\ Isabel\ \-\ GO",
"55733221", "Ilhéus\ \-\ BA",
"55863089", "Teresina\ \-\ PI",
"55953539", "Nova\ Colina\ \-\ RR",
"55883438", "Choró\ \-\ CE",
"55414113", "Pinhais\ \-\ PR",
"55333728", "Bandeira\ \-\ MG",
"55114837", "São\ Paulo\ \-\ SP",
"55633571", "Palmas\ \-\ TO",
"55323202", "Cataguases\ \-\ MG",
"55113413", "Itu\ \-\ SP",
"55313383", "Belo\ Horizonte\ \-\ MG",
"55483655", "Sangão\ \-\ SC",
"55343831", "Patrocínio\ \-\ MG",
"55623466", "Vila\ Boa\ \-\ GO",
"55733543", "Itaquara\ \-\ BA",
"55743528", "Umburanas\ \-\ BA",
"55813657", "Ferreiros\ \-\ PE",
"55443685", "Nova\ Olímpia\ \-\ PR",
"55453333", "Cascavel\ \-\ PR",
"55773684", "Roda\ Velha\ \-\ BA",
"55222627", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55943319", "Santa\ Maria\ das\ Barreiras\ \-\ PA",
"55513705", "Marques\ de\ Souza\ \-\ RS",
"55813281", "Recife\ \-\ PE",
"55813533", "Gravatá\ \-\ PE",
"55833307", "Caraúbas\ \-\ PB",
"55913443", "Irituia\ \-\ PA",
"55753660", "Pé\ de\ Serra\ \-\ BA",
"55323429", "Cataguases\ \-\ MG",
"55353244", "Cordislândia\ \-\ MG",
"55323285", "Chiador\ \-\ MG",
"55993665", "Capinzal\ do\ Norte\ \-\ MA",
"55383799", "Curvelo\ \-\ MG",
"55413443", "Guaratuba\ \-\ PR",
"55163706", "Franca\ \-\ SP",
"55553611", "Unistalda\ \-\ RS",
"55343356", "Nova\ Ponte\ \-\ MG",
"55172136", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55133279", "Santos\ \-\ SP",
"55493665", "Iraceminha\ \-\ SC",
"55143543", "Promissão\ \-\ SP",
"55213432", "Rio\ de\ Janeiro\ \-\ RJ",
"55193593", "Descalvado\ \-\ SP",
"55223723", "Macaé\ \-\ RJ",
"55114034", "Bragança\ Paulista\ \-\ SP",
"55114143", "Itapevi\ \-\ SP",
"55633474", "Araguatins\ \-\ TO",
"55313589", "Nova\ Lima\ \-\ MG",
"55213824", "Rio\ de\ Janeiro\ \-\ RJ",
"55273031", "Vila\ Velha\ \-\ ES",
"55113192", "São\ Paulo\ \-\ SP",
"55883536", "Lavras\ da\ Mangabeira\ \-\ CE",
"55143766", "Arandu\ \-\ SP",
"55314122", "Contagem\ \-\ MG",
"55843504", "Caicó\ \-\ RN",
"55543401", "Farroupilha\ \-\ RS",
"55313867", "São\ Sebastião\ do\ Rio\ Preto\ \-\ MG",
"5531320", "Minas\ Gerais",
"55673418", "Itaum\ \-\ MS",
"55613301", "Brasília\ \-\ DF",
"55114873", "São\ Paulo\ \-\ SP",
"55123878", "São\ José\ dos\ Campos\ \-\ SP",
"55353533", "Pratápolis\ \-\ MG",
"55623596", "Aparecida\ de\ Goiânia\ \-\ GO",
"55893452", "Wall\ Ferraz\ \-\ PI",
"55453902", "Cascavel\ \-\ PR",
"55433031", "Londrina\ \-\ PR",
"55943322", "Marabá\ \-\ PA",
"55333736", "Virgem\ da\ Lapa\ \-\ MG",
"55222771", "Rio\ das\ Ostras\ \-\ RJ",
"55773641", "Mansidão\ \-\ BA",
"55643512", "Rio\ Quente\ \-\ GO",
"55313235", "Belo\ Horizonte\ \-\ MG",
"55883426", "Banabuiú\ \-\ CE",
"55633375", "Pindorama\ do\ Tocantins\ \-\ TO",
"55343824", "Lagoa\ Formosa\ \-\ MG",
"55733234", "Ilhéus\ \-\ BA",
"55643603", "Iporá\ \-\ GO",
"55183272", "Presidente\ Venceslau\ \-\ SP",
"55823231", "Maceió\ \-\ AL",
"55353281", "Cristina\ \-\ MG",
"55623532", "Senador\ Canedo\ \-\ GO",
"55323539", "Ubá\ \-\ MG",
"55322104", "Juiz\ de\ Fora\ \-\ MG",
"55983488", "Santana\ do\ Maranhão\ \-\ MA",
"55333291", "Coroaci\ \-\ MG",
"55113368", "São\ Paulo\ \-\ SP",
"55413054", "Campo\ Largo\ \-\ PR",
"55354104", "Lavras\ \-\ MG",
"55443556", "Rancho\ Alegre\ D\'Oeste\ \-\ PR",
"55473362", "Presidente\ Nereu\ \-\ SC",
"55613634", "Padre\ Bernardo\ \-\ GO",
"55793215", "Aracaju\ \-\ SE",
"55453276", "Santa\ Helena\ \-\ PR",
"55313758", "Minas\ Gerais",
"55123186", "Cachoeira\ Paulista\ \-\ SP",
"55273229", "Vila\ Velha\ \-\ ES",
"55493256", "Fraiburgo\ \-\ SC",
"55843616", "Natal\ \-\ RN",
"55183334", "Presidente\ Prudente\ \-\ SP",
"55823263", "Marechal\ Deodoro\ \-\ AL",
"55473048", "Itajaí\ \-\ SC",
"55493567", "Caçador\ \-\ SC",
"55513049", "Campo\ Bom\ \-\ RS",
"55833321", "Campina\ Grande\ \-\ PB",
"55473340", "Blumenau\ \-\ SC",
"55433711", "Cambé\ \-\ PR",
"55123527", "Pindamonhangaba\ \-\ SP",
"55114576", "Mauá\ \-\ SP",
"55813648", "João\ Alfredo\ \-\ PE",
"55474141", "Itajaí\ \-\ SC",
"55193325", "Campinas\ \-\ SP",
"55114093", "Diadema\ \-\ SP",
"55353561", "Carmo\ do\ Rio\ Claro\ \-\ MG",
"55173441", "General\ Salgado\ \-\ SP",
"55193868", "Estiva\ Gerbi\ \-\ SP",
"55863477", "Inhuma\ \-\ PI",
"55793337", "Poço\ Redondo\ \-\ SE",
"55112277", "Bragança\ Paulista\ \-\ SP",
"55993639", "São\ Mateus\ do\ Maranhão\ \-\ MA",
"55933063", "Santarém\ \-\ PA",
"55654007", "Cuiabá\ \-\ MT",
"55513491", "Guaíba\ \-\ RS",
"55923365", "Novo\ Airão\ \-\ AM",
"55863241", "Boa\ Hora\ \-\ PI",
"55543379", "Coxilha\ \-\ RS",
"55143102", "Bauru\ \-\ SP",
"55663542", "Rondolândia\ \-\ MT",
"55173277", "Nipoã\ \-\ SP",
"55143372", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55983367", "Humberto\ de\ Campos\ \-\ MA",
"55183601", "Bento\ de\ Abreu\ \-\ SP",
"55993567", "São\ João\ do\ Soter\ \-\ MA",
"55753421", "Alagoinhas\ \-\ BA",
"55884102", "Crato\ \-\ CE",
"55623946", "Goiânia\ \-\ GO",
"55923491", "Carauari\ \-\ AM",
"55143888", "Pereiras\ \-\ SP",
"55713656", "São\ Sebastião\ do\ Passé\ \-\ BA",
"55483721", "Florianópolis\ \-\ SC",
"55123157", "Lorena\ \-\ SP",
"55693912", "Espigão\ do\ Oeste\ \-\ RO",
"55323551", "Visconde\ do\ Rio\ Branco\ \-\ MG",
"55273341", "Serra\ \-\ ES",
"55923675", "Manaus\ \-\ AM",
"5521329", "Rio\ de\ Janeiro\ \-\ RJ",
"5598324", "São\ Luís\ \-\ MA",
"55813686", "Belém\ de\ Maria\ \-\ PE",
"55143293", "Guaianás\ \-\ SP",
"55513464", "Canoas\ \-\ RS",
"55813561", "Ipojuca\ \-\ PE",
"55613262", "Brasília\ \-\ DF",
"55143662", "Bariri\ \-\ SP",
"55643465", "Urutaí\ \-\ GO",
"55223058", "Cabo\ Frio\ \-\ RJ",
"55163513", "Sertãozinho\ \-\ SP",
"55513675", "Cerro\ Grande\ do\ Sul\ \-\ RS",
"55613479", "Brazlândia\ \-\ DF",
"55383567", "Varjão\ de\ Minas\ \-\ MG",
"55112622", "São\ Paulo\ \-\ SP",
"55753283", "Paulo\ Afonso\ \-\ BA",
"55473702", "Blumenau\ \-\ SC",
"55613962", "Brasília\ \-\ DF",
"55643674", "Iporá\ \-\ GO",
"55173484", "Monções\ \-\ SP",
"55413628", "Campo\ do\ Tenente\ \-\ PR",
"55114445", "Caieiras\ \-\ SP",
"55553270", "São\ Miguel\ \-\ RS",
"55283524", "Vargem\ Grande\ do\ Soturno\ \-\ ES",
"55543537", "Caxias\ do\ Sul\ \-\ RS",
"55693341", "Colorado\ do\ Oeste\ \-\ RO",
"55663405", "Barra\ do\ Garças\ \-\ MT",
"55673289", "Rochedo\ \-\ MS",
"55173622", "Jales\ \-\ SP",
"55623004", "Goiânia\ \-\ GO",
"55624106", "Trindade\ \-\ GO",
"55193682", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55733662", "Jucuruçu\ \-\ BA",
"55483052", "Tubarão\ \-\ SC",
"5561", "Federal\ District",
"55693485", "Espigão\ D\'Oeste\ \-\ RO",
"55143846", "Areiópolis\ \-\ SP",
"55133877", "Santos\ \-\ SP",
"55193896", "Santo\ Antônio\ de\ Posse\ \-\ SP",
"55143417", "Marília\ \-\ SP",
"55613013", "Brasília\ \-\ DF",
"55163398", "Fazenda\ Babilônia\ \-\ SP",
"55623988", "Goiânia\ \-\ GO",
"55883683", "Ipu\ \-\ CE",
"55413517", "São\ José\ dos\ Pinhais\ \-\ PR",
"55863284", "Barro\ Duro\ \-\ PI",
"55733293", "Alcobaça\ \-\ BA",
"55313472", "Minas\ Gerais",
"55684001", "Rio\ Branco\ \-\ AC",
"55373071", "Divinópolis\ \-\ MG",
"55273711", "Colatina\ \-\ ES",
"55753642", "Jaguaripe\ \-\ BA",
"55313253", "Belo\ Horizonte\ \-\ MG",
"55313269", "Belo\ Horizonte\ \-\ MG",
"55423675", "Copel\ \-\ PR",
"55633026", "Palmas\ \-\ TO",
"55113180", "São\ Paulo\ \-\ SP",
"55473901", "Blumenau\ \-\ SC",
"55873849", "Itaíba\ \-\ PE",
"55623288", "Aparecida\ de\ Goiânia\ \-\ GO",
"55353555", "Guaranésia\ \-\ MG",
"55883655", "Frecheirinha\ \-\ CE",
"55863293", "Regeneração\ \-\ PI",
"55433272", "Jaguapitã\ \-\ PR",
"55733284", "Canavieiras\ \-\ BA",
"55623582", "Goiânia\ \-\ GO",
"55123678", "Natividade\ da\ Serra\ \-\ SP",
"55473346", "Itajaí\ \-\ SC",
"55823281", "União\ dos\ Palmares\ \-\ AL",
"55242104", "Petrópolis\ \-\ RJ",
"55333318", "Caratinga\ \-\ MG",
"55214139", "Maricá\ \-\ RJ",
"55483438", "Criciúma\ \-\ SC",
"55513443", "Alvorada\ \-\ RS",
"55793522", "Estância\ \-\ SE",
"55443401", "Cianorte\ \-\ PR",
"55543319", "Montauri\ \-\ RS",
"55353857", "Campo\ do\ Meio\ \-\ MG",
"55493237", "Capão\ Alto\ \-\ SC",
"55313377", "Belo\ Horizonte\ \-\ MG",
"55823533", "Jaramataia\ \-\ AL",
"55113501", "São\ Paulo\ \-\ SP",
"55433453", "Kaloré\ \-\ PR",
"55313107", "Sete\ Lagoas\ \-\ MG",
"55212133", "Rio\ de\ Janeiro\ \-\ RJ",
"55812119", "Recife\ \-\ PE",
"55843398", "Serrinha\ dos\ Pintos\ \-\ RN",
"55553333", "Ijuí\ \-\ RS",
"55143284", "Pederneiras\ \-\ SP",
"55273044", "Colatina\ \-\ ES",
"55115696", "São\ Paulo\ \-\ SP",
"55853667", "Itarema\ \-\ CE",
"55713637", "Vera\ Cruz\ \-\ BA",
"55643489", "Água\ Limpa\ \-\ GO",
"55673021", "Dourados\ \-\ MS",
"55973346", "Uarini\ \-\ AM",
"55613568", "Guará\ \-\ DF",
"55353732", "Ipuiúna\ \-\ MG",
"55115632", "São\ Paulo\ \-\ SP",
"55222031", "Saquarema\ \-\ RJ",
"55733312", "Itamaraju\ \-\ BA",
"55873854", "Carnaíba\ \-\ PE",
"55753294", "Água\ Fria\ \-\ BA",
"55883548", "Altaneira\ \-\ CE",
"55112493", "Atibaia\ \-\ SP",
"55433906", "Rolândia\ \-\ PR",
"55173353", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55542991", "Caxias\ do\ Sul\ \-\ RS",
"55212771", "Duque\ de\ Caxias\ \-\ RJ",
"55543267", "Vila\ Seca\ \-\ RS",
"55513054", "Viamão\ \-\ RS",
"55733241", "Coaraci\ \-\ BA",
"55853377", "Itaitinga\ \-\ CE",
"55623301", "Leopoldo\ de\ Bulhões\ \-\ GO",
"55383237", "Claro\ dos\ Poções\ \-\ MG",
"55373546", "Biquinhas\ \-\ MG",
"55273771", "São\ Mateus\ \-\ ES",
"5561344", "Brasília\ \-\ DF",
"55433133", "Cornélio\ Procópio\ \-\ PR",
"55343215", "Uberlândia\ \-\ MG",
"55473388", "Doutor\ Pedrinho\ \-\ SC",
"55613532", "Brasília\ \-\ DF",
"55142105", "Marília\ \-\ SP",
"55673687", "Miranda\ \-\ MS",
"55553276", "São\ Pedro\ do\ Sul\ \-\ RS",
"55513389", "Rio\ Grande\ do\ Sul",
"55114774", "Itapevi\ \-\ SP",
"55543322", "Quinze\ de\ Novembro\ \-\ RS",
"55813231", "Recife\ \-\ PE",
"55753261", "Serrinha\ \-\ BA",
"55753025", "Feira\ de\ Santana\ \-\ BA",
"55473080", "Blumenau\ \-\ SC",
"55443635", "Japurá\ \-\ PR",
"55983462", "Cantanhede\ \-\ MA",
"55133446", "Mongaguá\ \-\ SP",
"55673251", "Jardim\ \-\ MS",
"55843366", "Janduís\ \-\ RN",
"55143477", "Arco\-Íris\ \-\ SP",
"55193792", "Limeira\ \-\ SP",
"55823423", "Igaci\ \-\ AL",
"55883661", "Acaraú\ \-\ CE",
"55813732", "Fazenda\ Nova\ \-\ PE",
"55533031", "Pelotas\ \-\ RS",
"55643614", "Santa\ Helena\ de\ Goiás\ \-\ GO",
"55793432", "Itabaiana\ \-\ SE",
"55493328", "Chapecó\ \-\ SC",
"55313539", "Betim\ \-\ MG",
"55373691", "Divinópolis\ \-\ MG",
"55513615", "Caraá\ \-\ RS",
"55273081", "Vitória\ \-\ ES",
"55883586", "Crato\ \-\ CE",
"55483462", "Criciúma\ \-\ SC",
"55483279", "Palhoça\ \-\ SC",
"55433627", "Leópolis\ \-\ PR",
"55173045", "Catanduva\ \-\ SP",
"55833254", "Cruz\ do\ Espírito\ Santo\ \-\ PB",
"55114084", "São\ Paulo\ \-\ SP",
"55933518", "Itaituba\ \-\ PA",
"55243377", "Angra\ dos\ Reis\ \-\ RJ",
"55833295", "Jacaraú\ \-\ PB",
"55273272", "Guarapari\ \-\ ES",
"55313667", "Coronel\ Fabriciano\ \-\ MG",
"55732105", "Porto\ Seguro\ \-\ BA",
"55813692", "Lagoa\ dos\ Gatos\ \-\ PE",
"5512395", "Jacareí\ \-\ SP",
"55193016", "Indaiatuba\ \-\ SP",
"55193541", "Araras\ \-\ SP",
"55673239", "Água\ Clara\ \-\ MS",
"55313121", "Igarapé\ \-\ MG",
"551137", "São\ Paulo\ \-\ SP",
"55123042", "São\ José\ dos\ Campos\ \-\ SP",
"55743677", "Ponto\ Novo\ \-\ BA",
"55542108", "Caxias\ do\ Sul\ \-\ RS",
"55114604", "Mairiporã\ \-\ SP",
"55443427", "Porto\ Rico\ \-\ PR",
"55163810", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55333325", "Imbé\ de\ Minas\ \-\ MG",
"55883409", "Russas\ \-\ CE",
"55112822", "Osasco\ \-\ SP",
"55833545", "São\ Francisco\ \-\ PB",
"55333534", "Padre\ Paraíso\ \-\ MG",
"55133219", "Santos\ \-\ SP",
"55473467", "Joinville\ \-\ SC",
"55813636", "Paudalho\ \-\ PE",
"55553355", "Caibaté\ \-\ RS",
"55273194", "Vitória\ \-\ ES",
"55183341", "Cândido\ Mota\ \-\ SP",
"55433435", "Manoel\ Ribas\ \-\ PR",
"55183229", "Presidente\ Prudente\ \-\ SP",
"55143646", "Mineiros\ do\ Tietê\ \-\ SP",
"55193882", "Cosmópolis\ \-\ SP",
"55823555", "São\ Brás\ \-\ AL",
"55463523", "Francisco\ Beltrão\ \-\ PR",
"55663027", "Rondonópolis\ \-\ MT",
"55883557", "Porteiras\ \-\ CE",
"55813000", "Recife\ \-\ PE",
"55943379", "São\ João\ do\ Araguaia\ \-\ PA",
"55313551", "Ouro\ Preto\ \-\ MG",
"55492102", "Lages\ \-\ SC",
"55483877", "Florianópolis\ \-\ SC",
"55943427", "Água\ Azul\ do\ Norte\ \-\ PA",
"55373232", "Pará\ de\ Minas\ \-\ MG",
"55883530", "Araripe\ \-\ CE",
"55883633", "Ararendá\ \-\ CE",
"55693435", "Novo\ Horizonte\ do\ Oeste\ \-\ RO",
"55883420", "São\ João\ do\ Jaguaribe\ \-\ CE",
"5577", "Bahia",
"55123974", "Paraibuna\ \-\ SP",
"55663566", "Juína\ \-\ MT",
"55893497", "Betânia\ do\ Piauí\ \-\ PI",
"55693525", "Vale\ do\ Anari\ \-\ RO",
"55193584", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55873785", "Lagoa\ do\ Ouro\ \-\ PE",
"55823686", "Xingó\ \-\ AL",
"55793275", "Maruim\ \-\ SE",
"55713797", "Salvador\ \-\ BA",
"55333243", "Central\ de\ Minas\ \-\ MG",
"55343228", "Uberlândia\ \-\ MG",
"55913464", "Atalaia\ \-\ PA",
"55163146", "Itirapuã\ \-\ SP",
"55353692", "Itajubá\ \-\ MG",
"55112819", "Mogi\ das\ Cruzes\ \-\ SP",
"55613004", "Brasília\ \-\ DF",
"55753544", "Ubaíra\ \-\ BA",
"55173819", "Poloni\ \-\ SP",
"55683325", "Marechal\ Thaumaturgo\ \-\ AC",
"55733688", "Piraí\ do\ Norte\ \-\ BA",
"55433525", "Jacarezinho\ \-\ PR",
"55114703", "Cotia\ \-\ SP",
"55353263", "Monsenhor\ Paulo\ \-\ MG",
"55433334", "Londrina\ \-\ PR",
"55753698", "Santa\ Brígida\ \-\ BA",
"55323747", "Alto\ Caparaó\ \-\ MG",
"55382102", "Unaí\ \-\ MG",
"55443653", "Tuneiras\ do\ Oeste\ \-\ PR",
"55185841", "Junqueirópolis\ \-\ SP",
"55773693", "Rio\ do\ Pires\ \-\ BA",
"55773262", "Itapetinga\ \-\ BA",
"5562", "Goiás",
"55114164", "Carapicuíba\ \-\ SP",
"55383745", "Lagoa\ dos\ Patos\ \-\ MG",
"55333424", "Senhora\ do\ Porto\ \-\ MG",
"55353012", "Itajubá\ \-\ MG",
"55112524", "São\ Paulo\ \-\ SP",
"55843271", "Macaíba\ \-\ RN",
"55773479", "Piatã\ \-\ BA",
"55273161", "Guarapari\ \-\ ES",
"55513628", "Maquiné\ \-\ RS",
"55112335", "São\ Paulo\ \-\ SP",
"55473629", "Bela\ Vista\ do\ Toldo\ \-\ SC",
"55453270", "Iguiporã\ \-\ PR",
"55163342", "Ibitinga\ \-\ SP",
"55443537", "Engenheiro\ Beltrão\ \-\ PR",
"55163729", "Ituverava\ \-\ SP",
"55323253", "Tabuleiro\ \-\ MG",
"55173524", "Catanduva\ \-\ SP",
"55553361", "Giruá\ \-\ RS",
"55413675", "Colombo\ \-\ PR",
"55713289", "Lauro\ de\ Freitas\ \-\ BA",
"55173335", "Colômbia\ \-\ SP",
"55113437", "Guarulhos\ \-\ SP",
"55673478", "Tacuru\ \-\ MS",
"55114813", "Itu\ \-\ SP",
"55313229", "Minas\ Gerais",
"55313578", "Piedade\ dos\ Gerais\ \-\ MG",
"55173846", "Mira\ Estrela\ \-\ SP",
"55513757", "Nova\ Bréscia\ \-\ RS",
"55443201", "Campo\ Mourão\ \-\ PR",
"55623877", "Goiânia\ \-\ GO",
"55193351", "Araras\ \-\ SP",
"55493437", "Passos\ Maia\ \-\ SC",
"55223843", "Varre\-Sai\ \-\ RJ",
"55373275", "São\ José\ da\ Varginha\ \-\ MG",
"55193675", "Tambaú\ \-\ SP",
"55114652", "Arujá\ \-\ SP",
"55433253", "Cambé\ \-\ PR",
"55433472", "Ivaiporã\ \-\ PR",
"55513730", "Passo\ do\ Sobrado\ \-\ RS",
"55343071", "Uberaba\ \-\ MG",
"55193464", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55833394", "Ingá\ \-\ PB",
"55653046", "Cuiabá\ \-\ MT",
"55553545", "Porto\ Mauá\ \-\ RS",
"55693253", "Vila\ Nova\ Califórnia\ \-\ RO",
"55123026", "Taubaté\ \-\ SP",
"55353431", "Cambuí\ \-\ MG",
"55733622", "Mucuri\ \-\ BA",
"55633437", "Cachoeirinha\ \-\ TO",
"55663486", "Pedra\ Preta\ \-\ MT",
"55823481", "Arapiraca\ \-\ AL",
"55183551", "Lucélia\ \-\ SP",
"55443901", "Maringá\ \-\ PR",
"55793268", "General\ Maynard\ \-\ SE",
"55833355", "São\ João\ do\ Cariri\ \-\ PB",
"55463025", "Pato\ Branco\ \-\ PR",
"55453249", "Anahy\ \-\ PR",
"55773440", "Piripá\ \-\ BA",
"55513243", "Rio\ Grande\ do\ Sul",
"55843320", "Baraúna\ \-\ RN",
"55112662", "São\ Paulo\ \-\ SP",
"55963261", "Macapá\ \-\ AP",
"55153298", "Pilar\ do\ Sul\ \-\ SP",
"55453321", "Cascavel\ \-\ PR",
"55173293", "Palestina\ \-\ SP",
"55383527", "Turmalina\ \-\ MG",
"55333628", "Umburatiba\ \-\ MG",
"55273317", "Vitória\ \-\ ES",
"55853384", "Maracanaú\ \-\ CE",
"55753494", "Canudos\ \-\ BA",
"55323334", "Santana\ do\ Garambéu\ \-\ MG",
"55173662", "Santa\ Salete\ \-\ SP",
"55923682", "Manaus\ \-\ AM",
"55413668", "Pinhais\ \-\ PR",
"55613367", "Brasília\ \-\ DF",
"55673465", "Jateí\ \-\ MS",
"55413584", "Curitiba\ \-\ PR",
"55222551", "Cordeiro\ \-\ RJ",
"555131", "Rio\ Grande\ do\ Sul",
"55114787", "Taboão\ da\ Serra\ \-\ SP",
"55673674", "Bela\ Vista\ \-\ MS",
"55143484", "Álvaro\ de\ Carvalho\ \-\ SP",
"55423243", "Ponta\ Grossa\ \-\ PR",
"55893547", "São\ Miguel\ do\ Fidalgo\ \-\ PI",
"55513682", "Balneário\ Pinhal\ \-\ RS",
"55513424", "Rio\ Grande\ do\ Sul",
"55813521", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55543036", "Gramado\ \-\ RS",
"55452103", "Toledo\ \-\ PR",
"5561324", "Brasília\ \-\ DF",
"55213540", "Nova\ Iguaçu\ \-\ RJ",
"55114408", "Cajamar\ \-\ SP",
"55512109", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55343415", "Iturama\ \-\ MG",
"55213643", "Teresópolis\ \-\ RJ",
"55413070", "Fazenda\ Rio\ Grande\ \-\ PR",
"55843258", "São\ Tomé\ \-\ RN",
"55143385", "Tejupá\ \-\ SP",
"55813431", "Olinda\ \-\ PE",
"55983262", "São\ Luís\ \-\ MA",
"55613677", "Planaltina\ \-\ GO",
"55173638", "Mesópolis\ \-\ SP",
"55673451", "Itaporã\ \-\ MS",
"55143277", "Bauru\ \-\ SP",
"55413632", "Piên\ \-\ PR",
"55213781", "Itaguaí\ \-\ RJ",
"55623515", "Goiânia\ \-\ GO",
"55222565", "Bom\ Jardim\ \-\ RJ",
"55983479", "Tutóia\ \-\ MA",
"5548", "Santa\ Catarina",
"55923534", "Nhamundá\ \-\ AM",
"55873032", "Petrolina\ \-\ PE",
"55153266", "Iperó\ \-\ SP",
"55414001", "Curitiba\ \-\ PR",
"55313912", "Contagem\ \-\ MG",
"55153557", "Itaóca\ \-\ SP",
"5598", "Maranhão",
"55733277", "Guaratinga\ \-\ BA",
"55212747", "Tanguá\ \-\ RJ",
"55863369", "Cajueiro\ da\ Praia\ \-\ PI",
"55983013", "São\ Luís\ \-\ MA",
"55443048", "Sarandi\ \-\ PR",
"55833454", "Ibiara\ \-\ PB",
"55553402", "Uruguaiana\ \-\ RS",
"55443340", "Alto\ Alegre\ \-\ PR",
"55193828", "Sumaré\ \-\ SP",
"55163326", "Boa\ Esperança\ do\ Sul\ \-\ SP",
"55853341", "Maranguape\ \-\ CE",
"55633527", "Santa\ Tereza\ do\ Tocantins\ \-\ TO",
"55353521", "Passos\ \-\ MG",
"55313711", "Prudente\ de\ Morais\ \-\ MG",
"55823223", "Maceió\ \-\ AL",
"55273253", "Serra\ \-\ ES",
"55493527", "Joaçaba\ \-\ SC",
"55273269", "Alfredo\ Chaves\ \-\ ES",
"55674062", "Campo\ Grande\ \-\ MS",
"55414114", "Curitiba\ \-\ PR",
"55653904", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55113414", "Itu\ \-\ SP",
"55313384", "Belo\ Horizonte\ \-\ MG",
"55543612", "Muitos\ Capões\ \-\ RS",
"55833361", "Esperança\ \-\ PB",
"55193491", "Capivari\ \-\ SP",
"55213982", "Rio\ de\ Janeiro\ \-\ RJ",
"55143441", "Tupã\ \-\ SP",
"55483262", "Governador\ Celso\ Ramos\ \-\ SC",
"55133419", "Pedro\ de\ Toledo\ \-\ SP",
"55143879", "Bauru\ \-\ SP",
"55383625", "Varzelândia\ \-\ MG",
"55473556", "Santa\ Terezinha\ \-\ SC",
"55793546", "Umbaúba\ \-\ SE",
"55463544", "Enéas\ Marques\ \-\ PR",
"55843695", "Lagoa\ de\ Velhos\ \-\ RN",
"55673439", "Bela\ Vista\ \-\ MS",
"55513748", "Lajeado\ \-\ RS",
"55743532", "Pilar\ \-\ BA",
"55543388", "Bento\ Gonçalves\ \-\ RS",
"55653336", "Diamantino\ \-\ MT",
"55773438", "Cândido\ Sales\ \-\ BA",
"55163411", "São\ Carlos\ \-\ SP",
"55813459", "Aldeia\ \-\ PE",
"55413291", "Campo\ Largo\ \-\ PR",
"55873876", "Belém\ de\ São\ Francisco\ \-\ PE",
"55323393", "Senhora\ das\ Dores\ \-\ MG",
"55843654", "Natal\ \-\ RN",
"55753433", "Subaúma\ \-\ BA",
"55314138", "Vespasiano\ \-\ MG",
"55193577", "Corumbataí\ \-\ SP",
"55133596", "Praia\ Grande\ \-\ SP",
"5516361", "Ribeirão\ Preto\ \-\ SP",
"55493382", "Xanxerê\ \-\ SC",
"55823035", "Maceió\ \-\ AL",
"5519373", "Campinas\ \-\ SP",
"55893558", "São\ Francisco\ do\ Piauí\ \-\ PI",
"55213891", "Rio\ de\ Janeiro\ \-\ RJ",
"55693235", "Porto\ Velho\ \-\ RO",
"55743641", "Irecê\ \-\ BA",
"55433235", "Primeiro\ de\ Maio\ \-\ PR",
"55623438", "São\ João\ D\'Aliança\ \-\ GO",
"55753609", "Bravo\ \-\ BA",
"551120", "São\ Paulo\ \-\ SP",
"55123105", "Aparecida\ \-\ SP",
"55183285", "Caiabu\ \-\ SP",
"55242522", "Nova\ Friburgo\ \-\ RJ",
"55183377", "Florínia\ \-\ SP",
"55513786", "Rio\ Grande\ do\ Sul",
"55923318", "Nova\ Olinda\ do\ Norte\ \-\ AM",
"55623528", "Caturaí\ \-\ GO",
"55182104", "Presidente\ Prudente\ \-\ SP",
"55173543", "Novo\ Horizonte\ \-\ SP",
"55543346", "Ciríaco\ \-\ RS",
"55383214", "Montes\ Claros\ \-\ MG",
"55163075", "Ribeirão\ Preto\ \-\ SP",
"55353463", "Bueno\ Brandão\ \-\ MG",
"55153548", "Itapirapuã\ Paulista\ \-\ SP",
"55463233", "Coronel\ Vivida\ \-\ PR",
"55313827", "Minas\ Gerais",
"55114897", "Itu\ \-\ SP",
"55273235", "Vitória\ \-\ ES",
"55213113", "Rio\ de\ Janeiro\ \-\ RJ",
"55373522", "Bom\ Despacho\ \-\ MG",
"55463581", "Dois\ Vizinhos\ \-\ PR",
"55115049", "São\ Paulo\ \-\ SP",
"55843247", "Pedro\ Velho\ \-\ RN",
"55833276", "Pilões\ \-\ PB",
"55773617", "Baianópolis\ \-\ BA",
"55623979", "Anápolis\ \-\ GO",
"55193705", "Campinas\ \-\ SP",
"55473319", "Navegantes\ \-\ SC",
"55623097", "Aparecida\ de\ Goiânia\ \-\ GO",
"55493625", "Belmonte\ \-\ SC",
"55343428", "Fronteira\ \-\ MG",
"55613488", "Brasília\ \-\ DF",
"55843471", "Parelhas\ \-\ RN",
"55174003", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55853031", "Fortaleza\ \-\ CE",
"55713225", "Feira\ de\ Santana\ \-\ BA",
"55653273", "Curvelândia\ \-\ MT",
"55323453", "Dona\ Eusébia\ \-\ MG",
"55443672", "Rondon\ \-\ PR",
"55743684", "Canarana\ \-\ BA",
"5511501", "São\ Paulo\ \-\ SP",
"55624051", "Anápolis\ \-\ GO",
"55673278", "Rio\ Negro\ \-\ MS",
"55643637", "Aparecida\ do\ Rio\ Doce\ \-\ GO",
"55513593", "Novo\ Hamburgo\ \-\ RS",
"55483301", "Tubarão\ \-\ SC",
"55323272", "Simão\ Pereira\ \-\ MG",
"55553254", "Cacequi\ \-\ RS",
"55513690", "Rio\ Grande\ do\ Sul",
"55683615", "Santa\ Rosa\ do\ Purus\ \-\ AC",
"55773462", "Caetanos\ \-\ BA",
"55933589", "Santarém\ \-\ PA",
"55273758", "Mantenópolis\ \-\ ES",
"55222667", "Araruama\ \-\ RJ",
"55513668", "Palmares\ do\ Sul\ \-\ RS",
"55333351", "Raul\ Soares\ \-\ MG",
"55473653", "Papanduva\ \-\ SC",
"55112838", "São\ Paulo\ \-\ SP",
"55793643", "Riachão\ do\ Dantas\ \-\ SE",
"55553321", "Cruz\ Alta\ \-\ RS",
"5555321", "Santa\ Maria\ \-\ RS",
"55213731", "Maricá\ \-\ RJ",
"55323229", "Juiz\ de\ Fora\ \-\ MG",
"55323578", "Guidoval\ \-\ MG",
"55353444", "Jacutinga\ \-\ MG",
"55173564", "Catiguá\ \-\ SP",
"55923584", "Manaus\ \-\ AM",
"55163947", "Sertãozinho\ \-\ SP",
"55613877", "Brasília\ \-\ DF",
"55173838", "Pedranópolis\ \-\ SP",
"55873870", "Trindade\ \-\ PE",
"55443629", "Cianorte\ \-\ PR",
"55473537", "Chapadão\ do\ Lageado\ \-\ SC",
"55483246", "São\ José\ \-\ SC",
"55793314", "Itabi\ \-\ SE",
"55543702", "Bento\ Gonçalves\ \-\ RS",
"55115095", "São\ Paulo\ \-\ SP",
"55112688", "Guarulhos\ \-\ SP",
"55513584", "Novo\ Hamburgo\ \-\ RS",
"55673033", "Dourados\ \-\ MS",
"55143335", "Ourinhos\ \-\ SP",
"55813481", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55313194", "Belo\ Horizonte\ \-\ MG",
"55643478", "Ouvidor\ \-\ GO",
"55542628", "Farroupilha\ \-\ RS",
"55313334", "Minas\ Gerais",
"5574", "Bahia",
"55873772", "Correntes\ \-\ PE",
"55313525", "Minas\ Gerais",
"55873816", "Buíque\ \-\ PE",
"55913424", "Redenção\ \-\ PA",
"55114595", "Várzea\ Paulista\ \-\ SP",
"55623367", "Porangatu\ \-\ GO",
"55623922", "Goiânia\ \-\ GO",
"55353223", "Varginha\ \-\ MG",
"55373228", "Nova\ Serrana\ \-\ MG",
"55193628", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55433565", "São\ José\ da\ Boa\ Vista\ \-\ PR",
"5531340", "Minas\ Gerais",
"55153242", "Votorantim\ \-\ SP",
"55323341", "Ressaquinha\ \-\ MG",
"55663526", "Porto\ dos\ Gaúchos\ \-\ MT",
"55823521", "Arapiraca\ \-\ AL",
"55553249", "Santiago\ \-\ RS",
"55353715", "Poços\ de\ Caldas\ \-\ MG",
"55343268", "Ituiutaba\ \-\ MG",
"55115615", "São\ Paulo\ \-\ SP",
"55453545", "Foz\ do\ Iguaçu\ \-\ PR",
"55243334", "Rio\ Claro\ \-\ RJ",
"55214125", "Belford\ Roxo\ \-\ RJ",
"55543340", "Vanini\ \-\ RS",
"55242228", "Secretário\ \-\ RJ",
"55423632", "Jordãozinho\ \-\ PR",
"55112646", "São\ Paulo\ \-\ SP",
"55124408", "Polvilho\ \-\ SP",
"55433551", "Ribeirão\ do\ Pinhal\ \-\ PR",
"55113403", "Bragança\ Paulista\ \-\ SP",
"55893473", "Massapê\ do\ Piauí\ \-\ PI",
"55923016", "Manaus\ \-\ AM",
"55513780", "Rio\ Grande\ do\ Sul",
"55633487", "São\ Bento\ do\ Tocantins\ \-\ TO",
"55153311", "Sorocaba\ \-\ SP",
"55663436", "Poxoréo\ \-\ MT",
"55114852", "Santo\ André\ \-\ SP",
"5515322", "Sorocaba\ \-\ SP",
"55193875", "Indaiatuba\ \-\ SP",
"55683464", "Jordão\ \-\ AC",
"55424001", "Ponta\ Grossa\ \-\ PR",
"5511507", "São\ Paulo\ \-\ SP",
"55973379", "Novo\ Aripuanã\ \-\ AM",
"55463563", "Santo\ Antônio\ do\ Sudoeste\ \-\ PR",
"55463559", "Quedas\ do\ Iguaçu\ \-\ PR",
"55983004", "São\ Luís\ \-\ MA",
"55183269", "Pirapozinho\ \-\ SP",
"55714062", "Salvador\ \-\ BA",
"55513541", "Taquara\ \-\ RS",
"55973427", "Juruá\ \-\ AM",
"55343232", "Uberlândia\ \-\ MG",
"55313435", "Belo\ Horizonte\ \-\ MG",
"55544141", "Caxias\ do\ Sul\ \-\ RS",
"55484106", "Florianópolis\ \-\ SC",
"55513632", "Montenegro\ \-\ RS",
"55343843", "Estrela\ do\ Sul\ \-\ MG",
"55473379", "Massaranduba\ \-\ SC",
"55713083", "Salvador\ \-\ BA",
"55112862", "São\ Paulo\ \-\ SP",
"55773677", "Érico\ Cardoso\ \-\ BA",
"55222747", "Farol\ de\ São\ Tomé\ \-\ RJ",
"55213303", "Duque\ de\ Caxias\ \-\ RJ",
"55112591", "São\ Paulo\ \-\ SP",
"55713451", "Salvador\ \-\ BA",
"55413534", "São\ José\ dos\ Pinhais\ \-\ PR",
"55473427", "Joinville\ \-\ SC",
"55552103", "Santa\ Maria\ \-\ RS",
"55753626", "Feira\ de\ Santana\ \-\ BA",
"55183406", "Guararapes\ \-\ SP",
"55853334", "Cascavel\ \-\ CE",
"55313161", "Ribeirão\ das\ Neves\ \-\ MG",
"55353345", "Carvalhos\ \-\ MG",
"55643656", "Caçu\ \-\ GO",
"55514001", "Porto\ Alegre\ \-\ RS",
"55513696", "Barão\ \-\ RS",
"55323711", "Vermelho\ \-\ MG",
"5516336", "São\ Carlos\ \-\ SP",
"55112840", "Salto\ \-\ SP",
"55633368", "Pium\ \-\ TO",
"5518390", "Presidente\ Prudente\ \-\ SP",
"55863385", "São\ João\ do\ Arraial\ \-\ PI",
"55163258", "Fernando\ Prestes\ \-\ SP",
"55213664", "Belford\ Roxo\ \-\ RJ",
"55513792", "Costão\ \-\ RS",
"5511345", "São\ Paulo\ \-\ SP",
"5511589", "São\ Paulo\ \-\ SP",
"55693539", "Rio\ Crespo\ \-\ RO",
"55313627", "Ribeirão\ das\ Neves\ \-\ MG",
"55633456", "Augustinópolis\ \-\ TO",
"55343691", "Araxá\ \-\ MG",
"55863277", "Capitão\ de\ Campos\ \-\ PI",
"55553307", "Santa\ Maria\ \-\ RS",
"55773446", "Aracatu\ \-\ BA",
"55883621", "Camocim\ \-\ CE",
"55493456", "Campina\ da\ Alegria\ \-\ SC",
"55793113", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55313393", "Minas\ Gerais",
"55432104", "Londrina\ \-\ PR",
"55512126", "Porto\ Alegre\ \-\ RS",
"55513736", "Estrêla\ \-\ RS",
"55163958", "Taquaral\ \-\ SP",
"55713500", "Salvador\ \-\ BA",
"55963283", "Santana\ \-\ AP",
"55543362", "Nonoai\ \-\ RS",
"55319", "Minas\ Gerais",
"55833449", "Riacho\ dos\ Cavalos\ \-\ PB",
"55114017", "Jarinu\ \-\ SP",
"55383678", "Riachinho\ \-\ MG",
"55843326", "Tibau\ \-\ RN",
"55743634", "Caldeirão\ Grande\ \-\ BA",
"55693412", "Alvorada\ do\ Oeste\ \-\ RO",
"55173329", "Alberto\ Moreira\ \-\ SP",
"55373215", "Divinópolis\ \-\ MG",
"55643687", "Córrego\ do\ Ouro\ \-\ GO",
"55113375", "São\ Paulo\ \-\ SP",
"55623446", "Alto\ Paraíso\ de\ Goiás\ \-\ GO",
"55473635", "São\ Bento\ do\ Sul\ \-\ SC",
"55843552", "Galinhos\ \-\ RN",
"55113651", "Osasco\ \-\ SP",
"55323031", "Juiz\ de\ Fora\ \-\ MG",
"55543338", "Victor\ Graeff\ \-\ RS",
"55653386", "São\ José\ do\ Rio\ Claro\ \-\ MT",
"55773488", "Correntina\ \-\ BA",
"55133841", "Iguape\ \-\ SP",
"55112284", "Osasco\ \-\ SP",
"55963421", "Amapá\ \-\ AP",
"55173284", "Ribeiro\ dos\ Santos\ \-\ SP",
"5511272", "São\ Paulo\ \-\ SP",
"55673225", "Coxim\ \-\ MS",
"55242723", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55383825", "Montezuma\ \-\ MG",
"55673489", "Indápolis\ \-\ MS",
"55313771", "Sete\ Lagoas\ \-\ MG",
"55223864", "Aperibé\ \-\ RJ",
"55943346", "Parauapebas\ \-\ PA",
"55213763", "Mesquita\ \-\ RJ",
"55883442", "Madalena\ \-\ CE",
"55143493", "Varpa\ \-\ SP",
"55513264", "Rio\ Grande\ do\ Sul",
"55214118", "Rio\ de\ Janeiro\ \-\ RJ",
"55483641", "Tijucas\ \-\ SC",
"55453254", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55543057", "Bento\ Gonçalves\ \-\ RS",
"55333339", "Manhuaçu\ \-\ MG",
"55483532", "Praia\ Grande\ \-\ SC",
"55343664", "Araxá\ \-\ MG",
"55322152", "Juiz\ de\ Fora\ \-\ MG",
"55283543", "Ibatiba\ \-\ ES",
"55193924", "Águas\ de\ Lindóia\ \-\ SP",
"55153003", "Sorocaba\ \-\ SP",
"55733679", "Porto\ Seguro\ \-\ BA",
"55623488", "Simolândia\ \-\ GO",
"55213691", "Japeri\ \-\ RJ",
"55623575", "Goiânia\ \-\ GO",
"55433429", "Califórnia\ \-\ PR",
"55173312", "Barretos\ \-\ SP",
"55813728", "Bezerros\ \-\ PE",
"55613617", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55812138", "Recife\ \-\ PE",
"55212667", "Nova\ Iguaçu\ \-\ RJ",
"55633396", "São\ Salvador\ do\ Tocantins\ \-\ TO",
"55853133", "Fortaleza\ \-\ CE",
"55493678", "Itapiranga\ \-\ SC",
"55112312", "Mogi\ das\ Cruzes\ \-\ SP",
"55222758", "São\ Fidélis\ \-\ RJ",
"5519378", "Campinas\ \-\ SP",
"55833383", "Soledade\ \-\ PB",
"55493332", "Águas\ Frias\ \-\ SC",
"55823256", "Flexeiras\ \-\ AL",
"55543544", "Entre\ Rios\ do\ Sul\ \-\ RS",
"55443642", "Guaíra\ \-\ PR",
"55883565", "Acopiara\ \-\ CE",
"55673248", "Costa\ Rica\ \-\ MS",
"55493636", "São\ João\ do\ Oeste\ \-\ SC",
"55333751", "Pedra\ Azul\ \-\ MG",
"55733258", "Maraú\ \-\ BA",
"55133495", "Praia\ Grande\ \-\ SP",
"55863326", "Timon\ \-\ MA",
"55633692", "Dianópolis\ \-\ TO",
"55433056", "Arapongas\ \-\ PR",
"55163353", "Ibaté\ \-\ SP",
"55192106", "Piracicaba\ \-\ SP",
"55333252", "Joanésia\ \-\ MG",
"55423511", "Santo\ Antônio\ do\ Iratim\ \-\ PR",
"55643480", "Edealina\ \-\ GO",
"55323741", "Carangola\ \-\ MG",
"55993636", "Poção\ de\ Pedras\ \-\ MA",
"55213604", "Niterói\ \-\ RJ",
"55173573", "Roberto\ \-\ SP",
"55543376", "Aratiba\ \-\ RS",
"55443283", "Barbosa\ Ferraz\ \-\ PR",
"55313734", "Belo\ Vale\ \-\ MG",
"55993263", "Imperatriz\ \-\ MA",
"55863122", "Teresina\ \-\ PI",
"55443531", "Peabiru\ \-\ PR",
"55843277", "Nísia\ Floresta\ \-\ RN",
"55813745", "Riacho\ das\ Almas\ \-\ PE",
"55843385", "Marcelino\ Vieira\ \-\ RN",
"55113431", "Barueri\ \-\ SP",
"55793445", "Carira\ \-\ SE",
"55553367", "Santo\ Antônio\ das\ Missões\ \-\ RS",
"55473455", "Joinville\ \-\ SC",
"55343813", "Vazante\ \-\ MG",
"55812102", "Recife\ \-\ PE",
"55622764", "Goiânia\ \-\ GO",
"55813689", "Jaqueira\ \-\ PE",
"55193547", "Araras\ \-\ SP",
"55473354", "Guabiruba\ \-\ SC",
"55143597", "Presidente\ Alves\ \-\ SP",
"55793344", "Neópolis\ \-\ SE",
"55543581", "Passo\ Fundo\ \-\ RS",
"55423904", "Telêmaco\ Borba\ \-\ PR",
"55913725", "Apeú\ \-\ PA",
"55483216", "Florianópolis\ \-\ SC",
"55333022", "Governador\ Valadares\ \-\ MG",
"55443421", "Paranavaí\ \-\ PR",
"55313409", "Belo\ Horizonte\ \-\ MG",
"55473395", "Pomerode\ \-\ SC",
"55653325", "Tangará\ da\ Serra\ \-\ MT",
"55513088", "Lajeado\ \-\ RS",
"55153384", "Cerquilho\ \-\ SP",
"5513347", "Praia\ Grande\ \-\ SP",
"55543233", "Ipê\ \-\ RS",
"55513380", "Rio\ Grande\ do\ Sul",
"55213813", "Rio\ de\ Janeiro\ \-\ RJ",
"55673286", "Camapuã\ \-\ MS",
"55624109", "Goiânia\ \-\ GO",
"55474052", "Blumenau\ \-\ SC",
"55115645", "São\ Paulo\ \-\ SP",
"55533717", "Rio\ Grande\ \-\ RS",
"55833288", "Mulungu\ \-\ PB",
"55313530", "Betim\ \-\ MG",
"55143849", "Bairro\ de\ Santana\ \-\ SP",
"55193899", "Monte\ Alegre\ do\ Sul\ \-\ SP",
"55973461", "Santo\ Antônio\ do\ Içá\ \-\ AM",
"55323311", "Juiz\ de\ Fora\ \-\ MG",
"55194007", "Campinas\ \-\ SP",
"55893464", "Caridade\ do\ Piauí\ \-\ PI",
"55352102", "Pouso\ Alegre\ \-\ MG",
"55113151", "São\ Paulo\ \-\ SP",
"55473135", "Rio\ da\ Anta\ \-\ SC",
"55313557", "Mariana\ \-\ MG",
"55313266", "Minas\ Gerais",
"55513778", "Rio\ Grande\ do\ Sul",
"55873846", "Triunfo\ \-\ PE",
"55943421", "Conceição\ do\ Araguaia\ \-\ PA",
"55313883", "Rio\ Doce\ \-\ MG",
"55733247", "Almadina\ \-\ BA",
"55543261", "Farroupilha\ \-\ RS",
"55753322", "Feira\ de\ Santana\ \-\ BA",
"5531346", "Minas\ Gerais",
"55133202", "Santos\ \-\ SP",
"55673230", "Pedro\ Gomes\ \-\ MS",
"55383231", "Brasília\ de\ Minas\ \-\ MG",
"55613024", "Brasília\ \-\ DF",
"55853371", "Maracanaú\ \-\ CE",
"55423132", "Irati\ \-\ PR",
"55643526", "Itumbiara\ \-\ GO",
"55883412", "Quixadá\ \-\ CE",
"55623307", "Ceres\ \-\ GO",
"5543342", "Apucarana\ \-\ PR",
"55753267", "Biritinga\ \-\ BA",
"55113399", "São\ Paulo\ \-\ SP",
"55673681", "Terenos\ \-\ MS",
"55323426", "Miraí\ \-\ MG",
"55143471", "Garça\ \-\ SP",
"55883400", "Limoeiro\ do\ Norte\ \-\ CE",
"55663585", "Feliz\ Natal\ \-\ MT",
"55163524", "Sertãozinho\ \-\ SP",
"55883667", "Itarema\ \-\ CE",
"55483091", "Florianópolis\ \-\ SC",
"55343359", "Uberaba\ \-\ MG",
"55663478", "Canarana\ \-\ MT",
"55853014", "Maracanaú\ \-\ CE",
"55112342", "São\ Paulo\ \-\ SP",
"55183821", "Dracena\ \-\ SP",
"55513608", "Rio\ Grande\ do\ Sul",
"55112504", "São\ Paulo\ \-\ SP",
"55173342", "Bebedouro\ \-\ SP",
"55693621", "São\ Francisco\ do\ Guaporé\ \-\ RO",
"55933505", "Aveiro\ \-\ PA",
"55353865", "Cana\ Verde\ \-\ MG",
"5521375", "São\ João\ de\ Meriti\ \-\ RJ",
"55373323", "Pains\ \-\ MG",
"55883539", "Baixio\ \-\ CE",
"55143769", "Holambra\ II\ \-\ SP",
"555138", "Rio\ Grande\ do\ Sul",
"55313661", "Pedro\ Leopoldo\ \-\ MG",
"55833422", "Patos\ \-\ PB",
"55312323", "Betim\ \-\ MG",
"55833684", "Serra\ da\ Raiz\ \-\ PB",
"55214501", "Rio\ de\ Janeiro\ \-\ RJ",
"55243371", "Paraty\ \-\ RJ",
"55823287", "Capela\ \-\ AL",
"55353237", "São\ Thomé\ das\ Letras\ \-\ MG",
"55833532", "Cajazeiras\ \-\ PB",
"55173802", "Paulo\ de\ Faria\ \-\ SP",
"55323003", "Juiz\ de\ Fora\ \-\ MG",
"55883429", "Alto\ Santo\ \-\ CE",
"55653318", "Cuiabá\ \-\ MT",
"55773416", "Contendas\ do\ Sincorá\ \-\ BA",
"55333739", "Chapada\ do\ Norte\ \-\ MG",
"55353851", "Boa\ Esperança\ \-\ MG",
"55114482", "Mairiporã\ \-\ SP",
"55372101", "Divinópolis\ \-\ MG",
"5517332", "Barretos\ \-\ SP",
"55873798", "Bom\ Conselho\ \-\ PE",
"55213084", "Rio\ de\ Janeiro\ \-\ RJ",
"55114624", "Osasco\ \-\ SP",
"55313694", "Nova\ Lima\ \-\ MG",
"55163434", "Ribeirão\ Preto\ \-\ SP",
"55423273", "Telêmaco\ Borba\ \-\ PR",
"55113507", "São\ Paulo\ \-\ SP",
"55893577", "Monte\ Alegre\ do\ Piauí\ \-\ PI",
"55313371", "Minas\ Gerais",
"55143654", "Brotas\ \-\ SP",
"55313548", "Minas\ Gerais",
"55323536", "Senador\ Firmino\ \-\ MG",
"55513452", "Sapucaia\ do\ Sul\ \-\ RS",
"55112712", "São\ Paulo\ \-\ SP",
"55443563", "Farol\ \-\ PR",
"55913182", "Belém\ \-\ PA",
"55983383", "São\ Bento\ \-\ MA",
"55713631", "Itaparica\ \-\ BA",
"55543294", "Nova\ Roma\ do\ Sul\ \-\ RS",
"55643492", "Edéia\ \-\ GO",
"55693442", "Rolim\ de\ Moura\ \-\ RO",
"55112876", "Carapicuíba\ \-\ SP",
"55213208", "Rio\ de\ Janeiro\ \-\ RJ",
"55433442", "Bom\ Sucesso\ \-\ PR",
"55114047", "Diadema\ \-\ SP",
"55213774", "Duque\ de\ Caxias\ \-\ RJ",
"55313014", "Belo\ Horizonte\ \-\ MG",
"55673027", "Campo\ Grande\ \-\ MS",
"55833419", "Santa\ Teresinha\ \-\ PB",
"55753685", "Ipecaetá\ \-\ BA",
"55453279", "Quatro\ Pontes\ \-\ PR",
"55833641", "Riacho\ de\ Santo\ Antônio\ \-\ PB",
"55473523", "Lontras\ \-\ SC",
"55773470", "Rio\ do\ Antônio\ \-\ BA",
"55543283", "Caxias\ do\ Sul\ \-\ RS",
"55643520", "Itumbiara\ \-\ GO",
"55193019", "Mogi\-Guaçu\ \-\ SP",
"55643623", "Rio\ Verde\ \-\ GO",
"55983394", "Carutapera\ \-\ MA",
"55673236", "Nioaque\ \-\ MS",
"55813256", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55513038", "Campo\ Bom\ \-\ RS",
"55153334", "Sorocaba\ \-\ SP",
"55483043", "Tubarão\ \-\ SC",
"55983355", "Cajapió\ \-\ MA",
"55623545", "Goiânia\ \-\ GO",
"55473039", "Blumenau\ \-\ SC",
"55993555", "Pastos\ Bons\ \-\ MA",
"5512388", "Caraguatatuba\ \-\ SP",
"55133216", "Santos\ \-\ SP",
"55383561", "João\ Pinheiro\ \-\ MG",
"55493648", "Caibi\ \-\ SC",
"55663418", "São\ Pedro\ da\ Cipa\ \-\ MT",
"55753669", "Ponte\ 2\ de\ Julho\ \-\ BA",
"55813639", "Macaparana\ \-\ PE",
"55773658", "Ibitiara\ \-\ BA",
"55543531", "Paim\ Filho\ \-\ RS",
"55753653", "Cairu\ \-\ BA",
"55843434", "Santana\ do\ Matos\ \-\ RN",
"55313242", "Minas\ Gerais",
"55673292", "Rio\ Verde\ de\ Mato\ Grosso\ \-\ MS",
"55143649", "Barra\ Bonita\ \-\ SC",
"55133871", "Eldorado\ \-\ SP",
"55115845", "São\ Paulo\ \-\ SP",
"55143411", "Jaú\ \-\ SP",
"55493555", "Capinzal\ \-\ SC",
"55443302", "Maringá\ \-\ PR",
"55463227", "Vitorino\ \-\ PR",
"55113444", "São\ Paulo\ \-\ SP",
"55313833", "São\ Gonçalo\ do\ Rio\ Abaixo\ \-\ MG",
"55684007", "Rio\ Branco\ \-\ AC",
"55114275", "Mairiporã\ \-\ SP",
"55443544", "Tupãssi\ \-\ PR",
"55313741", "Ouro\ Branco\ \-\ MG",
"55993648", "Bernardo\ do\ Mearim\ \-\ MA",
"55123431", "São\ José\ dos\ Campos\ \-\ SP",
"55193473", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55273717", "Colatina\ \-\ ES",
"55313683", "Jaboticatubas\ \-\ MG",
"55854102", "Fortaleza\ \-\ CE",
"55483355", "Imbituba\ \-\ SC",
"55443018", "Cianorte\ \-\ PR",
"55663569", "Porto\ Alegre\ do\ Norte\ \-\ MT",
"55493561", "Caçador\ \-\ SC",
"55193022", "Mogi\ Mirim\ \-\ SP",
"55453219", "Cascavel\ \-\ PR",
"55663553", "Juruena\ \-\ MT",
"55833479", "Cacimba\ de\ Areia\ \-\ PB",
"55433717", "Londrina\ \-\ PR",
"55123521", "Pindamonhangaba\ \-\ SP",
"55313074", "Belo\ Horizonte\ \-\ MG",
"55913088", "Belém\ \-\ PA",
"55463057", "Francisco\ Beltrão\ \-\ PR",
"55653541", "Colíder\ \-\ MT",
"55923213", "Manaus\ \-\ AM",
"55773402", "Vitória\ da\ Conquista\ \-\ BA",
"55513725", "Cerro\ Branco\ \-\ RS",
"55112772", "São\ Paulo\ \-\ SP",
"55623476", "Colinas\ do\ Tocantins\ \-\ TO",
"55173816", "Orindiúva\ \-\ SP",
"55833262", "João\ Pessoa\ \-\ PB",
"5511368", "Osasco\ \-\ SP",
"55963198", "Macapá\ \-\ AP",
"55682106", "Rio\ Branco\ \-\ AC",
"55513497", "Gravataí\ \-\ RS",
"55654001", "Cuiabá\ \-\ MT",
"55443666", "Herculândia\ \-\ PR",
"5531322", "Belo\ Horizonte\ \-\ MG",
"55843335", "Ipanguaçu\ \-\ RN",
"55543421", "Gramado\ \-\ RS",
"55983361", "Axixá\ \-\ MA",
"55173271", "Neves\ Paulista\ \-\ SP",
"55863247", "Castelo\ do\ Piauí\ \-\ PI",
"55773476", "Abaíra\ \-\ BA",
"55983454", "Anajatuba\ \-\ MA",
"55873838", "Afogados\ da\ Ingazeira\ \-\ PE",
"5583", "Paraiba",
"55473626", "São\ Bento\ do\ Sul\ \-\ SC",
"55753427", "Esplanada\ \-\ BA",
"55443233", "Mandaguari\ \-\ PR",
"55183607", "Araçatuba\ \-\ SP",
"55993561", "Governador\ Luiz\ Rocha\ \-\ MA",
"55643430", "Itumbiara\ \-\ GO",
"55273347", "Vitória\ \-\ ES",
"55163726", "Orlândia\ \-\ SP",
"55213445", "Rio\ de\ Janeiro\ \-\ RJ",
"55123151", "Canas\ \-\ SP",
"55193765", "Campinas\ \-\ SP",
"5511499", "Santo\ André\ \-\ SP",
"55412626", "Curitiba\ \-\ PR",
"55713286", "Salvador\ \-\ BA",
"55192112", "Rio\ Claro\ \-\ SP",
"55793363", "Canhoba\ \-\ SE",
"55133383", "Guarujá\ \-\ SP",
"55333413", "Paulistas\ \-\ MG",
"55673405", "Vista\ Alegre\ \-\ MS",
"55473349", "Itajaí\ \-\ SC",
"55413608", "Fazenda\ Rio\ Grande\ \-\ PR",
"55483333", "Florianópolis\ \-\ SC",
"55413132", "Pinhais\ \-\ PR",
"55613307", "Brasília\ \-\ DF",
"55693466", "Nova\ União\ \-\ RO",
"55513348", "Rio\ Grande\ do\ Sul",
"55773647", "Ibitiara\ \-\ BA",
"55222777", "Rio\ das\ Ostras\ \-\ RJ",
"55493657", "Santa\ Terezinha\ do\ Progresso\ \-\ SC",
"5571348", "Salvador\ \-\ BA",
"5511454", "Mauá\ \-\ SP",
"55313894", "Araponga\ \-\ MG",
"55114496", "Itupeva\ \-\ SP",
"55313426", "Belo\ Horizonte\ \-\ MG",
"55353375", "Dom\ Viçoso\ \-\ MG",
"55173513", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55353651", "Paraisópolis\ \-\ MG",
"55112610", "Mogi\ das\ Cruzes\ \-\ SP",
"55493533", "Videira\ \-\ SC",
"55313855", "Alvinópolis\ \-\ MG",
"55753635", "Mutuípe\ \-\ BA",
"55653291", "Cáceres\ \-\ MT",
"55993072", "Imperatriz\ \-\ MA",
"55333297", "Santa\ Efigênia\ de\ Minas\ \-\ MG",
"55923571", "Urucará\ \-\ AM",
"55853260", "Eusébio\ \-\ CE",
"55893443", "Santana\ do\ Piauí\ \-\ PI",
"55193845", "Hortolândia\ \-\ SP",
"55353799", "Caldas\ \-\ MG",
"55993533", "Buritirana\ \-\ MA",
"55713681", "Vera\ Cruz\ \-\ BA",
"55114519", "Mauá\ \-\ SP",
"55473065", "Balneário\ Camboriú\ \-\ SC",
"55513571", "São\ José\ do\ Hortêncio\ \-\ RS",
"55193404", "Limeira\ \-\ SP",
"55813474", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55473221", "Blumenau\ \-\ SC",
"55993118", "Timon\ \-\ MA",
"55413392", "Campo\ Largo\ \-\ PR",
"55192129", "Campinas\ \-\ SP",
"55493244", "Santa\ Cecília\ \-\ SC",
"55983276", "São\ Luís\ \-\ MA",
"55813651", "Passira\ \-\ PE",
"55143552", "Getulina\ \-\ SP",
"55193305", "Campinas\ \-\ SP",
"55483902", "Criciúma\ \-\ SC",
"55513718", "Vera\ Cruz\ \-\ RS",
"55443255", "Maringá\ \-\ PR",
"55222621", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55383533", "Couto\ de\ Magalhães\ de\ Minas\ \-\ MG",
"55413973", "Rio\ Branco\ do\ Sul\ \-\ PR",
"55413452", "Matinhos\ \-\ PR",
"55143326", "Ourinhos\ \-\ SP",
"55153272", "Itapetininga\ \-\ SP",
"55323371", "São\ João\ Del\ Rei\ \-\ MG",
"55483202", "Florianópolis\ \-\ SC",
"55553528", "Campo\ Novo\ \-\ RS",
"55553279", "Quevedos\ \-\ RS",
"55323694", "Leopoldina\ \-\ MG",
"55223084", "Macaé\ \-\ RJ",
"55843353", "São\ Miguel\ \-\ RN",
"55674002", "Campo\ Grande\ \-\ MS",
"55553617", "Tiradentes\ do\ Sul\ \-\ RS",
"55833634", "Casserengue\ \-\ PB",
"55313536", "Florestal\ \-\ MG",
"55114468", "Santo\ André\ \-\ SP",
"55973483", "Envira\ \-\ AM",
"55733552", "Córrego\ de\ Pedras\ \-\ BA",
"55163977", "Ribeirão\ Preto\ \-\ SP",
"55183621", "Araçatuba\ \-\ SP",
"55873840", "Inajá\ \-\ PE",
"55713644", "Camaçari\ \-\ BA",
"55483276", "Alfredo\ Wagner\ \-\ SC",
"55623954", "Goiânia\ \-\ GO",
"55313260", "Minas\ Gerais",
"55663535", "Sinop\ \-\ MT",
"55623995", "Goiânia\ \-\ GO",
"55633423", "Darcinópolis\ \-\ TO",
"55863258", "Monsenhor\ Gil\ \-\ PI",
"55163385", "Tabatinga\ \-\ SP",
"55313861", "Nova\ Era\ \-\ MG",
"55964141", "Macapá\ \-\ AP",
"55133416", "Ana\ Dias\ \-\ SP",
"55283552", "Alegre\ \-\ ES",
"55133847", "Miracatu\ \-\ SP",
"55913739", "Paragominas\ \-\ PA",
"5511435", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55473563", "Salete\ \-\ SC",
"55343245", "Indianópolis\ \-\ MG",
"55173695", "Marinópolis\ \-\ SP",
"55112654", "São\ Paulo\ \-\ SP",
"55843234", "Natal\ \-\ RN",
"55513558", "Rio\ Grande\ do\ Sul",
"55793549", "Poço\ Verde\ \-\ SE",
"55313442", "Minas\ Gerais",
"55113423", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55423645", "Laranjal\ \-\ PR",
"55753338", "Mucugê\ \-\ BA",
"55873879", "Exu\ \-\ PE",
"55733211", "Itabuna\ \-\ BA",
"55753030", "Feira\ de\ Santana\ \-\ BA",
"55653339", "Tangará\ da\ Serra\ \-\ MT",
"55443523", "Campo\ Mourão\ \-\ PR",
"55483647", "Laguna\ \-\ SC",
"55433548", "Sapopema\ \-\ PR",
"55114664", "Embu\-Guaçu\ \-\ SP",
"55353332", "São\ Lourenço\ \-\ MG",
"55833438", "Condado\ \-\ PB",
"55383728", "Angueretá\ \-\ MG",
"55513645", "São\ Pedro\ da\ Serra\ \-\ RS",
"55643644", "Aporé\ \-\ GO",
"55183855", "Monte\ Castelo\ \-\ SP",
"55193452", "Limeira\ \-\ SP",
"55115904", "São\ Paulo\ \-\ SP",
"55483024", "Florianópolis\ \-\ SC",
"55513128", "Gravataí\ \-\ RS",
"55353825", "Itutinga\ \-\ MG",
"55114104", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55773202", "Vitória\ da\ Conquista\ \-\ BA",
"55373359", "Arcos\ \-\ MG",
"55513789", "Boqueirão\ do\ Leão\ \-\ RS",
"55114374", "Carapicuíba\ \-\ SP",
"55433661", "Alvorada\ do\ Sul\ \-\ PR",
"55863271", "Pedro\ II\ \-\ PI",
"55353456", "Natércia\ \-\ MG",
"55543349", "São\ Domingos\ do\ Sul\ \-\ RS",
"55663572", "Nova\ Bandeirantes\ \-\ MT",
"5511267", "São\ Paulo\ \-\ SP",
"55143342", "Chavantes\ \-\ SP",
"55313621", "Vespasiano\ \-\ MG",
"55463537", "Boa\ Esperança\ do\ Iguaçu\ \-\ PR",
"55833462", "São\ Mamede\ \-\ PB",
"55413404", "Curitiba\ \-\ PR",
"55933793", "Porto\ de\ Moz\ \-\ PA",
"55943433", "Tucumã\ \-\ PA",
"55813136", "Caruaru\ \-\ PE",
"55193336", "Rio\ Claro\ \-\ SP",
"55483254", "Garopaba\ \-\ SC",
"55553301", "Santa\ Maria\ \-\ RS",
"55212655", "São\ João\ de\ Meriti\ \-\ RJ",
"55343323", "Veríssimo\ \-\ MG",
"55833279", "Cachoeira\ \-\ PB",
"55883627", "Martinópole\ \-\ CE",
"55163838", "Ituverava\ \-\ SP",
"55953532", "Caracaraí\ \-\ RR",
"55463550", "Renascença\ \-\ PR",
"55112753", "São\ Paulo\ \-\ SP",
"55183861", "Irapuru\ \-\ SP",
"55823625", "Maravilha\ \-\ AL",
"55273371", "Linhares\ \-\ ES",
"55883518", "Solonópole\ \-\ CE",
"55443433", "Nova\ Aliança\ do\ Ivaí\ \-\ PR",
"55663506", "Analândia\ do\ Norte\ \-\ MT",
"55613383", "Brasília\ \-\ DF",
"55224009", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55323466", "Além\ Paraíba\ \-\ MG",
"55114011", "Piracaia\ \-\ SP",
"55193608", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55813678", "Rio\ Formoso\ \-\ PE",
"5531342", "Minas\ Gerais",
"55643681", "Firminópolis\ \-\ GO",
"55753362", "Boa\ Vista\ Cananéia\ \-\ BA",
"5554331", "Passo\ Fundo\ \-\ RS",
"55114759", "Suzano\ \-\ SP",
"55553884", "Dona\ Otília\ \-\ RS",
"55333725", "Salto\ da\ Divisa\ \-\ MG",
"55883435", "Potiretama\ \-\ CE",
"55553794", "Planalto\ \-\ RS",
"55623355", "Itapuranga\ \-\ GO",
"55173849", "Macedônia\ \-\ SP",
"55693530", "Monte\ Negro\ \-\ RO",
"55553755", "Liberato\ Salzano\ \-\ RS",
"55433266", "Nova\ Santa\ Bárbara\ \-\ PR",
"55754141", "Feira\ de\ Santana\ \-\ BA",
"55433557", "Arapoti\ \-\ PR",
"55163116", "São\ Carlos\ \-\ SP",
"55483658", "Braço\ do\ Norte\ \-\ SC",
"55112849", "São\ Paulo\ \-\ SP",
"55183741", "Castilho\ \-\ SP",
"55163984", "São\ Simão\ \-\ SP",
"55213554", "Rio\ de\ Janeiro\ \-\ RJ",
"55623394", "Santa\ Rita\ do\ Novo\ Destino\ \-\ GO",
"55753340", "Marcionílio\ Souza\ \-\ BA",
"55333213", "Governador\ Valadares\ \-\ MG",
"55663489", "Ribeirão\ Cascalheira\ \-\ MT",
"55424007", "Ponta\ Grossa\ \-\ PR",
"55453246", "Palmitópolis\ \-\ PR",
"55893424", "Paquetá\ \-\ PI",
"55373331", "Oliveira\ \-\ MG",
"55843417", "Caicó\ \-\ RN",
"55513547", "Rolante\ \-\ RS",
"55183942", "Gardênia\ \-\ SP",
"55653365", "Cuiabá\ \-\ MT",
"55123848", "Ubatuba\ \-\ SP",
"55943779", "Goianésia\ do\ Pará\ \-\ PA",
"55513115", "Canoas\ \-\ RS",
"55383223", "Montes\ Claros\ \-\ MG",
"55813274", "Recife\ \-\ PE",
"55114731", "Suzano\ \-\ SP",
"55833440", "Brejo\ dos\ Santos\ \-\ PB",
"55312191", "Contagem\ \-\ MG",
"55813708", "Bezerros\ \-\ PE",
"55193778", "Campinas\ \-\ SP",
"55222741", "São\ João\ da\ Barra\ \-\ RJ",
"55773671", "Sítio\ do\ Mato\ \-\ BA",
"55112597", "São\ Paulo\ \-\ SP",
"55493345", "Santiago\ do\ Sul\ \-\ SC",
"55653491", "Itiquira\ \-\ MT",
"55514007", "Porto\ Alegre\ \-\ RS",
"55533311", "Bagé\ \-\ RS",
"5553322", "Pelotas\ \-\ RS",
"55193904", "Mogi\ Mirim\ \-\ SP",
"55843662", "Natal\ \-\ RN",
"55813974", "Recife\ \-\ PE",
"55983658", "Alto\ Alegre\ do\ Pindaré\ \-\ MA",
"55933557", "Faro\ \-\ PA",
"55212734", "Rio\ Bonito\ \-\ RJ",
"55843293", "Serra\ Caiada\ \-\ RN",
"55222580", "Nova\ Friburgo\ \-\ RJ",
"55913765", "Salvaterra\ \-\ PA",
"55333062", "Governador\ Valadares\ \-\ MG",
"55673480", "Paranhos\ \-\ MS",
"55413473", "Caiobá\ \-\ PR",
"55183311", "Presidente\ Prudente\ \-\ SP",
"55653351", "Nossa\ Senhora\ do\ Livramento\ \-\ MT",
"55512106", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55333357", "Dom\ Cavati\ \-\ MG",
"55143032", "Jaú\ \-\ SP",
"55453288", "Santa\ Lúcia\ \-\ PR",
"55163941", "Ribeirão\ Preto\ \-\ SP",
"55533242", "Bagé\ \-\ RS",
"55114173", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55553327", "Salto\ do\ Jacuí\ \-\ RS",
"55633444", "Axixá\ do\ Tocantins\ \-\ TO",
"55983476", "Santa\ Quitéria\ do\ Maranhão\ \-\ MA",
"55493444", "Concórdia\ \-\ SC",
"55473531", "Rio\ do\ Sul\ \-\ SC",
"55113555", "São\ Paulo\ \-\ SP",
"55843372", "Severiano\ Melo\ \-\ RN",
"55773454", "Caetité\ \-\ BA",
"55843638", "Rio\ do\ Fogo\ \-\ RN",
"55413699", "Almirante\ Tamandaré\ \-\ PR",
"55733616", "Itabuna\ \-\ BA",
"55163241", "Monte\ Alto\ \-\ SP",
"55913751", "Abaetetuba\ \-\ PA",
"55773495", "Caetité\ \-\ BA",
"55683213", "Rio\ Branco\ \-\ AC",
"55173258", "Bady\ Bassitt\ \-\ SP",
"55113594", "São\ Paulo\ \-\ SP",
"55443455", "Santa\ Mônica\ \-\ PR",
"55553262", "Paraíso\ do\ Sul\ \-\ RS",
"55153253", "Quadra\ \-\ SP",
"55733573", "Prado\ \-\ BA",
"55863366", "Luís\ Correia\ \-\ PI",
"55623361", "Itapaci\ \-\ GO",
"55483476", "Nova\ Veneza\ \-\ SC",
"55473642", "Mafra\ \-\ SC",
"55212633", "Magé\ \-\ RJ",
"55213852", "Rio\ de\ Janeiro\ \-\ RJ",
"55543207", "São\ Brás\ \-\ RS",
"55162105", "Sertãozinho\ \-\ SP",
"55823527", "Craíbas\ \-\ AL",
"55195657", "São\ Paulo\ \-\ SP",
"55323347", "Ibertioga\ \-\ MG",
"5555", "Rio\ Grande\ do\ Sul",
"55273266", "Santa\ Leopoldina\ \-\ ES",
"55133321", "Santos\ \-\ SP",
"55883525", "Antonina\ do\ Norte\ \-\ CE",
"55353274", "Olímpio\ Noronha\ \-\ MG",
"55753201", "Acupe\ \-\ BA",
"55344009", "Uberlândia\ \-\ MG",
"55133295", "Santos\ \-\ SP",
"55323442", "Leopoldina\ \-\ MG",
"55433260", "Guaraci\ \-\ PR",
"55185871", "Panorama\ \-\ SP",
"55222793", "Macaé\ \-\ RJ",
"55353625", "Marmelópolis\ \-\ MG",
"55693536", "Ariquemes\ \-\ RO",
"55633463", "Aragominas\ \-\ TO",
"55114891", "Bom\ Jesus\ dos\ Perdões\ \-\ SP",
"55243358", "Resende\ \-\ RJ",
"55922129", "Manaus\ \-\ AM",
"55313220", "Minas\ Gerais",
"55193386", "Campinas\ \-\ SP",
"55633459", "Buriti\ do\ Tocantins\ \-\ TO",
"55773611", "Barreiras\ \-\ BA",
"55493459", "Coronel\ Martins\ \-\ SC",
"55643542", "Itumbiara\ \-\ GO",
"55663451", "Dom\ Aquino\ \-\ MT",
"55183586", "Mariápolis\ \-\ SP",
"55843241", "Canguaretama\ \-\ RN",
"55773449", "Malhada\ de\ Pedras\ \-\ BA",
"55173122", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55115213", "São\ Paulo\ \-\ SP",
"55433536", "Ribeirão\ Claro\ \-\ PR",
"55453240", "Medianeira\ \-\ PR",
"55224105", "Nova\ Friburgo\ \-\ RJ",
"55623091", "Goiânia\ \-\ GO",
"55513739", "Rio\ Grande\ do\ Sul",
"55114428", "Santo\ André\ \-\ SP",
"55673448", "Deodápolis\ \-\ MS",
"55933536", "Juruti\ \-\ PA",
"55143366", "Bauru\ \-\ SP",
"55843477", "Ouro\ Branco\ \-\ RN",
"55173552", "Urupês\ \-\ SP",
"55143458", "Queiroz\ \-\ SP",
"55643631", "Jataí\ \-\ GO",
"55733162", "Porto\ Seguro\ \-\ BA",
"55473255", "Brusque\ \-\ SC",
"55843329", "Felipe\ Guerra\ \-\ RN",
"55823203", "Ibateguara\ \-\ AL",
"55543523", "Barão\ de\ Cotegipe\ \-\ RS",
"55163176", "Furnas\ Vila\ Residencial\ \-\ SP",
"55613333", "Recanto\ das\ Emas\ \-\ DF",
"55163306", "São\ Carlos\ \-\ SP",
"55113583", "São\ Paulo\ \-\ SP",
"55193808", "Amparo\ \-\ SP",
"55623611", "Aparecida\ de\ Goiânia\ \-\ GO",
"55553422", "Alegrete\ \-\ RS",
"55222661", "Araruama\ \-\ RJ",
"55853358", "Tururu\ \-\ CE",
"55153285", "Tietê\ \-\ SP",
"55115062", "São\ Paulo\ \-\ SP",
"55623449", "Guarani\ de\ Goiás\ \-\ GO",
"55653224", "Cáceres\ \-\ MT",
"55152104", "Sorocaba\ \-\ SP",
"55353214", "Varginha\ \-\ MG",
"55112895", "São\ Paulo\ \-\ SP",
"55543433", "Arco\ Verde\ \-\ RS",
"55124104", "Taubaté\ \-\ SP",
"55473261", "Balneário\ Camboriú\ \-\ SC",
"5531358", "Minas\ Gerais",
"55613701", "Brasília\ \-\ DF",
"55653054", "Cuiabá\ \-\ MT",
"55813625", "Goiana\ \-\ PE",
"55843284", "Serrinha\ \-\ RN",
"55222101", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55222655", "Saquarema\ \-\ RJ",
"55333336", "Simonésia\ \-\ MG",
"55112119", "Atibaia\ \-\ SP",
"55143602", "Jaú\ \-\ SP",
"55454100", "Cascavel\ \-\ PR",
"55193571", "Leme\ \-\ SP",
"55813501", "Ipojuca\ \-\ PE",
"55163993", "Ribeirão\ Preto\ \-\ SP",
"55513404", "Rio\ Grande\ do\ Sul",
"55623383", "Britânia\ \-\ GO",
"55643405", "Piracanjuba\ \-\ GO",
"55123981", "Cedro\ \-\ SP",
"55313466", "Belo\ Horizonte\ \-\ MG",
"55114538", "Itatiba\ \-\ SP",
"55743647", "Jussara\ \-\ BA",
"55733676", "Barrolândia\ \-\ BA",
"55313358", "Contagem\ \-\ MG",
"55863360", "Joaquim\ Pires\ \-\ PI",
"55163662", "Batatais\ \-\ SP",
"55183694", "Zacarias\ \-\ SP",
"55833488", "Santa\ Inês\ \-\ PB",
"55273260", "Vila\ Velha\ \-\ ES",
"55553419", "Barra\ do\ Quaraí\ \-\ RS",
"55633399", "Sucupira\ \-\ TO",
"55453301", "Cascavel\ \-\ PR",
"55823332", "Maceió\ \-\ AL",
"55183371", "Maracaí\ \-\ SP",
"55183655", "Barbosa\ \-\ SP",
"55693311", "Cacoal\ \-\ RO",
"55993521", "Caxias\ \-\ MA",
"55543395", "Viadutos\ \-\ RS",
"55373344", "Pedra\ do\ Indaiá\ \-\ MG",
"55613394", "Santa\ Maria\ \-\ DF",
"55193913", "Itapira\ \-\ SP",
"55543354", "Esmeralda\ \-\ RS",
"55673457", "Itaporã\ \-\ MS",
"55613355", "Taguatinga\ \-\ DF",
"55453238", "Ibema\ \-\ PR",
"55242445", "Barra\ do\ Piraí\ \-\ RJ",
"55543461", "Carlos\ Barbosa\ \-\ RS",
"55443626", "Umuarama\ \-\ PR",
"55213787", "Seropédica\ \-\ RJ",
"55473233", "São\ Francisco\ do\ Sul\ \-\ SC",
"55153551", "Ribeirão\ Branco\ \-\ SP",
"55414007", "Curitiba\ \-\ PR",
"55433311", "Rolândia\ \-\ PR",
"55273242", "Vila\ Velha\ \-\ ES",
"55823274", "Colônia\ Pindorama\ \-\ AL",
"55212741", "Teresópolis\ \-\ RJ",
"55953238", "Rorainópolis\ \-\ RR",
"55733271", "Iguaí\ \-\ BA",
"55513765", "Lagoão\ \-\ RS",
"55353527", "Bom\ Jesus\ dos\ Campos\ \-\ MG",
"55853347", "Baturité\ \-\ CE",
"55483321", "Florianópolis\ \-\ SC",
"55633521", "Brejinho\ de\ Nazaré\ \-\ TO",
"55123836", "Ubatuba\ \-\ SP",
"55544052", "Passo\ Fundo\ \-\ RS",
"55753612", "Feira\ de\ Santana\ \-\ BA",
"55183998", "João\ Ramalho\ \-\ SP",
"55673509", "Três\ Lagoas\ \-\ MS",
"55222734", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55212683", "Paracambi\ \-\ RJ",
"55123892", "São\ Sebastião\ \-\ SP",
"55413547", "Lapa\ \-\ PR",
"55663529", "Querência\ \-\ MT",
"55493521", "Joaçaba\ \-\ SC",
"55123686", "Taubaté\ \-\ SP",
"55713205", "Salvador\ \-\ BA",
"55313717", "Santana\ de\ Pirapama\ \-\ MG",
"55213077", "Rio\ de\ Janeiro\ \-\ RJ",
"55613043", "Brasília\ \-\ DF",
"55833367", "Bananeiras\ \-\ PB",
"55193497", "Limeira\ \-\ SP",
"55112785", "São\ Paulo\ \-\ SP",
"55164003", "Ribeirão\ Preto\ \-\ SP",
"55373381", "Cláudio\ \-\ MG",
"55513751", "Encantado\ \-\ RS",
"55114282", "São\ Paulo\ \-\ SP",
"55113308", "Jundiaí\ \-\ SP",
"55113178", "São\ Paulo\ \-\ SP",
"55353066", "Poços\ de\ Caldas\ \-\ MG",
"5571323", "Salvador\ \-\ BA",
"55953262", "Normandia\ \-\ RR",
"55163234", "Ribeirão\ Preto\ \-\ SP",
"55923019", "Manaus\ \-\ AM",
"55473544", "Trombudo\ Central\ \-\ SC",
"55493431", "Xanxerê\ \-\ SC",
"55663439", "Rondonópolis\ \-\ MT",
"55633431", "Angico\ \-\ TO",
"55183557", "Salmourão\ \-\ SP",
"55353437", "Senador\ Amaral\ \-\ MG",
"55163934", "Ribeirão\ Preto\ \-\ SP",
"55183266", "Alfredo\ Marcondes\ \-\ SP",
"55423252", "Palmeira\ \-\ PR",
"55333511", "Itambacuri\ \-\ MG",
"5583324", "João\ Pessoa\ \-\ PB",
"55463556", "Pérola\ D\'Oeste\ \-\ PR",
"5545", "Paraná",
"55473018", "Gaspar\ \-\ SC",
"55843646", "Natal\ \-\ RN",
"55883578", "Umari\ \-\ CE",
"55222633", "Armação\ dos\ Búzios\ \-\ RJ",
"55383521", "Itamarandiba\ \-\ MG",
"55663603", "Aripuanã\ \-\ MT",
"55433242", "Bela\ Vista\ do\ Paraíso\ \-\ PR",
"55273311", "Vila\ Velha\ \-\ ES",
"55484109", "Biguaçu\ \-\ SC",
"55223852", "Miracema\ \-\ RJ",
"55113636", "São\ Paulo\ \-\ SP",
"55473376", "Jaraguá\ do\ Sul\ \-\ SC",
"55663500", "Primavera\ do\ Leste\ \-\ MT",
"55873822", "Arcoverde\ \-\ PE",
"55274102", "Serra\ \-\ ES",
"55412106", "Curitiba\ \-\ PR",
"55613361", "Guará\ \-\ DF",
"5595", "Roraima",
"55443039", "Cianorte\ \-\ PR",
"55753629", "Conceição\ do\ Almeida\ \-\ BA",
"55513952", "São\ Leopoldo\ \-\ RS",
"55513473", "Esteio\ \-\ RS",
"55643663", "Caiapônia\ \-\ GO",
"55613454", "Sobradinho\ \-\ DF",
"55453262", "Matelândia\ \-\ PR",
"55114781", "Embu\ das\ Artes\ \-\ SP",
"55513252", "Rio\ Grande\ do\ Sul",
"55663512", "Alta\ Floresta\ \-\ MT",
"55643659", "Itarumã\ \-\ GO",
"55963322", "Pedra\ Branca\ do\ Amaparí\ \-\ AP",
"55643560", "São\ João\ da\ Paraúna\ \-\ GO",
"55513699", "Rio\ Grande\ do\ Sul",
"55743658", "Canarana\ \-\ BA",
"55153565", "Itaporanga\ \-\ SP",
"55893541", "Marcos\ Parente\ \-\ PI",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+55|\D)//g;
      my $self = bless({ country_code => '55', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(?:0|90)(?:(1[245]|2[1-35]|31|4[13]|[56]5|99)(\d{10,11}))?)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$2/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '55', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;