package Net::Async::Spotify::Object::Generated::ExternalId;

use strict;
use warnings;

our $VERSION = '0.001'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::ExternalId - Package representing Spotify ExternalId Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify ExternalId Object attributes:

=over 4

=item ean

Type:String
Description:International Article Number

=item isrc

Type:String
Description:International Standard Recording Code

=item upc

Type:String
Description:Universal Product Code

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        ean => 'String',
        isrc => 'String',
        upc => 'String',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
