use strict;

package HTML::FormFu::Inflator;
$HTML::FormFu::Inflator::VERSION = '2.07';
# ABSTRACT: Inflator Base Class

use Moose;
extends 'HTML::FormFu::Processor';

use HTML::FormFu::Exception::Inflator;
use Scalar::Util qw( blessed );

sub process {
    my ( $self, $values ) = @_;

    my $return;
    my @errors;

    if ( ref $values eq 'ARRAY' ) {
        my @return;
        for my $value (@$values) {
            ($return) = eval { $self->inflator($value) };

            if ($@) {
                push @errors, $self->return_error($@);
                push @return, $value;
            }
            else {
                push @return, $return;
            }
        }
        $return = \@return;
    }
    else {
        ($return) = eval { $self->inflator($values) };

        if ($@) {
            push @errors, $self->return_error($@);
            $return = $values;
        }
    }

    return ( $return, @errors );
}

sub return_error {
    my ( $self, $err ) = @_;

    if ( !blessed $err || !$err->isa('HTML::FormFu::Exception::Inflator') ) {
        $err = HTML::FormFu::Exception::Inflator->new;
    }

    return $err;
}

__PACKAGE__->meta->make_immutable;

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

HTML::FormFu::Inflator - Inflator Base Class

=head1 VERSION

version 2.07

=head1 SYNOPSIS

    my $inflator = $form->inflator( $type, @names );

=head1 DESCRIPTION

Inflator Base Class.

=head1 METHODS

=head2 names

Arguments: @names

Return Value: @names

Contains names of params to inflator.

=head2 process

Arguments: $form_result, \%params

=head1 CORE INFLATORS

=over

=item L<HTML::FormFu::Inflator::CompoundDateTime>

=item L<HTML::FormFu::Inflator::DateTime>

=back

=head1 AUTHOR

Carl Franks, C<cfranks@cpan.org>

=head1 LICENSE

This library is free software, you can redistribute it and/or modify it under
the same terms as Perl itself.

=head1 AUTHOR

Carl Franks <cpan@fireartist.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Carl Franks.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
