package Archive::Libarchive::Lib::Constants;

use strict;
use warnings;
use 5.020;
use experimental qw( signatures );

# ABSTRACT: Private class for Arcive::Libarchive
our $VERSION = '0.08'; # VERSION

# NOTE: This document is autogenerated from the template
# maint/tt/Const.pm.tt
# Please see maint/README.md for details on updating.


sub _enums ($class, $ffi)
{
  $ffi->load_custom_type('::Enum', 'archive_entry_digest_t',
    { prefix => 'ARCHIVE_ENTRY_DIGEST_', rev => 'dualvar', type => 'int', package => 'Archive::Libarchive' },
    ['md5', 1],
    ['rmd160', 2],
    ['sha1', 3],
    ['sha256', 4],
    ['sha384', 5],
    ['sha512', 6],
  );
  $ffi->load_custom_type('::Enum', 'archive_filter_t',
    { prefix => 'ARCHIVE_FILTER_', rev => 'dualvar', type => 'int', package => 'Archive::Libarchive' },
    ['bzip2', 2],
    ['compress', 3],
    ['grzip', 12],
    ['gzip', 1],
    ['lrzip', 10],
    ['lz4', 13],
    ['lzip', 9],
    ['lzma', 5],
    ['lzop', 11],
    ['none', 0],
    ['program', 4],
    ['rpm', 8],
    ['uu', 7],
    ['xz', 6],
    ['zstd', 14],
  );
  $ffi->load_custom_type('::Enum', 'archive_format_t',
    { prefix => 'ARCHIVE_FORMAT_', rev => 'dualvar', type => 'int', package => 'Archive::Libarchive' },
    ['7zip', 917504],
    ['ar', 458752],
    ['ar_bsd', 458754],
    ['ar_gnu', 458753],
    ['base_mask', 16711680],
    ['cab', 786432],
    ['cpio', 65536],
    ['cpio_afio_large', 65542],
    ['cpio_bin_be', 65539],
    ['cpio_bin_le', 65538],
    ['cpio_posix', 65537],
    ['cpio_pwb', 65543],
    ['cpio_svr4_crc', 65541],
    ['cpio_svr4_nocrc', 65540],
    ['empty', 393216],
    ['iso9660', 262144],
    ['iso9660_rockridge', 262145],
    ['lha', 720896],
    ['mtree', 524288],
    ['rar', 851968],
    ['rar_v5', 1048576],
    ['raw', 589824],
    ['shar', 131072],
    ['shar_base', 131073],
    ['shar_dump', 131074],
    ['tar', 196608],
    ['tar_gnutar', 196612],
    ['tar_pax_interchange', 196610],
    ['tar_pax_restricted', 196611],
    ['tar_ustar', 196609],
    ['warc', 983040],
    ['xar', 655360],
    ['zip', 327680],
  );
}

package
  Archive::Libarchive;

use constant {
  ARCHIVE_ENTRY_ACL_ADD_FILE => 16,
  ARCHIVE_ENTRY_ACL_ADD_SUBDIRECTORY => 32,
  ARCHIVE_ENTRY_ACL_APPEND_DATA => 32,
  ARCHIVE_ENTRY_ACL_DELETE => 2048,
  ARCHIVE_ENTRY_ACL_DELETE_CHILD => 256,
  ARCHIVE_ENTRY_ACL_ENTRY_DIRECTORY_INHERIT => 67108864,
  ARCHIVE_ENTRY_ACL_ENTRY_FAILED_ACCESS => 1073741824,
  ARCHIVE_ENTRY_ACL_ENTRY_FILE_INHERIT => 33554432,
  ARCHIVE_ENTRY_ACL_ENTRY_INHERITED => 16777216,
  ARCHIVE_ENTRY_ACL_ENTRY_INHERIT_ONLY => 268435456,
  ARCHIVE_ENTRY_ACL_ENTRY_NO_PROPAGATE_INHERIT => 134217728,
  ARCHIVE_ENTRY_ACL_ENTRY_SUCCESSFUL_ACCESS => 536870912,
  ARCHIVE_ENTRY_ACL_EVERYONE => 10107,
  ARCHIVE_ENTRY_ACL_EXECUTE => 1,
  ARCHIVE_ENTRY_ACL_GROUP => 10003,
  ARCHIVE_ENTRY_ACL_GROUP_OBJ => 10004,
  ARCHIVE_ENTRY_ACL_INHERITANCE_NFS4 => 2130706432,
  ARCHIVE_ENTRY_ACL_LIST_DIRECTORY => 8,
  ARCHIVE_ENTRY_ACL_MASK => 10005,
  ARCHIVE_ENTRY_ACL_OTHER => 10006,
  ARCHIVE_ENTRY_ACL_PERMS_NFS4 => 65529,
  ARCHIVE_ENTRY_ACL_PERMS_POSIX1E => 7,
  ARCHIVE_ENTRY_ACL_READ => 4,
  ARCHIVE_ENTRY_ACL_READ_ACL => 4096,
  ARCHIVE_ENTRY_ACL_READ_ATTRIBUTES => 512,
  ARCHIVE_ENTRY_ACL_READ_DATA => 8,
  ARCHIVE_ENTRY_ACL_READ_NAMED_ATTRS => 64,
  ARCHIVE_ENTRY_ACL_STYLE_COMPACT => 16,
  ARCHIVE_ENTRY_ACL_STYLE_EXTRA_ID => 1,
  ARCHIVE_ENTRY_ACL_STYLE_MARK_DEFAULT => 2,
  ARCHIVE_ENTRY_ACL_STYLE_SEPARATOR_COMMA => 8,
  ARCHIVE_ENTRY_ACL_STYLE_SOLARIS => 4,
  ARCHIVE_ENTRY_ACL_SYNCHRONIZE => 32768,
  ARCHIVE_ENTRY_ACL_TYPE_ACCESS => 256,
  ARCHIVE_ENTRY_ACL_TYPE_ALARM => 8192,
  ARCHIVE_ENTRY_ACL_TYPE_ALLOW => 1024,
  ARCHIVE_ENTRY_ACL_TYPE_AUDIT => 4096,
  ARCHIVE_ENTRY_ACL_TYPE_DEFAULT => 512,
  ARCHIVE_ENTRY_ACL_TYPE_DENY => 2048,
  ARCHIVE_ENTRY_ACL_TYPE_NFS4 => 15360,
  ARCHIVE_ENTRY_ACL_TYPE_POSIX1E => 768,
  ARCHIVE_ENTRY_ACL_USER => 10001,
  ARCHIVE_ENTRY_ACL_USER_OBJ => 10002,
  ARCHIVE_ENTRY_ACL_WRITE => 2,
  ARCHIVE_ENTRY_ACL_WRITE_ACL => 8192,
  ARCHIVE_ENTRY_ACL_WRITE_ATTRIBUTES => 1024,
  ARCHIVE_ENTRY_ACL_WRITE_DATA => 16,
  ARCHIVE_ENTRY_ACL_WRITE_NAMED_ATTRS => 128,
  ARCHIVE_ENTRY_ACL_WRITE_OWNER => 16384,
  ARCHIVE_EOF => 1,
  ARCHIVE_EXTRACT_ACL => 32,
  ARCHIVE_EXTRACT_CLEAR_NOCHANGE_FFLAGS => 131072,
  ARCHIVE_EXTRACT_FFLAGS => 64,
  ARCHIVE_EXTRACT_HFS_COMPRESSION_FORCED => 32768,
  ARCHIVE_EXTRACT_MAC_METADATA => 8192,
  ARCHIVE_EXTRACT_NO_AUTODIR => 1024,
  ARCHIVE_EXTRACT_NO_HFS_COMPRESSION => 16384,
  ARCHIVE_EXTRACT_NO_OVERWRITE => 8,
  ARCHIVE_EXTRACT_NO_OVERWRITE_NEWER => 2048,
  ARCHIVE_EXTRACT_OWNER => 1,
  ARCHIVE_EXTRACT_PERM => 2,
  ARCHIVE_EXTRACT_SAFE_WRITES => 262144,
  ARCHIVE_EXTRACT_SECURE_NOABSOLUTEPATHS => 65536,
  ARCHIVE_EXTRACT_SECURE_NODOTDOT => 512,
  ARCHIVE_EXTRACT_SECURE_SYMLINKS => 256,
  ARCHIVE_EXTRACT_SPARSE => 4096,
  ARCHIVE_EXTRACT_TIME => 4,
  ARCHIVE_EXTRACT_UNLINK => 16,
  ARCHIVE_EXTRACT_XATTR => 128,
  ARCHIVE_FAILED => -25,
  ARCHIVE_FATAL => -30,
  ARCHIVE_MATCH_CTIME => 512,
  ARCHIVE_MATCH_EQUAL => 16,
  ARCHIVE_MATCH_MTIME => 256,
  ARCHIVE_MATCH_NEWER => 1,
  ARCHIVE_MATCH_OLDER => 2,
  ARCHIVE_OK => 0,
  ARCHIVE_READDISK_HONOR_NODUMP => 2,
  ARCHIVE_READDISK_MAC_COPYFILE => 4,
  ARCHIVE_READDISK_NO_ACL => 32,
  ARCHIVE_READDISK_NO_FFLAGS => 64,
  ARCHIVE_READDISK_NO_SPARSE => 128,
  ARCHIVE_READDISK_NO_TRAVERSE_MOUNTS => 8,
  ARCHIVE_READDISK_NO_XATTR => 16,
  ARCHIVE_READDISK_RESTORE_ATIME => 1,
  ARCHIVE_READ_FORMAT_CAPS_ENCRYPT_DATA => 1,
  ARCHIVE_READ_FORMAT_CAPS_ENCRYPT_METADATA => 2,
  ARCHIVE_READ_FORMAT_CAPS_NONE => 0,
  ARCHIVE_READ_FORMAT_ENCRYPTION_DONT_KNOW => -1,
  ARCHIVE_READ_FORMAT_ENCRYPTION_UNSUPPORTED => -2,
  ARCHIVE_RETRY => -10,
  ARCHIVE_WARN => -20,
};

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Archive::Libarchive::Lib::Constants - Private class for Arcive::Libarchive

=head1 VERSION

version 0.08

=head1 SYNOPSIS

 % perldoc Archive::Libarchive

=head1 DESCRIPTION

This is a private class for L<Archive::Libarchive> see the main documentation for the public interface.

=head1 SEE ALSO

=over 4

=item L<Archive::Libarchive::Peek>

Provides an interface for listing and retrieving entries from an archive without extracting them to the local filesystem.

=item L<Archive::Libarchive::Extract>

Provides an interface for extracting arbitrary archives of any format/filter supported by C<libarchive>.

=item L<Archive::Libarchive::Unwrap>

Decompresses / unwraps files that have been compressed or wrapped in any of the filter formats supported by C<libarchive>

=item L<Archive::Libarchive>

This is the main top-level module for using C<libarchive> from
Perl.  It is the best place to start reading the documentation.
It pulls in the other classes and C<libarchive> constants so
that you only need one C<use> statement to effectively use
C<libarchive>.

=item L<Archive::Libarchive::API>

This contains the full and complete API for all of the L<Archive::Libarchive>
classes.  Because C<libarchive> has hundreds of methods, the main documentation
pages elsewhere only contain enough to be useful, and not to overwhelm.

=item L<Archive::Libarchive::Archive>

The base class of all archive classes.  This includes some common error
reporting functionality among other things.

=item L<Archive::Libarchive::ArchiveRead>

This class is used for reading from archives.

=item L<Archive::Libarchive::ArchiveWrite>

This class is for creating new archives.

=item L<Archive::Libarchive::DiskRead>

This class is for reading L<Archive::Libarchive::Entry> objects from disk
so that they can be written to L<Archive::Libarchive::ArchiveWrite> objects.

=item L<Archive::Libarchive::DiskWrite>

This class is for writing L<Archive::Libarchive::Entry> objects to disk
that have been written from L<Archive::Libarchive::ArchiveRead> objects.

=item L<Archive::Libarchive::Entry>

This class represents a file in an archive, or on disk.

=item L<Archive::Libarchive::EntryLinkResolver>

This class exposes the C<libarchive> link resolver API.

=item L<Archive::Libarchive::Match>

This class exposes the C<libarchive> match API.

=item L<Dist::Zilla::Plugin::Libarchive>

Build L<Dist::Zilla> based dist tarballs with libarchive instead of the built in L<Archive::Tar>.

=item L<Alien::Libarchive3>

If a suitable system C<libarchive> can't be found, then this
L<Alien> will be installed to provide it.

=item L<libarchive.org|http://libarchive.org/>

The C<libarchive> project home page.

=item L<https://github.com/libarchive/libarchive/wiki>

The C<libarchive> project wiki.

=item L<https://github.com/libarchive/libarchive/wiki/ManualPages>

Some of the C<libarchive> man pages are listed here.

=back

=head1 AUTHOR

Graham Ollis <plicease@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021,2022 by Graham Ollis.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
