.COMMENT SccsID: %Z% %M% %I% %E% %U%
.TH "XpTable" 3 "19 March 1993"
.SH NAME
XpTable \- Xt-Based Public Table Widget
.SH SYNOPSIS
.ta 1.5i 2.5i
.nf
.ft B
In C++ or C:

#include <X11/Intrinsic.h>
#include <X11/Xp/Table.h>

Widget newTable = XtCreateWidget( name, xpTableWidgetClass, pw, ... );
Widget another = XpCreateTable( pw, name, arglist, argcount );
.fi
.ft R
.SH LINK BY
.nf
.ft B
example% ld -o prog prog.o -lXp  -lXaw <WclOption> -lXmu -lXt -lX11
example% ld -o prog prog.o -lXop -lXol <WclOption> -lXmu -lXt -lX11
.ft R
.fi
.LP 
.I XpTable
works with any widget set.  If you are using Motif, you may want to
use the 
.I XmpTable
which is very similar but derived from Motif manager classes, hence it
works slightly better in some Motif contexts.
.LP
.I XpTable is built into the Xp and Xop libraries which are
distributed with Wcl.
.I XpTable
does not require the use of Wcl, but the author obviously
encourages its use ;^).  See 
.I Wcl(3)
for usage and linking of Wcl.
.SH DESCRIPTION
.LP
.I XpTable
is a manager widget which allows widgets to be arranged in a tabular
form.  The
.I XpTable
widget has a 
.B layout
resource which is used to specify the column and row position of each
child.  Children can span rows and/or columns.  Layout options
are available to control the initial sizes, justification, and dynamic resizing
of children.
.LP
Amazing as this may sound,
.I XpTable
is internally fully object-oriented, but all methods and members of internal
objects are in fact accessible to client applications.  Rather than
being pedantic about "information hiding", the author tries to follow
the principle that
.I XpTable
is going to be used by programmers, and programmers sometimes need to
do things the author did not foresee.  The structures and methods of
the
.I XpTable
and all of its component objects are declared in the
.B TableP.h
include file.  Some methods which some may find useful are
.B XpTableLocFindPosition()
and
.B XpTableLocFind()
which clients can use to find the location information for widgets at
some specific location in an
.I XpTable,
or for some specific widget in an
.I XpTable.
.sp 1
.SS "Classes"
.I XpTable
inherits behavior and resources
from \fBCore\fP, \fBComposite\fP, and \fBConstraint\fP.
.PP
The class pointer is \fBxpTableWidgetClass\fP.
.PP
The class name is \fBXpTable\fP.
.sp 1
.SS "New Resources"
The following table defines a set of widget resources used by the programmer
to specify data.  The programmer can also set the resource values for the
inherited classes to set attributes for this widget.  To reference a
resource by name or by class in an application defaults file, remove the
\fBXtN\fP or \fBXtC\fP prefix and use the remaining letters. 

The codes in the access column indicate if the given resource can be
set at creation time (\fBC\fP),
set by using \fBXtSetValues\fP (\fBS\fP),
retrieved by using \fBXtGetValues\fP (\fBG\fP),
or is not applicable (\fBN/A\fP).
.nf

XpTable Resource Set
Name              Class             Type        Default Access

XtNlayout         XtCLayout         XpTableLoc  NULL    CSG
XtNdefaultOptions XtCDefaultOptions XpTableOpts NULL    CSG
XtNsameWidth      XtCSameSize       XrmName**   NULL    CSG
XtNsameHeight     XtCSameSize       XrmName**   NULL    CSG
XtNsameBorder     XtCSameSize       XrmName**   NULL    CSG
XtNshrinkSimple   XtCShrinkSimple   Boolean     True    CSG
XtNcolumnSpacing  XtCSpacing        int         0       CSG
XtNrowSpacing     XtCSpacing        int         0       CSG
XtNmarginWidth    XtCMarginWidth    int         0       CSG
XtNmarginHeight   XtCMarginHeight   int         0       CSG
.fi
.IP "\fBXtNlayout\fP"
Specifies the column, row, column span, row span, and options for each
child.  The options field is optional, and takes the identical form of
the \fBXtNdefaultOptions\fP resource discussed below.  If no options
are specified for a child, that childs options will be the value of the
\fBXtNdefaultOptions\fP resource when the child is first managed.
Children which are not named in the layout specification are positioned
in column 0, row 0, with colum and row spans of 1, and using the
default options.  If the layout is changed after the
.I XpTable
is created, then a complete re-layout is performed.  The internal type
\fBXpTableLoc\fP which must be passed to \fBXtCreateWidget()\fP or to
\fBXtSetValues()\fP is obtained by passing a string representation of
the layout specification to \fBXpTableLocParse()\fP which will be
discussed below.  A layout resource consists of one layout
specification per named child, with each layout specification being
separated (or terminated) by a ";" and with each layout specification
of the form:
.RS
.RS
.sp 2
.nf
\fB<name> <col> <row> [<opts>]\fP
.fi
.RE
.RE
.IP "\fBXtNdefaultOptions\fP"
Specifies the layout options which apply to all children which do not
have specific layout options in the child's layout specification.  The
layout options allow a child widget to be justified within the table
cell, and allow the initial size and dynamic resizing of children to be
constrained.  Combinations of options can be used: \fBtr\fP means top
and right, or north-east justification.  Note that the justification
does not do anything special with labels of any widgets, or text in
any Text widgets: it simply sets the positioning of the entire child
widget within the cell of the
.I XpTable.
The layout options consist of a series of adjacent case sensitive
letters, each of which sets a layout option:
.RS
.RS
.IP \fBl\fP
left justify child in table cell.
.IP \fBr\fP
right justify child in table cell.
.IP \fBt\fP
top  justify child in table cell.
.IP \fBb\fP
bottom justify child in table cell.
.IP \fBw\fP
do not stretch width of column in which child is
positioned during resizing.  Column width will remain wide enough to
contain the widest child in the column.
.IP \fBh\fP
do not stretch height of row in which child is positioned
during resizing.  Row height will remain high enough to contain the
tallest child in the row.
.IP \fBW\fP
do not stretch width of child during resizing.  The width
of the column may grow (unless constrained by \fBw\fP), and the child
will be justified according to its layout options.
.IP \fBH\fP
do not stretch height of child during resizing.  The height
of the row  may grow (unless constrained by \fBh\fP), and the child
will be justified according to its layout options.
.RE
.RE
.IP "\fBXtNsameWidth XtNsameHeight XtNsameBorder\fP"
These three resources are used to specify the names of children
of a Table which will be constrained to remain the same size as
the table shrinks and grows, and when children are managed and
unmanaged, and when children are allowed to resize.

These three resources are often set together by using their common
resource class \fBSameSize\fP in resource files.

If you have been using \fBWcSameSize()\fP with limited success, you will
probably like to use these resources instead.
.IP "\fBXtNshrinkSimple\fP"
Specifies if simple widgets (widgets which have NULL
\fBquery_geometry\fP methods) should be forced smaller when the table
widget is made smaller.  Such simple widgets will be forced to their
original preferred sizes, but not smaller.
By default, this is \fBTrue\fP.
Older versions of XpTable did not provide this feature, and so setting
this resource \fBFalse\fP will give the old behavior, which the author
found obnoxious.
.IP "\fBXtNcolumnSpacing\fP"
Specifies the number of pixels between columns.
.IP "\fBXtNrowSpacing\fP"
Specifies the number of pixels between rows.
.IP "\fBXtNmarginWidth\fP"
Specifies the number of pixels to the left of the first column of children
widgets, and the the right of the last column of children widgets.
.IP "\fBXtNmarginHeight\fP"
Specifies the number of pixels above the first row of children widgets,
and below the last row of children widgets.
.sp 1
.SS "Inherited Resources"
.I XpTable
inherits behavior and resources from the following
superclasses.  For a complete description of each resource, refer to the
man page for that superclass.
.nf

Composite Resource Set
Name              Class              Type        Default Access

XtNchildren       XtCReadOnly        WidgetList  NULL    G
XtNinsertPosition XtCInsertPosition  (*)()       NULL    CSG
XtNnumChildren    XtCReadOnly        Cardinal    0       G
.fi
.nf

Core Resource Set
Name                 Class                Type           Default Access

XtNaccelerators      XtCAccelerators      XtAccelerators NULL    CSG
XtNancestorSensitive XtCSensitive         Boolean        dynamic G
XtNbackground        XtCBackground        Pixel          dynamic CSG
XtNbackgroundPixmap  XtCPixmap            Pixmap  XtUNSPECIFIED_PIXMAP CSG
XtNborderColor       XtCBorderColor       Pixel   XtDefaultForeground  CSG
XtNborderPixmap      XtCPixmap            Pixmap  XtUNSPECIFIED_PIXMAP CSG
XtNborderWidth       XtCBorderWidth       Dimension      0       CSG
XtNcolormap          XtCColormap          Colormap       dynamic CG
XtNdepth             XtCDepth             int            dynamic CG
XtNdestroyCallback   XtCCallback          XtCallbackList NULL    C
XtNheight            XtCHeight            Dimension      dynamic CSG
XtNmappedWhenManaged XtCMappedWhenManaged Boolean        True    CSG
XtNscreen            XtCScreen            Screen*        dynamic CG
XtNsensitive         XtCSensitive         Boolean        True    CSG
XtNtranslations      XtCTranslations      XtTranslations NULL    CSG
XtNwidth             XtCWidth             Dimension      dynamic CSG
XtNx                 XtCPosition          Position       0       CSG
XtNy                 XtCPosition          Position       0       CSG
.fi
.SH SUPPORT PROCEDURES
.LP
.I XpTable
provides the following procedures and functions which can be used
to create and manipulate 
.I XpTables
and the children of
.I XpTables:
.nf
.ft B

XpTableLoc XpTableLocParse( char* layout );
void XpTableLocFree( XpTableLoc toFree );
XpTableOpts XpTableOptsParse( char* options );
void XpTableChildPosition( Widget child, int col, int row );
void XpTableChildResize( Widget child, int col_span, int row_span );
void XpTableChildOptions( Widget child, XpTableOpts opts );
void XpTableChildConfig( Widget child,
                         int col, int row, int col_span, int row_span,
                         XpTableOpts opts );
Widget XpCreateTable( Widget, char*, ArgList, Cardinal );
Widget XpCreateTableDialog( Widget, char*, ArgList, Cardinal );
Widget XpCreateTableTransient( Widget, char*, ArgList, Cardinal );
.ft R
.fi
.LP
Each of these routines can also be invoked from resource files, as the
.B Xp
library procedure
.B XpRegisterAthena()
registers the names of each of these procedures as both actions and
callbacks with the
.B Wcl
string-to-callback converter and with the \fBXt Translation Manager\fP.
These routines are discussed in more detail below.
.IP "XpTableLoc XpTableLocParse( char* layout );"
This function takes a string which specifies a layout resource for and
.I XpTable
widget and returns an
.B XpTableLoc,
a pointer to an opaque type, which can then passed to
.B XtCreateWidget(),
any of the
.B XpCreateTable
constructors, or to
.B XtSetValues().  The
.I XpTable
copies the storage, and so the
.B XpTableLoc
storage must be released by the client when no longer needed (often
immediately after use) by passing the
.B XpTableLoc
to
.B XpTableLocFree().
.IP "void XpTableLocFree( XpTableLoc toFree );"
This procedure releases the storage pointed to by the 
.B XpTableLoc
opaque pointer.
.IP "XpTableOpts XpTableOptsParse( char* options );"
This function parses the options specifier string into an
.B XpTableOpts
which can then be passed to .B XtCreateWidget(),
any of the
.B XpCreateTable
constructors, or to
.B XtSetValues().
.B XpTableOpts
is typedef'd to a standard machine data type (currently an int),
and so does not need to be free'd.
.IP "void XpTableChildPosition( Widget child, int col, int row );"
This procedure allows a child of an
.I XpTable
widget to be moved to a different cell.  If the child spans multiple
columns and/or rows, the column and row indicates the upper left corner
of the child widget.  The defaultLayout resource of the
.I XpTable
is actually changed by this procedure, so the new location of the child
will be remembered even if the child is unmanaged and re-managed.  The
layout of the
.I XpTable
is recomputed, which means all issues involved in the positioning and
sizes of all children of the
.I XpTable
are also re-analyzed.  For example, if the child widget has the option
\fBW\fP specified, then the column to which the child widget is moved will
then be prevented from becoming wider, and the column from which the
child widget came may be enabled to be made wider.
.IP "void XpTableChildResize( Widget, int col_span, int row_span );"
This procedure allows a child of an
.I XpTable
widget to be resized so the child spans a different number of columns
or rows.  Again, the layout of the
.I XpTable
is recomputed, which means all issues involved in the positioning and
sizes of all children of the
.I XpTable
are re-analyzed.  For example, if the child widget has the option
\fBW\fP specified, then all of the columns which the child widget spans
will be prevented from becoming wider.
.IP "void XpTableChildOptions( Widget child, XpTableOpts opts );"
This procedure allows a child of an
.I XpTable
widget to have its layout options changed.  Again, the layout of the
.I XpTable
is recomputed, which means all issues involved in the positioning and
sizes of all children of the
.I XpTable
are re-analyzed.  For example, if the child widget has the option
\fBW\fP specified, then all of the columns which the child widget spans
will be prevented from becoming wider.
.LP
.nf
void XpTableChildConfig( Widget child,
                          int col, int row,
                          int col_span, int row_span,
                          XpTableOpts opts );
.fi
.IP
This procedure allows a child of an
.I XpTable
widget to have all of its layout specifications changed at once.
.IP "Widget XpCreateTable( Widget, char*, ArgList, Cardinal );"
This function creates a new
.I XpTable
widget.  The \fIWidget\fP argument specifies the parent widget ID, the
\fIchar*\fP argument specifies the name of the created widget, the
\fIArgList\fP argument specifies the argument list, and the
\fICardinal\fP argument specifies the number of attribute/value pairs
in the argument list.
but with the characters "_popup" concatenated to the end.  The
\fIWidget\fP argument specifies the parent widget ID, the \fIchar*\fP
argument specifies the name of the created \fIXpTable\fP widget, the
\fIArgList\fP argument specifies the argument list, and the
\fICardinal\fP argument specifies the number of attribute/value pairs
in the argument list.
.IP "Widget XpCreateTableTransient(Widget,char*,ArgList,Cardinal);"
This function creates a new
.I XpTable
widget as a child of a new
.I XtTransientShell.
The name of the new
.I XtTransientShell
has the same name as the new
.I XpTable
but with the characters "_popup" concatenated to the end.  The
\fIWidget\fP argument specifies the parent widget ID, the \fIchar*\fP
argument specifies the name of the created \fIXpTable\fP widget, the
\fIArgList\fP argument specifies the argument list, and the
\fICardinal\fP argument specifies the number of attribute/value pairs
in the argument list.
.SH ACTIONS AND CALLBACKS
.LP
The Xp library provides the following callbacks and actions
for manipulating children of
XpTable widgets:
.LP
.nf
.ft B
XpTableChildConfig( widget col row [h_span [v_span [opts]]] )
XpTableChildPosition( widget col row )
XpTableChildResize( widget h_span v_span )
XpTableChildOptions( widget options )
.ft R
.fi
.LP
Each callback procedure can also be named in resource files as
the name of the procedure followed by CB: i.e, XpTableChildConfig()
can also be invoked as a callback by giving the name XpTableChildConfigCB()
for a callback resource value.  Also, each action procedure can also
be named by appending ACT to the procedure name.  Normally, I just use the
procedure name, so it is less trouble to change behavior from callbacks
to actions triggered by translations or accelerators, and vice versa.
The CB and ACT endings are maintained for backward compatibility, and
because some people like to be more explicit.  It is all a matter of taste.
.LP
Arguments to the procedures are provided as strings, the characters
between the parenthesis following the procedure name.  If no parenthesis
follow the procedure name, then a NULL string is passed to the procedure.
Some procedures require arguments, some provide reasonable defaults when
no arguments are given.  For example:
.RS
.LP
.nf
*foo.select:       XpTableChildPosition( this 2 4 )
.fi
.RE
.LP
Each
.I XpTable
callback and action procedure is discussed in detail below.
.IP "XpTableChildConfig( w col row [h_span [v_span [opts]]] )"
This allows a child of an XpTable to be moved to a new row or
column, to be given a different horizontal or vertical span, and
to change the justification and re-size options of the child.
.IP "XpTableChildPosition( w col row )"
This allows a child of an XpTable to be moved to a new row or 
column.
.IP "XpTableChildResize( w h_span v_span )"
This allows a child of an XpTable to be given a different horizontal
or vertical span.
.IP "XpTableChildOptions( w options )"
This allows a child of an XpTable to be given new
justification and re-size options.
.SH "SEE ALSO"
Xp (3), Xop (3), Ari (1), Cri (1), Ori (1), Wcl (3), X (1),
Core (3X), Composite (3X), 
Constraint (3X).
.SH BUGS
.LP
Sometimes, semi-intersecting sameWidth and sameHeight name lists
do not work correctly during resizing.
.SH AUTHORS
David E. Smyth (David.Smyth@sniap.mchp.sni.de) at Siemens Nixdorf
Informationssysteme AG, Munich Germany.  The original Table widget
on which the external interface and many concepts of the
.I XpTable
were derived was written by David Harrison in 1989 while he was
at the University of California, Berkeley.
