package Task::Lego;

# Pragmas.
use strict;
use warnings;

# Version.
our $VERSION = 0.01;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Task::Lego - Install the Lego modules.

=head1 SYNOPSIS

 cpanm Task::Lego

=head1 SEE ALSO

=over

=item L<Lego::From::PNG>

Convert PNGs into plans to build a two dimensional lego replica.

=item L<Lego::Ldraw>

Perl extension for parsing, modifying, translating and displaying Ldraw files.

=item L<Lego::Part>

Lego part object.

=item L<Lego::Part::Image>

Lego part image abstract class.

=item L<Lego::Part::Image::PeeronCom>

Lego part image class for peeron.com.

=item L<Lego::Part::Image::LegoCom>

Lego part image class for lego.com.

=item L<Lego::Part::Image::LugnetCom>

Lego part image class for lugnet.com.

=back

=head1 REPOSITORY

L<https://github.com/tupinek/Task-Lego>

=head1 AUTHOR

Michal Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

 © 2015 Michal Špaček
 BSD 2-Clause License

=head1 VERSION

0.01

=cut
