use strict;
use warnings;
use utf8;

use FindBin;
use lib ("lib", "$FindBin::Bin/../blib/lib", "$FindBin::Bin/../blib/arch");

use Lingua::RU::Money::XS qw(rur2words);
use Test::Spec;

describe "Convert rubles to word, amount: " => sub {
	# Suppress warnings and dies messages
	open STDERR, '>', '/dev/null';
	it "1000000000000.00" => sub { is rur2words(1000000000000.00), "один триллион рублей 00 копеек"; };
	it "2000000000000.00" => sub { is rur2words(2000000000000.00), "два триллиона рублей 00 копеек"; };
	it "3000000000000.00" => sub { is rur2words(3000000000000.00), "три триллиона рублей 00 копеек"; };
	it "4000000000000.00" => sub { is rur2words(4000000000000.00), "четыре триллиона рублей 00 копеек"; };
	it "5000000000000.00" => sub { is rur2words(5000000000000.00), "пять триллионов рублей 00 копеек"; };
	it "6000000000000.00" => sub { is rur2words(6000000000000.00), "шесть триллионов рублей 00 копеек"; };
	it "7000000000000.00" => sub { is rur2words(7000000000000.00), "семь триллионов рублей 00 копеек"; };
	it "8000000000000.00" => sub { is rur2words(8000000000000.00), "восемь триллионов рублей 00 копеек"; };
	it "9000000000000.00" => sub { is rur2words(9000000000000.00), "девять триллионов рублей 00 копеек"; };
	it "10000000000000.00" => sub { is rur2words(10000000000000.00), "десять триллионов рублей 00 копеек"; };
	it "11000000000000.00" => sub { is rur2words(11000000000000.00), "одиннадцать триллионов рублей 00 копеек"; };
	it "12000000000000.00" => sub { is rur2words(12000000000000.00), "двенадцать триллионов рублей 00 копеек"; };
	it "13000000000000.00" => sub { is rur2words(13000000000000.00), "тринадцать триллионов рублей 00 копеек"; };
	it "14000000000000.00" => sub { is rur2words(14000000000000.00), "четырнадцать триллионов рублей 00 копеек"; };
	it "15000000000000.00" => sub { is rur2words(15000000000000.00), "пятнадцать триллионов рублей 00 копеек"; };
	it "16000000000000.00" => sub { is rur2words(16000000000000.00), "шестнадцать триллионов рублей 00 копеек"; };
	it "17000000000000.00" => sub { is rur2words(17000000000000.00), "семнадцать триллионов рублей 00 копеек"; };
	it "18000000000000.00" => sub { is rur2words(18000000000000.00), "восемнадцать триллионов рублей 00 копеек"; };
	it "19000000000000.00" => sub { is rur2words(19000000000000.00), "девятнадцать триллионов рублей 00 копеек"; };
	it "20000000000000.00" => sub { is rur2words(20000000000000.00), "двадцать триллионов рублей 00 копеек"; };
	it "21000000000000.00" => sub { is rur2words(21000000000000.00), "двадцать один триллион рублей 00 копеек"; };
	it "22000000000000.00" => sub { is rur2words(22000000000000.00), "двадцать два триллиона рублей 00 копеек"; };
	it "23000000000000.00" => sub { is rur2words(23000000000000.00), "двадцать три триллиона рублей 00 копеек"; };
	it "24000000000000.00" => sub { is rur2words(24000000000000.00), "двадцать четыре триллиона рублей 00 копеек"; };
	it "25000000000000.00" => sub { is rur2words(25000000000000.00), "двадцать пять триллионов рублей 00 копеек"; };
	it "26000000000000.00" => sub { is rur2words(26000000000000.00), "двадцать шесть триллионов рублей 00 копеек"; };
	it "27000000000000.00" => sub { is rur2words(27000000000000.00), "двадцать семь триллионов рублей 00 копеек"; };
	it "28000000000000.00" => sub { is rur2words(28000000000000.00), "двадцать восемь триллионов рублей 00 копеек"; };
	it "29000000000000.00" => sub { is rur2words(29000000000000.00), "двадцать девять триллионов рублей 00 копеек"; };
	it "30000000000000.00" => sub { is rur2words(30000000000000.00), "тридцать триллионов рублей 00 копеек"; };
	it "31000000000000.00" => sub { is rur2words(31000000000000.00), "тридцать один триллион рублей 00 копеек"; };
	it "32000000000000.00" => sub { is rur2words(32000000000000.00), "тридцать два триллиона рублей 00 копеек"; };
	it "33000000000000.00" => sub { is rur2words(33000000000000.00), "тридцать три триллиона рублей 00 копеек"; };
	it "34000000000000.00" => sub { is rur2words(34000000000000.00), "тридцать четыре триллиона рублей 00 копеек"; };
	it "35000000000000.00" => sub { is rur2words(35000000000000.00), "тридцать пять триллионов рублей 00 копеек"; };
	it "36000000000000.00" => sub { is rur2words(36000000000000.00), "тридцать шесть триллионов рублей 00 копеек"; };
	it "37000000000000.00" => sub { is rur2words(37000000000000.00), "тридцать семь триллионов рублей 00 копеек"; };
	it "38000000000000.00" => sub { is rur2words(38000000000000.00), "тридцать восемь триллионов рублей 00 копеек"; };
	it "39000000000000.00" => sub { is rur2words(39000000000000.00), "тридцать девять триллионов рублей 00 копеек"; };
	it "40000000000000.00" => sub { is rur2words(40000000000000.00), "сорок триллионов рублей 00 копеек"; };
	it "41000000000000.00" => sub { is rur2words(41000000000000.00), "сорок один триллион рублей 00 копеек"; };
	it "42000000000000.00" => sub { is rur2words(42000000000000.00), "сорок два триллиона рублей 00 копеек"; };
	it "43000000000000.00" => sub { is rur2words(43000000000000.00), "сорок три триллиона рублей 00 копеек"; };
	it "44000000000000.00" => sub { is rur2words(44000000000000.00), "сорок четыре триллиона рублей 00 копеек"; };
	it "45000000000000.00" => sub { is rur2words(45000000000000.00), "сорок пять триллионов рублей 00 копеек"; };
	it "46000000000000.00" => sub { is rur2words(46000000000000.00), "сорок шесть триллионов рублей 00 копеек"; };
	it "47000000000000.00" => sub { is rur2words(47000000000000.00), "сорок семь триллионов рублей 00 копеек"; };
	it "48000000000000.00" => sub { is rur2words(48000000000000.00), "сорок восемь триллионов рублей 00 копеек"; };
	it "49000000000000.00" => sub { is rur2words(49000000000000.00), "сорок девять триллионов рублей 00 копеек"; };
	it "50000000000000.00" => sub { is rur2words(50000000000000.00), "пятьдесят триллионов рублей 00 копеек"; };
	it "51000000000000.00" => sub { is rur2words(51000000000000.00), "пятьдесят один триллион рублей 00 копеек"; };
	it "52000000000000.00" => sub { is rur2words(52000000000000.00), "пятьдесят два триллиона рублей 00 копеек"; };
	it "53000000000000.00" => sub { is rur2words(53000000000000.00), "пятьдесят три триллиона рублей 00 копеек"; };
	it "54000000000000.00" => sub { is rur2words(54000000000000.00), "пятьдесят четыре триллиона рублей 00 копеек"; };
	it "55000000000000.00" => sub { is rur2words(55000000000000.00), "пятьдесят пять триллионов рублей 00 копеек"; };
	it "56000000000000.00" => sub { is rur2words(56000000000000.00), "пятьдесят шесть триллионов рублей 00 копеек"; };
	it "57000000000000.00" => sub { is rur2words(57000000000000.00), "пятьдесят семь триллионов рублей 00 копеек"; };
	it "58000000000000.00" => sub { is rur2words(58000000000000.00), "пятьдесят восемь триллионов рублей 00 копеек"; };
	it "59000000000000.00" => sub { is rur2words(59000000000000.00), "пятьдесят девять триллионов рублей 00 копеек"; };
	it "60000000000000.00" => sub { is rur2words(60000000000000.00), "шестьдесят триллионов рублей 00 копеек"; };
	it "61000000000000.00" => sub { is rur2words(61000000000000.00), "шестьдесят один триллион рублей 00 копеек"; };
	it "62000000000000.00" => sub { is rur2words(62000000000000.00), "шестьдесят два триллиона рублей 00 копеек"; };
	it "63000000000000.00" => sub { is rur2words(63000000000000.00), "шестьдесят три триллиона рублей 00 копеек"; };
	it "64000000000000.00" => sub { is rur2words(64000000000000.00), "шестьдесят четыре триллиона рублей 00 копеек"; };
	it "65000000000000.00" => sub { is rur2words(65000000000000.00), "шестьдесят пять триллионов рублей 00 копеек"; };
	it "66000000000000.00" => sub { is rur2words(66000000000000.00), "шестьдесят шесть триллионов рублей 00 копеек"; };
	it "67000000000000.00" => sub { is rur2words(67000000000000.00), "шестьдесят семь триллионов рублей 00 копеек"; };
	it "68000000000000.00" => sub { is rur2words(68000000000000.00), "шестьдесят восемь триллионов рублей 00 копеек"; };
	it "69000000000000.00" => sub { is rur2words(69000000000000.00), "шестьдесят девять триллионов рублей 00 копеек"; };
	it "70000000000000.00" => sub { is rur2words(70000000000000.00), "семьдесят триллионов рублей 00 копеек"; };
	it "71000000000000.00" => sub { is rur2words(71000000000000.00), "семьдесят один триллион рублей 00 копеек"; };
	it "72000000000000.00" => sub { is rur2words(72000000000000.00), "семьдесят два триллиона рублей 00 копеек"; };
	it "73000000000000.00" => sub { is rur2words(73000000000000.00), "семьдесят три триллиона рублей 00 копеек"; };
	it "74000000000000.00" => sub { is rur2words(74000000000000.00), "семьдесят четыре триллиона рублей 00 копеек"; };
	it "75000000000000.00" => sub { is rur2words(75000000000000.00), "семьдесят пять триллионов рублей 00 копеек"; };
	it "76000000000000.00" => sub { is rur2words(76000000000000.00), "семьдесят шесть триллионов рублей 00 копеек"; };
	it "77000000000000.00" => sub { is rur2words(77000000000000.00), "семьдесят семь триллионов рублей 00 копеек"; };
	it "78000000000000.00" => sub { is rur2words(78000000000000.00), "семьдесят восемь триллионов рублей 00 копеек"; };
	it "79000000000000.00" => sub { is rur2words(79000000000000.00), "семьдесят девять триллионов рублей 00 копеек"; };
	it "80000000000000.00" => sub { is rur2words(80000000000000.00), "восемьдесят триллионов рублей 00 копеек"; };
	it "81000000000000.00" => sub { is rur2words(81000000000000.00), "восемьдесят один триллион рублей 00 копеек"; };
	it "82000000000000.00" => sub { is rur2words(82000000000000.00), "восемьдесят два триллиона рублей 00 копеек"; };
	it "83000000000000.00" => sub { is rur2words(83000000000000.00), "восемьдесят три триллиона рублей 00 копеек"; };
	it "84000000000000.00" => sub { is rur2words(84000000000000.00), "восемьдесят четыре триллиона рублей 00 копеек"; };
	it "85000000000000.00" => sub { is rur2words(85000000000000.00), "восемьдесят пять триллионов рублей 00 копеек"; };
	it "86000000000000.00" => sub { is rur2words(86000000000000.00), "восемьдесят шесть триллионов рублей 00 копеек"; };
	it "87000000000000.00" => sub { is rur2words(87000000000000.00), "восемьдесят семь триллионов рублей 00 копеек"; };
	it "88000000000000.00" => sub { is rur2words(88000000000000.00), "восемьдесят восемь триллионов рублей 00 копеек"; };
	it "89000000000000.00" => sub { is rur2words(89000000000000.00), "восемьдесят девять триллионов рублей 00 копеек"; };
	it "90000000000000.00" => sub { is rur2words(90000000000000.00), "девяносто триллионов рублей 00 копеек"; };
	it "91000000000000.00" => sub { is rur2words(91000000000000.00), "девяносто один триллион рублей 00 копеек"; };
	it "92000000000000.00" => sub { is rur2words(92000000000000.00), "девяносто два триллиона рублей 00 копеек"; };
	it "93000000000000.00" => sub { is rur2words(93000000000000.00), "девяносто три триллиона рублей 00 копеек"; };
	it "94000000000000.00" => sub { is rur2words(94000000000000.00), "девяносто четыре триллиона рублей 00 копеек"; };
	it "95000000000000.00" => sub { is rur2words(95000000000000.00), "девяносто пять триллионов рублей 00 копеек"; };
	it "96000000000000.00" => sub { is rur2words(96000000000000.00), "девяносто шесть триллионов рублей 00 копеек"; };
	it "97000000000000.00" => sub { is rur2words(97000000000000.00), "девяносто семь триллионов рублей 00 копеек"; };
	it "98000000000000.00" => sub { is rur2words(98000000000000.00), "девяносто восемь триллионов рублей 00 копеек"; };
	it "99000000000000.00" => sub { is rur2words(99000000000000.00), "девяносто девять триллионов рублей 00 копеек"; };
	it "100000000000000.00" => sub { is rur2words(100000000000000.00), "сто триллионов рублей 00 копеек"; };
	it "101000000000000.00" => sub { is rur2words(101000000000000.00), "сто один триллион рублей 00 копеек"; };
	it "102000000000000.00" => sub { is rur2words(102000000000000.00), "сто два триллиона рублей 00 копеек"; };
	it "103000000000000.00" => sub { is rur2words(103000000000000.00), "сто три триллиона рублей 00 копеек"; };
	it "104000000000000.00" => sub { is rur2words(104000000000000.00), "сто четыре триллиона рублей 00 копеек"; };
	it "105000000000000.00" => sub { is rur2words(105000000000000.00), "сто пять триллионов рублей 00 копеек"; };
	it "106000000000000.00" => sub { is rur2words(106000000000000.00), "сто шесть триллионов рублей 00 копеек"; };
	it "107000000000000.00" => sub { is rur2words(107000000000000.00), "сто семь триллионов рублей 00 копеек"; };
	it "108000000000000.00" => sub { is rur2words(108000000000000.00), "сто восемь триллионов рублей 00 копеек"; };
	it "109000000000000.00" => sub { is rur2words(109000000000000.00), "сто девять триллионов рублей 00 копеек"; };
	it "110000000000000.00" => sub { is rur2words(110000000000000.00), "сто десять триллионов рублей 00 копеек"; };
	it "111000000000000.00" => sub { is rur2words(111000000000000.00), "сто одиннадцать триллионов рублей 00 копеек"; };
	it "112000000000000.00" => sub { is rur2words(112000000000000.00), "сто двенадцать триллионов рублей 00 копеек"; };
	it "113000000000000.00" => sub { is rur2words(113000000000000.00), "сто тринадцать триллионов рублей 00 копеек"; };
	it "114000000000000.00" => sub { is rur2words(114000000000000.00), "сто четырнадцать триллионов рублей 00 копеек"; };
	it "115000000000000.00" => sub { is rur2words(115000000000000.00), "сто пятнадцать триллионов рублей 00 копеек"; };
	it "116000000000000.00" => sub { is rur2words(116000000000000.00), "сто шестнадцать триллионов рублей 00 копеек"; };
	it "117000000000000.00" => sub { is rur2words(117000000000000.00), "сто семнадцать триллионов рублей 00 копеек"; };
	it "118000000000000.00" => sub { is rur2words(118000000000000.00), "сто восемнадцать триллионов рублей 00 копеек"; };
	it "119000000000000.00" => sub { is rur2words(119000000000000.00), "сто девятнадцать триллионов рублей 00 копеек"; };
	it "120000000000000.00" => sub { is rur2words(120000000000000.00), "сто двадцать триллионов рублей 00 копеек"; };
	it "121000000000000.00" => sub { is rur2words(121000000000000.00), "сто двадцать один триллион рублей 00 копеек"; };
	it "122000000000000.00" => sub { is rur2words(122000000000000.00), "сто двадцать два триллиона рублей 00 копеек"; };
	it "123000000000000.00" => sub { is rur2words(123000000000000.00), "сто двадцать три триллиона рублей 00 копеек"; };
	it "124000000000000.00" => sub { is rur2words(124000000000000.00), "сто двадцать четыре триллиона рублей 00 копеек"; };
	it "125000000000000.00" => sub { is rur2words(125000000000000.00), "сто двадцать пять триллионов рублей 00 копеек"; };
	it "126000000000000.00" => sub { is rur2words(126000000000000.00), "сто двадцать шесть триллионов рублей 00 копеек"; };
	it "127000000000000.00" => sub { is rur2words(127000000000000.00), "сто двадцать семь триллионов рублей 00 копеек"; };
	it "128000000000000.00" => sub { is rur2words(128000000000000.00), "сто двадцать восемь триллионов рублей 00 копеек"; };
	it "129000000000000.00" => sub { is rur2words(129000000000000.00), "сто двадцать девять триллионов рублей 00 копеек"; };
	it "130000000000000.00" => sub { is rur2words(130000000000000.00), "сто тридцать триллионов рублей 00 копеек"; };
	it "131000000000000.00" => sub { is rur2words(131000000000000.00), "сто тридцать один триллион рублей 00 копеек"; };
	it "132000000000000.00" => sub { is rur2words(132000000000000.00), "сто тридцать два триллиона рублей 00 копеек"; };
	it "133000000000000.00" => sub { is rur2words(133000000000000.00), "сто тридцать три триллиона рублей 00 копеек"; };
	it "134000000000000.00" => sub { is rur2words(134000000000000.00), "сто тридцать четыре триллиона рублей 00 копеек"; };
	it "135000000000000.00" => sub { is rur2words(135000000000000.00), "сто тридцать пять триллионов рублей 00 копеек"; };
	it "136000000000000.00" => sub { is rur2words(136000000000000.00), "сто тридцать шесть триллионов рублей 00 копеек"; };
	it "137000000000000.00" => sub { is rur2words(137000000000000.00), "сто тридцать семь триллионов рублей 00 копеек"; };
	it "138000000000000.00" => sub { is rur2words(138000000000000.00), "сто тридцать восемь триллионов рублей 00 копеек"; };
	it "139000000000000.00" => sub { is rur2words(139000000000000.00), "сто тридцать девять триллионов рублей 00 копеек"; };
	it "140000000000000.00" => sub { is rur2words(140000000000000.00), "сто сорок триллионов рублей 00 копеек"; };
	it "141000000000000.00" => sub { is rur2words(141000000000000.00), "сто сорок один триллион рублей 00 копеек"; };
	it "142000000000000.00" => sub { is rur2words(142000000000000.00), "сто сорок два триллиона рублей 00 копеек"; };
	it "143000000000000.00" => sub { is rur2words(143000000000000.00), "сто сорок три триллиона рублей 00 копеек"; };
	it "144000000000000.00" => sub { is rur2words(144000000000000.00), "сто сорок четыре триллиона рублей 00 копеек"; };
	it "145000000000000.00" => sub { is rur2words(145000000000000.00), "сто сорок пять триллионов рублей 00 копеек"; };
	it "146000000000000.00" => sub { is rur2words(146000000000000.00), "сто сорок шесть триллионов рублей 00 копеек"; };
	it "147000000000000.00" => sub { is rur2words(147000000000000.00), "сто сорок семь триллионов рублей 00 копеек"; };
	it "148000000000000.00" => sub { is rur2words(148000000000000.00), "сто сорок восемь триллионов рублей 00 копеек"; };
	it "149000000000000.00" => sub { is rur2words(149000000000000.00), "сто сорок девять триллионов рублей 00 копеек"; };
	it "150000000000000.00" => sub { is rur2words(150000000000000.00), "сто пятьдесят триллионов рублей 00 копеек"; };
	it "151000000000000.00" => sub { is rur2words(151000000000000.00), "сто пятьдесят один триллион рублей 00 копеек"; };
	it "152000000000000.00" => sub { is rur2words(152000000000000.00), "сто пятьдесят два триллиона рублей 00 копеек"; };
	it "153000000000000.00" => sub { is rur2words(153000000000000.00), "сто пятьдесят три триллиона рублей 00 копеек"; };
	it "154000000000000.00" => sub { is rur2words(154000000000000.00), "сто пятьдесят четыре триллиона рублей 00 копеек"; };
	it "155000000000000.00" => sub { is rur2words(155000000000000.00), "сто пятьдесят пять триллионов рублей 00 копеек"; };
	it "156000000000000.00" => sub { is rur2words(156000000000000.00), "сто пятьдесят шесть триллионов рублей 00 копеек"; };
	it "157000000000000.00" => sub { is rur2words(157000000000000.00), "сто пятьдесят семь триллионов рублей 00 копеек"; };
	it "158000000000000.00" => sub { is rur2words(158000000000000.00), "сто пятьдесят восемь триллионов рублей 00 копеек"; };
	it "159000000000000.00" => sub { is rur2words(159000000000000.00), "сто пятьдесят девять триллионов рублей 00 копеек"; };
	it "160000000000000.00" => sub { is rur2words(160000000000000.00), "сто шестьдесят триллионов рублей 00 копеек"; };
	it "161000000000000.00" => sub { is rur2words(161000000000000.00), "сто шестьдесят один триллион рублей 00 копеек"; };
	it "162000000000000.00" => sub { is rur2words(162000000000000.00), "сто шестьдесят два триллиона рублей 00 копеек"; };
	it "163000000000000.00" => sub { is rur2words(163000000000000.00), "сто шестьдесят три триллиона рублей 00 копеек"; };
	it "164000000000000.00" => sub { is rur2words(164000000000000.00), "сто шестьдесят четыре триллиона рублей 00 копеек"; };
	it "165000000000000.00" => sub { is rur2words(165000000000000.00), "сто шестьдесят пять триллионов рублей 00 копеек"; };
	it "166000000000000.00" => sub { is rur2words(166000000000000.00), "сто шестьдесят шесть триллионов рублей 00 копеек"; };
	it "167000000000000.00" => sub { is rur2words(167000000000000.00), "сто шестьдесят семь триллионов рублей 00 копеек"; };
	it "168000000000000.00" => sub { is rur2words(168000000000000.00), "сто шестьдесят восемь триллионов рублей 00 копеек"; };
	it "169000000000000.00" => sub { is rur2words(169000000000000.00), "сто шестьдесят девять триллионов рублей 00 копеек"; };
	it "170000000000000.00" => sub { is rur2words(170000000000000.00), "сто семьдесят триллионов рублей 00 копеек"; };
	it "171000000000000.00" => sub { is rur2words(171000000000000.00), "сто семьдесят один триллион рублей 00 копеек"; };
	it "172000000000000.00" => sub { is rur2words(172000000000000.00), "сто семьдесят два триллиона рублей 00 копеек"; };
	it "173000000000000.00" => sub { is rur2words(173000000000000.00), "сто семьдесят три триллиона рублей 00 копеек"; };
	it "174000000000000.00" => sub { is rur2words(174000000000000.00), "сто семьдесят четыре триллиона рублей 00 копеек"; };
	it "175000000000000.00" => sub { is rur2words(175000000000000.00), "сто семьдесят пять триллионов рублей 00 копеек"; };
	it "176000000000000.00" => sub { is rur2words(176000000000000.00), "сто семьдесят шесть триллионов рублей 00 копеек"; };
	it "177000000000000.00" => sub { is rur2words(177000000000000.00), "сто семьдесят семь триллионов рублей 00 копеек"; };
	it "178000000000000.00" => sub { is rur2words(178000000000000.00), "сто семьдесят восемь триллионов рублей 00 копеек"; };
	it "179000000000000.00" => sub { is rur2words(179000000000000.00), "сто семьдесят девять триллионов рублей 00 копеек"; };
	it "180000000000000.00" => sub { is rur2words(180000000000000.00), "сто восемьдесят триллионов рублей 00 копеек"; };
	it "181000000000000.00" => sub { is rur2words(181000000000000.00), "сто восемьдесят один триллион рублей 00 копеек"; };
	it "182000000000000.00" => sub { is rur2words(182000000000000.00), "сто восемьдесят два триллиона рублей 00 копеек"; };
	it "183000000000000.00" => sub { is rur2words(183000000000000.00), "сто восемьдесят три триллиона рублей 00 копеек"; };
	it "184000000000000.00" => sub { is rur2words(184000000000000.00), "сто восемьдесят четыре триллиона рублей 00 копеек"; };
	it "185000000000000.00" => sub { is rur2words(185000000000000.00), "сто восемьдесят пять триллионов рублей 00 копеек"; };
	it "186000000000000.00" => sub { is rur2words(186000000000000.00), "сто восемьдесят шесть триллионов рублей 00 копеек"; };
	it "187000000000000.00" => sub { is rur2words(187000000000000.00), "сто восемьдесят семь триллионов рублей 00 копеек"; };
	it "188000000000000.00" => sub { is rur2words(188000000000000.00), "сто восемьдесят восемь триллионов рублей 00 копеек"; };
	it "189000000000000.00" => sub { is rur2words(189000000000000.00), "сто восемьдесят девять триллионов рублей 00 копеек"; };
	it "190000000000000.00" => sub { is rur2words(190000000000000.00), "сто девяносто триллионов рублей 00 копеек"; };
	it "191000000000000.00" => sub { is rur2words(191000000000000.00), "сто девяносто один триллион рублей 00 копеек"; };
	it "192000000000000.00" => sub { is rur2words(192000000000000.00), "сто девяносто два триллиона рублей 00 копеек"; };
	it "193000000000000.00" => sub { is rur2words(193000000000000.00), "сто девяносто три триллиона рублей 00 копеек"; };
	it "194000000000000.00" => sub { is rur2words(194000000000000.00), "сто девяносто четыре триллиона рублей 00 копеек"; };
	it "195000000000000.00" => sub { is rur2words(195000000000000.00), "сто девяносто пять триллионов рублей 00 копеек"; };
	it "196000000000000.00" => sub { is rur2words(196000000000000.00), "сто девяносто шесть триллионов рублей 00 копеек"; };
	it "197000000000000.00" => sub { is rur2words(197000000000000.00), "сто девяносто семь триллионов рублей 00 копеек"; };
	it "198000000000000.00" => sub { is rur2words(198000000000000.00), "сто девяносто восемь триллионов рублей 00 копеек"; };
	it "199000000000000.00" => sub { is rur2words(199000000000000.00), "сто девяносто девять триллионов рублей 00 копеек"; };
	it "200000000000000.00" => sub { is rur2words(200000000000000.00), "двести триллионов рублей 00 копеек"; };
	it "201000000000000.00" => sub { is rur2words(201000000000000.00), "двести один триллион рублей 00 копеек"; };
	it "202000000000000.00" => sub { is rur2words(202000000000000.00), "двести два триллиона рублей 00 копеек"; };
	it "203000000000000.00" => sub { is rur2words(203000000000000.00), "двести три триллиона рублей 00 копеек"; };
	it "204000000000000.00" => sub { is rur2words(204000000000000.00), "двести четыре триллиона рублей 00 копеек"; };
	it "205000000000000.00" => sub { is rur2words(205000000000000.00), "двести пять триллионов рублей 00 копеек"; };
	it "206000000000000.00" => sub { is rur2words(206000000000000.00), "двести шесть триллионов рублей 00 копеек"; };
	it "207000000000000.00" => sub { is rur2words(207000000000000.00), "двести семь триллионов рублей 00 копеек"; };
	it "208000000000000.00" => sub { is rur2words(208000000000000.00), "двести восемь триллионов рублей 00 копеек"; };
	it "209000000000000.00" => sub { is rur2words(209000000000000.00), "двести девять триллионов рублей 00 копеек"; };
	it "210000000000000.00" => sub { is rur2words(210000000000000.00), "двести десять триллионов рублей 00 копеек"; };
	it "211000000000000.00" => sub { is rur2words(211000000000000.00), "двести одиннадцать триллионов рублей 00 копеек"; };
	it "212000000000000.00" => sub { is rur2words(212000000000000.00), "двести двенадцать триллионов рублей 00 копеек"; };
	it "213000000000000.00" => sub { is rur2words(213000000000000.00), "двести тринадцать триллионов рублей 00 копеек"; };
	it "214000000000000.00" => sub { is rur2words(214000000000000.00), "двести четырнадцать триллионов рублей 00 копеек"; };
	it "215000000000000.00" => sub { is rur2words(215000000000000.00), "двести пятнадцать триллионов рублей 00 копеек"; };
	it "216000000000000.00" => sub { is rur2words(216000000000000.00), "двести шестнадцать триллионов рублей 00 копеек"; };
	it "217000000000000.00" => sub { is rur2words(217000000000000.00), "двести семнадцать триллионов рублей 00 копеек"; };
	it "218000000000000.00" => sub { is rur2words(218000000000000.00), "двести восемнадцать триллионов рублей 00 копеек"; };
	it "219000000000000.00" => sub { is rur2words(219000000000000.00), "двести девятнадцать триллионов рублей 00 копеек"; };
	it "220000000000000.00" => sub { is rur2words(220000000000000.00), "двести двадцать триллионов рублей 00 копеек"; };
	it "221000000000000.00" => sub { is rur2words(221000000000000.00), "двести двадцать один триллион рублей 00 копеек"; };
	it "222000000000000.00" => sub { is rur2words(222000000000000.00), "двести двадцать два триллиона рублей 00 копеек"; };
	it "223000000000000.00" => sub { is rur2words(223000000000000.00), "двести двадцать три триллиона рублей 00 копеек"; };
	it "224000000000000.00" => sub { is rur2words(224000000000000.00), "двести двадцать четыре триллиона рублей 00 копеек"; };
	it "225000000000000.00" => sub { is rur2words(225000000000000.00), "двести двадцать пять триллионов рублей 00 копеек"; };
	it "226000000000000.00" => sub { is rur2words(226000000000000.00), "двести двадцать шесть триллионов рублей 00 копеек"; };
	it "227000000000000.00" => sub { is rur2words(227000000000000.00), "двести двадцать семь триллионов рублей 00 копеек"; };
	it "228000000000000.00" => sub { is rur2words(228000000000000.00), "двести двадцать восемь триллионов рублей 00 копеек"; };
	it "229000000000000.00" => sub { is rur2words(229000000000000.00), "двести двадцать девять триллионов рублей 00 копеек"; };
	it "230000000000000.00" => sub { is rur2words(230000000000000.00), "двести тридцать триллионов рублей 00 копеек"; };
	it "231000000000000.00" => sub { is rur2words(231000000000000.00), "двести тридцать один триллион рублей 00 копеек"; };
	it "232000000000000.00" => sub { is rur2words(232000000000000.00), "двести тридцать два триллиона рублей 00 копеек"; };
	it "233000000000000.00" => sub { is rur2words(233000000000000.00), "двести тридцать три триллиона рублей 00 копеек"; };
	it "234000000000000.00" => sub { is rur2words(234000000000000.00), "двести тридцать четыре триллиона рублей 00 копеек"; };
	it "235000000000000.00" => sub { is rur2words(235000000000000.00), "двести тридцать пять триллионов рублей 00 копеек"; };
	it "236000000000000.00" => sub { is rur2words(236000000000000.00), "двести тридцать шесть триллионов рублей 00 копеек"; };
	it "237000000000000.00" => sub { is rur2words(237000000000000.00), "двести тридцать семь триллионов рублей 00 копеек"; };
	it "238000000000000.00" => sub { is rur2words(238000000000000.00), "двести тридцать восемь триллионов рублей 00 копеек"; };
	it "239000000000000.00" => sub { is rur2words(239000000000000.00), "двести тридцать девять триллионов рублей 00 копеек"; };
	it "240000000000000.00" => sub { is rur2words(240000000000000.00), "двести сорок триллионов рублей 00 копеек"; };
	it "241000000000000.00" => sub { is rur2words(241000000000000.00), "двести сорок один триллион рублей 00 копеек"; };
	it "242000000000000.00" => sub { is rur2words(242000000000000.00), "двести сорок два триллиона рублей 00 копеек"; };
	it "243000000000000.00" => sub { is rur2words(243000000000000.00), "двести сорок три триллиона рублей 00 копеек"; };
	it "244000000000000.00" => sub { is rur2words(244000000000000.00), "двести сорок четыре триллиона рублей 00 копеек"; };
	it "245000000000000.00" => sub { is rur2words(245000000000000.00), "двести сорок пять триллионов рублей 00 копеек"; };
	it "246000000000000.00" => sub { is rur2words(246000000000000.00), "двести сорок шесть триллионов рублей 00 копеек"; };
	it "247000000000000.00" => sub { is rur2words(247000000000000.00), "двести сорок семь триллионов рублей 00 копеек"; };
	it "248000000000000.00" => sub { is rur2words(248000000000000.00), "двести сорок восемь триллионов рублей 00 копеек"; };
	it "249000000000000.00" => sub { is rur2words(249000000000000.00), "двести сорок девять триллионов рублей 00 копеек"; };
	it "250000000000000.00" => sub { is rur2words(250000000000000.00), "двести пятьдесят триллионов рублей 00 копеек"; };
	it "251000000000000.00" => sub { is rur2words(251000000000000.00), "двести пятьдесят один триллион рублей 00 копеек"; };
	it "252000000000000.00" => sub { is rur2words(252000000000000.00), "двести пятьдесят два триллиона рублей 00 копеек"; };
	it "253000000000000.00" => sub { is rur2words(253000000000000.00), "двести пятьдесят три триллиона рублей 00 копеек"; };
	it "254000000000000.00" => sub { is rur2words(254000000000000.00), "двести пятьдесят четыре триллиона рублей 00 копеек"; };
	it "255000000000000.00" => sub { is rur2words(255000000000000.00), "двести пятьдесят пять триллионов рублей 00 копеек"; };
	it "256000000000000.00" => sub { is rur2words(256000000000000.00), "двести пятьдесят шесть триллионов рублей 00 копеек"; };
	it "257000000000000.00" => sub { is rur2words(257000000000000.00), "двести пятьдесят семь триллионов рублей 00 копеек"; };
	it "258000000000000.00" => sub { is rur2words(258000000000000.00), "двести пятьдесят восемь триллионов рублей 00 копеек"; };
	it "259000000000000.00" => sub { is rur2words(259000000000000.00), "двести пятьдесят девять триллионов рублей 00 копеек"; };
	it "260000000000000.00" => sub { is rur2words(260000000000000.00), "двести шестьдесят триллионов рублей 00 копеек"; };
	it "261000000000000.00" => sub { is rur2words(261000000000000.00), "двести шестьдесят один триллион рублей 00 копеек"; };
	it "262000000000000.00" => sub { is rur2words(262000000000000.00), "двести шестьдесят два триллиона рублей 00 копеек"; };
	it "263000000000000.00" => sub { is rur2words(263000000000000.00), "двести шестьдесят три триллиона рублей 00 копеек"; };
	it "264000000000000.00" => sub { is rur2words(264000000000000.00), "двести шестьдесят четыре триллиона рублей 00 копеек"; };
	it "265000000000000.00" => sub { is rur2words(265000000000000.00), "двести шестьдесят пять триллионов рублей 00 копеек"; };
	it "266000000000000.00" => sub { is rur2words(266000000000000.00), "двести шестьдесят шесть триллионов рублей 00 копеек"; };
	it "267000000000000.00" => sub { is rur2words(267000000000000.00), "двести шестьдесят семь триллионов рублей 00 копеек"; };
	it "268000000000000.00" => sub { is rur2words(268000000000000.00), "двести шестьдесят восемь триллионов рублей 00 копеек"; };
	it "269000000000000.00" => sub { is rur2words(269000000000000.00), "двести шестьдесят девять триллионов рублей 00 копеек"; };
	it "270000000000000.00" => sub { is rur2words(270000000000000.00), "двести семьдесят триллионов рублей 00 копеек"; };
	it "271000000000000.00" => sub { is rur2words(271000000000000.00), "двести семьдесят один триллион рублей 00 копеек"; };
	it "272000000000000.00" => sub { is rur2words(272000000000000.00), "двести семьдесят два триллиона рублей 00 копеек"; };
	it "273000000000000.00" => sub { is rur2words(273000000000000.00), "двести семьдесят три триллиона рублей 00 копеек"; };
	it "274000000000000.00" => sub { is rur2words(274000000000000.00), "двести семьдесят четыре триллиона рублей 00 копеек"; };
	it "275000000000000.00" => sub { is rur2words(275000000000000.00), "двести семьдесят пять триллионов рублей 00 копеек"; };
	it "276000000000000.00" => sub { is rur2words(276000000000000.00), "двести семьдесят шесть триллионов рублей 00 копеек"; };
	it "277000000000000.00" => sub { is rur2words(277000000000000.00), "двести семьдесят семь триллионов рублей 00 копеек"; };
	it "278000000000000.00" => sub { is rur2words(278000000000000.00), "двести семьдесят восемь триллионов рублей 00 копеек"; };
	it "279000000000000.00" => sub { is rur2words(279000000000000.00), "двести семьдесят девять триллионов рублей 00 копеек"; };
	it "280000000000000.00" => sub { is rur2words(280000000000000.00), "двести восемьдесят триллионов рублей 00 копеек"; };
	it "281000000000000.00" => sub { is rur2words(281000000000000.00), "двести восемьдесят один триллион рублей 00 копеек"; };
	it "282000000000000.00" => sub { is rur2words(282000000000000.00), "двести восемьдесят два триллиона рублей 00 копеек"; };
	it "283000000000000.00" => sub { is rur2words(283000000000000.00), "двести восемьдесят три триллиона рублей 00 копеек"; };
	it "284000000000000.00" => sub { is rur2words(284000000000000.00), "двести восемьдесят четыре триллиона рублей 00 копеек"; };
	it "285000000000000.00" => sub { is rur2words(285000000000000.00), "двести восемьдесят пять триллионов рублей 00 копеек"; };
	it "286000000000000.00" => sub { is rur2words(286000000000000.00), "двести восемьдесят шесть триллионов рублей 00 копеек"; };
	it "287000000000000.00" => sub { is rur2words(287000000000000.00), "двести восемьдесят семь триллионов рублей 00 копеек"; };
	it "288000000000000.00" => sub { is rur2words(288000000000000.00), "двести восемьдесят восемь триллионов рублей 00 копеек"; };
	it "289000000000000.00" => sub { is rur2words(289000000000000.00), "двести восемьдесят девять триллионов рублей 00 копеек"; };
	it "290000000000000.00" => sub { is rur2words(290000000000000.00), "двести девяносто триллионов рублей 00 копеек"; };
	it "291000000000000.00" => sub { is rur2words(291000000000000.00), "двести девяносто один триллион рублей 00 копеек"; };
	it "292000000000000.00" => sub { is rur2words(292000000000000.00), "двести девяносто два триллиона рублей 00 копеек"; };
	it "293000000000000.00" => sub { is rur2words(293000000000000.00), "двести девяносто три триллиона рублей 00 копеек"; };
	it "294000000000000.00" => sub { is rur2words(294000000000000.00), "двести девяносто четыре триллиона рублей 00 копеек"; };
	it "295000000000000.00" => sub { is rur2words(295000000000000.00), "двести девяносто пять триллионов рублей 00 копеек"; };
	it "296000000000000.00" => sub { is rur2words(296000000000000.00), "двести девяносто шесть триллионов рублей 00 копеек"; };
	it "297000000000000.00" => sub { is rur2words(297000000000000.00), "двести девяносто семь триллионов рублей 00 копеек"; };
	it "298000000000000.00" => sub { is rur2words(298000000000000.00), "двести девяносто восемь триллионов рублей 00 копеек"; };
	it "299000000000000.00" => sub { is rur2words(299000000000000.00), "двести девяносто девять триллионов рублей 00 копеек"; };
	it "300000000000000.00" => sub { is rur2words(300000000000000.00), "триста триллионов рублей 00 копеек"; };
	it "301000000000000.00" => sub { is rur2words(301000000000000.00), "триста один триллион рублей 00 копеек"; };
	it "302000000000000.00" => sub { is rur2words(302000000000000.00), "триста два триллиона рублей 00 копеек"; };
	it "303000000000000.00" => sub { is rur2words(303000000000000.00), "триста три триллиона рублей 00 копеек"; };
	it "304000000000000.00" => sub { is rur2words(304000000000000.00), "триста четыре триллиона рублей 00 копеек"; };
	it "305000000000000.00" => sub { is rur2words(305000000000000.00), "триста пять триллионов рублей 00 копеек"; };
	it "306000000000000.00" => sub { is rur2words(306000000000000.00), "триста шесть триллионов рублей 00 копеек"; };
	it "307000000000000.00" => sub { is rur2words(307000000000000.00), "триста семь триллионов рублей 00 копеек"; };
	it "308000000000000.00" => sub { is rur2words(308000000000000.00), "триста восемь триллионов рублей 00 копеек"; };
	it "309000000000000.00" => sub { is rur2words(309000000000000.00), "триста девять триллионов рублей 00 копеек"; };
	it "310000000000000.00" => sub { is rur2words(310000000000000.00), "триста десять триллионов рублей 00 копеек"; };
	it "311000000000000.00" => sub { is rur2words(311000000000000.00), "триста одиннадцать триллионов рублей 00 копеек"; };
	it "312000000000000.00" => sub { is rur2words(312000000000000.00), "триста двенадцать триллионов рублей 00 копеек"; };
	it "313000000000000.00" => sub { is rur2words(313000000000000.00), "триста тринадцать триллионов рублей 00 копеек"; };
	it "314000000000000.00" => sub { is rur2words(314000000000000.00), "триста четырнадцать триллионов рублей 00 копеек"; };
	it "315000000000000.00" => sub { is rur2words(315000000000000.00), "триста пятнадцать триллионов рублей 00 копеек"; };
	it "316000000000000.00" => sub { is rur2words(316000000000000.00), "триста шестнадцать триллионов рублей 00 копеек"; };
	it "317000000000000.00" => sub { is rur2words(317000000000000.00), "триста семнадцать триллионов рублей 00 копеек"; };
	it "318000000000000.00" => sub { is rur2words(318000000000000.00), "триста восемнадцать триллионов рублей 00 копеек"; };
	it "319000000000000.00" => sub { is rur2words(319000000000000.00), "триста девятнадцать триллионов рублей 00 копеек"; };
	it "320000000000000.00" => sub { is rur2words(320000000000000.00), "триста двадцать триллионов рублей 00 копеек"; };
	it "321000000000000.00" => sub { is rur2words(321000000000000.00), "триста двадцать один триллион рублей 00 копеек"; };
	it "322000000000000.00" => sub { is rur2words(322000000000000.00), "триста двадцать два триллиона рублей 00 копеек"; };
	it "323000000000000.00" => sub { is rur2words(323000000000000.00), "триста двадцать три триллиона рублей 00 копеек"; };
	it "324000000000000.00" => sub { is rur2words(324000000000000.00), "триста двадцать четыре триллиона рублей 00 копеек"; };
	it "325000000000000.00" => sub { is rur2words(325000000000000.00), "триста двадцать пять триллионов рублей 00 копеек"; };
	it "326000000000000.00" => sub { is rur2words(326000000000000.00), "триста двадцать шесть триллионов рублей 00 копеек"; };
	it "327000000000000.00" => sub { is rur2words(327000000000000.00), "триста двадцать семь триллионов рублей 00 копеек"; };
	it "328000000000000.00" => sub { is rur2words(328000000000000.00), "триста двадцать восемь триллионов рублей 00 копеек"; };
	it "329000000000000.00" => sub { is rur2words(329000000000000.00), "триста двадцать девять триллионов рублей 00 копеек"; };
	it "330000000000000.00" => sub { is rur2words(330000000000000.00), "триста тридцать триллионов рублей 00 копеек"; };
	it "331000000000000.00" => sub { is rur2words(331000000000000.00), "триста тридцать один триллион рублей 00 копеек"; };
	it "332000000000000.00" => sub { is rur2words(332000000000000.00), "триста тридцать два триллиона рублей 00 копеек"; };
	it "333000000000000.00" => sub { is rur2words(333000000000000.00), "триста тридцать три триллиона рублей 00 копеек"; };
	it "334000000000000.00" => sub { is rur2words(334000000000000.00), "триста тридцать четыре триллиона рублей 00 копеек"; };
	it "335000000000000.00" => sub { is rur2words(335000000000000.00), "триста тридцать пять триллионов рублей 00 копеек"; };
	it "336000000000000.00" => sub { is rur2words(336000000000000.00), "триста тридцать шесть триллионов рублей 00 копеек"; };
	it "337000000000000.00" => sub { is rur2words(337000000000000.00), "триста тридцать семь триллионов рублей 00 копеек"; };
	it "338000000000000.00" => sub { is rur2words(338000000000000.00), "триста тридцать восемь триллионов рублей 00 копеек"; };
	it "339000000000000.00" => sub { is rur2words(339000000000000.00), "триста тридцать девять триллионов рублей 00 копеек"; };
	it "340000000000000.00" => sub { is rur2words(340000000000000.00), "триста сорок триллионов рублей 00 копеек"; };
	it "341000000000000.00" => sub { is rur2words(341000000000000.00), "триста сорок один триллион рублей 00 копеек"; };
	it "342000000000000.00" => sub { is rur2words(342000000000000.00), "триста сорок два триллиона рублей 00 копеек"; };
	it "343000000000000.00" => sub { is rur2words(343000000000000.00), "триста сорок три триллиона рублей 00 копеек"; };
	it "344000000000000.00" => sub { is rur2words(344000000000000.00), "триста сорок четыре триллиона рублей 00 копеек"; };
	it "345000000000000.00" => sub { is rur2words(345000000000000.00), "триста сорок пять триллионов рублей 00 копеек"; };
	it "346000000000000.00" => sub { is rur2words(346000000000000.00), "триста сорок шесть триллионов рублей 00 копеек"; };
	it "347000000000000.00" => sub { is rur2words(347000000000000.00), "триста сорок семь триллионов рублей 00 копеек"; };
	it "348000000000000.00" => sub { is rur2words(348000000000000.00), "триста сорок восемь триллионов рублей 00 копеек"; };
	it "349000000000000.00" => sub { is rur2words(349000000000000.00), "триста сорок девять триллионов рублей 00 копеек"; };
	it "350000000000000.00" => sub { is rur2words(350000000000000.00), "триста пятьдесят триллионов рублей 00 копеек"; };
	it "351000000000000.00" => sub { is rur2words(351000000000000.00), "триста пятьдесят один триллион рублей 00 копеек"; };
	it "352000000000000.00" => sub { is rur2words(352000000000000.00), "триста пятьдесят два триллиона рублей 00 копеек"; };
	it "353000000000000.00" => sub { is rur2words(353000000000000.00), "триста пятьдесят три триллиона рублей 00 копеек"; };
	it "354000000000000.00" => sub { is rur2words(354000000000000.00), "триста пятьдесят четыре триллиона рублей 00 копеек"; };
	it "355000000000000.00" => sub { is rur2words(355000000000000.00), "триста пятьдесят пять триллионов рублей 00 копеек"; };
	it "356000000000000.00" => sub { is rur2words(356000000000000.00), "триста пятьдесят шесть триллионов рублей 00 копеек"; };
	it "357000000000000.00" => sub { is rur2words(357000000000000.00), "триста пятьдесят семь триллионов рублей 00 копеек"; };
	it "358000000000000.00" => sub { is rur2words(358000000000000.00), "триста пятьдесят восемь триллионов рублей 00 копеек"; };
	it "359000000000000.00" => sub { is rur2words(359000000000000.00), "триста пятьдесят девять триллионов рублей 00 копеек"; };
	it "360000000000000.00" => sub { is rur2words(360000000000000.00), "триста шестьдесят триллионов рублей 00 копеек"; };
	it "361000000000000.00" => sub { is rur2words(361000000000000.00), "триста шестьдесят один триллион рублей 00 копеек"; };
	it "362000000000000.00" => sub { is rur2words(362000000000000.00), "триста шестьдесят два триллиона рублей 00 копеек"; };
	it "363000000000000.00" => sub { is rur2words(363000000000000.00), "триста шестьдесят три триллиона рублей 00 копеек"; };
	it "364000000000000.00" => sub { is rur2words(364000000000000.00), "триста шестьдесят четыре триллиона рублей 00 копеек"; };
	it "365000000000000.00" => sub { is rur2words(365000000000000.00), "триста шестьдесят пять триллионов рублей 00 копеек"; };
	it "366000000000000.00" => sub { is rur2words(366000000000000.00), "триста шестьдесят шесть триллионов рублей 00 копеек"; };
	it "367000000000000.00" => sub { is rur2words(367000000000000.00), "триста шестьдесят семь триллионов рублей 00 копеек"; };
	it "368000000000000.00" => sub { is rur2words(368000000000000.00), "триста шестьдесят восемь триллионов рублей 00 копеек"; };
	it "369000000000000.00" => sub { is rur2words(369000000000000.00), "триста шестьдесят девять триллионов рублей 00 копеек"; };
	it "370000000000000.00" => sub { is rur2words(370000000000000.00), "триста семьдесят триллионов рублей 00 копеек"; };
	it "371000000000000.00" => sub { is rur2words(371000000000000.00), "триста семьдесят один триллион рублей 00 копеек"; };
	it "372000000000000.00" => sub { is rur2words(372000000000000.00), "триста семьдесят два триллиона рублей 00 копеек"; };
	it "373000000000000.00" => sub { is rur2words(373000000000000.00), "триста семьдесят три триллиона рублей 00 копеек"; };
	it "374000000000000.00" => sub { is rur2words(374000000000000.00), "триста семьдесят четыре триллиона рублей 00 копеек"; };
	it "375000000000000.00" => sub { is rur2words(375000000000000.00), "триста семьдесят пять триллионов рублей 00 копеек"; };
	it "376000000000000.00" => sub { is rur2words(376000000000000.00), "триста семьдесят шесть триллионов рублей 00 копеек"; };
	it "377000000000000.00" => sub { is rur2words(377000000000000.00), "триста семьдесят семь триллионов рублей 00 копеек"; };
	it "378000000000000.00" => sub { is rur2words(378000000000000.00), "триста семьдесят восемь триллионов рублей 00 копеек"; };
	it "379000000000000.00" => sub { is rur2words(379000000000000.00), "триста семьдесят девять триллионов рублей 00 копеек"; };
	it "380000000000000.00" => sub { is rur2words(380000000000000.00), "триста восемьдесят триллионов рублей 00 копеек"; };
	it "381000000000000.00" => sub { is rur2words(381000000000000.00), "триста восемьдесят один триллион рублей 00 копеек"; };
	it "382000000000000.00" => sub { is rur2words(382000000000000.00), "триста восемьдесят два триллиона рублей 00 копеек"; };
	it "383000000000000.00" => sub { is rur2words(383000000000000.00), "триста восемьдесят три триллиона рублей 00 копеек"; };
	it "384000000000000.00" => sub { is rur2words(384000000000000.00), "триста восемьдесят четыре триллиона рублей 00 копеек"; };
	it "385000000000000.00" => sub { is rur2words(385000000000000.00), "триста восемьдесят пять триллионов рублей 00 копеек"; };
	it "386000000000000.00" => sub { is rur2words(386000000000000.00), "триста восемьдесят шесть триллионов рублей 00 копеек"; };
	it "387000000000000.00" => sub { is rur2words(387000000000000.00), "триста восемьдесят семь триллионов рублей 00 копеек"; };
	it "388000000000000.00" => sub { is rur2words(388000000000000.00), "триста восемьдесят восемь триллионов рублей 00 копеек"; };
	it "389000000000000.00" => sub { is rur2words(389000000000000.00), "триста восемьдесят девять триллионов рублей 00 копеек"; };
	it "390000000000000.00" => sub { is rur2words(390000000000000.00), "триста девяносто триллионов рублей 00 копеек"; };
	it "391000000000000.00" => sub { is rur2words(391000000000000.00), "триста девяносто один триллион рублей 00 копеек"; };
	it "392000000000000.00" => sub { is rur2words(392000000000000.00), "триста девяносто два триллиона рублей 00 копеек"; };
	it "393000000000000.00" => sub { is rur2words(393000000000000.00), "триста девяносто три триллиона рублей 00 копеек"; };
	it "394000000000000.00" => sub { is rur2words(394000000000000.00), "триста девяносто четыре триллиона рублей 00 копеек"; };
	it "395000000000000.00" => sub { is rur2words(395000000000000.00), "триста девяносто пять триллионов рублей 00 копеек"; };
	it "396000000000000.00" => sub { is rur2words(396000000000000.00), "триста девяносто шесть триллионов рублей 00 копеек"; };
	it "397000000000000.00" => sub { is rur2words(397000000000000.00), "триста девяносто семь триллионов рублей 00 копеек"; };
	it "398000000000000.00" => sub { is rur2words(398000000000000.00), "триста девяносто восемь триллионов рублей 00 копеек"; };
	it "399000000000000.00" => sub { is rur2words(399000000000000.00), "триста девяносто девять триллионов рублей 00 копеек"; };
	it "400000000000000.00" => sub { is rur2words(400000000000000.00), "четыреста триллионов рублей 00 копеек"; };
	it "401000000000000.00" => sub { is rur2words(401000000000000.00), "четыреста один триллион рублей 00 копеек"; };
	it "402000000000000.00" => sub { is rur2words(402000000000000.00), "четыреста два триллиона рублей 00 копеек"; };
	it "403000000000000.00" => sub { is rur2words(403000000000000.00), "четыреста три триллиона рублей 00 копеек"; };
	it "404000000000000.00" => sub { is rur2words(404000000000000.00), "четыреста четыре триллиона рублей 00 копеек"; };
	it "405000000000000.00" => sub { is rur2words(405000000000000.00), "четыреста пять триллионов рублей 00 копеек"; };
	it "406000000000000.00" => sub { is rur2words(406000000000000.00), "четыреста шесть триллионов рублей 00 копеек"; };
	it "407000000000000.00" => sub { is rur2words(407000000000000.00), "четыреста семь триллионов рублей 00 копеек"; };
	it "408000000000000.00" => sub { is rur2words(408000000000000.00), "четыреста восемь триллионов рублей 00 копеек"; };
	it "409000000000000.00" => sub { is rur2words(409000000000000.00), "четыреста девять триллионов рублей 00 копеек"; };
	it "410000000000000.00" => sub { is rur2words(410000000000000.00), "четыреста десять триллионов рублей 00 копеек"; };
	it "411000000000000.00" => sub { is rur2words(411000000000000.00), "четыреста одиннадцать триллионов рублей 00 копеек"; };
	it "412000000000000.00" => sub { is rur2words(412000000000000.00), "четыреста двенадцать триллионов рублей 00 копеек"; };
	it "413000000000000.00" => sub { is rur2words(413000000000000.00), "четыреста тринадцать триллионов рублей 00 копеек"; };
	it "414000000000000.00" => sub { is rur2words(414000000000000.00), "четыреста четырнадцать триллионов рублей 00 копеек"; };
	it "415000000000000.00" => sub { is rur2words(415000000000000.00), "четыреста пятнадцать триллионов рублей 00 копеек"; };
	it "416000000000000.00" => sub { is rur2words(416000000000000.00), "четыреста шестнадцать триллионов рублей 00 копеек"; };
	it "417000000000000.00" => sub { is rur2words(417000000000000.00), "четыреста семнадцать триллионов рублей 00 копеек"; };
	it "418000000000000.00" => sub { is rur2words(418000000000000.00), "четыреста восемнадцать триллионов рублей 00 копеек"; };
	it "419000000000000.00" => sub { is rur2words(419000000000000.00), "четыреста девятнадцать триллионов рублей 00 копеек"; };
	it "420000000000000.00" => sub { is rur2words(420000000000000.00), "четыреста двадцать триллионов рублей 00 копеек"; };
	it "421000000000000.00" => sub { is rur2words(421000000000000.00), "четыреста двадцать один триллион рублей 00 копеек"; };
	it "422000000000000.00" => sub { is rur2words(422000000000000.00), "четыреста двадцать два триллиона рублей 00 копеек"; };
	it "423000000000000.00" => sub { is rur2words(423000000000000.00), "четыреста двадцать три триллиона рублей 00 копеек"; };
	it "424000000000000.00" => sub { is rur2words(424000000000000.00), "четыреста двадцать четыре триллиона рублей 00 копеек"; };
	it "425000000000000.00" => sub { is rur2words(425000000000000.00), "четыреста двадцать пять триллионов рублей 00 копеек"; };
	it "426000000000000.00" => sub { is rur2words(426000000000000.00), "четыреста двадцать шесть триллионов рублей 00 копеек"; };
	it "427000000000000.00" => sub { is rur2words(427000000000000.00), "четыреста двадцать семь триллионов рублей 00 копеек"; };
	it "428000000000000.00" => sub { is rur2words(428000000000000.00), "четыреста двадцать восемь триллионов рублей 00 копеек"; };
	it "429000000000000.00" => sub { is rur2words(429000000000000.00), "четыреста двадцать девять триллионов рублей 00 копеек"; };
	it "430000000000000.00" => sub { is rur2words(430000000000000.00), "четыреста тридцать триллионов рублей 00 копеек"; };
	it "431000000000000.00" => sub { is rur2words(431000000000000.00), "четыреста тридцать один триллион рублей 00 копеек"; };
	it "432000000000000.00" => sub { is rur2words(432000000000000.00), "четыреста тридцать два триллиона рублей 00 копеек"; };
	it "433000000000000.00" => sub { is rur2words(433000000000000.00), "четыреста тридцать три триллиона рублей 00 копеек"; };
	it "434000000000000.00" => sub { is rur2words(434000000000000.00), "четыреста тридцать четыре триллиона рублей 00 копеек"; };
	it "435000000000000.00" => sub { is rur2words(435000000000000.00), "четыреста тридцать пять триллионов рублей 00 копеек"; };
	it "436000000000000.00" => sub { is rur2words(436000000000000.00), "четыреста тридцать шесть триллионов рублей 00 копеек"; };
	it "437000000000000.00" => sub { is rur2words(437000000000000.00), "четыреста тридцать семь триллионов рублей 00 копеек"; };
	it "438000000000000.00" => sub { is rur2words(438000000000000.00), "четыреста тридцать восемь триллионов рублей 00 копеек"; };
	it "439000000000000.00" => sub { is rur2words(439000000000000.00), "четыреста тридцать девять триллионов рублей 00 копеек"; };
	it "440000000000000.00" => sub { is rur2words(440000000000000.00), "четыреста сорок триллионов рублей 00 копеек"; };
	it "441000000000000.00" => sub { is rur2words(441000000000000.00), "четыреста сорок один триллион рублей 00 копеек"; };
	it "442000000000000.00" => sub { is rur2words(442000000000000.00), "четыреста сорок два триллиона рублей 00 копеек"; };
	it "443000000000000.00" => sub { is rur2words(443000000000000.00), "четыреста сорок три триллиона рублей 00 копеек"; };
	it "444000000000000.00" => sub { is rur2words(444000000000000.00), "четыреста сорок четыре триллиона рублей 00 копеек"; };
	it "445000000000000.00" => sub { is rur2words(445000000000000.00), "четыреста сорок пять триллионов рублей 00 копеек"; };
	it "446000000000000.00" => sub { is rur2words(446000000000000.00), "четыреста сорок шесть триллионов рублей 00 копеек"; };
	it "447000000000000.00" => sub { is rur2words(447000000000000.00), "четыреста сорок семь триллионов рублей 00 копеек"; };
	it "448000000000000.00" => sub { is rur2words(448000000000000.00), "четыреста сорок восемь триллионов рублей 00 копеек"; };
	it "449000000000000.00" => sub { is rur2words(449000000000000.00), "четыреста сорок девять триллионов рублей 00 копеек"; };
	it "450000000000000.00" => sub { is rur2words(450000000000000.00), "четыреста пятьдесят триллионов рублей 00 копеек"; };
	it "451000000000000.00" => sub { is rur2words(451000000000000.00), "четыреста пятьдесят один триллион рублей 00 копеек"; };
	it "452000000000000.00" => sub { is rur2words(452000000000000.00), "четыреста пятьдесят два триллиона рублей 00 копеек"; };
	it "453000000000000.00" => sub { is rur2words(453000000000000.00), "четыреста пятьдесят три триллиона рублей 00 копеек"; };
	it "454000000000000.00" => sub { is rur2words(454000000000000.00), "четыреста пятьдесят четыре триллиона рублей 00 копеек"; };
	it "455000000000000.00" => sub { is rur2words(455000000000000.00), "четыреста пятьдесят пять триллионов рублей 00 копеек"; };
	it "456000000000000.00" => sub { is rur2words(456000000000000.00), "четыреста пятьдесят шесть триллионов рублей 00 копеек"; };
	it "457000000000000.00" => sub { is rur2words(457000000000000.00), "четыреста пятьдесят семь триллионов рублей 00 копеек"; };
	it "458000000000000.00" => sub { is rur2words(458000000000000.00), "четыреста пятьдесят восемь триллионов рублей 00 копеек"; };
	it "459000000000000.00" => sub { is rur2words(459000000000000.00), "четыреста пятьдесят девять триллионов рублей 00 копеек"; };
	it "460000000000000.00" => sub { is rur2words(460000000000000.00), "четыреста шестьдесят триллионов рублей 00 копеек"; };
	it "461000000000000.00" => sub { is rur2words(461000000000000.00), "четыреста шестьдесят один триллион рублей 00 копеек"; };
	it "462000000000000.00" => sub { is rur2words(462000000000000.00), "четыреста шестьдесят два триллиона рублей 00 копеек"; };
	it "463000000000000.00" => sub { is rur2words(463000000000000.00), "четыреста шестьдесят три триллиона рублей 00 копеек"; };
	it "464000000000000.00" => sub { is rur2words(464000000000000.00), "четыреста шестьдесят четыре триллиона рублей 00 копеек"; };
	it "465000000000000.00" => sub { is rur2words(465000000000000.00), "четыреста шестьдесят пять триллионов рублей 00 копеек"; };
	it "466000000000000.00" => sub { is rur2words(466000000000000.00), "четыреста шестьдесят шесть триллионов рублей 00 копеек"; };
	it "467000000000000.00" => sub { is rur2words(467000000000000.00), "четыреста шестьдесят семь триллионов рублей 00 копеек"; };
	it "468000000000000.00" => sub { is rur2words(468000000000000.00), "четыреста шестьдесят восемь триллионов рублей 00 копеек"; };
	it "469000000000000.00" => sub { is rur2words(469000000000000.00), "четыреста шестьдесят девять триллионов рублей 00 копеек"; };
	it "470000000000000.00" => sub { is rur2words(470000000000000.00), "четыреста семьдесят триллионов рублей 00 копеек"; };
	it "471000000000000.00" => sub { is rur2words(471000000000000.00), "четыреста семьдесят один триллион рублей 00 копеек"; };
	it "472000000000000.00" => sub { is rur2words(472000000000000.00), "четыреста семьдесят два триллиона рублей 00 копеек"; };
	it "473000000000000.00" => sub { is rur2words(473000000000000.00), "четыреста семьдесят три триллиона рублей 00 копеек"; };
	it "474000000000000.00" => sub { is rur2words(474000000000000.00), "четыреста семьдесят четыре триллиона рублей 00 копеек"; };
	it "475000000000000.00" => sub { is rur2words(475000000000000.00), "четыреста семьдесят пять триллионов рублей 00 копеек"; };
	it "476000000000000.00" => sub { is rur2words(476000000000000.00), "четыреста семьдесят шесть триллионов рублей 00 копеек"; };
	it "477000000000000.00" => sub { is rur2words(477000000000000.00), "четыреста семьдесят семь триллионов рублей 00 копеек"; };
	it "478000000000000.00" => sub { is rur2words(478000000000000.00), "четыреста семьдесят восемь триллионов рублей 00 копеек"; };
	it "479000000000000.00" => sub { is rur2words(479000000000000.00), "четыреста семьдесят девять триллионов рублей 00 копеек"; };
	it "480000000000000.00" => sub { is rur2words(480000000000000.00), "четыреста восемьдесят триллионов рублей 00 копеек"; };
	it "481000000000000.00" => sub { is rur2words(481000000000000.00), "четыреста восемьдесят один триллион рублей 00 копеек"; };
	it "482000000000000.00" => sub { is rur2words(482000000000000.00), "четыреста восемьдесят два триллиона рублей 00 копеек"; };
	it "483000000000000.00" => sub { is rur2words(483000000000000.00), "четыреста восемьдесят три триллиона рублей 00 копеек"; };
	it "484000000000000.00" => sub { is rur2words(484000000000000.00), "четыреста восемьдесят четыре триллиона рублей 00 копеек"; };
	it "485000000000000.00" => sub { is rur2words(485000000000000.00), "четыреста восемьдесят пять триллионов рублей 00 копеек"; };
	it "486000000000000.00" => sub { is rur2words(486000000000000.00), "четыреста восемьдесят шесть триллионов рублей 00 копеек"; };
	it "487000000000000.00" => sub { is rur2words(487000000000000.00), "четыреста восемьдесят семь триллионов рублей 00 копеек"; };
	it "488000000000000.00" => sub { is rur2words(488000000000000.00), "четыреста восемьдесят восемь триллионов рублей 00 копеек"; };
	it "489000000000000.00" => sub { is rur2words(489000000000000.00), "четыреста восемьдесят девять триллионов рублей 00 копеек"; };
	it "490000000000000.00" => sub { is rur2words(490000000000000.00), "четыреста девяносто триллионов рублей 00 копеек"; };
	it "491000000000000.00" => sub { is rur2words(491000000000000.00), "четыреста девяносто один триллион рублей 00 копеек"; };
	it "492000000000000.00" => sub { is rur2words(492000000000000.00), "четыреста девяносто два триллиона рублей 00 копеек"; };
	it "493000000000000.00" => sub { is rur2words(493000000000000.00), "четыреста девяносто три триллиона рублей 00 копеек"; };
	it "494000000000000.00" => sub { is rur2words(494000000000000.00), "четыреста девяносто четыре триллиона рублей 00 копеек"; };
	it "495000000000000.00" => sub { is rur2words(495000000000000.00), "четыреста девяносто пять триллионов рублей 00 копеек"; };
	it "496000000000000.00" => sub { is rur2words(496000000000000.00), "четыреста девяносто шесть триллионов рублей 00 копеек"; };
	it "497000000000000.00" => sub { is rur2words(497000000000000.00), "четыреста девяносто семь триллионов рублей 00 копеек"; };
	it "498000000000000.00" => sub { is rur2words(498000000000000.00), "четыреста девяносто восемь триллионов рублей 00 копеек"; };
	it "499000000000000.00" => sub { is rur2words(499000000000000.00), "четыреста девяносто девять триллионов рублей 00 копеек"; };
	it "500000000000000.00" => sub { is rur2words(500000000000000.00), "пятьсот триллионов рублей 00 копеек"; };
	it "501000000000000.00" => sub { is rur2words(501000000000000.00), "пятьсот один триллион рублей 00 копеек"; };
	it "502000000000000.00" => sub { is rur2words(502000000000000.00), "пятьсот два триллиона рублей 00 копеек"; };
	it "503000000000000.00" => sub { is rur2words(503000000000000.00), "пятьсот три триллиона рублей 00 копеек"; };
	it "504000000000000.00" => sub { is rur2words(504000000000000.00), "пятьсот четыре триллиона рублей 00 копеек"; };
	it "505000000000000.00" => sub { is rur2words(505000000000000.00), "пятьсот пять триллионов рублей 00 копеек"; };
	it "506000000000000.00" => sub { is rur2words(506000000000000.00), "пятьсот шесть триллионов рублей 00 копеек"; };
	it "507000000000000.00" => sub { is rur2words(507000000000000.00), "пятьсот семь триллионов рублей 00 копеек"; };
	it "508000000000000.00" => sub { is rur2words(508000000000000.00), "пятьсот восемь триллионов рублей 00 копеек"; };
	it "509000000000000.00" => sub { is rur2words(509000000000000.00), "пятьсот девять триллионов рублей 00 копеек"; };
	it "510000000000000.00" => sub { is rur2words(510000000000000.00), "пятьсот десять триллионов рублей 00 копеек"; };
	it "511000000000000.00" => sub { is rur2words(511000000000000.00), "пятьсот одиннадцать триллионов рублей 00 копеек"; };
	it "512000000000000.00" => sub { is rur2words(512000000000000.00), "пятьсот двенадцать триллионов рублей 00 копеек"; };
	it "513000000000000.00" => sub { is rur2words(513000000000000.00), "пятьсот тринадцать триллионов рублей 00 копеек"; };
	it "514000000000000.00" => sub { is rur2words(514000000000000.00), "пятьсот четырнадцать триллионов рублей 00 копеек"; };
	it "515000000000000.00" => sub { is rur2words(515000000000000.00), "пятьсот пятнадцать триллионов рублей 00 копеек"; };
	it "516000000000000.00" => sub { is rur2words(516000000000000.00), "пятьсот шестнадцать триллионов рублей 00 копеек"; };
	it "517000000000000.00" => sub { is rur2words(517000000000000.00), "пятьсот семнадцать триллионов рублей 00 копеек"; };
	it "518000000000000.00" => sub { is rur2words(518000000000000.00), "пятьсот восемнадцать триллионов рублей 00 копеек"; };
	it "519000000000000.00" => sub { is rur2words(519000000000000.00), "пятьсот девятнадцать триллионов рублей 00 копеек"; };
	it "520000000000000.00" => sub { is rur2words(520000000000000.00), "пятьсот двадцать триллионов рублей 00 копеек"; };
	it "521000000000000.00" => sub { is rur2words(521000000000000.00), "пятьсот двадцать один триллион рублей 00 копеек"; };
	it "522000000000000.00" => sub { is rur2words(522000000000000.00), "пятьсот двадцать два триллиона рублей 00 копеек"; };
	it "523000000000000.00" => sub { is rur2words(523000000000000.00), "пятьсот двадцать три триллиона рублей 00 копеек"; };
	it "524000000000000.00" => sub { is rur2words(524000000000000.00), "пятьсот двадцать четыре триллиона рублей 00 копеек"; };
	it "525000000000000.00" => sub { is rur2words(525000000000000.00), "пятьсот двадцать пять триллионов рублей 00 копеек"; };
	it "526000000000000.00" => sub { is rur2words(526000000000000.00), "пятьсот двадцать шесть триллионов рублей 00 копеек"; };
	it "527000000000000.00" => sub { is rur2words(527000000000000.00), "пятьсот двадцать семь триллионов рублей 00 копеек"; };
	it "528000000000000.00" => sub { is rur2words(528000000000000.00), "пятьсот двадцать восемь триллионов рублей 00 копеек"; };
	it "529000000000000.00" => sub { is rur2words(529000000000000.00), "пятьсот двадцать девять триллионов рублей 00 копеек"; };
	it "530000000000000.00" => sub { is rur2words(530000000000000.00), "пятьсот тридцать триллионов рублей 00 копеек"; };
	it "531000000000000.00" => sub { is rur2words(531000000000000.00), "пятьсот тридцать один триллион рублей 00 копеек"; };
	it "532000000000000.00" => sub { is rur2words(532000000000000.00), "пятьсот тридцать два триллиона рублей 00 копеек"; };
	it "533000000000000.00" => sub { is rur2words(533000000000000.00), "пятьсот тридцать три триллиона рублей 00 копеек"; };
	it "534000000000000.00" => sub { is rur2words(534000000000000.00), "пятьсот тридцать четыре триллиона рублей 00 копеек"; };
	it "535000000000000.00" => sub { is rur2words(535000000000000.00), "пятьсот тридцать пять триллионов рублей 00 копеек"; };
	it "536000000000000.00" => sub { is rur2words(536000000000000.00), "пятьсот тридцать шесть триллионов рублей 00 копеек"; };
	it "537000000000000.00" => sub { is rur2words(537000000000000.00), "пятьсот тридцать семь триллионов рублей 00 копеек"; };
	it "538000000000000.00" => sub { is rur2words(538000000000000.00), "пятьсот тридцать восемь триллионов рублей 00 копеек"; };
	it "539000000000000.00" => sub { is rur2words(539000000000000.00), "пятьсот тридцать девять триллионов рублей 00 копеек"; };
	it "540000000000000.00" => sub { is rur2words(540000000000000.00), "пятьсот сорок триллионов рублей 00 копеек"; };
	it "541000000000000.00" => sub { is rur2words(541000000000000.00), "пятьсот сорок один триллион рублей 00 копеек"; };
	it "542000000000000.00" => sub { is rur2words(542000000000000.00), "пятьсот сорок два триллиона рублей 00 копеек"; };
	it "543000000000000.00" => sub { is rur2words(543000000000000.00), "пятьсот сорок три триллиона рублей 00 копеек"; };
	it "544000000000000.00" => sub { is rur2words(544000000000000.00), "пятьсот сорок четыре триллиона рублей 00 копеек"; };
	it "545000000000000.00" => sub { is rur2words(545000000000000.00), "пятьсот сорок пять триллионов рублей 00 копеек"; };
	it "546000000000000.00" => sub { is rur2words(546000000000000.00), "пятьсот сорок шесть триллионов рублей 00 копеек"; };
	it "547000000000000.00" => sub { is rur2words(547000000000000.00), "пятьсот сорок семь триллионов рублей 00 копеек"; };
	it "548000000000000.00" => sub { is rur2words(548000000000000.00), "пятьсот сорок восемь триллионов рублей 00 копеек"; };
	it "549000000000000.00" => sub { is rur2words(549000000000000.00), "пятьсот сорок девять триллионов рублей 00 копеек"; };
	it "550000000000000.00" => sub { is rur2words(550000000000000.00), "пятьсот пятьдесят триллионов рублей 00 копеек"; };
	it "551000000000000.00" => sub { is rur2words(551000000000000.00), "пятьсот пятьдесят один триллион рублей 00 копеек"; };
	it "552000000000000.00" => sub { is rur2words(552000000000000.00), "пятьсот пятьдесят два триллиона рублей 00 копеек"; };
	it "553000000000000.00" => sub { is rur2words(553000000000000.00), "пятьсот пятьдесят три триллиона рублей 00 копеек"; };
	it "554000000000000.00" => sub { is rur2words(554000000000000.00), "пятьсот пятьдесят четыре триллиона рублей 00 копеек"; };
	it "555000000000000.00" => sub { is rur2words(555000000000000.00), "пятьсот пятьдесят пять триллионов рублей 00 копеек"; };
	it "556000000000000.00" => sub { is rur2words(556000000000000.00), "пятьсот пятьдесят шесть триллионов рублей 00 копеек"; };
	it "557000000000000.00" => sub { is rur2words(557000000000000.00), "пятьсот пятьдесят семь триллионов рублей 00 копеек"; };
	it "558000000000000.00" => sub { is rur2words(558000000000000.00), "пятьсот пятьдесят восемь триллионов рублей 00 копеек"; };
	it "559000000000000.00" => sub { is rur2words(559000000000000.00), "пятьсот пятьдесят девять триллионов рублей 00 копеек"; };
	it "560000000000000.00" => sub { is rur2words(560000000000000.00), "пятьсот шестьдесят триллионов рублей 00 копеек"; };
	it "561000000000000.00" => sub { is rur2words(561000000000000.00), "пятьсот шестьдесят один триллион рублей 00 копеек"; };
	it "562000000000000.00" => sub { is rur2words(562000000000000.00), "пятьсот шестьдесят два триллиона рублей 00 копеек"; };
	it "563000000000000.00" => sub { is rur2words(563000000000000.00), "пятьсот шестьдесят три триллиона рублей 00 копеек"; };
	it "564000000000000.00" => sub { is rur2words(564000000000000.00), "пятьсот шестьдесят четыре триллиона рублей 00 копеек"; };
	it "565000000000000.00" => sub { is rur2words(565000000000000.00), "пятьсот шестьдесят пять триллионов рублей 00 копеек"; };
	it "566000000000000.00" => sub { is rur2words(566000000000000.00), "пятьсот шестьдесят шесть триллионов рублей 00 копеек"; };
	it "567000000000000.00" => sub { is rur2words(567000000000000.00), "пятьсот шестьдесят семь триллионов рублей 00 копеек"; };
	it "568000000000000.00" => sub { is rur2words(568000000000000.00), "пятьсот шестьдесят восемь триллионов рублей 00 копеек"; };
	it "569000000000000.00" => sub { is rur2words(569000000000000.00), "пятьсот шестьдесят девять триллионов рублей 00 копеек"; };
	it "570000000000000.00" => sub { is rur2words(570000000000000.00), "пятьсот семьдесят триллионов рублей 00 копеек"; };
	it "571000000000000.00" => sub { is rur2words(571000000000000.00), "пятьсот семьдесят один триллион рублей 00 копеек"; };
	it "572000000000000.00" => sub { is rur2words(572000000000000.00), "пятьсот семьдесят два триллиона рублей 00 копеек"; };
	it "573000000000000.00" => sub { is rur2words(573000000000000.00), "пятьсот семьдесят три триллиона рублей 00 копеек"; };
	it "574000000000000.00" => sub { is rur2words(574000000000000.00), "пятьсот семьдесят четыре триллиона рублей 00 копеек"; };
	it "575000000000000.00" => sub { is rur2words(575000000000000.00), "пятьсот семьдесят пять триллионов рублей 00 копеек"; };
	it "576000000000000.00" => sub { is rur2words(576000000000000.00), "пятьсот семьдесят шесть триллионов рублей 00 копеек"; };
	it "577000000000000.00" => sub { is rur2words(577000000000000.00), "пятьсот семьдесят семь триллионов рублей 00 копеек"; };
	it "578000000000000.00" => sub { is rur2words(578000000000000.00), "пятьсот семьдесят восемь триллионов рублей 00 копеек"; };
	it "579000000000000.00" => sub { is rur2words(579000000000000.00), "пятьсот семьдесят девять триллионов рублей 00 копеек"; };
	it "580000000000000.00" => sub { is rur2words(580000000000000.00), "пятьсот восемьдесят триллионов рублей 00 копеек"; };
	it "581000000000000.00" => sub { is rur2words(581000000000000.00), "пятьсот восемьдесят один триллион рублей 00 копеек"; };
	it "582000000000000.00" => sub { is rur2words(582000000000000.00), "пятьсот восемьдесят два триллиона рублей 00 копеек"; };
	it "583000000000000.00" => sub { is rur2words(583000000000000.00), "пятьсот восемьдесят три триллиона рублей 00 копеек"; };
	it "584000000000000.00" => sub { is rur2words(584000000000000.00), "пятьсот восемьдесят четыре триллиона рублей 00 копеек"; };
	it "585000000000000.00" => sub { is rur2words(585000000000000.00), "пятьсот восемьдесят пять триллионов рублей 00 копеек"; };
	it "586000000000000.00" => sub { is rur2words(586000000000000.00), "пятьсот восемьдесят шесть триллионов рублей 00 копеек"; };
	it "587000000000000.00" => sub { is rur2words(587000000000000.00), "пятьсот восемьдесят семь триллионов рублей 00 копеек"; };
	it "588000000000000.00" => sub { is rur2words(588000000000000.00), "пятьсот восемьдесят восемь триллионов рублей 00 копеек"; };
	it "589000000000000.00" => sub { is rur2words(589000000000000.00), "пятьсот восемьдесят девять триллионов рублей 00 копеек"; };
	it "590000000000000.00" => sub { is rur2words(590000000000000.00), "пятьсот девяносто триллионов рублей 00 копеек"; };
	it "591000000000000.00" => sub { is rur2words(591000000000000.00), "пятьсот девяносто один триллион рублей 00 копеек"; };
	it "592000000000000.00" => sub { is rur2words(592000000000000.00), "пятьсот девяносто два триллиона рублей 00 копеек"; };
	it "593000000000000.00" => sub { is rur2words(593000000000000.00), "пятьсот девяносто три триллиона рублей 00 копеек"; };
	it "594000000000000.00" => sub { is rur2words(594000000000000.00), "пятьсот девяносто четыре триллиона рублей 00 копеек"; };
	it "595000000000000.00" => sub { is rur2words(595000000000000.00), "пятьсот девяносто пять триллионов рублей 00 копеек"; };
	it "596000000000000.00" => sub { is rur2words(596000000000000.00), "пятьсот девяносто шесть триллионов рублей 00 копеек"; };
	it "597000000000000.00" => sub { is rur2words(597000000000000.00), "пятьсот девяносто семь триллионов рублей 00 копеек"; };
	it "598000000000000.00" => sub { is rur2words(598000000000000.00), "пятьсот девяносто восемь триллионов рублей 00 копеек"; };
	it "599000000000000.00" => sub { is rur2words(599000000000000.00), "пятьсот девяносто девять триллионов рублей 00 копеек"; };
	it "600000000000000.00" => sub { is rur2words(600000000000000.00), "шестьсот триллионов рублей 00 копеек"; };
	it "601000000000000.00" => sub { is rur2words(601000000000000.00), "шестьсот один триллион рублей 00 копеек"; };
	it "602000000000000.00" => sub { is rur2words(602000000000000.00), "шестьсот два триллиона рублей 00 копеек"; };
	it "603000000000000.00" => sub { is rur2words(603000000000000.00), "шестьсот три триллиона рублей 00 копеек"; };
	it "604000000000000.00" => sub { is rur2words(604000000000000.00), "шестьсот четыре триллиона рублей 00 копеек"; };
	it "605000000000000.00" => sub { is rur2words(605000000000000.00), "шестьсот пять триллионов рублей 00 копеек"; };
	it "606000000000000.00" => sub { is rur2words(606000000000000.00), "шестьсот шесть триллионов рублей 00 копеек"; };
	it "607000000000000.00" => sub { is rur2words(607000000000000.00), "шестьсот семь триллионов рублей 00 копеек"; };
	it "608000000000000.00" => sub { is rur2words(608000000000000.00), "шестьсот восемь триллионов рублей 00 копеек"; };
	it "609000000000000.00" => sub { is rur2words(609000000000000.00), "шестьсот девять триллионов рублей 00 копеек"; };
	it "610000000000000.00" => sub { is rur2words(610000000000000.00), "шестьсот десять триллионов рублей 00 копеек"; };
	it "611000000000000.00" => sub { is rur2words(611000000000000.00), "шестьсот одиннадцать триллионов рублей 00 копеек"; };
	it "612000000000000.00" => sub { is rur2words(612000000000000.00), "шестьсот двенадцать триллионов рублей 00 копеек"; };
	it "613000000000000.00" => sub { is rur2words(613000000000000.00), "шестьсот тринадцать триллионов рублей 00 копеек"; };
	it "614000000000000.00" => sub { is rur2words(614000000000000.00), "шестьсот четырнадцать триллионов рублей 00 копеек"; };
	it "615000000000000.00" => sub { is rur2words(615000000000000.00), "шестьсот пятнадцать триллионов рублей 00 копеек"; };
	it "616000000000000.00" => sub { is rur2words(616000000000000.00), "шестьсот шестнадцать триллионов рублей 00 копеек"; };
	it "617000000000000.00" => sub { is rur2words(617000000000000.00), "шестьсот семнадцать триллионов рублей 00 копеек"; };
	it "618000000000000.00" => sub { is rur2words(618000000000000.00), "шестьсот восемнадцать триллионов рублей 00 копеек"; };
	it "619000000000000.00" => sub { is rur2words(619000000000000.00), "шестьсот девятнадцать триллионов рублей 00 копеек"; };
	it "620000000000000.00" => sub { is rur2words(620000000000000.00), "шестьсот двадцать триллионов рублей 00 копеек"; };
	it "621000000000000.00" => sub { is rur2words(621000000000000.00), "шестьсот двадцать один триллион рублей 00 копеек"; };
	it "622000000000000.00" => sub { is rur2words(622000000000000.00), "шестьсот двадцать два триллиона рублей 00 копеек"; };
	it "623000000000000.00" => sub { is rur2words(623000000000000.00), "шестьсот двадцать три триллиона рублей 00 копеек"; };
	it "624000000000000.00" => sub { is rur2words(624000000000000.00), "шестьсот двадцать четыре триллиона рублей 00 копеек"; };
	it "625000000000000.00" => sub { is rur2words(625000000000000.00), "шестьсот двадцать пять триллионов рублей 00 копеек"; };
	it "626000000000000.00" => sub { is rur2words(626000000000000.00), "шестьсот двадцать шесть триллионов рублей 00 копеек"; };
	it "627000000000000.00" => sub { is rur2words(627000000000000.00), "шестьсот двадцать семь триллионов рублей 00 копеек"; };
	it "628000000000000.00" => sub { is rur2words(628000000000000.00), "шестьсот двадцать восемь триллионов рублей 00 копеек"; };
	it "629000000000000.00" => sub { is rur2words(629000000000000.00), "шестьсот двадцать девять триллионов рублей 00 копеек"; };
	it "630000000000000.00" => sub { is rur2words(630000000000000.00), "шестьсот тридцать триллионов рублей 00 копеек"; };
	it "631000000000000.00" => sub { is rur2words(631000000000000.00), "шестьсот тридцать один триллион рублей 00 копеек"; };
	it "632000000000000.00" => sub { is rur2words(632000000000000.00), "шестьсот тридцать два триллиона рублей 00 копеек"; };
	it "633000000000000.00" => sub { is rur2words(633000000000000.00), "шестьсот тридцать три триллиона рублей 00 копеек"; };
	it "634000000000000.00" => sub { is rur2words(634000000000000.00), "шестьсот тридцать четыре триллиона рублей 00 копеек"; };
	it "635000000000000.00" => sub { is rur2words(635000000000000.00), "шестьсот тридцать пять триллионов рублей 00 копеек"; };
	it "636000000000000.00" => sub { is rur2words(636000000000000.00), "шестьсот тридцать шесть триллионов рублей 00 копеек"; };
	it "637000000000000.00" => sub { is rur2words(637000000000000.00), "шестьсот тридцать семь триллионов рублей 00 копеек"; };
	it "638000000000000.00" => sub { is rur2words(638000000000000.00), "шестьсот тридцать восемь триллионов рублей 00 копеек"; };
	it "639000000000000.00" => sub { is rur2words(639000000000000.00), "шестьсот тридцать девять триллионов рублей 00 копеек"; };
	it "640000000000000.00" => sub { is rur2words(640000000000000.00), "шестьсот сорок триллионов рублей 00 копеек"; };
	it "641000000000000.00" => sub { is rur2words(641000000000000.00), "шестьсот сорок один триллион рублей 00 копеек"; };
	it "642000000000000.00" => sub { is rur2words(642000000000000.00), "шестьсот сорок два триллиона рублей 00 копеек"; };
	it "643000000000000.00" => sub { is rur2words(643000000000000.00), "шестьсот сорок три триллиона рублей 00 копеек"; };
	it "644000000000000.00" => sub { is rur2words(644000000000000.00), "шестьсот сорок четыре триллиона рублей 00 копеек"; };
	it "645000000000000.00" => sub { is rur2words(645000000000000.00), "шестьсот сорок пять триллионов рублей 00 копеек"; };
	it "646000000000000.00" => sub { is rur2words(646000000000000.00), "шестьсот сорок шесть триллионов рублей 00 копеек"; };
	it "647000000000000.00" => sub { is rur2words(647000000000000.00), "шестьсот сорок семь триллионов рублей 00 копеек"; };
	it "648000000000000.00" => sub { is rur2words(648000000000000.00), "шестьсот сорок восемь триллионов рублей 00 копеек"; };
	it "649000000000000.00" => sub { is rur2words(649000000000000.00), "шестьсот сорок девять триллионов рублей 00 копеек"; };
	it "650000000000000.00" => sub { is rur2words(650000000000000.00), "шестьсот пятьдесят триллионов рублей 00 копеек"; };
	it "651000000000000.00" => sub { is rur2words(651000000000000.00), "шестьсот пятьдесят один триллион рублей 00 копеек"; };
	it "652000000000000.00" => sub { is rur2words(652000000000000.00), "шестьсот пятьдесят два триллиона рублей 00 копеек"; };
	it "653000000000000.00" => sub { is rur2words(653000000000000.00), "шестьсот пятьдесят три триллиона рублей 00 копеек"; };
	it "654000000000000.00" => sub { is rur2words(654000000000000.00), "шестьсот пятьдесят четыре триллиона рублей 00 копеек"; };
	it "655000000000000.00" => sub { is rur2words(655000000000000.00), "шестьсот пятьдесят пять триллионов рублей 00 копеек"; };
	it "656000000000000.00" => sub { is rur2words(656000000000000.00), "шестьсот пятьдесят шесть триллионов рублей 00 копеек"; };
	it "657000000000000.00" => sub { is rur2words(657000000000000.00), "шестьсот пятьдесят семь триллионов рублей 00 копеек"; };
	it "658000000000000.00" => sub { is rur2words(658000000000000.00), "шестьсот пятьдесят восемь триллионов рублей 00 копеек"; };
	it "659000000000000.00" => sub { is rur2words(659000000000000.00), "шестьсот пятьдесят девять триллионов рублей 00 копеек"; };
	it "660000000000000.00" => sub { is rur2words(660000000000000.00), "шестьсот шестьдесят триллионов рублей 00 копеек"; };
	it "661000000000000.00" => sub { is rur2words(661000000000000.00), "шестьсот шестьдесят один триллион рублей 00 копеек"; };
	it "662000000000000.00" => sub { is rur2words(662000000000000.00), "шестьсот шестьдесят два триллиона рублей 00 копеек"; };
	it "663000000000000.00" => sub { is rur2words(663000000000000.00), "шестьсот шестьдесят три триллиона рублей 00 копеек"; };
	it "664000000000000.00" => sub { is rur2words(664000000000000.00), "шестьсот шестьдесят четыре триллиона рублей 00 копеек"; };
	it "665000000000000.00" => sub { is rur2words(665000000000000.00), "шестьсот шестьдесят пять триллионов рублей 00 копеек"; };
	it "666000000000000.00" => sub { is rur2words(666000000000000.00), "шестьсот шестьдесят шесть триллионов рублей 00 копеек"; };
	it "667000000000000.00" => sub { is rur2words(667000000000000.00), "шестьсот шестьдесят семь триллионов рублей 00 копеек"; };
	it "668000000000000.00" => sub { is rur2words(668000000000000.00), "шестьсот шестьдесят восемь триллионов рублей 00 копеек"; };
	it "669000000000000.00" => sub { is rur2words(669000000000000.00), "шестьсот шестьдесят девять триллионов рублей 00 копеек"; };
	it "670000000000000.00" => sub { is rur2words(670000000000000.00), "шестьсот семьдесят триллионов рублей 00 копеек"; };
	it "671000000000000.00" => sub { is rur2words(671000000000000.00), "шестьсот семьдесят один триллион рублей 00 копеек"; };
	it "672000000000000.00" => sub { is rur2words(672000000000000.00), "шестьсот семьдесят два триллиона рублей 00 копеек"; };
	it "673000000000000.00" => sub { is rur2words(673000000000000.00), "шестьсот семьдесят три триллиона рублей 00 копеек"; };
	it "674000000000000.00" => sub { is rur2words(674000000000000.00), "шестьсот семьдесят четыре триллиона рублей 00 копеек"; };
	it "675000000000000.00" => sub { is rur2words(675000000000000.00), "шестьсот семьдесят пять триллионов рублей 00 копеек"; };
	it "676000000000000.00" => sub { is rur2words(676000000000000.00), "шестьсот семьдесят шесть триллионов рублей 00 копеек"; };
	it "677000000000000.00" => sub { is rur2words(677000000000000.00), "шестьсот семьдесят семь триллионов рублей 00 копеек"; };
	it "678000000000000.00" => sub { is rur2words(678000000000000.00), "шестьсот семьдесят восемь триллионов рублей 00 копеек"; };
	it "679000000000000.00" => sub { is rur2words(679000000000000.00), "шестьсот семьдесят девять триллионов рублей 00 копеек"; };
	it "680000000000000.00" => sub { is rur2words(680000000000000.00), "шестьсот восемьдесят триллионов рублей 00 копеек"; };
	it "681000000000000.00" => sub { is rur2words(681000000000000.00), "шестьсот восемьдесят один триллион рублей 00 копеек"; };
	it "682000000000000.00" => sub { is rur2words(682000000000000.00), "шестьсот восемьдесят два триллиона рублей 00 копеек"; };
	it "683000000000000.00" => sub { is rur2words(683000000000000.00), "шестьсот восемьдесят три триллиона рублей 00 копеек"; };
	it "684000000000000.00" => sub { is rur2words(684000000000000.00), "шестьсот восемьдесят четыре триллиона рублей 00 копеек"; };
	it "685000000000000.00" => sub { is rur2words(685000000000000.00), "шестьсот восемьдесят пять триллионов рублей 00 копеек"; };
	it "686000000000000.00" => sub { is rur2words(686000000000000.00), "шестьсот восемьдесят шесть триллионов рублей 00 копеек"; };
	it "687000000000000.00" => sub { is rur2words(687000000000000.00), "шестьсот восемьдесят семь триллионов рублей 00 копеек"; };
	it "688000000000000.00" => sub { is rur2words(688000000000000.00), "шестьсот восемьдесят восемь триллионов рублей 00 копеек"; };
	it "689000000000000.00" => sub { is rur2words(689000000000000.00), "шестьсот восемьдесят девять триллионов рублей 00 копеек"; };
	it "690000000000000.00" => sub { is rur2words(690000000000000.00), "шестьсот девяносто триллионов рублей 00 копеек"; };
	it "691000000000000.00" => sub { is rur2words(691000000000000.00), "шестьсот девяносто один триллион рублей 00 копеек"; };
	it "692000000000000.00" => sub { is rur2words(692000000000000.00), "шестьсот девяносто два триллиона рублей 00 копеек"; };
	it "693000000000000.00" => sub { is rur2words(693000000000000.00), "шестьсот девяносто три триллиона рублей 00 копеек"; };
	it "694000000000000.00" => sub { is rur2words(694000000000000.00), "шестьсот девяносто четыре триллиона рублей 00 копеек"; };
	it "695000000000000.00" => sub { is rur2words(695000000000000.00), "шестьсот девяносто пять триллионов рублей 00 копеек"; };
	it "696000000000000.00" => sub { is rur2words(696000000000000.00), "шестьсот девяносто шесть триллионов рублей 00 копеек"; };
	it "697000000000000.00" => sub { is rur2words(697000000000000.00), "шестьсот девяносто семь триллионов рублей 00 копеек"; };
	it "698000000000000.00" => sub { is rur2words(698000000000000.00), "шестьсот девяносто восемь триллионов рублей 00 копеек"; };
	it "699000000000000.00" => sub { is rur2words(699000000000000.00), "шестьсот девяносто девять триллионов рублей 00 копеек"; };
	it "700000000000000.00" => sub { is rur2words(700000000000000.00), "семьсот триллионов рублей 00 копеек"; };
	it "701000000000000.00" => sub { is rur2words(701000000000000.00), "семьсот один триллион рублей 00 копеек"; };
	it "702000000000000.00" => sub { is rur2words(702000000000000.00), "семьсот два триллиона рублей 00 копеек"; };
	it "703000000000000.00" => sub { is rur2words(703000000000000.00), "семьсот три триллиона рублей 00 копеек"; };
	it "704000000000000.00" => sub { is rur2words(704000000000000.00), "семьсот четыре триллиона рублей 00 копеек"; };
	it "705000000000000.00" => sub { is rur2words(705000000000000.00), "семьсот пять триллионов рублей 00 копеек"; };
	it "706000000000000.00" => sub { is rur2words(706000000000000.00), "семьсот шесть триллионов рублей 00 копеек"; };
	it "707000000000000.00" => sub { is rur2words(707000000000000.00), "семьсот семь триллионов рублей 00 копеек"; };
	it "708000000000000.00" => sub { is rur2words(708000000000000.00), "семьсот восемь триллионов рублей 00 копеек"; };
	it "709000000000000.00" => sub { is rur2words(709000000000000.00), "семьсот девять триллионов рублей 00 копеек"; };
	it "710000000000000.00" => sub { is rur2words(710000000000000.00), "семьсот десять триллионов рублей 00 копеек"; };
	it "711000000000000.00" => sub { is rur2words(711000000000000.00), "семьсот одиннадцать триллионов рублей 00 копеек"; };
	it "712000000000000.00" => sub { is rur2words(712000000000000.00), "семьсот двенадцать триллионов рублей 00 копеек"; };
	it "713000000000000.00" => sub { is rur2words(713000000000000.00), "семьсот тринадцать триллионов рублей 00 копеек"; };
	it "714000000000000.00" => sub { is rur2words(714000000000000.00), "семьсот четырнадцать триллионов рублей 00 копеек"; };
	it "715000000000000.00" => sub { is rur2words(715000000000000.00), "семьсот пятнадцать триллионов рублей 00 копеек"; };
	it "716000000000000.00" => sub { is rur2words(716000000000000.00), "семьсот шестнадцать триллионов рублей 00 копеек"; };
	it "717000000000000.00" => sub { is rur2words(717000000000000.00), "семьсот семнадцать триллионов рублей 00 копеек"; };
	it "718000000000000.00" => sub { is rur2words(718000000000000.00), "семьсот восемнадцать триллионов рублей 00 копеек"; };
	it "719000000000000.00" => sub { is rur2words(719000000000000.00), "семьсот девятнадцать триллионов рублей 00 копеек"; };
	it "720000000000000.00" => sub { is rur2words(720000000000000.00), "семьсот двадцать триллионов рублей 00 копеек"; };
	it "721000000000000.00" => sub { is rur2words(721000000000000.00), "семьсот двадцать один триллион рублей 00 копеек"; };
	it "722000000000000.00" => sub { is rur2words(722000000000000.00), "семьсот двадцать два триллиона рублей 00 копеек"; };
	it "723000000000000.00" => sub { is rur2words(723000000000000.00), "семьсот двадцать три триллиона рублей 00 копеек"; };
	it "724000000000000.00" => sub { is rur2words(724000000000000.00), "семьсот двадцать четыре триллиона рублей 00 копеек"; };
	it "725000000000000.00" => sub { is rur2words(725000000000000.00), "семьсот двадцать пять триллионов рублей 00 копеек"; };
	it "726000000000000.00" => sub { is rur2words(726000000000000.00), "семьсот двадцать шесть триллионов рублей 00 копеек"; };
	it "727000000000000.00" => sub { is rur2words(727000000000000.00), "семьсот двадцать семь триллионов рублей 00 копеек"; };
	it "728000000000000.00" => sub { is rur2words(728000000000000.00), "семьсот двадцать восемь триллионов рублей 00 копеек"; };
	it "729000000000000.00" => sub { is rur2words(729000000000000.00), "семьсот двадцать девять триллионов рублей 00 копеек"; };
	it "730000000000000.00" => sub { is rur2words(730000000000000.00), "семьсот тридцать триллионов рублей 00 копеек"; };
	it "731000000000000.00" => sub { is rur2words(731000000000000.00), "семьсот тридцать один триллион рублей 00 копеек"; };
	it "732000000000000.00" => sub { is rur2words(732000000000000.00), "семьсот тридцать два триллиона рублей 00 копеек"; };
	it "733000000000000.00" => sub { is rur2words(733000000000000.00), "семьсот тридцать три триллиона рублей 00 копеек"; };
	it "734000000000000.00" => sub { is rur2words(734000000000000.00), "семьсот тридцать четыре триллиона рублей 00 копеек"; };
	it "735000000000000.00" => sub { is rur2words(735000000000000.00), "семьсот тридцать пять триллионов рублей 00 копеек"; };
	it "736000000000000.00" => sub { is rur2words(736000000000000.00), "семьсот тридцать шесть триллионов рублей 00 копеек"; };
	it "737000000000000.00" => sub { is rur2words(737000000000000.00), "семьсот тридцать семь триллионов рублей 00 копеек"; };
	it "738000000000000.00" => sub { is rur2words(738000000000000.00), "семьсот тридцать восемь триллионов рублей 00 копеек"; };
	it "739000000000000.00" => sub { is rur2words(739000000000000.00), "семьсот тридцать девять триллионов рублей 00 копеек"; };
	it "740000000000000.00" => sub { is rur2words(740000000000000.00), "семьсот сорок триллионов рублей 00 копеек"; };
	it "741000000000000.00" => sub { is rur2words(741000000000000.00), "семьсот сорок один триллион рублей 00 копеек"; };
	it "742000000000000.00" => sub { is rur2words(742000000000000.00), "семьсот сорок два триллиона рублей 00 копеек"; };
	it "743000000000000.00" => sub { is rur2words(743000000000000.00), "семьсот сорок три триллиона рублей 00 копеек"; };
	it "744000000000000.00" => sub { is rur2words(744000000000000.00), "семьсот сорок четыре триллиона рублей 00 копеек"; };
	it "745000000000000.00" => sub { is rur2words(745000000000000.00), "семьсот сорок пять триллионов рублей 00 копеек"; };
	it "746000000000000.00" => sub { is rur2words(746000000000000.00), "семьсот сорок шесть триллионов рублей 00 копеек"; };
	it "747000000000000.00" => sub { is rur2words(747000000000000.00), "семьсот сорок семь триллионов рублей 00 копеек"; };
	it "748000000000000.00" => sub { is rur2words(748000000000000.00), "семьсот сорок восемь триллионов рублей 00 копеек"; };
	it "749000000000000.00" => sub { is rur2words(749000000000000.00), "семьсот сорок девять триллионов рублей 00 копеек"; };
	it "750000000000000.00" => sub { is rur2words(750000000000000.00), "семьсот пятьдесят триллионов рублей 00 копеек"; };
	it "751000000000000.00" => sub { is rur2words(751000000000000.00), "семьсот пятьдесят один триллион рублей 00 копеек"; };
	it "752000000000000.00" => sub { is rur2words(752000000000000.00), "семьсот пятьдесят два триллиона рублей 00 копеек"; };
	it "753000000000000.00" => sub { is rur2words(753000000000000.00), "семьсот пятьдесят три триллиона рублей 00 копеек"; };
	it "754000000000000.00" => sub { is rur2words(754000000000000.00), "семьсот пятьдесят четыре триллиона рублей 00 копеек"; };
	it "755000000000000.00" => sub { is rur2words(755000000000000.00), "семьсот пятьдесят пять триллионов рублей 00 копеек"; };
	it "756000000000000.00" => sub { is rur2words(756000000000000.00), "семьсот пятьдесят шесть триллионов рублей 00 копеек"; };
	it "757000000000000.00" => sub { is rur2words(757000000000000.00), "семьсот пятьдесят семь триллионов рублей 00 копеек"; };
	it "758000000000000.00" => sub { is rur2words(758000000000000.00), "семьсот пятьдесят восемь триллионов рублей 00 копеек"; };
	it "759000000000000.00" => sub { is rur2words(759000000000000.00), "семьсот пятьдесят девять триллионов рублей 00 копеек"; };
	it "760000000000000.00" => sub { is rur2words(760000000000000.00), "семьсот шестьдесят триллионов рублей 00 копеек"; };
	it "761000000000000.00" => sub { is rur2words(761000000000000.00), "семьсот шестьдесят один триллион рублей 00 копеек"; };
	it "762000000000000.00" => sub { is rur2words(762000000000000.00), "семьсот шестьдесят два триллиона рублей 00 копеек"; };
	it "763000000000000.00" => sub { is rur2words(763000000000000.00), "семьсот шестьдесят три триллиона рублей 00 копеек"; };
	it "764000000000000.00" => sub { is rur2words(764000000000000.00), "семьсот шестьдесят четыре триллиона рублей 00 копеек"; };
	it "765000000000000.00" => sub { is rur2words(765000000000000.00), "семьсот шестьдесят пять триллионов рублей 00 копеек"; };
	it "766000000000000.00" => sub { is rur2words(766000000000000.00), "семьсот шестьдесят шесть триллионов рублей 00 копеек"; };
	it "767000000000000.00" => sub { is rur2words(767000000000000.00), "семьсот шестьдесят семь триллионов рублей 00 копеек"; };
	it "768000000000000.00" => sub { is rur2words(768000000000000.00), "семьсот шестьдесят восемь триллионов рублей 00 копеек"; };
	it "769000000000000.00" => sub { is rur2words(769000000000000.00), "семьсот шестьдесят девять триллионов рублей 00 копеек"; };
	it "770000000000000.00" => sub { is rur2words(770000000000000.00), "семьсот семьдесят триллионов рублей 00 копеек"; };
	it "771000000000000.00" => sub { is rur2words(771000000000000.00), "семьсот семьдесят один триллион рублей 00 копеек"; };
	it "772000000000000.00" => sub { is rur2words(772000000000000.00), "семьсот семьдесят два триллиона рублей 00 копеек"; };
	it "773000000000000.00" => sub { is rur2words(773000000000000.00), "семьсот семьдесят три триллиона рублей 00 копеек"; };
	it "774000000000000.00" => sub { is rur2words(774000000000000.00), "семьсот семьдесят четыре триллиона рублей 00 копеек"; };
	it "775000000000000.00" => sub { is rur2words(775000000000000.00), "семьсот семьдесят пять триллионов рублей 00 копеек"; };
	it "776000000000000.00" => sub { is rur2words(776000000000000.00), "семьсот семьдесят шесть триллионов рублей 00 копеек"; };
	it "777000000000000.00" => sub { is rur2words(777000000000000.00), "семьсот семьдесят семь триллионов рублей 00 копеек"; };
	it "778000000000000.00" => sub { is rur2words(778000000000000.00), "семьсот семьдесят восемь триллионов рублей 00 копеек"; };
	it "779000000000000.00" => sub { is rur2words(779000000000000.00), "семьсот семьдесят девять триллионов рублей 00 копеек"; };
	it "780000000000000.00" => sub { is rur2words(780000000000000.00), "семьсот восемьдесят триллионов рублей 00 копеек"; };
	it "781000000000000.00" => sub { is rur2words(781000000000000.00), "семьсот восемьдесят один триллион рублей 00 копеек"; };
	it "782000000000000.00" => sub { is rur2words(782000000000000.00), "семьсот восемьдесят два триллиона рублей 00 копеек"; };
	it "783000000000000.00" => sub { is rur2words(783000000000000.00), "семьсот восемьдесят три триллиона рублей 00 копеек"; };
	it "784000000000000.00" => sub { is rur2words(784000000000000.00), "семьсот восемьдесят четыре триллиона рублей 00 копеек"; };
	it "785000000000000.00" => sub { is rur2words(785000000000000.00), "семьсот восемьдесят пять триллионов рублей 00 копеек"; };
	it "786000000000000.00" => sub { is rur2words(786000000000000.00), "семьсот восемьдесят шесть триллионов рублей 00 копеек"; };
	it "787000000000000.00" => sub { is rur2words(787000000000000.00), "семьсот восемьдесят семь триллионов рублей 00 копеек"; };
	it "788000000000000.00" => sub { is rur2words(788000000000000.00), "семьсот восемьдесят восемь триллионов рублей 00 копеек"; };
	it "789000000000000.00" => sub { is rur2words(789000000000000.00), "семьсот восемьдесят девять триллионов рублей 00 копеек"; };
	it "790000000000000.00" => sub { is rur2words(790000000000000.00), "семьсот девяносто триллионов рублей 00 копеек"; };
	it "791000000000000.00" => sub { is rur2words(791000000000000.00), "семьсот девяносто один триллион рублей 00 копеек"; };
	it "792000000000000.00" => sub { is rur2words(792000000000000.00), "семьсот девяносто два триллиона рублей 00 копеек"; };
	it "793000000000000.00" => sub { is rur2words(793000000000000.00), "семьсот девяносто три триллиона рублей 00 копеек"; };
	it "794000000000000.00" => sub { is rur2words(794000000000000.00), "семьсот девяносто четыре триллиона рублей 00 копеек"; };
	it "795000000000000.00" => sub { is rur2words(795000000000000.00), "семьсот девяносто пять триллионов рублей 00 копеек"; };
	it "796000000000000.00" => sub { is rur2words(796000000000000.00), "семьсот девяносто шесть триллионов рублей 00 копеек"; };
	it "797000000000000.00" => sub { is rur2words(797000000000000.00), "семьсот девяносто семь триллионов рублей 00 копеек"; };
	it "798000000000000.00" => sub { is rur2words(798000000000000.00), "семьсот девяносто восемь триллионов рублей 00 копеек"; };
	it "799000000000000.00" => sub { is rur2words(799000000000000.00), "семьсот девяносто девять триллионов рублей 00 копеек"; };
	it "800000000000000.00" => sub { is rur2words(800000000000000.00), "восемьсот триллионов рублей 00 копеек"; };
	it "801000000000000.00" => sub { is rur2words(801000000000000.00), "восемьсот один триллион рублей 00 копеек"; };
	it "802000000000000.00" => sub { is rur2words(802000000000000.00), "восемьсот два триллиона рублей 00 копеек"; };
	it "803000000000000.00" => sub { is rur2words(803000000000000.00), "восемьсот три триллиона рублей 00 копеек"; };
	it "804000000000000.00" => sub { is rur2words(804000000000000.00), "восемьсот четыре триллиона рублей 00 копеек"; };
	it "805000000000000.00" => sub { is rur2words(805000000000000.00), "восемьсот пять триллионов рублей 00 копеек"; };
	it "806000000000000.00" => sub { is rur2words(806000000000000.00), "восемьсот шесть триллионов рублей 00 копеек"; };
	it "807000000000000.00" => sub { is rur2words(807000000000000.00), "восемьсот семь триллионов рублей 00 копеек"; };
	it "808000000000000.00" => sub { is rur2words(808000000000000.00), "восемьсот восемь триллионов рублей 00 копеек"; };
	it "809000000000000.00" => sub { is rur2words(809000000000000.00), "восемьсот девять триллионов рублей 00 копеек"; };
	it "810000000000000.00" => sub { is rur2words(810000000000000.00), "восемьсот десять триллионов рублей 00 копеек"; };
	it "811000000000000.00" => sub { is rur2words(811000000000000.00), "восемьсот одиннадцать триллионов рублей 00 копеек"; };
	it "812000000000000.00" => sub { is rur2words(812000000000000.00), "восемьсот двенадцать триллионов рублей 00 копеек"; };
	it "813000000000000.00" => sub { is rur2words(813000000000000.00), "восемьсот тринадцать триллионов рублей 00 копеек"; };
	it "814000000000000.00" => sub { is rur2words(814000000000000.00), "восемьсот четырнадцать триллионов рублей 00 копеек"; };
	it "815000000000000.00" => sub { is rur2words(815000000000000.00), "восемьсот пятнадцать триллионов рублей 00 копеек"; };
	it "816000000000000.00" => sub { is rur2words(816000000000000.00), "восемьсот шестнадцать триллионов рублей 00 копеек"; };
	it "817000000000000.00" => sub { is rur2words(817000000000000.00), "восемьсот семнадцать триллионов рублей 00 копеек"; };
	it "818000000000000.00" => sub { is rur2words(818000000000000.00), "восемьсот восемнадцать триллионов рублей 00 копеек"; };
	it "819000000000000.00" => sub { is rur2words(819000000000000.00), "восемьсот девятнадцать триллионов рублей 00 копеек"; };
	it "820000000000000.00" => sub { is rur2words(820000000000000.00), "восемьсот двадцать триллионов рублей 00 копеек"; };
	it "821000000000000.00" => sub { is rur2words(821000000000000.00), "восемьсот двадцать один триллион рублей 00 копеек"; };
	it "822000000000000.00" => sub { is rur2words(822000000000000.00), "восемьсот двадцать два триллиона рублей 00 копеек"; };
	it "823000000000000.00" => sub { is rur2words(823000000000000.00), "восемьсот двадцать три триллиона рублей 00 копеек"; };
	it "824000000000000.00" => sub { is rur2words(824000000000000.00), "восемьсот двадцать четыре триллиона рублей 00 копеек"; };
	it "825000000000000.00" => sub { is rur2words(825000000000000.00), "восемьсот двадцать пять триллионов рублей 00 копеек"; };
	it "826000000000000.00" => sub { is rur2words(826000000000000.00), "восемьсот двадцать шесть триллионов рублей 00 копеек"; };
	it "827000000000000.00" => sub { is rur2words(827000000000000.00), "восемьсот двадцать семь триллионов рублей 00 копеек"; };
	it "828000000000000.00" => sub { is rur2words(828000000000000.00), "восемьсот двадцать восемь триллионов рублей 00 копеек"; };
	it "829000000000000.00" => sub { is rur2words(829000000000000.00), "восемьсот двадцать девять триллионов рублей 00 копеек"; };
	it "830000000000000.00" => sub { is rur2words(830000000000000.00), "восемьсот тридцать триллионов рублей 00 копеек"; };
	it "831000000000000.00" => sub { is rur2words(831000000000000.00), "восемьсот тридцать один триллион рублей 00 копеек"; };
	it "832000000000000.00" => sub { is rur2words(832000000000000.00), "восемьсот тридцать два триллиона рублей 00 копеек"; };
	it "833000000000000.00" => sub { is rur2words(833000000000000.00), "восемьсот тридцать три триллиона рублей 00 копеек"; };
	it "834000000000000.00" => sub { is rur2words(834000000000000.00), "восемьсот тридцать четыре триллиона рублей 00 копеек"; };
	it "835000000000000.00" => sub { is rur2words(835000000000000.00), "восемьсот тридцать пять триллионов рублей 00 копеек"; };
	it "836000000000000.00" => sub { is rur2words(836000000000000.00), "восемьсот тридцать шесть триллионов рублей 00 копеек"; };
	it "837000000000000.00" => sub { is rur2words(837000000000000.00), "восемьсот тридцать семь триллионов рублей 00 копеек"; };
	it "838000000000000.00" => sub { is rur2words(838000000000000.00), "восемьсот тридцать восемь триллионов рублей 00 копеек"; };
	it "839000000000000.00" => sub { is rur2words(839000000000000.00), "восемьсот тридцать девять триллионов рублей 00 копеек"; };
	it "840000000000000.00" => sub { is rur2words(840000000000000.00), "восемьсот сорок триллионов рублей 00 копеек"; };
	it "841000000000000.00" => sub { is rur2words(841000000000000.00), "восемьсот сорок один триллион рублей 00 копеек"; };
	it "842000000000000.00" => sub { is rur2words(842000000000000.00), "восемьсот сорок два триллиона рублей 00 копеек"; };
	it "843000000000000.00" => sub { is rur2words(843000000000000.00), "восемьсот сорок три триллиона рублей 00 копеек"; };
	it "844000000000000.00" => sub { is rur2words(844000000000000.00), "восемьсот сорок четыре триллиона рублей 00 копеек"; };
	it "845000000000000.00" => sub { is rur2words(845000000000000.00), "восемьсот сорок пять триллионов рублей 00 копеек"; };
	it "846000000000000.00" => sub { is rur2words(846000000000000.00), "восемьсот сорок шесть триллионов рублей 00 копеек"; };
	it "847000000000000.00" => sub { is rur2words(847000000000000.00), "восемьсот сорок семь триллионов рублей 00 копеек"; };
	it "848000000000000.00" => sub { is rur2words(848000000000000.00), "восемьсот сорок восемь триллионов рублей 00 копеек"; };
	it "849000000000000.00" => sub { is rur2words(849000000000000.00), "восемьсот сорок девять триллионов рублей 00 копеек"; };
	it "850000000000000.00" => sub { is rur2words(850000000000000.00), "восемьсот пятьдесят триллионов рублей 00 копеек"; };
	it "851000000000000.00" => sub { is rur2words(851000000000000.00), "восемьсот пятьдесят один триллион рублей 00 копеек"; };
	it "852000000000000.00" => sub { is rur2words(852000000000000.00), "восемьсот пятьдесят два триллиона рублей 00 копеек"; };
	it "853000000000000.00" => sub { is rur2words(853000000000000.00), "восемьсот пятьдесят три триллиона рублей 00 копеек"; };
	it "854000000000000.00" => sub { is rur2words(854000000000000.00), "восемьсот пятьдесят четыре триллиона рублей 00 копеек"; };
	it "855000000000000.00" => sub { is rur2words(855000000000000.00), "восемьсот пятьдесят пять триллионов рублей 00 копеек"; };
	it "856000000000000.00" => sub { is rur2words(856000000000000.00), "восемьсот пятьдесят шесть триллионов рублей 00 копеек"; };
	it "857000000000000.00" => sub { is rur2words(857000000000000.00), "восемьсот пятьдесят семь триллионов рублей 00 копеек"; };
	it "858000000000000.00" => sub { is rur2words(858000000000000.00), "восемьсот пятьдесят восемь триллионов рублей 00 копеек"; };
	it "859000000000000.00" => sub { is rur2words(859000000000000.00), "восемьсот пятьдесят девять триллионов рублей 00 копеек"; };
	it "860000000000000.00" => sub { is rur2words(860000000000000.00), "восемьсот шестьдесят триллионов рублей 00 копеек"; };
	it "861000000000000.00" => sub { is rur2words(861000000000000.00), "восемьсот шестьдесят один триллион рублей 00 копеек"; };
	it "862000000000000.00" => sub { is rur2words(862000000000000.00), "восемьсот шестьдесят два триллиона рублей 00 копеек"; };
	it "863000000000000.00" => sub { is rur2words(863000000000000.00), "восемьсот шестьдесят три триллиона рублей 00 копеек"; };
	it "864000000000000.00" => sub { is rur2words(864000000000000.00), "восемьсот шестьдесят четыре триллиона рублей 00 копеек"; };
	it "865000000000000.00" => sub { is rur2words(865000000000000.00), "восемьсот шестьдесят пять триллионов рублей 00 копеек"; };
	it "866000000000000.00" => sub { is rur2words(866000000000000.00), "восемьсот шестьдесят шесть триллионов рублей 00 копеек"; };
	it "867000000000000.00" => sub { is rur2words(867000000000000.00), "восемьсот шестьдесят семь триллионов рублей 00 копеек"; };
	it "868000000000000.00" => sub { is rur2words(868000000000000.00), "восемьсот шестьдесят восемь триллионов рублей 00 копеек"; };
	it "869000000000000.00" => sub { is rur2words(869000000000000.00), "восемьсот шестьдесят девять триллионов рублей 00 копеек"; };
	it "870000000000000.00" => sub { is rur2words(870000000000000.00), "восемьсот семьдесят триллионов рублей 00 копеек"; };
	it "871000000000000.00" => sub { is rur2words(871000000000000.00), "восемьсот семьдесят один триллион рублей 00 копеек"; };
	it "872000000000000.00" => sub { is rur2words(872000000000000.00), "восемьсот семьдесят два триллиона рублей 00 копеек"; };
	it "873000000000000.00" => sub { is rur2words(873000000000000.00), "восемьсот семьдесят три триллиона рублей 00 копеек"; };
	it "874000000000000.00" => sub { is rur2words(874000000000000.00), "восемьсот семьдесят четыре триллиона рублей 00 копеек"; };
	it "875000000000000.00" => sub { is rur2words(875000000000000.00), "восемьсот семьдесят пять триллионов рублей 00 копеек"; };
	it "876000000000000.00" => sub { is rur2words(876000000000000.00), "восемьсот семьдесят шесть триллионов рублей 00 копеек"; };
	it "877000000000000.00" => sub { is rur2words(877000000000000.00), "восемьсот семьдесят семь триллионов рублей 00 копеек"; };
	it "878000000000000.00" => sub { is rur2words(878000000000000.00), "восемьсот семьдесят восемь триллионов рублей 00 копеек"; };
	it "879000000000000.00" => sub { is rur2words(879000000000000.00), "восемьсот семьдесят девять триллионов рублей 00 копеек"; };
	it "880000000000000.00" => sub { is rur2words(880000000000000.00), "восемьсот восемьдесят триллионов рублей 00 копеек"; };
	it "881000000000000.00" => sub { is rur2words(881000000000000.00), "восемьсот восемьдесят один триллион рублей 00 копеек"; };
	it "882000000000000.00" => sub { is rur2words(882000000000000.00), "восемьсот восемьдесят два триллиона рублей 00 копеек"; };
	it "883000000000000.00" => sub { is rur2words(883000000000000.00), "восемьсот восемьдесят три триллиона рублей 00 копеек"; };
	it "884000000000000.00" => sub { is rur2words(884000000000000.00), "восемьсот восемьдесят четыре триллиона рублей 00 копеек"; };
	it "885000000000000.00" => sub { is rur2words(885000000000000.00), "восемьсот восемьдесят пять триллионов рублей 00 копеек"; };
	it "886000000000000.00" => sub { is rur2words(886000000000000.00), "восемьсот восемьдесят шесть триллионов рублей 00 копеек"; };
	it "887000000000000.00" => sub { is rur2words(887000000000000.00), "восемьсот восемьдесят семь триллионов рублей 00 копеек"; };
	it "888000000000000.00" => sub { is rur2words(888000000000000.00), "восемьсот восемьдесят восемь триллионов рублей 00 копеек"; };
	it "889000000000000.00" => sub { is rur2words(889000000000000.00), "восемьсот восемьдесят девять триллионов рублей 00 копеек"; };
	it "890000000000000.00" => sub { is rur2words(890000000000000.00), "восемьсот девяносто триллионов рублей 00 копеек"; };
	it "891000000000000.00" => sub { is rur2words(891000000000000.00), "восемьсот девяносто один триллион рублей 00 копеек"; };
	it "892000000000000.00" => sub { is rur2words(892000000000000.00), "восемьсот девяносто два триллиона рублей 00 копеек"; };
	it "893000000000000.00" => sub { is rur2words(893000000000000.00), "восемьсот девяносто три триллиона рублей 00 копеек"; };
	it "894000000000000.00" => sub { is rur2words(894000000000000.00), "восемьсот девяносто четыре триллиона рублей 00 копеек"; };
	it "895000000000000.00" => sub { is rur2words(895000000000000.00), "восемьсот девяносто пять триллионов рублей 00 копеек"; };
	it "896000000000000.00" => sub { is rur2words(896000000000000.00), "восемьсот девяносто шесть триллионов рублей 00 копеек"; };
	it "897000000000000.00" => sub { is rur2words(897000000000000.00), "восемьсот девяносто семь триллионов рублей 00 копеек"; };
	it "898000000000000.00" => sub { is rur2words(898000000000000.00), "восемьсот девяносто восемь триллионов рублей 00 копеек"; };
	it "899000000000000.00" => sub { is rur2words(899000000000000.00), "восемьсот девяносто девять триллионов рублей 00 копеек"; };
	it "900000000000000.00" => sub { is rur2words(900000000000000.00), "девятьсот триллионов рублей 00 копеек"; };
	it "901000000000000.00" => sub { is rur2words(901000000000000.00), "девятьсот один триллион рублей 00 копеек"; };
	it "902000000000000.00" => sub { is rur2words(902000000000000.00), "девятьсот два триллиона рублей 00 копеек"; };
	it "903000000000000.00" => sub { is rur2words(903000000000000.00), "девятьсот три триллиона рублей 00 копеек"; };
	it "904000000000000.00" => sub { is rur2words(904000000000000.00), "девятьсот четыре триллиона рублей 00 копеек"; };
	it "905000000000000.00" => sub { is rur2words(905000000000000.00), "девятьсот пять триллионов рублей 00 копеек"; };
	it "906000000000000.00" => sub { is rur2words(906000000000000.00), "девятьсот шесть триллионов рублей 00 копеек"; };
	it "907000000000000.00" => sub { is rur2words(907000000000000.00), "девятьсот семь триллионов рублей 00 копеек"; };
	it "908000000000000.00" => sub { is rur2words(908000000000000.00), "девятьсот восемь триллионов рублей 00 копеек"; };
	it "909000000000000.00" => sub { is rur2words(909000000000000.00), "девятьсот девять триллионов рублей 00 копеек"; };
	it "910000000000000.00" => sub { is rur2words(910000000000000.00), "девятьсот десять триллионов рублей 00 копеек"; };
	it "911000000000000.00" => sub { is rur2words(911000000000000.00), "девятьсот одиннадцать триллионов рублей 00 копеек"; };
	it "912000000000000.00" => sub { is rur2words(912000000000000.00), "девятьсот двенадцать триллионов рублей 00 копеек"; };
	it "913000000000000.00" => sub { is rur2words(913000000000000.00), "девятьсот тринадцать триллионов рублей 00 копеек"; };
	it "914000000000000.00" => sub { is rur2words(914000000000000.00), "девятьсот четырнадцать триллионов рублей 00 копеек"; };
	it "915000000000000.00" => sub { is rur2words(915000000000000.00), "девятьсот пятнадцать триллионов рублей 00 копеек"; };
	it "916000000000000.00" => sub { is rur2words(916000000000000.00), "девятьсот шестнадцать триллионов рублей 00 копеек"; };
	it "917000000000000.00" => sub { is rur2words(917000000000000.00), "девятьсот семнадцать триллионов рублей 00 копеек"; };
	it "918000000000000.00" => sub { is rur2words(918000000000000.00), "девятьсот восемнадцать триллионов рублей 00 копеек"; };
	it "919000000000000.00" => sub { is rur2words(919000000000000.00), "девятьсот девятнадцать триллионов рублей 00 копеек"; };
	it "920000000000000.00" => sub { is rur2words(920000000000000.00), "девятьсот двадцать триллионов рублей 00 копеек"; };
	it "921000000000000.00" => sub { is rur2words(921000000000000.00), "девятьсот двадцать один триллион рублей 00 копеек"; };
	it "922000000000000.00" => sub { is rur2words(922000000000000.00), "девятьсот двадцать два триллиона рублей 00 копеек"; };
	it "923000000000000.00" => sub { is rur2words(923000000000000.00), "девятьсот двадцать три триллиона рублей 00 копеек"; };
	it "924000000000000.00" => sub { is rur2words(924000000000000.00), "девятьсот двадцать четыре триллиона рублей 00 копеек"; };
	it "925000000000000.00" => sub { is rur2words(925000000000000.00), "девятьсот двадцать пять триллионов рублей 00 копеек"; };
	it "926000000000000.00" => sub { is rur2words(926000000000000.00), "девятьсот двадцать шесть триллионов рублей 00 копеек"; };
	it "927000000000000.00" => sub { is rur2words(927000000000000.00), "девятьсот двадцать семь триллионов рублей 00 копеек"; };
	it "928000000000000.00" => sub { is rur2words(928000000000000.00), "девятьсот двадцать восемь триллионов рублей 00 копеек"; };
	it "929000000000000.00" => sub { is rur2words(929000000000000.00), "девятьсот двадцать девять триллионов рублей 00 копеек"; };
	it "930000000000000.00" => sub { is rur2words(930000000000000.00), "девятьсот тридцать триллионов рублей 00 копеек"; };
	it "931000000000000.00" => sub { is rur2words(931000000000000.00), "девятьсот тридцать один триллион рублей 00 копеек"; };
	it "932000000000000.00" => sub { is rur2words(932000000000000.00), "девятьсот тридцать два триллиона рублей 00 копеек"; };
	it "933000000000000.00" => sub { is rur2words(933000000000000.00), "девятьсот тридцать три триллиона рублей 00 копеек"; };
	it "934000000000000.00" => sub { is rur2words(934000000000000.00), "девятьсот тридцать четыре триллиона рублей 00 копеек"; };
	it "935000000000000.00" => sub { is rur2words(935000000000000.00), "девятьсот тридцать пять триллионов рублей 00 копеек"; };
	it "936000000000000.00" => sub { is rur2words(936000000000000.00), "девятьсот тридцать шесть триллионов рублей 00 копеек"; };
	it "937000000000000.00" => sub { is rur2words(937000000000000.00), "девятьсот тридцать семь триллионов рублей 00 копеек"; };
	it "938000000000000.00" => sub { is rur2words(938000000000000.00), "девятьсот тридцать восемь триллионов рублей 00 копеек"; };
	it "939000000000000.00" => sub { is rur2words(939000000000000.00), "девятьсот тридцать девять триллионов рублей 00 копеек"; };
	it "940000000000000.00" => sub { is rur2words(940000000000000.00), "девятьсот сорок триллионов рублей 00 копеек"; };
	it "941000000000000.00" => sub { is rur2words(941000000000000.00), "девятьсот сорок один триллион рублей 00 копеек"; };
	it "942000000000000.00" => sub { is rur2words(942000000000000.00), "девятьсот сорок два триллиона рублей 00 копеек"; };
	it "943000000000000.00" => sub { is rur2words(943000000000000.00), "девятьсот сорок три триллиона рублей 00 копеек"; };
	it "944000000000000.00" => sub { is rur2words(944000000000000.00), "девятьсот сорок четыре триллиона рублей 00 копеек"; };
	it "945000000000000.00" => sub { is rur2words(945000000000000.00), "девятьсот сорок пять триллионов рублей 00 копеек"; };
	it "946000000000000.00" => sub { is rur2words(946000000000000.00), "девятьсот сорок шесть триллионов рублей 00 копеек"; };
	it "947000000000000.00" => sub { is rur2words(947000000000000.00), "девятьсот сорок семь триллионов рублей 00 копеек"; };
	it "948000000000000.00" => sub { is rur2words(948000000000000.00), "девятьсот сорок восемь триллионов рублей 00 копеек"; };
	it "949000000000000.00" => sub { is rur2words(949000000000000.00), "девятьсот сорок девять триллионов рублей 00 копеек"; };
	it "950000000000000.00" => sub { is rur2words(950000000000000.00), "девятьсот пятьдесят триллионов рублей 00 копеек"; };
	it "951000000000000.00" => sub { is rur2words(951000000000000.00), "девятьсот пятьдесят один триллион рублей 00 копеек"; };
	it "952000000000000.00" => sub { is rur2words(952000000000000.00), "девятьсот пятьдесят два триллиона рублей 00 копеек"; };
	it "953000000000000.00" => sub { is rur2words(953000000000000.00), "девятьсот пятьдесят три триллиона рублей 00 копеек"; };
	it "954000000000000.00" => sub { is rur2words(954000000000000.00), "девятьсот пятьдесят четыре триллиона рублей 00 копеек"; };
	it "955000000000000.00" => sub { is rur2words(955000000000000.00), "девятьсот пятьдесят пять триллионов рублей 00 копеек"; };
	it "956000000000000.00" => sub { is rur2words(956000000000000.00), "девятьсот пятьдесят шесть триллионов рублей 00 копеек"; };
	it "957000000000000.00" => sub { is rur2words(957000000000000.00), "девятьсот пятьдесят семь триллионов рублей 00 копеек"; };
	it "958000000000000.00" => sub { is rur2words(958000000000000.00), "девятьсот пятьдесят восемь триллионов рублей 00 копеек"; };
	it "959000000000000.00" => sub { is rur2words(959000000000000.00), "девятьсот пятьдесят девять триллионов рублей 00 копеек"; };
	it "960000000000000.00" => sub { is rur2words(960000000000000.00), "девятьсот шестьдесят триллионов рублей 00 копеек"; };
	it "961000000000000.00" => sub { is rur2words(961000000000000.00), "девятьсот шестьдесят один триллион рублей 00 копеек"; };
	it "962000000000000.00" => sub { is rur2words(962000000000000.00), "девятьсот шестьдесят два триллиона рублей 00 копеек"; };
	it "963000000000000.00" => sub { is rur2words(963000000000000.00), "девятьсот шестьдесят три триллиона рублей 00 копеек"; };
	it "964000000000000.00" => sub { is rur2words(964000000000000.00), "девятьсот шестьдесят четыре триллиона рублей 00 копеек"; };
	it "965000000000000.00" => sub { is rur2words(965000000000000.00), "девятьсот шестьдесят пять триллионов рублей 00 копеек"; };
	it "966000000000000.00" => sub { is rur2words(966000000000000.00), "девятьсот шестьдесят шесть триллионов рублей 00 копеек"; };
	it "967000000000000.00" => sub { is rur2words(967000000000000.00), "девятьсот шестьдесят семь триллионов рублей 00 копеек"; };
	it "968000000000000.00" => sub { is rur2words(968000000000000.00), "девятьсот шестьдесят восемь триллионов рублей 00 копеек"; };
	it "969000000000000.00" => sub { is rur2words(969000000000000.00), "девятьсот шестьдесят девять триллионов рублей 00 копеек"; };
	it "970000000000000.00" => sub { is rur2words(970000000000000.00), "девятьсот семьдесят триллионов рублей 00 копеек"; };
	it "971000000000000.00" => sub { is rur2words(971000000000000.00), "девятьсот семьдесят один триллион рублей 00 копеек"; };
	it "972000000000000.00" => sub { is rur2words(972000000000000.00), "девятьсот семьдесят два триллиона рублей 00 копеек"; };
	it "973000000000000.00" => sub { is rur2words(973000000000000.00), "девятьсот семьдесят три триллиона рублей 00 копеек"; };
	it "974000000000000.00" => sub { is rur2words(974000000000000.00), "девятьсот семьдесят четыре триллиона рублей 00 копеек"; };
	it "975000000000000.00" => sub { is rur2words(975000000000000.00), "девятьсот семьдесят пять триллионов рублей 00 копеек"; };
	it "976000000000000.00" => sub { is rur2words(976000000000000.00), "девятьсот семьдесят шесть триллионов рублей 00 копеек"; };
	it "977000000000000.00" => sub { is rur2words(977000000000000.00), "девятьсот семьдесят семь триллионов рублей 00 копеек"; };
	it "978000000000000.00" => sub { is rur2words(978000000000000.00), "девятьсот семьдесят восемь триллионов рублей 00 копеек"; };
	it "979000000000000.00" => sub { is rur2words(979000000000000.00), "девятьсот семьдесят девять триллионов рублей 00 копеек"; };
	it "980000000000000.00" => sub { is rur2words(980000000000000.00), "девятьсот восемьдесят триллионов рублей 00 копеек"; };
	it "981000000000000.00" => sub { is rur2words(981000000000000.00), "девятьсот восемьдесят один триллион рублей 00 копеек"; };
	it "982000000000000.00" => sub { is rur2words(982000000000000.00), "девятьсот восемьдесят два триллиона рублей 00 копеек"; };
	it "983000000000000.00" => sub { is rur2words(983000000000000.00), "девятьсот восемьдесят три триллиона рублей 00 копеек"; };
	it "984000000000000.00" => sub { is rur2words(984000000000000.00), "девятьсот восемьдесят четыре триллиона рублей 00 копеек"; };
	it "985000000000000.00" => sub { is rur2words(985000000000000.00), "девятьсот восемьдесят пять триллионов рублей 00 копеек"; };
	it "986000000000000.00" => sub { is rur2words(986000000000000.00), "девятьсот восемьдесят шесть триллионов рублей 00 копеек"; };
	it "987000000000000.00" => sub { is rur2words(987000000000000.00), "девятьсот восемьдесят семь триллионов рублей 00 копеек"; };
	it "988000000000000.00" => sub { is rur2words(988000000000000.00), "девятьсот восемьдесят восемь триллионов рублей 00 копеек"; };
	it "989000000000000.00" => sub { is rur2words(989000000000000.00), "девятьсот восемьдесят девять триллионов рублей 00 копеек"; };
	it "990000000000000.00" => sub { is rur2words(990000000000000.00), "девятьсот девяносто триллионов рублей 00 копеек"; };
	it "991000000000000.00" => sub { is rur2words(991000000000000.00), "девятьсот девяносто один триллион рублей 00 копеек"; };
	it "992000000000000.00" => sub { is rur2words(992000000000000.00), "девятьсот девяносто два триллиона рублей 00 копеек"; };
	it "993000000000000.00" => sub { is rur2words(993000000000000.00), "девятьсот девяносто три триллиона рублей 00 копеек"; };
	it "994000000000000.00" => sub { is rur2words(994000000000000.00), "девятьсот девяносто четыре триллиона рублей 00 копеек"; };
	it "995000000000000.00" => sub { is rur2words(995000000000000.00), "девятьсот девяносто пять триллионов рублей 00 копеек"; };
	it "996000000000000.00" => sub { is rur2words(996000000000000.00), "девятьсот девяносто шесть триллионов рублей 00 копеек"; };
	it "997000000000000.00" => sub { is rur2words(997000000000000.00), "девятьсот девяносто семь триллионов рублей 00 копеек"; };
	it "998000000000000.00" => sub { is rur2words(998000000000000.00), "девятьсот девяносто восемь триллионов рублей 00 копеек"; };
	it "999000000000000.00" => sub { is rur2words(999000000000000.00), "девятьсот девяносто девять триллионов рублей 00 копеек"; };
};

runtests unless caller;
