/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.regex.JRegularExpression;
import net.sf.saxon.functions.regex.RegexSyntaxException;
import net.sf.saxon.functions.regex.RegularExpression;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.StringValue;

public class Matches
extends SystemFunction {
    private RegularExpression regexp;
    private boolean allow30features = false;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.allow30features = DecimalValue.THREE.equals(visitor.getStaticContext().getXPathLanguageLevel());
        Expression e = this.simplifyArguments(visitor);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    private void maybePrecompile(ExpressionVisitor visitor) throws XPathException {
        if (this.regexp == null) {
            try {
                this.regexp = Matches.tryToCompile(this.argument, 1, 2, visitor.getStaticContext());
            }
            catch (XPathException err) {
                err.setLocator(this);
                throw err;
            }
        }
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    public RegularExpression getCompiledRegularExpression() {
        return this.regexp;
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        RegularExpression re;
        AtomicValue sv0 = (AtomicValue)this.argument[0].evaluateItem(c);
        if (sv0 == null) {
            sv0 = StringValue.EMPTY_STRING;
        }
        if ((re = this.regexp) == null) {
            CharSequence flags;
            AtomicValue pat = (AtomicValue)this.argument[1].evaluateItem(c);
            if (this.argument.length == 2) {
                flags = "";
            } else {
                AtomicValue sv2 = (AtomicValue)this.argument[2].evaluateItem(c);
                if (sv2 == null) {
                    return null;
                }
                flags = sv2.getStringValueCS();
            }
            return BooleanValue.get(this.evalMatches(sv0, pat, flags, c));
        }
        return BooleanValue.get(re.containsMatch(sv0.getStringValueCS()));
    }

    public boolean evalMatches(AtomicValue input, AtomicValue regex, CharSequence flags, XPathContext context) throws XPathException {
        JRegularExpression re;
        if (regex == null) {
            return false;
        }
        try {
            int flagBits = JRegularExpression.setFlags(flags);
            int options = 2;
            if (context.getConfiguration().getXMLVersion() == 11) {
                options |= 1;
            }
            if (context.getConfiguration().getXsdVersion() == 11) {
                options |= 0x20;
            }
            if (this.allow30features) {
                options |= 4;
            }
            re = new JRegularExpression(regex.getStringValueCS(), options, flagBits, null);
        }
        catch (XPathException err) {
            XPathException de = new XPathException(err);
            de.maybeSetErrorCode("FORX0002");
            de.setXPathContext(context);
            throw de;
        }
        return re.containsMatch(input.getStringValueCS());
    }

    public static RegularExpression tryToCompile(Expression[] args, int patternArg, int flagsArg, StaticContext env) throws XPathException {
        if (patternArg > args.length - 1) {
            return null;
        }
        String flagstr = null;
        if (args.length - 1 < flagsArg) {
            flagstr = "";
        } else if (args[flagsArg] instanceof StringLiteral) {
            flagstr = ((StringLiteral)args[flagsArg]).getStringValue();
        }
        if (args[patternArg] instanceof StringLiteral && flagstr != null) {
            try {
                String in = ((StringLiteral)args[patternArg]).getStringValue();
                int options = 2;
                if (flagstr.indexOf(33) >= 0) {
                    options |= 8;
                }
                int flagBits = JRegularExpression.setFlags(flagstr);
                if (env.getConfiguration().getXMLVersion() == 11) {
                    options |= 1;
                }
                if (env.getConfiguration().getXsdVersion() == 11) {
                    options |= 0x20;
                }
                if (DecimalValue.THREE.equals(env.getXPathLanguageLevel())) {
                    options |= 4;
                }
                ArrayList<RegexSyntaxException> warnings = new ArrayList<RegexSyntaxException>();
                JRegularExpression jre = new JRegularExpression(in, options, flagBits, warnings);
                for (RegexSyntaxException e : warnings) {
                    env.issueWarning(e.getMessage(), args[patternArg]);
                }
                return jre;
            }
            catch (XPathException err) {
                err.maybeSetErrorCode("FORX0002");
                throw err;
            }
        }
        return null;
    }
}

