#  You may distribute under the terms of either the GNU General Public License
#  or the Artistic License (the same terms as Perl itself)
#
#  (C) Paul Evans, 2023 -- leonerd@leonerd.org.uk

use v5.36;
use Object::Pad 0.66;

role App::perl::distrolint::CheckRole::TreeSitterPerl;

use File::Slurper qw( read_text );
use Text::Treesitter;

my $TSPERL;

method tree_sitter_perl
{
   return $TSPERL //= Text::Treesitter->new(
      lang_name => "perl",
   );
}

my %TREE_FOR_STRING;

method parse_perl_string ( $str )
{
   return $TREE_FOR_STRING{ $str } //= $self->tree_sitter_perl->parse_string( $str );
}

method parse_perl_file( $path )
{
   return $self->parse_perl_string( read_text $path );
}

0x55AA;
