/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.iterator;

import com.sun.media.jai.iterator.RectIterCSM;
import com.sun.media.jai.util.DataBufferUtils;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;

public class RectIterCSMFloat
extends RectIterCSM {
    float[][] bankData;
    float[] bank;

    public RectIterCSMFloat(RenderedImage renderedImage, Rectangle rectangle) {
        super(renderedImage, rectangle);
        this.bankData = new float[this.numBands + 1][];
        this.dataBufferChanged();
    }

    protected final void dataBufferChanged() {
        if (this.bankData == null) {
            return;
        }
        float[][] fArray = DataBufferUtils.getBankDataFloat(this.dataBuffer);
        int n = 0;
        while (n < this.numBands) {
            this.bankData[n] = fArray[this.bankIndices[n]];
            ++n;
        }
        this.bank = this.bankData[this.b];
        this.adjustBandOffsets();
    }

    public void startBands() {
        super.startBands();
        this.bank = this.bankData[0];
    }

    public void nextBand() {
        super.nextBand();
        this.bank = this.bankData[this.b];
    }

    public final int getSample() {
        return (int)this.bank[this.offset + this.bandOffset];
    }

    public final int getSample(int n) {
        return (int)this.bankData[n][this.offset + this.bandOffsets[n]];
    }

    public final float getSampleFloat() {
        return this.bank[this.offset + this.bandOffset];
    }

    public final float getSampleFloat(int n) {
        return this.bankData[n][this.offset + this.bandOffsets[n]];
    }

    public final double getSampleDouble() {
        return this.bank[this.offset + this.bandOffset];
    }

    public final double getSampleDouble(int n) {
        return this.bankData[n][this.offset + this.bandOffsets[n]];
    }

    public int[] getPixel(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.numBands];
        }
        int n = 0;
        while (n < this.numBands) {
            nArray[n] = (int)this.bankData[n][this.offset + this.bandOffsets[n]];
            ++n;
        }
        return nArray;
    }

    public float[] getPixel(float[] fArray) {
        if (fArray == null) {
            fArray = new float[this.numBands];
        }
        int n = 0;
        while (n < this.numBands) {
            fArray[n] = this.bankData[n][this.offset + this.bandOffsets[n]];
            ++n;
        }
        return fArray;
    }

    public double[] getPixel(double[] dArray) {
        if (dArray == null) {
            dArray = new double[this.numBands];
        }
        int n = 0;
        while (n < this.numBands) {
            dArray[n] = this.bankData[n][this.offset + this.bandOffsets[n]];
            ++n;
        }
        return dArray;
    }
}

