# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::NA;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240308154352;

my $formatters = [
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '88',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '6',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '87',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          64426\\d{3}|
          6(?:
            1(?:
              2[2-7]|
              3[01378]|
              4[0-4]
            )|
            254|
            32[0237]|
            4(?:
              27|
              41|
              5[25]
            )|
            52[236-8]|
            626|
            7(?:
              2[2-4]|
              30
            )
          )\\d{4,5}|
          6(?:
            1(?:
              (?:
                0\\d|
                2[0189]|
                3[24-69]|
                4[5-9]
              )\\d|
              17|
              69|
              7[014]
            )|
            2(?:
              17|
              5[0-36-8]|
              69|
              70
            )|
            3(?:
              17|
              2[14-689]|
              34|
              6[289]|
              7[01]|
              81
            )|
            4(?:
              17|
              2[0-2]|
              4[06]|
              5[0137]|
              69|
              7[01]
            )|
            5(?:
              17|
              2[0459]|
              69|
              7[01]
            )|
            6(?:
              17|
              25|
              38|
              42|
              69|
              7[01]
            )|
            7(?:
              17|
              2[569]|
              3[13]|
              6[89]|
              7[01]
            )
          )\\d{4}
        ',
                'geographic' => '
          64426\\d{3}|
          6(?:
            1(?:
              2[2-7]|
              3[01378]|
              4[0-4]
            )|
            254|
            32[0237]|
            4(?:
              27|
              41|
              5[25]
            )|
            52[236-8]|
            626|
            7(?:
              2[2-4]|
              30
            )
          )\\d{4,5}|
          6(?:
            1(?:
              (?:
                0\\d|
                2[0189]|
                3[24-69]|
                4[5-9]
              )\\d|
              17|
              69|
              7[014]
            )|
            2(?:
              17|
              5[0-36-8]|
              69|
              70
            )|
            3(?:
              17|
              2[14-689]|
              34|
              6[289]|
              7[01]|
              81
            )|
            4(?:
              17|
              2[0-2]|
              4[06]|
              5[0137]|
              69|
              7[01]
            )|
            5(?:
              17|
              2[0459]|
              69|
              7[01]
            )|
            6(?:
              17|
              25|
              38|
              42|
              69|
              7[01]
            )|
            7(?:
              17|
              2[569]|
              3[13]|
              6[89]|
              7[01]
            )
          )\\d{4}
        ',
                'mobile' => '
          (?:
            60|
            8[1245]
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(8701\\d{5})',
                'toll_free' => '80\\d{7}',
                'voip' => '
          8(?:
            3\\d\\d|
            86
          )\\d{5}
        '
              };
my %areanames = ();
$areanames{en} = {"264625676", "Otjinene",
"264652715", "Ruacana",
"264651716", "Kunene\ River\ Lodge",
"264652582", "Tsandi",
"264641747", "Usakos",
"264632901", "Rosh\ Pinah",
"264652324", "Ongwediva",
"264631765", "Oranjemund",
"264632803", "Dawiab",
"264672584", "Andara",
"264631754", "Mariental",
"264631711", "Bralano",
"264632655", "Tsumispark",
"26463257", "Tses",
"264673331", "Kamanjab",
"264671776", "Otjiwarongo",
"264657032", "Oshakati",
"264651729", "Okangwati",
"264652800", "Ondangwa",
"264652525", "Okahao",
"26462549", "Hochfeld",
"264662502", "Mpacha\/Ngoma",
"264625809", "Otjiwa",
"264645316", "Usakos",
"264673336", "Kamanjab",
"264671771", "Otavi",
"264661703", "Bukalo",
"264651765", "Oshakati",
"264651754", "Ongha",
"264652766", "Oruvandjai",
"264651711", "Etanga",
"264652655", "Oshikango",
"264652664", "Oshikango",
"26462505", "Okahandja",
"264632406", "Mariental",
"264673169", "Okakarara",
"264631729", "Kalkrand",
"264632800", "Ariamsvlei",
"264651783", "Warmquelle",
"26467317", "Okakarara",
"264637184", "Keetmanshoop",
"26467331", "Kamanjab\/Khorixas",
"264652489", "Onathinge",
"26467223", "Tsumeb",
"264652702", "Ruacana",
"264625391", "Klein\ Aub",
"26462692", "Central",
"264661726", "Ruuga",
"26464272", "Walvis\ Bay",
"264625688", "Epukiro",
"264662670", "Rundu",
"264625697", "Blumfelde",
"26467224", "Tsumeb",
"264671797", "Grootfontein",
"264661719", "Nzinze",
"264625810", "Leonardville",
"264652628", "Ongha",
"264621769", "Steinhausen",
"264672455", "Gam",
"264661721", "Rundu",
"264625813", "Blumfelde",
"264625411", "Otjihase",
"264662673", "Rundu",
"264652462", "Oluno",
"264637191", "Keetmanshoop",
"26464407", "Swakopmund",
"264671747", "Kalkfeld",
"26464210", "Walvis\ Bay",
"26465230", "Ongwediva",
"264672492", "Grootfontein",
"264625801", "Epukiro",
"264652494", "Onathinge",
"264651721", "Ogongo",
"26464694", "Central",
"264677166", "Kamanjab\/Otavi",
"264631719", "Gochas",
"264631767", "Oranjemund",
"264673339", "Kamanjab",
"264645319", "Usakos",
"264632657", "Tsumispark",
"264652717", "Ruacana",
"264652566", "Elim",
"26465226", "Oshakati",
"264632409", "Mariental",
"264652725", "Oshifo",
"264651726", "Ohangwena",
"264645212", "Rössing\ Mine",
"264625722", "Hochland",
"264672312", "Kombat",
"264625806", "Summerdown",
"264627024", "Hosea\ Kutako\ INT\ Airport",
"264651719", "Ombombo",
"264625608", "Otjiwa",
"264651767", "Oshakati",
"264625679", "Otjinene",
"26462566", "Gobabis",
"264652657", "Oshikango",
"264632769", "Aranos",
"264671779", "Outjo",
"264673062", "Klein\ Waterberg",
"264641708", "Karibib",
"26464176", "Walvis\ Bay",
"264661711", "Kongola",
"26464500", "Henties\ Bay",
"264652692", "Omungwelume",
"264651703", "Edundja",
"264625421", "Groot\–Aub",
"26463204", "Luderitz",
"264625695", "Leonardville",
"264621766", "Sandveld",
"26466696", "North\ East",
"264632502", "Gochas",
"26463203", "Luderitz",
"264652481", "Onandjokwe",
"264671745", "Halali",
"264632811", "Gaibis",
"264652642", "Eenhana",
"264662582", "Nyangana",
"264631703", "Aranos",
"264652880", "Omundaungilo",
"264667153", "Rundu",
"26464271", "Walvis\ Bay",
"264661716", "Muveke",
"2646441", "Swakopmund",
"264621761", "Rehoboth",
"264652632", "Eenhana",
"264632408", "Mariental",
"264625731", "Nina",
"26463246", "Mariental",
"264621756", "Otjihase",
"264673338", "Kamanjab",
"264645318", "Usakos",
"264631732", "Karasburg",
"264631718", "Goageb",
"264647172", "Swakopmund",
"26464175", "Walvis\ Bay",
"264652590", "Mahenene",
"264673052", "Otjiwarongo",
"264671794", "Epupa",
"264625694", "Leonardville",
"264641710", "Langstrand",
"26463270", "Karasburg",
"264652600", "Ohangwena",
"264671778", "Outjo",
"264677140", "Grootfontein",
"264632768", "Aranos",
"264641713", "Omaruru",
"264625678", "Otjinene",
"264651732", "Oluno",
"264625609", "Otjiwa",
"264621751", "Okahandja",
"264621772", "Witvlei",
"264651742", "Onathinge",
"264672292", "Etosha\ Rurtel\/Lindequest",
"26464573", "Omaruru",
"264621743", "Hochland",
"264652327", "Ongwediva",
"26465225", "Oshakati",
"264625681", "Drimiopsis",
"264631770", "Rosh\ Pinah",
"264647130", "Walvis\ Bay",
"264625613", "Otjiwa",
"264651773", "Otjondeka",
"26463811", "Keetmanshoop",
"264672903", "Epupa",
"26466263", "Katima\-Mulilo",
"264652621", "Onuno",
"264641709", "Langstrand",
"264645521", "Karibib",
"26462565", "Gobabis",
"264625686", "Epukiro",
"264672900", "Kalkfeld",
"264652667", "Omafu",
"264661728", "Nyangana",
"264652572", "Ogongo",
"264627025", "Hosea\ Kutako\ INT\ Airport",
"264651757", "Ongwediva",
"264671786", "Tsumeb",
"264651770", "Oshikango",
"264621730", "Babi\-Babi",
"26466269", "Rundu",
"264625610", "Otjiwa",
"264677151", "Grootfontein",
"264645711", "Omaruru",
"2646420", "Walvis\ Bay",
"264621740", "Gobabis",
"26463345", "Mariental",
"264652740", "Ehomba",
"26463264", "Kalkrand",
"264625808", "Otjinene",
"264641723", "Swakopmund",
"26462524", "Rehoboth",
"264662572", "Hakasembe",
"264632733", "Aminuis",
"264652870", "Oniingo",
"264651728", "Okalongo",
"264625704", "Witvlei",
"264625606", "Otjiwa",
"26462523", "Rehoboth",
"264673322", "Sorris\-Sorris",
"26463626", "Helmeringhausen",
"264631728", "Kalkrand",
"264673168", "Okakarara",
"264625601", "Seeis",
"264621759", "Otjozondu",
"264632730", "Aminuis",
"26463683", "Keetmanshoop",
"264652452", "Haiyandja",
"264652743", "Kunene\ River\ Lodge",
"264652629", "Ongha",
"26463237", "Oranjemund",
"264661718", "Nakayale\/Nkurenkuru",
"264662593", "Bagani",
"264641701", "Arandis",
"264652524", "Okahao",
"264662600", "Mpungu",
"264625689", "Babi\-Babi",
"264652751", "Otjondeka",
"264652714", "Ruacana",
"264632654", "Hoachanas",
"264632611", "Oamseb",
"264631764", "Oranjemund",
"264652325", "Ongwediva",
"264631755", "Mariental",
"264652488", "Onathinge",
"264671789", "Uchab",
"264672350", "Uib",
"264652683", "Ongenga",
"264652447", "Omuthiya",
"264632524", "Bulwana",
"264632382", "Luderitz",
"264637185", "Keetmanshoop",
"26465695", "North",
"264641706", "Henties\ Bay",
"26464400", "Swakopmund",
"264671762", "Okaputa",
"264632714", "Karasburg",
"264652892", "Omuntele",
"264652654", "Oshikango",
"264652665", "Oshikango",
"26467243", "Grootfontein",
"264651764", "Oshakati",
"264621768", "Spatzenfeld",
"264662590", "Bagani",
"26462519", "Okandjatu",
"264652721", "Oshifo",
"264645714", "Omaruru",
"264677165", "Anker\/Braunfels\/Fransfontein",
"264631725", "Hoachanas",
"264657152", "Oshakati",
"26464404", "Swakopmund",
"264672323", "Horabe",
"264652565", "Elim",
"264651717", "Mahenene",
"264651769", "Oshigambo",
"264625677", "Otjinene",
"264641746", "Usakos",
"26467240", "Grootfontein",
"264632580", "Aus",
"264632719", "Karasburg",
"264671777", "Otjiwarongo",
"26464403", "Swakopmund",
"26463221", "Keetmanshoop",
"264667145", "Katima\-Mulilo",
"264662500", "Nakayale\/Omega",
"264625805", "Drimiopsis",
"264651725", "Ohangwena",
"264661702", "Bagani",
"264673180", "Okamatapati",
"264671753", "Kombat",
"264632583", "Guibis",
"264652624", "Ondobe",
"264671784", "Tsumeb",
"264631717", "Gibeon",
"264631769", "Rosh\ Pinah",
"264673337", "Kamanjab",
"264645317", "Usakos",
"264645220", "Rössing\ Mine",
"264662640", "Nyangana",
"26466423", "Kalahariplaas",
"264672320", "Abenab",
"264652580", "Tsandi",
"264652719", "Ruacana",
"264641741", "Swakopmund",
"26465221", "Oshakati",
"264625684", "Sandveld",
"264632407", "Mariental",
"264651782", "Tsandi",
"264652866", "Okatope",
"264671741", "Anker",
"264625696", "Leonardville",
"26467313", "Outjo",
"26464511", "Arandis",
"26466268", "Katima\-Mulilo",
"26464276", "Walvis\ Bay",
"264621754", "Ombotozu",
"264661727", "Sikono",
"264625180", "Otjozondu",
"264652460", "Oluno",
"264671791", "Waterberg\ Plateau\ Park",
"264662672", "Rundu",
"26464550", "Karibib",
"264661715", "Matava",
"264652463", "Oluno",
"264625183", "Ombotozu",
"264671746", "Horabe",
"264625812", "Blumfelde",
"264625691", "Leonardville",
"264625709", "Witvlei",
"26463260", "Stampriet",
"264652700", "Ruacana",
"264652328", "Ongwediva",
"264647165", "Walvis\ Bay",
"264632754", "Bralano",
"264631766", "Oranjemund",
"264632711", "Karasburg",
"264632656", "Tsumispark",
"264671775", "Otjiwarongo",
"264651761", "Opuwo",
"264625675", "Otjinene",
"264652716", "Ruacana",
"264651715", "Kaoko\ Otavi",
"264652567", "Elim",
"264652651", "Oshikango",
"264672493", "Grootfontein",
"264673167", "Okakarara",
"264631727", "Kalahariplaas",
"264672310", "Kombat",
"26467697", "North",
"264672440", "Tsumkwe",
"264625720", "Namib\ Grens",
"264652729", "Opuwo",
"264652526", "Okahao",
"26465222", "Oshakati",
"264651766", "Oshakati",
"264647100", "Walvis\ Bay",
"26466254", "Katima\-Mulilo",
"264632405", "Mariental",
"264641749", "Usakos",
"26463207", "Luderitz",
"264631715", "Feldschuhorn",
"264632651", "Schilp",
"264625723", "Many\ Hills",
"264645213", "Rössing\ Mine",
"264673335", "Toshari",
"264645315", "Usakos",
"26466253", "Katima\-Mulilo",
"264651727", "Okahao",
"264641704", "Henties\ Bay",
"264652521", "Okahao",
"26462562", "Gobabis",
"264625807", "Plessisplaas",
"26463222", "Keetmanshoop",
"264621767", "Seeis",
"264625604", "Buitepos",
"264651702", "Blue\ Sodalite\ Mine",
"264661725", "Rupara",
"264673063", "Klein\ Waterberg",
"264652630", "Eenhana",
"264667030", "Rundu",
"264657145", "Oshakati",
"26464570", "Omaruru",
"264652640", "Eenhana",
"264671749", "Khorixas",
"264652448", "Omuthiya",
"26463274", "Rosh\ Pinah",
"264662580", "Nkurenkuru",
"264632690", "Warmbad",
"264642118", "Walvis\ Bay",
"264652882", "Oshuli",
"264631702", "Aminuis",
"264632693", "Hamab",
"264652643", "Eenhana",
"26464512", "Arandis",
"26467248", "Grootfontein",
"264632500", "Gochas",
"264625701", "Witvlei",
"26465273", "Opuwo",
"264673060", "Otjiwarongo",
"264652503", "Anamulenge",
"264652633", "Eenhana",
"264652690", "Omungwelume",
"264671799", "Grootfontein",
"264661717", "Nkurenkuru",
"264652728", "Opuwo",
"26463242", "Mariental",
"264631733", "Karasburg",
"264651740", "Omutsewonime",
"264672290", "Etosha\ Rurtel",
"264661724", "Rundu",
"264631743", "Lorelei",
"264652532", "Okahao",
"264625605", "Otjiwa",
"26465200", "Ombalantu",
"264651730", "Okatope",
"264621770", "Summerdown",
"264673053", "Otjiwarongo",
"264673050", "Waterberg\ Plateau\ Park",
"26465242", "Ondangwa",
"264632300", "Oranjemund",
"264651733", "Oluno",
"264631740", "Klein\ Karas",
"26467301", "Otjiwarongo",
"264641712", "Leoburn",
"264651743", "Ondangwa",
"26463200", "Luderitz",
"264672293", "Etosha\ Rurtel\/Namutoni",
"26467335", "Kamanjab\/Khorixas",
"264641748", "Usakos",
"264631730", "Karasburg",
"26464504", "Uis",
"264642119", "Walvis\ Bay",
"264671748", "Kamanjab",
"264652449", "Omuthiya",
"26464464", "Swakopmund",
"264637181", "Keetmanshoop",
"264671774", "Otjiwarongo",
"264673091", "Okaputa",
"26464463", "Swakopmund",
"264672902", "Kalkfeld",
"264652570", "Ogongo",
"26462501", "Okahandja",
"264625430", "Hosea\ Kutako\ INT\ Airport",
"264625674", "Epukiro",
"264651772", "Oshitayi",
"264651751", "Onesi",
"264625612", "Otjiwa",
"264651714", "Haiyandja",
"264621732", "Buitepos",
"264671798", "Grootfontein",
"264641705", "Henties\ Bay",
"264625698", "Blumfelde",
"264625687", "Epukiro",
"264632404", "Mariental",
"264652666", "Omafu",
"264652755", "Sesfontein",
"264651756", "Ongwediva",
"264652764", "Otjitjekwa",
"264673334", "Toshari",
"264677173", "Otjiwarongo",
"264652321", "Ongwediva",
"264631751", "Mariental",
"264631772", "Seeheim",
"264671787", "Tsumeb",
"26461", "Windhoek",
"264631714", "Deurstamp",
"264662573", "Bunia",
"264632732", "Aminuis",
"26463239", "Oranjemund",
"26465241", "Ondangwa",
"26465234", "Ongwediva",
"264632718", "Karasburg",
"264652450", "Oshitayi",
"26467302", "Otjiwarongo",
"264651768", "Oshifo",
"264662627", "Katima\-Mulilo",
"264625607", "Otjiwa",
"264621755", "Omitara",
"264641722", "Rössing\ Mine",
"26465233", "Ongwediva",
"264652856", "Onyaanya",
"26464275", "Walvis\ Bay",
"264673320", "Khorixas",
"26464219", "Walvis\ Bay",
"264673323", "Sorris\-Sorris",
"264632950", "Namgorab",
"264652718", "Ruacana",
"26463234", "Oranjemund",
"26463241", "Mariental",
"26464530", "Usakos",
"264672982", "Tsumeb",
"26467220", "Tsumeb",
"264652742", "Panosa",
"264661714", "Mashare",
"26463233", "Oranjemund",
"264652453", "Haiyandja",
"264662570", "Sikono",
"264671760", "Okakarara",
"264632260", "Keetmanshoop",
"264651759", "Ondundu",
"26462540", "Neudamm\/Hosea\ Kutako\ INT\ Airport",
"264652890", "Okankolo",
"264662592", "Bagani",
"26464220", "Walvis\ Bay",
"264642111", "Langstrand",
"264632380", "Oranjemund",
"264652441", "Omuthiya",
"264632830", "Bethanie",
"264631724", "Helmeringhausen",
"264632383", "Luderitz",
"264671785", "Tsumeb",
"264632833", "Helmeringhausen",
"264652329", "Ongwediva",
"264631759", "Noordoewer",
"264625685", "Sandveld",
"264652682", "Edundja",
"264625804", "Eland",
"264652446", "Omuthiya",
"264671763", "Okaukuejo",
"264652625", "Ondobe",
"26462502", "Okahandja",
"264652491", "Onathinge",
"264651724", "Ohangwena",
"264641707", "Karibib",
"264651748", "Ondobe",
"264662506", "Ngoma",
"264645219", "Rössing\ Mine",
"264672298", "Etosha\ Rurtel\/Okaukuejo",
"264632807", "Aroab",
"26462522", "Rehoboth",
"264641743", "Tsaobis",
"264652720", "Oshifo",
"26463262", "Grunau",
"264652675", "Omafu",
"264672326", "Maroelaboom",
"264625716", "Eland",
"264651774", "Otwani",
"264651738", "Ombalantu",
"264625672", "Epukiro",
"264621734", "Drimiopsis",
"264651712", "Etunda",
"264625614", "Steinhausen",
"264632581", "Aus",
"264671751", "Khorixas",
"264672615", "Uchab",
"264631748", "Luderitz",
"264673181", "Okamatapati",
"264662501", "Nakayale",
"26463236", "Oranjemund",
"264661707", "Kahenge",
"264657031", "Ondangwa",
"264632308", "Oranjemund",
"264671756", "Maroelaboom",
"264673332", "Biermanskool",
"264631774", "Stampriet",
"264632902", "Rosh\ Pinah",
"264631738", "Keetmanshoop",
"264631712", "Bulwana",
"26463228", "Keetmanshoop",
"264645221", "Rössing\ Mine",
"264652581", "Tsandi",
"264652762", "Kowares",
"264652885", "Okongo",
"264652290", "Oshakati",
"264662589", "Rundu",
"264632699", "Uhabis",
"264652649", "Oshikango",
"264671740", "Abenab",
"264625181", "Otjozondu",
"264652461", "Oluno",
"264637192", "Keetmanshoop",
"264657142", "Oshakati",
"26464405", "Swakopmund",
"264652822", "Ondangwa",
"264671793", "Waterberg\ Plateau\ Park",
"264625693", "Leonardville",
"264661722", "Rundu",
"264651705", "Eenhana",
"264652863", "Onankali",
"264652509", "Ombalantu",
"26467307", "Otjiwarongo",
"26467242", "Grootfontein",
"264645539", "Karibib",
"26466261", "Katima\-Mulilo",
"264625690", "Babi\-Babi",
"264652860", "Okapuku",
"264641714", "Omaruru",
"264625817", "Nina",
"264671790", "Uib",
"264625392", "Rietoog",
"264671743", "Biermanskool",
"26462573", "Dordabis",
"264652701", "Ruacana",
"264652650", "Oshikango",
"264632589", "Aus",
"264671759", "Okakarara",
"264652458", "Oluno",
"264651760", "Opuwo",
"264652523", "Okahao",
"264672617", "Uchab",
"264652677", "Odibo",
"264652562", "Onaanda",
"264673328", "Kamanjab",
"26464510", "Arandis",
"264631722", "Guibis",
"264672441", "Tsumkwe",
"264672311", "Kombat",
"264625721", "Friedental",
"264632653", "Hoachanas",
"264632805", "Aroab",
"264632520", "Grenslyn",
"264631763", "Oranjemund",
"264672329", "Coblenz",
"264632650", "Schilp",
"264652589", "Onesi",
"264631760", "Noordoewer",
"264632523", "Asab",
"26464572", "Omaruru",
"264652710", "Etoto",
"264661705", "Hakasembe",
"264662578", "Marangi",
"264672316", "Rietfontein",
"264647027", "Walvis\ Bay",
"26464551", "Otjimbingwe",
"264651722", "Ohandungu",
"264672491", "Grootfontein",
"264625802", "Epukiro",
"264652653", "Oshikango",
"264652520", "Okahao",
"264651763", "Oshakati",
"26467234", "Otavi",
"26467241", "Grootfontein",
"264652631", "Eenhana",
"264651707", "Ehomba",
"264641724", "Swakopmund",
"264621762", "Rehoboth",
"26463220", "Keetmanshoop",
"264671768", "Etosha\ Rurtel",
"264672450", "Mangetti\ duin",
"264652641", "Eenhana",
"264632812", "Deurstamp",
"264673066", "Klein\ Waterberg",
"264662581", "Nkurenkuru",
"264632691", "Warmbad",
"264625703", "Witvlei",
"264625700", "Witvlei",
"26463297", "Noordoewer",
"264632501", "Gochas",
"264652482", "Onandjokwe",
"264647162", "Swakopmund",
"26465220", "Oshakati",
"264652636", "Eenhana",
"26463247", "Mariental",
"264625815", "Nouas",
"264652691", "Omungwelume",
"264652744", "Etanga",
"264661712", "Mpacha",
"26466255", "Rundu",
"264652646", "Oshikango",
"264673061", "Otjiwarongo",
"26466381", "Maltahohe",
"264662586", "Mashare",
"264632696", "Stinkdoring",
"264672291", "Etosha\ Rurtel",
"26467308", "Otjiwarongo",
"264651741", "Onandjokwe",
"264652547", "Oshikuku",
"26464221", "Walvis\ Bay",
"264631746", "Luderitz",
"264673329", "Kamanjab",
"264651731", "Okorosave",
"264641725", "Swakopmund",
"264621752", "Okahandja",
"264621771", "Hosea\ Kutako\ INT\ Airport",
"264652537", "Okalongo",
"264631736", "Keetmanshoop",
"264652459", "Oluno",
"264625814", "Nouas",
"264662674", "Rundu",
"264673051", "Waterberg\ Plateau\ Park",
"264641717", "Omaruru",
"26466256", "Rundu",
"264672296", "Etosha\ Rurtel\/Ongava",
"264652745", "Okangwati",
"264662508", "Ngoma",
"264651746", "Ondangwa",
"264662579", "Kahenge",
"264631731", "Karasburg",
"264651736", "Ombalantu",
"264652588", "Onesi",
"264625718", "Spatzenfeld",
"26463202", "Luderitz",
"264657165", "Oshakati",
"264637180", "Keetmanshoop",
"264632839", "Bethanie",
"264631753", "Mariental",
"264672583", "Andara",
"264645712", "Omaruru",
"264621747", "Namib\ Grens",
"264632389", "Luderitz\ \-\ Elizabeth\ Bay",
"26465240", "Ondangwa",
"26463227", "Keetmanshoop",
"264621737", "Friedental",
"264625617", "Summerdown",
"264652571", "Ogongo",
"264651777", "Ruacana",
"264632849", "Bethanie",
"26465290", "Eenhana",
"264673090", "Okaputa",
"264661704", "Bunia",
"264652622", "Okatope",
"264651753", "Ongha",
"264652663", "Oshikango",
"26467334", "Kamanjab",
"264652320", "Ongwediva",
"264631750", "Maltahohe",
"26465227", "Oshakati",
"264632660", "Klein\ Karas",
"264625682", "Plessisplaas",
"26467221", "Tsumeb",
"264671782", "Toshari",
"264631777", "Tsumispark",
"264637183", "Keetmanshoop",
"264652451", "Oshitayi",
"26464406", "Swakopmund",
"264677145", "Grootfontein",
"264652853", "Okashana",
"264641727", "Swakopmund",
"264651704", "Edundja",
"264652535", "Okalongo",
"264625602", "Omitara",
"264651739", "Omungwelume",
"26462500", "Okahandja",
"26463248", "Mariental",
"264652884", "Okongo",
"264673321", "Khorixas",
"264672299", "Mokuti",
"264657100", "Oshakati",
"264652545", "Oshikuku",
"264662576", "Rupara",
"264651749", "Onuno",
"264631704", "Ariamsvlei",
"264631739", "Keetmanshoop",
"264652456", "Oluno",
"264632309", "Oranjemund",
"264641715", "Omaruru",
"264652850", "Omutsewonime",
"264662571", "Ruuga",
"264652747", "Kaoko\ Otavi",
"264637100", "Keetmanshoop",
"264673326", "Kamanjab",
"264652595", "Etunda",
"264631749", "Maltahohe",
"264651775", "Panosa",
"26464274", "Walvis\ Bay",
"264652508", "Ombalantu",
"264621735", "Eland",
"264625615", "Steinhausen",
"264632261", "Keetmanshoop",
"264662597", "Sambyu",
"264632752", "Bralano",
"264652493", "Onathinge",
"264652440", "Omuthiya",
"264652648", "Oshikango",
"264632831", "Bethanie",
"264662588", "Nyangana",
"264642110", "Langstrand",
"26464273", "Walvis\ Bay",
"264632381", "Oranjemund",
"264672357", "Otavi",
"26467222", "Tsumeb",
"264631775", "Stinkdoring",
"26463201", "Luderitz",
"264671766", "Etosha\ Rurtel",
"264652752", "Ombombo",
"264652896", "Onyuulaye",
"264652490", "Onathinge",
"264673068", "Omatjene",
"264641702", "Henties\ Bay",
"26467300", "Otjiwarongo",
"264632386", "Oranjemund",
"26463235", "Oranjemund",
"264672327", "Maroelaboom",
"264625717", "Spatzenfeld",
"264641742", "Swakopmund",
"264652587", "Onesi",
"264673330", "Anker",
"264651781", "Tsandi",
"264632900", "Rosh\ Pinah",
"26467304", "Otjiwarongo",
"26462577", "Gobabis",
"264631710", "Bethanie",
"26464501", "Henties\ Bay",
"26467303", "Otjiwarongo",
"264671773", "Otjiwarongo",
"264661701", "Bagani",
"264645508", "Tsaobis\/Karibib",
"264632806", "Aroab",
"264641718", "Omaruru",
"264652598", "Eunda",
"264651713", "Etunda",
"264652801", "Ondangwa",
"264625673", "Epukiro",
"264671757", "Etosha\ Rurtel",
"264625434", "Hosea\ Kutako\ INT\ Airport",
"264651710", "Endola",
"26463232", "Oranjemund",
"264671770", "Otavi",
"264632403", "Mariental",
"264673333", "Biermanskool",
"26464270", "Walvis\ Bay",
"264661706", "K\.\ Murangi",
"264672315", "Rietfontein",
"264631713", "Dawiab",
"264632801", "Ariamsvlei",
"2646520", "Oshakati",
"264631734", "Karasburg",
"264631778", "Uhabis",
"264632505", "Seeheim",
"264625390", "Klein\ Aub",
"264631709", "Bethanie",
"264625811", "Leonardville",
"264631744", "Luderitz",
"264661723", "Rundu",
"264625692", "Leonardville",
"264637130", "Keetmanshoop",
"264662671", "Rundu",
"264673054", "Okorusu",
"264671792", "Waterberg\ Plateau\ Park",
"264673065", "Klein\ Waterberg",
"264637190", "Keetmanshoop",
"26462503", "Okahandja\/Ovitoto\/Wilhelmstal",
"264652635", "Eenhana",
"264651734", "Oluno",
"264651778", "Sesfontein",
"264651709", "Elim",
"264625618", "Summerdown",
"264625410", "Otjihase",
"264621738", "Gobabis",
"264644650", "Swakopmund",
"26464461", "Swakopmund",
"264661720", "Omega",
"264677029", "Grootfontein",
"264651744", "Ondangwa",
"264621748", "Nina",
"264652645", "Oshigambo",
"264672294", "Etosha\ Rurtel\/Halali",
"26462504", "Okahandja",
"264657130", "Oshakati",
"264625816", "Nina",
"264625393", "Rietoog",
"264671742", "Sorris\-Sorris",
"264651720", "Odibo",
"26463244", "Mariental",
"264652748", "Okorosave",
"264661709", "Katima\-Mulilo",
"264625800", "Epukiro",
"264652522", "Okahao",
"26463293", "Maltahohe\/Solitaire",
"264677163", "Otjiwarongo",
"264672616", "Uchab",
"264631762", "Oamseb",
"26467330", "Kamanjab",
"264652676", "Odibo",
"264625715", "Eland",
"264631723", "Hamab",
"26463243", "Mariental",
"264632384", "Oranjemund",
"264632809", "Ariamsvlei",
"264647026", "Walvis\ Bay",
"264631720", "Grenslyn",
"26465231", "Ongwediva",
"264637035", "Luderitz",
"264632522", "Asab",
"26464502", "Henties\ Bay",
"264625803", "Epukiro",
"264652652", "Oshikango",
"264652894", "Oshikunde",
"264667143", "Rundu",
"264651762", "Orumana",
"264641728", "Swakopmund",
"264671764", "Okorusu",
"264632264", "Deurstamp",
"26465243", "Ondangwa",
"264651723", "Ohangwena",
"264652560", "Etilyasa",
"264632712", "Karasburg",
"264662574", "Matava",
"264645537", "Karibib",
"26466266", "Rundu",
"264625420", "Groot\–Aub",
"264673067", "Klein\ Waterberg",
"264652886", "Ekoka",
"26464462", "Swakopmund",
"264661710", "Katima\-Mulilo",
"264625819", "Dordabis",
"264621763", "Rehoboth",
"264625702", "Witvlei",
"264651706", "Eenhana",
"264652688", "Endola",
"264631701", "Aminuis",
"264632507", "Narubis",
"264673324", "Sorris\-Sorris",
"264632810", "Köes",
"264672358", "Otavi",
"264652483", "Onandjokwe",
"264662587", "Mashare",
"264652647", "Oshikango",
"264652454", "Ongha",
"264661713", "Marangi",
"264631706", "Asab",
"264621760", "Plessisplaas",
"264651701", "Anamulenge",
"264652507", "Ombalantu",
"264652536", "Okalongo",
"26465223", "Oshakati",
"264631737", "Keetmanshoop",
"26465224", "Oshakati",
"264632307", "Oranjemund",
"264641711", "Langstrand",
"26463229", "Keetmanshoop",
"264652546", "Oshikuku",
"26466265", "Rundu",
"264662575", "Nzinze",
"264661708", "Katima\-Mulilo",
"264652749", "Orumana",
"264652591", "Mahenene",
"264631747", "Luderitz",
"264621750", "Okahandja",
"264652455", "Ongha",
"264625184", "Ombotozu",
"26463223", "Keetmanshoop",
"26464401", "Swakopmund",
"264652464", "Oluno",
"264677141", "Grootfontein",
"264641729", "Swakopmund",
"264652531", "Okahao",
"264651737", "Ombalantu",
"26466252", "Katima\-Mulilo",
"26462563", "Gobabis",
"264652601", "Ohangwena",
"26463224", "Keetmanshoop",
"264673325", "Sorris\-Sorris",
"264652596", "Etunda",
"264625733", "Nouas",
"26467230", "Oshivello",
"26462564", "Gobabis",
"264641716", "Omaruru",
"264672297", "Etosha\ Rurtel",
"264632808", "Kais",
"26464520", "Rössing\ Mine",
"264651747", "Ondangwa",
"264631752", "Mariental",
"264631771", "Schilp",
"264625680", "Drimiopsis",
"264645713", "Omaruru",
"26463251", "Gibeon",
"264651776", "Ruacana",
"264652689", "Endola",
"264625616", "Summerdown",
"264625818", "Dordabis",
"264652620", "Onuno",
"26463272", "Aranos",
"26464173", "Swakopmund",
"264662504", "Kongola",
"264621746", "Many\ Hills",
"264651752", "Ongenga",
"264651771", "Oshikuku",
"26463210", "Luderitz",
"264625611", "Otjiwa",
"26465251", "Ombalantu",
"264631776", "Tses",
"264662599", "Muhembo",
"264645520", "Karibib",
"264652623", "Okatope",
"264671765", "Omatjene",
"264672901", "Kalkfeld",
"264671754", "Lindequest",
"264632835", "Goageb",
"264671783", "Tsumeb",
"264637182", "Keetmanshoop",
"264632385", "Oranjemund",
"264672359", "Otavi",
"264621741", "Groot\–Aub",
"264637034", "Keetmanshoop",
"264645710", "Omaruru",
"264677150", "Grootfontein",
"264625683", "Plessisplaas",
"26463693", "South",
"264625603", "Omitara",
"264631745", "Luderitz",
"26464402", "Swakopmund",
"264673055", "Okorusu",
"26466385", "Namgorab",
"264673064", "Klein\ Waterberg",
"26466251", "Katima\-Mulilo",
"264647028", "Swakopmund",
"264652741", "Sodalite",
"264662577", "Muveke",
"264631735", "Keetmanshoop",
"264641726", "Swakopmund",
"264652644", "Oshigambo",
"264672295", "Etosha\ Rurtel\/Ombika",
"264652746", "Ohandungu",
"264651745", "Ondangwa",
"264673327", "Kamanjab",
"264651735", "Omafu",
"264652736", "Otjerunda",
"264652504", "Anamulenge",
"264641721", "Rössing\ Mine",
"264652634", "Eenhana",
"264671700", "Andara",
"264625600", "Seeis",
"264632731", "Aminuis",
"264652457", "Oluno",
"264652492", "Onathinge",
"264632753", "Bralano",
"264641700", "Arandis",
"264632942", "Kumakams",
"264672494", "Grootfontein",
"26462525", "Rehoboth",
"264652681", "Edundja",
"264632610", "Oamseb",
"264652750", "Otwani",
"264631779", "Warmbad",
"264662596", "Sambyu",
"26467312", "Outjo",
"264652753", "Warmquelle",
"264632492", "Mariental",
"264642112", "Langstrand",
"264652888", "Epembe",
"264632837", "Lorelei",
"264645214", "Rössing\ Mine",
"264632387", "Oranjemund",
"264625435", "Hosea\ Kutako\ INT\ Airport",
"264641703", "Henties\ Bay",
"264632267", "Feldschuhorn",
"264662591", "Bagani",
"264671767", "Etosha\ Rurtel",
"264632750", "Kalahariplaas",
"264621739", "Gobabis",
"264651708", "Elim",};
my $timezones = {
               '' => [
                       'Africa/Windhoek'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+264|\D)//g;
      my $self = bless({ country_code => '264', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '264', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;