=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ky - Package for language Kyrgyz

=cut

package Locale::CLDR::Locales::Ky;
# This file auto generated from Data\common\main\ky.xml
#	on Fri 13 Oct  9:24:58 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.2');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal','spellout-cardinal-verbose','spellout-ordinal','digits-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => HashRef,
	init_arg => undef,
	default => sub { 
		use bigfloat;
		return {
		'and' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(' жана =%spellout-cardinal-verbose=),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(' =%spellout-cardinal-verbose=),
				},
				'max' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(' =%spellout-cardinal-verbose=),
				},
			},
		},
		'commas' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(' жана =%spellout-cardinal-verbose=),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(, =%spellout-cardinal-verbose=),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(, ←%spellout-cardinal-verbose← миң[→%%commas→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(, =%spellout-cardinal-verbose=),
				},
				'max' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(, =%spellout-cardinal-verbose=),
				},
			},
		},
		'digits-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(−→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=#,##0==%%digits-ordinal-indicator=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=#,##0==%%digits-ordinal-indicator=),
				},
			},
		},
		'digits-ordinal-indicator' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(''инчи),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(''инчи),
				},
			},
		},
		'inci' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(инчи),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'ingci' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(иңчи),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'ncu' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нчы),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'ncy' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нчү),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нөл),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← бүтүн →%%z-spellout-fraction→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(бир),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(эки),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(үч),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(төрт),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(беш),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(алты),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(жети),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(сегиз),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(тогуз),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(он[ →→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(жыйырма[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(отуз[ →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(кырк[ →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(элүү[ →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(алтымыш[ →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(жетимиш[ →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(сексен[ →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(токсон[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(жүз),
				},
				'101' => {
					base_value => q(101),
					divisor => q(100),
					rule => q(←← жүз[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(←← жүз[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(миң),
				},
				'1001' => {
					base_value => q(1001),
					divisor => q(1000),
					rule => q(←← миң[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←← миң[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(миллион),
				},
				'1000001' => {
					base_value => q(1000001),
					divisor => q(1000000),
					rule => q(←← миллион[ →→]),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←← миллион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(миллиард),
				},
				'1000000001' => {
					base_value => q(1000000001),
					divisor => q(1000000000),
					rule => q(←← миллиард[ →→]),
				},
				'2000000000' => {
					base_value => q(2000000000),
					divisor => q(1000000000),
					rule => q(←← миллиард[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(триллион),
				},
				'1000000000001' => {
					base_value => q(1000000000001),
					divisor => q(1000000000000),
					rule => q(←← триллион[ →→]),
				},
				'2000000000000' => {
					base_value => q(2000000000000),
					divisor => q(1000000000000),
					rule => q(←← триллион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(квадриллион),
				},
				'1000000000000001' => {
					base_value => q(1000000000000001),
					divisor => q(1000000000000000),
					rule => q(←← квадриллион[ →→]),
				},
				'2000000000000000' => {
					base_value => q(2000000000000000),
					divisor => q(1000000000000000),
					rule => q(←← квадриллион[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-verbose' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← бүтүн →%%z-spellout-fraction→),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(жүз),
				},
				'101' => {
					base_value => q(101),
					divisor => q(100),
					rule => q(←← жүз[→%%and→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(←← жүз[→%%and→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(миң),
				},
				'1001' => {
					base_value => q(1001),
					divisor => q(1000),
					rule => q(←← миң[→%%and→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←← миң[→%%and→]),
				},
				'100000' => {
					base_value => q(100000),
					divisor => q(100000),
					rule => q(←← миң[→%%commas→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(миллион),
				},
				'1000001' => {
					base_value => q(1000001),
					divisor => q(1000000),
					rule => q(←← миллион[→%%commas→]),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←← миллион[→%%commas→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(миллиард),
				},
				'1000000001' => {
					base_value => q(1000000001),
					divisor => q(1000000000),
					rule => q(←← миллиард[→%%commas→]),
				},
				'2000000000' => {
					base_value => q(2000000000),
					divisor => q(1000000000),
					rule => q(←← миллиард[→%%commas→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(триллион),
				},
				'1000000000001' => {
					base_value => q(1000000000001),
					divisor => q(1000000000000),
					rule => q(←← триллион[→%%commas→]),
				},
				'2000000000000' => {
					base_value => q(2000000000000),
					divisor => q(1000000000000),
					rule => q(←← триллион[→%%commas→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(квадриллион),
				},
				'1000000000000001' => {
					base_value => q(1000000000000001),
					divisor => q(1000000000000000),
					rule => q(←← квадриллион[→%%commas→]),
				},
				'2000000000000000' => {
					base_value => q(2000000000000000),
					divisor => q(1000000000000000),
					rule => q(←← квадриллион[→%%commas→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нөлүнчү),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##0.#=),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(биринчи),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(экинчи),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(үчүнчү),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(төртүнчү),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(бешинчи),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(алтынчы),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(жетинчи),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(сегизинчи),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(тогузунчу),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(он→%%yncy→),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(жыйырма→%%ncu→),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(отуз→%%yncy→),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(кырк→%%uncu→),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(элүү→%%ncy→),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(алтымыш→%%uncu→),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(жетимиш→%%inci→),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(сексен→%%inci→),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(токсон→%%yncy→),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(жүзүнчү),
				},
				'101' => {
					base_value => q(101),
					divisor => q(100),
					rule => q(←%spellout-numbering← жүз→%%yncy2→),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(←%spellout-numbering← жүз→%%yncy2→),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(миңиңчи),
				},
				'1001' => {
					base_value => q(1001),
					divisor => q(1000),
					rule => q(←%spellout-numbering← миң→%%ingci→),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-numbering← миң→%%ingci→),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(миллионунчу),
				},
				'1000001' => {
					base_value => q(1000001),
					divisor => q(1000000),
					rule => q(←%spellout-numbering← миллион→%%yncy→),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←%spellout-numbering← миллион→%%yncy→),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(миллиардынчы),
				},
				'1000000001' => {
					base_value => q(1000000001),
					divisor => q(1000000000),
					rule => q(←%spellout-numbering← миллиард→%%uncu→),
				},
				'2000000000' => {
					base_value => q(2000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-numbering← миллиард→%%uncu→),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(триллионунчу),
				},
				'1000000000001' => {
					base_value => q(1000000000001),
					divisor => q(1000000000000),
					rule => q(←%spellout-numbering← триллион→%%yncy→),
				},
				'2000000000000' => {
					base_value => q(2000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-numbering← триллион→%%yncy→),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(квадриллионунчу),
				},
				'1000000000000001' => {
					base_value => q(1000000000000001),
					divisor => q(1000000000000000),
					rule => q(←%spellout-numbering← квадриллион→%%yncy→),
				},
				'2000000000000000' => {
					base_value => q(2000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-numbering← квадриллион→%%yncy→),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0='inci),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0='inci),
				},
			},
		},
		'uncu' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ынчы),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'yncy' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(унчу),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'yncy2' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(үнчү),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'z-spellout-fraction' => {
			'private' => {
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(ондон ←%spellout-numbering←),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(жүздөн ←%spellout-numbering←),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(миңден ←%spellout-numbering←),
				},
				'10000' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(он миңден ←%spellout-numbering←),
				},
				'100000' => {
					base_value => q(100000),
					divisor => q(100000),
					rule => q(жүз миңден ←%spellout-numbering←),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(миллиондон ←%spellout-numbering←),
				},
				'10000000' => {
					base_value => q(10000000),
					divisor => q(10000000),
					rule => q(он миллиондон ←%spellout-numbering←),
				},
				'100000000' => {
					base_value => q(100000000),
					divisor => q(100000000),
					rule => q(жүз миллиондон ←%spellout-numbering←),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(миллиарддан ←%spellout-numbering←),
				},
				'10000000000' => {
					base_value => q(10000000000),
					divisor => q(10000000000),
					rule => q(он миллиарддан ←%spellout-numbering←),
				},
				'100000000000' => {
					base_value => q(100000000000),
					divisor => q(100000000000),
					rule => q(жүз миллиарддан ←%spellout-numbering←),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(0* ←#,##0←←),
				},
				'max' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(0* ←#,##0←←),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'афарча',
 				'ab' => 'абхазча',
 				'ace' => 'ачехче',
 				'ada' => 'адаңмече',
 				'ady' => 'адыгейче',
 				'af' => 'африкаанча',
 				'agq' => 'агемче',
 				'ain' => 'айнуча',
 				'ak' => 'аканча',
 				'ale' => 'алеутча',
 				'alt' => 'түштүк алтайча',
 				'am' => 'амхарча',
 				'an' => 'арагончо',
 				'anp' => 'ангикача',
 				'ar' => 'арабча',
 				'ar_001' => 'азыркы адабий араб тилинде',
 				'arn' => 'мапучече',
 				'arp' => 'арапахочо',
 				'as' => 'ассамча',
 				'asa' => 'асуча',
 				'ast' => 'астурийче',
 				'av' => 'аварикче',
 				'awa' => 'авадхиче',
 				'ay' => 'аймарача',
 				'az' => 'азербайжанча',
 				'az@alt=short' => 'азерче',
 				'ba' => 'башкырча',
 				'ban' => 'баличе',
 				'bas' => 'басаача',
 				'be' => 'беларусча',
 				'bem' => 'бембача',
 				'bez' => 'бенача',
 				'bg' => 'болгарча',
 				'bgn' => 'чыгыш балучиче',
 				'bho' => 'бхожпуриче',
 				'bi' => 'бисламача',
 				'bin' => 'биниче',
 				'bla' => 'сиксикача',
 				'bm' => 'бамбарача',
 				'bn' => 'бангладешче',
 				'bo' => 'тибетче',
 				'br' => 'бретончо',
 				'brx' => 'бодочо',
 				'bs' => 'боснийче',
 				'bug' => 'бугийче',
 				'byn' => 'блинче',
 				'ca' => 'каталонча',
 				'ce' => 'чеченче',
 				'ceb' => 'себуанча',
 				'cgg' => 'чигача',
 				'ch' => 'чаморрочо',
 				'chk' => 'чуукиче',
 				'chm' => 'мариче',
 				'cho' => 'чокточо',
 				'chr' => 'черокиче',
 				'chy' => 'шайеннче',
 				'ckb' => 'борбордук курдча',
 				'co' => 'корсиканча',
 				'crs' => 'сеселва креол французча',
 				'cs' => 'чехче',
 				'cu' => 'чиркөө славянча',
 				'cv' => 'чувашча',
 				'cy' => 'уелшче',
 				'da' => 'датча',
 				'dak' => 'дакотача',
 				'dar' => 'даргинче',
 				'dav' => 'таитача',
 				'de' => 'немисче',
 				'de_CH' => 'адабий немисче (Швейцария)',
 				'dgr' => 'догрибче',
 				'dje' => 'зармача',
 				'dsb' => 'төмөнкү сорбианча',
 				'dua' => 'дуалача',
 				'dv' => 'дивехиче',
 				'dyo' => 'жола-фониче',
 				'dz' => 'жонгуча',
 				'dzg' => 'дазагача',
 				'ebu' => 'эмбуча',
 				'ee' => 'эбече',
 				'efi' => 'эфикче',
 				'eka' => 'экажукча',
 				'el' => 'грекче',
 				'en' => 'англисче',
 				'en_GB@alt=short' => 'англисче (УБ)',
 				'en_US' => 'англисче (Америка Кошмо Штаттары)',
 				'en_US@alt=short' => 'англисче (АКШ)',
 				'eo' => 'эсперанто',
 				'es' => 'испанча',
 				'es_ES' => 'испанча (Европа)',
 				'et' => 'эстончо',
 				'eu' => 'баскча',
 				'ewo' => 'эвондочо',
 				'fa' => 'фарсча',
 				'ff' => 'фулача',
 				'fi' => 'финче',
 				'fil' => 'филипинче',
 				'fj' => 'фижиче',
 				'fo' => 'фарерче',
 				'fon' => 'фончо',
 				'fr' => 'французча',
 				'fur' => 'фриулча',
 				'fy' => 'батыш фризче',
 				'ga' => 'ирландча',
 				'gaa' => 'гача',
 				'gag' => 'гагаузча',
 				'gan' => 'Гань Кытайча',
 				'gd' => 'шотладиялык гелча',
 				'gez' => 'гиизче',
 				'gil' => 'гилбертче',
 				'gl' => 'галисияча',
 				'gn' => 'гуараниче',
 				'gor' => 'горонталочо',
 				'gsw' => 'немисче (Швейцария)',
 				'gu' => 'гужаратча',
 				'guz' => 'гусиче',
 				'gv' => 'мэнксыча',
 				'gwi' => 'гвичинче',
 				'ha' => 'хаусача',
 				'hak' => 'Хакка кытайча',
 				'haw' => 'гавайча',
 				'he' => 'ивритче',
 				'hi' => 'хиндиче',
 				'hil' => 'хилигайнончо',
 				'hmn' => 'хмонгчо',
 				'hr' => 'хорватча',
 				'hsb' => 'жогорку сорбианча',
 				'hsn' => 'Сянь Кытайча',
 				'ht' => 'гаитиче',
 				'hu' => 'венгерче',
 				'hup' => 'хупача',
 				'hy' => 'армянча',
 				'hz' => 'герерочо',
 				'ia' => 'интерлингва',
 				'iba' => 'ибанча',
 				'ibb' => 'ибибиочо',
 				'id' => 'индонезияча',
 				'ig' => 'игбочо',
 				'ii' => 'сычуань йиче',
 				'ilo' => 'илокочо',
 				'inh' => 'ингушча',
 				'io' => 'идочо',
 				'is' => 'исландча',
 				'it' => 'италиянча',
 				'iu' => 'инуктитутча',
 				'ja' => 'жапончо',
 				'jbo' => 'ложбанча',
 				'jgo' => 'нгомбача',
 				'jmc' => 'мачамече',
 				'jv' => 'жаванизче',
 				'ka' => 'грузинче',
 				'kab' => 'кабылча',
 				'kac' => 'кахинче',
 				'kaj' => 'джуча',
 				'kam' => 'камбача',
 				'kbd' => 'кабардинче',
 				'kcg' => 'тяпча',
 				'kde' => 'макондече',
 				'kea' => 'кабувердиче',
 				'kfo' => 'корочо',
 				'kha' => 'хасиче',
 				'khq' => 'койра чиниче',
 				'ki' => 'кикуйиче',
 				'kj' => 'куаньямача',
 				'kk' => 'казакча',
 				'kkj' => 'какочо',
 				'kl' => 'калаалисутча',
 				'kln' => 'каленжиче',
 				'km' => 'кмерче',
 				'kmb' => 'кимбундуча',
 				'kn' => 'каннадача',
 				'ko' => 'корейче',
 				'koi' => 'коми-пермякча',
 				'kok' => 'конканиче',
 				'kpe' => 'кпеллече',
 				'kr' => 'кануриче',
 				'krc' => 'карачай-балкарча',
 				'krl' => 'карелче',
 				'kru' => 'курухча',
 				'ks' => 'кашмирче',
 				'ksb' => 'шамабалача',
 				'ksf' => 'бафияча',
 				'ksh' => 'колоньяча',
 				'ku' => 'курдча',
 				'kum' => 'кумыкча',
 				'kv' => 'комиче',
 				'kw' => 'корнишче',
 				'ky' => 'кыргызча',
 				'la' => 'латынча',
 				'lad' => 'ладиночо',
 				'lag' => 'лангиче',
 				'lb' => 'люксембургча',
 				'lez' => 'лезгинче',
 				'lg' => 'гандача',
 				'li' => 'лимбургиче',
 				'lkt' => 'лакотача',
 				'ln' => 'лингалача',
 				'lo' => 'лаочо',
 				'loz' => 'лозиче',
 				'lrc' => 'түндүк луриче',
 				'lt' => 'литовчо',
 				'lu' => 'луба-катангача',
 				'lua' => 'луба-лулуача',
 				'lun' => 'лундача',
 				'luo' => 'луочо',
 				'lus' => 'мизочо',
 				'luy' => 'лухияча',
 				'lv' => 'латышча',
 				'mad' => 'мадурисче',
 				'mag' => 'магахиче',
 				'mai' => 'маитиличе',
 				'mak' => 'макасарча',
 				'mas' => 'масайча',
 				'mdf' => 'мокшача',
 				'men' => 'мендече',
 				'mer' => 'меруча',
 				'mfe' => 'морисианча',
 				'mg' => 'малагасча',
 				'mgh' => 'макуача',
 				'mgo' => 'метача',
 				'mh' => 'маршаллча',
 				'mi' => 'маориче',
 				'mic' => 'микмакча',
 				'min' => 'минанкабауча',
 				'mk' => 'македончо',
 				'ml' => 'малайаламча',
 				'mn' => 'монголчо',
 				'mni' => 'манипуриче',
 				'moh' => 'мохаукча',
 				'mos' => 'моссиче',
 				'mr' => 'маратиче',
 				'ms' => 'малайча',
 				'mt' => 'малтизче',
 				'mua' => 'мундангча',
 				'mul' => 'бир нече тилде',
 				'mus' => 'крикче',
 				'mwl' => 'мирандизче',
 				'my' => 'бурмача',
 				'myv' => 'эрзянча',
 				'mzn' => 'мазандераниче',
 				'na' => 'науруча',
 				'nan' => 'nan',
 				'nap' => 'неополитанча',
 				'naq' => 'намача',
 				'nb' => 'норвежче (букмал)',
 				'nd' => 'түндүк ндыбелче',
 				'nds' => 'төмөнкү немисче',
 				'nds_NL' => 'төмөнкү саксончо',
 				'ne' => 'непалча',
 				'new' => 'невариче',
 				'ng' => 'ндонгача',
 				'nia' => 'ниасча',
 				'niu' => 'ньюанча',
 				'nl' => 'голландча',
 				'nl_BE' => 'фламандча',
 				'nmg' => 'квасиочо',
 				'nn' => 'норвежче (нинорск)',
 				'nnh' => 'нгимбунча',
 				'no' => 'норвежче',
 				'nog' => 'ногайча',
 				'nqo' => 'нкочо',
 				'nr' => 'түштүк ндебелече',
 				'nso' => 'түндүк соточо',
 				'nus' => 'нуерче',
 				'nv' => 'наваджочо',
 				'ny' => 'ньянджача',
 				'nyn' => 'ныйанколчо',
 				'oc' => 'окситанча',
 				'om' => 'оромочо',
 				'or' => 'орияча',
 				'os' => 'осетинче',
 				'pa' => 'пунжабиче',
 				'pag' => 'пангасиче',
 				'pam' => 'пампангача',
 				'pap' => 'папиаменточо',
 				'pau' => 'палауанча',
 				'pcm' => 'аргындашкан тил (Нигерия)',
 				'pl' => 'полякча',
 				'prg' => 'пруссча',
 				'ps' => 'пуштуча',
 				'pt' => 'португалча',
 				'pt_PT' => 'португалча (Европа)',
 				'qu' => 'кечуача',
 				'quc' => 'кичече',
 				'rap' => 'рапаньюча',
 				'rar' => 'раротонгача',
 				'rm' => 'романшча',
 				'rn' => 'рундиче',
 				'ro' => 'румынча',
 				'ro_MD' => 'молдованча',
 				'rof' => 'ромбочо',
 				'root' => 'түпкү',
 				'ru' => 'орусча',
 				'rup' => 'аромунча',
 				'rw' => 'руандача',
 				'rwk' => 'руача',
 				'sa' => 'санскритче',
 				'sad' => 'сандавече',
 				'sah' => 'сахача',
 				'saq' => 'самбуруча',
 				'sat' => 'санталиче',
 				'sba' => 'нгамбайча',
 				'sbp' => 'сангуча',
 				'sc' => 'сардинче',
 				'scn' => 'сицилийче',
 				'sco' => 'шотландча',
 				'sd' => 'синдхиче',
 				'sdh' => 'түштүк курдча',
 				'se' => 'түндүк саамиче',
 				'seh' => 'сенача',
 				'ses' => 'койраборо сенниче',
 				'sg' => 'сангочо',
 				'sh' => 'серб-хорват',
 				'shi' => 'ташелитче',
 				'shn' => 'шанча',
 				'si' => 'сингалача',
 				'sk' => 'словакча',
 				'sl' => 'словенче',
 				'sm' => 'самоанча',
 				'sma' => 'түштүк саамиче',
 				'smj' => 'луле саамиче',
 				'smn' => 'инари саамиче',
 				'sms' => 'сколт саамиче',
 				'sn' => 'шонача',
 				'snk' => 'сонинкече',
 				'so' => 'сомаличе',
 				'sq' => 'албанча',
 				'sr' => 'сербче',
 				'srn' => 'сранан тонгочо',
 				'ss' => 'сватиче',
 				'ssy' => 'сахочо',
 				'st' => 'сесоточо',
 				'su' => 'сунданча',
 				'suk' => 'сукумача',
 				'sv' => 'шведче',
 				'sw' => 'суахиличе',
 				'sw_CD' => 'конго суахаличе',
 				'swb' => 'коморчо',
 				'syr' => 'сирияча',
 				'ta' => 'тамилче',
 				'te' => 'телугуча',
 				'tem' => 'тимнече',
 				'teo' => 'тесочо',
 				'tet' => 'тетумча',
 				'tg' => 'тажикче',
 				'th' => 'тайча',
 				'ti' => 'тигриниача',
 				'tig' => 'тигрече',
 				'tk' => 'түркмөнчө',
 				'tlh' => 'клингончо',
 				'tn' => 'тсванача',
 				'to' => 'тонгача',
 				'tpi' => 'ток-писинче',
 				'tr' => 'түркчө',
 				'trv' => 'тарокочо',
 				'ts' => 'тсонгача',
 				'tt' => 'татарча',
 				'tum' => 'тумбукача',
 				'tvl' => 'тувалуча',
 				'tw' => 'тви',
 				'twq' => 'тасабакча',
 				'ty' => 'таитиче',
 				'tyv' => 'тувинче',
 				'tzm' => 'борбордук Атлас тамазигтче',
 				'udm' => 'удмуртча',
 				'ug' => 'уйгурча',
 				'uk' => 'украинче',
 				'umb' => 'умбундуча',
 				'und' => 'белгисиз тилде',
 				'ur' => 'урдуча',
 				'uz' => 'өзбекче',
 				'vai' => 'вайиче',
 				've' => 'вендача',
 				'vi' => 'вьетнамча',
 				'vo' => 'волапюкча',
 				'vun' => 'вунжочо',
 				'wa' => 'валлончо',
 				'wae' => 'валцерче',
 				'wal' => 'вольяттача',
 				'war' => 'варайча',
 				'wbp' => 'ворлпириче',
 				'wo' => 'уолофчо',
 				'wuu' => 'wuu',
 				'xal' => 'калмыкча',
 				'xh' => 'косача',
 				'xog' => 'согача',
 				'yav' => 'янгбенче',
 				'ybb' => 'йембача',
 				'yi' => 'идишче',
 				'yo' => 'йорубача',
 				'yue' => 'кантончо',
 				'zgh' => 'марокко тамазигт адабий тилинде',
 				'zh' => 'кытайча',
 				'zh_Hans' => 'кытайча (жөнөкөйлөштүрүлгөн)',
 				'zh_Hant' => 'кытайча (салттуу)',
 				'zu' => 'зулуча',
 				'zun' => 'зуниче',
 				'zxx' => 'тилдик мазмун жок',
 				'zza' => 'зазача',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'Араб',
 			'Armn' => 'Армян',
 			'Beng' => 'Бенгал',
 			'Bopo' => 'Бопомофо',
 			'Brai' => 'Брейл',
 			'Cyrl' => 'Кирилл',
 			'Deva' => 'Деванагари',
 			'Ethi' => 'Эфиоп',
 			'Geor' => 'Грузин',
 			'Grek' => 'Грек',
 			'Gujr' => 'Гужарати',
 			'Guru' => 'Гурмухи',
 			'Hanb' => 'Ханб',
 			'Hang' => 'Хангул',
 			'Hani' => 'Хань',
 			'Hans' => 'Жөнөкөйлөштүрүлгөн',
 			'Hans@alt=stand-alone' => 'Жөнөк. Хань',
 			'Hant' => 'Салттуу',
 			'Hant@alt=stand-alone' => 'Салттуу Хань',
 			'Hebr' => 'Иврит',
 			'Hira' => 'Хирагана',
 			'Hrkt' => 'Жапон силлабографиясы',
 			'Jamo' => 'Джамо',
 			'Jpan' => 'Жапан',
 			'Kana' => 'Катакана',
 			'Khmr' => 'Кмер',
 			'Knda' => 'Каннада',
 			'Kore' => 'Корей',
 			'Laoo' => 'Лао',
 			'Latn' => 'Латын',
 			'Mlym' => 'Малайалам',
 			'Mong' => 'Монгол',
 			'Mymr' => 'Мйанмар',
 			'Orya' => 'Орийа',
 			'Sinh' => 'Сингала',
 			'Taml' => 'Тамил',
 			'Telu' => 'Телу',
 			'Thaa' => 'Таана',
 			'Thai' => 'Тай',
 			'Tibt' => 'Тибет',
 			'Zmth' => 'Математикалык маани',
 			'Zsye' => 'Быйтыкча',
 			'Zsym' => 'Белгилер',
 			'Zxxx' => 'Жазылбаган',
 			'Zyyy' => 'Жалпы',
 			'Zzzz' => 'Белгисиз жазуу',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Дүйнө',
 			'002' => 'Африка',
 			'003' => 'Түндүк Америка',
 			'005' => 'Түштүк Америка',
 			'009' => 'Океания',
 			'011' => 'Батыш Африка',
 			'013' => 'Борбордук Америка',
 			'014' => 'Чыгыш Африка',
 			'015' => 'Түндүк Африка',
 			'017' => 'Борбордук Африка',
 			'018' => 'Түштүк Африка',
 			'019' => 'Америка',
 			'021' => 'Түндүк Америка (чөлкөм)',
 			'029' => 'Кариб аралдары',
 			'030' => 'Чыгыш Азия',
 			'034' => 'Түштүк Азия',
 			'035' => 'Түштүк-Чыгыш Азия',
 			'039' => 'Түштүк Европа',
 			'053' => 'Австралазия',
 			'054' => 'Меланезия',
 			'057' => 'Микронезия чөлкөмү',
 			'061' => 'Полинезия',
 			'142' => 'Азия',
 			'143' => 'Борбор Азия',
 			'145' => 'Батыш Азия',
 			'150' => 'Европа',
 			'151' => 'Чыгыш Европа',
 			'154' => 'Түндүк Европа',
 			'155' => 'Батыш Европа',
 			'202' => 'Африка өлкөлөрү',
 			'419' => 'Латын Америкасы',
 			'AC' => 'Вознесение аралы',
 			'AD' => 'Андорра',
 			'AE' => 'Бириккен Араб Эмираттары',
 			'AF' => 'Афганистан',
 			'AG' => 'Антигуа жана Барбуда',
 			'AI' => 'Ангилья',
 			'AL' => 'Албания',
 			'AM' => 'Армения',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктида',
 			'AR' => 'Аргентина',
 			'AS' => 'Америкалык Самоа',
 			'AT' => 'Австрия',
 			'AU' => 'Австралия',
 			'AW' => 'Аруба',
 			'AX' => 'Аланд аралдары',
 			'AZ' => 'Азербайжан',
 			'BA' => 'Босния жана Герцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Бельгия',
 			'BF' => 'Буркина-Фасо',
 			'BG' => 'Болгария',
 			'BH' => 'Бахрейн',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сент Бартелеми',
 			'BM' => 'Бермуд аралдары',
 			'BN' => 'Бруней',
 			'BO' => 'Боливия',
 			'BQ' => 'Кариб Нидерланддары',
 			'BR' => 'Бразилия',
 			'BS' => 'Багама аралдары',
 			'BT' => 'Бутан',
 			'BV' => 'Буве аралы',
 			'BW' => 'Ботсвана',
 			'BY' => 'Беларусь',
 			'BZ' => 'Белиз',
 			'CA' => 'Канада',
 			'CC' => 'Кокос (Килинг) аралдары',
 			'CD' => 'Конго-Киншаса',
 			'CD@alt=variant' => 'Конго (КДР)',
 			'CF' => 'Борбордук Африка Республикасы',
 			'CG' => 'Конго-Браззавил',
 			'CG@alt=variant' => 'Конго (Республикасы)',
 			'CH' => 'Швейцария',
 			'CI' => 'Кот-д’Ивуар',
 			'CI@alt=variant' => 'Пил сөөктүү жээк',
 			'CK' => 'Кук аралдары',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Кытай',
 			'CO' => 'Колумбия',
 			'CP' => 'Клиппертон аралы',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо-Верде',
 			'CW' => 'Кюрасао',
 			'CX' => 'Рождество аралы',
 			'CY' => 'Кипр',
 			'CZ' => 'Чехия',
 			'CZ@alt=variant' => 'Чех Республикасы',
 			'DE' => 'Германия',
 			'DG' => 'Диего Гарсия',
 			'DJ' => 'Джибути',
 			'DK' => 'Дания',
 			'DM' => 'Доминика',
 			'DO' => 'Доминика Республикасы',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута жана Мелилла',
 			'EC' => 'Эквадор',
 			'EE' => 'Эстония',
 			'EG' => 'Египет',
 			'EH' => 'Батыш Сахара',
 			'ER' => 'Эритрея',
 			'ES' => 'Испания',
 			'ET' => 'Эфиопия',
 			'EU' => 'Европа Биримдиги',
 			'EZ' => 'Еврозона',
 			'FI' => 'Финляндия',
 			'FJ' => 'Фиджи',
 			'FK' => 'Фолкленд аралдары',
 			'FK@alt=variant' => 'Фолкленд (Мальвина) аралдары',
 			'FM' => 'Микронезия',
 			'FO' => 'Фарер аралдары',
 			'FR' => 'Франция',
 			'GA' => 'Габон',
 			'GB' => 'Улуу Британия',
 			'GB@alt=short' => 'УБ',
 			'GD' => 'Гренада',
 			'GE' => 'Грузия',
 			'GF' => 'Француздук Гвиана',
 			'GG' => 'Гернси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренландия',
 			'GM' => 'Гамбия',
 			'GN' => 'Гвинея',
 			'GP' => 'Гваделупа',
 			'GQ' => 'Экватордук Гвинея',
 			'GR' => 'Греция',
 			'GS' => 'Түштүк Жоржия жана Түштүк Сэндвич аралдары',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинея-Бисау',
 			'GY' => 'Гайана',
 			'HK' => 'Гонконг Кытай ААА',
 			'HK@alt=short' => 'Гонконг',
 			'HM' => 'Херд жана Макдональд аралдары',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорватия',
 			'HT' => 'Гаити',
 			'HU' => 'Венгрия',
 			'IC' => 'Канар аралдары',
 			'ID' => 'Индонезия',
 			'IE' => 'Ирландия',
 			'IL' => 'Израиль',
 			'IM' => 'Мэн аралы',
 			'IN' => 'Индия',
 			'IO' => 'Инди океанындагы Британ территориясы',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исландия',
 			'IT' => 'Италия',
 			'JE' => 'Жерси',
 			'JM' => 'Ямайка',
 			'JO' => 'Иордания',
 			'JP' => 'Япония',
 			'KE' => 'Кения',
 			'KG' => 'Кыргызстан',
 			'KH' => 'Камбоджа',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморос',
 			'KN' => 'Сент-Китс жана Невис',
 			'KP' => 'Түндүк Корея',
 			'KR' => 'Түштүк Корея',
 			'KW' => 'Кувейт',
 			'KY' => 'Кайман аралдары',
 			'KZ' => 'Казакстан',
 			'LA' => 'Лаос',
 			'LB' => 'Ливан',
 			'LC' => 'Сент-Люсия',
 			'LI' => 'Лихтенштейн',
 			'LK' => 'Шри-Ланка',
 			'LR' => 'Либерия',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латвия',
 			'LY' => 'Ливия',
 			'MA' => 'Марокко',
 			'MC' => 'Монако',
 			'MD' => 'Молдова',
 			'ME' => 'Черногория',
 			'MF' => 'Сент-Мартин',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалл аралдары',
 			'MK' => 'Македония',
 			'MK@alt=variant' => 'Македония (Мур. Югосл.)',
 			'ML' => 'Мали',
 			'MM' => 'Мьянма (Бирма)',
 			'MN' => 'Монголия',
 			'MO' => 'Макау Кытай ААА',
 			'MO@alt=short' => 'Макау',
 			'MP' => 'Түндүк Мариана аралдары',
 			'MQ' => 'Мартиника',
 			'MR' => 'Мавритания',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Маврикий',
 			'MV' => 'Мальдив',
 			'MW' => 'Малави',
 			'MX' => 'Мексика',
 			'MY' => 'Малайзия',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибия',
 			'NC' => 'Жаңы Каледония',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолк аралы',
 			'NG' => 'Нигерия',
 			'NI' => 'Никарагуа',
 			'NL' => 'Нидерланд',
 			'NO' => 'Норвегия',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуэ',
 			'NZ' => 'Жаңы Зеландия',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Полинезия (франциялык)',
 			'PG' => 'Папуа-Жаңы Гвинея',
 			'PH' => 'Филиппин',
 			'PK' => 'Пакистан',
 			'PL' => 'Польша',
 			'PM' => 'Сен-Пьер жана Микелон',
 			'PN' => 'Питкэрн аралдары',
 			'PR' => 'Пуэрто-Рико',
 			'PS' => 'Палестина аймактары',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалия',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Катар',
 			'QO' => 'Алыскы Океания',
 			'RE' => 'Реюньон',
 			'RO' => 'Румыния',
 			'RS' => 'Сербия',
 			'RU' => 'Россия',
 			'RW' => 'Руанда',
 			'SA' => 'Сауд Арабиясы',
 			'SB' => 'Соломон аралдары',
 			'SC' => 'Сейшел аралдары',
 			'SD' => 'Судан',
 			'SE' => 'Швеция',
 			'SG' => 'Сингапур',
 			'SH' => 'Ыйык Елена',
 			'SI' => 'Словения',
 			'SJ' => 'Шпицберген жана Ян-Майен',
 			'SK' => 'Словакия',
 			'SL' => 'Сьерра-Леоне',
 			'SM' => 'Сан Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомали',
 			'SR' => 'Суринам',
 			'SS' => 'Түштүк Судан',
 			'ST' => 'Сан-Томе жана Принсипи',
 			'SV' => 'Эль-Сальвадор',
 			'SX' => 'Синт-Мартен',
 			'SY' => 'Сирия',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан-да-Кунья',
 			'TC' => 'Түркс жана Кайкос аралдары',
 			'TD' => 'Чад',
 			'TF' => 'Франциянын Түштүктөгү аймактары',
 			'TG' => 'Того',
 			'TH' => 'Тайланд',
 			'TJ' => 'Тажикстан',
 			'TK' => 'Токелау',
 			'TL' => 'Тимор-Лесте',
 			'TL@alt=variant' => 'Чыгыш Тимор',
 			'TM' => 'Түркмөнстан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Түркия',
 			'TT' => 'Тринидад жана Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайвань',
 			'TZ' => 'Танзания',
 			'UA' => 'Украина',
 			'UG' => 'Уганда',
 			'UM' => 'АКШнын сырткы аралдары',
 			'UN' => 'БУ',
 			'US' => 'Кошмо Штаттар',
 			'US@alt=short' => 'АКШ',
 			'UY' => 'Уругвай',
 			'UZ' => 'Өзбекстан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент-Винсент жана Гренадиндер',
 			'VE' => 'Венесуэла',
 			'VG' => 'Виргин аралдары (Британия)',
 			'VI' => 'Виргин аралдары (АКШ)',
 			'VN' => 'Вьетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уоллис жана Футуна',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Йемен',
 			'YT' => 'Майотта',
 			'ZA' => 'Түштүк-Африка Республикасы',
 			'ZM' => 'Замбия',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Белгисиз чөлкөм',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'Жылнаама',
 			'cf' => 'Валюта форматы',
 			'collation' => 'Иргөө тартиби',
 			'currency' => 'Валюта',
 			'hc' => 'Саат мерчеми (12/24)',
 			'lb' => 'Саптарды ажыратуу стили',
 			'ms' => 'Өлчөө тутуму',
 			'numbers' => 'Сандар',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{Будда жылнаамасы},
 				'chinese' => q{Кытай жылнаамасы},
 				'dangi' => q{Данги жылнаамасы},
 				'ethiopic' => q{Эфиоп жылнаамасы},
 				'gregorian' => q{Григориан жылнаамасы},
 				'hebrew' => q{Иврит жылнаамасы},
 				'islamic' => q{Ислам жылнаамасы},
 				'iso8601' => q{ИСО-8601 жылнаамасы},
 				'japanese' => q{Жапон жылнаамасы},
 				'persian' => q{Перс жылнаамасы},
 				'roc' => q{Мингуо жылнаамасы},
 			},
 			'cf' => {
 				'account' => q{Эсептешүү валютасынын форматы},
 				'standard' => q{Стандарттык валюта форматы},
 			},
 			'collation' => {
 				'ducet' => q{Демейки Unicode иргөө тартиби},
 				'search' => q{Жалпы издөө},
 				'standard' => q{Стандарттык иргөө тартиби},
 			},
 			'd0' => {
 				'fwidth' => q{Кең формат},
 				'hwidth' => q{Кыска формат},
 				'npinyin' => q{Сандык},
 			},
 			'hc' => {
 				'h11' => q{12 сааттык тутум (0–11)},
 				'h12' => q{12 сааттык тутум (1–12)},
 				'h23' => q{24 сааттык тутум (0–23)},
 				'h24' => q{24 сааттык тутум (1–24)},
 			},
 			'lb' => {
 				'loose' => q{Саптардын арасы кенен},
 				'normal' => q{Саптардын арасы орточо},
 				'strict' => q{Саптардын арасы тыкыс},
 			},
 			'ms' => {
 				'metric' => q{Метрикалык тутум},
 				'uksystem' => q{Британ империясынын өлчөө тутуму},
 				'ussystem' => q{АКШ өлчөө тутуму},
 			},
 			'numbers' => {
 				'arab' => q{Араб-индус сандары},
 				'arabext' => q{Кеңейтилген араб-индус сандары},
 				'armn' => q{Армян сандары},
 				'armnlow' => q{Армян сандары (кичинекей арип менен)},
 				'beng' => q{Бенгали сандары},
 				'deva' => q{Деванагари сандары},
 				'ethi' => q{Эфиоп сандары},
 				'fullwide' => q{Толук эндүү сандар},
 				'geor' => q{Грузин сандары},
 				'grek' => q{Грек сандары},
 				'greklow' => q{Грек сандары (кичинекей арип менен)},
 				'gujr' => q{Гужарати сандары},
 				'guru' => q{Гужарати сандары},
 				'hanidec' => q{Кытай ондук сандары},
 				'hans' => q{Жөнөкөйлөштүрүлгөн кытай сандары},
 				'hansfin' => q{Жөнөкөйлөштүрүлгөн кытай каржы сандары},
 				'hant' => q{Салттуу кытай сандары},
 				'hantfin' => q{Салттуу кытай каржы сандары},
 				'hebr' => q{Иврит сандары},
 				'jpan' => q{Жапон сандары},
 				'jpanfin' => q{Жапон каржы сандары},
 				'khmr' => q{Кмер сандары},
 				'knda' => q{Каннада сандары},
 				'laoo' => q{Лао сандары},
 				'latn' => q{Батыш сандары},
 				'mlym' => q{Малайалам сандары},
 				'mymr' => q{Мйанмар сандары},
 				'orya' => q{Ория сандары},
 				'roman' => q{Роман сандары},
 				'romanlow' => q{Роман сандары (кичинекей арип менен)},
 				'taml' => q{Салттуу тамил сандары},
 				'tamldec' => q{Тамил сандары},
 				'telu' => q{Телугу сандары},
 				'thai' => q{Тай сандары},
 				'tibt' => q{Тибет сандары},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{Метрикалык өлчөө тутуму},
 			'UK' => q{Британия},
 			'US' => q{АКШ},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'Тили: {0}',
 			'script' => 'Жазуусу: {0}',
 			'region' => 'Аймагы: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[в ф ц щ ь]},
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'Ң', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ү', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'],
			main => qr{[а б г д е ё ж з и й к л м н ң о ө п р с т у ү х ч ш ъ ы э ю я]},
			numbers => qr{[  \- , % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[\- ‐ – — , ; \: ! ? . … ' ‘ ‚ " “ „ « » ( ) \[ \] \{ \} § @ * / \& #]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'Ң', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ү', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{„},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'' => {
						'name' => q(негизги багыт),
					},
					'acre' => {
						'name' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'acre-foot' => {
						'name' => q(акр-фут),
						'one' => q({0} акр-фут),
						'other' => q({0} акр-фут),
					},
					'ampere' => {
						'name' => q(ампер),
						'one' => q({0} ампер),
						'other' => q({0} ампер),
					},
					'arc-minute' => {
						'name' => q(аркмүнөт),
						'one' => q({0} аркмүнөт),
						'other' => q({0} аркмүнөт),
					},
					'arc-second' => {
						'name' => q(арксекунд),
						'one' => q({0} арксекунд),
						'other' => q({0} арксекунд),
					},
					'astronomical-unit' => {
						'name' => q(астрономиялык бирдик),
						'one' => q({0} астрономиялык бирдик),
						'other' => q({0} астрономиялык бирдик),
					},
					'atmosphere' => {
						'name' => q(атмосфера),
						'one' => q({0} атмосфера),
						'other' => q({0} атм),
					},
					'bit' => {
						'name' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					'byte' => {
						'name' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					'calorie' => {
						'name' => q(калория),
						'one' => q({0} калория),
						'other' => q({0} калория),
					},
					'carat' => {
						'name' => q(карат),
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					'celsius' => {
						'name' => q(Цельсий градусу),
						'one' => q({0} Цельсий градусу),
						'other' => q({0} Цельсий градусу),
					},
					'centiliter' => {
						'name' => q(сантилитр),
						'one' => q({0} сантилитр),
						'other' => q({0} сантилитр),
					},
					'centimeter' => {
						'name' => q(сантиметр),
						'one' => q({0} сантиметр),
						'other' => q({0} сантиметр),
						'per' => q(сантиметрине {0}),
					},
					'century' => {
						'name' => q(кылым),
						'one' => q({0} кылым),
						'other' => q({0} кылым),
					},
					'coordinate' => {
						'east' => q({0}Ч),
						'north' => q({0}Тн),
						'south' => q({0}Тш),
						'west' => q({0}Б),
					},
					'cubic-centimeter' => {
						'name' => q(куб сантиметр),
						'one' => q({0} куб сантиметр),
						'other' => q({0} куб сантиметр),
						'per' => q(куб сантиметрине {0}),
					},
					'cubic-foot' => {
						'name' => q(куб фут),
						'one' => q({0} куб фут),
						'other' => q({0} куб фут),
					},
					'cubic-inch' => {
						'name' => q(куб дюйм),
						'one' => q({0} куб дюйм),
						'other' => q({0} куб дюйм),
					},
					'cubic-kilometer' => {
						'name' => q(куб километр),
						'one' => q({0} куб километр),
						'other' => q({0} куб километр),
					},
					'cubic-meter' => {
						'name' => q(куб метр),
						'one' => q({0} куб метр),
						'other' => q({0} куб метр),
						'per' => q(куб метрине {0}),
					},
					'cubic-mile' => {
						'name' => q(куб миля),
						'one' => q({0} куб миля),
						'other' => q({0} куб миля),
					},
					'cubic-yard' => {
						'name' => q(куб ярд),
						'one' => q({0} куб ярд),
						'other' => q({0} куб ярд),
					},
					'cup' => {
						'name' => q(чөйчөк),
						'one' => q({0} чөйчөк),
						'other' => q({0} чөйчөк),
					},
					'cup-metric' => {
						'name' => q(mcup),
						'one' => q({0} mc),
						'other' => q({0} mc),
					},
					'day' => {
						'name' => q(күн),
						'one' => q({0} күн),
						'other' => q({0} күн),
						'per' => q(күнүнө {0}),
					},
					'deciliter' => {
						'name' => q(децилитр),
						'one' => q({0} децилитр),
						'other' => q({0} децилитр),
					},
					'decimeter' => {
						'name' => q(дециметр),
						'one' => q({0} дециметр),
						'other' => q({0} дециметр),
					},
					'degree' => {
						'name' => q(градус),
						'one' => q({0} градус),
						'other' => q({0} градус),
					},
					'fahrenheit' => {
						'name' => q(Фаренгейт градусу),
						'one' => q({0} Фаренгейт градусу),
						'other' => q({0} Фаренгейт градусу),
					},
					'fluid-ounce' => {
						'name' => q(суюк унция),
						'one' => q({0} суюк унция),
						'other' => q({0} суюк унция),
					},
					'foodcalorie' => {
						'name' => q(Калория),
						'one' => q({0} Калория),
						'other' => q({0} Калория),
					},
					'foot' => {
						'name' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
						'per' => q(футуна {0}),
					},
					'g-force' => {
						'name' => q(оордук күчүнүн ылдамдануусу),
						'one' => q({0} оордук күчү),
						'other' => q({0} оордук күчү),
					},
					'gallon' => {
						'name' => q(галлон),
						'one' => q({0} галлон),
						'other' => q({0} галлон),
						'per' => q(галлонуна {0}),
					},
					'gallon-imperial' => {
						'name' => q(англ. галлону),
						'one' => q({0} англ. галлону),
						'other' => q({0} англ. галлону),
						'per' => q(англ. галлонуна {0}),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(гигабит),
						'one' => q({0} гигабит),
						'other' => q({0} гигабит),
					},
					'gigabyte' => {
						'name' => q(гигабайт),
						'one' => q({0} гигабайт),
						'other' => q({0} гигабайт),
					},
					'gigahertz' => {
						'name' => q(гигагерц),
						'one' => q({0} гигагерц),
						'other' => q({0} гигагерц),
					},
					'gigawatt' => {
						'name' => q(гигаватт),
						'one' => q({0} гигаватт),
						'other' => q({0} гигаватт),
					},
					'gram' => {
						'name' => q(грамм),
						'one' => q({0} грамм),
						'other' => q({0} грамм),
						'per' => q(граммына {0}),
					},
					'hectare' => {
						'name' => q(гектар),
						'one' => q({0} гектар),
						'other' => q({0} гектар),
					},
					'hectoliter' => {
						'name' => q(гектолитр),
						'one' => q({0} гектолитр),
						'other' => q({0} гектолитр),
					},
					'hectopascal' => {
						'name' => q(гектопаскаль),
						'one' => q({0} гектопаскаль),
						'other' => q({0} гектопаскаль),
					},
					'hertz' => {
						'name' => q(герц),
						'one' => q({0} герц),
						'other' => q({0} герц),
					},
					'horsepower' => {
						'name' => q(аттын күчү),
						'one' => q({0} аттын күчү),
						'other' => q({0} аттын күчү),
					},
					'hour' => {
						'name' => q(саат),
						'one' => q({0} саат),
						'other' => q({0} саат),
						'per' => q(саатына {0}),
					},
					'inch' => {
						'name' => q(дюйм),
						'one' => q({0} дюйм),
						'other' => q({0} дюйм),
						'per' => q(дюймуна {0}),
					},
					'inch-hg' => {
						'name' => q(дюйм сымап мамычасы),
						'one' => q({0} дюйм сымап мамычасы),
						'other' => q({0} дюйм сымап мамычасы),
					},
					'joule' => {
						'name' => q(жоул),
						'one' => q({0} жоул),
						'other' => q({0} жоул),
					},
					'karat' => {
						'name' => q(карат),
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					'kelvin' => {
						'name' => q(Келвин градусу),
						'one' => q({0} Келвин градусу),
						'other' => q({0} Келвин градусу),
					},
					'kilobit' => {
						'name' => q(килобит),
						'one' => q({0} килобит),
						'other' => q({0} килобит),
					},
					'kilobyte' => {
						'name' => q(килобайт),
						'one' => q({0} килобайт),
						'other' => q({0} килобайт),
					},
					'kilocalorie' => {
						'name' => q(килокалория),
						'one' => q({0} килокалория),
						'other' => q({0} килокалория),
					},
					'kilogram' => {
						'name' => q(килограмм),
						'one' => q({0} килограмм),
						'other' => q({0} килограмм),
						'per' => q(килограммына {0}),
					},
					'kilohertz' => {
						'name' => q(килогерц),
						'one' => q({0} килогерц),
						'other' => q({0} килогерц),
					},
					'kilojoule' => {
						'name' => q(киложоул),
						'one' => q({0} киложоул),
						'other' => q({0} киложоул),
					},
					'kilometer' => {
						'name' => q(километр),
						'one' => q({0} километр),
						'other' => q({0} километр),
						'per' => q(километрине {0}),
					},
					'kilometer-per-hour' => {
						'name' => q(саатына километр),
						'one' => q(саатына {0} километр),
						'other' => q(саатына {0} километр),
					},
					'kilowatt' => {
						'name' => q(киловатт),
						'one' => q({0} киловатт),
						'other' => q({0} киловатт),
					},
					'kilowatt-hour' => {
						'name' => q(килловат-саат),
						'one' => q({0} килловат-саат),
						'other' => q({0} килловат-саат),
					},
					'knot' => {
						'name' => q(түйүн),
						'one' => q({0} түйүн),
						'other' => q({0} түйүн),
					},
					'light-year' => {
						'name' => q(жарык жыл),
						'one' => q({0} жарык жыл),
						'other' => q({0} жарык жыл),
					},
					'liter' => {
						'name' => q(литр),
						'one' => q({0} литр),
						'other' => q({0} литр),
						'per' => q(литрине {0}),
					},
					'liter-per-100kilometers' => {
						'name' => q(100 километрге литр),
						'one' => q(100 километрге {0} литр),
						'other' => q(100 километрге {0} литр),
					},
					'liter-per-kilometer' => {
						'name' => q(километрине литр),
						'one' => q(километрине {0} литр),
						'other' => q(километрине {0} литр),
					},
					'lux' => {
						'name' => q(люкс),
						'one' => q({0} люкс),
						'other' => q({0} люкс),
					},
					'megabit' => {
						'name' => q(мегабит),
						'one' => q({0} мегабит),
						'other' => q({0} мегабит),
					},
					'megabyte' => {
						'name' => q(мегабайт),
						'one' => q({0} мегабайт),
						'other' => q({0} мегабайт),
					},
					'megahertz' => {
						'name' => q(мегагерц),
						'one' => q({0} мегагерц),
						'other' => q({0} мегагерц),
					},
					'megaliter' => {
						'name' => q(мегалитр),
						'one' => q({0} мегалитр),
						'other' => q({0} мегалитр),
					},
					'megawatt' => {
						'name' => q(мегаватт),
						'one' => q({0} мегаватт),
						'other' => q({0} мегаватт),
					},
					'meter' => {
						'name' => q(метр),
						'one' => q({0} метр),
						'other' => q({0} метр),
						'per' => q(метрине {0}),
					},
					'meter-per-second' => {
						'name' => q(секундасына метр),
						'one' => q(секундасына {0} метр),
						'other' => q(секундасына {0} метр),
					},
					'meter-per-second-squared' => {
						'name' => q(квадраттык секундасына метр),
						'one' => q(квадраттык секундасына {0} метр),
						'other' => q(квадраттык секундасына {0} метр),
					},
					'metric-ton' => {
						'name' => q(метр тонна),
						'one' => q({0} метр тонна),
						'other' => q({0} метр тонна),
					},
					'microgram' => {
						'name' => q(микрограмм),
						'one' => q({0} микрограмм),
						'other' => q({0} микрограмм),
					},
					'micrometer' => {
						'name' => q(микрометр),
						'one' => q(микрометр),
						'other' => q({0} микрометр),
					},
					'microsecond' => {
						'name' => q(микросекунд),
						'one' => q({0} микросекунд),
						'other' => q({0} микросекунд),
					},
					'mile' => {
						'name' => q(миля),
						'one' => q({0} миля),
						'other' => q({0} миля),
					},
					'mile-per-gallon' => {
						'name' => q(миляга/галлон),
						'one' => q({0} миляга/галлон),
						'other' => q({0} миляга/галлон),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(англ. галлонуна миля),
						'one' => q(англ. галлонуна {0} миля),
						'other' => q(англ. галлонуна {0} миля),
					},
					'mile-per-hour' => {
						'name' => q(саатына миля),
						'one' => q(саатына {0} миля),
						'other' => q(саатына {0} миля),
					},
					'mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					'milliampere' => {
						'name' => q(миллиампер),
						'one' => q({0} миллиампер),
						'other' => q({0} миллиампер),
					},
					'millibar' => {
						'name' => q(миллибар),
						'one' => q({0} миллибар),
						'other' => q({0} миллибар),
					},
					'milligram' => {
						'name' => q(миллиграмм),
						'one' => q({0} миллиграмм),
						'other' => q({0} миллиграмм),
					},
					'milligram-per-deciliter' => {
						'name' => q(децилитрга миллиграмм),
						'one' => q(децилитрга {0} миллиграмм),
						'other' => q(децилитрга {0} миллиграмм),
					},
					'milliliter' => {
						'name' => q(миллилитр),
						'one' => q({0} миллилитр),
						'other' => q({0} миллилитр),
					},
					'millimeter' => {
						'name' => q(миллиметр),
						'one' => q({0} миллиметр),
						'other' => q({0} миллиметр),
					},
					'millimeter-of-mercury' => {
						'name' => q(миллиметр сымап мамычасы),
						'one' => q({0} миллиметр сымап мамычасы),
						'other' => q({0} миллиметр сымап мамычасы),
					},
					'millimole-per-liter' => {
						'name' => q(литрине миллимоль),
						'one' => q(литрине {0} миллимоль),
						'other' => q(литрине {0} миллимоль),
					},
					'millisecond' => {
						'name' => q(миллисекунд),
						'one' => q({0} миллисекунд),
						'other' => q({0} миллисекунд),
					},
					'milliwatt' => {
						'name' => q(милливатт),
						'one' => q({0} милливатт),
						'other' => q({0} милливатт),
					},
					'minute' => {
						'name' => q(мүнөт),
						'one' => q({0} мүнөт),
						'other' => q({0} мүнөт),
						'per' => q(мүнөтүнө {0}),
					},
					'month' => {
						'name' => q(ай),
						'one' => q({0} ай),
						'other' => q({0} ай),
						'per' => q(айына {0}),
					},
					'nanometer' => {
						'name' => q(нанометр),
						'one' => q({0} нанометр),
						'other' => q({0} нанометр),
					},
					'nanosecond' => {
						'name' => q(наносекунд),
						'one' => q({0} наносекунд),
						'other' => q({0} наносекунд),
					},
					'nautical-mile' => {
						'name' => q(деңиз милясы),
						'one' => q({0} деңиз милясы),
						'other' => q({0} деңиз милясы),
					},
					'ohm' => {
						'name' => q(ом),
						'one' => q({0} ом),
						'other' => q({0} ом),
					},
					'ounce' => {
						'name' => q(унция),
						'one' => q({0} унция),
						'other' => q({0} унция),
						'per' => q(унциясына {0}),
					},
					'ounce-troy' => {
						'name' => q(троя унциясы),
						'one' => q({0} троя унциясы),
						'other' => q({0} троя унциясы),
					},
					'parsec' => {
						'name' => q(парсек),
						'one' => q({0} парсек),
						'other' => q({0} парсек),
					},
					'part-per-million' => {
						'name' => q(миллионго бөлүктөр),
						'one' => q(миллионго {0} бөлүк),
						'other' => q(миллионго {0} бөлүк),
					},
					'per' => {
						'1' => q({1}/{0}),
					},
					'percent' => {
						'name' => q(пайыз),
						'one' => q({0} пайыз),
						'other' => q({0} пайыз),
					},
					'permille' => {
						'name' => q(промилле),
						'one' => q({0} промилле),
						'other' => q({0} промилле),
					},
					'petabyte' => {
						'name' => q(петабайт),
						'one' => q({0} петабайт),
						'other' => q({0} ПТБ),
					},
					'picometer' => {
						'name' => q(пикометр),
						'one' => q({0} пикометр),
						'other' => q({0} пикометр),
					},
					'pint' => {
						'name' => q(пинта),
						'one' => q({0} пинта),
						'other' => q({0} пинта),
					},
					'pint-metric' => {
						'name' => q(метрикалык пинта),
						'one' => q({0} метрикалык пинта),
						'other' => q({0} метрикалык пинта),
					},
					'point' => {
						'name' => q(чекиттер),
						'one' => q({0} чекит),
						'other' => q({0} чекит),
					},
					'pound' => {
						'name' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
						'per' => q(фунтуна {0}),
					},
					'pound-per-square-inch' => {
						'name' => q(чарчы дюймга фунт),
						'one' => q(чарчы дюймга {0} фунт),
						'other' => q(чарчы дюймга {0} фунт),
					},
					'quart' => {
						'name' => q(кварта),
						'one' => q({0} кварта),
						'other' => q({0} кварта),
					},
					'radian' => {
						'name' => q(радиан),
						'one' => q({0} радиан),
						'other' => q({0} радиан),
					},
					'revolution' => {
						'name' => q(rev),
						'one' => q({0} rev),
						'other' => q({0} rev),
					},
					'second' => {
						'name' => q(секунд),
						'one' => q({0} секунд),
						'other' => q({0} секунд),
						'per' => q(секундуна {0}),
					},
					'square-centimeter' => {
						'name' => q(чарчы сантиметр),
						'one' => q({0} чарчы сантиметр),
						'other' => q({0} чарчы сантиметр),
						'per' => q(чарчы сантиметрине {0}),
					},
					'square-foot' => {
						'name' => q(чарчы фут),
						'one' => q({0} чарчы фут),
						'other' => q({0} чарчы фут),
					},
					'square-inch' => {
						'name' => q(чарчы дюйм),
						'one' => q({0} чарчы дюйм),
						'other' => q({0} чарчы дюйм),
						'per' => q(чарчы дюймуна {0}),
					},
					'square-kilometer' => {
						'name' => q(чарчы километр),
						'one' => q({0} чарчы километр),
						'other' => q({0} чарчы километр),
						'per' => q(чарчы километрине {0}),
					},
					'square-meter' => {
						'name' => q(чарчы метр),
						'one' => q({0} чарчы метр),
						'other' => q({0} чарчы метр),
						'per' => q(чарчы метрине {0}),
					},
					'square-mile' => {
						'name' => q(чарчы миля),
						'one' => q({0} чарчы миля),
						'other' => q({0} чарчы миля),
						'per' => q(чарчы милясына {0}),
					},
					'square-yard' => {
						'name' => q(чарчы ярд),
						'one' => q({0} чарчы ярд),
						'other' => q({0} чарчы ярд),
					},
					'tablespoon' => {
						'name' => q(чоң кашык),
						'one' => q({0} чоң кашык),
						'other' => q({0} чоң кашык),
					},
					'teaspoon' => {
						'name' => q(чай кашык),
						'one' => q({0} чай кашык),
						'other' => q({0} чай кашык),
					},
					'terabit' => {
						'name' => q(терабит),
						'one' => q({0} терабит),
						'other' => q({0} терабит),
					},
					'terabyte' => {
						'name' => q(терабайт),
						'one' => q({0} терабайт),
						'other' => q({0} терабайт),
					},
					'ton' => {
						'name' => q(тонна),
						'one' => q({0} тонна),
						'other' => q({0} тонна),
					},
					'volt' => {
						'name' => q(вольт),
						'one' => q({0} вольт),
						'other' => q({0} вольт),
					},
					'watt' => {
						'name' => q(ватт),
						'one' => q({0} ватт),
						'other' => q({0} ватт),
					},
					'week' => {
						'name' => q(апта),
						'one' => q({0} апта),
						'other' => q({0} апта),
						'per' => q(аптасына {0}),
					},
					'yard' => {
						'name' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'name' => q(жыл),
						'one' => q({0} жыл),
						'other' => q({0} жыл),
						'per' => q(жылына {0}),
					},
				},
				'narrow' => {
					'' => {
						'name' => q(багыт),
					},
					'acre' => {
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'name' => q(°C),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
					},
					'coordinate' => {
						'east' => q({0}Ч),
						'north' => q({0}Тн),
						'south' => q({0}Тш),
						'west' => q({0}Б),
					},
					'cubic-kilometer' => {
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-mile' => {
						'one' => q({0} чак³),
						'other' => q({0} чак³),
					},
					'day' => {
						'name' => q(күн),
						'one' => q({0} кн),
						'other' => q({0} кн),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} фут),
						'other' => q({0} фут),
					},
					'g-force' => {
						'one' => q({0} о.к.),
						'other' => q({0} о.к.),
					},
					'gram' => {
						'name' => q(грамм),
						'one' => q({0} гр),
						'other' => q({0} гр),
					},
					'hectare' => {
						'one' => q({0} га),
						'other' => q({0} га),
					},
					'hectopascal' => {
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					'horsepower' => {
						'one' => q({0} ат),
						'other' => q({0} ат),
					},
					'hour' => {
						'name' => q(саат),
						'one' => q({0} ст),
						'other' => q({0} ст),
					},
					'inch' => {
						'one' => q({0} д),
						'other' => q({0} д),
					},
					'inch-hg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'name' => q(килограмм),
						'one' => q({0} кг),
						'other' => q({0} кг),
					},
					'kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
					},
					'kilometer-per-hour' => {
						'name' => q(км/саат),
						'one' => q({0} км/с),
						'other' => q({0} км/с),
					},
					'kilowatt' => {
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					'light-year' => {
						'one' => q({0} жар.ж.),
						'other' => q({0} жар.ж.),
					},
					'liter' => {
						'name' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
					},
					'liter-per-100kilometers' => {
						'name' => q(100 км/л),
						'one' => q({0} л/100км),
						'other' => q({0} л/100км),
					},
					'meter' => {
						'name' => q(метр),
						'one' => q({0}м),
						'other' => q({0}м),
					},
					'meter-per-second' => {
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					'mile' => {
						'one' => q({0} чак),
						'other' => q({0} чак),
					},
					'mile-per-hour' => {
						'one' => q({0} чак/с),
						'other' => q({0} чак/с),
					},
					'millibar' => {
						'one' => q({0} мб),
						'other' => q({0} мб),
					},
					'millimeter' => {
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millisecond' => {
						'name' => q(миллисек),
						'one' => q({0} мсек),
						'other' => q({0} мсек),
					},
					'minute' => {
						'name' => q(мүн),
						'one' => q({0} мүн),
						'other' => q({0} мүн),
					},
					'month' => {
						'name' => q(ай),
						'one' => q({0} ай),
						'other' => q({0} ай),
					},
					'ounce' => {
						'one' => q({0} унция),
						'other' => q({0} унция),
					},
					'per' => {
						'1' => q({1}/{0}),
					},
					'percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'picometer' => {
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pound' => {
						'one' => q({0} фунт),
						'other' => q({0} фунт),
					},
					'second' => {
						'name' => q(сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
					},
					'square-foot' => {
						'one' => q({0} фут²),
						'other' => q({0} фут²),
					},
					'square-kilometer' => {
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'one' => q({0} м²),
						'other' => q({0} м²),
					},
					'square-mile' => {
						'one' => q({0} чак²),
						'other' => q({0} чак²),
					},
					'watt' => {
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					'week' => {
						'name' => q(апт),
						'one' => q({0} ап),
						'other' => q({0} ап),
					},
					'yard' => {
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'name' => q(жыл),
						'one' => q({0} ж.),
						'other' => q({0} ж.),
					},
				},
				'short' => {
					'' => {
						'name' => q(багыт),
					},
					'acre' => {
						'name' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'acre-foot' => {
						'name' => q(акр-фут),
						'one' => q({0} ак. фт.),
						'other' => q({0} ак. фт.),
					},
					'ampere' => {
						'name' => q(амп),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'name' => q(аркмүн),
						'one' => q({0} аркмүн),
						'other' => q({0} аркмүн),
					},
					'arc-second' => {
						'name' => q(арксек),
						'one' => q({0} арксек),
						'other' => q({0} арксек),
					},
					'astronomical-unit' => {
						'name' => q(а. б.),
						'one' => q({0} а.б.),
						'other' => q({0} а.б.),
					},
					'atmosphere' => {
						'name' => q(атм),
						'one' => q({0} атм),
						'other' => q({0} атмс),
					},
					'bit' => {
						'name' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					'byte' => {
						'name' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					'calorie' => {
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					'carat' => {
						'name' => q(карат),
						'one' => q({0} кар.),
						'other' => q({0} кар.),
					},
					'celsius' => {
						'name' => q(Цельсий град.),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'name' => q(сЛ),
						'one' => q({0} сЛ),
						'other' => q({0} сЛ),
					},
					'centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
						'per' => q(см/{0}),
					},
					'century' => {
						'name' => q(к.),
						'one' => q({0} к.),
						'other' => q({0} к.),
					},
					'coordinate' => {
						'east' => q({0}Ч),
						'north' => q({0}Тн),
						'south' => q({0}Тш),
						'west' => q({0}Б),
					},
					'cubic-centimeter' => {
						'name' => q(см³),
						'one' => q({0} см³),
						'other' => q({0} см³),
						'per' => q(см³/{0}),
					},
					'cubic-foot' => {
						'name' => q(фут³),
						'one' => q({0} фут³),
						'other' => q({0} фут³),
					},
					'cubic-inch' => {
						'name' => q(дюйм³),
						'one' => q({0} дюйм³),
						'other' => q({0} дюйм³),
					},
					'cubic-kilometer' => {
						'name' => q(куб километр),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-meter' => {
						'name' => q(м³),
						'one' => q({0} м³),
						'other' => q({0} м³),
						'per' => q(м³/{0}),
					},
					'cubic-mile' => {
						'name' => q(мил³),
						'one' => q({0} мил³),
						'other' => q({0} мил³),
					},
					'cubic-yard' => {
						'name' => q(ярд³),
						'one' => q({0} ярд³),
						'other' => q({0} ярд³),
					},
					'cup' => {
						'name' => q(чөйчөк),
						'one' => q({0} чөй.),
						'other' => q({0} чөй.),
					},
					'cup-metric' => {
						'name' => q(mcup),
						'one' => q({0} mc),
						'other' => q({0} mc),
					},
					'day' => {
						'name' => q(күн),
						'one' => q({0} күн),
						'other' => q({0} күн),
						'per' => q(күн/{0}),
					},
					'deciliter' => {
						'name' => q(дл),
						'one' => q({0} дл),
						'other' => q({0} дл),
					},
					'decimeter' => {
						'name' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					'degree' => {
						'name' => q(градус),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'name' => q(Ф. град),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fluid-ounce' => {
						'name' => q(с. унц.),
						'one' => q({0} с. унц.),
						'other' => q({0} с. унц.),
					},
					'foodcalorie' => {
						'name' => q(Кал),
						'one' => q({0} Кал),
						'other' => q({0} Кал),
					},
					'foot' => {
						'name' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
						'per' => q(ф/{0}),
					},
					'g-force' => {
						'name' => q(оордук күчүнүн ылдамдануусу),
						'one' => q({0} о.к.),
						'other' => q({0} о.к.),
					},
					'gallon' => {
						'name' => q(гал),
						'one' => q({0} гал),
						'other' => q({0} гал),
						'per' => q(гал/{0}),
					},
					'gallon-imperial' => {
						'name' => q(англ. гал),
						'one' => q({0} англ. гал),
						'other' => q({0} англ. гал),
						'per' => q(англ. гал/{0}),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(Гбит),
						'one' => q({0} Гб),
						'other' => q({0} Гб),
					},
					'gigabyte' => {
						'name' => q(Гбайт),
						'one' => q({0} ГБ),
						'other' => q({0} ГБ),
					},
					'gigahertz' => {
						'name' => q(Ггц),
						'one' => q({0} Ггц),
						'other' => q({0} Ггц),
					},
					'gigawatt' => {
						'name' => q(ГВт),
						'one' => q({0} ГВт),
						'other' => q({0} ГВт),
					},
					'gram' => {
						'name' => q(грамм),
						'one' => q({0} гр),
						'other' => q({0} гр),
						'per' => q(гр/{0}),
					},
					'hectare' => {
						'name' => q(гектар),
						'one' => q({0} га),
						'other' => q({0} га),
					},
					'hectoliter' => {
						'name' => q(гл),
						'one' => q({0} гл),
						'other' => q({0} гл),
					},
					'hectopascal' => {
						'name' => q(гПа),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					'hertz' => {
						'name' => q(Гц),
						'one' => q({0} Гц),
						'other' => q({0} Гц),
					},
					'horsepower' => {
						'name' => q(а.к.),
						'one' => q({0} а.к.),
						'other' => q({0} а.к.),
					},
					'hour' => {
						'name' => q(саат),
						'one' => q({0} ст),
						'other' => q({0} ст),
						'per' => q(ст/{0}),
					},
					'inch' => {
						'name' => q(дюйм),
						'one' => q({0} дюйм),
						'other' => q({0} дюйм),
						'per' => q(д/{0}),
					},
					'inch-hg' => {
						'name' => q(дюйм сымап мамычасы),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'name' => q(жоул),
						'one' => q({0} ж),
						'other' => q({0} ж),
					},
					'karat' => {
						'name' => q(карат),
						'one' => q({0} кт),
						'other' => q({0} кт),
					},
					'kelvin' => {
						'name' => q(К град.),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'name' => q(кбит),
						'one' => q({0} кб),
						'other' => q({0} кб),
					},
					'kilobyte' => {
						'name' => q(кБайт),
						'one' => q({0} кБ),
						'other' => q({0} кБ),
					},
					'kilocalorie' => {
						'name' => q(ккал),
						'one' => q({0} ккал),
						'other' => q({0} ккал),
					},
					'kilogram' => {
						'name' => q(килограмм),
						'one' => q({0} кг),
						'other' => q({0} кг),
						'per' => q(кг/{0}),
					},
					'kilohertz' => {
						'name' => q(кГц),
						'one' => q({0} кГц),
						'other' => q({0} кГц),
					},
					'kilojoule' => {
						'name' => q(киложоул),
						'one' => q({0} кж),
						'other' => q({0} кж),
					},
					'kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
						'per' => q(км/{0}),
					},
					'kilometer-per-hour' => {
						'name' => q(км/саат),
						'one' => q({0} км/с),
						'other' => q({0} км/с),
					},
					'kilowatt' => {
						'name' => q(кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					'kilowatt-hour' => {
						'name' => q(кВ-саат),
						'one' => q({0} кВ-саат),
						'other' => q({0} кВ-саат),
					},
					'knot' => {
						'name' => q(тн),
						'one' => q({0} тн),
						'other' => q({0} тн),
					},
					'light-year' => {
						'name' => q(жарык жыл),
						'one' => q({0} жар.ж.),
						'other' => q({0} жар.ж.),
					},
					'liter' => {
						'name' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
						'per' => q(л/{0}),
					},
					'liter-per-100kilometers' => {
						'name' => q(100 км/л),
						'one' => q({0} л/100км),
						'other' => q({0} л/100км),
					},
					'liter-per-kilometer' => {
						'name' => q(км/литр),
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					'lux' => {
						'name' => q(люкс),
						'one' => q({0} лк),
						'other' => q({0} лк),
					},
					'megabit' => {
						'name' => q(Мбит),
						'one' => q({0} Мб),
						'other' => q({0} Мб),
					},
					'megabyte' => {
						'name' => q(МБайт),
						'one' => q({0} МБ),
						'other' => q({0} МБ),
					},
					'megahertz' => {
						'name' => q(МГЦ),
						'one' => q({0} МГЦ),
						'other' => q({0} МГЦ),
					},
					'megaliter' => {
						'name' => q(мгл),
						'one' => q({0} мгл),
						'other' => q({0} мгл),
					},
					'megawatt' => {
						'name' => q(МВт),
						'one' => q({0} МВт),
						'other' => q({0} МВт),
					},
					'meter' => {
						'name' => q(метр),
						'one' => q({0} м),
						'other' => q({0} м),
						'per' => q(м/{0}),
					},
					'meter-per-second' => {
						'name' => q(метр/сек.),
						'one' => q({0} м/сек.),
						'other' => q({0} м/сек.),
					},
					'meter-per-second-squared' => {
						'name' => q(метр/сек²),
						'one' => q({0} м/сек²),
						'other' => q({0} м/сек²),
					},
					'metric-ton' => {
						'name' => q(т),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					'microgram' => {
						'name' => q(мкг),
						'one' => q({0} мкг),
						'other' => q({0} мкг),
					},
					'micrometer' => {
						'name' => q(µметр),
						'one' => q({0} µм),
						'other' => q({0} µм),
					},
					'microsecond' => {
						'name' => q(μсек),
						'one' => q({0}μс),
						'other' => q({0}μс),
					},
					'mile' => {
						'name' => q(миля),
						'one' => q({0} миля),
						'other' => q({0} миля),
					},
					'mile-per-gallon' => {
						'name' => q(мил/гал),
						'one' => q({0} мил/гал),
						'other' => q({0} мил/гал),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(миля/англ. галлонуна),
						'one' => q({0} мил/англ.гал),
						'other' => q({0} мил/англ.гал),
					},
					'mile-per-hour' => {
						'name' => q(миля/саатына),
						'one' => q({0} миля/с),
						'other' => q({0} миля/с),
					},
					'mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					'milliampere' => {
						'name' => q(миллиамп),
						'one' => q({0} мА),
						'other' => q({0} мА),
					},
					'millibar' => {
						'name' => q(миллибар),
						'one' => q({0} мбар),
						'other' => q({0} мбар),
					},
					'milligram' => {
						'name' => q(мг),
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					'milligram-per-deciliter' => {
						'name' => q(мг/Дл),
						'one' => q({0} мг/Дл),
						'other' => q({0} мг/Дл),
					},
					'milliliter' => {
						'name' => q(мл),
						'one' => q({0} мл),
						'other' => q({0} мл),
					},
					'millimeter' => {
						'name' => q(миллиметр),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millimeter-of-mercury' => {
						'name' => q(мм.с.м.),
						'one' => q({0} мм.с. м.),
						'other' => q({0} мм.с. м.),
					},
					'millimole-per-liter' => {
						'name' => q(ммоль/л),
						'one' => q({0} ммоль/л),
						'other' => q({0} ммоль/л),
					},
					'millisecond' => {
						'name' => q(миллисекунд),
						'one' => q({0} мсек),
						'other' => q({0} мсек),
					},
					'milliwatt' => {
						'name' => q(мвт),
						'one' => q({0} мвт),
						'other' => q({0} мвт),
					},
					'minute' => {
						'name' => q(мүнөт),
						'one' => q({0} мүн),
						'other' => q({0} мүн),
						'per' => q(мүн/{0}),
					},
					'month' => {
						'name' => q(ай),
						'one' => q({0} ай),
						'other' => q({0} ай),
						'per' => q(а/{0}),
					},
					'nanometer' => {
						'name' => q(нм),
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					'nanosecond' => {
						'name' => q(наносек),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					'nautical-mile' => {
						'name' => q(дең. мил.),
						'one' => q({0} дең. мил.),
						'other' => q({0} дең. мил.),
					},
					'ohm' => {
						'name' => q(ом),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(унц.),
						'one' => q({0} унц.),
						'other' => q({0} унц.),
						'per' => q(унц/{0}),
					},
					'ounce-troy' => {
						'name' => q(тр. унц.),
						'one' => q({0} тр. унц.),
						'other' => q({0} тр. унц.),
					},
					'parsec' => {
						'name' => q(парсек),
						'one' => q({0} пк),
						'other' => q({0} пк),
					},
					'part-per-million' => {
						'name' => q(миллионго/бөлүк),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					'per' => {
						'1' => q({1}/{0}),
					},
					'percent' => {
						'name' => q(пайыз),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'permille' => {
						'name' => q(промилле),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					'petabyte' => {
						'name' => q(ПТб),
						'one' => q({0} Птб),
						'other' => q({0} Птб),
					},
					'picometer' => {
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pint' => {
						'name' => q(пт),
						'one' => q({0} пт),
						'other' => q({0} пт),
					},
					'pint-metric' => {
						'name' => q(мпт),
						'one' => q({0} мпт),
						'other' => q({0} мпт),
					},
					'point' => {
						'name' => q(чекиттер),
						'one' => q({0} чкт),
						'other' => q({0} чкт),
					},
					'pound' => {
						'name' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
						'per' => q(фунт/{0}),
					},
					'pound-per-square-inch' => {
						'name' => q(фчд),
						'one' => q({0} фчд),
						'other' => q({0} фчд),
					},
					'quart' => {
						'name' => q(квр),
						'one' => q({0} квр),
						'other' => q({0} квр),
					},
					'radian' => {
						'name' => q(рад.),
						'one' => q({0} рад),
						'other' => q({0} рад.),
					},
					'revolution' => {
						'name' => q(rev),
						'one' => q({0} rev),
						'other' => q({0} rev),
					},
					'second' => {
						'name' => q(секунд),
						'one' => q({0} сек),
						'other' => q({0} сек),
						'per' => q(сек/{0}),
					},
					'square-centimeter' => {
						'name' => q(см²),
						'one' => q({0} см²),
						'other' => q({0} см²),
						'per' => q(см²/{0}),
					},
					'square-foot' => {
						'name' => q(чарчы фут),
						'one' => q({0} фут²),
						'other' => q({0} фут²),
					},
					'square-inch' => {
						'name' => q(дюйм²),
						'one' => q({0} дюйм²),
						'other' => q({0} дюйм²),
						'per' => q(дюйм²/{0}),
					},
					'square-kilometer' => {
						'name' => q(км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
						'per' => q(km²/{0}),
					},
					'square-meter' => {
						'name' => q(метр²),
						'one' => q({0} м²),
						'other' => q({0} м²),
						'per' => q(м²/{0}),
					},
					'square-mile' => {
						'name' => q(чарчы миля),
						'one' => q({0} мл²),
						'other' => q({0} мл²),
						'per' => q(mi²/{0}),
					},
					'square-yard' => {
						'name' => q(ярд²),
						'one' => q({0} ярд²),
						'other' => q({0} ярд²),
					},
					'tablespoon' => {
						'name' => q(чоң каш.),
						'one' => q({0} чоң каш.),
						'other' => q({0} чоң каш.),
					},
					'teaspoon' => {
						'name' => q(чай каш.),
						'one' => q({0} чай каш.),
						'other' => q({0} чай каш.),
					},
					'terabit' => {
						'name' => q(Тбит),
						'one' => q({0} Тб),
						'other' => q({0} Тб),
					},
					'terabyte' => {
						'name' => q(ТБайт),
						'one' => q({0} ТБ),
						'other' => q({0} ТБ),
					},
					'ton' => {
						'name' => q(тонна),
						'one' => q({0} тон.),
						'other' => q({0} тон.),
					},
					'volt' => {
						'name' => q(вольт),
						'one' => q({0} В),
						'other' => q({0} В),
					},
					'watt' => {
						'name' => q(ватт),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					'week' => {
						'name' => q(апта),
						'one' => q({0} апт),
						'other' => q({0} апт),
						'per' => q(апт/{0}),
					},
					'yard' => {
						'name' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'name' => q(жыл),
						'one' => q({0} ж.),
						'other' => q({0} ж.),
						'per' => q(ж/{0}),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ооба|о|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:жок|ж|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q( ),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(сан эмес),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 миң',
					'other' => '0 миң',
				},
				'10000' => {
					'one' => '00 миң',
					'other' => '00 миң',
				},
				'100000' => {
					'one' => '000 миң',
					'other' => '000 миң',
				},
				'1000000' => {
					'one' => '0 млн',
					'other' => '0 млн',
				},
				'10000000' => {
					'one' => '00 млн',
					'other' => '00 млн',
				},
				'100000000' => {
					'one' => '000 млн',
					'other' => '000 млн',
				},
				'1000000000' => {
					'one' => '0 млд',
					'other' => '0 млд',
				},
				'10000000000' => {
					'one' => '00 млд',
					'other' => '00 млд',
				},
				'100000000000' => {
					'one' => '000 млд',
					'other' => '000 млд',
				},
				'1000000000000' => {
					'one' => '0 трлн',
					'other' => '0 трлн',
				},
				'10000000000000' => {
					'one' => '00 трлн',
					'other' => '00 трлн',
				},
				'100000000000000' => {
					'one' => '000 трлн',
					'other' => '000 трлн',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 миң',
					'other' => '0 миң',
				},
				'10000' => {
					'one' => '00 миң',
					'other' => '00 миң',
				},
				'100000' => {
					'one' => '000 миң',
					'other' => '000 миң',
				},
				'1000000' => {
					'one' => '0 миллион',
					'other' => '0 миллион',
				},
				'10000000' => {
					'one' => '00 миллион',
					'other' => '00 миллион',
				},
				'100000000' => {
					'one' => '000 миллион',
					'other' => '000 миллион',
				},
				'1000000000' => {
					'one' => '0 миллиард',
					'other' => '0 миллиард',
				},
				'10000000000' => {
					'one' => '00 миллиард',
					'other' => '00 миллиард',
				},
				'100000000000' => {
					'one' => '000 миллиард',
					'other' => '000 миллиард',
				},
				'1000000000000' => {
					'one' => '0 триллион',
					'other' => '0 триллион',
				},
				'10000000000000' => {
					'one' => '00 триллион',
					'other' => '00 триллион',
				},
				'100000000000000' => {
					'one' => '000 триллион',
					'other' => '000 триллион',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 миң',
					'other' => '0 миң',
				},
				'10000' => {
					'one' => '00 миң',
					'other' => '00 миң',
				},
				'100000' => {
					'one' => '000 миң',
					'other' => '000 миң',
				},
				'1000000' => {
					'one' => '0 млн',
					'other' => '0 млн',
				},
				'10000000' => {
					'one' => '00 млн',
					'other' => '00 млн',
				},
				'100000000' => {
					'one' => '000 млн',
					'other' => '000 млн',
				},
				'1000000000' => {
					'one' => '0 млд',
					'other' => '0 млд',
				},
				'10000000000' => {
					'one' => '00 млд',
					'other' => '00 млд',
				},
				'100000000000' => {
					'one' => '000 млд',
					'other' => '000 млд',
				},
				'1000000000000' => {
					'one' => '0 трлн',
					'other' => '0 трлн',
				},
				'10000000000000' => {
					'one' => '00 трлн',
					'other' => '00 трлн',
				},
				'100000000000000' => {
					'one' => '000 трлн',
					'other' => '000 трлн',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(Бириккен Араб Эмираттарынын дирхамы),
				'one' => q(БАЭ дирхамы),
				'other' => q(БАЭ дирхамы),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(Афганстан афганиси),
				'one' => q(Афганстан афганиси),
				'other' => q(Афганстан афганиси),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(албан леги),
				'one' => q(албан леги),
				'other' => q(албан леги),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(Армения драмы),
				'one' => q(Армения драмы),
				'other' => q(Армения драмы),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(нидерланд-антил гулдени),
				'one' => q(нидерланд-антил гулдени),
				'other' => q(нидерланд-антил гулдени),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(Ангола кванзасы),
				'one' => q(Ангола кванзасы),
				'other' => q(Ангола кванзасы),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(аргентина песосу),
				'one' => q(аргентина песосу),
				'other' => q(аргентина песосу),
			},
		},
		'AUD' => {
			symbol => 'AUD',
			display_name => {
				'currency' => q(Австралия доллары),
				'one' => q(Австралия доллары),
				'other' => q(Австралия доллары),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(аруба флорини),
				'one' => q(аруба флорини),
				'other' => q(аруба флорини),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(Азербайжан манаты),
				'one' => q(Азербайжан манаты),
				'other' => q(Азербайжан манаты),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(босния-герцоговина конвертациялануучу маркасы),
				'one' => q(босния-герцоговина конвертациялануучу маркасы),
				'other' => q(босния-герцоговина конвертациялануучу маркалары),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(барбадос доллары),
				'one' => q(барбадос доллары),
				'other' => q(барбадос доллары),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(Бангладеш такасы),
				'one' => q(Бангладеш такасы),
				'other' => q(Бангладеш такасы),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(болгар левиси),
				'one' => q(болгар левиси),
				'other' => q(болгар левиси),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(Бахрейн динары),
				'one' => q(Бахрейн динары),
				'other' => q(Бахрейн динары),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(Бурунди франкы),
				'one' => q(Бурунди франкы),
				'other' => q(Бурунди франкы),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(бермуд доллары),
				'one' => q(бермуд доллары),
				'other' => q(бермуд доллары),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(Бруней доллары),
				'one' => q(Бруней доллары),
				'other' => q(Бруней доллары),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(боливия боливианосу),
				'one' => q(боливия боливианосу),
				'other' => q(боливия боливианосу),
			},
		},
		'BRL' => {
			symbol => 'BRL',
			display_name => {
				'currency' => q(бразилия реалы),
				'one' => q(бразилия реалы),
				'other' => q(бразилия реалы),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(багама доллары),
				'one' => q(багама доллары),
				'other' => q(багама доллары),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(Бутан нгултруму),
				'one' => q(Бутан нгултруму),
				'other' => q(Бутан нгултруму),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(Ботсвана пуласы),
				'one' => q(Ботсвана пуласы),
				'other' => q(Ботсвана пуласы),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(беларусь рублу),
				'one' => q(беларусь рублу),
				'other' => q(беларусь рублу),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(беларусь рублу \(2000–2016\)),
				'one' => q(беларусь рублу \(2000–2016\)),
				'other' => q(беларусь рублу \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(белиз доллары),
				'one' => q(белиз доллары),
				'other' => q(белиз доллары),
			},
		},
		'CAD' => {
			symbol => 'CAD',
			display_name => {
				'currency' => q(канада доллары),
				'one' => q(канада доллары),
				'other' => q(канада долларлары),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(Конго франкы),
				'one' => q(Конго франкы),
				'other' => q(Конго франкы),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(швейцария франкы),
				'one' => q(швейцария франкы),
				'other' => q(швейцария франкы),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(чили песосу),
				'one' => q(чили песосу),
				'other' => q(чили песосу),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(CNH),
				'one' => q(CNH),
				'other' => q(CNH),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(Кытай юаны),
				'one' => q(Кытай юаны),
				'other' => q(Кытай юаны),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(колумбия песосу),
				'one' => q(колумбия песосу),
				'other' => q(колумбия песосу),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(коста-рика колону),
				'one' => q(коста-рика колону),
				'other' => q(коста-рика колону),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(кубанын конвертациялануучу песосу),
				'one' => q(кубанын конвертациялануучу песосу),
				'other' => q(кубанын конвертациялануучу песолору),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(куба песосу),
				'one' => q(куба песосу),
				'other' => q(куба песосу),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(Кабо-Верде эскудосу),
				'one' => q(Кабо-Верде эскудосу),
				'other' => q(Кабо-Верде эскудосу),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(чех кронасы),
				'one' => q(чех кронасы),
				'other' => q(чех кронасы),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(Жибути франкы),
				'one' => q(Жибути франкы),
				'other' => q(Жибути франкы),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(дания крону),
				'one' => q(дания крону),
				'other' => q(дания крону),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(доминикан песосу),
				'one' => q(доминикан песосу),
				'other' => q(доминикан песосу),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(алжир динары),
				'one' => q(алжир динары),
				'other' => q(алжир динары),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(египет фунту),
				'one' => q(египет фунту),
				'other' => q(египет фунту),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(Эритреа накфасы),
				'one' => q(Эритреа накфасы),
				'other' => q(Эритреа накфасы),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(Эфиопия бирри),
				'one' => q(Эфиопия бирри),
				'other' => q(Эфиопия бирри),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(Евро),
				'one' => q(евро),
				'other' => q(евролор),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(Фижи доллары),
				'one' => q(Фижи доллары),
				'other' => q(Фижи доллары),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(фолкленд аралдарынын фунту),
				'one' => q(фолкленд аралдарынын фунту),
				'other' => q(фолкленд аралдарынын фунту),
			},
		},
		'GBP' => {
			symbol => 'GBP',
			display_name => {
				'currency' => q(британия фунт стерлинги),
				'one' => q(британия фунт стерлинги),
				'other' => q(британия фунт стерлинги),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(Грузия лариси),
				'one' => q(Грузия лариси),
				'other' => q(Грузия лариси),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(Гана седиси),
				'one' => q(Гана седиси),
				'other' => q(Гана седиси),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(гибралтар фунту),
				'one' => q(гибралтар фунту),
				'other' => q(гибралтар фунту),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(Гамбия даласиси),
				'one' => q(Гамбия даласиси),
				'other' => q(Гамбия даласиси),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(Гине франкы),
				'one' => q(Гине франкы),
				'other' => q(Гине франкы),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(гватемала кетсалы),
				'one' => q(гватемала кетсалы),
				'other' => q(гватемала кетсалы),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(гуйана доллары),
				'one' => q(гуйана доллары),
				'other' => q(гуйана доллары),
			},
		},
		'HKD' => {
			symbol => 'HKD',
			display_name => {
				'currency' => q(Гонконг доллары),
				'one' => q(Гонконг доллары),
				'other' => q(Гонконг доллары),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(гондурас лемпирасы),
				'one' => q(гондурас лемпирасы),
				'other' => q(гондурас лемпирасы),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(хорват кунасы),
				'one' => q(хорват кунасы),
				'other' => q(хорват кунасы),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(гаити гурдусу),
				'one' => q(гаити гурдусу),
				'other' => q(гаити гурдусу),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(венгр форинти),
				'one' => q(венгр форинти),
				'other' => q(венгр форинти),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(Индонезия рупийасы),
				'one' => q(Индонезия рупийасы),
				'other' => q(Индонезия рупийасы),
			},
		},
		'ILS' => {
			symbol => 'ILS',
			display_name => {
				'currency' => q(Израилдин жаңы шекели),
				'one' => q(Израилдин жаңы шекели),
				'other' => q(Израилдин жаңы шекели),
			},
		},
		'INR' => {
			symbol => 'INR',
			display_name => {
				'currency' => q(Индия руписи),
				'one' => q(Индия руписи),
				'other' => q(Индия руписи),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(Ирак динары),
				'one' => q(Ирак динары),
				'other' => q(Ирак динары),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(Иран риалы),
				'one' => q(Иран риалы),
				'other' => q(Иран риалы),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(исландия крону),
				'one' => q(исландия крону),
				'other' => q(исландия крону),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(ямайка доллары),
				'one' => q(ямайка доллары),
				'other' => q(ямайка доллары),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(Йордания динары),
				'one' => q(Йордания динары),
				'other' => q(Йордания динары),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(Жапан йени),
				'one' => q(Жапан йени),
				'other' => q(Жапан йени),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(Кения шиллинги),
				'one' => q(Кения шиллинги),
				'other' => q(Кения шиллинги),
			},
		},
		'KGS' => {
			symbol => 'сом',
			display_name => {
				'currency' => q(Кыргызстан сому),
				'one' => q(Кыргызстан сому),
				'other' => q(Кыргызстан сому),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(Камбожа риели),
				'one' => q(Камбожа риели),
				'other' => q(Камбожа риели),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(Коморос франкы),
				'one' => q(Коморос франкы),
				'other' => q(Коморос франкы),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(Түндүк Корея уону),
				'one' => q(Түндүк Корея уону),
				'other' => q(Түндүк Корея уону),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(Түштүк Корея уону),
				'one' => q(Түштүк Корея уону),
				'other' => q(Түштүк Корея уону),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(Кувейт динары),
				'one' => q(Кувейт динары),
				'other' => q(Кувейт динары),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(кайман доллары),
				'one' => q(кайман доллары),
				'other' => q(кайман доллары),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(Казакстан теңгеси),
				'one' => q(Казакстан теңгеси),
				'other' => q(Казакстан теңгеси),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(Лаос киби),
				'one' => q(Лаос киби),
				'other' => q(Лаос киби),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(Ливан фунту),
				'one' => q(Ливан фунту),
				'other' => q(Ливан фунту),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(Шри Ланка руписи),
				'one' => q(Шри Ланка руписи),
				'other' => q(Шри Ланка руписи),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(Либерия доллары),
				'one' => q(Либерия доллары),
				'other' => q(Либерия доллары),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(литва литасы),
				'one' => q(литва литасы),
				'other' => q(литва литасы),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(латвия латы),
				'one' => q(латвия латы),
				'other' => q(латвия латы),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(ливия динары),
				'one' => q(ливия динары),
				'other' => q(ливия динары),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(марокко дирхамы),
				'one' => q(марокко дирхамы),
				'other' => q(марокко дирхамы),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(молдован лейи),
				'one' => q(молдован лейи),
				'other' => q(молдован лейи),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(Мадагаскар ариариси),
				'one' => q(Мадагаскар ариариси),
				'other' => q(Мадагаскар ариариси),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(македон денары),
				'one' => q(македон денары),
				'other' => q(македон денары),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(Мйанмар кйаты),
				'one' => q(Мйанмар кйаты),
				'other' => q(Мйанмар кйаты),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(Монгол тугриги),
				'one' => q(Монгол тугриги),
				'other' => q(Монгол тугриги),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(Макау патакасы),
				'one' => q(Макау патакасы),
				'other' => q(Макау патакасы),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(Мавритания угиясы \(1973–2017\)),
				'one' => q(Мавритания угиясы \(1973–2017\)),
				'other' => q(Мавритания угиясы \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(Мавритания угиясы),
				'one' => q(Мавритания угиясы),
				'other' => q(Мавритания угиясы),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(Мавританий руписи),
				'one' => q(Мавританий руписи),
				'other' => q(Мавританий руписи),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(Малдив руфийасы),
				'one' => q(Малдив руфийасы),
				'other' => q(Малдив руфийасы),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(Малави квачасы),
				'one' => q(Малави квачасы),
				'other' => q(Малави квачасы),
			},
		},
		'MXN' => {
			symbol => 'MXN',
			display_name => {
				'currency' => q(мексика песосу),
				'one' => q(мексика песосу),
				'other' => q(мексика песосу),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(Малайзия ринггити),
				'one' => q(Малайзия ринггити),
				'other' => q(Малайзия ринггити),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(Мозамбик метикалы),
				'one' => q(Мозамбик метикалы),
				'other' => q(Мозамбик метикалы),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(Намибия доллары),
				'one' => q(Намибия доллары),
				'other' => q(Намибия доллары),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(Нигерия найрасы),
				'one' => q(Нигерия найрасы),
				'other' => q(Нигерия найрасы),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(никарагуа кордобасы),
				'one' => q(никарагуа кордобасы),
				'other' => q(никарагуа кордобасы),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(норвегия крону),
				'one' => q(норвегия крону),
				'other' => q(норвегия крону),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(Непал руписи),
				'one' => q(Непал руписи),
				'other' => q(Непал руписи),
			},
		},
		'NZD' => {
			symbol => 'NZD',
			display_name => {
				'currency' => q(Жаңы Зеландия доллары),
				'one' => q(Жаңы Зеландия доллары),
				'other' => q(Жаңы Зеландия доллары),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(Оман риалы),
				'one' => q(Оман риалы),
				'other' => q(Оман риалы),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(панама балбоасы),
				'one' => q(панама балбоасы),
				'other' => q(панама балбоасы),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(перу солу),
				'one' => q(перу солу),
				'other' => q(перу солу),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(Папуа Жаңы Гвинея кинасы),
				'one' => q(Папуа Жаңы Гвинея кинасы),
				'other' => q(Папуа Жаңы Гвинея кинасы),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(Филиппин песосу),
				'one' => q(Филиппин песосу),
				'other' => q(Филиппин песосу),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(Пакистан руписи),
				'one' => q(Пакистан руписи),
				'other' => q(Пакистан руписи),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(польша злотыйы),
				'one' => q(польша злотыйы),
				'other' => q(польша злотыйы),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(парагвай гуараниси),
				'one' => q(парагвай гуараниси),
				'other' => q(парагвай гуараниси),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(Катар риалы),
				'one' => q(Катар риалы),
				'other' => q(Катар риалы),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(румын лейи),
				'one' => q(румын лейи),
				'other' => q(румын лейи),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(серб динары),
				'one' => q(серб динары),
				'other' => q(серб динары),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(орус рублу),
				'one' => q(орус рублу),
				'other' => q(орус рублу),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(Руанда франкы),
				'one' => q(Руанда франкы),
				'other' => q(Руанда франкы),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(Сауд риалы),
				'one' => q(Сауд риалы),
				'other' => q(Сауд риалы),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(Соломон аралдарынын доллары),
				'one' => q(Соломон аралдарынын доллары),
				'other' => q(Соломон аралдарынын долларлары),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(Сейшел руписи),
				'one' => q(Сейшел руписи),
				'other' => q(Сейшел руписи),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(судан фунту),
				'one' => q(судан фунту),
				'other' => q(судан фунту),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(швеция крону),
				'one' => q(швеция крону),
				'other' => q(швеция крону),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(Сингапур доллары),
				'one' => q(Сингапур доллары),
				'other' => q(Сингапур доллары),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(Ыйык Елена аралынын фунту),
				'one' => q(Ыйык Елена аралынын фунту),
				'other' => q(Ыйык Елена аралынын фунту),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(Сиерра-Леоне леонеси),
				'one' => q(Сиерра-Леоне леонеси),
				'other' => q(Сиерра-Леоне леонеси),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(Сомали шиллинги),
				'one' => q(Сомали шиллинги),
				'other' => q(Сомали шиллинги),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(суринам доллары),
				'one' => q(суринам доллары),
				'other' => q(суринам доллары),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(Түштүк Судан фунту),
				'one' => q(Түштүк Судан фунту),
				'other' => q(Түштүк Судан фунту),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(Сао Томе жана Принсипе добрасы \(1977–2017\)),
				'one' => q(Сао Томе жана Принсипе добрасы \(1977–2017\)),
				'other' => q(Сао Томе жана Принсипе добрасы \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'Db',
			display_name => {
				'currency' => q(Сао Томе жана Принсипе добрасы),
				'one' => q(Сао Томе жана Принсипе добрасы),
				'other' => q(Сао Томе жана Принсипе добрасы),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(Сирия фунту),
				'one' => q(Сирия фунту),
				'other' => q(Сирия фунту),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(Свази лилангени),
				'one' => q(Свази лилангени),
				'other' => q(Свази эмалангени),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(Тай баты),
				'one' => q(Тай баты),
				'other' => q(Тай баты),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(Тажикстан сомониси),
				'one' => q(Тажикстан сомониси),
				'other' => q(Тажикстан сомониси),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(Түркмөнстан манаты),
				'one' => q(Түркмөнстан манаты),
				'other' => q(Түркмөнстан манаты),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(тунис динары),
				'one' => q(тунис динары),
				'other' => q(тунис динары),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(Тонга паангасы),
				'one' => q(Тонга паангасы),
				'other' => q(Тонга паангасы),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(Түркия лирасы),
				'one' => q(Түркия лирасы),
				'other' => q(Түркия лирасы),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(тринидад жана тобаго доллары),
				'one' => q(тринидад жана тобаго доллары),
				'other' => q(тринидад жана тобаго доллары),
			},
		},
		'TWD' => {
			symbol => 'TWD',
			display_name => {
				'currency' => q(Тайвань жаңы доллары),
				'one' => q(Тайвань жаңы доллары),
				'other' => q(Тайвань жаңы доллары),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(Танзания шиллинги),
				'one' => q(Танзания шиллинги),
				'other' => q(Танзания шиллинги),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(украин гривени),
				'one' => q(украин гривени),
				'other' => q(украин гривени),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(Уганда шиллинги),
				'one' => q(Уганда шиллинги),
				'other' => q(Уганда шиллинги),
			},
		},
		'USD' => {
			symbol => 'USD',
			display_name => {
				'currency' => q(АКШ доллары),
				'one' => q(АКШ доллары),
				'other' => q(АКШ доллары),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(уругвай песосу),
				'one' => q(уругвай песосу),
				'other' => q(уругвай песосу),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(Өзбекстан суму),
				'one' => q(Өзбекстан суму),
				'other' => q(Өзбекстан суму),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(венесуэла боливары \(2008–2018\)),
				'one' => q(венесуэла боливары \(2008–2018\)),
				'other' => q(венесуэла боливары \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(VES),
				'one' => q(VES),
				'other' => q(VES),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(Вьетнам доңу),
				'one' => q(Вьетнам доңу),
				'other' => q(Вьетнам доңу),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(Вануату ватусу),
				'one' => q(Вануату ватусу),
				'other' => q(Вануату ватусу),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(Самоа таласы),
				'one' => q(Самоа таласы),
				'other' => q(Самоа таласы),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(Борбордук Африка КФА франкы),
				'one' => q(Борбордук Африка КФА франкы),
				'other' => q(Борбордук Африка КФА франкы),
			},
		},
		'XCD' => {
			symbol => 'XCD',
			display_name => {
				'currency' => q(чыгыш кариб доллары),
				'one' => q(чыгыш кариб доллары),
				'other' => q(чыгыш кариб доллары),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(КФА франкы),
				'one' => q(КФА франкы),
				'other' => q(КФА франкы),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(КФП франкы),
				'one' => q(КФП франкы),
				'other' => q(КФП франкы),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Белгисиз акча),
				'one' => q(\(белгисиз акча бирдиги\)),
				'other' => q(\(белгисиз акча\)),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(Йемен риалы),
				'one' => q(Йемен риалы),
				'other' => q(Йемен риалы),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(Түштүк Африка ранды),
				'one' => q(Түштүк Африка ранды),
				'other' => q(Түштүк Африка ранды),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(Замбия квачасы),
				'one' => q(Замбия квачасы),
				'other' => q(Замбия квачасы),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'янв.',
							'фев.',
							'мар.',
							'апр.',
							'май',
							'июн.',
							'июл.',
							'авг.',
							'сен.',
							'окт.',
							'ноя.',
							'дек.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Я',
							'Ф',
							'М',
							'А',
							'М',
							'И',
							'И',
							'А',
							'С',
							'О',
							'Н',
							'Д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'январь',
							'февраль',
							'март',
							'апрель',
							'май',
							'июнь',
							'июль',
							'август',
							'сентябрь',
							'октябрь',
							'ноябрь',
							'декабрь'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'Янв',
							'Фев',
							'Мар',
							'Апр',
							'Май',
							'Июн',
							'Июл',
							'Авг',
							'Сен',
							'Окт',
							'Ноя',
							'Дек'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Я',
							'Ф',
							'М',
							'А',
							'М',
							'И',
							'И',
							'А',
							'С',
							'О',
							'Н',
							'Д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Январь',
							'Февраль',
							'Март',
							'Апрель',
							'Май',
							'Июнь',
							'Июль',
							'Август',
							'Сентябрь',
							'Октябрь',
							'Ноябрь',
							'Декабрь'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'дүй.',
						tue => 'шейш.',
						wed => 'шарш.',
						thu => 'бейш.',
						fri => 'жума',
						sat => 'ишм.',
						sun => 'жек.'
					},
					narrow => {
						mon => 'Д',
						tue => 'Ш',
						wed => 'Ш',
						thu => 'Б',
						fri => 'Ж',
						sat => 'И',
						sun => 'Ж'
					},
					short => {
						mon => 'дш.',
						tue => 'шш.',
						wed => 'шр.',
						thu => 'бш.',
						fri => 'жм.',
						sat => 'иш.',
						sun => 'жш.'
					},
					wide => {
						mon => 'дүйшөмбү',
						tue => 'шейшемби',
						wed => 'шаршемби',
						thu => 'бейшемби',
						fri => 'жума',
						sat => 'ишемби',
						sun => 'жекшемби'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'дүй.',
						tue => 'шейш.',
						wed => 'шарш.',
						thu => 'бейш.',
						fri => 'жума',
						sat => 'ишм.',
						sun => 'жек.'
					},
					narrow => {
						mon => 'Д',
						tue => 'Ш',
						wed => 'Ш',
						thu => 'Б',
						fri => 'Ж',
						sat => 'И',
						sun => 'Ж'
					},
					short => {
						mon => 'дш.',
						tue => 'шш.',
						wed => 'шр.',
						thu => 'бш.',
						fri => 'жм.',
						sat => 'иш.',
						sun => 'жш.'
					},
					wide => {
						mon => 'дүйшөмбү',
						tue => 'шейшемби',
						wed => 'шаршемби',
						thu => 'бейшемби',
						fri => 'жума',
						sat => 'ишемби',
						sun => 'жекшемби'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => '1-чей.',
						1 => '2-чей.',
						2 => '3-чей.',
						3 => '4-чей.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-чейрек',
						1 => '2-чейрек',
						2 => '3-чейрек',
						3 => '4-чейрек'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => '1-ч.',
						1 => '2-ч.',
						2 => '3-ч.',
						3 => '4-ч.'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-чейрек',
						1 => '2-чейрек',
						2 => '3-чейрек',
						3 => '4-чейрек'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{түштөн кийин},
					'am' => q{тң},
					'evening1' => q{кечинде},
					'midnight' => q{түн ортосу},
					'morning1' => q{эртең менен},
					'night1' => q{түн ичинде},
					'noon' => q{чак түш},
					'pm' => q{тк},
				},
				'narrow' => {
					'afternoon1' => q{түшт кйн},
					'am' => q{тң},
					'evening1' => q{кечк},
					'midnight' => q{түн орт},
					'morning1' => q{эртң мн},
					'night1' => q{түн},
					'noon' => q{чт},
					'pm' => q{тк},
				},
				'wide' => {
					'afternoon1' => q{түштөн кийин},
					'am' => q{таңкы},
					'evening1' => q{кечинде},
					'midnight' => q{түн ортосу},
					'morning1' => q{эртең менен},
					'night1' => q{түн ичинде},
					'noon' => q{чак түш},
					'pm' => q{түштөн кийинки},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{түштөн кийин},
					'am' => q{тң},
					'evening1' => q{кечкурун},
					'midnight' => q{түн ортосу},
					'morning1' => q{эртең менен},
					'night1' => q{түн},
					'noon' => q{чак түш},
					'pm' => q{тк},
				},
				'narrow' => {
					'afternoon1' => q{түштөн кийин},
					'am' => q{тң},
					'evening1' => q{кечкурун},
					'midnight' => q{түн ортосу},
					'morning1' => q{эртең менен},
					'night1' => q{түн},
					'noon' => q{чак түш},
					'pm' => q{тк},
				},
				'wide' => {
					'afternoon1' => q{түштөн кийин},
					'am' => q{таңкы},
					'evening1' => q{кечкурун},
					'midnight' => q{түн ортосу},
					'morning1' => q{эртең менен},
					'night1' => q{түн},
					'noon' => q{чак түш},
					'pm' => q{түштөн кийинки},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'б.з.ч.',
				'1' => 'б.з.'
			},
			narrow => {
				'0' => 'б.з.ч.',
				'1' => 'б.з.'
			},
			wide => {
				'0' => 'биздин заманга чейин',
				'1' => 'биздин заман'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, G d-MMMM y-'ж'.},
			'long' => q{d-MMMM G y-'ж'.},
			'medium' => q{dd.MM.y G},
			'short' => q{dd.MM.y GGGGG},
		},
		'gregorian' => {
			'full' => q{y-'ж'., d-MMMM, EEEE},
			'long' => q{y-'ж'., d-MMMM},
			'medium' => q{y-'ж'., d-MMM},
			'short' => q{d/M/yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y-'ж'. d-MMM, E},
			GyMMMd => q{G y-'ж'. d-MMM},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{dd/MM, E},
			MMM => q{LLL},
			MMMEd => q{d-MMM, E},
			MMMMd => q{d MMMM},
			MMMd => q{d-MMM},
			Md => q{dd/MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y-G},
			yyyy => q{y-G},
			yyyyM => q{GGGGG y-MM},
			yyyyMEd => q{GGGGG y-dd-MM, E},
			yyyyMMM => q{G y-'ж'. MMM},
			yyyyMMMEd => q{G y-'ж'. d-MMM, E},
			yyyyMMMM => q{G y-'ж'., MMMM},
			yyyyMMMd => q{G y-'ж'. d-MMM},
			yyyyMd => q{GGGGG y-dd-MM},
			yyyyQQQ => q{G y-'ж'. QQQ},
			yyyyQQQQ => q{G y-'ж'. QQQQ},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y-'ж'.},
			GyMMM => q{G y-'ж'. MMM},
			GyMMMEd => q{G y-'ж'. d-MMM, E},
			GyMMMd => q{G y-'ж'. d-MMM},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{dd-MM, E},
			MMM => q{LLL},
			MMMEd => q{d-MMM, E},
			MMMMW => q{MMM 'айынын' W-'аптасы'},
			MMMMd => q{d-MMMM},
			MMMd => q{d-MMM},
			Md => q{dd-MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{y-MM},
			yMEd => q{y-dd-MM, E},
			yMMM => q{y-'ж'. MMM},
			yMMMEd => q{y-'ж'. d-MMM, E},
			yMMMM => q{y-'ж'., MMMM},
			yMMMd => q{y-'ж'. d-MMM},
			yMd => q{y-dd-MM},
			yQQQ => q{y-'ж'., QQQ},
			yQQQQ => q{y-'ж'., QQQQ},
			yw => q{Y-'жылдын' w-'аптасы'},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd.MM – E, dd.MM},
				d => q{E, dd.MM – E, dd.MM},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} - {1}',
			h => {
				h => q{h–h a},
			},
			hm => {
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				h => q{h–h a v},
			},
			y => {
				y => q{y-'ж'.–y-'ж'. G},
			},
			yM => {
				M => q{MM.y – MM.y G},
				y => q{MM.y – MM.y G},
			},
			yMEd => {
				M => q{E, dd.MM.y – E, dd.MM.y G},
				d => q{E, dd.MM.y – E, dd.MM.y G},
				y => q{E, dd.MM.y – E, dd.MM.y G},
			},
			yMMM => {
				M => q{MMM–MMM y-'ж'. G},
				y => q{MMM y-'ж'. - MMM y-'ж'. G},
			},
			yMMMEd => {
				M => q{E, d-MMM – E, d-MMM y-'ж'. G},
				d => q{E, d – E, d-MMM y-'ж'. G},
				y => q{E, d-MMM y-'ж'. - E, d-MMM y-'ж'. G},
			},
			yMMMM => {
				M => q{G y-'ж'. MMMM – MMMM},
				y => q{G y-'ж'. MMMM – y-'ж'. MMMM},
			},
			yMMMd => {
				M => q{d-MMM – d-MMM y-'ж'. G},
				d => q{d–d-MMM y-'ж'. G},
				y => q{d-MMM y-'ж'. - d-MMM y-'ж'. G},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y G},
				d => q{dd.MM.y – dd.MM.y G},
				y => q{dd.MM.y – dd.MM.y G},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{dd-MM, E – dd-MM, E},
				d => q{dd-MM, E – dd-MM, E},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{d-MMM, E – d-MMM, E},
				d => q{d-MMM, E – d-MMM, E},
			},
			MMMd => {
				M => q{d-MMM – d-MMM},
				d => q{d–d-MMM},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{a h – a h},
				h => q{a h–h},
			},
			hm => {
				a => q{a h:mm – a h:mm},
				h => q{a h:mm–h:mm},
				m => q{a h:mm–h:mm},
			},
			hmv => {
				a => q{a h:mm – a h:mm v},
				h => q{a h:mm–h:mm v},
				m => q{a h:mm–h:mm v},
			},
			hv => {
				a => q{a h – a h v},
				h => q{a h–h v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{y-MM – y-MM},
				y => q{MM.y – MM.y},
			},
			yMEd => {
				M => q{y-dd-MM, E – y-dd-MM, E},
				d => q{E, dd.MM.y – E, dd.MM.y},
				y => q{y-dd-MM, E – y-dd-MM, E},
			},
			yMMM => {
				M => q{MMM–MMM y-'ж'.},
				y => q{MMM y-'ж'. - MMM y-'ж'.},
			},
			yMMMEd => {
				M => q{y-'ж'., d-MMM, E – d-MMM E},
				d => q{y-'ж'., d-MMM, E – d-MMM, E},
				y => q{y-'ж'., d-MMM, E – y-'ж'., d-MMM, E},
			},
			yMMMM => {
				M => q{MMMM – MMMM, y-'ж'.},
				y => q{MMMM, y-'ж'. – MMMM, y-'ж'.},
			},
			yMMMd => {
				M => q{d-MMM – d-MMM y-'ж'.},
				d => q{d–d-MMM y-'ж'.},
				y => q{d-MMM y-'ж'. - d-MMM y-'ж'.},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y},
				d => q{dd.MM.y – dd.MM.y},
				y => q{dd.MM.y – dd.MM.y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} убактысы),
		regionFormat => q({0} (+1)),
		regionFormat => q({0} (+0)),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#Афганистан убактысы#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиджан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Аккра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Аддис-Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмара#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Баги#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантайр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Браззавилл#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Бужумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каир#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар эс Салаам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Жибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Эл Айун#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Йоханнесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Жуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Картум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревилл#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишу#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровиа#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Найроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нжамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Нйаме#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто-Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сао Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Уиндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#Борбордук Африка убактысы#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#Чыгыш Африка убактысы#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#Түштүк Африка убактысы#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Батыш Африка жайкы убактысы#,
				'generic' => q#Батыш Африка убактысы#,
				'standard' => q#Батыш Африка кышкы убакыты#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Аляска жайкы убактысы#,
				'generic' => q#Аляска убактысы#,
				'standard' => q#Аляска кышкы убактысы#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Амазон жайкы убактысы#,
				'generic' => q#Амазон убактысы#,
				'standard' => q#Амазон кышкы убактысы#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкориж#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангуила#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагуаина#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла-Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио Галлегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луи#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуайа#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсион#,
		},
		'America/Bahia' => {
			exemplarCity => q#Байиа#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баийа Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белиз#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бойсе#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буэнос-Айрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кэмбриж Бей#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кайен#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кайман#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чихуахуа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Атикокан#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордова#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста-Рика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куйаба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кюрасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмарксхавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Доусон Грек#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детройт#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Эдмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Эйрунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Эл Салвадор#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Форт Нельсон#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глейс Бей#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нуук#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус Бей#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Түрк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гваделупе#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гуайакил#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гуйана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Галифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Гавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Эрмосилло#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индиана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индиана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсбург, Индиана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Телл Сити, Индиана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вивей, Индиана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винсен, Индиана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Уинамак, Индиана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ямайка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуй#,
		},
		'America/Juneau' => {
			exemplarCity => q#Жуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичелло, Кентукки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендейк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Пас#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос-Анжелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луизвилл#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуэр Принсес Куате#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масейо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиник#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоза#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мехико шаары#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтерей#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монсерат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Нассау#,
		},
		'America/New_York' => {
			exemplarCity => q#Нью-Йорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Норониа#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Беула, Түндүк Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Түндүк Дакотанын борбору#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нью-Салем, Түндүк Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангиртуң#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Феникс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт оф Спейн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто Велио#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуэрто-Рико#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#Пунта-Аренас#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рейни Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Рэнкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Регина#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолут#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта Изабел#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантиаго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сао Пауло#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Иттоккортоормиит#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сент-Бартелеми#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент Жонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент-Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Санта Лючия#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент-Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент-Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт Каррент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигальпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Сандер Бей#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Уайтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Уиннипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Якутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Йеллоунайф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Түндүк Америка, борбордук жайкы убакыт#,
				'generic' => q#Түндүк Америка, борбордук убакыт#,
				'standard' => q#Түндүк Америка, борбордук кышкы убактысы#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Түндүк Америка, чыгыш жайкы убактысы#,
				'generic' => q#Түндүк Америка, чыгыш убактысы#,
				'standard' => q#Түндүк Америка, чыгыш кышкы убактысы#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Түндүк Америка, тоо жайкы убактысы#,
				'generic' => q#Түндүк Америка, тоо убактысы#,
				'standard' => q#Түндүк Америка, тоо кышкы убактысы#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Түндүк Америка, Тынч океан жайкы убактысы#,
				'generic' => q#Түндүк Америка, Тынч океан убактысы#,
				'standard' => q#Түндүк Америка, Тынч океан кышкы убактысы#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кейси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дэвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Дюмон д-Урвил#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Моусон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#МакМёрдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Саоа#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Тролл#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q#Апиа жайкы убактысы#,
				'generic' => q#Апиа убактысы#,
				'standard' => q#Апиа кышкы убакыты#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#Арабия жайкы убакыты#,
				'generic' => q#Арабия убактысы#,
				'standard' => q#Арабия кышкы убакыты#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгйербиен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#Аргентина жайкы убактысы#,
				'generic' => q#Аргентина убактысы#,
				'standard' => q#Аргентина кышкы убактысы#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Батыш Аргентина жайкы убактысы#,
				'generic' => q#Батыш Аргентина убактысы#,
				'standard' => q#Батыш Аргентина кышкы убактысы#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Армения жайкы убактысы#,
				'generic' => q#Армения убактысы#,
				'standard' => q#Армения кышкы убакыты#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алматы#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Амман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадыр#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Атырау#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахрейн#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Барнаул#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бейрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Бруней#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калькутта#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чойбалсан#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дакка#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубай#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#Фамагуста#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Гонконг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркутск#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Жакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Жайапура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Иерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Кандыга#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноярск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучиң#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувейт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макау#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макассар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никосия#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пномпень#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пхеньян#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кызылорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Рийад#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхай#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Среднеколымск#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тайпей#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Тегеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тимпу#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Томск#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан-Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Үрүмчү#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Усть-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Виентиан#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Якутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Атлантика жайкы убактысы#,
				'generic' => q#Атлантика убактысы#,
				'standard' => q#Атлантика кышкы убактысы#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азор#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуда#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канари#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Капе Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарер#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадейра#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рейкьявик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Түштүк Жоржия#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Сент Елена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стэнли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брисбен#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Броукен Хил#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Керри#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Юкла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мельбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сидней#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Австралия борбордук жайкы убактысы#,
				'generic' => q#Австралия борбордук убактысы#,
				'standard' => q#Австралия борбордук кышкы убакыты#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Австралия борбордук чыгыш жайкы убактысы#,
				'generic' => q#Австралия борбордук батыш убактысы#,
				'standard' => q#Австралия борбордук батыш кышкы убакыты#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Австралия чыгыш жайкы убактысы#,
				'generic' => q#Австралия чыгыш убактысы#,
				'standard' => q#Австралия чыгыш кышкы убакыты#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Австралия батыш жайкы убактысы#,
				'generic' => q#Австралия батыш убактысы#,
				'standard' => q#Австралия батыш кышкы убакыты#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Азербайжан жайкы убактысы#,
				'generic' => q#Азербайжан убактысы#,
				'standard' => q#Азербайжан кышкы убакыты#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Азорс жайкы убактысы#,
				'generic' => q#Азор убактысы#,
				'standard' => q#Азор кышкы убакыты#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Бангладеш жайкы убактысы#,
				'generic' => q#Бангладеш убактысы#,
				'standard' => q#Бангладеш кышкы убакыты#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Бутан убактысы#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#Боливия убактысы#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Бразилия жайкы убактысы#,
				'generic' => q#Бразилия убактысы#,
				'standard' => q#Бразилия кышкы убактысы#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Бруней Даруссалам убактысы#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Капе Верде жайкы убактысы#,
				'generic' => q#Капе Верде убактысы#,
				'standard' => q#Капе Верде кышкы убакыты#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#Чаморро убактысы#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Чатам жайкы убактысы#,
				'generic' => q#Чатам убактысы#,
				'standard' => q#Чатам кышкы убакыт#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Чили жайкы убактысы#,
				'generic' => q#Чили убактысы#,
				'standard' => q#Чили кышкы убактысы#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Кытай жайкы убакыты#,
				'generic' => q#Кытай убактысы#,
				'standard' => q#Кытай кышкы убакыты#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#Чойбалсан жайкы убактысы#,
				'generic' => q#Чойбалсан убактысы#,
				'standard' => q#Чойбалсан кышкы убакыты#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#Крисмас аралынын убактысы#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#Кокос аралдарынын убактысы#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Колумбия жайкы убактысы#,
				'generic' => q#Колумбия убактысы#,
				'standard' => q#Колумбия кышкы убактысы#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Кук аралдарынын жарым жайкы убактысы#,
				'generic' => q#Кук аралдарынын убактысы#,
				'standard' => q#Кук аралдарынын кышкы убакыты#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Куба жайкы убактысы#,
				'generic' => q#Куба убактысы#,
				'standard' => q#Куба кышкы убактысы#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#Дэвис убактысы#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#Дюмон-д-Урвил убактысы#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Чыгыш Тимор убактысы#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#Истер аралынын жайкы убакыты#,
				'generic' => q#Истер аралынын убактысы#,
				'standard' => q#Истер аралынын кышкы убакыты#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#Экуадор убактысы#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#Бирдиктүү дүйнөлүк убакыт#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Белгисиз шаар#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андорра#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Астрахань#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Афины#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брюссель#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Бухарест#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапешт#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бузинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинев#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенгаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дублин#,
			long => {
				'daylight' => q#Ирландия кышкы убакыты#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернси#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хельсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Мэн аралы#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Стамбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Жерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Киров#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лиссабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Любляна#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q#Британия жайкы убактысы#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Мальта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Мариехамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париж#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Саратов#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферополь#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопйе#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#София#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокгольм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Таллин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Ульяновск#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Фадуц#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Вена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вильнюс#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожье#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цюрих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Борбордук Европа жайкы убактысы#,
				'generic' => q#Борбордук Европа убактысы#,
				'standard' => q#Борбордук Европа кышкы убакыты#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Чыгыш Европа жайкы убактысы#,
				'generic' => q#Чыгыш Европа убактысы#,
				'standard' => q#Чыгыш Европа кышкы убакыты#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#Калининград жана Минск убактысы#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Батыш Европа жайкы убактысы#,
				'generic' => q#Батыш Европа убактысы#,
				'standard' => q#Батыш Европа кышкы убакыты#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Фолкленд аралдарынын жайкы убактысы#,
				'generic' => q#Фолкленд аралдарынын убактысы#,
				'standard' => q#Фолкленд аралдарынын кышкы убакыты#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Фижи жайкы убактысы#,
				'generic' => q#Фижи убактысы#,
				'standard' => q#Фижи кышкы убакыты#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Француз Гвиана убактысы#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Француз Түштүгү жана Антарктика убактысы#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#Гринвич боюнча орточо убакыт#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Галапагос убактысы#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#Гамбие убактысы#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Грузия жайкы убактысы#,
				'generic' => q#Грузия убактысы#,
				'standard' => q#Грузия кышкы убакыты#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#Гилберт убактысы#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Чыгыш Гренландия жайкы убактысы#,
				'generic' => q#Чыгыш Гренландия убактысы#,
				'standard' => q#Чыгыш Гренландия кышкы убактысы#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Батыш Гренландия жайкы убактысы#,
				'generic' => q#Батыш Гренландия убактысы#,
				'standard' => q#Батыш Гренландия кышкы убактысы#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#Булуңдун стандарттык убакыты#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#Гвиана убактысы#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Гавайи-Алеут жайкы убактысы#,
				'generic' => q#Гавайи-Алеут убактысы#,
				'standard' => q#Гавайи-Алеут кышкы убактысы#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Гонконг жайкы убактысы#,
				'generic' => q#Гонконг убактысы#,
				'standard' => q#Гонконг кышкы убакыты#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Ховд жайкы убактысы#,
				'generic' => q#Ховд убактысы#,
				'standard' => q#Ховд кышкы убакыты#,
			},
		},
		'India' => {
			long => {
				'standard' => q#Индия убактысы#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Крисмас#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморо#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Маэ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Мальдив аралдары#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврикий#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Майотт#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реюнион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Инди океан убактысы#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#Индокытай убактысы#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Борбордук Индонезия убактысы#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Чыгыш Индонезия убактысы#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Батыш Индонезия убактысы#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#Иран күндүзгү убактысы#,
				'generic' => q#Иран убактысы#,
				'standard' => q#Иран кышкы убакыты#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Иркутск жайкы убакыты#,
				'generic' => q#Иркутск убактысы#,
				'standard' => q#Иркутск кышкы убакыты#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Израиль жайкы убакыты#,
				'generic' => q#Израиль убакыты#,
				'standard' => q#Израиль кышкы убакыты#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Жапон жайкы убактысы#,
				'generic' => q#Жапон убактысы#,
				'standard' => q#Жапон кышкы убакыты#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#Чыгыш Казакстан убактысы#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#Батыш Казакстан убактысы#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Корея жайкы убакыты#,
				'generic' => q#Корея убактысы#,
				'standard' => q#Корея кышкы убакыты#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Косрае убактысы#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Красноярск жайкы убактысы#,
				'generic' => q#Красноярск убактысы#,
				'standard' => q#Красноярск кышкы убакыты#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Кыргызстан убактысы#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#Лайн аралдарынын убактысы#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Лорд Хау жайкы убактысы#,
				'generic' => q#Лорд Хау убактысы#,
				'standard' => q#Лорд Хау кышкы убакыты#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#Макуари убактысы#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Магадан жайкы убактысы#,
				'generic' => q#Магадан убактысы#,
				'standard' => q#Магадан кышкы убакыты#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#Малайзия убактысы#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#Мальдив убактысы#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Маркезас убактысы#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#Маршалл аралдарынын убактысы#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Маврикий жайкы убактысы#,
				'generic' => q#Маврикий убактысы#,
				'standard' => q#Маврикий кышкы убакыты#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Моусон убактысы#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#Түндүк-чыгыш Мексика жайкы убактысы#,
				'generic' => q#Түндүк-чыгыш Мексика убактысы#,
				'standard' => q#Түндүк-чыгыш Мексика кышкы убактысы#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#Мексика, Тынч океан жайкы убактысы#,
				'generic' => q#Мексика, Тынч океан убактысы#,
				'standard' => q#Мексика, Тынч океан кышкы убактысы#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Улан Батор жайкы убактысы#,
				'generic' => q#Улан Батор убактысы#,
				'standard' => q#Улан Батор кышкы убакыты#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Москва жайкы убактысы#,
				'generic' => q#Москва убактысы#,
				'standard' => q#Москва кышкы убакыты#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#Мйанмар убактысы#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Науру убактысы#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Непал убактысы#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Жаңы Каледония жайкы убактысы#,
				'generic' => q#Жаңы Каледония убактысы#,
				'standard' => q#Жаңы Каледония кышкы убакыты#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Жаңы Зеландия жайкы убакыты#,
				'generic' => q#Жаңы Зеландия убактысы#,
				'standard' => q#Жаңы Зеландия кышкы убакыты#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Нюфаундлэнд жайкы убактысы#,
				'generic' => q#Нюфаундлэнд убактысы#,
				'standard' => q#Нюфаундлэнд кышкы убактысы#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#Ниуэ убактысы#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#Норфолк убактысы#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Фернандо де Норонья жайкы убактысы#,
				'generic' => q#Фернандо де Норонья убактысы#,
				'standard' => q#Фернандо де Норонья кышкы убактысы#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Новосибирск жайкы убактысы#,
				'generic' => q#Новосибирск убактысы#,
				'standard' => q#Новосибирск кышкы убакыты#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Омск жайкы убактысы#,
				'generic' => q#Омск убактысы#,
				'standard' => q#Омск кышкы убакыты#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апиа#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Оклэнд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Бугенвиль#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатем#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Истер#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Эфат#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Эндербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фижи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбие#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гуадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Гонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Жонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Козрае#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Куажалейн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Мажуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркезас#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидуэй#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуэ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкэрн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понпей#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт Моэрсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раготонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сайпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Чуук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Уейк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Уолис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Пакистан жайкы убактысы#,
				'generic' => q#Пакистан убактысы#,
				'standard' => q#Пакистан кышкы убакыты#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Палау убактысы#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Папуа-Жаңы Гвинея убакыты#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Парагвай жайкы убактысы#,
				'generic' => q#Парагвай убактысы#,
				'standard' => q#Парагвай кышкы убактысы#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Перу жайкы убактысы#,
				'generic' => q#Перу убактысы#,
				'standard' => q#Перу кышкы убактысы#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Филиппин аралдарынын жайкы убактысы#,
				'generic' => q#Филиппин аралдарынын убактысы#,
				'standard' => q#Филиппин аралдарынын кышкы убактысы#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#Феникс аралдарынын убактысы#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Сен Пьер жана Микелон жайкы убактысы#,
				'generic' => q#Сен Пьер жана Микелон убактысы#,
				'standard' => q#Сен Пьер жана Микелон кышкы убактысы#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#Питкэрнг убактысы#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Понапе убактысы#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#Пхеньян убакыты#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#Реюнион убактысы#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#Ротера убактысы#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Сахалин жайкы убактысы#,
				'generic' => q#Сахалин убактысы#,
				'standard' => q#Сахалин кышкы убакыты#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Самоа жайкы убактысы#,
				'generic' => q#Самоа убактысы#,
				'standard' => q#Самоа кышкы убакыты#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Сейшел убактысы#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Сингапур убактысы#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#Соломон аралдарынын убактысы#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#Түштүк Жоржия убактысы#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Суринаме убактысы#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#Саоа убактысы#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#Таити убактысы#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Тайпей жайкы убакыты#,
				'generic' => q#Тайпей убактысы#,
				'standard' => q#Тайпей кышкы убакыты#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Тажикстан убактысы#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Токелау убактысы#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Тонга жайкы убактысы#,
				'generic' => q#Тонга убактысы#,
				'standard' => q#Тонга кышкы убакыты#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#Чуук убактысы#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Түркмөнстан жайкы убактысы#,
				'generic' => q#Түркмөнстан убактысы#,
				'standard' => q#Түркмөнстан кышкы убакыты#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#Тувалу убактысы#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Уругвай жайкы убактысы#,
				'generic' => q#Уругвай убактысы#,
				'standard' => q#Уругвай кышкы убактысы#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Өзбекстан жайкы убактысы#,
				'generic' => q#Өзбекстан убактысы#,
				'standard' => q#Өзбекстан кышкы убакыты#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Вануату жайкы убактысы#,
				'generic' => q#Вануату убактысы#,
				'standard' => q#Вануату кышкы убакыты#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Венесуэла убактысы#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Владивосток жайкы убактысы#,
				'generic' => q#Владивосток убактысы#,
				'standard' => q#Владивосток кышкы убакыты#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Волгоград жайкы убактысы#,
				'generic' => q#Волгоград убактысы#,
				'standard' => q#Волгоград кышкы убакыты#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Восток убактысы#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Уейк аралдарынын убактысы#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Уолис жана Футуна убактысы#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Якутск жайкы убактысы#,
				'generic' => q#Якутск убактысы#,
				'standard' => q#Якутск кышкы убакыты#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Екатеринбург жайкы убактысы#,
				'generic' => q#Екатеринбург убактысы#,
				'standard' => q#Екатеринбург кышкы убакыты#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
