package Locale::CLDR::Transformations::Bgn::Uz_cyrl::Uz;
# This file auto generated from Data\common\transforms\Uzbek-Latin-BGN.xml
#	on Fri 13 Oct  9:03:49 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.2');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^umi:\G[АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЪЬЭЮЯЎҚҒҲабвгдеёжзийклмнопрстуфхцчшъьэюяўқғҳ])/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFD),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q([аеёиоуэюяў]ы),
					result  => q(y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q([АЕЁИОУЭЮЯЎ][Ыы]),
					result  => q(Y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(А),
					result  => q(A),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(а),
					result  => q(a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Б),
					result  => q(B),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(б),
					result  => q(b),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(В),
					result  => q(W),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(в),
					result  => q(w),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ГҲ),
					result  => q(G·H),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Гҳ),
					result  => q(G·h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гҳ),
					result  => q(g·h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Г),
					result  => q(G),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(г),
					result  => q(g),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Д),
					result  => q(D),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(д),
					result  => q(d),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[АЕЁИОУЭЮЯЎ]|[ЙЬ])),
					replace => q(Е),
					result  => q(YE),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[аеёиоуэюяў]|[йь])),
					replace => q(Е),
					result  => q(Ye),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(Е),
					result  => q(Ye),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Е),
					result  => q(E),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[АЕЁИОУЭЮЯЎ]|[аеёиоуэюяў]|[ЙйЬь])),
					replace => q(е),
					result  => q(ye),
					revisit => 0,
				},
				{
					before  => q([^ \p{L} \p{M} \p{N}]),
					after   => q(),
					replace => q(е),
					result  => q(ye),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(е),
					result  => q(e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[бвгджзйклмнпрстфхцчшъьқғҳ]|[аеёиоуэюяў])),
					replace => q(Ё),
					result  => q(Yo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ё),
					result  => q(YO),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ё),
					result  => q(yo),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ж),
					result  => q(J),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ж),
					result  => q(j),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(З),
					result  => q(Z),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(з),
					result  => q(z),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(И),
					result  => q(I),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(и),
					result  => q(i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Й),
					result  => q(Y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(й),
					result  => q(y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(КҲ),
					result  => q(K·H),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Кҳ),
					result  => q(K·h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кҳ),
					result  => q(k·h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(К),
					result  => q(K),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(к),
					result  => q(k),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Л),
					result  => q(L),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(л),
					result  => q(l),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(М),
					result  => q(M),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(м),
					result  => q(m),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Н),
					result  => q(N),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(н),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(О),
					result  => q(O),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(о),
					result  => q(o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(П),
					result  => q(P),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(п),
					result  => q(p),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Р),
					result  => q(R),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(р),
					result  => q(r),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(СҲ),
					result  => q(S·H),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Сҳ),
					result  => q(S·h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сҳ),
					result  => q(s·h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(С),
					result  => q(S),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(с),
					result  => q(s),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Т),
					result  => q(T),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(т),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(У),
					result  => q(Ū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(у),
					result  => q(ū),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ф),
					result  => q(F),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ф),
					result  => q(f),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[бвгджзйклмнпрстфхцчшъьқғҳ]|[аеёиоуэюяў])),
					replace => q(Х),
					result  => q(Kh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Х),
					result  => q(KH),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(х),
					result  => q(kh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ЦҲ),
					result  => q(TS·H),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Цҳ),
					result  => q(Ts·h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цҳ),
					result  => q(ts·h),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[бвгджзйклмнпрстфхцчшъьқғҳ]|[аеёиоуэюяў])),
					replace => q(Ц),
					result  => q(Ts),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ц),
					result  => q(TS),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ц),
					result  => q(ts),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[бвгджзйклмнпрстфхцчшъьқғҳ]|[аеёиоуэюяў])),
					replace => q(Ч),
					result  => q(Ch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ч),
					result  => q(CH),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ч),
					result  => q(ch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[бвгджзйклмнпрстфхцчшъьқғҳ]|[аеёиоуэюяў])),
					replace => q(Ш),
					result  => q(Sh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ш),
					result  => q(SH),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ш),
					result  => q(sh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ъ),
					result  => q(ʹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ъ),
					result  => q(ʹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ь),
					result  => q(ʹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ь),
					result  => q(ʹ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Э),
					result  => q(e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(э),
					result  => q(e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[бвгджзйклмнпрстфхцчшъьқғҳ]|[аеёиоуэюяў])),
					replace => q(Ю),
					result  => q(Yu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ю),
					result  => q(YU),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ю),
					result  => q(yu),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[бвгджзйклмнпрстфхцчшъьқғҳ]|[аеёиоуэюяў])),
					replace => q(Я),
					result  => q(Ya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Я),
					result  => q(YA),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(я),
					result  => q(ya),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ў),
					result  => q(Ŭ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ў),
					result  => q(ŭ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Қ),
					result  => q(Q),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(қ),
					result  => q(q),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[бвгджзйклмнпрстфхцчшъьқғҳ]|[аеёиоуэюяў])),
					replace => q(Ғ),
					result  => q(Gh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ғ),
					result  => q(GH),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ғ),
					result  => q(gh),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ҳ),
					result  => q(H),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ҳ),
					result  => q(h),
					revisit => 0,
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
