#!/usr/bin/perl -w
#
#    BreakIterator.t
#
#    Copyright (c) 2000 Brian Stell
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

use strict;
use Test;
BEGIN { plan tests => 5 }
use ExtUtils::testlib;

use utf8;
use ICU qw(U_ZERO_ERROR);
use ICU::BreakIterator qw(DONE);
use ICU::Locale;

#
# Make sure we always use the same fallback locale
#
my $default_locale = new ICU::Locale('en_US');
ICU::Locale->setDefault($default_locale);

ok(check_constants(), 1);
ok(check_createCharacterInstance(), 1);
ok(check_createLineInstance(), 1);
ok(check_createSentenceInstance(), 1);
ok(check_createWordInstance(), 1);

########################################################################
#
# The subroutines and tests
#
# (in alphabetic order)
#
########################################################################

sub check_createCharacterInstance {
  my $text = "hello, world\nIt is me. I'm back.";
  my $status = U_ZERO_ERROR;
  my $loc = new ICU::Locale('en_US');
  my $bi = ICU::BreakIterator->createCharacterInstance($loc, \$status);
  if (!defined($bi)) {
    print "failed to create character interator\n";
    return(0);
  }
  $bi->setText($text);
  $bi->first();
  if ($bi->next() != 1) {
    print "next() != 1\n";
    return(0);
  }
  if ($bi->next() != 2) {
    print "next() != 2\n";
    return(0);
  }
  if ($bi->next() != 3) {
    print "next() != 3\n";
    return(0);
  }
  return(1);
}

sub check_createLineInstance {
  my $text = "hello, world\nIt is me. I'm back.";
  my $status = U_ZERO_ERROR;
  my $loc = new ICU::Locale('en_US');
  my $bi = ICU::BreakIterator->createLineInstance($loc, \$status);
  if (!defined($bi)) {
    print "failed to create line interator\n";
    return(0);
  }
  $bi->setText($text);
  $bi->first();
  if ($bi->next() != 7) {
    print "next() != 7\n";
    return(0);
  }
  if ($bi->next() != 13) {
    print "next() != 13\n";
    return(0);
  }
  if ($bi->next() != 16) {
    print "next() != 16\n";
    return(0);
  }
  if ($bi->next() != 19) {
    print "next() != 19\n";
    return(0);
  }
  if ($bi->next() != 23) {
    print "next() != 23\n";
    return(0);
  }
  if ($bi->next() != 27) {
    print "next() != 27\n";
    return(0);
  }
  if ($bi->next() != 32) {
    print "next() != 32\n";
    return(0);
  }
  if ($bi->next() != -1) {
    print "next() != -1\n";
    return(0);
  }
  return(1);
}

sub check_createSentenceInstance {
  my $text = "hello, world\nIt is me. I'm back.";
  my $status = U_ZERO_ERROR;
  my $loc = new ICU::Locale('en_US');
  my $bi = ICU::BreakIterator->createSentenceInstance($loc, \$status);
  if (!defined($bi)) {
    print "failed to create sentence interator\n";
    return(0);
  }
  $bi->setText($text);
  $bi->first();
  if ($bi->next() != 23) {
    print "next() != 23\n";
    return(0);
  }
  if ($bi->next() != 32) {
    print "next() != 32\n";
    return(0);
  }
  if ($bi->next() != -1) {
    print "next() != -1\n";
    return(0);
  }
  return(1);
}

sub check_createWordInstance {
  my $text = "hello, world\nIt is me. I'm back.";
  my $status = U_ZERO_ERROR;
  my $loc = new ICU::Locale('en_US');
  my $bi = ICU::BreakIterator->createWordInstance($loc, \$status);
  if (!defined($bi)) {
    print "failed to create word interator\n";
    return(0);
  }
  $bi->setText($text);
  if ($bi->isBoundary(9) != 0) {
    print "isBoundary(9) != 0\n";
    return(0);
  }
  if ($bi->isBoundary(13) != 1) {
    print "isBoundary(13) != 1\n";
    return(0);
  }
  if ($bi->preceding(18) != 16) {
    print "preceding(18) != 16\n";
    return(0);
  }
  if ($bi->next(3) != 21) {
    print "next(3) != 21\n";
    return(0);
  }
  if ($bi->last() != 32) {
    print "last() != 32\n";
    return(0);
  }
  $bi->first();
  if ($bi->next() != 5) {
    print "next() != 5\n";
    return(0);
  }
  if ($bi->next() != 6) {
    print "next() != 6\n";
    return(0);
  }
  if ($bi->next() != 7) {
    print "next() != 7\n";
    return(0);
  }
  if ($bi->next() != 12) {
    print "next() != 12\n";
    return(0);
  }
  if ($bi->next() != 13) {
    print "next() != 13\n";
    return(0);
  }
  if ($bi->next() != 15) {
    print "next() != 15\n";
    return(0);
  }
  if ($bi->next() != 16) {
    print "next() != 16\n";
    return(0);
  }
  if ($bi->next() != 18) {
    print "next() != 18\n";
    return(0);
  }
  if ($bi->next() != 19) {
    print "next() != 19\n";
    return(0);
  }
  if ($bi->next() != 21) {
    print "next() != 21\n";
    return(0);
  }
  if ($bi->next() != 22) {
    print "next() != 22\n";
    return(0);
  }
  return(1);
}

sub check_constants {
    if ((DONE == -1)) {
        return(1);
    }
    else {
        return(0);
    }
}

exit(0);

