/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached.client;

import java.nio.ByteBuffer;
import org.couchbase.mock.memcached.protocol.CommandCode;

public class CommandBuilder {
    static int opaqueCounter = 0;
    private byte[] key = new byte[0];
    private byte[] value = new byte[0];
    private byte[] extras = new byte[0];
    private long cas = 0L;
    private int opaque = opaqueCounter++;
    private short vbucket = 0;
    private final CommandCode command;

    public CommandBuilder(CommandCode command) {
        this.command = command;
    }

    public CommandBuilder key(String key, short vbucket) {
        this.key = key.getBytes();
        this.vbucket = vbucket;
        return this;
    }

    public CommandBuilder value(String value) {
        this.value = value.getBytes();
        return this;
    }

    public CommandBuilder value(byte[] value) {
        this.value = value;
        return this;
    }

    public CommandBuilder cas(long cas) {
        this.cas = cas;
        return this;
    }

    public CommandBuilder extras(byte[] extras) {
        this.extras = extras;
        return this;
    }

    public byte[] build() {
        int totalLen = 24 + this.key.length + this.value.length + this.extras.length;
        byte[] ret = new byte[totalLen];
        ByteBuffer buffer = ByteBuffer.wrap(ret);
        buffer.put((byte)-128);
        buffer.put((byte)this.command.cc());
        buffer.putShort((short)this.key.length);
        buffer.put((byte)this.extras.length);
        buffer.put((byte)0);
        buffer.putShort(this.vbucket);
        buffer.putInt(totalLen - 24);
        buffer.putInt(this.opaque);
        buffer.putLong(this.cas);
        buffer.put(this.extras);
        buffer.put(this.key);
        buffer.put(this.value);
        return ret;
    }
}

