package Task::CPANAuthors;
$Task::CPANAuthors::VERSION = '1.005';
use strict;
use warnings;

'BOOK';

__END__

=encoding utf8

=head1 NAME

Task::CPANAuthors - All Acme::CPANAuthors modules at once

=head1 SYNOPSIS

    cpan Task::CPANAuthors

    cpanp -i Task::CPANAuthors

    cpanm Task::CPANAuthors

=head1 DESCRIPTION

This tasks installs all L<Acme::CPANAuthors> modules.

=head1 CONTENT

L<Acme::CPANAuthors> - We are CPAN authors

L<Task::CPANAuthors::Regional> - All regional Acme::CPANAuthors modules at once

L<Acme::CPANAuthors::Acme::CPANAuthors::Authors> - We are CPAN authors who have authored Acme::CPANAuthors modules

L<Acme::CPANAuthors::AnyEvent> - We are CPAN Authors of AnyEvent!

L<Acme::CPANAuthors::BackPAN::OneHundred> - The CPAN Authors who have 100+ distributions on BackPAN

L<Acme::CPANAuthors::Booking> - Booking.com CPAN authors

L<Acme::CPANAuthors::CPAN::MostScripts> - Authors with the most scripts on CPAN

L<Acme::CPANAuthors::CPAN::OneHundred> - The CPAN Authors who have 100+ distributions on CPAN

L<Acme::CPANAuthors::CPAN::TopDepended> - Authors with the largest number of distributions depending on one of his/her modules

L<Acme::CPANAuthors::CPAN::TopDepended::ByOthers> - Authors with the largest number of other authors' distributions depending on one of his/her modules

L<Acme::CPANAuthors::CPANTS::FiveOrMore> - CPAN Authors with five or more dists

L<Acme::CPANAuthors::CodeRepos> - We are CPAN authors using CodeRepos

L<Acme::CPANAuthors::DebianDev> - CPAN authors who are Debian Developers

L<Acme::CPANAuthors::DualLife> - We are CPAN Authors of Dual Life core modules

L<Acme::CPANAuthors::GeekHouse> - We're CPAN Authors in The Geek House

L<Acme::CPANAuthors::GitHub> - CPAN Authors with GitHub repositories

L<Acme::CPANAuthors::InMemoriam> - Remembering our fallen heroes

L<Acme::CPANAuthors::MBTI> - CPAN Authors by MBTI Type

L<Acme::CPANAuthors::MetaSyntactic> - MetaSyntactic CPAN authors

L<Acme::CPANAuthors::Misanthrope> - The CPAN authors who see into your soul with perfect clarity

L<Acme::CPANAuthors::Nonhuman> - We are non-human CPAN authors

L<Acme::CPANAuthors::Not> - We are not CPAN authors

L<Acme::CPANAuthors::POE> - We are CPAN Authors of POE

L<Acme::CPANAuthors::Pumpkings> - We are pumpkings

L<Acme::CPANAuthors::ToBeLike> - BeLike other CPAN Authors

L<Acme::CPANAuthors::You::re_using> - We are the CPAN authors that have written the modules installed on your perl!

=head1 OTHER CPANAUTHORS MODULES

L<Task::CPANAuthors::STRO> is not related to L<Acme::CPANAuthors>.

=head1 COPYRIGHT

Copyright 2014 Philippe Bruhat (BooK), All Rights Reserved.

=head1 LICENSE

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
