use Test::More tests => 181;
use strict;
use MARC::Charset;

BEGIN {
    use_ok('MARC::Charset::ArabicBasic');
    use_ok('MARC::Charset::ArabicExtended');
}

my $cs = MARC::Charset->new();
$cs->g0( MARC::Charset::ArabicBasic->new() );
$cs->g1( MARC::Charset::ArabicExtended->new() );

## make sure we were able to set the G0 and G1 charsets

isa_ok( $cs->g0(), 'MARC::Charset::ArabicBasic' );
isa_ok( $cs->g1(), 'MARC::Charset::ArabicExtended' );

## see if we can use valid Arabic characters

my %valid = (

chr(0x21)=>chr(0x0021),
chr(0x22)=>chr(0x0022),
chr(0x23)=>chr(0x0023),
chr(0x24)=>chr(0x0024),
chr(0x25)=>chr(0x066A),
chr(0x26)=>chr(0x0026),
chr(0x27)=>chr(0x0027),
chr(0x28)=>chr(0x0028),
chr(0x29)=>chr(0x0029),
chr(0x2A)=>chr(0x066D),
chr(0x2B)=>chr(0x002B),
chr(0x2C)=>chr(0x060C),
chr(0x2D)=>chr(0x002D),
chr(0x2E)=>chr(0x002E),
chr(0x2F)=>chr(0x002F),
chr(0x30)=>chr(0x0660),
chr(0x31)=>chr(0x0661),
chr(0x32)=>chr(0x0662),
chr(0x33)=>chr(0x0663),
chr(0x34)=>chr(0x0664),
chr(0x35)=>chr(0x0665),
chr(0x36)=>chr(0x0666),
chr(0x37)=>chr(0x0667),
chr(0x38)=>chr(0x0668),
chr(0x39)=>chr(0x0669),
chr(0x3A)=>chr(0x003A),
chr(0x3B)=>chr(0x061B),
chr(0x3C)=>chr(0x003C),
chr(0x3D)=>chr(0x003D),
chr(0x3E)=>chr(0x003E),
chr(0x3F)=>chr(0x061F),
chr(0x41)=>chr(0x0621),
chr(0x42)=>chr(0x0622),
chr(0x43)=>chr(0x0623),
chr(0x44)=>chr(0x0624),
chr(0x45)=>chr(0x0625),
chr(0x46)=>chr(0x0626),
chr(0x47)=>chr(0x0627),
chr(0x48)=>chr(0x0628),
chr(0x49)=>chr(0x0629),
chr(0x4A)=>chr(0x062A),
chr(0x4B)=>chr(0x062B),
chr(0x4C)=>chr(0x062C),
chr(0x4D)=>chr(0x062D),
chr(0x4E)=>chr(0x062E),
chr(0x4F)=>chr(0x062F),
chr(0x50)=>chr(0x0630),
chr(0x51)=>chr(0x0631),
chr(0x52)=>chr(0x0632),
chr(0x53)=>chr(0x0633),
chr(0x54)=>chr(0x0634),
chr(0x55)=>chr(0x0635),
chr(0x56)=>chr(0x0636),
chr(0x57)=>chr(0x0637),
chr(0x58)=>chr(0x0638),
chr(0x59)=>chr(0x0639),
chr(0x5A)=>chr(0x063A),
chr(0x5B)=>chr(0x005B),
chr(0x5D)=>chr(0x005D),
chr(0x60)=>chr(0x0640), 
chr(0x61)=>chr(0x0641), 
chr(0x62)=>chr(0x0642), 
chr(0x63)=>chr(0x0643), 
chr(0x64)=>chr(0x0644), 
chr(0x65)=>chr(0x0645), 
chr(0x66)=>chr(0x0646), 
chr(0x67)=>chr(0x0647), 
chr(0x68)=>chr(0x0648), 
chr(0x69)=>chr(0x0649), 
chr(0x6A)=>chr(0x064A), 
chr(0x6B)=>chr(0x064B), 
chr(0x6C)=>chr(0x064C), 
chr(0x6D)=>chr(0x064D), 
chr(0x6E)=>chr(0x064E), 
chr(0x6F)=>chr(0x064F), 
chr(0x70)=>chr(0x0650), 
chr(0x71)=>chr(0x0651), 
chr(0x72)=>chr(0x0652), 
chr(0x73)=>chr(0x0671), 
chr(0x74)=>chr(0x0670), 
chr(0x78)=>chr(0x066C), 
chr(0x79)=>chr(0x201D), 
chr(0x7A)=>chr(0x201C), 
chr(0xA1)=>chr(0x06FD), 
chr(0xA2)=>chr(0x0672), 
chr(0xA3)=>chr(0x0673), 
chr(0xA4)=>chr(0x0679), 
chr(0xA5)=>chr(0x067A), 
chr(0xA6)=>chr(0x067B), 
chr(0xA7)=>chr(0x067C), 
chr(0xA8)=>chr(0x067D), 
chr(0xA9)=>chr(0x067E), 
chr(0xAA)=>chr(0x067F), 
chr(0xAB)=>chr(0x0680), 
chr(0xAC)=>chr(0x0681), 
chr(0xAD)=>chr(0x0682), 
chr(0xAE)=>chr(0x0683), 
chr(0xAF)=>chr(0x0684), 
chr(0xB0)=>chr(0x0685), 
chr(0xB1)=>chr(0x0686), 
chr(0xB2)=>chr(0x06BF), 
chr(0xB3)=>chr(0x0687), 
chr(0xB4)=>chr(0x0688), 
chr(0xB5)=>chr(0x0689), 
chr(0xB6)=>chr(0x068A), 
chr(0xB7)=>chr(0x068B), 
chr(0xB8)=>chr(0x068C), 
chr(0xB9)=>chr(0x068D), 
chr(0xBA)=>chr(0x068E), 
chr(0xBB)=>chr(0x068F), 
chr(0xBC)=>chr(0x0690), 
chr(0xBD)=>chr(0x0691), 
chr(0xBE)=>chr(0x0692), 
chr(0xBF)=>chr(0x0693), 
chr(0xC0)=>chr(0x0694), 
chr(0xC1)=>chr(0x0695), 
chr(0xC2)=>chr(0x0696), 
chr(0xC3)=>chr(0x0697), 
chr(0xC4)=>chr(0x0698), 
chr(0xC5)=>chr(0x0699), 
chr(0xC6)=>chr(0x069A), 
chr(0xC7)=>chr(0x069B), 
chr(0xC8)=>chr(0x069C), 
chr(0xC9)=>chr(0x06FA), 
chr(0xCA)=>chr(0x069D), 
chr(0xCB)=>chr(0x069E), 
chr(0xCC)=>chr(0x06FB), 
chr(0xCD)=>chr(0x069F), 
chr(0xCE)=>chr(0x06A0), 
chr(0xCF)=>chr(0x06FC), 
chr(0xD0)=>chr(0x06A1), 
chr(0xD1)=>chr(0x06A2), 
chr(0xD2)=>chr(0x06A3), 
chr(0xD3)=>chr(0x06A4), 
chr(0xD4)=>chr(0x06A5), 
chr(0xD5)=>chr(0x06A6), 
chr(0xD6)=>chr(0x06A7), 
chr(0xD7)=>chr(0x06A8), 
chr(0xD8)=>chr(0x06A9), 
chr(0xD9)=>chr(0x06AA), 
chr(0xDA)=>chr(0x06AB), 
chr(0xDB)=>chr(0x06AC), 
chr(0xDC)=>chr(0x06AD), 
chr(0xDD)=>chr(0x06AE), 
chr(0xDE)=>chr(0x06AF), 
chr(0xDF)=>chr(0x06B0), 
chr(0xE0)=>chr(0x06B1), 
chr(0xE1)=>chr(0x06B2), 
chr(0xE2)=>chr(0x06B3), 
chr(0xE3)=>chr(0x06B4), 
chr(0xE4)=>chr(0x06B5), 
chr(0xE5)=>chr(0x06B6), 
chr(0xE6)=>chr(0x06B7), 
chr(0xE7)=>chr(0x06B8), 
chr(0xE8)=>chr(0x06BA), 
chr(0xE9)=>chr(0x06BB), 
chr(0xEA)=>chr(0x06BC), 
chr(0xEB)=>chr(0x06BD), 
chr(0xEC)=>chr(0x06B9), 
chr(0xED)=>chr(0x06BE), 
chr(0xEE)=>chr(0x06C0), 
chr(0xEF)=>chr(0x06C4), 
chr(0xF0)=>chr(0x06C5), 
chr(0xF1)=>chr(0x06C6), 
chr(0xF2)=>chr(0x06CA), 
chr(0xF3)=>chr(0x06CB), 
chr(0xF4)=>chr(0x06CD), 
chr(0xF5)=>chr(0x06CE), 
chr(0xF6)=>chr(0x06D0), 
chr(0xF7)=>chr(0x06D2), 
chr(0xF8)=>chr(0x06D3), 
chr(0xFD)=>chr(0x0306), 
chr(0xFE)=>chr(0x030C), 

);

my @combining = (
chr(0xFD), 
chr(0xFE),
);
	

while ( my($test,$expected) = each %valid ) {
    my $converted = $cs->to_utf8($test);
    is( $converted => $expected,
	'valid Arabic character chr(0x'.sprintf("%2x",ord($test)).')'
    ); 
}

## test each combining character, to make sure things get reordered with
## Note: 0x2C (ArabicBasic) is 0x060C (UTF8)
foreach my $test (@combining) {
    my $converted = $cs->to_utf8( $test.chr(0x2C) );
    is ( $converted => chr(0x060C).$valid{$test}, 
	'valid Arabic combining character chr(0x'.sprintf("%2x",ord($test)).')'
    );
}
 
## try one test with multiple combining characters

is ( 
    $cs->to_utf8(chr(0xFD).chr(0xFE).chr(0x2C)),
    chr(0x060C).chr(0x0306).chr(0x030C),
    'mulitple Arabic combining characters'
);

## and lets try one longish string
my $test = chr(0xEA).chr(0xF3).chr(0xF8).chr(0xF8).chr(0xED);
my $expected = chr(0x06BC).chr(0x06CB).chr(0x06D3).chr(0x06D3).chr(0x06BE);
is ($cs->to_utf8($test),$expected,'longish Arabic string');




