# Generated by default/object.tt
package Paws::CodeGuruProfiler::FrameMetricDatum;
  use Moose;
  has FrameMetric => (is => 'ro', isa => 'Paws::CodeGuruProfiler::FrameMetric', request_name => 'frameMetric', traits => ['NameInRequest'], required => 1);
  has Values => (is => 'ro', isa => 'ArrayRef[Num]', request_name => 'values', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruProfiler::FrameMetricDatum

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruProfiler::FrameMetricDatum object:

  $service_obj->Method(Att1 => { FrameMetric => $value, ..., Values => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruProfiler::FrameMetricDatum object:

  $result = $service_obj->Method(...);
  $result->Att1->FrameMetric

=head1 DESCRIPTION

Information about a frame metric and its values.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FrameMetric => L<Paws::CodeGuruProfiler::FrameMetric>




=head2 B<REQUIRED> Values => ArrayRef[Num]

A list of values that are associated with a frame metric.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruProfiler>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

