# Generated by default/object.tt
package Paws::GameLift::LaunchTemplateSpecification;
  use Moose;
  has LaunchTemplateId => (is => 'ro', isa => 'Str');
  has LaunchTemplateName => (is => 'ro', isa => 'Str');
  has Version => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::LaunchTemplateSpecification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::LaunchTemplateSpecification object:

  $service_obj->Method(Att1 => { LaunchTemplateId => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::LaunchTemplateSpecification object:

  $result = $service_obj->Method(...);
  $result->Att1->LaunchTemplateId

=head1 DESCRIPTION

B<This data type is used with the GameLift FleetIQ and game server
groups.>

An EC2 launch template that contains configuration settings and game
server code to be deployed to all instances in a game server group. The
launch template is specified when creating a new game server group with
CreateGameServerGroup.

=head1 ATTRIBUTES


=head2 LaunchTemplateId => Str

A unique identifier for an existing EC2 launch template.


=head2 LaunchTemplateName => Str

A readable identifier for an existing EC2 launch template.


=head2 Version => Str

The version of the EC2 launch template to use. If no version is
specified, the default version will be used. With Amazon EC2, you can
specify a default version for a launch template. If none is set, the
default is the first version created.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

