package Locale::CLDR::Transformations::Any::Latn::Arab;
# This file auto generated from Data\common\transforms\Arabic-Latin.xml
#	on Sat  4 Nov  5:50:45 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.3');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^um:\G.)/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFD),
				},
				{
					from => q(Any),
					to => q(lower),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(‎ⁿ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(x),
					result  => q(),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(o),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(e),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(c),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q([eiy]),
					replace => q(c),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(g),
					result  => q(گ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(v),
					result  => q(ڤ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(cẖ),
					result  => q(چ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(p),
					result  => q(پ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(̹),
					result  => q(ٕ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(̉),
					result  => q(ٔ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(̂),
					result  => q(ٓ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(̊),
					result  => q(ْ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(̃),
					result  => q(ّ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(i),
					result  => q(ِ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(u),
					result  => q(ُ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(a),
					result  => q(َ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(iⁿ),
					result  => q(ٍ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(uⁿ),
					result  => q(ٌ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(aⁿ),
					result  => q(ً),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(y),
					result  => q(ي),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(y̱),
					result  => q(ى),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(w),
					result  => q(و),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(h),
					result  => q(ه),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(n),
					result  => q(ن),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(m),
					result  => q(م),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(l),
					result  => q(ل),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(k),
					result  => q(ك),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ḵ),
					result  => q(ک),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(q),
					result  => q(ق),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(f),
					result  => q(ف),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʿ),
					result  => q(ع),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(s),
					result  => q(س),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(z),
					result  => q(ز),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(r),
					result  => q(ر),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(d),
					result  => q(د),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(kẖ),
					result  => q(خ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ḥ),
					result  => q(ح),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(j),
					result  => q(ج),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t),
					result  => q(ت),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(b),
					result  => q(ب),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ạ),
					result  => q(ا),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ʾ),
					result  => q(ء),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sˌ),
					result  => q(ښ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(y̰),
					result  => q(ی),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(v̱),
					result  => q(ۋ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ṉg),
					result  => q(ڭ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(zẖ),
					result  => q(ژ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(t((?:(?=[\p{^ccc = 230}])[\p{^ccc = 0}])+)̈),
					result  => q(ة),
					revisit => 2,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ẗ),
					result  => q(ة),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(gẖ),
					result  => q(غ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ẓ),
					result  => q(ظ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ṭ),
					result  => q(ط),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ḍ),
					result  => q(ض),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ṣ),
					result  => q(ص),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(sẖ),
					result  => q(ش),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(dẖ),
					result  => q(ذ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(tẖ),
					result  => q(ث),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ī),
					result  => q(ِي),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ū),
					result  => q(ُو),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ā),
					result  => q(َا),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(9),
					result  => q(٩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(8),
					result  => q(٨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(7),
					result  => q(٧),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(6),
					result  => q(٦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(5),
					result  => q(٥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(4),
					result  => q(٤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(3),
					result  => q(٣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(2),
					result  => q(٢),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(1),
					result  => q(١),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(),
					result  => q(٠),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(9̱),
					result  => q(۹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(8̱),
					result  => q(۸),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(7̱),
					result  => q(۷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(6̱),
					result  => q(۶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(5̱),
					result  => q(۵),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(4̱),
					result  => q(۴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(3̱),
					result  => q(۳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(2̱),
					result  => q(۲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(1̱),
					result  => q(۱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(̱),
					replace => q(),
					result  => q(۰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\'),
					result  => q(٪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\'),
					result  => q(؟),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\'),
					result  => q(؛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\'),
					result  => q(،),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\'̱),
					result  => q(٬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\'̱),
					result  => q(٫),
					revisit => 0,
				},
				{
					before  => q(\p{Nd}),
					after   => q(\p{Nd}),
					replace => q(\'),
					result  => q(٬),
					revisit => 0,
				},
				{
					before  => q(\p{Nd}),
					after   => q(\p{Nd}),
					replace => q(\'),
					result  => q(٫),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
