ACH::Builder
============

This module is tool to help construct ACH files, which are fixed-width
formatted files accpected by most banks. ACH (Automated Clearing House) is an
electronic banking network operating system in the United States.  ACH
processes large volumes of both credit and debit transactions which are
originated in batches. Rules and regulations governing the ACH network are
established by the National Automated Clearing House Association (NACHA) and
the Federal Reserve (Fed).

ACH credit transfers include direct deposit payroll payments and payments to
contractors and vendors. ACH debit transfers include consumer payments on
insurance premiums, mortgage loans, and other kinds of bills.


Installation
------------

To install this module, run the following commands:

    perl Makefile.PL
    make
    make test
    make install


Documentation
-------------------------

After installing, you can find documentation for this module with the
perldoc command:

    perldoc ACH::Builder

You can also look for information at:

- [AnnoCPAN, Annotated CPAN documentation] (http://annocpan.org/dist/ACH-Builder)
- [CPAN Ratings] (http://cpanratings.perl.org/d/ACH-Builder)
- [Search CPAN] (http://search.cpan.org/dist/ACH-Builder/)


Support and Development
-----------------------

The source repository for ACH::Builder is on [GitHub] (https://github.com/horsepunchkid/ACH-Builder).
Issues can be submitted there or at [CPAN's request tracker] (http://rt.cpan.org/NoAuth/Bugs.html?Dist=ACH-Builder).


License and Copyright
---------------------

Copyright (C) 2011 Cameron Baustian

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See [Perl Licensing] (http://dev.perl.org/licenses/) for more information.

