use strict;
use warnings;
use Test::More tests => 68;
use Digest::Hamsi qw(hamsi_256 hamsi_256_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Hamsi->new(256)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            hamsi_256_hex($data), $digest,
            "hamsi_256_hex: $len bits of $msg"
        );
        ok(
            hamsi_256($data) eq pack('H*', $digest),
            "hamsi_256: $len bits of $msg"
        );
    }

    my $md = Digest::Hamsi->new(256)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|750E9EC469F4DB626BEE7E0C10DDAA1BD01FE194B94EFBABEBD24764DC2B13E9
00|22238EE2E8A04DFE163EAD28C70C3E760B85B3814704A84FE0E54290ECAE6883
C0|4C0F20F6FB3A989F9DDDFB9564B9EBE7103287B2AEE214C50CE6B42CD9212E87
C0|5CD6962619640668A808A535078B2C19B5D01D6BBA67F9619BC2C85E5ACCE378
80|AB57B5347DC1AC098C985F0DA6C85B55F7FCA6E79933571D9A94E2C251DE854A
48|B146709BC8252F6EA5664C4AA0CE8E7528885A6CF0D81B295C2F28C2372F8569
50|1FAFF96AEE360DFF44106193E4494D630988D19B13D9FEC31A10F876B15FAD96
98|53E4A34D5DD4D6A825917DBA478AFD8F853692E81FB8B64BD9676959187BAA60
CC|AC2DAC2A6DDAF703B7A55745D61B1A16A3D1BF1F74CAAB265A2E5DBEBCF60832
9800|6162A40F7E88F958B9DBBB22343BD9374BB8ABBE0CE9D3AAA4AF99F3F7292E47
9D40|99296C41082086775EE6A8CC8148C0A06DDF884F154DDA5228DC92E7401F8696
AA80|E8F8DD59580E64D321FC9F7BC1339C24F9ED12F3FA6035FDE267714C676FF8F2
9830|C0064895B0139B9589D16D7E98FD6647CD1D976E55002847EF8A80A0D1158B76
5030|8B724DF24715A7B23CF4B21874AF50CC7659C3A41477FB12819BCB749B55D783
4D24|00BC10BD52CCDC3D21EC0BB5252E612524B00D919AF6E51EA03BF95AA5427E60
CBDE|ED977B57ADE1AA84430C529C5D5AF7507BB5CE921A57612C1F1D7CF6B5032C0C
41FB|2DB4F6B7A8E20B28D5D3D536EA23ADE6566D4E622E62A108CD52A7A809C469DD
4FF400|839B68DB19DFB0BCB48BCE25447C114EDBCE304BB06140246BFBA81FF32A998A
FD0440|58D3F698F238D6C5BAE8CAECB98DF46DF92E8A3229AE9BBAAC9C9C9F51DE4E9A
424D00|42B70C8C0134168D521A91744EC3F1E8CFD6BEA8AFFE40A052C0B8ED562DCF45
3FDEE0|AF77077E795BC91BBA61FA49E7CB1E12170399F505413F53ED212D69EFE66EF5
335768|A15CAE290DB699551996339B9A8FE99BE6FC4BFD5DCB58CA5DFDF516068A061E
051E7C|11B1C1744EDDC5F0BC664129431DF141392528F25726B92399BFEA7C8D4970C0
717F8C|96855F36A8F4E01F4744C40EA17D7414D28CF14702D603DF105D70A9474FCDEA
1F877C|CB596913E691F8654A613E24DEBF3262E6477FD737D5C422E670E0C75FAE7D17
EB35CF80|65B74F6DCDAE00193C556067BA46969D60B8E955FD9076453EF102DD1D1344B4
B406C480|1DDF197758F8F1E738684AC3E861D713F0A26A81693FAE0A329525BD5A04B453
CEE88040|B2FA17DB44CF6B5AA606DF6E6CFE2E92CF8183EFD5B05153EC57D1DDD7821EE9
C584DB70|5B7DE79F371B41EF3BEBA58A4170A594CC73B75F865B5B0F596914940816EBCD
53587BC8|8242FE17397AD8F9DBA45237B64541440730A1BEB78B678101C664D1C7AB05D0
69A305B0|15423A5E7A33DF8524EC96FF6311EC75D1F3484326CE331E864B329C49A70087
C9375ECE|A4761F41D86521000F6255E5537D387D207A5B70D6CAC50B1BFE5EBE806025D5
C1ECFDFC|AEAEF9B3B7F8F947FBA5FE9BD9886A203110621BC2BCA6AC890997AEEC69AE0E
8D73E8A280|5988E3A755EA2C18213C9824E167F2888265CA25CE5C63A6D0730DF47F33E030
06F2522080|3E1F8568F548897A439BE11CE9CF0D550631C090804733318031CCC70518DF0E
3EF6C36F20|EDAB62072E9ADEBF6CF0255C4C1E0E91D78952BF4C50060DC1942019AC440A25
0127A1D340|0E7753962E81D5350B0372AFCF5C03CE03499E0EB84A6924856C5E87D95C8493
6A6AB6C210|2882CC75389610FCE9173F5B291E657283EACC8A4BDFD3B9019E3E242C42BA6B
AF3175E160|06A3A8E7F76BC9A3E50B880FE048060F893289177CF9938D6E093E7D52DDC213
B66609ED86|30C559F5D88B811D15B6A6E15BA3E696C59C1EAB05B70B9B9AAB6CA137416E5C
21F134AC57|B302060A7649A5872109E845FE20C3C427021E45E91D680445980529374A598D
3DC2AADFFC80|0D2ED3332EDCBE1C4E805731E8701ED3BF7B32C8A2E653AD39DBD4549F6D782C
9202736D2240|BC7DC3D4CCB26FD74E46E6E031E6E0671F8D68B7D664D6C681320FC452881B27
F219BD629820|B9E9C7202C90A703797DD3FC4A28A33A8C7F5C4C03870DCBAA24D46566943385
F3511EE2C4B0|5DBEFD44A806BE8310C7A3312961FA934475111188794F97B6802DAAEEC3DCCC
3ECAB6BF7720|8AAB82FB6050A3C95604F5CBCCCCFBA6611DD64A6F1447B8DD78B1FC16C21432
CD62F688F498|0BA27ADB9555E4B828B4F6F2244DC4F428B3EFC4F14D03379A33170B15553E3D
C2CBAA33A9F8|5BF8F3D6E39CB77B9EF16554F4C189133BE2877DBFCBB8296ADC831A4715AE7F
C6F50BB74E29|15AA66C5E6A2F5274739BB0D47F7F2BA9A0EFA76356D3CBDC0B00EFC92A3848D
79F1B4CCC62A00|9A1E9B2569B6ACDC3D4BDDD4B9B6D4589C7A26A4ED45A61B7B2BDDC1BB31B761
