/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Throwables;
import com.google.common.primitives.Ints;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ScreenshotException;

public class ErrorHandler {
    private static final String MESSAGE = "message";
    private static final String SCREEN_SHOT = "screen";
    private static final String CLASS = "class";
    private static final String STACK_TRACE = "stackTrace";
    private static final String LINE_NUMBER = "lineNumber";
    private static final String METHOD_NAME = "methodName";
    private static final String CLASS_NAME = "className";
    private static final String FILE_NAME = "fileName";
    private static final String UNKNOWN_CLASS = "<anonymous class>";
    private static final String UNKNOWN_METHOD = "<anonymous method>";
    private static final String UNKNOWN_FILE = null;
    private ErrorCodes errorCodes;
    private boolean includeServerErrors;

    public ErrorHandler() {
        this(true);
    }

    public ErrorHandler(boolean includeServerErrors) {
        this.includeServerErrors = includeServerErrors;
        this.errorCodes = new ErrorCodes();
    }

    public ErrorHandler(ErrorCodes codes, boolean includeServerErrors) {
        this.includeServerErrors = includeServerErrors;
        this.errorCodes = codes;
    }

    public boolean isIncludeServerErrors() {
        return this.includeServerErrors;
    }

    public void setIncludeServerErrors(boolean includeServerErrors) {
        this.includeServerErrors = includeServerErrors;
    }

    public Response throwIfResponseFailed(Response response, long duration) throws RuntimeException {
        if (response.getStatus() == null || response.getStatus() == 0) {
            return response;
        }
        if (response.getValue() instanceof Throwable) {
            Throwable throwable = (Throwable)response.getValue();
            Throwables.throwIfUnchecked(throwable);
            throw new RuntimeException(throwable);
        }
        Class<? extends WebDriverException> outerErrorType = this.errorCodes.getExceptionType(response.getStatus());
        Object value = response.getValue();
        String message = null;
        Throwable cause = null;
        if (value instanceof Map) {
            Map rawErrorData = (Map)value;
            if (!rawErrorData.containsKey(MESSAGE) && rawErrorData.containsKey("value")) {
                try {
                    rawErrorData = (Map)rawErrorData.get("value");
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            try {
                message = (String)rawErrorData.get(MESSAGE);
            }
            catch (ClassCastException e) {
                message = String.valueOf(e);
            }
            Throwable serverError = this.rebuildServerError(rawErrorData, response.getStatus());
            if (serverError == null) {
                if (this.includeServerErrors) {
                    message = message + " (WARNING: The server did not provide any stacktrace information)";
                }
            } else if (!this.includeServerErrors) {
                message = message + " (WARNING: The client has suppressed server-side stacktraces)";
            } else {
                cause = serverError;
            }
            if (rawErrorData.get(SCREEN_SHOT) != null) {
                cause = new ScreenshotException(String.valueOf(rawErrorData.get(SCREEN_SHOT)), cause);
            }
        } else if (value != null) {
            message = String.valueOf(value);
        }
        String duration1 = this.duration(duration);
        if (message != null && !message.contains(duration1)) {
            message = message + duration1;
        }
        WebDriverException toThrow = null;
        if (outerErrorType.equals(UnhandledAlertException.class) && value instanceof Map) {
            toThrow = this.createUnhandledAlertException(value);
        }
        if (toThrow == null) {
            toThrow = this.createThrowable(outerErrorType, new Class[]{String.class, Throwable.class, Integer.class}, new Object[]{message, cause, response.getStatus()});
        }
        if (toThrow == null) {
            toThrow = this.createThrowable(outerErrorType, new Class[]{String.class, Throwable.class}, new Object[]{message, cause});
        }
        if (toThrow == null) {
            toThrow = this.createThrowable(outerErrorType, new Class[]{String.class}, new Object[]{message});
        }
        if (toThrow == null) {
            toThrow = new WebDriverException(message, cause);
        }
        throw toThrow;
    }

    private UnhandledAlertException createUnhandledAlertException(Object value) {
        Map rawErrorData = (Map)value;
        if (rawErrorData.containsKey("alert") || rawErrorData.containsKey("alertText")) {
            Map alert;
            Object alertText = rawErrorData.get("alertText");
            if (alertText == null && (alert = (Map)rawErrorData.get("alert")) != null) {
                alertText = alert.get("text");
            }
            return this.createThrowable(UnhandledAlertException.class, new Class[]{String.class, String.class}, new Object[]{rawErrorData.get(MESSAGE), alertText});
        }
        return null;
    }

    private String duration(long duration) {
        String prefix = "\nCommand duration or timeout: ";
        if (duration < 1000L) {
            return prefix + duration + " milliseconds";
        }
        return prefix + new BigDecimal(duration).divide(new BigDecimal(1000)).setScale(2, RoundingMode.HALF_UP) + " seconds";
    }

    private <T extends Throwable> T createThrowable(Class<T> clazz, Class<?>[] parameterTypes, Object[] parameters) {
        try {
            Constructor<T> constructor = clazz.getConstructor(parameterTypes);
            return (T)((Throwable)constructor.newInstance(parameters));
        }
        catch (OutOfMemoryError | ReflectiveOperationException throwable) {
            return null;
        }
    }

    private Throwable rebuildServerError(Map<String, Object> rawErrorData, int responseStatus) {
        if (!rawErrorData.containsKey(CLASS) && !rawErrorData.containsKey(STACK_TRACE)) {
            return null;
        }
        WebDriverException toReturn = null;
        String message = (String)rawErrorData.get(MESSAGE);
        Class<WebDriverException> clazz = null;
        if (rawErrorData.containsKey(CLASS)) {
            String className = (String)rawErrorData.get(CLASS);
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (null == clazz) {
            clazz = this.errorCodes.getExceptionType(responseStatus);
        }
        if (clazz.equals(UnhandledAlertException.class)) {
            toReturn = this.createUnhandledAlertException(rawErrorData);
        } else if (Throwable.class.isAssignableFrom(clazz)) {
            Class<WebDriverException> throwableType = clazz;
            toReturn = this.createThrowable(throwableType, new Class[]{String.class}, new Object[]{message});
        }
        if (toReturn == null) {
            toReturn = new UnknownServerException(message);
        }
        StackTraceElement[] stackTrace = new StackTraceElement[]{};
        if (rawErrorData.containsKey(STACK_TRACE)) {
            List stackTraceInfo = (List)rawErrorData.get(STACK_TRACE);
            stackTrace = (StackTraceElement[])stackTraceInfo.stream().map(entry -> new FrameInfoToStackFrame().apply((Map<String, Object>)entry)).filter(Objects::nonNull).toArray(StackTraceElement[]::new);
        }
        toReturn.setStackTrace(stackTrace);
        return toReturn;
    }

    private static class FrameInfoToStackFrame
    implements Function<Map<String, Object>, StackTraceElement> {
        private FrameInfoToStackFrame() {
        }

        @Override
        public StackTraceElement apply(Map<String, Object> frameInfo) {
            if (frameInfo == null) {
                return null;
            }
            Optional<Number> maybeLineNumberInteger = Optional.empty();
            Object lineNumberObject = frameInfo.get(ErrorHandler.LINE_NUMBER);
            if (lineNumberObject instanceof Number) {
                maybeLineNumberInteger = Optional.of((Number)lineNumberObject);
            } else if (lineNumberObject != null) {
                maybeLineNumberInteger = Optional.ofNullable(Ints.tryParse(lineNumberObject.toString()));
            }
            int lineNumber = ((Number)maybeLineNumberInteger.orElse(-1)).intValue();
            String className = frameInfo.containsKey(ErrorHandler.CLASS_NAME) ? FrameInfoToStackFrame.toStringOrNull(frameInfo.get(ErrorHandler.CLASS_NAME)) : ErrorHandler.UNKNOWN_CLASS;
            String methodName = frameInfo.containsKey(ErrorHandler.METHOD_NAME) ? FrameInfoToStackFrame.toStringOrNull(frameInfo.get(ErrorHandler.METHOD_NAME)) : ErrorHandler.UNKNOWN_METHOD;
            String fileName = frameInfo.containsKey(ErrorHandler.FILE_NAME) ? FrameInfoToStackFrame.toStringOrNull(frameInfo.get(ErrorHandler.FILE_NAME)) : UNKNOWN_FILE;
            return new StackTraceElement(className, methodName, fileName, lineNumber);
        }

        private static String toStringOrNull(Object o) {
            return o == null ? null : o.toString();
        }
    }

    public static class UnknownServerException
    extends WebDriverException {
        private UnknownServerException(String s) {
            super(s);
        }
    }
}

