# This Makefile.PL for UV was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.47.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

use Config;
use Alien::libuv ();

# make sure we actually get stuff back from Alien::libuv
sub TRIM {
    my $s = shift;
    return '' unless $s;
    $s =~ s/\A\s*//;
    $s =~ s/\s*\z//;
    return $s;
}

my @flags = ('-I.', $Config{ccflags});
push @flags, '-DDEBUG -g' if $ENV{PERL_UV_DEBUG};
my $libs = Alien::libuv->libs();
{
    my $cflags = TRIM(Alien::libuv->cflags);
    my $cflags_s = TRIM(Alien::libuv->cflags_static);
    if ($cflags eq $cflags_s) {
        unshift @flags, $cflags if $cflags;
    }
    else {
        unshift @flags, $cflags if $cflags;
        unshift @flags, $cflags_s if $cflags_s;
    }
}
my %xsbuild = (
    XSMULTI => 1,
    XSBUILD => {
        xs => {
            'lib/UV' => {
              OBJECT => 'lib/UV$(OBJ_EXT) lib/perl_math_int64$(OBJ_EXT)',
            },
        },
    },
    OBJECT  => '$(O_FILES)',
    LIBS => [$libs],
    CCFLAGS => join(' ', @flags),
);

my %WriteMakefileArgs = (
  "ABSTRACT" => "Perl interface to libuv",
  "AUTHOR" => "Chase Whitener <capoeirab\@cpan.org>, Daisuke Murase <typester\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Alien::libuv" => "1.000",
    "Config" => 0,
    "ExtUtils::MakeMaker" => "7.12",
    "Math::Int64" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "Alien::libuv" => "1.000",
    "ExtUtils::MakeMaker" => "7.12"
  },
  "DISTNAME" => "UV",
  "LICENSE" => "perl",
  "NAME" => "UV",
  "PREREQ_PM" => {
    "Alien::libuv" => "1.000",
    "Carp" => 0,
    "Exporter" => "5.57",
    "Math::Int64" => 0,
    "Scalar::Util" => 0,
    "XS::Object::Magic" => 0,
    "XSLoader" => "0.14",
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Alien::libuv" => "1.000",
    "Errno" => 0,
    "ExtUtils::MakeMaker" => "7.12",
    "File::Spec" => 0,
    "FindBin" => 0,
    "IO::Handle" => 0,
    "IO::Socket::INET" => 0,
    "POSIX" => 0,
    "Socket" => 0,
    "Test::More" => "0.88",
    "Try::Tiny" => 0
  },
  "VERSION" => "1.000009",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    %xsbuild,
);

my %FallbackPrereqs = (
  "Alien::libuv" => "1.000",
  "Carp" => 0,
  "Config" => 0,
  "Errno" => 0,
  "Exporter" => "5.57",
  "ExtUtils::MakeMaker" => "7.12",
  "File::Spec" => 0,
  "FindBin" => 0,
  "IO::Handle" => 0,
  "IO::Socket::INET" => 0,
  "Math::Int64" => 0,
  "POSIX" => 0,
  "Scalar::Util" => 0,
  "Socket" => 0,
  "Test::More" => "0.88",
  "Try::Tiny" => 0,
  "XS::Object::Magic" => 0,
  "XSLoader" => "0.14",
  "parent" => 0,
  "strict" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
