/* ServiceTimer.c
 * This file is part of the LaBrea package
 *
 * Copyright (C) 2001, 2002 Tom Liston <tliston@premmag.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "labrea.h"

#ifdef WIN32
DWORD WINAPI ServiceTimer(LPVOID lpAintGonnaUseThis) {
#else
void ServiceTimer(int sig) {
#endif
  extern int rflag, totalbw;
  extern int currentbandwidth, past[], maxbw, bflag, oflag, newthisminute;
  extern char mybuffer[], bwstr[], format5[];
  int avgbw, i;
#ifdef WIN32
  extern boolThread;
  int j = 0;

  boolThread = 1;
  for(;;) {
    j++;
    if(!boolThread) {
      boolThread = 1;
      ExitThread(0);
    }
    if(j == 6) {
      j = 0;
#endif
      totalbw -= past[4];
      for(i = 4; i; i--)
        past[i] = past[i - 1];
      past[0] = currentbandwidth;
      totalbw += past[0];
      currentbandwidth = 0;
      avgbw = totalbw / 300;
      if(bflag) {
        sprintf(mybuffer, bwstr, avgbw);
        if(oflag)
          printf(format5, mybuffer);
        else
          syslog(LOGTYPE, mybuffer);
      }
      /* this allows for a "soft" restart by       */
      /* letting 5 minutes go by before allowing   */
      /* any new connections are captured.         */
      /* if you restart with this enabled, then    */
      /* it should "recapture" the old stuff, and  */
      /* base the bw calc on that before grabbing  */
      /* anything new...                           */
      /* I got bit by this... that's why I thought */
      /* to do it...                               */
      if(rflag)
        rflag--;
      else
        /* an attempt to keep bw in line when you're  */
        /* getting hammered.  limit new connections   */
        /* that we'll allow to be captured per minute */
        newthisminute = maxbw - avgbw;
      if(newthisminute < 0)
        newthisminute = 0;
#ifdef WIN32
    }
    sleep(10000);
  }
  return(0);
#else
    alarm(60);
#endif
}

