package TableData::Test::Spec::Basic;

use strict;
use warnings;

use Role::Tiny::With;

with 'TableDataRole::Spec::Basic';

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-08-27'; # DATE
our $DIST = 'TableData'; # DIST
our $VERSION = '0.2.4'; # VERSION

my $rows = [
    {a=>1, b=>2},
    {a=>3, b=>4},
    {a=>"5 2", b=>"6,2"},
];
my $columns = [qw/a b/];

sub new {
    my $class = shift;
    bless {pos=>0}, $class;
}

sub _rows {
    $rows;
}

sub reset_iterator {
    my $self = shift;
    $self->{pos} = 0;
}

sub get_iterator_pos {
    my $self = shift;
    $self->{pos};
}

sub has_next_item {
    my $self = shift;
    $self->{pos} < @$rows;
}

sub get_next_item {
    my $self = shift;
    die "StopIteration" if $self->{pos} >= @$rows;
    my $row_hashref = $rows->[ $self->{pos}++ ];
    [map {$row_hashref->{$_}} @$columns];
}

sub get_next_row_hashref {
    my $self = shift;
    die "StopIteration" if $self->{pos} >= @$rows;
    $rows->[ $self->{pos}++ ];
}

sub get_row_hashref {
    my $self = shift;
    return unless $rows->[ $self->{index} ];
    $rows->[ $self->{index}++ ];
}

sub get_column_count {
    my $self = shift;
    scalar(keys %{$rows->[0]});
}

sub get_column_names {
    my $self = shift;
    my @names = sort keys %{$rows->[0]};
    wantarray ? @names : \@names;
}

1;

# ABSTRACT: A test table data

__END__

=pod

=encoding UTF-8

=head1 NAME

TableData::Test::Spec::Basic - A test table data

=head1 VERSION

This document describes version 0.2.4 of TableData::Test::Spec::Basic (from Perl distribution TableData), released on 2023-08-27.

=for Pod::Coverage ^(.+)$

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/TableData>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-TableData>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2022, 2021, 2020 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=TableData>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
