.TH UNSHAR 1L
''' $Id: unshar.man,v 3.0.3.2 1993/08/25 17:05:02 ram Exp $
'''
''' $Log: unshar.man,v $
''' Revision 3.0.3.2  1993/08/25  17:05:02  ram
''' patch12: cleanup checkin for RCS 5.6
'''
''' Revision 3.0.3.1  91/01/21  11:38:52  ram
''' 3.0 baseline (ram).
''' 
'''
.SH NAME
unshar \- unpack shell archives from news, mail, notes, etc.
.SH SYNOPSIS
.RS
.na
.ti -.5i
.B unshar
[
.BI \-c\| path
] [
.BI \-d\| path
] [
.BI \-h\| file
] [
.B \-f
] [
.B \-n
] [
.B \-s
] [
.B \-v
] [ file... ]
.ad
.RE
.SH DESCRIPTION
.I Unshar
removes mail and news header lines from its input, and feeds the remainder
to
.IR /bin/sh (1)
so that a shell archive can be properly unpacked.
If no files are specified,
.I unshar
reads from standard input.
The program is designed to be useful when unpacking archives directly
from the news or mail systems (e.g., s | unshar).
.PP
.I Unshar
normally unpacks its files in the current directory.
Use the ``\-c'' option to have the program change to a new directory
before invoking the shell.
If the directory does not exist,
.I unshar
will try to create it.
If the directory name starts with a question mark, then
.I unshar
will ask for the directory name before doing anything; this is most useful
with the environment variable UNSHAREDIR.
If the directory name starts with a tilde, then the value of the HOME
environment variable is inserted in place of that character.
For convenience, the ``\-d'' option is a synonym for the ``\-c'' option.
.PP
.I Unshar
normally complains if the input looks like something other than a shar file.
(Among other things, it checks for files that resemble C, and Pascal code).
It can be fooled, however, by nonstandard versions of news, notes, etc.
The ``\-f'' option forces
.I unshar
to try unpacking files, even if they look like something else.
.PP
Depending on how the program is installed,
.I unshar
may or may not try to preserve the header part of file ``foo''
into the name ``foo.hdr'' (if the file is standard input, the name
will be ``UNSHAR.HDR'').
Using the ``\-s'' option forces the program to save the headers, while
using the ``\-n'' option forces it to discard the headers.
The file is appended to, if it already exists, so all headers can be easily
saved in one file.
The name of the file may be given by using the ``\-h'' option; this is
particularly useful when processing more than one file at a time.
.PP
The ``\-v'' option prints out the current version and exits.
.SH ENVIRONMENT
.ta \w'UNSHAREDIR  'u
HOME	Used if directory name starts with a tilde.
.br
UNSHAREDIR	Default value for ``\-c'' option.
.SH "SEE ALSO"
shar(1L).
