# Generated by default/object.tt
package Paws::SageMaker::DeviceFleetSummary;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str');
  has DeviceFleetArn => (is => 'ro', isa => 'Str', required => 1);
  has DeviceFleetName => (is => 'ro', isa => 'Str', required => 1);
  has LastModifiedTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::DeviceFleetSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::DeviceFleetSummary object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., LastModifiedTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::DeviceFleetSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

Summary of the device fleet.

=head1 ATTRIBUTES


=head2 CreationTime => Str

Timestamp of when the device fleet was created.


=head2 B<REQUIRED> DeviceFleetArn => Str

Amazon Resource Name (ARN) of the device fleet.


=head2 B<REQUIRED> DeviceFleetName => Str

Name of the device fleet.


=head2 LastModifiedTime => Str

Timestamp of when the device fleet was last updated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

