#!/usr/bin/env perl
use Config;
use inc::Module::Package 'Au:dry';

perl_version '5.005';
license 'apache2';

my $osname = $Config{osname};
if ( $osname eq 'linux' ) {
    requires 'Linux::Pid';
    if ( -e '/proc/self/smaps' ) {
        requires 'Linux::Smaps';
    }
}
elsif ( $osname =~ /(bsd|aix)/i ) {
    requires 'BSD::Resource';
}
elsif ( $osname eq 'MSWin32' ) {
    requires 'Win32::API';
}
else {
    warn "Process::SizeLimit::Core is probably not going to work in your platform ($osname); proceeding anyway...\n";
}
__END__

# Deps list generated by:
author_requires 'Module::Package' => '0.24';

author_requires 'Module::Package::Au' => '0.01';
