# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::RU;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240308154353;

my $formatters = [
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '[0-79]',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                [0-356]2|
                4[29]|
                7|
                8[27]
              )|
              2(?:
                13[03-69]|
                62[013-9]
              )
            )|
            72[1-57-9]2
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '
            7(?:
              1(?:
                0(?:
                  [356]|
                  4[023]
                )|
                [18]|
                2(?:
                  3[013-9]|
                  5
                )|
                3[45]|
                43[013-79]|
                5(?:
                  3[1-8]|
                  4[1-7]|
                  5
                )|
                6(?:
                  3[0-35-9]|
                  [4-6]
                )
              )|
              2(?:
                1(?:
                  3[178]|
                  [45]
                )|
                [24-689]|
                3[35]|
                7[457]
              )
            )|
            7(?:
              14|
              23
            )4[0-8]|
            71(?:
              33|
              45
            )[1-79]
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{5})(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3-$4',
                  'leading_digits' => '
            [349]|
            8(?:
              [02-7]|
              1[1-8]
            )
          ',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '8',
                  'national_rule' => '8 ($1)',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'geographic' => '
          (?:
            3(?:
              0[12]|
              4[1-35-79]|
              5[1-3]|
              65|
              8[1-58]|
              9[0145]
            )|
            4(?:
              01|
              1[1356]|
              2[13467]|
              7[1-5]|
              8[1-7]|
              9[1-689]
            )|
            8(?:
              1[1-8]|
              2[01]|
              3[13-6]|
              4[0-8]|
              5[15]|
              6[1-35-79]|
              7[1-37-9]
            )
          )\\d{7}
        ',
                'mobile' => '9\\d{9}',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(80[39]\\d{7})',
                'toll_free' => '
          8(?:
            0[04]|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{ru} = {"736", "Республика\ Крым",
"771445", "Алтынсаринский\ р\-н",
"771139", "Таскалинский\ р\-н",
"771632", "Зерендинский\ р\-н",
"772633", "Жамбылский\ р\-н",
"771448", "Карасуский\ р\-н",
"771037", "Актогайский\ р\-н",
"771033", "Шетский\ р\-н",
"772637", "Байзакский\ р\-н",
"772256", "Алгабас",
"772773", "Балхашский\ р\-н",
"7473", "Воронежская\ обл\.",
"772154", "Бухар\-Жырауский\ р\-н",
"772777", "Райымбекский\ р\-н",
"771335", "Шалкарский\ р\-н",
"7301", "Республика\ Бурятия",
"772236", "Бескарагайский\ р\-н",
"7712302", "Тенгизшевройл",
"771041", "Актау\,\ Жезказган",
"772641", "Таласский\ р\-н",
"772535", "Шардара",
"7385", "Алтайский\ край",
"772538", "имени\ Турара\ Рыскулова",
"772137", "Сарань",
"771340", "Хобдинский\ р\-н",
"771132", "Теректинский\ р\-н",
"771639", "Енбекшилдерский\ р\-н",
"7472", "Белгородская\ обл\.",
"771845", "Павлодар",
"772540", "Арыс",
"77106", "Сатпаев",
"772725", "Отеген\-Батыр",
"772774", "Талгарский\ р\-н",
"7347", "Республика\ Башкортостан",
"772153", "Абайский\ р\-н",
"771536", "Тайыншинский\ р\-н",
"771430", "Аркалык",
"772634", "Жанатас",
"772336", "Риддер",
"771034", "Улытауский\ р\-н",
"771235", "Макатский\ р\-н",
"771238", "Кзылкогинский\ р\-н",
"772831", "Панфиловский\ р\-н",
"771339", "Айтекебийский\ р\-н",
"771640", "Сандыктауский\ р\-н",
"772931", "Мангистауский\ р\-н",
"771232", "Атырауская\ область",
"7471", "Курская\ обл\.",
"77142", "Костанай",
"733", "Байконыр",
"772237", "Аязог",
"772539", "Казыгурт",
"771138", "Казталовский\ р\-н",
"7845", "Саратовская\ обл\.",
"771534", "Шал\ Акына\ р\-н",
"771135", "Жанибекский\ р\-н",
"771449", "Тарановский\ р\-н",
"772776", "Енбекшиказахский\ р\-н",
"7494", "Костромская\ обл\.",
"771036", "Балхаш",
"771842", "Майский\ р\-он",
"7712303", "Тензиз",
"772334", "Уланский\ р\-н",
"772636", "Кордай",
"772257", "Шульбинск",
"772843", "Лепсы",
"7349", "Ямало\-Ненецкий\ АО",
"77182", "Павлодар",
"772337", "Серебрянск",
"771140", "Бокейординский\ р\-н",
"772333", "Кокпектинский\ р\-н",
"7391", "Красноярский\ край",
"771332", "Уилский\ р\-н",
"772532", "Абая",
"772431", "Жалагашский\ р\-н",
"77213", "Темиртау",
"771533", "Айыртауский\ р\-н",
"772156", "Шахтинск",
"771537", "Тимирязевский\ р\-н",
"771239", "Макатский\ р\-н",
"771635", "Жаксынский\ р\-н",
"771442", "Федоровский\ р\-н",
"771541", "Мамлютский\ р\-н",
"772353", "Бородулихинский\ р\-н",
"771638", "Аккольский\ р\-н",
"7302", "Забайкальский\ край",
"7851", "Астраханская\ обл\.",
"772341", "Катон\-Карагайский\ р\-н",
"7499", "г\.\ Москва",
"77274", "Карасайский\ р\-н",
"7498", "Московская\ обл\.",
"7873", "Республика\ Ингушетия",
"7869", "г\.\ Севастополь",
"7381", "Омская\ обл\.",
"772138", "Бухар\-Жырауский\ р\-н",
"772534", "Жетысай",
"771636", "Щучинский\ р\-н",
"771334", "Мугалжарский\ р\-н",
"772842", "Кербулакский\ р\-н",
"7843", "Республика\ Татарстан",
"771843", "Майский\ р\-н",
"772252", "Абайский\ р\-н",
"771040", "Жайрем\ \(ГОК\)",
"7390", "Республика\ Хакасия",
"772339", "Курчумский\ р\-н",
"771831", "Железинский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"771237", "Жылыойский\ р\-н",
"771444", "Узункольский\ р\-н",
"771539", "Кызылжарский\ р\-н",
"77242", "Кызылорда",
"771233", "Курмангазинский\ р\-н",
"772541", "Мырзакент",
"772635", "Жуалынский\ р\-н",
"771443", "Мендыкаринский\ р\-н",
"772638", "Шуский\ р\-н",
"7842", "Ульяновская\ обл\.",
"771038", "Сыры\-Шаган",
"771447", "Карабалыкский\ р\-н",
"7817", "Вологодская\ обл\.",
"771035", "Улытауский\ р\-н",
"771234", "Индерский\ р\-н",
"772778", "Уйгурский\ р\-н",
"772775", "Енбекшиказахский\ р\-н",
"7717", "Астана",
"771451", "Сарыкольский\ р\-н",
"771136", "Акжаикский\ р\-н",
"7872", "Республика\ Дагестан",
"771341", "Хобдинский\ р\-н",
"771333", "Мугалжарский\ р\-н",
"772332", "Шемонаихинский\ р\-н",
"77292", "Актау",
"771844", "Иртышский\ р\-н",
"7484", "Калужская\ обл\.",
"771337", "Алгинский\ р\-н",
"77282", "Талдыкорган",
"772537", "Сарыагаш",
"7424", "Сахалинская\ обл\.",
"772239", "Урджарский\ р\-н",
"771431", "Рудный",
"771532", "Аккайынский\ р\-н",
"772533", "Туркестан",
"7871", "Республика\ Чеченская",
"771236", "Махамбетский\ р\-н",
"77125", "Атырауская\ область",
"7383", "Новосибирская\ обл\.",
"772338", "Уланский\ р\-н",
"772159", "Карагандинская\ область",
"772335", "Зыряновск",
"771535", "Габита\ Мусрепова\ р\-н",
"771641", "Астраханский\ р\-н",
"771134", "Сырымский\ р\-н",
"771538", "Кызылжарский\ р\-н",
"7841", "Пензенская\ обл\.",
"772830", "Алакольский\ р\-н",
"7818", "Архангельская\ обл\.",
"771637", "Коргалжынский\ р\-н",
"7475", "Тамбовская\ обл\.",
"771032", "Каражал",
"772632", "Меркенский\ р\-н",
"771633", "Ерейментауский\ р\-н",
"77272", "Алма\-Ата",
"772772", "Капчагай",
"772536", "Кентау",
"7855", "Республика\ Татарстан",
"7834", "Республика\ Мордовия",
"7814", "Республика\ Карелия",
"7382", "Томская\ обл\.",
"77135", "Актюбинская\ область",
"7846", "Самарская\ обл\.",
"771141", "Жангалинский\ р\-н",
"771336", "Хромтауский\ р\-н",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"772340", "Зайсанский\ р\-н",
"771133", "Бурлинский\ р\-н",
"772639", "Сарысуский\ р\-н",
"772132", "Нуринский\ р\-н",
"7487", "Тульская\ обл\.",
"771039", "Приозерск",
"771137", "Чингирлауский\ р\-н",
"77187", "Экибастуз",
"772779", "Райымбекский\ р\-н",
"7427", "Чукотский\ АО",
"7395", "Иркутская\ обл\.",
"771446", "Узункольский\ р\-н",
"771540", "Уалихановский\ р\-н",
"772932", "Бейнеуский\ р\-н",
"771837", "Аксуский\ р\-н",
"77232", "Усть\-Каменогорск",
"77149", "Костанай",
"771646", "Буландинский\ р\-н",
"772832", "Аксуский\ р\-н",
"7482", "Тверская\ обл\.",
"771454", "Наурзумский\ р\-н",
"771833", "Качирский\ р\-н",
"772148", "Осакаровский\ р\-н",
"772439", "Аральский\ р\-н",
"772544", "Шаульдер",
"771231", "Исатайский\ р\-н",
"77152", "Петропавловск",
"772770", "Жамбылский\ р\-н",
"77145834", "Красногорск",
"7495", "Московская\ обл\.",
"7844", "Волгоградская\ обл\.",
"771434", "Денисовский\ р\-н",
"771841", "Актогайский\ р\-н",
"7820", "Вологодская\ обл\.",
"7836", "Республика\ Марий\ Эл",
"7351", "Челябинская\ обл\.",
"771030", "Жана\-Аркинский\ р\-н",
"7862", "Краснодарский\ край",
"7816", "Новгородская\ обл\.",
"771146", "Акжаикский\ р\-н",
"772839", "Саркандский\ р\-н",
"771331", "Мартукский\ р\-н",
"7423", "Приморский\ край",
"771437", "Камыстинский\ р\-н",
"7483", "Брянская\ обл\.",
"7415", "Камчатский\ край",
"772531", "Аксукент",
"772432", "Шиелийский\ р\-н",
"771433", "Лисаковск",
"77222", "Семипалатинск",
"7863", "Ростовская\ обл\.",
"771542", "Уалихановский\ р\-н",
"771441", "Карабалыкский\ р\-н",
"772543", "Аксумбе",
"7879", "Ставропольский\ край",
"772547", "Ленгер",
"7878", "Республика\ Карачаево\-Черкесская",
"7345", "Тюменская\ обл\.",
"7811", "Псковская\ обл\.",
"771457", "Джангильдинский\ р\-н",
"771347", "Айтекебийский\ р\-н",
"771343", "Иргизский\ р\-н",
"7831", "Нижегородская\ обл\.",
"7848", "Самарская\ обл\.",
"772342", "Катон\-Карагайский\ р\-н",
"771453", "Аулиекольский\ р\-н",
"771834", "Успенский\ р\-н",
"77212", "Караганда",
"7426", "Еврейская\ автономная\ обл\.",
"771631", "Шортандинский\ р\-н",
"771545", "Жамбылский\ р\-н",
"771144", "Казталовский\ р\-н",
"772840", "Кербулакский\ р\-н",
"772348", "Кокпектинский\ р\-н",
"772345", "Жарминский\ р\-н",
"7486", "Орловская\ обл\.",
"772230", "Урджарский\ р\-н",
"771651", "Целиноградский\ р\-н",
"7847", "Республика\ Калмыкия",
"7866", "Республика\ Кабардино\-Балкарская",
"7812", "г\.\ Санкт\-Петербург",
"771836", "Щербактинский\ р\-н",
"772435", "Жанакорганский\ р\-н",
"772149", "Осакаровский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"772438", "Казалинский\ р\-н",
"772759", "Алматинская\ область",
"7384", "Кемеровская\ обл\.",
"77185", "Шалдай",
"771643", "Атбасарский\ р\-н",
"771647", "Есильский\ р\-н",
"7353", "Оренбургская\ обл\.",
"7877", "Республика\ Адыгея",
"771042", "Акой",
"771456", "Качар",
"77102", "Жезказган",
"771131", "Зеленовский\ р\-н",
"771644", "Аршалынский\ р\-н",
"771346", "Темирский\ р\-н",
"7421", "Хабаровский\ край",
"77262", "Тараз",
"7481", "Смоленская\ обл\.",
"772546", "Шолаккорган",
"77272983", "Каскелен",
"7861", "Краснодарский\ край",
"772835", "Текели",
"771436", "Тарановский\ р\-н",
"7388", "Республика\ Алтай",
"7352", "Курганская\ обл\.",
"772838", "Коксуский\ р\-н",
"772935", "Каракиянский\ р\-н",
"772938", "Тупкараганский\ р\-н",
"7813", "Ленинградская\ обл\.",
"771147", "Акжаикский\ р\-н",
"772752", "Илийский\ р\-н",
"772330", "Зыряновский\ р\-н",
"771143", "Теректинский\ р\-н",
"7833", "Кировская\ обл\.",
"771230", "Атырауская\ область",
"771043", "Жайрем\ \(поселок\)",
"7491", "Рязанская\ обл\.",
"77224", "Эмельтау",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"771642", "Егиндыкольский\ р\-н",
"771149", "Акжаикский\ р\-н",
"771435", "Житикаринский\ р\-н",
"772836", "Ескельдинский\ р\-н",
"772643", "Шуский\ р\-н",
"771438", "Амангельдинский\ р\-н",
"772144", "Нуринский\ р\-н",
"772545", "Икан",
"772631", "Турара\ Рыскулова\ р\-н",
"772548", "Шаян",
"771840", "Баянаульский\ р\-н",
"77112", "Уральск",
"77279", "Алматы",
"7474", "Липецкая\ обл\.",
"7416", "Амурская\ обл\.",
"771031", "Шетский\ р\-н",
"772771", "Карасайский\ р\-н",
"771455", "Костанайский\ р\-н",
"771348", "Шалкарский\ р\-н",
"771345", "Байганинский\ р\-н",
"771458", "Костанайская\ область",
"7815", "Мурманская\ обл\.",
"772436", "Сырдарьинский\ р\-н",
"771838", "Майский\ р\-он",
"772530", "Темирлановка",
"77245", "Кызылординская\ область",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"771330", "Хромтауский\ р\-н",
"771649", "Жаксынский\ р\-н",
"771142", "Акжаикский\ р\-н",
"7341", "Республика\ Удмуртская",
"772757", "Акший",
"7496", "г\.\ Москва",
"772147", "Каркаралинский\ р\-н",
"7411", "Республика\ Саха\ \/Якутия\/",
"77162", "Кокшетау",
"772346", "Тарбагатайский\ р\-н",
"772644", "Таласский\ р\-н",
"772131", "Абайский\ р\-н",
"771546", "Акжарский\ р\-н",
"7394", "Республика\ Тыва",
"771440", "Амангельдинский\ р\-н",
"7342", "Пермский\ край",
"772251", "Курчатов",
"7493", "Ивановская\ обл\.",
"772841", "Аксуский\ р\-н",
"771349", "Шалкарский\ р\-н",
"771630", "Боровое",
"77272956", "Талгар",
"771459", "Костанайская\ область",
"772937", "Каракиянский\ р\-н",
"771832", "Иртышский\ р\-н",
"772344", "Тарбагатайский\ р\-н",
"772833", "Алакольский\ р\-н",
"772837", "Алакольский\ р\-н",
"77132", "Актобе\/Актюбинск",
"77252", "Шымкент",
"771544", "Жамбылский\ р\-н",
"771439", "Джангильдинский\ р\-н",
"771145", "Каратобинский\ р\-н",
"771547", "Жамбылский\ р\-н",
"772542", "Асыката",
"7492", "Владимирская\ обл\.",
"772351", "Бородулихинский\ р\-н",
"771543", "Есильский\ р\-н",
"771130", "Зеленовский\ р\-н",
"772343", "Курчумский\ р\-н",
"771452", "Карасуский\ р\-н",
"772834", "Каратальский\ р\-н",
"771342", "Каргалинский\ р\-н",
"7865", "Ставропольский\ край",
"7821", "Республика\ Коми",
"740", "Калининградская\ обл\.",
"7343", "Свердловская\ обл",
"772347", "Жарминский\ р\-н",
"772934", "Жанаозен",
"7485", "Ярославская\ обл\.",
"7413", "Магаданская\ обл\.",
"771839", "Лебяжинский\ р\-н",
"772331", "Глубоковский\ р\-н",
"772146", "Каркаралинск",
"77273", "Алма\-Ата",
"771531", "Магжана\ Жумабаева\ р\-н",
"771645", "Степногорск",
"77122", "Атырау",
"771648", "Жаркаинский\ р\-н",
"772433", "Аральский\ р\-н",
"772437", "Кармакшинский\ р\-н",};
$areanames{en} = {"771147", "Akzhaiksky\ District",
"7813", "Leningrad\ region",
"772330", "Zyryanovsky\ District",
"772752", "Otegen\ Batyra",
"771143", "Akzhaik",
"7833", "Kirov",
"7352", "Kurgan",
"7388", "Republic\ of\ Altai",
"772838", "Balpyk\ bi",
"7861", "Krasnodar\ Territory",
"772835", "Tekeli",
"771436", "Taranovskoye",
"772938", "Fort\ Shevchenko",
"772935", "Zhetybai",
"7481", "Smolensk",
"77272983", "Kaskelen",
"772546", "Sholakkorgan",
"771131", "Darinskoye",
"771644", "Arshaly",
"771346", "Shubarkuduk",
"77102", "Zhezkazgan",
"771456", "Kachar",
"77262", "Taraz",
"7421", "Khabarovsk\ Territory",
"772438", "Aiteke\ bi",
"7384", "Kemerovo",
"772759", "Almaty\ Region",
"77185", "Shaldai",
"771643", "Atbasar",
"771836", "Sharbakty",
"772435", "Zhanakorgan",
"772149", "Osakarovka",
"772642", "Moiynkum",
"771042", "Zharyk",
"7877", "Republic\ of\ Adygeya",
"771647", "Esil",
"7353", "Orenburg",
"772230", "Urdzhar",
"7866", "Kabardino\-Balkarian\ Republic",
"7812", "St\ Petersburg",
"771651", "Kabanbai\ Batyr",
"7847", "Republic\ of\ Kalmykia",
"772345", "Shar",
"772348", "Kokpekty",
"7486", "Orel",
"7426", "Jewish\ Autonomous\ Region",
"77212", "Karaganda",
"772840", "Saryozek",
"771631", "Shortandy",
"771545", "Zhambylsky\ District",
"771144", "Kaztalovka",
"771347", "Aitekebisky\ District",
"7811", "Pskov",
"771457", "Dzhangildinsky\ District",
"772342", "Katon\-Karagai",
"771453", "Auliekol",
"771834", "Uspenka",
"771343", "Irgiz",
"7831", "Nizhni\ Novgorod",
"7848", "Tolyatti",
"772543", "Aqsumbe",
"7879", "Mineranye\ Vody",
"771542", "Kishkenekol",
"7863", "Rostov",
"771441", "Karabalyk",
"7878", "Karachayevo\-Cherkessian\ Republic",
"7345", "Tyumen",
"772547", "Lenger",
"7483", "Bryansk",
"7415", "Kamchatka\ Region",
"771437", "Kamysty",
"771433", "Lisakovsk",
"77222", "Semey",
"772432", "Shiyeli",
"772531", "Aksukent",
"771146", "Akzhaiksky\ District",
"772839", "Sarkand",
"771331", "Martuk",
"7423", "Primorie\ territory",
"7836", "Republic\ of\ Marij\ El",
"771841", "Aktogai",
"7820", "Cherepovets",
"7862", "Sochi",
"7816", "Veliky\ Novgorod",
"7351", "Chelyabinsk",
"771030", "Atasu",
"77145834", "Krasnogorsk",
"7495", "Moscow",
"772770", "Uzynagash",
"771434", "Denisovka",
"7844", "Volgograd",
"772439", "Aralsky\ District",
"772544", "Shaulder",
"772148", "Molodezhnoye",
"77152", "Petropavlovsk",
"771231", "Akkystau",
"772932", "Beineu",
"77232", "Ust\-Kamenogorsk",
"77149", "Kostanai",
"771837", "Aksu",
"771454", "Karamendy",
"771833", "Terenkol",
"771646", "Makinsk",
"772832", "Zhansugurov",
"7482", "Tver",
"77122", "Atyrau",
"771648", "Derzhavinsk",
"772433", "Aralsk",
"771531", "Bulayevo",
"771645", "Stepnogorsk",
"772437", "Zhosaly",
"7485", "Yaroslavl",
"7413", "Magadan",
"772331", "Glubokoye",
"771839", "Akku",
"772146", "Karkaralinsk",
"77273", "Almaty",
"772834", "Ushtobe",
"771342", "Badamsha",
"7865", "Stavropol\ territory",
"771130", "Peremetnoye",
"771452", "Karasu",
"772343", "Terekty",
"772347", "Kalbatau",
"772934", "Zhanaozen",
"7821", "Komi\ Republic",
"740", "Kaliningrad",
"7343", "Ekaterinburg",
"771547", "Zhambylsky\ District",
"772351", "Borodulikha",
"7492", "Vladimir",
"771543", "Yavlenka",
"772542", "Asykata",
"77252", "Shymkent",
"771544", "Presnovka",
"771439", "Torgai",
"771145", "Karatobe\ District",
"772833", "Usharal",
"772937", "Kuryk",
"771832", "Irtyshsk",
"772344", "Akzhar",
"772837", "Kabanbai",
"77132", "Aktobe\/Kargalinskoye",
"772251", "Kurchatov",
"771630", "Burabay",
"77272956", "Talgar",
"771459", "Kostanai\ Region",
"771349", "Shalkarsky\ District",
"772841", "Kapal",
"7342", "Perm",
"771440", "Amangeldy",
"771546", "Talshik",
"7394", "Republic\ of\ Tuva",
"77162", "Kokshetau\/Krasni\ Yar",
"7411", "Republic\ of\ Sakha",
"772346", "Aksuat",
"772644", "Karatau",
"772131", "Abai",
"771142", "Taipak",
"771649", "Zhaksynsky\ District",
"771330", "Khromtau\ District",
"7496", "Moscow",
"772147", "Egindybulak",
"772757", "Akshi",
"7341", "Udmurtian\ Republic",
"7815", "Murmansk",
"771838", "Koktobe",
"772530", "Temirlanovka",
"77245", "Kyzylorda\ Region",
"7835", "Chuvashi\ Republic",
"772436", "Terenozek",
"772771", "Kaskelen",
"771345", "Karauylkeldy",
"771458", "Kostanai\ Region",
"771455", "Zatobolsk",
"771348", "Shalkarsky\ District",
"772548", "Shayan",
"771840", "Bayanaul",
"772144", "Kiyevka",
"772545", "Ikan",
"772631", "Kulan",
"7474", "Lipetsk",
"7416", "Amur\ Region",
"771031", "Aksu\-Ayuly",
"77112", "Uralsk",
"77279", "Almaty",
"77224", "Barshatas",
"7346", "Surgut",
"771043", "Zhairem",
"7491", "Ryazan",
"772643", "Shu",
"771438", "Amangeldy",
"771149", "Zelenovsky\ District",
"771642", "Egendykol",
"771435", "Zhitikara",
"772836", "Karabulak",
"771230", "Atyrau\ Region",
"7302", "Chita",
"7851", "Astrakhan",
"772341", "Ulken\ Naryn",
"7499", "Moscow",
"77274", "Karassaisky\ District",
"7498", "Moscow",
"771638", "Akkol",
"771635", "Zhaksy",
"771442", "Fyodorovka",
"771541", "Mamlutka",
"772353", "Novaya\ Shulba",
"771533", "Saumalkol",
"772156", "Shakhtinsk",
"772431", "Zhalagash",
"772532", "Abai",
"77213", "Aktau\/Temirtau",
"771239", "Makat",
"771537", "Timiryazevo",
"77182", "Pavlodar",
"772337", "Serebryansk",
"7391", "Krasnoyarsk\ Territory",
"771332", "Uil",
"771140", "Saikhin",
"772333", "Samarskoye",
"771036", "Balkhash",
"772843", "Lepsy",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"7712303", "Tengizs",
"771842", "Koktobe",
"772334", "Tavricheskoye",
"772636", "Kordai",
"772257", "Shulbinsk",
"771534", "Sergeyevka",
"771135", "Zhanibek",
"771449", "Taranovskoye",
"7845", "Saratov",
"771138", "Zhalpaktal",
"772776", "Shelek",
"7494", "Kostroma",
"77142", "Kostanai",
"771232", "Atyrau\ Region",
"7471", "Kursk",
"772539", "Kazygurt",
"733", "Baikonur",
"772237", "Ayagoz",
"771640", "Balkashino",
"772831", "Zharkent",
"771339", "Komsomolskoye",
"772931", "Shetpe",
"772634", "Zhanatas",
"772336", "Ridder",
"771238", "Miyaly",
"771034", "Zhezdy",
"771235", "Dossor",
"7347", "Republic\ of\ Bashkortostan",
"772725", "Otegen\ Batyra",
"772774", "Talgar",
"771430", "Arkalyk",
"772153", "Topar",
"771536", "Taiynsha",
"772540", "Arys",
"771845", "Pavlodar\ Area",
"77106", "Satpaev",
"772137", "Saran",
"771639", "Stepnyak",
"771132", "Fyodorovka",
"7472", "Belgorod",
"771340", "Khobdinsky\ District",
"771041", "Aktau\,\ Zhezkazgan",
"7385", "Altai\ Territory",
"772538", "Turara\ Ryskulova",
"772641", "Akkol",
"772535", "Shardara",
"771335", "Shalkar",
"7712302", "Tengizshevroil",
"7301", "Republic\ of\ Buryatia",
"772236", "Beskaragai",
"772773", "Bakanas",
"7473", "Voronezh",
"772777", "Kegen",
"772154", "Botakara",
"772633", "Asa",
"771037", "Aktogai",
"771448", "Oktyabrskoye",
"771445", "Ubaganskoye",
"736", "Simferopol",
"771632", "Zerenda",
"771139", "Taskala",
"771033", "Agadyr",
"772256", "Kainar",
"772637", "Sarykemer",
"7427", "Chukotka\ Autonomous\ District",
"77187", "Ekibastuz",
"772779", "Narynkol",
"771540", "Kishkenekol",
"771446", "Uzunkolsky\ District",
"7395", "Irkutsk",
"772132", "Nurinsky\ District",
"772639", "Saudakent",
"772340", "Zaisan",
"771133", "Aksai",
"771137", "Chingirlau",
"7487", "Tula",
"771039", "Priozersk",
"7382", "Tomsk",
"771141", "Zhangala",
"771336", "Khromtau",
"7867", "Republic\ of\ North\ Ossetia",
"77135", "Aktobe\ Region",
"7846", "Samara",
"7834", "Republic\ of\ Mordovia",
"772536", "Kentau",
"7855", "Naberezhnye\ Chelny",
"7814", "Republic\ of\ Karelia",
"77272", "Almaty",
"772772", "Kapchagai",
"7475", "Tambov",
"771032", "Karazhal",
"771637", "Korgalzhyn",
"771633", "Ereimentau",
"772632", "Merke",
"7841", "Penza",
"771538", "Beskol",
"772830", "Alakolsky\ District",
"771535", "Novoishimski",
"771641", "Astrakhanka",
"771134", "Zhympity",
"7818", "Arkhangelsk",
"77125", "Atyrau\ Region",
"7871", "Chechen\ Republic",
"771236", "Makhambet",
"772335", "Zyryanovsk",
"7383", "Novosibirsk",
"772338", "Bozanbai\/Molodezhnyi",
"772159", "Karaganda\ Region",
"7424", "Sakhalin\ Region",
"772239", "Makanchi",
"772537", "Saryagash",
"772533", "Turkestan",
"771431", "Rudny",
"771532", "Smirnovo",
"772332", "Shemonaikha",
"77292", "Aktau",
"771844", "Irtyshsky\ District",
"771333", "Kandyagash",
"771337", "Alga",
"77282", "Taldykorgan",
"7484", "Kaluga",
"772775", "Esik",
"772778", "Chundzha",
"771136", "Chapayev",
"7872", "Republic\ of\ Daghestan",
"771341", "Khobda",
"771451", "Sarykol",
"7717", "Astana",
"771443", "Borovskoi",
"772638", "Tole\ bi",
"772541", "Myrzakent",
"772635", "Bauyrzhan\ Mamyshuly",
"7817", "Vologda",
"771035", "Ulytau",
"771234", "Indernborski",
"771447", "Karabalyksky\ District",
"7842", "Ulyanovsk",
"771038", "Shashubai",
"771444", "Uzunkol",
"771539", "Beskol",
"771237", "Kulsary",
"77242", "Kyzylorda",
"771233", "Ganyushkino",
"7390", "Republic\ of\ Khakassia",
"771040", "Zhairem\ \(GOK\)",
"772640", "Moiynkumsky\ District",
"771831", "Zhelezinka",
"772339", "Kurchum",
"7843", "Republic\ of\ Tatarstan",
"771843", "Maisky\ District",
"771636", "Shuchinsk",
"771334", "Emba",
"772842", "Kogaly",
"772252", "Karaul",
"7869", "Sevastopol",
"7873", "Ingushi\ Republic",
"772534", "Zhetysai",
"7381", "Omsk",
"772138", "Gabidena\ Mustafina",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '33' => [
                         'Asia/Almaty'
                       ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;