/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Properties;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.event.TransformerReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;

public class TimingTraceListener
implements TraceListener {
    private int repeat = 0;
    Logger out = new StandardLogger();
    private long t_total;
    private Stack<InstructionDetails> instructs = new Stack();
    HashMap<InstructionInfo, InstructionDetails> instructMap = new HashMap();
    protected Configuration config = null;
    private InstructionInfo[] instructStack = new InstructionInfo[1500];
    private int stackDepth = 0;
    private int lang = 50;

    public void setOutputDestination(Logger stream) {
        this.out = stream;
    }

    public void open(Controller controller) {
        this.config = controller.getConfiguration();
        this.lang = controller.getExecutable().getHostLanguage();
        this.t_total = System.nanoTime();
    }

    public void close() {
        this.t_total = System.nanoTime() - this.t_total;
        ++this.repeat;
        try {
            PreparedStylesheet sheet = this.getStyleSheet();
            Controller controller = sheet.newController();
            Properties props = new Properties();
            props.setProperty("method", "html");
            props.setProperty("indent", "yes");
            controller.setTraceListener(null);
            TransformerReceiver tr = new TransformerReceiver(controller);
            controller.initializeController(new GlobalParameterSet());
            tr.open();
            SequenceReceiver result = this.config.getSerializerFactory().getReceiver(this.out.asStreamResult(), controller.makePipelineConfiguration(), props);
            tr.setDestination(result);
            StreamWriterToReceiver writer = new StreamWriterToReceiver(tr);
            writer.writeStartDocument();
            writer.writeStartElement("trace");
            writer.writeAttribute("t-total", Double.toString((double)this.t_total / 1000000.0));
            for (InstructionDetails ins : this.instructMap.values()) {
                writer.writeStartElement("fn");
                String name = "UNKNOWN";
                if (ins.instruct.getObjectName() != null) {
                    name = ins.instruct.getObjectName().getDisplayName();
                    writer.writeAttribute("name", name);
                } else if (ins.instruct.getProperty("name") != null) {
                    name = ins.instruct.getProperty("name").toString();
                    writer.writeAttribute("name", name);
                }
                if (ins.instruct.getProperty("match") != null) {
                    name = ins.instruct.getProperty("match").toString();
                    writer.writeAttribute("match", name);
                }
                if (ins.instruct.getProperty("mode") != null) {
                    name = ins.instruct.getProperty("mode").toString();
                    writer.writeAttribute("mode", name);
                }
                writer.writeAttribute("construct", ins.instruct.getConstructType() == 158 ? "function" : (ins.instruct.getConstructType() == 206 ? "variable" : "template"));
                String file = ins.instruct.getSystemId();
                if (file != null) {
                    writer.writeAttribute("file", file);
                }
                writer.writeAttribute("count", Long.toString(ins.count / (long)this.repeat));
                writer.writeAttribute("t-sum-net", Double.toString((double)ins.net / (double)this.repeat / 1000000.0));
                writer.writeAttribute("t-avg-net", Double.toString((double)ins.net / (double)ins.count / 1000000.0));
                writer.writeAttribute("t-sum", Double.toString((double)ins.gross / (double)this.repeat / 1000000.0));
                writer.writeAttribute("t-avg", Double.toString((double)ins.gross / (double)ins.count / 1000000.0));
                writer.writeAttribute("line", Long.toString(ins.instruct.getLineNumber()));
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XPathException e) {
            System.err.println("Unable to transform timing profile information: " + e.getMessage());
        }
        catch (TransformerException e) {
            System.err.println("Unable to render timing profile information: " + e.getMessage());
        }
        catch (XMLStreamException e) {
            System.err.println("Unable to generate timing profile information: " + e.getMessage());
        }
    }

    public void enter(InstructionInfo instruction, XPathContext context) {
        int loc = instruction.getConstructType();
        if (loc == 158 || loc == 200 || loc == 206) {
            long start = System.nanoTime();
            InstructionDetails instructDetails = new InstructionDetails();
            instructDetails.instruct = instruction;
            instructDetails.gross = start;
            this.instructs.add(instructDetails);
            this.instructStack[this.stackDepth++] = instruction;
        }
    }

    public void leave(InstructionInfo instruction) {
        int loc = instruction.getConstructType();
        if (loc == 158 || loc == 200 || loc == 206) {
            long net;
            InstructionDetails instruct = this.instructs.peek();
            long duration = System.nanoTime() - instruct.gross;
            instruct.net = net = duration - instruct.net;
            instruct.gross = duration;
            InstructionDetails foundInstructDetails = this.instructMap.get(instruction);
            if (foundInstructDetails == null) {
                instruct.count = 1L;
                this.instructMap.put(instruction, instruct);
                --this.stackDepth;
            } else {
                ++foundInstructDetails.count;
                boolean inStack = false;
                for (int i = 0; i < this.stackDepth - 1; ++i) {
                    if (this.instructStack[i] != instruction) continue;
                    inStack = true;
                    break;
                }
                --this.stackDepth;
                if (!inStack) {
                    foundInstructDetails.gross += instruct.gross;
                }
                foundInstructDetails.net += instruct.net;
            }
            this.instructs.pop();
            if (this.instructs.size() > 0) {
                InstructionDetails parentInstruct = this.instructs.peek();
                parentInstruct.net += duration;
            }
        }
    }

    public void startCurrentItem(Item item) {
    }

    public void endCurrentItem(Item item) {
    }

    public PreparedStylesheet getStyleSheet() throws XPathException {
        String process = this.lang == 50 ? "Stylesheet" : "Query";
        String templateOr = this.lang == 50 ? "template, " : "";
        String templatesAnd = this.lang == 50 ? "templates and " : "";
        String xsl = "<?xml version='1.0' encoding='UTF-8'?><xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:xs='http://www.w3.org/2001/XMLSchema' exclude-result-prefixes='xs' version='2.0'><xsl:template match='*'><html><head><title>Analysis of " + process + " Execution Time</title>" + "</head>" + "<body>" + "<h1>Analysis of " + process + " Execution Time</h1>" + "<p>Total time: <xsl:value-of select='format-number(@t-total, \"#0.000\")'/> milliseconds</p>" + "<h2>Time spent in each " + templateOr + "function or global variable:</h2>" + "<p>The table below is ordered by the total net time spent in the " + templateOr + "   function or global variable. Gross time means the time including called " + templatesAnd + "functions (recursive calls only count from the original entry);" + "  net time means time excluding time spent in called " + templatesAnd + "functions.</p>" + "<table border='border' cellpadding='10'>" + "   <thead>" + "      <tr>" + "         <th>file</th>" + "        <th>line</th>" + "       <th>instruction</th>" + "      <th>count</th>" + "     <th>average time (gross/ms)</th>" + "    <th>total time (gross/ms)</th>" + "   <th>average time (net/ms)</th>" + "  <th>total time (net/ms)</th>" + "</tr>" + "</thead>" + "<tbody>" + "   <xsl:for-each select='fn'>" + "  <xsl:sort select='number(@t-sum-net)' order='descending'/>" + "      <tr>" + "         <td>" + "            \"<xsl:value-of select='if(string-length(@file) gt 15) then \"*\" else (),substring(@file,string-length(@file) - 15)' separator=''/>\"" + "       </td>" + "      <td>" + "         <xsl:value-of select='@line'/>" + "    </td>" + "   <td>" + "      <xsl:value-of select='@construct, @name, @match'/>" + " </td>" + "<td align='right'>" + "    <xsl:value-of select=\"format-number(@count,',##0')\"/>" + "</td>" + "    <td align='right'>" + "       <xsl:value-of select=\"format-number(@t-avg, '#0.000')\"/>" + "  </td>" + " <td align='right'>" + "    <xsl:value-of select=\"format-number(@t-sum, ',##0.000')\"/>" + "</td>" + " <td align='right'>" + "    <xsl:value-of select=\"format-number(@t-avg-net, '#0.000')\"/>" + "</td>" + "<td align='right'>" + "   <xsl:value-of select=\"format-number(@t-sum-net, ',##0.000')\"/>" + " </td>" + "</tr>" + " </xsl:for-each>" + "</tbody>" + "</table>" + "</body>" + "</html>" + "</xsl:template>" + "</xsl:stylesheet>";
        StreamSource styleSource = new StreamSource(new StringReader(xsl));
        CompilerInfo compilerInfo = this.config.getDefaultXsltCompilerInfo();
        compilerInfo.setCodeInjector(null);
        return Compilation.compileSingletonPackage(this.config, compilerInfo, styleSource);
    }

    private static class InstructionDetails {
        public InstructionInfo instruct;
        public long gross;
        public long net;
        public long count;

        private InstructionDetails() {
        }
    }
}

