# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20231210185945;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3(?:
                [045]|
                9(?:
                  [0-58]|
                  6[4-9]|
                  7[0-35689]
                )
              )|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9[0169]
              )|
              3(?:
                [29]|
                60|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[2-57-9]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                7(?:
                  2[2-468]|
                  3[78]
                )|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              8294|
              96
            )[1-3]|
            2(?:
              57|
              93
            )[015-9]|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              8292|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{ja} = {"819957", "加治木",
"814700", "鴨川",
"811463", "浦河",
"817963", "豊岡",
"812475", "石川",
"818244", "三次",
"812832", "佐野",
"817683", "輪島",
"815954", "上野",
"811235", "夕張",
"812957", "大子",
"814795", "銚子",
"81593", "四日市",
"819598", "福江",
"814291", "飯能",
"812657", "伊那",
"81563", "西尾",
"819933", "指宿",
"818360", "小郡",
"812933", "高萩",
"811394", "松前",
"814223", "武蔵野三鷹",
"815985", "松阪",
"81564", "岡崎",
"81465", "小田原",
"811352", "余市",
"819943", "鹿屋",
"812617", "大町",
"818956", "宇和島",
"818362", "宇部",
"817466", "十津川",
"814702", "館山",
"817486", "水口",
"812643", "木曾福島",
"815992", "鳥羽",
"81495", "本庄",
"818382", "萩",
"818656", "笠岡",
"812917", "水戸",
"812830", "宇都宮",
"81167", "富良野",
"811986", "遠野",
"81126", "岩見沢",
"817903", "福崎",
"81989", "那覇",
"81825", "広島",
"81594", "桑名",
"818542", "安来",
"8188093", "窪川",
"8198292", "延岡",
"81429", "所沢",
"81899", "松山",
"811754", "むつ",
"817357", "串本",
"811586", "中湧別",
"81538", "磐田",
"81554", "大月",
"818942", "八幡浜",
"811375", "八雲",
"815565", "鰍沢青柳",
"812856", "真岡",
"817724", "宮津",
"817718", "園部",
"815585", "下田",
"818556", "江津",
"819543", "武雄",
"81157", "北見",
"812412", "喜多方",
"811566", "十勝清水",
"814996", "八丈島",
"812543", "新発田",
"818296", "広島",
"812383", "米沢",
"818843", "阿南",
"819823", "延岡",
"811878", "大曲",
"81577", "高山",
"815766", "下呂",
"812698", "飯山",
"818833", "鴨島",
"819557", "唐津",
"81174", "蟹田",
"812998", "潮来",
"811867", "鷹巣",
"814240", "国分寺",
"818374", "長門",
"812899", "鹿沼",
"81582", "岐阜",
"81553", "山梨",
"812557", "新井",
"811336", "石狩",
"811863", "鹿角",
"815996", "阿児",
"817482", "八日市",
"819432", "八女",
"814706", "大原",
"812553", "上越",
"812788", "前橋",
"819788", "国東",
"817738", "舞鶴",
"818546", "掛合",
"819553", "伊万里",
"818652", "倉敷",
"811982", "花巻",
"812875", "大田原",
"81436", "市原",
"81555", "吉田",
"818952", "宇和島",
"81438", "木更津",
"818366", "宇部",
"811356", "岩内",
"817495", "長浜",
"819725", "佐伯",
"818837", "阿波池田",
"819827", "高千穂",
"812547", "村上",
"812378", "寒河江",
"812387", "長井",
"818847", "牟岐",
"81551", "韮崎",
"81482", "川口",
"811734", "五所川原",
"815959", "亀山",
"819547", "鹿島",
"818249", "東広島",
"818694", "岡山",
"81878", "高松",
"8198298", "日向",
"81249", "郡山",
"81949", "直方",
"812836", "佐野",
"8186994", "岡山瀬戸",
"817353", "新宮",
"817474", "五条",
"812913", "鉾田",
"817907", "播磨山崎",
"81561", "瀬戸",
"811332", "当別",
"81463", "平塚",
"819913", "硫黄島",
"812647", "長野",
"811974", "水沢",
"81823", "呉",
"81591", "津",
"818512", "西郷",
"81493", "東松山",
"812248", "大河原",
"81222", "仙台",
"818205", "柳井",
"81922", "福岡",
"818290", "広島",
"812894", "宇都宮",
"815762", "下呂",
"812613", "大町",
"819947", "志布志",
"818594", "米子",
"812937", "水戸",
"811562", "本別",
"814771", "市川",
"812416", "田島",
"814227", "武蔵野三鷹",
"818552", "浜田",
"818265", "安芸吉田",
"81494", "秩父",
"812238", "仙台",
"818675", "久世",
"8178", "神戸",
"812852", "小山",
"8186691", "倉敷",
"812653", "飯田",
"818292", "広島",
"814992", "伊豆大島",
"819937", "加世田",
"817967", "八鹿",
"817678", "七尾",
"817687", "能都",
"81464", "厚木",
"818975", "新居浜",
"819953", "大口",
"818946", "宇和",
"81542", "静岡",
"811582", "紋別",
"8198299", "日向",
"81565", "豊田",
"812482", "白河",
"811932", "釜石",
"812567", "巻",
"818792", "三本松",
"819738", "玖珠",
"811374", "森",
"811857", "能代",
"815564", "鰍沢青柳",
"818679", "新見",
"819578", "島原",
"814775", "船橋",
"811523", "斜里",
"815756", "郡上八幡",
"819806", "沖縄宮古",
"817725", "宮津",
"815584", "下田",
"8188098", "土佐清水",
"818878", "嶺北",
"81531", "田原",
"811632", "天塩",
"81433", "千葉",
"812587", "長岡",
"812578", "六日町",
"81987", "日南",
"815972", "尾鷲",
"811556", "帯広",
"81857", "鳥取",
"81535", "浜松",
"81434", "千葉",
"811642", "石狩深川",
"818807", "宿毛",
"818375", "美祢",
"811942", "岩泉",
"818586", "倉吉",
"81272", "前橋",
"817367", "岩出",
"8199343", "鹿児島",
"81199", "盛岡",
"812748", "富岡",
"818245", "三次",
"814286", "相模原",
"815955", "上野",
"811542", "釧路",
"812474", "石川",
"81125", "滝川",
"81468", "横須賀",
"814794", "銚子",
"818666", "井原",
"811234", "千歳",
"811656", "美深",
"8112394", "夕張",
"815396", "浜松",
"819208", "対馬佐賀",
"815732", "恵那",
"811395", "江差",
"8188099", "土佐清水",
"817947", "三木",
"817456", "大和高田",
"81722", "堺",
"8182941", "広島",
"818686", "津山",
"811362", "倶知安",
"811956", "岩手",
"81466", "藤沢",
"817613", "小松",
"8125481", "村上",
"81427", "相模原",
"81828", "広島",
"819667", "水俣",
"812793", "渋川",
"819978", "徳之島",
"812879", "烏山",
"817238", "寝屋川",
"815984", "松阪",
"812978", "竜ケ崎",
"81460", "小田原",
"812678", "佐久",
"812967", "笠間",
"811532", "根室",
"817953", "西脇",
"814752", "茂原",
"811453", "早来",
"818463", "竹原",
"819967", "出水",
"819687", "玉名",
"815742", "美濃加茂",
"819678", "矢部",
"81566", "刈谷",
"811457", "門別富川",
"818467", "木江",
"818582", "倉吉",
"811975", "水沢",
"819963", "川内",
"819683", "山鹿",
"811946", "久慈",
"812963", "下館",
"817475", "下市",
"81839", "山口",
"817957", "丹波柏原",
"812895", "宇都宮",
"818595", "米子",
"819663", "人吉",
"812797", "渋川",
"811646", "羽幌",
"818562", "益田",
"818478", "東城",
"81596", "伊勢",
"818204", "柳井",
"811552", "帯広",
"81568", "春日井",
"81124", "芦別",
"819802", "南大東",
"815752", "関",
"817617", "加賀",
"81947", "田川",
"818264", "安芸吉田",
"811636", "北見枝幸",
"817943", "加古川",
"818674", "久世",
"8153977", "天竜",
"818796", "土庄",
"818974", "新居浜",
"811936", "宮古",
"812486", "須賀川",
"817917", "竜野",
"815589", "修善寺大仁",
"817363", "和歌山橋本",
"818660", "岡山瀬戸",
"812874", "大田原",
"811536", "厚岸",
"81533", "豊橋",
"814280", "立川",
"818803", "土佐中村",
"815746", "美濃加茂",
"81178", "八戸",
"8152", "名古屋",
"814756", "東金",
"81875", "観音寺",
"81176", "十和田",
"81550", "御殿場",
"818680", "岡山",
"817494", "彦根",
"818391", "小郡",
"819724", "佐伯",
"811735", "五所川原",
"817452", "大和高田",
"812583", "長岡",
"811527", "美幌",
"8198293", "延岡",
"811366", "寿都",
"818682", "津山",
"811952", "二戸",
"8188092", "窪川",
"811652", "士別",
"817998", "津名",
"818662", "高梁",
"811546", "釧路",
"814282", "青梅",
"81534", "浜松",
"815736", "中津川",
"812563", "三条",
"818695", "岡山瀬戸",
"815392", "浜松",
"811853", "男鹿",
"812245", "大河原",
"81226", "気仙沼",
"818208", "久賀",
"818474", "府中",
"8186698", "倉敷",
"811643", "石狩深川",
"8186996", "岡山瀬戸",
"819666", "水俣",
"815973", "尾鷲",
"81926", "福岡",
"81723", "堺",
"81928", "福岡",
"811943", "岩泉",
"819686", "玉名",
"819966", "出水",
"81228", "築館",
"81724", "岸和田貝塚",
"818793", "三本松",
"815397", "浜松",
"818879", "室戸",
"812483", "白河",
"811933", "釜石",
"817675", "七尾",
"812579", "小出",
"8112390", "夕張",
"814287", "青梅",
"81546", "静岡",
"818978", "伯方",
"818667", "井原",
"811957", "岩手",
"818678", "新見",
"812235", "仙台",
"818687", "美作",
"81548", "榛原",
"81220", "迫",
"818268", "千代田",
"811522", "斜里",
"817946", "三木",
"812571", "六日町",
"817457", "大和高田",
"819728", "臼杵",
"817498", "長浜",
"818567", "津和野",
"811557", "十勝池田",
"81480", "久喜",
"812792", "渋川",
"819679", "高森",
"812679", "佐久",
"81737", "湯浅",
"817952", "西脇",
"812785", "沼田",
"817366", "岩出",
"812979", "竜ケ崎",
"811533", "根室",
"81432", "千葉",
"815743", "美濃加茂",
"818806", "宿毛",
"819979", "徳之島",
"8198291", "延岡",
"812878", "烏山",
"811452", "早来",
"814753", "茂原",
"819785", "豊後高田",
"817735", "福知山",
"817239", "寝屋川",
"818587", "郡家",
"818462", "竹原",
"817950", "三田",
"8186552", "倉敷",
"817912", "相生",
"811543", "釧路",
"812566", "三条",
"815733", "恵那",
"811856", "能代",
"81776", "福井",
"817994", "洲本",
"81488", "浦和",
"81486", "浦和",
"812375", "村山",
"81778", "武生",
"8112397", "栗山",
"812586", "長岡",
"817612", "小松",
"81273", "高崎",
"815757", "郡上八幡",
"819807", "沖縄宮古",
"811363", "倶知安",
"812574", "柏崎",
"8153960", "天竜",
"811526", "網走",
"81532", "豊橋",
"818874", "安芸",
"819803", "名護",
"815753", "関",
"815588", "修善寺大仁",
"811367", "寿都",
"817715", "亀岡",
"8153974", "天竜",
"817942", "加古川",
"819574", "諫早",
"815737", "中津川",
"811378", "今金",
"819734", "日田",
"811547", "白糠",
"81975", "大分",
"819962", "川内",
"815747", "美濃白川",
"819682", "山鹿",
"818479", "東城",
"812744", "藤岡",
"814757", "東金",
"812995", "石岡",
"818583", "倉吉",
"81586", "一宮",
"819744", "三重",
"811537", "中標津",
"812962", "下館",
"817704", "敦賀",
"811875", "角館",
"818563", "益田",
"812695", "中野",
"811553", "帯広",
"819662", "人吉",
"817940", "加古川",
"811637", "北見枝幸",
"81939", "北九州",
"812582", "長岡",
"817453", "大和高田",
"811953", "二戸",
"818683", "津山",
"81721", "富田林",
"817616", "小松",
"818895", "須崎",
"819204", "郷ノ浦",
"814283", "青梅",
"817916", "竜野",
"811653", "士別",
"818663", "総社",
"811238", "栗山",
"818797", "土庄",
"815393", "浜松",
"819595", "有川",
"811852", "男鹿",
"814798", "八日市場",
"812478", "三春",
"812562", "三条",
"811937", "宮古",
"812487", "須賀川",
"8162", "大阪",
"819674", "熊本一の宮",
"8182943", "広島",
"817956", "三田",
"817362", "和歌山橋本",
"818466", "木江",
"8125483", "村上",
"811456", "門別富川",
"811947", "久慈",
"812560", "糸魚川",
"818802", "窪川",
"812674", "小諸",
"811647", "羽幌",
"812796", "渋川",
"812580", "十日町",
"812974", "水海道",
"815988", "三瀬谷",
"815977", "熊野",
"8112395", "栗山",
"818398", "小郡",
"81725", "和泉",
"819974", "屋久島",
"811353", "余市",
"8186995", "岡山瀬戸",
"815767", "下呂",
"818363", "宇部",
"819942", "大根占",
"81172", "弘前",
"81584", "大垣",
"8111", "札幌",
"812930", "水戸",
"814220", "国分寺",
"81485", "熊谷",
"812642", "木曾福島",
"81775", "大津",
"815993", "鳥羽",
"811866", "鷹巣",
"812556", "糸魚川",
"811337", "石狩",
"814703", "館山",
"819784", "豊後高田",
"81969", "天草",
"817734", "福知山",
"812784", "沼田",
"817902", "福崎",
"8147955", "八日市場",
"819556", "唐津",
"818543", "安来",
"818383", "萩",
"817960", "八鹿",
"812640", "長野",
"811462", "浦河",
"815368", "設楽",
"811587", "中湧別",
"8182920", "廿日市",
"817995", "洲本",
"817356", "串本",
"817962", "豊岡",
"817682", "輪島",
"818698", "備前",
"812833", "宇都宮",
"8167", "大阪",
"819932", "指宿",
"819940", "志布志",
"814298", "飯能",
"811738", "鰺ケ沢",
"819599", "大瀬戸",
"818297", "廿日市",
"81552", "甲府",
"81583", "岐阜",
"812857", "真岡",
"812374", "村山",
"811567", "十勝清水",
"812932", "高萩",
"818557", "川本",
"814222", "武蔵野三鷹",
"818598", "根雨",
"819822", "延岡",
"812898", "鹿沼",
"8125482", "村上",
"818475", "府中",
"812244", "白石",
"818832", "鴨島",
"812999", "潮来",
"81592", "津",
"818957", "御荘",
"812616", "大町",
"81739", "田辺",
"8182942", "広島",
"811987", "遠野",
"818657", "笠岡",
"811978", "北上",
"81545", "富士",
"81562", "尾張横須賀",
"819437", "田主丸",
"817487", "水口",
"812956", "常陸大宮",
"819956", "加治木",
"818943", "八幡浜",
"817674", "羽咋",
"819542", "武雄",
"81925", "福岡",
"812413", "喜多方",
"81259", "佐渡",
"812382", "米沢",
"812656", "伊那",
"812234", "仙台",
"818842", "阿南",
"81225", "石巻",
"812542", "新発田",
"81726", "茨木",
"8186997", "岡山瀬戸",
"819936", "加世田",
"811398", "熊石",
"814226", "武蔵野三鷹",
"812417", "会津山口",
"812936", "水戸",
"81462", "厚木",
"81544", "富士宮",
"819594", "有川",
"81492", "川越",
"818947", "宇和",
"812550", "安塚",
"815958", "亀山",
"811466", "えりも",
"818248", "庄原",
"81822", "広島",
"817686", "能都",
"819205", "厳原",
"81797", "西宮",
"817352", "新宮",
"817966", "八鹿",
"818894", "須崎",
"81923", "福岡",
"81728", "寝屋川",
"8147957", "八日市場",
"8183768", "下関",
"8175", "京都",
"812552", "上越",
"811862", "鹿角",
"812675", "佐久",
"812646", "長野",
"819433", "八女",
"817483", "八日市",
"811983", "花巻",
"819675", "熊本一の宮",
"819552", "伊万里",
"81924", "福岡",
"817906", "播磨山崎",
"819789", "杵築",
"8125488", "津川",
"8126177", "長野",
"819946", "鹿屋",
"818953", "宇和島",
"819975", "名瀬",
"817463", "吉野",
"812975", "水海道",
"81543", "静岡",
"812789", "前橋",
"812853", "小山",
"811563", "本別",
"819575", "諫早",
"819546", "鹿島",
"818553", "浜田",
"8147950", "八日市場",
"812546", "村上",
"812575", "十日町",
"812652", "飯田",
"818846", "丹生谷",
"817714", "亀岡",
"8186553", "倉敷",
"817728", "峰山",
"818875", "土佐山田",
"81774", "宇治",
"812386", "長井",
"818293", "廿日市",
"819735", "日田",
"81484", "川口",
"81585", "揖斐川",
"812837", "佐野",
"81270", "伊勢崎",
"811583", "紋別",
"81937", "北九州",
"812239", "仙台",
"819952", "大口",
"818547", "掛合",
"81581", "高富",
"818378", "下関",
"818387", "田万川",
"819912", "中之島",
"815997", "阿児",
"812994", "石岡",
"811333", "当別",
"812745", "藤岡",
"814707", "大原",
"81276", "太田",
"812694", "中野",
"81849", "福山",
"819826", "日向",
"8188091", "窪川",
"8125489", "津川",
"811357", "岩内",
"811874", "角館",
"815763", "下呂",
"818367", "宇部",
"817705", "小浜",
"812612", "大町",
"818836", "脇町",
"8112396", "栗山",
"819685", "玉名",
"811973", "水沢",
"8112393", "夕張",
"819965", "川内",
"812992", "石岡",
"812965", "下館",
"81294", "常陸太田",
"817473", "五条",
"812914", "鉾田",
"812614", "大町",
"818593", "米子",
"812246", "大河原",
"812893", "宇都宮",
"812692", "中野",
"81964", "松橋",
"8125485", "津川",
"819665", "人吉",
"81263", "松本",
"81845", "因島",
"812418", "会津山口",
"817712", "亀岡",
"812236", "仙台",
"81862", "岡山",
"812654", "飯田",
"817945", "加古川",
"811397", "奥尻",
"81963", "熊本",
"81766", "高岡",
"812549", "津川",
"817676", "七尾",
"81798", "西宮",
"819954", "加治木",
"81727", "池田",
"812389", "米沢",
"81892", "久万",
"818948", "宇和",
"818247", "庄原",
"815957", "上野",
"815998", "阿児",
"819554", "伊万里",
"814708", "大原",
"817365", "和歌山橋本",
"81734", "和歌山",
"812786", "沼田",
"819786", "杵築",
"817736", "舞鶴",
"818548", "石見大田",
"81852", "松江",
"812554", "上越",
"811864", "大館",
"819949", "大根占",
"81282", "栃木",
"818388", "田万川",
"818377", "下関",
"81253", "新潟",
"818805", "土佐中村",
"818368", "宇部",
"81977", "別府",
"81277", "桐生",
"8186992", "備前",
"81930", "行橋",
"812649", "長野",
"812585", "長岡",
"817969", "浜坂",
"811733", "五所川原",
"812376", "寒河江",
"81236", "山形",
"817727", "峰山",
"81936", "北九州",
"814777", "船橋",
"814229", "武蔵野三鷹",
"815363", "新城",
"811757", "野辺地",
"818892", "佐川",
"812939", "水戸",
"817354", "新宮",
"81938", "北九州",
"819592", "大瀬戸",
"811855", "能代",
"812838", "佐野",
"818693", "邑久",
"812565", "三条",
"812659", "伊那",
"818697", "備前",
"817672", "羽咋",
"81549", "静岡",
"815367", "設楽",
"811588", "興部",
"811753", "むつ",
"8124197", "柳津",
"812858", "真岡",
"812384", "米沢",
"812232", "岩沼",
"817716", "園部",
"818844", "阿南",
"811525", "網走",
"818558", "川本",
"812544", "新発田",
"819544", "武雄",
"814998", "小笠原",
"8125487", "津川",
"811737", "鰺ケ沢",
"818298", "廿日市",
"819232", "前原",
"817723", "宮津",
"814297", "飯能",
"812230", "仙台",
"812242", "白石",
"818834", "鴨島",
"81929", "福岡",
"81885", "小松島",
"811876", "大曲",
"8198294", "延岡",
"819824", "延岡",
"815768", "下呂",
"8153963", "天竜",
"81229", "古川",
"8186998", "岡山瀬戸",
"812696", "飯山",
"812996", "潮来",
"812911", "鉾田",
"812619", "大町",
"8183767", "下関",
"818373", "長門",
"8163", "大阪",
"81188", "秋田",
"8125480", "村上",
"812780", "前橋",
"81965", "八代",
"818896", "須崎",
"817964", "豊岡",
"818490", "尾道",
"818243", "東広島",
"817915", "相生",
"81942", "久留米",
"817684", "輪島",
"81779", "大野",
"815953", "上野",
"81242", "会津若松",
"811464", "静内",
"819596", "福江",
"812372", "村山",
"812934", "高萩",
"811393", "松前",
"814224", "武蔵野三鷹",
"817615", "小松",
"81489", "草加",
"819934", "指宿",
"8186999", "岡山瀬戸",
"818958", "御荘",
"812795", "渋川",
"819944", "鹿屋",
"818597", "根雨",
"817468", "上北山",
"811869", "大館",
"812559", "安塚",
"812897", "鹿沼",
"817904", "福崎",
"812551", "上越",
"812782", "沼田",
"817955", "三田",
"819438", "田主丸",
"817488", "水口",
"812644", "木曾福島",
"811977", "北上",
"811455", "鵡川",
"817732", "福知山",
"819782", "豊後高田",
"812555", "糸魚川",
"8165", "大阪",
"8153962", "天竜",
"811538", "根室標津",
"818804", "土佐中村",
"812672", "小諸",
"811865", "大館",
"8124196", "柳津",
"81184", "本荘",
"812873", "大田原",
"819672", "熊本一の宮",
"815748", "美濃白川",
"8144", "川崎",
"81572", "多治見",
"812799", "長野原",
"8188094", "窪川",
"817364", "和歌山橋本",
"814758", "東金",
"819555", "唐津",
"8112399", "栗山",
"817493", "彦根",
"819723", "佐伯",
"819972", "種子島",
"81935", "北九州",
"8125486", "津川",
"81235", "鶴岡",
"812972", "水海道",
"817959", "三田",
"81587", "一宮",
"817230", "寝屋川",
"81729", "八尾",
"812584", "長岡",
"815587", "修善寺大仁",
"8186697", "倉敷",
"817996", "津名",
"811377", "八雲",
"811854", "男鹿",
"811548", "弟子屈",
"812564", "三条",
"81183", "湯沢",
"815738", "中津川",
"817355", "新宮",
"8183766", "下関",
"81848", "尾道",
"819742", "三重",
"81192", "大船渡",
"812964", "下館",
"819964", "川内",
"819684", "山鹿",
"81979", "中津",
"81742", "奈良",
"812742", "藤岡",
"81765", "魚津",
"818397", "小郡",
"818203", "柳井",
"819664", "人吉",
"817702", "敦賀",
"812615", "大町",
"81162", "稚内",
"812570", "小出",
"811648", "焼尻",
"8112398", "栗山",
"818476", "府中",
"815978", "熊野",
"815987", "三瀬谷",
"818673", "福渡",
"818263", "加計",
"819572", "諫早",
"817944", "加古川",
"812572", "柏崎",
"811638", "利尻礼文",
"818872", "室戸",
"8166", "大阪",
"812655", "飯田",
"814797", "八日市場",
"8169", "大阪",
"818798", "土庄",
"811237", "栗山",
"812955", "常陸大宮",
"819732", "日田",
"811938", "宮古",
"812488", "須賀川",
"812477", "三春",
"819955", "加治木",
"818973", "新居浜",
"81144", "苫小牧",
"814288", "青梅",
"811465", "静内",
"818668", "井原",
"81260", "阿南町",
"817992", "洲本",
"811658", "上川",
"818977", "伯方",
"814793", "銚子",
"815398", "浜松",
"811233", "千歳",
"817914", "相生",
"817685", "輪島",
"812589", "長岡",
"817965", "豊岡",
"812473", "石川",
"817614", "小松",
"819935", "加世田",
"812569", "巻",
"81764", "富山",
"817458", "大和榛原",
"81547", "島田",
"818688", "美作",
"811958", "岩手",
"818677", "新見",
"818267", "千代田",
"814225", "武蔵野三鷹",
"812935", "水戸",
"819945", "鹿屋",
"81763", "福野",
"819976", "名瀬",
"815983", "松阪",
"818207", "久賀",
"812976", "竜ケ崎",
"8112392", "夕張",
"81268", "上田",
"812794", "渋川",
"812676", "佐久",
"81298", "土浦",
"81143", "室蘭",
"81266", "諏訪",
"812645", "木曾福島",
"811454", "鵡川",
"81227", "仙台",
"818464", "竹原",
"817905", "福崎",
"817954", "西脇",
"81927", "福岡",
"81793", "姫路",
"81998", "鹿児島",
"819676", "高森",
"817949", "加古川",
"81234", "酒田",
"81487", "浦和",
"81888", "高知",
"81934", "北九州",
"815563", "鰍沢青柳",
"81958", "長崎",
"819576", "島原",
"81956", "佐世保",
"815583", "下田",
"815758", "郡上八幡",
"819808", "八重山",
"818845", "丹生谷",
"8128798", "大田原",
"81886", "徳島",
"812385", "米沢",
"818876", "土佐山田",
"812545", "村上",
"811524", "網走",
"812576", "十日町",
"819825", "日向",
"81950", "平戸",
"811558", "広尾",
"81250", "新津",
"818835", "脇町",
"817497", "長浜",
"818472", "甲山",
"818568", "津和野",
"819727", "臼杵",
"819969", "中甑",
"817706", "小浜",
"812877", "黒磯",
"81832", "下関",
"819746", "竹田",
"81233", "新庄",
"8186993", "備前",
"818588", "郡家",
"81933", "北九州",
"81738", "御坊",
"812746", "富岡",
"811954", "二戸",
"818684", "津山",
"817454", "大和高田",
"811549", "釧路",
"81743", "奈良",
"81948", "飯塚",
"817618", "加賀",
"8198296", "日向",
"811541", "弟子屈",
"81946", "甘木",
"815394", "浜松",
"8161", "大阪",
"811654", "名寄",
"811236", "千歳",
"818664", "高梁",
"814796", "八日市場",
"812476", "三春",
"81246", "いわき",
"814284", "立川",
"819435", "八女",
"817485", "八日市",
"812673", "小諸",
"817958", "丹波柏原",
"81940", "宗像",
"81439", "木更津",
"81240", "磐城富岡",
"819673", "熊本一の宮",
"812872", "大田原",
"818655", "鴨方",
"819973", "種子島",
"8188097", "土佐清水",
"812798", "長野原",
"818955", "宇和島",
"815986", "松阪",
"81567", "津島",
"819722", "佐伯",
"818477", "東城",
"817492", "彦根",
"811539", "根室標津",
"817465", "吉野",
"812973", "水海道",
"81744", "大和高田",
"818555", "江津",
"811528", "美幌",
"818262", "加計",
"8199331", "鹿児島",
"819573", "諫早",
"812855", "小山",
"81138", "函館",
"818672", "福渡",
"8168", "大阪",
"815586", "下田",
"818873", "安芸",
"818295", "廿日市",
"819804", "名護",
"815754", "関",
"812573", "柏崎",
"811939", "宮古",
"81471", "柏",
"812489", "須賀川",
"811639", "利尻礼文",
"819733", "日田",
"815566", "身延",
"811376", "八雲",
"81835", "防府",
"818972", "新居浜",
"817997", "津名",
"81557", "伊東",
"811585", "遠軽",
"815979", "熊野",
"81177", "青森",
"819743", "三重",
"812743", "藤岡",
"818584", "倉吉",
"8188090", "窪川",
"81182", "横手",
"818202", "柳井",
"818564", "益田",
"811554", "帯広",
"817703", "敦賀",
"815765", "下呂",
"819726", "臼杵",
"817496", "長浜",
"815982", "松阪",
"818365", "宇部",
"817707", "小浜",
"81834", "徳山",
"81288", "今市",
"81988", "那覇",
"814705", "館山",
"812747", "富岡",
"814754", "茂原",
"817368", "岩出",
"81473", "市川",
"815995", "阿児",
"81986", "都城",
"815744", "美濃加茂",
"81286", "宇都宮",
"818808", "土佐清水",
"811534", "中標津",
"818385", "萩",
"812876", "黒磯",
"818545", "木次",
"819747", "竹田",
"818689", "岡山",
"817993", "洲本",
"814281", "相模原",
"81474", "船橋",
"815734", "恵那",
"812835", "佐野",
"812568", "巻",
"812472", "石川",
"811544", "釧路",
"811858", "能代",
"817459", "大和榛原",
"81280", "古河",
"814792", "銚子",
"819737", "玖珠",
"811232", "千歳",
"818877", "嶺北",
"815399", "天竜",
"811364", "倶知安",
"812577", "六日町",
"81833", "下松",
"812588", "長岡",
"8188095", "土佐清水",
"814289", "青梅",
"819577", "島原",
"818669", "総社",
"81932", "北九州",
"8164", "大阪",
"815974", "尾鷲",
"818206", "柳井",
"811644", "留萌",
"812977", "竜ケ崎",
"819977", "瀬戸内",
"8145", "横浜",
"813", "東京",
"819668", "水俣",
"811551", "十勝池田",
"818473", "甲山",
"811559", "帯広",
"819677", "矢部",
"819688", "玉名",
"819968", "出水",
"811944", "岩泉",
"812968", "笠間",
"81191", "一関",
"812677", "佐久",
"81420", "所沢",
"81762", "金沢",
"81426", "八王子",
"812484", "白河",
"811934", "釜石",
"818976", "新居浜",
"818794", "三本松",
"819809", "八重山",
"815562", "鰍沢青柳",
"81467", "藤沢",
"81896", "伊予三島",
"818945", "八幡浜",
"811372", "鹿部",
"818676", "久世",
"81898", "今治",
"815582", "下田",
"812415", "柳津",
"81827", "岩国",
"81142", "伊達",
"811634", "浜頓別",
"818266", "千代田",
"817948", "三木",
"81792", "姫路",
"815755", "関",
"819805", "名護",
"817713", "亀岡",
"812890", "宇都宮",
"818949", "宇和",
"818294", "廿日市",
"814776", "船橋",
"81983", "高鍋",
"81952", "佐賀",
"814994", "三宅",
"81476", "成田",
"811564", "上士幌",
"81252", "新潟",
"818554", "浜田",
"818848", "牟岐",
"817726", "峰山",
"812388", "長井",
"812854", "小山",
"81853", "出雲",
"812377", "寒河江",
"811584", "遠軽",
"81478", "佐原",
"812419", "田島",
"8198295", "日向",
"81877", "丸亀",
"811756", "野辺地",
"8153961", "天竜",
"812993", "石岡",
"818585", "倉吉",
"819787", "国東",
"817737", "舞鶴",
"818376", "美祢",
"811972", "水沢",
"817472", "五条",
"81569", "半田",
"812787", "沼田",
"812892", "宇都宮",
"811873", "角館",
"81984", "小林",
"815764", "下呂",
"819828", "高千穂",
"818592", "米子",
"81284", "足利",
"818838", "阿波池田",
"812693", "中野",
"811555", "帯広",
"818514", "海士",
"818565", "益田",
"811732", "五所川原",
"817455", "大和高田",
"812839", "佐野",
"819938", "加世田",
"81559", "沼津",
"811396", "江差",
"814228", "武蔵野三鷹",
"8199347", "鹿児島",
"812938", "水戸",
"81424", "武蔵野三鷹",
"811955", "二戸",
"812237", "仙台",
"818685", "津山",
"818665", "高梁",
"81864", "倉敷",
"811655", "名寄",
"815956", "上野",
"814285", "相模原",
"815362", "新城",
"818246", "三次",
"818893", "佐川",
"817688", "能都",
"817677", "七尾",
"818692", "邑久",
"817968", "浜坂",
"819593", "大瀬戸",
"815395", "浜松",
"81863", "玉野",
"814701", "鴨川",
"81245", "福島",
"811984", "花巻",
"81262", "長野",
"818654", "鴨方",
"812648", "長野",
"818690", "岡山",
"818369", "宇部",
"81962", "熊本",
"817484", "八日市",
"819434", "八女",
"817908", "播磨山崎",
"818549", "石見大田",
"817464", "吉野",
"819948", "志布志",
"81992", "鹿児島",
"81179", "三戸",
"815999", "津",
"81292", "水戸",
"818954", "宇和島",
"81423", "国分寺",
"81893", "大洲",
"814709", "鴨川",
"812247", "大河原",
"818596", "米子",
"814770", "市川",
"812896", "鹿沼",
"812243", "白石",
"81243", "二本松",
"812618", "大町",
"811645", "留萌",
"81166", "旭川",
"811976", "北上",
"815769", "荘川",
"818372", "長門",
"811945", "久慈",
"81196", "盛岡",
"81425", "立川",
"8198297", "日向",
"817476", "下市",
"8125484", "村上",
"817673", "羽咋",
"812485", "白河",
"811935", "釜石",
"818299", "広島",
"819597", "福江",
"818944", "八幡浜",
"818795", "三本松",
"81740", "今津",
"812859", "小山",
"811752", "むつ",
"818559", "川本",
"811589", "興部",
"81944", "瀬高",
"814772", "市川",
"8112391", "夕張",
"812233", "岩沼",
"819233", "前原",
"812658", "伊那",
"817722", "宮津",
"8188096", "土佐清水",
"81244", "原町",
"812414", "柳津",
"811635", "浜頓別",
"81578", "神岡",
"812697", "飯山",
"8198290", "延岡",
"811354", "余市",
"8199345", "鹿児島",
"811877", "大曲",
"818364", "宇部",
"818493", "尾道",
"811535", "厚岸",
"818384", "萩",
"81281", "宇都宮",
"818240", "東広島",
"811868", "鷹巣",
"812783", "沼田",
"812558", "新井",
"818544", "木次",
"812997", "潮来",
"814704", "館山",
"819558", "唐津",
"814755", "東金",
"817733", "福知山",
"819783", "豊後高田",
"815745", "美濃加茂",
"815994", "阿児",
"81537", "掛川",
"811545", "釧路",
"815952", "上野",
"818242", "東広島",
"815366", "設楽",
"812834", "宇都宮",
"81985", "宮崎",
"815735", "恵那",
"818696", "備前",
"811392", "木古内",
"812373", "村山",
"811736", "五所川原",
"81134", "小樽",
"817717", "園部",
"811365", "倶知安",};
$areanames{en} = {"812614", "Omachi\,\ Nagano",
"81563", "Nishio\,\ Aichi",
"818593", "Yonago\,\ Tottori",
"814291", "Hanno\,\ Saitama",
"812657", "Ina\,\ Nagano",
"812893", "Utsunomiya\,\ Tochigi",
"818360", "Ogori\,\ Yamaguchi",
"819933", "Ibusuki\,\ Kagoshima",
"812246", "Ogawara\,\ Miyagi",
"812933", "Takahagi\,\ Ibaraki",
"812692", "Nakano\,\ Nagano",
"811394", "Matsumae\,\ Hokkaido",
"8125485", "Tsugawa\,\ Niigata",
"819665", "Hitoyoshi\,\ Kumamoto",
"819957", "Kajiki\,\ Kagoshima",
"811973", "Mizusawa\,\ Iwate",
"819965", "Satsumasendai\,\ Kagoshima",
"8112393", "Yubari\,\ Hokkaido",
"814700", "Kamogawa\,\ Chiba",
"819685", "Tamana\,\ Kumamoto",
"811463", "Urakawa\,\ Hokkaido",
"812992", "Ishioka\,\ Ibaraki",
"812832", "Sano\,\ Tochigi",
"818244", "Miyoshi\,\ Hiroshima",
"817683", "Wajima\,\ Ishikawa",
"817963", "Toyooka\,\ Hyogo",
"812475", "Ishikawa\,\ Fukushima",
"812914", "Hokota\,\ Ibaraki",
"81593", "Yokkaichi\,\ Mie",
"814795", "Choshi\,\ Chiba",
"819598", "Fukue\,\ Nagasaki",
"812965", "Shimodate\,\ Ibaraki",
"811235", "Yubari\,\ Hokkaido",
"812957", "Daigo\,\ Ibaraki",
"81294", "Hitachiota\,\ Ibaraki",
"817676", "Nanao\,\ Ishikawa",
"81798", "Nishinomiya\,\ Hyogo",
"814702", "Tateyama\,\ Chiba",
"81766", "Takaoka\,\ Toyama",
"812549", "Tsugawa\,\ Niigata",
"81727", "Ikeda\,\ Osaka",
"812389", "Yonezawa\,\ Yamagata",
"819954", "Kajiki\,\ Kagoshima",
"815992", "Toba\,\ Mie",
"817486", "Minakuchi\,\ Shiga",
"81167", "Furano\,\ Hokkaido",
"818948", "Uwajima\,\ Ehime",
"812830", "Utsunomiya\,\ Tochigi",
"818656", "Kasaoka\,\ Okayama",
"812917", "Mito\,\ Ibaraki",
"811986", "Tono\,\ Iwate",
"818382", "Hagi\,\ Yamaguchi",
"81495", "Honjo\,\ Saitama",
"81892", "Kumakogen\,\ Ehime",
"818247", "Shobara\,\ Hiroshima",
"81825", "Hiroshima\,\ Hiroshima",
"818542", "Yasugi\,\ Shimane",
"81594", "Kuwana\,\ Mie",
"81989", "Naha\,\ Okinawa",
"817903", "Fukusaki\,\ Hyogo",
"8153976", "Hamamatsu\,\ Shizuoka",
"81126", "Iwamizawa\,\ Hokkaido",
"81564", "Okazaki\,\ Aichi",
"81263", "Matsumoto\,\ Nagano",
"815985", "Matsusaka\,\ Mie",
"81845", "Innoshima\,\ Hiroshima",
"818956", "Uwajima\,\ Ehime",
"819943", "Kanoya\,\ Kagoshima",
"818362", "Ube\,\ Yamaguchi",
"812236", "Sendai\,\ Miyagi",
"817712", "Kameoka\,\ Kyoto",
"81465", "Odawara\,\ Kanagawa",
"812654", "Iida\,\ Nagano",
"81862", "Okayama\,\ Okayama",
"811352", "Yoichi\,\ Hokkaido",
"817466", "Totsukawa\,\ Nara",
"81963", "Kumamoto\,\ Kumamoto",
"811397", "Okushiri\,\ Hokkaido",
"817945", "Kakogawa\,\ Hyogo",
"815585", "Shimoda\,\ Shizuoka",
"817718", "Sonobe\,\ Kyoto",
"817724", "Miyazu\,\ Kyoto",
"812856", "Mooka\,\ Tochigi",
"818368", "Ube\,\ Yamaguchi",
"812412", "Kitakata\,\ Fukushima",
"81977", "Beppu\,\ Oita",
"81157", "Kitami\,\ Hokkaido",
"818556", "Gotsu\,\ Shimane",
"819543", "Takeo\,\ Saga",
"812543", "Shibata\,\ Niigata",
"81277", "Kiryu\,\ Gunma",
"8186992", "Bizen\,\ Okayama",
"818843", "Anan\,\ Tokushima",
"812649", "Nagano\,\ Nagano",
"818296", "Hiroshima\,\ Hiroshima",
"812383", "Yonezawa\,\ Yamagata",
"81930", "Yukuhashi\,\ Fukuoka",
"81429", "Tokorozawa\,\ Saitama",
"8198292", "Nobeoka\,\ Miyazaki",
"815998", "Ago\,\ Mie",
"812786", "Numata\,\ Gunma",
"817357", "Kushimoto\,\ Wakayama",
"81734", "Wakayama\,\ Wakayama",
"81899", "Matsuyama\,\ Ehime",
"819554", "Imari\,\ Saga",
"811754", "Mutsu\,\ Aomori",
"812554", "Joetsu\,\ Niigata",
"81852", "Matsue\,\ Shimane",
"81538", "Iwata\,\ Shizuoka",
"819786", "Kitsuki\,\ Oita",
"811586", "Nakayubetsu\,\ Hokkaido",
"817736", "Maizuru\,\ Kyoto",
"818388", "Tamagawa\,\ Yamaguchi",
"81282", "Tochigi\,\ Tochigi",
"81253", "Niigata\,\ Niigata",
"818377", "Shimonoseki\,\ Yamaguchi",
"818942", "Yawatahama\,\ Ehime",
"811375", "Yakumo\,\ Hokkaido",
"811864", "Odate\,\ Akita",
"81554", "Otsuki\,\ Yamanashi",
"818892", "Sakawa\,\ Kochi",
"817354", "Shingu\,\ Fukuoka",
"812998", "Itako\,\ Ibaraki",
"812939", "Mito\,\ Ibaraki",
"815363", "Shinshiro\,\ Aichi",
"819557", "Karatsu\,\ Saga",
"811757", "Noheji\,\ Aomori",
"81174", "Kanita\,\ Aomori",
"81938", "Kitakyushu\,\ Fukuoka",
"8153971", "Hamamatsu\,\ Shizuoka",
"814240", "Kokubunji\,\ Tokyo",
"818374", "Nagato\,\ Yamaguchi",
"811867", "Takanosu\,\ Akita",
"811855", "Noshiro\,\ Akita",
"819592", "Oseto\,\ Nagasaki",
"811336", "Ishikari\,\ Hokkaido",
"812565", "Sanjo\,\ Niigata",
"818693", "Oku\,\ Okayama",
"81582", "Gifu\,\ Gifu",
"812838", "Sano\,\ Tochigi",
"812899", "Kanuma\,\ Tochigi",
"81553", "Yamanashi\,\ Yamanashi",
"817969", "Hamasaka\,\ Hyogo",
"812585", "Nagaoka\,\ Niigata",
"811878", "Omagari\,\ Akita",
"81236", "Yamagata\,\ Yamagata",
"811733", "Goshogawara\,\ Aomori",
"812376", "Sagae\,\ Yamagata",
"819823", "Nobeoka\,\ Miyazaki",
"8126172", "Omachi\,\ Nagano",
"815766", "Gero\,\ Gifu",
"81577", "Takayama\,\ Gifu",
"81936", "Kitakyushu\,\ Fukuoka",
"818833", "Kamojima\,\ Tokushima",
"814777", "Funabashi\,\ Chiba",
"812698", "Iiyama\,\ Nagano",
"818844", "Anan\,\ Tokushima",
"817716", "Sonobe\,\ Kyoto",
"812232", "Iwanuma\,\ Miyagi",
"811356", "Iwanai\,\ Hokkaido",
"818952", "Uwajima\,\ Ehime",
"81438", "Kisarazu\,\ Chiba",
"81555", "Fujiyoshida\,\ Yamanashi",
"818366", "Ube\,\ Yamaguchi",
"812384", "Yonezawa\,\ Yamagata",
"812858", "Mooka\,\ Tochigi",
"812544", "Shibata\,\ Niigata",
"817495", "Nagahama\,\ Shiga",
"811525", "Abashiri\,\ Hokkaido",
"819725", "Saiki\,\ Oita",
"818558", "Kawamoto\,\ Shimane",
"814998", "Ogasawara\,\ Tokyo",
"8125487", "Tsugawa\,\ Niigata",
"819544", "Takeo\,\ Saga",
"814297", "Hanno\,\ Saitama",
"817723", "Miyazu\,\ Kyoto",
"818298", "Hatsukaichi\,\ Hiroshima",
"8126178", "Omachi\,\ Nagano",
"819232", "Maebaru\,\ Fukuoka",
"819827", "Takachiho\,\ Miyazaki",
"817482", "Yokaichi\,\ Shiga",
"819432", "Yame\,\ Fukuoka",
"812659", "Ina\,\ Nagano",
"811863", "Kazuno\,\ Akita",
"815996", "Ago\,\ Mie",
"81549", "Shizuoka\,\ Shizuoka",
"812553", "Joetsu\,\ Niigata",
"812788", "Maebashi\,\ Gunma",
"817672", "Hakui\,\ Ishikawa",
"818697", "Bizen\,\ Okayama",
"8124197", "Yanaizu\,\ Fukushima",
"815367", "Shitara\,\ Aichi",
"819788", "Kunisaki\,\ Oita",
"817738", "Maizuru\,\ Kyoto",
"811588", "Okoppe\,\ Hokkaido",
"819553", "Imari\,\ Saga",
"811753", "Mutsu\,\ Aomori",
"818546", "Kakeya\,\ Shimane",
"812875", "Otawara\,\ Tochigi",
"8126174", "Omachi\,\ Nagano",
"81436", "Ichihara\,\ Chiba",
"818652", "Kurashiki\,\ Okayama",
"811982", "Hanamaki\,\ Iwate",
"812996", "Itako\,\ Ibaraki",
"81878", "Takamatsu\,\ Kagawa",
"818694", "Okayama\,\ Okayama",
"818373", "Nagato\,\ Yamaguchi",
"8183767", "Shimonoseki\,\ Yamaguchi",
"81249", "Koriyama\,\ Fukushima",
"8198298", "Hyuga\,\ Miyazaki",
"812911", "Hokota\,\ Ibaraki",
"812619", "Omachi\,\ Nagano",
"81188", "Akita\,\ Akita",
"81949", "Nogata\,\ Fukuoka",
"8163", "Osaka\,\ Osaka",
"8186994", "Seto\,\ Okayama",
"817353", "Shingu\,\ Fukuoka",
"812836", "Sano\,\ Tochigi",
"812230", "Sendai\,\ Miyagi",
"812547", "Murakami\,\ Niigata",
"818834", "Kamojima\,\ Tokushima",
"812242", "Shiroishi\,\ Miyagi",
"811876", "Omagari\,\ Akita",
"81885", "Komatsushima\,\ Tokushima",
"8198294", "Nobeoka\,\ Miyazaki",
"81482", "Kawaguchi\,\ Saitama",
"81551", "Nirasaki\,\ Yamanashi",
"812378", "Sagae\,\ Yamagata",
"81929", "Fukuoka\,\ Fukuoka",
"812387", "Nagai\,\ Yamagata",
"815768", "Gero\,\ Gifu",
"811734", "Goshogawara\,\ Aomori",
"819824", "Nobeoka\,\ Miyazaki",
"812696", "Iiyama\,\ Nagano",
"815959", "Kameyama\,\ Mie",
"8186998", "Seto\,\ Okayama",
"819547", "Kashima\,\ Saga",
"818249", "Higashi\-ku\,\ Hiroshima",
"812372", "Murayama\,\ Yamagata",
"81823", "Kure\,\ Hiroshima",
"81222", "Sendai\,\ Miyagi",
"8126179", "Omachi\,\ Nagano",
"818205", "Yanai\,\ Yamaguchi",
"818512", "Nishigo\,\ Fukushima",
"812934", "Takahagi\,\ Ibaraki",
"81591", "Tsu\,\ Mie",
"812248", "Ogawara\,\ Miyagi",
"81493", "Higashimatsuyama\,\ Saitama",
"811393", "Matsumae\,\ Hokkaido",
"818290", "Hiroshima\,\ Hiroshima",
"817615", "Komatsu\,\ Ishikawa",
"81489", "Soka\,\ Saitama",
"812894", "Utsunomiya\,\ Tochigi",
"819934", "Ibusuki\,\ Kagoshima",
"81922", "Fukuoka\,\ Fukuoka",
"812613", "Omachi\,\ Nagano",
"819947", "Shibushi\,\ Kagoshima",
"818594", "Yonago\,\ Tottori",
"815762", "Gero\,\ Gifu",
"81965", "Yatsushiro\,\ Kumamoto",
"812913", "Hokota\,\ Ibaraki",
"8125480", "Murakami\,\ Niigata",
"812780", "Maebashi\,\ Gunma",
"81942", "Kurume\,\ Fukuoka",
"818243", "Higashi\-ku\,\ Hiroshima",
"817915", "Aioi\,\ Hyogo",
"81779", "Ono\,\ Gifu",
"817684", "Wajima\,\ Ishikawa",
"817964", "Toyooka\,\ Hyogo",
"818896", "Susaki\,\ Kochi",
"818490", "Onomichi\,\ Hiroshima",
"811464", "Shizunai\,\ Hokkaido",
"811332", "Tobetsu\,\ Hokkaido",
"81561", "Seto\,\ Aichi",
"81242", "Aizuwakamatsu\,\ Fukushima",
"81463", "Hiratsuka\,\ Kanagawa",
"811974", "Mizusawa\,\ Iwate",
"819596", "Fukue\,\ Nagasaki",
"812647", "Nagano\,\ Nagano",
"817678", "Nanao\,\ Ishikawa",
"817687", "Noto\,\ Ishikawa",
"817904", "Fukusaki\,\ Hyogo",
"812551", "Joetsu\,\ Niigata",
"812782", "Numata\,\ Gunma",
"817955", "Sanda\,\ Hyogo",
"817488", "Minakuchi\,\ Shiga",
"819438", "Tanushimaru\,\ Fukuoka",
"811977", "Kitakami\,\ Iwate",
"819953", "Okuchi\,\ Kagoshima",
"818946", "Uwajima\,\ Ehime",
"81542", "Shizuoka\,\ Shizuoka",
"81464", "Atsugi\,\ Kanagawa",
"818975", "Niihama\,\ Ehime",
"817732", "Fukuchiyama\,\ Kyoto",
"819782", "Bungotakada\,\ Oita",
"811582", "Monbetsu\,\ Hokkaido",
"811455", "Mukawa\,\ Hokkaido",
"8198299", "Hyuga\,\ Miyazaki",
"81565", "Toyota\,\ Aichi",
"818552", "Hamada\,\ Shimane",
"812937", "Mito\,\ Ibaraki",
"812416", "Tajima\,\ Fukushima",
"811562", "Honbetsu\,\ Hokkaido",
"814771", "Ichikawa\,\ Chiba",
"8178", "Kobe\,\ Hyogo",
"818958", "Misho\,\ Ehime",
"8186999", "Seto\,\ Okayama",
"812852", "Oyama\,\ Tochigi",
"812795", "Shibukawa\,\ Gunma",
"812238", "Sendai\,\ Miyagi",
"81494", "Chichibu\,\ Saitama",
"818675", "Kuse\,\ Okayama",
"818292", "Hiroshima\,\ Hiroshima",
"819944", "Kanoya\,\ Kagoshima",
"811869", "Odate\,\ Akita",
"817468", "Kamikitayama\,\ Nara",
"8186691", "Kurashiki\,\ Okayama",
"812653", "Iida\,\ Nagano",
"819937", "Kaseda\,\ Kagoshima",
"812897", "Kanuma\,\ Tochigi",
"812559", "Yasuzuka\,\ Niigata",
"817493", "Hikone\,\ Shiga",
"811523", "Shari\,\ Hokkaido",
"819723", "Saiki\,\ Oita",
"8112399", "Kuriyama\,\ Hokkaido",
"819578", "Shimabara\,\ Nagasaki",
"814775", "Funabashi\,\ Chiba",
"81935", "Kitakyushu\,\ Fukuoka",
"8125486", "Tsugawa\,\ Niigata",
"815584", "Shimoda\,\ Shizuoka",
"8188098", "Tosashimizu\,\ Kochi",
"817725", "Miyazu\,\ Kyoto",
"81235", "Tsuruoka\,\ Yamagata",
"81587", "Ichinomiya\,\ Aichi",
"812587", "Nagaoka\,\ Niigata",
"812578", "Muika\,\ Niigata",
"817959", "Sanda\,\ Hyogo",
"81531", "Tahara\,\ Aichi",
"811632", "Teshio\,\ Hokkaido",
"81433", "Chiba\,\ Chiba",
"8165", "Osaka\,\ Osaka",
"812555", "Itoigawa\,\ Niigata",
"811932", "Kamaishi\,\ Iwate",
"812482", "Shirakawa\,\ Fukushima",
"811374", "Mori\,\ Hokkaido",
"812672", "Komoro\,\ Nagano",
"811865", "Odate\,\ Akita",
"81184", "Yurihonjo\,\ Akita",
"811857", "Noshiro\,\ Akita",
"8124196", "Yanaizu\,\ Fukushima",
"819738", "Kusu\,\ Oita",
"812799", "Naganohara\,\ Gunma",
"81572", "Tajimi\,\ Gifu",
"8144", "Kawasaki\,\ Kanagawa",
"818679", "Niimi\,\ Okayama",
"812873", "Otawara\,\ Tochigi",
"814758", "Togane\,\ Chiba",
"819555", "Karatsu\,\ Saga",
"811377", "Yakumo\,\ Hokkaido",
"811854", "Oga\,\ Akita",
"811942", "Iwaizumi\,\ Iwate",
"818375", "Mine\,\ Yamaguchi",
"817996", "Tsuna\,\ Hyogo",
"818807", "Sukumo\,\ Kochi",
"81183", "Yuzawa\,\ Akita",
"811548", "Teshikaga\,\ Hokkaido",
"818586", "Kurayoshi\,\ Tottori",
"8153975", "Hamamatsu\,\ Shizuoka",
"812564", "Sanjo\,\ Niigata",
"8183766", "Shimonoseki\,\ Yamaguchi",
"812748", "Tomioka\,\ Gunma",
"815738", "Nakatsugawa\,\ Gifu",
"817367", "Iwade\,\ Wakayama",
"81272", "Maebashi\,\ Gunma",
"817355", "Shingu\,\ Fukuoka",
"8199343", "Kagoshima\,\ Kagoshima",
"81199", "Morioka\,\ Iwate",
"81987", "Nichinan\,\ Miyazaki",
"817230", "Neyagawa\,\ Osaka",
"812584", "Nagaoka\,\ Niigata",
"81535", "Hamamatsu\,\ Shizuoka",
"81857", "Tottori\,\ Tottori",
"811556", "Obihiro\,\ Hokkaido",
"815972", "Owase\,\ Mie",
"81729", "Yao\,\ Osaka",
"8186697", "Kurashiki\,\ Okayama",
"81434", "Chiba\,\ Chiba",
"817947", "Miki\,\ Hyogo",
"8188099", "Tosashimizu\,\ Kochi",
"811395", "Esashi\,\ Hokkaido",
"818397", "Ogori\,\ Yamaguchi",
"818203", "Yanai\,\ Yamaguchi",
"8182941", "Hiroshima\,\ Hiroshima",
"81722", "Sakai\,\ Osaka",
"817456", "Yamatotakada\,\ Nara",
"819664", "Hitoyoshi\,\ Kumamoto",
"811362", "Kutchan\,\ Hokkaido",
"818686", "Tsuyama\,\ Okayama",
"81466", "Fujisawa\,\ Kanagawa",
"811956", "Iwate\,\ Iwate",
"8112398", "Kuriyama\,\ Hokkaido",
"812615", "Omachi\,\ Nagano",
"817702", "Tsuruga\,\ Fukui",
"81162", "Wakkanai\,\ Hokkaido",
"815978", "Kumano\,\ Mie",
"81828", "Hiroshima\,\ Hiroshima",
"8125481", "Murakami\,\ Niigata",
"818476", "Fuchu\,\ Hiroshima",
"817613", "Komatsu\,\ Ishikawa",
"81427", "Sagamihara\,\ Kanagawa",
"811542", "Kushiro\,\ Hokkaido",
"819742", "Mie\,\ Oita",
"81125", "Takikawa\,\ Hokkaido",
"812474", "Ishikawa\,\ Fukushima",
"814286", "Sagamihara\,\ Kanagawa",
"818245", "Miyoshi\,\ Hiroshima",
"81848", "Onomichi\,\ Hiroshima",
"811234", "Chitose\,\ Hokkaido",
"812964", "Shimodate\,\ Ibaraki",
"811656", "Bifuka\,\ Hokkaido",
"81192", "Ofunato\,\ Iwate",
"814794", "Choshi\,\ Chiba",
"81468", "Yokosuka\,\ Kanagawa",
"818666", "Ibara\,\ Okayama",
"819684", "Yamaga\,\ Kumamoto",
"81979", "Nakatsu\,\ Oita",
"81742", "Nara\,\ Nara",
"8112394", "Yubari\,\ Hokkaido",
"819964", "Satsumasendai\,\ Kagoshima",
"815732", "Ena\,\ Gifu",
"81765", "Uozu\,\ Toyama",
"812742", "Fujioka\,\ Gunma",
"811237", "Kuriyama\,\ Hokkaido",
"818798", "Tonosho\,\ Kagawa",
"812967", "Kasama\,\ Ibaraki",
"819732", "Hita\,\ Oita",
"811532", "Nemuro\,\ Hokkaido",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"814797", "Yokaichiba\,\ Chiba",
"812678", "Saku\,\ Nagano",
"8169", "Osaka\,\ Osaka",
"812488", "Sukagawa\,\ Fukushima",
"811938", "Miyako\,\ Iwate",
"812477", "Miharu\,\ Fukushima",
"817953", "Nishiwaki\,\ Hyogo",
"818463", "Takehara\,\ Hiroshima",
"814752", "Mobara\,\ Chiba",
"811453", "Hayakita\,\ Hokkaido",
"819687", "Tamana\,\ Kumamoto",
"818973", "Niihama\,\ Ehime",
"815742", "Minokamo\,\ Gifu",
"819955", "Kajiki\,\ Kagoshima",
"819967", "Izumi\,\ Kagoshima",
"812879", "Nasukarasuyama\,\ Tochigi",
"819978", "Tokunoshima\,\ Kagoshima",
"819667", "Minamata\,\ Kumamoto",
"812793", "Shibukawa\,\ Gunma",
"819572", "Isahaya\,\ Nagasaki",
"817238", "Neyagawa\,\ Osaka",
"817944", "Kakogawa\,\ Hyogo",
"818263", "Kake\,\ Hiroshima",
"815984", "Matsusaka\,\ Mie",
"812572", "Kashiwazaki\,\ Niigata",
"812655", "Iida\,\ Nagano",
"81460", "Odawara\,\ Kanagawa",
"8166", "Osaka\,\ Osaka",
"818872", "Muroto\,\ Kochi",
"81764", "Toyama\,\ Toyama",
"817614", "Komatsu\,\ Ishikawa",
"812895", "Utsunomiya\,\ Tochigi",
"819935", "Kaseda\,\ Kagoshima",
"818595", "Yonago\,\ Tottori",
"818688", "Mimasaka\,\ Okayama",
"818677", "Niimi\,\ Okayama",
"811958", "Iwate\,\ Iwate",
"811646", "Haboro\,\ Hokkaido",
"819663", "Hitoyoshi\,\ Kumamoto",
"812797", "Shibukawa\,\ Gunma",
"81547", "Shimada\,\ Shizuoka",
"811552", "Obihiro\,\ Hokkaido",
"812935", "Mito\,\ Ibaraki",
"81124", "Ashibetsu\,\ Hokkaido",
"81568", "Kasugai\,\ Aichi",
"81596", "Ise\,\ Mie",
"818562", "Masuda\,\ Shimane",
"818478", "Tojo\,\ Hiroshima",
"818204", "Yanai\,\ Yamaguchi",
"818467", "Mima\,\ Tokushima",
"818582", "Kurayoshi\,\ Tottori",
"81566", "Kariya\,\ Aichi",
"814288", "Ome\,\ Tokyo",
"81144", "Tomakomai\,\ Hokkaido",
"811465", "Shizunai\,\ Hokkaido",
"81260", "Anan\,\ Nagano",
"819683", "Yamaga\,\ Kumamoto",
"818977", "Hakata\,\ Ehime",
"811658", "Kamikawa\,\ Hokkaido",
"817992", "Sumoto\,\ Hyogo",
"811946", "Kuji\,\ Iwate",
"811975", "Mizusawa\,\ Iwate",
"819963", "Satsumasendai\,\ Kagoshima",
"818668", "Ibara\,\ Okayama",
"812963", "Shimodate\,\ Ibaraki",
"811233", "Chitose\,\ Hokkaido",
"817475", "Shimonoseki\,\ Yamaguchi",
"814793", "Choshi\,\ Chiba",
"815398", "Hamamatsu\,\ Shizuoka",
"817965", "Toyooka\,\ Hyogo",
"812473", "Ishikawa\,\ Fukushima",
"81839", "Yamaguchi\,\ Yamaguchi",
"817914", "Aioi\,\ Hyogo",
"817685", "Wajima\,\ Ishikawa",
"812589", "Nagaoka\,\ Niigata",
"81266", "Suwa\,\ Nagano",
"818796", "Tonosho\,\ Kagawa",
"818974", "Niihama\,\ Ehime",
"812676", "Saku\,\ Nagano",
"81143", "Muroran\,\ Hokkaido",
"81298", "Tsuchiura\,\ Ibaraki",
"818464", "Takehara\,\ Hiroshima",
"812486", "Sukagawa\,\ Fukushima",
"811936", "Miyako\,\ Iwate",
"811454", "Mukawa\,\ Hokkaido",
"81227", "Sendai\,\ Miyagi",
"817905", "Fukusaki\,\ Hyogo",
"81927", "Fukuoka\,\ Fukuoka",
"817954", "Nishiwaki\,\ Hyogo",
"8153969", "Hamamatsu\,\ Shizuoka",
"81793", "Himeji\,\ Hyogo",
"81998", "Kagoshima\,\ Kagoshima",
"819676", "Takamori\,\ Kumamoto",
"81763", "Fukuno\,\ Toyama",
"819976", "Naze\,\ Kagoshima",
"819802", "Minamidaito\,\ Okinawa",
"815752", "Sekigahara\,\ Gifu",
"819945", "Kanoya\,\ Kagoshima",
"815983", "Matsusaka\,\ Mie",
"81947", "Tagawa\,\ Fukuoka",
"817617", "Kaga\,\ Ishikawa",
"817943", "Kakogawa\,\ Hyogo",
"818674", "Kuse\,\ Okayama",
"81268", "Ueda\,\ Nagano",
"812794", "Shibukawa\,\ Gunma",
"8112392", "Yubari\,\ Hokkaido",
"81176", "Towada\,\ Aomori",
"81956", "Sasebo\,\ Nagasaki",
"81875", "Kan\'onji\,\ Kagawa",
"819576", "Shimabara\,\ Nagasaki",
"815583", "Shimoda\,\ Shizuoka",
"819808", "Yaeyama\ District\,\ Okinawa",
"81550", "Gotenba\,\ Shizuoka",
"812385", "Yonezawa\,\ Yamagata",
"81886", "Tokushima\,\ Tokushima",
"8128798", "Otawara\,\ Tochigi",
"817494", "Hikone\,\ Shiga",
"818391", "Ogori\,\ Yamaguchi",
"812576", "Tokamachi\,\ Niigata",
"811524", "Abashiri\,\ Hokkaido",
"819724", "Saiki\,\ Oita",
"812545", "Murakami\,\ Niigata",
"818680", "Okayama\,\ Okayama",
"818660", "Seto\,\ Okayama",
"817949", "Kakogawa\,\ Hyogo",
"814280", "Tachikawa\,\ Tokyo",
"81533", "Toyohashi\,\ Aichi",
"81888", "Kochi\,\ Kochi",
"8126173", "Omachi\,\ Nagano",
"812874", "Otawara\,\ Tochigi",
"81487", "Urawa\,\ Saitama",
"81234", "Sakata\,\ Yamagata",
"811536", "Akkeshi\,\ Hokkaido",
"81934", "Kitakyushu\,\ Fukuoka",
"815746", "Minokamo\,\ Gifu",
"814756", "Togane\,\ Chiba",
"8152", "Nagoya\,\ Aichi",
"81178", "Hachinohe\,\ Aomori",
"81958", "Nagasaki\,\ Nagasaki",
"8153968", "Hamamatsu\,\ Shizuoka",
"818662", "Takahashi\,\ Okayama",
"812877", "Kuroiso\,\ Tochigi",
"811652", "Shibetsu\,\ Hokkaido",
"817998", "Tsuna\,\ Hyogo",
"81832", "Shimonoseki\,\ Yamaguchi",
"814282", "Ome\,\ Tokyo",
"81534", "Hamamatsu\,\ Shizuoka",
"81233", "Shinjo\,\ Yamagata",
"811546", "Kushiro\,\ Hokkaido",
"819746", "Taketa\,\ Oita",
"818588", "Koge\,\ Tottori",
"8186993", "Bizen\,\ Okayama",
"818695", "Seto\,\ Okayama",
"812746", "Tomioka\,\ Gunma",
"81738", "Gobo\,\ Wakayama",
"81933", "Kitakyushu\,\ Fukuoka",
"815736", "Nakatsugawa\,\ Gifu",
"812563", "Sanjo\,\ Niigata",
"811853", "Oga\,\ Akita",
"815392", "Hamamatsu\,\ Shizuoka",
"817452", "Yamatotakada\,\ Nara",
"811735", "Goshogawara\,\ Aomori",
"819825", "Hyuga\,\ Miyazaki",
"8153964", "Hamamatsu\,\ Shizuoka",
"812583", "Nagaoka\,\ Niigata",
"81950", "Hirado\,\ Nagasaki",
"818568", "Tsuwano\,\ Shimane",
"817497", "Nagahama\,\ Shiga",
"811527", "Bihoro\,\ Hokkaido",
"819727", "Usuki\,\ Oita",
"8153970", "Hamamatsu\,\ Shizuoka",
"811558", "Hiroo\,\ Hokkaido",
"818835", "Mima\,\ Tokushima",
"81250", "Niitsu\,\ Niigata",
"817706", "Obama\,\ Fukui",
"818682", "Tsuyama\,\ Okayama",
"8198293", "Nobeoka\,\ Miyazaki",
"811366", "Suttsu\,\ Hokkaido",
"811952", "Ninohe\,\ Iwate",
"8198296", "Hyuga\,\ Miyazaki",
"81946", "Amagi\,\ Fukuoka",
"81928", "Fukuoka\,\ Fukuoka",
"811541", "Teshikaga\,\ Hokkaido",
"81723", "Sakai\,\ Osaka",
"8161", "Osaka\,\ Osaka",
"815394", "Hamamatsu\,\ Shizuoka",
"819966", "Izumi\,\ Kagoshima",
"811943", "Iwaizumi\,\ Iwate",
"819686", "Tamana\,\ Kumamoto",
"818664", "Takahashi\,\ Okayama",
"814796", "Yokaichiba\,\ Chiba",
"811654", "Nayoro\,\ Hokkaido",
"811236", "Chitose\,\ Hokkaido",
"81246", "Iwaki\,\ Fukushima",
"814284", "Tachikawa\,\ Tokyo",
"812476", "Miharu\,\ Fukushima",
"818474", "Fuchu\,\ Hiroshima",
"812245", "Ogawara\,\ Miyagi",
"81226", "Kesennuma\,\ Miyagi",
"8186698", "Kurashiki\,\ Okayama",
"811954", "Ninohe\,\ Iwate",
"818684", "Tsuyama\,\ Okayama",
"819666", "Minamata\,\ Kumamoto",
"817454", "Yamatotakada\,\ Nara",
"8186996", "Seto\,\ Okayama",
"81926", "Fukuoka\,\ Fukuoka",
"81743", "Nara\,\ Nara",
"81948", "Iizuka\,\ Fukuoka",
"817618", "Kaga\,\ Ishikawa",
"811549", "Kushiro\,\ Hokkaido",
"815973", "Owase\,\ Mie",
"812798", "Naganohara\,\ Gunma",
"818955", "Uwajima\,\ Ehime",
"81548", "Haibara\,\ Shizuoka",
"818678", "Niimi\,\ Okayama",
"811957", "Iwate\,\ Iwate",
"8188097", "Tosashimizu\,\ Kochi",
"818687", "Mimasaka\,\ Okayama",
"812235", "Sendai\,\ Miyagi",
"819722", "Saiki\,\ Oita",
"811522", "Shari\,\ Hokkaido",
"817492", "Hikone\,\ Shiga",
"818477", "Tojo\,\ Hiroshima",
"815986", "Matsusaka\,\ Mie",
"81567", "Tsushima\,\ Aichi",
"812571", "Muika\,\ Niigata",
"817946", "Miki\,\ Hyogo",
"8126176", "Omachi\,\ Nagano",
"817465", "Yoshino\,\ Nara",
"81744", "Yamatotakada\,\ Nara",
"817457", "Yamatotakada\,\ Nara",
"818879", "Muroto\,\ Kochi",
"812673", "Komoro\,\ Nagano",
"817485", "Yokaichi\,\ Shiga",
"819435", "Yame\,\ Fukuoka",
"817675", "Nanao\,\ Ishikawa",
"811933", "Kamaishi\,\ Iwate",
"81439", "Kisarazu\,\ Chiba",
"81940", "Munakata\,\ Fukuoka",
"812483", "Shirakawa\,\ Fukushima",
"814287", "Ome\,\ Tokyo",
"8112390", "Yubari\,\ Hokkaido",
"818667", "Ibara\,\ Okayama",
"818655", "Kamogata\,\ Okayama",
"818978", "Hakata\,\ Ehime",
"81546", "Shizuoka\,\ Shizuoka",
"812872", "Otawara\,\ Tochigi",
"817952", "Nishiwaki\,\ Hyogo",
"812785", "Numata\,\ Gunma",
"817366", "Iwade\,\ Wakayama",
"81737", "Yuasa\,\ Wakayama",
"819733", "Hita\,\ Oita",
"811533", "Nemuro\,\ Hokkaido",
"817997", "Tsuna\,\ Hyogo",
"81557", "Ito\,\ Shizuoka",
"818972", "Niihama\,\ Ehime",
"818806", "Sukumo\,\ Kochi",
"815743", "Minokamo\,\ Gifu",
"8198291", "Nobeoka\,\ Miyazaki",
"812878", "Nasukarasuyama\,\ Tochigi",
"819979", "Tokunoshima\,\ Kagoshima",
"815566", "Minobu\,\ Yamanashi",
"81432", "Chiba\,\ Chiba",
"81835", "Hofu\,\ Yamaguchi",
"811376", "Yakumo\,\ Hokkaido",
"817239", "Neyagawa\,\ Osaka",
"818587", "Koge\,\ Tottori",
"8153965", "Hamamatsu\,\ Shizuoka",
"818462", "Takehara\,\ Hiroshima",
"811585", "Engaru\,\ Hokkaido",
"819785", "Bungotakada\,\ Oita",
"817735", "Fukuchiyama\,\ Kyoto",
"811452", "Hayakita\,\ Hokkaido",
"814753", "Mobara\,\ Chiba",
"8199331", "Kagoshima\,\ Kagoshima",
"819573", "Isahaya\,\ Nagasaki",
"811528", "Bihoro\,\ Hokkaido",
"819728", "Usuki\,\ Oita",
"818555", "Gotsu\,\ Shimane",
"818262", "Kake\,\ Hiroshima",
"818567", "Tsuwano\,\ Shimane",
"817498", "Nagahama\,\ Shiga",
"8168", "Osaka\,\ Osaka",
"815586", "Shimoda\,\ Shizuoka",
"819679", "Takamori\,\ Kumamoto",
"81138", "Hakodate\,\ Hokkaido",
"812855", "Oyama\,\ Tochigi",
"812792", "Shibukawa\,\ Gunma",
"81480", "Kuki\,\ Saitama",
"815754", "Sekigahara\,\ Gifu",
"819804", "Nago\,\ Okinawa",
"812679", "Saku\,\ Nagano",
"818873", "Aki\,\ Kochi",
"818295", "Hatsukaichi\,\ Hiroshima",
"812489", "Sukagawa\,\ Fukushima",
"81471", "Kashiwa\,\ Chiba",
"811939", "Miyako\,\ Iwate",
"812573", "Kashiwazaki\,\ Niigata",
"8112397", "Kuriyama\,\ Hokkaido",
"81778", "Takefu\,\ Fukui",
"81182", "Yokote\,\ Akita",
"8126171", "Omachi\,\ Nagano",
"81486", "Urawa\,\ Saitama",
"812375", "Murayama\,\ Yamagata",
"811554", "Obihiro\,\ Hokkaido",
"818202", "Yanai\,\ Yamaguchi",
"812586", "Nagaoka\,\ Niigata",
"818564", "Masuda\,\ Shimane",
"817612", "Komatsu\,\ Ishikawa",
"815765", "Gero\,\ Gifu",
"811363", "Kutchan\,\ Hokkaido",
"817703", "Tsuruga\,\ Fukui",
"81273", "Takasaki\,\ Gunma",
"817950", "Sanda\,\ Hyogo",
"8186552", "Kurashiki\,\ Okayama",
"815979", "Kumano\,\ Mie",
"819743", "Mie\,\ Oita",
"811543", "Kushiro\,\ Hokkaido",
"81177", "Aomori\,\ Aomori",
"817912", "Aioi\,\ Hyogo",
"812566", "Sanjo\,\ Niigata",
"818584", "Kurayoshi\,\ Tottori",
"815733", "Ena\,\ Gifu",
"812743", "Fujioka\,\ Gunma",
"817994", "Sumoto\,\ Hyogo",
"8153972", "Hamamatsu\,\ Shizuoka",
"81488", "Urawa\,\ Saitama",
"811856", "Noshiro\,\ Akita",
"81776", "Fukui\,\ Fukui",
"815737", "Nakatsugawa\,\ Gifu",
"817368", "Iwade\,\ Wakayama",
"812747", "Tomioka\,\ Gunma",
"814705", "Tateyama\,\ Chiba",
"814754", "Mobara\,\ Chiba",
"815744", "Minokamo\,\ Gifu",
"81986", "Miyakonojo\,\ Miyazaki",
"815995", "Ago\,\ Mie",
"81473", "Ichikawa\,\ Chiba",
"811534", "Nakashibetsu\,\ Hokkaido",
"819734", "Hita\,\ Oita",
"818808", "Tosashimizu\,\ Kochi",
"812876", "Kuroiso\,\ Tochigi",
"818385", "Hagi\,\ Yamaguchi",
"8153978", "Hamamatsu\,\ Shizuoka",
"81286", "Utsunomiya\,\ Tochigi",
"811378", "Imakane\,\ Hokkaido",
"81975", "Oita\,\ Oita",
"811547", "Shiranuka\,\ Hokkaido",
"819747", "Taketa\,\ Oita",
"818545", "Kisuki\,\ Shimane",
"815982", "Matsusaka\,\ Mie",
"81532", "Toyohashi\,\ Aichi",
"811526", "Abashiri\,\ Hokkaido",
"819726", "Usuki\,\ Oita",
"812574", "Kashiwazaki\,\ Niigata",
"817496", "Nagahama\,\ Shiga",
"819803", "Nago\,\ Okinawa",
"81288", "Imabari\,\ Ehime",
"815753", "Sekigahara\,\ Gifu",
"817715", "Kameoka\,\ Kyoto",
"811367", "Suttsu\,\ Hokkaido",
"818365", "Ube\,\ Yamaguchi",
"818874", "Aki\,\ Kochi",
"81834", "Tokuyama\,\ Yamaguchi",
"817707", "Obama\,\ Fukui",
"81988", "Naha\,\ Okinawa",
"817942", "Kakogawa\,\ Hyogo",
"819574", "Isahaya\,\ Nagasaki",
"811364", "Kutchan\,\ Hokkaido",
"811875", "Kakunodate\,\ Akita",
"817704", "Tsuruga\,\ Fukui",
"812577", "Muika\,\ Niigata",
"81833", "Kudamatsu\,\ Yamaguchi",
"8188095", "Tosashimizu\,\ Kochi",
"812588", "Nagaoka\,\ Niigata",
"812695", "Nakano\,\ Nagano",
"811553", "Obihiro\,\ Hokkaido",
"819577", "Shimabara\,\ Nagasaki",
"814289", "Ome\,\ Tokyo",
"818563", "Masuda\,\ Shimane",
"81932", "Kitakyushu\,\ Fukuoka",
"817940", "Kakogawa\,\ Hyogo",
"819662", "Hitoyoshi\,\ Kumamoto",
"818669", "Soja\,\ Okayama",
"817993", "Sumoto\,\ Hyogo",
"818689", "Okayama\,\ Okayama",
"819682", "Yamaga\,\ Kumamoto",
"819962", "Satsumasendai\,\ Kagoshima",
"818583", "Kurayoshi\,\ Tottori",
"812995", "Ishioka\,\ Ibaraki",
"815734", "Ena\,\ Gifu",
"818479", "Tojo\,\ Hiroshima",
"812744", "Fujioka\,\ Gunma",
"81474", "Funabashi\,\ Chiba",
"814281", "Sagamihara\,\ Kanagawa",
"814757", "Togane\,\ Chiba",
"812472", "Ishikawa\,\ Fukushima",
"811544", "Kushiro\,\ Hokkaido",
"819744", "Mie\,\ Oita",
"81586", "Ichinomiya\,\ Aichi",
"812835", "Sano\,\ Tochigi",
"811537", "Nakashibetsu\,\ Hokkaido",
"819737", "Kusu\,\ Oita",
"811232", "Chitose\,\ Hokkaido",
"812962", "Shimodate\,\ Ibaraki",
"811858", "Noshiro\,\ Akita",
"814792", "Choshi\,\ Chiba",
"81280", "Koga\,\ Ibaraki",
"8153979", "Hamamatsu\,\ Shizuoka",
"814283", "Ome\,\ Tokyo",
"811559", "Obihiro\,\ Hokkaido",
"818895", "Susaki\,\ Kochi",
"819968", "Izumi\,\ Kagoshima",
"818663", "Soja\,\ Okayama",
"811653", "Shibetsu\,\ Hokkaido",
"819688", "Tamana\,\ Kumamoto",
"8153967", "Hamamatsu\,\ Shizuoka",
"811852", "Oga\,\ Akita",
"815393", "Hamamatsu\,\ Shizuoka",
"812677", "Saku\,\ Nagano",
"814798", "Yokaichiba\,\ Chiba",
"81191", "Ichinoseki\,\ Iwate",
"811944", "Iwaizumi\,\ Iwate",
"812968", "Kasama\,\ Ibaraki",
"818797", "Tonosho\,\ Kagawa",
"811238", "Kuriyama\,\ Hokkaido",
"8162", "Osaka\,\ Osaka",
"81420", "Tokorozawa\,\ Saitama",
"812478", "Miharu\,\ Fukushima",
"812562", "Sanjo\,\ Niigata",
"812487", "Sukagawa\,\ Fukushima",
"811937", "Miyako\,\ Iwate",
"818206", "Yanai\,\ Yamaguchi",
"812582", "Nagaoka\,\ Niigata",
"81939", "Kitakyushu\,\ Fukuoka",
"815974", "Owase\,\ Mie",
"8164", "Osaka\,\ Osaka",
"817453", "Yamatotakada\,\ Nara",
"811644", "Rumoi\,\ Hokkaido",
"819668", "Minamata\,\ Kumamoto",
"81721", "Tondabayashi\,\ Osaka",
"811953", "Ninohe\,\ Iwate",
"819977", "Setouchi\,\ Kagoshima",
"813", "Tokyo",
"818683", "Tsuyama\,\ Okayama",
"8145", "Yokohama\,\ Kanagawa",
"817616", "Komatsu\,\ Ishikawa",
"812796", "Shibukawa\,\ Gunma",
"812580", "Tokamachi\,\ Niigata",
"818676", "Kuse\,\ Okayama",
"811647", "Haboro\,\ Hokkaido",
"815582", "Shimoda\,\ Shizuoka",
"81898", "Imabari\,\ Ehime",
"8112395", "Kuriyama\,\ Hokkaido",
"81827", "Iwakuni\,\ Yamaguchi",
"812415", "Yanaizu\,\ Fukushima",
"81142", "Date\,\ Hokkaido",
"811634", "Hamatonbetsu\,\ Hokkaido",
"815977", "Kumano\,\ Mie",
"818398", "Ogori\,\ Yamaguchi",
"81792", "Himeji\,\ Hyogo",
"817948", "Miki\,\ Hyogo",
"819974", "Yakushima\,\ Kagoshima",
"81725", "Izumi\,\ Osaka",
"8182943", "Hiroshima\,\ Hiroshima",
"81762", "Kanazawa\,\ Ishikawa",
"817956", "Sanda\,\ Hyogo",
"8125483", "Murakami\,\ Niigata",
"81426", "Hachioji\,\ Tokyo",
"811934", "Kamaishi\,\ Iwate",
"818466", "Mima\,\ Tokushima",
"812484", "Shirakawa\,\ Fukushima",
"81467", "Fujisawa\,\ Kanagawa",
"81896", "Iyomishima\,\ Ehime",
"811372", "Shikabe\,\ Hokkaido",
"818945", "Yawatahama\,\ Ehime",
"812674", "Komoro\,\ Nagano",
"812560", "Itoigawa\,\ Niigata",
"818976", "Niihama\,\ Ehime",
"811947", "Kuji\,\ Iwate",
"819809", "Yaeyama\ District\,\ Okinawa",
"815993", "Toba\,\ Mie",
"81775", "Otsu\,\ Shiga",
"811866", "Takanosu\,\ Akita",
"814703", "Tateyama\,\ Chiba",
"81969", "Amakusa\,\ Kumamoto",
"819784", "Bungotakada\,\ Oita",
"817734", "Fukuchiyama\,\ Kyoto",
"811584", "Engaru\,\ Hokkaido",
"811337", "Ishikari\,\ Hokkaido",
"812556", "Itoigawa\,\ Niigata",
"818543", "Yasugi\,\ Shimane",
"819556", "Karatsu\,\ Saga",
"811756", "Noheji\,\ Aomori",
"81877", "Marugame\,\ Kagawa",
"812784", "Numata\,\ Gunma",
"812419", "Tajima\,\ Fukushima",
"8198295", "Hyuga\,\ Miyazaki",
"8147955", "Yokaichiba\,\ Chiba",
"81478", "Sawara\,\ Chiba",
"817902", "Fukusaki\,\ Hyogo",
"818383", "Hagi\,\ Yamaguchi",
"818363", "Ube\,\ Yamaguchi",
"812890", "Utsunomiya\,\ Tochigi",
"818949", "Uwajima\,\ Ehime",
"818294", "Hatsukaichi\,\ Hiroshima",
"8186995", "Seto\,\ Okayama",
"819805", "Nago\,\ Okinawa",
"811353", "Yoichi\,\ Hokkaido",
"815755", "Sekigahara\,\ Gifu",
"817713", "Kameoka\,\ Kyoto",
"815767", "Gero\,\ Gifu",
"81476", "Narita\,\ Chiba",
"81983", "Takanabe\,\ Miyazaki",
"814776", "Funabashi\,\ Chiba",
"81952", "Saga\,\ Saga",
"81172", "Hirosaki\,\ Aomori",
"81252", "Niigata\,\ Niigata",
"818554", "Hamada\,\ Shimane",
"81584", "Ogaki\,\ Gifu",
"811564", "Kamishihoro\,\ Hokkaido",
"8111", "Sapporo\,\ Hokkaido",
"812854", "Oyama\,\ Tochigi",
"812388", "Nagai\,\ Yamagata",
"814220", "Kokubunji\,\ Tokyo",
"81853", "Izumo\,\ Shimane",
"812377", "Sagae\,\ Yamagata",
"81485", "Kumagaya\,\ Saitama",
"812930", "Mito\,\ Ibaraki",
"812892", "Utsunomiya\,\ Tochigi",
"819932", "Ibusuki\,\ Kagoshima",
"819940", "Shibushi\,\ Kagoshima",
"8167", "Osaka\,\ Osaka",
"8126175", "Omachi\,\ Nagano",
"818592", "Yonago\,\ Tottori",
"819828", "Takachiho\,\ Miyazaki",
"818297", "Hatsukaichi\,\ Hiroshima",
"819599", "Oseto\,\ Nagasaki",
"814298", "Hanno\,\ Saitama",
"81984", "Kobayashi\,\ Miyazaki",
"815764", "Gero\,\ Gifu",
"811873", "Kakunodate\,\ Akita",
"812857", "Mooka\,\ Tochigi",
"81284", "Ashikaga\,\ Tochigi",
"812374", "Murayama\,\ Yamagata",
"81552", "Kofu\,\ Yamanashi",
"81583", "Gifu\,\ Gifu",
"818557", "Kawamoto\,\ Shimane",
"818565", "Masuda\,\ Shimane",
"812693", "Nakano\,\ Nagano",
"818514", "Ama\,\ Shimane",
"811555", "Obihiro\,\ Hokkaido",
"812932", "Takahagi\,\ Ibaraki",
"811462", "Urakawa\,\ Hokkaido",
"8182920", "Hatsukaichi\,\ Hiroshima",
"817737", "Maizuru\,\ Kyoto",
"819787", "Kunisaki\,\ Oita",
"815368", "Shitara\,\ Aichi",
"811587", "Nakayubetsu\,\ Hokkaido",
"812993", "Ishioka\,\ Ibaraki",
"818585", "Kurayoshi\,\ Tottori",
"812640", "Nagano\,\ Nagano",
"811972", "Mizusawa\,\ Iwate",
"817995", "Sumoto\,\ Hyogo",
"818376", "Mine\,\ Yamaguchi",
"81569", "Handa\,\ Aichi",
"817682", "Wajima\,\ Ishikawa",
"812833", "Utsunomiya\,\ Tochigi",
"818698", "Bizen\,\ Okayama",
"812787", "Numata\,\ Gunma",
"817356", "Kushimoto\,\ Wakayama",
"817962", "Toyooka\,\ Hyogo",
"811655", "Nayoro\,\ Hokkaido",
"81545", "Fuji\,\ Shizuoka",
"818665", "Takahashi\,\ Okayama",
"811987", "Tono\,\ Iwate",
"811978", "Kitakami\,\ Iwate",
"818657", "Kasaoka\,\ Okayama",
"81864", "Kurashiki\,\ Okayama",
"818893", "Sakawa\,\ Kochi",
"8153966", "Hamamatsu\,\ Shizuoka",
"818246", "Miyoshi\,\ Hiroshima",
"815362", "Shinshiro\,\ Aichi",
"814285", "Sagamihara\,\ Kanagawa",
"817968", "Hamasaka\,\ Hyogo",
"817688", "Noto\,\ Ishikawa",
"818692", "Oku\,\ Okayama",
"817677", "Nanao\,\ Ishikawa",
"819437", "Tanushimaru\,\ Fukuoka",
"817487", "Minakuchi\,\ Shiga",
"819593", "Oseto\,\ Nagasaki",
"815395", "Hamamatsu\,\ Shizuoka",
"819822", "Nobeoka\,\ Miyazaki",
"817455", "Yamatotakada\,\ Nara",
"811732", "Goshogawara\,\ Aomori",
"811396", "Esashi\,\ Hokkaido",
"819938", "Kaseda\,\ Kagoshima",
"812839", "Sano\,\ Tochigi",
"812898", "Kanuma\,\ Tochigi",
"8125482", "Murakami\,\ Niigata",
"81559", "Numazu\,\ Shizuoka",
"818832", "Kamojima\,\ Tokushima",
"812244", "Shiroishi\,\ Miyagi",
"81592", "Tsu\,\ Mie",
"812999", "Itako\,\ Ibaraki",
"812938", "Mito\,\ Ibaraki",
"8199347", "Kagoshima\,\ Kagoshima",
"818475", "Fuchu\,\ Hiroshima",
"811955", "Ninohe\,\ Iwate",
"81739", "Tanabe\,\ Wakayama",
"8182942", "Hiroshima\,\ Hiroshima",
"818685", "Tsuyama\,\ Okayama",
"812237", "Sendai\,\ Miyagi",
"812616", "Omachi\,\ Nagano",
"818957", "Misho\,\ Ehime",
"812413", "Kitakata\,\ Fukushima",
"819542", "Takeo\,\ Saga",
"81925", "Fukuoka\,\ Fukuoka",
"81992", "Kagoshima\,\ Kagoshima",
"81259", "Sado\,\ Niigata",
"817464", "Yoshino\,\ Nara",
"819948", "Shibushi\,\ Kagoshima",
"81423", "Kokubunji\,\ Tokyo",
"812656", "Ina\,\ Nagano",
"818842", "Anan\,\ Tokushima",
"812234", "Sendai\,\ Miyagi",
"81179", "Sannohe\,\ Aomori",
"812382", "Yonezawa\,\ Yamagata",
"818954", "Uwajima\,\ Ehime",
"81292", "Mito\,\ Ibaraki",
"815999", "Tsu\,\ Mie",
"812247", "Ogawara\,\ Miyagi",
"81225", "Ishinomaki\,\ Miyagi",
"812542", "Shibata\,\ Niigata",
"81893", "Ozu\,\ Ehime",
"814709", "Kamogawa\,\ Chiba",
"814701", "Kamogawa\,\ Chiba",
"81863", "Tamano\,\ Okayama",
"81245", "Fukushima\,\ Fukushima",
"812648", "Nagano\,\ Nagano",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"811984", "Hanamaki\,\ Iwate",
"81262", "Nagano\,\ Nagano",
"818654", "Kamogata\,\ Okayama",
"81962", "Kumamoto\,\ Kumamoto",
"817484", "Yokaichi\,\ Shiga",
"819434", "Yame\,\ Fukuoka",
"818943", "Yawatahama\,\ Ehime",
"819956", "Kajiki\,\ Kagoshima",
"818369", "Ube\,\ Yamaguchi",
"818690", "Okayama\,\ Okayama",
"817674", "Hakui\,\ Ishikawa",
"818372", "Nagato\,\ Yamaguchi",
"811945", "Kuji\,\ Iwate",
"815769", "Shokawa\,\ Gifu",
"81196", "Morioka\,\ Iwate",
"812550", "Yasuzuka\,\ Niigata",
"81492", "Kawagoe\,\ Saitama",
"811976", "Kitakami\,\ Iwate",
"818947", "Uwajima\,\ Ehime",
"81822", "Hiroshima\,\ Hiroshima",
"81425", "Tachikawa\,\ Tokyo",
"815958", "Kameyama\,\ Mie",
"811466", "Erimo\,\ Hokkaido",
"818248", "Shobara\,\ Hiroshima",
"817352", "Shingu\,\ Fukuoka",
"818894", "Susaki\,\ Kochi",
"817686", "Noto\,\ Ishikawa",
"81797", "Nishinomiya\,\ Hyogo",
"8183768", "Shimonoseki\,\ Yamaguchi",
"817476", "Shimonoseki\,\ Yamaguchi",
"81728", "Neyagawa\,\ Osaka",
"81923", "Fukuoka\,\ Fukuoka",
"8147957", "Yokaichiba\,\ Chiba",
"8198297", "Hyuga\,\ Miyazaki",
"814770", "Ichikawa\,\ Chiba",
"81726", "Ibaraki\,\ Osaka",
"818596", "Yonago\,\ Tottori",
"811398", "Kumaishi\,\ Hokkaido",
"812243", "Shiroishi\,\ Miyagi",
"819936", "Kaseda\,\ Kagoshima",
"8186997", "Seto\,\ Okayama",
"812896", "Kanuma\,\ Tochigi",
"812936", "Mito\,\ Ibaraki",
"811645", "Rumoi\,\ Hokkaido",
"81544", "Fujinomiya\,\ Shizuoka",
"81166", "Asahikawa\,\ Hokkaido",
"81243", "Nihonmatsu\,\ Fukushima",
"81462", "Atsugi\,\ Kanagawa",
"812618", "Omachi\,\ Nagano",
"814772", "Ichikawa\,\ Chiba",
"81944", "Setaka\,\ Fukuoka",
"8125488", "Tsugawa\,\ Niigata",
"811589", "Okoppe\,\ Hokkaido",
"819789", "Kitsuki\,\ Oita",
"819975", "Naze\,\ Kagoshima",
"812233", "Iwanuma\,\ Miyagi",
"8112391", "Yubari\,\ Hokkaido",
"818953", "Uwajima\,\ Ehime",
"819946", "Kanoya\,\ Kagoshima",
"812658", "Ina\,\ Nagano",
"817722", "Miyazu\,\ Kyoto",
"819233", "Maebaru\,\ Fukuoka",
"817463", "Yoshino\,\ Nara",
"81543", "Shizuoka\,\ Shizuoka",
"812414", "Yanaizu\,\ Fukushima",
"812789", "Maebashi\,\ Gunma",
"811635", "Hamatonbetsu\,\ Hokkaido",
"8188096", "Tosashimizu\,\ Kochi",
"81244", "Hobara\,\ Fukushima",
"8175", "Kyoto\,\ Kyoto",
"812552", "Joetsu\,\ Niigata",
"811935", "Kamaishi\,\ Iwate",
"812485", "Shirakawa\,\ Fukushima",
"8125484", "Murakami\,\ Niigata",
"817673", "Hakui\,\ Ishikawa",
"812646", "Nagano\,\ Nagano",
"817483", "Yokaichi\,\ Shiga",
"819433", "Yame\,\ Fukuoka",
"818299", "Hiroshima\,\ Hiroshima",
"819597", "Fukue\,\ Nagasaki",
"818944", "Yawatahama\,\ Ehime",
"812675", "Saku\,\ Nagano",
"811862", "Kazuno\,\ Akita",
"811983", "Hanamaki\,\ Iwate",
"81740", "Imazu\,\ Shiga",
"812859", "Oyama\,\ Tochigi",
"811752", "Mutsu\,\ Aomori",
"819552", "Imari\,\ Saga",
"818559", "Kawamoto\,\ Shimane",
"81924", "Fukuoka\,\ Fukuoka",
"811868", "Takanosu\,\ Akita",
"818240", "Higashi\-ku\,\ Hiroshima",
"81484", "Kawaguchi\,\ Saitama",
"819735", "Hita\,\ Oita",
"811535", "Akkeshi\,\ Hokkaido",
"818493", "Onomichi\,\ Hiroshima",
"81281", "Utsunomiya\,\ Tochigi",
"818384", "Hagi\,\ Yamaguchi",
"818544", "Kisuki\,\ Shimane",
"812837", "Sano\,\ Tochigi",
"812783", "Numata\,\ Gunma",
"81585", "Ibigawa\,\ Gifu",
"819558", "Karatsu\,\ Saga",
"814704", "Tateyama\,\ Chiba",
"817733", "Fukuchiyama\,\ Kyoto",
"819783", "Bungotakada\,\ Oita",
"81270", "Isesaki\,\ Gunma",
"811583", "Monbetsu\,\ Hokkaido",
"814755", "Togane\,\ Chiba",
"812997", "Itako\,\ Ibaraki",
"815994", "Ago\,\ Mie",
"819952", "Okuchi\,\ Kagoshima",
"812239", "Sendai\,\ Miyagi",
"81937", "Kitakyushu\,\ Fukuoka",
"815745", "Minokamo\,\ Gifu",
"812853", "Oyama\,\ Tochigi",
"81578", "Kamioka\,\ Akita",
"8153973", "Hamamatsu\,\ Shizuoka",
"818553", "Hamada\,\ Shimane",
"819546", "Kashima\,\ Saga",
"8198290", "Nobeoka\,\ Miyazaki",
"8147950", "Yokaichiba\,\ Chiba",
"812697", "Iiyama\,\ Nagano",
"811563", "Honbetsu\,\ Hokkaido",
"819575", "Isahaya\,\ Nagasaki",
"812575", "Tokamachi\,\ Niigata",
"812546", "Murakami\,\ Niigata",
"812386", "Nagai\,\ Yamagata",
"818364", "Ube\,\ Yamaguchi",
"81774", "Uji\,\ Kyoto",
"818293", "Hatsukaichi\,\ Hiroshima",
"8199345", "Kagoshima\,\ Kagoshima",
"812652", "Iida\,\ Nagano",
"811354", "Yoichi\,\ Hokkaido",
"8186553", "Kurashiki\,\ Okayama",
"811877", "Omagari\,\ Akita",
"817714", "Kameoka\,\ Kyoto",
"812694", "Nakano\,\ Nagano",
"811392", "Kikonai\,\ Hokkaido",
"819826", "Hyuga\,\ Miyazaki",
"811736", "Goshogawara\,\ Aomori",
"812373", "Murayama\,\ Yamagata",
"81849", "Fukuyama\,\ Hiroshima",
"818367", "Ube\,\ Yamaguchi",
"812612", "Omachi\,\ Nagano",
"817705", "Obama\,\ Fukui",
"811357", "Iwanai\,\ Hokkaido",
"81134", "Otaru\,\ Hokkaido",
"8125489", "Tsugawa\,\ Niigata",
"811365", "Kutchan\,\ Hokkaido",
"815763", "Gero\,\ Gifu",
"811874", "Kakunodate\,\ Akita",
"817717", "Sonobe\,\ Kyoto",
"8112396", "Kuriyama\,\ Hokkaido",
"818836", "Mima\,\ Tokushima",
"818547", "Kakeya\,\ Shimane",
"812834", "Utsunomiya\,\ Tochigi",
"815366", "Shitara\,\ Aichi",
"818242", "Higashi\-ku\,\ Hiroshima",
"811545", "Kushiro\,\ Hokkaido",
"81537", "Kakegawa\,\ Shizuoka",
"818378", "Shimonoseki\,\ Yamaguchi",
"818387", "Tamagawa\,\ Yamaguchi",
"815997", "Ago\,\ Mie",
"81985", "Miyazaki\,\ Miyazaki",
"812745", "Fujioka\,\ Gunma",
"8126170", "Omachi\,\ Nagano",
"818696", "Bizen\,\ Okayama",
"81276", "Ota\,\ Gunma",
"812994", "Ishioka\,\ Ibaraki",
"811333", "Tobetsu\,\ Hokkaido",
"815735", "Ena\,\ Gifu",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(000[259]\d{6})$|(?:(?:003768)0?)|0)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;