#  You may distribute under the terms of either the GNU General Public License
#  or the Artistic License (the same terms as Perl itself)
#
#  (C) Paul Evans, 2023 -- leonerd@leonerd.org.uk

use v5.36;
use Object::Pad 0.66;

role App::perl::distrolint::CheckRole::EachFile;

use File::Find ();
use File::Basename qw( basename );

use List::Util 1.29 qw( any );

my @SKIP_TOP = qw(
   blib
   _build
);

method _run_foreach ( $opts, $method, @args )
{
   my $ok = 1;

   File::Find::find({
      no_chdir => 1,
      preprocess => sub {
         return sort { $a cmp $b } @_;
      },
      wanted => sub {
         my $path = $_;

         return if $path eq ".";
         $path =~ s{^\./}{};

         my $basename = basename $path;

         # skip hidden
         $File::Find::prune = 1, return if $basename =~ m{^\..};

         # skip toplevels
         $File::Find::prune = 1, return if any { $_ eq $path } @SKIP_TOP;

         -f $path or return;

         return if $opts->{if_basename} and $basename !~ $opts->{if_basename};

         $ok &= $self->$method( $path, @args );
      },
   }, "." );

   return $ok;
}

method run_for_each_file ( $method, @args )
{
   $self->_run_foreach( {}, $method, @args );
}

my %BASENAMES = (
   perl => qr/\.PL$|\.pl$|\.pm$|\.t$/,
   xs   => qr/\.xs$/,
   c    => qr/\.c$|\.h$/,
);
my $SOURCE_BASENAMES = do {
   my $re = join "|",
      @BASENAMES{qw( perl xs c )},
      qr/^typemap$/;
   qr/$re/;
};

method run_for_each_perl_file ( $method, @args )
{
   # TODO: Also check executables in bin/ that start with a perl shebang
   $self->_run_foreach( { if_basename => $BASENAMES{perl} }, $method, @args );
}

method run_for_each_test_file ( $method, @args )
{
   $self->_run_foreach( { if_basename => qr/\.t$/ }, $method, @args );
}

method run_for_each_source_file ( $method, @args )
{
   $self->_run_foreach( { if_basename => $SOURCE_BASENAMES }, $method, @args );
}

0x55AA;
