#!/usr/bin/perl

package eBay::API::XML::Call::RelistItem;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. RelistItem.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::RelistItem

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::RelistItem inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::RelistItem::RelistItemRequestType;
use eBay::API::XML::Call::RelistItem::RelistItemResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'RelistItem';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::RelistItem::RelistItemRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::RelistItem::RelistItemResponseType';
}

#
# input properties
#

=head2 setDeletedField()

Specifies the name of the field to delete from a listing.
See the eBay Web Services guide for rules on deleting values when relisting items.
Also see the relevant field descriptions to determine when to use DeletedField (and potential consequences).
The request can contain zero, one, or many instances of DeletedField (one for each field to be deleted).
DeletedField accepts the following path names, which delete the corresponding nodes:<br><br>
Item.ApplicationData<br>
Item.AttributeSetArray<br>
Item.BuyItNowPrice<br>
Item.Charity<br>
Item.ItemSpecifics<br>
Item.ListingCheckoutRedirectPreference.ProStoresStoreName<br>
Item.ListingCheckoutRedirectPreference.SellerThirdPartyUsername<br>
Item.ListingDesigner.LayoutID<br>
Item.ListingDesigner.ThemeID<br>
Item.ListingDetails.LocalListingDistance<br>
Item.ListingDetails.MinimumBestOfferMessage<br>
Item.ListingDetails.MinimumBestOfferPrice<br>
Item.ListingEnhancement[Value]<br>
Item.PayPalEmailAddress<br>
Item.PictureDetails.GalleryURL<br>
Item.PictureDetails.PictureURL<br>
Item.PostalCode<br>
Item.ProductListingDetails<br>
Item.SecondaryCategory<br>
Item.SellerContactDetails<br>
Item.SellerContactDetails.CompanyName<br>
Item.SellerContactDetails.County<br>
Item.SellerContactDetails.InternationalStreet<br>
Item.SellerContactDetails.Phone2AreaOrCityCode<br>
Item.SellerContactDetails.Phone2CountryCode<br>
Item.SellerContactDetails.Phone2CountryPrefix<br>
Item.SellerContactDetails.Phone2LocalNumber<br>
Item.SellerContactDetails.PhoneAreaOrCityCode<br>
Item.SellerContactDetails.PhoneCountryCode<br>
Item.SellerContactDetails.PhoneCountryPrefix<br>
Item.SellerContactDetails.PhoneLocalNumber<br>
Item.SellerContactDetails.Street<br>
Item.SellerContactDetails.Street2<br>
Item.ShippingDetails.PaymentInstructions<br>
Item.SKU<br>
Item.SubTitle<br>
These values are case-sensitive. Use values that match the case of the schema element names
(Item.PictureDetails.GalleryURL) or make the initial letter of each field name lowercase (item.pictureDetails.galleryURL).
However, do not change the case of letters in the middle of a field name.
For example, item.picturedetails.galleryUrl is not allowed.<br><br>
To delete a listing enhancement like Featured, specify the value you are deleting;
for example, Item.ListingEnhancement[Featured].

  RequiredInput: Conditionally
#    Argument: reference to an array  
                      of 'xs:string'

=cut
       
sub setDeletedField {
   my $self   = shift;
   my $sDeletedField = shift;
   $self->getRequestDataType()->setDeletedField($sDeletedField);
}

=head2 setItem()

Child elements hold the values for item properties that change for the
item re-list. Item is a required input. At a minimum, the Item.ItemID
property must be set to the ID of the listing being re-listed (a
listing that ended in the past 90 days). By default, the new listing's
Item object properties are the same as those of the original (ended)
listing. By setting a new value in the Item object, the new listing
uses the new value rather than the corresponding value from the old
listing.

  RequiredInput: Yes
#    Argument: 'ns:ItemType'

=cut
       
sub setItem {
   my $self   = shift;
   my $pItem = shift;
   $self->getRequestDataType()->setItem($pItem);
}



#
# output properties
#

=head2 getCategory2ID()

ID of the secondary category in which the item was listed.
Only returned if you set Item.CategoryMappingAllowed to true in the request
and the ID passed in Item.SecondaryCategory was mapped to a new ID by eBay.
If the secondary category has not changed or it has expired with no replacement,
Category2ID does not return a value.

  Returned: Conditionally
#    Returns: 'xs:string'

=cut
       
sub getCategory2ID {
   my $self = shift;
   return $self->getResponseDataType()->getCategory2ID();
}

=head2 getCategoryID()

ID of the primary category in which the item was listed.
Only returned if you set Item.CategoryMappingAllowed to true in the request
and the ID passed in Item.PrimaryCategory was mapped to a new ID by eBay.
If the primary category has not changed or it has expired with no replacement,
CategoryID does not return a value.

  Returned: Conditionally
#    Returns: 'xs:string'

=cut
       
sub getCategoryID {
   my $self = shift;
   return $self->getResponseDataType()->getCategoryID();
}

=head2 getEndTime()

Date and time when the new listing ends. This is the starting time plus
the listing duration.

  Returned: Always
#    Returns: 'xs:dateTime'

=cut
       
sub getEndTime {
   my $self = shift;
   return $self->getResponseDataType()->getEndTime();
}

=head2 getFees()

Child elements contain the estimated listing fees for the new item
listing. The fees do not include the Final Value Fee (FVF), which cannot
be determined until an item is sold.

  Returned: Always
#    Returns: 'ns:FeesType'

=cut
       
sub getFees {
   my $self = shift;
   return $self->getResponseDataType()->getFees();
}

=head2 getItemID()

Unique item ID for the new listing.

  Returned: Always
#    Returns: 'ns:ItemIDType'

=cut
       
sub getItemID {
   my $self = shift;
   return $self->getResponseDataType()->getItemID();
}

=head2 getStartTime()

Date and time the new listing became active on the eBay site.

  Returned: Always
#    Returns: 'xs:dateTime'

=cut
       
sub getStartTime {
   my $self = shift;
   return $self->getResponseDataType()->getStartTime();
}





1;   
